//debug navigation
// object of current level: currentLevel

//Game flow Paused/Unpaused
var paused = false;
var allowedPausing = false;

//these are updated from a Runtime.js VRUN_Hijack
var objUpdateApplication; 
var objUpdateApplication; 
var objDelta;

function PauseButton(){
	
	/*
	if(paused)
	{
		Unpause();
	}
	else
	{
		Pause();
	}
	*/
	
}

function Unpause(){
	paused = false;
	window.setTimeout(objUpdateApplication, objDelta);
}

function Pause(){
	if(!allowedPausing)
		return;
	
	paused = true;
}
//---------------------------


var gameValues = new Object();

gameValues["Multiverse"] = 0;

gameValues["BossMode"] = false;
gameValues["BossLevel"] = 1;

gameValues["Life"] = 3;
gameValues["Exp"] = 0;
gameValues["Currency"] = 0;

gameValues["Intensity"] = 1;
gameValues["Range"] = 1;
gameValues["Burst"] = 1;
gameValues["Speed"] = 1;
gameValues["Luck"] = 0;
gameValues["Trail"] = 1;
gameValues["Field"] = 1;
gameValues["Hover"] = 1;
gameValues["BlastType"] = 0;
gameValues["ItemType"] = 0;

gameValues["ShopItem1Name"] = "";
gameValues["ShopItem2Name"] = "";
gameValues["ShopItem3Name"] = "";
gameValues["ShopItem1Value"] = 0;
gameValues["ShopItem2Value"] = 0;
gameValues["ShopItem3Value"] = 0;

gameValues["SoundVolume"] = 80;
gameValues["MusicVolume"] = 100;
gameValues["VoiceVolume"] = 80;

var Items = [
"HEALTH++", 
"BURST++",
"SPEED++",
"RANGE++",
"INTENSITY++",
"LUCK++",
"TRAIL++",
"FIELD++",
"HOVER++"
];

var visitedAreas = new Object();
var currentArea = null;
var areaTitleDisplay = -50;


var canvasMapPosX = 335.5;
var canvasMapPosY = 161.5;

var lastPositionX = -1;
var lastPositionY = -1;
var lastDirection = "Start";

var mapVisible = false;


window.onload = function () { 
 //Check the support for the File API support 

    var filexSelected = document.getElementById('txtfiletoread');
    filexSelected.addEventListener('change', function (e) { 
	
	
         //Get the file object 
         var filexTobeRead = filexSelected.files[0];
        //Check of the extension match 
             //Initialize the FileReader object to read the 2file 
			 
			 
             var filexReader = new FileReader(); 
             filexReader.onload = function (e) { 
				var mapstring = filexReader.result;
                LoadMap(mapstring);
             } 
			 
             filexReader.readAsText(filexTobeRead); 

 
 
    }, false);

 }
 
 Number.prototype.padLeft = function (n,str){
    return Array(n-String(this).length+1).join(str||'0')+this;
}

var startdate = new Date();
function gamestart()
{
	 startdate = new Date();
}

function gamecomplete()
{
	var newdate = new Date();
	var difference = (newdate - startdate);
	
	var finalMS = difference % 1000;
	var remainingSec = (difference - finalMS) / 1000;
	var finalSec = remainingSec % 60;
	var remainingMin = (remainingSec - finalSec) / 60;
	var finalMin = remainingMin % 60;
	var finalHour = (remainingMin - finalMin) / 60;

	return "Your time: " + finalHour.padLeft(2,'0') + ":" + finalMin.padLeft(2,'0') + ":" + finalSec.padLeft(2,'0') + ":" + finalMS.padLeft(3,'0');
}

function drawUpdateHook(ctx)
{
	/* HIJACK SET IN Runtime.js around code shown under
	
		else
	{
		var delta = (new Date()).getTime() - this.timer;
		delta = Math.max(1000 / this.gaFrameRate - delta, 1);
		window.setTimeout(updateApplication, delta);
		
		//VRUN_HIJACK
		drawUpdateHook(context);
	}
	
	>>> search for stepApplication:    function ()
	
	*/
	
	

	drawScreenEffectHurt(ctx);
	drawScreenEffectGlitch(ctx);
	
	drawMapOverlay(ctx);

	drawAreaName(ctx);
}


var screenEffectHurtLifespan = 0;
var screenEffectGlitchLifespan = 0;
var screenEffectHurtDuration = 0;


function callScreenEffectHurt() {

	if(gameValues["backVid"] == 0)
	{
		return;
	}
	else if(gameValues["backVid"] == 1)
	{
		screenEffectHurtDuration = 2;
		screenEffectHurtLifespan = screenEffectHurtDuration;
		
		screenEffectGlitchLifespan = 2;
		
	}
	else
	{
		screenEffectHurtDuration = 9;
		screenEffectHurtLifespan = screenEffectHurtDuration;
		screenEffectGlitchLifespan = 70;
	}
	
}

function callScreenEffectGlitch() {
	
	if(gameValues["backVid"] == 0)
	{
		return;
	}
	else if(gameValues["backVid"] == 1)
	{
		screenEffectGlitchLifespan = 30;
	}
	else
	{
		screenEffectGlitchLifespan = 70;
	}
	
}

function callScreenEffectBossHurt() {
	screenEffectHurtDuration = 3;
    screenEffectHurtLifespan = screenEffectHurtDuration;
	screenEffectGlitchLifespan = 15;
}

function drawScreenEffectGlitch(ctx) {
	if(screenEffectGlitchLifespan!= 0)
	{
		var intensity = screenEffectGlitchLifespan / 2;
		
		for(var i=0;i<intensity;i++)
		{
			var y = getRandomInt(1,223);
			
			var stretchRND = getRandomInt(1,100);
			
			var stretch = 1;
			if(stretchRND > 80 && stretchRND < 98)
				stretch = 2;
			if(stretchRND >= 98)
				stretch = 3
		
			var imgData=ctx.getImageData(0,y,256-stretch,stretch);
			ctx.putImageData(imgData, stretch, y);
		}
		
		screenEffectGlitchLifespan--;
	}
	
}

function drawScreenEffectHurt(ctx){
	if(screenEffectHurtLifespan!= 0)
	{
		var xSize = getRandomInt(3,25);
		var ySize = getRandomInt(3,25);
		
		var nbXfitScreen = 400/xSize + 1;
		var nbYfitScreen = 224/ySize + 1;
		
		var effectAlpha = screenEffectHurtLifespan/screenEffectHurtDuration;
		
		if (effectAlpha > 1)
			effectAlpha = 1;
		
		for(x=0;x<nbXfitScreen;x++)
			for(y=0;y<nbYfitScreen;y++)
			{
				var xPos = x*xSize;
				var yPos = y*ySize;
				
				//var computedAlpha = ((getRandomFloat(1, 9)/10)*effectAlpha).toFixed(2).toString();
				var computedAlpha = 1;
				
				var p = ctx.getImageData(xPos, yPos, 1, 1).data; 
				var rColor = p[0];
				var gColor = p[1];
				var bColor = p[2];
				
				ctx.fillStyle = "rgba("+rColor+", "+gColor+", "+bColor+", " + computedAlpha + " )";
				//ctx.fillStyle = "rgba(255, 0, 0, " + computedAlpha + " )";
				
				ctx.fillRect(xPos,yPos,xSize,ySize);
			}
			
		//ctx.fillStyle = "rgba(255, 255, 255, 1 )";
		//ctx.fillRect(getRandomFloat(1, 256),getRandomFloat(1, 224),1,1);
		screenEffectHurtLifespan--;
	}
}

function GetPixel(x, y){
    var p = ctx.getImageData(x, y, 1, 1).data; 
    var hex = "#" + ("000000" + rgbToHex(p[0], p[1], p[2])).slice(-6);  
    return hex;
}

function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}


function drawMapOverlay(ctx)
{
	if(mapVisible)
	{
		generateMapOverlay(ctx);
		
		//if(screenEffectGlitchLifespan < 40)
		//	screenEffectGlitchLifespan = 40;
	}

	
}

function drawAreaName(ctx)
{
	if(currentArea != null)
	{
		ctx.globalAlpha = 1;
		
		
		var opacity = 100;
		
		if(areaTitleDisplay > 0)
		{
			opacity = (100 - areaTitleDisplay)
			screenEffectGlitchLifespan = opacity;
		}
		
		if(opacity > 100)
			opacity = 100;
		
		var alpha = (opacity / 100);
		
		var textAlpha  = (opacity / 100);
		if(areaTitleDisplay < -25)
		{
			textAlpha = 1 - (((areaTitleDisplay + 25) * -1) / 25);
		}
		
		ctx.beginPath();
		ctx.rect(0, 0, 398, 224);
		ctx.fillStyle  = "rgba(0, 0, 0, " + (alpha) + ")";
		ctx.fill();

		ctx.font = "22px Tahoma";
		ctx.fillStyle  = "rgba(255, 255, 255, " + textAlpha + ")";
		
		
		ctx.textAlign = "center";
		ctx.textBaseline = "top";
		ctx.fillText( currentArea , 128+71, 96);

		areaTitleDisplay++;
		
		if(areaTitleDisplay > 100)
			currentArea = null;
	}

	
}

function displayText(sometext)
{
	currentArea = sometext;
	areaTitleDisplay = -50;
}

function generateMapOverlay(ctx)
{
	/*
	//darkening the screen
	ctx.fillStyle = "rgba(0, 0, 0, 0.75 )";
	ctx.fillRect(0,0,398,224);
	ctx.stroke();
	*/
	
	//realmap.width = 398;
	//realmap.height = 224;
	
	ctx.globalAlpha = 1;
	
	currentRoom = currentLevel["Name"];
	var arr = currentRoom.split(",");
	
	currentRoomX = parseInt(arr[0]);
	currentRoomY = parseInt(arr[1]);

	var gridWidth = 8;
	var gridHeight = 7;
	var gridResolution = 8;
	
	TopLeftMapX = currentRoomX - 3;
	TopLeftMapY = currentRoomY - 3;
	
	for(mapy = TopLeftMapY; mapy < TopLeftMapY + 7; mapy++)
	{
		for(mapx = TopLeftMapX; mapx < TopLeftMapX + 7; mapx++)
		{
			var targetRoom = mapx.toString() + "," + mapy.toString();
			
			if(levels[targetRoom] != undefined)
			{
				if(levels[targetRoom]["visited"] !== undefined || levels[targetRoom]["revealed"] !== undefined || levels[targetRoom]["Corrupted"] !== undefined)
				{
					ctx.beginPath();

					ctx.lineWidth = "1";
					
					if(levels[targetRoom]["revealed"] !== undefined)
						ctx.strokeStyle = "rgba(64, 64, 64, 1)";//"#404040";
					else if(levels[targetRoom]["Corrupted"] !== undefined)
						ctx.strokeStyle = "rgba(191, 123, 199, 1)";//"#bf7bc7";
					else 
						ctx.strokeStyle = "rgba(128, 128, 128, 1)";//"#808080";
					
					//Draws visited box
					ctx.rect(canvasMapPosX + (mapx-TopLeftMapX)*gridResolution+3,canvasMapPosY + (mapy-TopLeftMapY)*gridResolution +3,2,2);
					ctx.stroke();
					
					//draws X
					if(levels[targetRoom]["Corrupted"] !== undefined)
					{
						
						ctx.beginPath();
						ctx.lineWidth = "1";
						ctx.strokeStyle = "rgba(191, 123, 199, 1)";//"#bf7bc7";
						ctx.moveTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution), canvasMapPosY + (mapy-TopLeftMapY)*gridResolution);
						ctx.lineTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 8, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) + 8);
						ctx.stroke();
						
						ctx.beginPath();
						ctx.lineWidth = "1";
						ctx.strokeStyle = "rgba(191, 123, 199, 1)";//"#bf7bc7";
						ctx.moveTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 8, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) );
						ctx.lineTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution), canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) + 8 );
						ctx.stroke();
						
					}
					
					//Draws paths
					if(levels[targetRoom]["visited"] !== undefined)
					{
						if(levels[targetRoom]["Left"] != "")
						{
							ctx.beginPath();
							ctx.lineWidth = "1";
							
							var lineColor = "rgba(255, 255, 255, 1)";//"white";
							if( levels[levels[targetRoom]["Left"]]["Type"] !=  levels[targetRoom]["Type"])
							{
								lineColor = "rgba(255, 0, 0, 1)";//"red";
							}
							ctx.strokeStyle = lineColor;
							
							ctx.moveTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 4, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) + 4);
							ctx.lineTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) -4, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) + 4);
							ctx.stroke();
						}
						
						if(levels[targetRoom]["Right"] != "")
						{
							ctx.beginPath();
							ctx.lineWidth = "1";
							
							var lineColor = "rgba(255, 255, 255, 1)";//"white";
							if( levels[levels[targetRoom]["Right"]]["Type"] !=  levels[targetRoom]["Type"])
							{
								lineColor = "rgba(255, 0, 0, 1)";//"red";
							}
							ctx.strokeStyle = lineColor;
							
							ctx.moveTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 4, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) + 4);
							ctx.lineTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 12, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) + 4);
							ctx.stroke();
						}
						
						if(levels[targetRoom]["Up"] != "")
						{
							ctx.beginPath();
							ctx.lineWidth = "1";
							
							var lineColor = "rgba(255, 255, 255, 1)";//"white";
							if( levels[levels[targetRoom]["Up"]]["Type"] !=  levels[targetRoom]["Type"])
							{
								lineColor = "rgba(255, 0, 0, 1)";//"red";
							}
							ctx.strokeStyle = lineColor;
							
							ctx.moveTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 4, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) + 4);
							ctx.lineTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 4, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution) -4);
							ctx.stroke();
						}
						
						if(levels[targetRoom]["Down"] != "")
						{
							ctx.beginPath();
							ctx.lineWidth = "1";
							
							var lineColor = "rgba(255, 255, 255, 1)";//"white";
							if( levels[levels[targetRoom]["Down"]]["Type"] !=  levels[targetRoom]["Type"])
							{
								lineColor = "rgba(255, 0, 0, 1)";//"red";
							}
							ctx.strokeStyle = lineColor;
							
							ctx.moveTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 4, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution)+4);
							ctx.lineTo(canvasMapPosX + ((mapx-TopLeftMapX)*gridResolution) + 4, canvasMapPosY + ((mapy-TopLeftMapY)*gridResolution)+12);
							ctx.stroke();
						}
					}
				
				}
			}
			
		}
	}
	
	
	//Draws Orange box
	ctx.beginPath();
	
	ctx.lineWidth = "1";
	ctx.strokeStyle = "rgba(255, 165, 0, 1)";//"orange";
	
	ctx.rect(canvasMapPosX + (3*gridResolution) + (gridResolution/4), canvasMapPosY + (3*gridResolution) + (gridResolution/4),gridResolution - (gridResolution/2),gridResolution - (gridResolution/2));
	ctx.stroke();
	
	/*
	ctx.beginPath();
	
	ctx.lineWidth = "1";
	ctx.strokeStyle = "orange";
	
	ctx.rect((8*16)+2,(7*16)+2,16-4,16-4);
	ctx.stroke();
	*/
}



function getRandomFloat(min, max) {
    return Math.random() * (max - min) + min;
}

function getRandomInt(min, max){
	return Math.floor(getRandomFloat(min, max)) ;
}

function deleted()
{
	mapVisible = false;
	
	music_stopSong();
	
	lastPositionX = -1;
	lastPositionY = -1;
	lastDirection = "Start";
	
	currentLevel = levels["x"];
	gameValues["Life"] = 3;
	gameValues["Exp"] = 0;
	gameValues["Currency"] = 0;
	
	gameValues["Intensity"] = 1;
	gameValues["Range"] = 1;
	gameValues["Burst"] = 1;
	gameValues["Speed"] = 1;
	
	gameValues["Luck"] = 0;
	
	gameValues["Trail"] = 1;
	gameValues["Field"] = 1;
	gameValues["BlastType"] = 1;

}

function killgame()
{
	location.reload();
}


function GenerateShop()
{
	mapVisible = false;
	
	var copy_Items = Items.slice(0);
	
	var item1_pos = Math.floor(Math.random()*copy_Items.length);
	var item1 = copy_Items[item1_pos];
	while(ScaleItemPrice(item1) == 0){
		item1_pos = Math.floor(Math.random()*copy_Items.length);
		item1 = copy_Items[item1_pos];
	}
	copy_Items.splice(item1_pos,1);
	
	var item2_pos = Math.floor(Math.random()*copy_Items.length);
	var item2 = copy_Items[item2_pos];
	while(ScaleItemPrice(item2) == 0){
		item2_pos = Math.floor(Math.random()*copy_Items.length);
		item2 = copy_Items[item2_pos];
	}
	copy_Items.splice(item2_pos,1);
	
	var item3_pos = Math.floor(Math.random()*copy_Items.length);
	while(ScaleItemPrice(item3) == 0){
		item3_pos = Math.floor(Math.random()*copy_Items.length);
		item3 = copy_Items[item3_pos];
	}
	var item3 = copy_Items[item3_pos];
	
	gameValues["ShopItem1"] = item1;
	gameValues["ShopItem2"] = item2;
	gameValues["ShopItem3"] = item3;
	
	gameValues["ShopItem1Value"] = ScaleItemPrice(item1);
	gameValues["ShopItem2Value"] = ScaleItemPrice(item2);
	gameValues["ShopItem3Value"] = ScaleItemPrice(item3);
	
	gameValues["ShopItem1Name"] = pad(9, "(" + gameValues["ShopItem1Value"] + ") -> ", ' ') + gameValues["ShopItem1"];
	gameValues["ShopItem2Name"] = pad(9, "(" + gameValues["ShopItem2Value"] + ") -> ", ' ') + gameValues["ShopItem2"];
	gameValues["ShopItem3Name"] = pad(9, "(" + gameValues["ShopItem3Value"] + ") -> ", ' ') + gameValues["ShopItem3"];
}

function ScaleItemPrice(item)
{
	
	if(item == "SPEED++")
	{
		if(gameValues["Speed"] == 1)
		{
			return 75;
		}
		else if(gameValues["Speed"] == 2)
		{
			return 175;
		}
	}
	else if(item == "BURST++")
	{
		if(gameValues["Burst"] == 1)
		{
			return 20;
		}
		else if(gameValues["Burst"] == 2)
		{
			return 50;
		}
		else if(gameValues["Burst"] == 3)
		{
			return 125;
		}
		else if(gameValues["Burst"] == 4)
		{
			return 245;
		}
		else if(gameValues["Burst"] == 5)
		{
			return 435;
		}
		else if(gameValues["Burst"] == 6)
		{
			return 665;
		}
		else if(gameValues["Burst"] == 7)
		{
			return 955;
		}
		else if(gameValues["Burst"] == 8)
		{
			return 1685;
		}
		else if(gameValues["Burst"] == 9)
		{
			return 3075;
		}
		else if(gameValues["Burst"] == 10)
		{
			return 6150;
		}

	}
	else if(item == "RANGE++")
	{
		if(gameValues["Range"] == 1)
		{
			return 175;
		}
		else if(gameValues["Range"] == 2)
		{
			return 350;
		}
	}
	else if(item == "LUCK++")
	{
		if(gameValues["Luck"] == 0)
		{
			return 125;
		}
		else if(gameValues["Luck"] == 1)
		{
			return 250;
		}
		else if(gameValues["Luck"] == 2)
		{
			return 500;
		}
		else if(gameValues["Luck"] == 3)
		{
			return 1000;
		}
		else if(gameValues["Luck"] == 4)
		{
			return 2000;
		}
		else if(gameValues["Luck"] == 5)
		{
			return 4000;
		}
		else if(gameValues["Luck"] == 6)
		{
			return 8000;
		}
		else if(gameValues["Luck"] == 7)
		{
			return 16000;
		}
		else if(gameValues["Luck"] == 7)
		{
			return 32000;
		}
		else if(gameValues["Luck"] == 8)
		{
			return 64000;
		}
		else if(gameValues["Luck"] == 9)
		{
			return 12800;
		}
		else if(gameValues["Luck"] == 10)
		{
			return 256000;
		}
	}
	
	else if(item == "INTENSITY++")
	{
		if(gameValues["Intensity"] == 1)
		{
			return 32;
		}
		else if(gameValues["Intensity"] == 2)
		{
			return 64;
		}
		else if(gameValues["Intensity"] == 3)
		{
			return 128;
		}
		else if(gameValues["Intensity"] == 4)
		{
			return 256;
		}
		else if(gameValues["Intensity"] == 5)
		{
			return 512;
		}
		else if(gameValues["Intensity"] == 6)
		{
			return 1024;
		}
		else if(gameValues["Intensity"] == 7)
		{
			return 2048;
		}
		else if(gameValues["Intensity"] == 8)
		{
			return 4096;
		}
		else if(gameValues["Intensity"] == 9)
		{
			return 8192;
		}
		else if(gameValues["Intensity"] == 10)
		{
			return 16384;
		}


	}
	else if(item == "HEALTH++")
	{
		return 15;
	}
	
	else if(item == "TRAIL++")
	{
		if(gameValues["Trail"] == 1)
		{
			return 150;
		}
		else if(gameValues["Trail"] == 2)
		{
			return 300;
		}
	}
	
	else if(item == "FIELD++")
	{
		if(gameValues["Field"] == 1)
		{
			return 200;
		}
		else if(gameValues["Field"] == 2)
		{
			return 400;
		}
	}
	
		else if(item == "HOVER++")
	{
		if(gameValues["Hover"] == 1)
		{
			return 160;
		}
		else if(gameValues["Hover"] == 2)
		{
			return 320;
		}
	}
	
	
	return 0;
}


function pad(width, string, padding) { 
  return (width <= string.length) ? string : pad(width, padding + string, padding)
}

function LeaveShopItem1()
{
	ApplyItem(gameValues["ShopItem1"]);
	gameValues["Currency"] -= gameValues["ShopItem1Value"];
}

function LeaveShopItem2()
{
	gameValues["Currency"] -= gameValues["ShopItem2Value"];
	ApplyItem(gameValues["ShopItem2"]);
}

function LeaveShopItem3()
{
	gameValues["Currency"] -= gameValues["ShopItem3Value"];
	ApplyItem(gameValues["ShopItem3"]);
	
}

function ApplyItem(item)
{
	if(item == "SPEED++")
	{
		gameValues["Speed"]++;
	}
	else if(item == "BURST++")
	{
		gameValues["Burst"]++;
	}
	else if(item == "RANGE++")
	{
		gameValues["Range"]++;
	}
	else if(item == "INTENSITY++")
	{
		gameValues["Intensity"]++;
	}
	else if(item == "HEALTH++")
	{
		gameValues["Life"]++;
	}
	else if(item == "LUCK++")
	{
		gameValues["Luck"]++;
	}
	else if(item == "TRAIL++")
	{
		gameValues["Trail"]++;
	}
	else if(item == "FIELD++")
	{
		gameValues["Field"]++;
	}
	else if(item == "HOVER++")
	{
		gameValues["Hover"]++;
	}
	
	speakit(item);
}



var levels = new Object();
var currentLevel;
var bossLevel = new Object(); // or just {}
bossLevel["Name"]    = "9999,9999";
bossLevel["Type"]    = "19";
bossLevel["Up"]      = "";
bossLevel["Left"]    = "";
bossLevel["Right"]   = "";
bossLevel["Down"]    = "";
bossLevel["Comment"] = "BOSS";

/**
 * Returns a random integer between min (inclusive) and max (inclusive)
 * Using Math.round() will give you a non-uniform distribution!
 */
function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}


var LoadedAreas = new Object();
function LoadMap(mapcode)
{

	var LevelName  = "";
	var LevelType  = "";
	var LevelUp    = "";
	var LevelLeft  = "";
	var LevelRight = "";
	var LevelDown  = "";
	var Comment    = "";
	var MapLine0   = "";
	var MapLine1   = "";
	var MapLine2   = "";
	var MapLine3   = "";
	var MapLine4   = "";
	var MapLine5   = "";
	var MapLine6   = "";
	var MapLine7   = "";
	var MapLine8   = "";
	var MapLine9   = "";
	var MapLine10  = "";
	var MapLine11  = "";
	var MapLine12  = "";
	var MapLine13  = "";
	
	var FirstMap = true;
	
	var textArea;
	var lines;
	
	textArea = document.getElementById("LoadMapTextArea");
	
	if(mapcode != "text")
	{
		textArea.innerText = mapcode;
	}

		lines = textArea.value.split('\n');

	
	for(var i = 0;i < lines.length;i++){
    //code here using lines[i] which will give you each line
		switch(i % 21) {
		case 0:
			LevelName = lines[i].trim();
			break;
		case 1:
			LevelType = lines[i].trim();
			break;
		case 2:
			LevelUp = lines[i].trim();
			break;
		case 3:
			LevelLeft = lines[i].trim();
			break;
		case 4:
			LevelRight = lines[i].trim();
			break;
		case 5:
			LevelDown = lines[i].trim();
			break;
		case 6:
			Comment = lines[i].trim();
			break;
		case 7:
			MapLine0 = lines[i].trim();
			break;
		case 8:
			MapLine1 = lines[i].trim();
			break;
		case 9:
			MapLine2 = lines[i].trim();
			break;
		case 10:
			MapLine3 = lines[i].trim();
			break;
		case 11:
			MapLine4 = lines[i].trim();
			break;
		case 12:
			MapLine5 = lines[i].trim();
			break;
		case 13:
			MapLine6 = lines[i].trim();
			break;
		case 14:
			MapLine7 = lines[i].trim();
			break;
		case 15:
			MapLine8 = lines[i].trim();
			break;
		case 16:
			MapLine9 = lines[i].trim();
			break;
		case 17:
			MapLine10 = lines[i].trim();
			break;
		case 18:
			MapLine11 = lines[i].trim();
			break;
		case 19:
			MapLine12 = lines[i].trim();
			break;
		case 20:
			MapLine13 = lines[i].trim();
			
			

			if(LevelName != "")
			{
			
				levels[LevelName] = new Object(); // or just {}
				for (j = 0; j < 14; j++) 
				{ 
					levels[LevelName]["status_" + j] = new Object();
				}
				levels[LevelName]["Name"]    = LevelName;
				levels[LevelName]["Type"]    = LevelType;
				levels[LevelName]["Up"]      = LevelUp;
				levels[LevelName]["Left"]    = LevelLeft;
				levels[LevelName]["Right"]   = LevelRight;
				levels[LevelName]["Down"]    = LevelDown;
				levels[LevelName]["Comment"] = Comment;
				levels[LevelName][0]         = readLineToArray (MapLine0);
				levels[LevelName][1]         = readLineToArray (MapLine1);
				levels[LevelName][2]         = readLineToArray (MapLine2);
				levels[LevelName][3]         = readLineToArray (MapLine3);
				levels[LevelName][4]         = readLineToArray (MapLine4);
				levels[LevelName][5]         = readLineToArray (MapLine5);
				levels[LevelName][6]         = readLineToArray (MapLine6);
				levels[LevelName][7]         = readLineToArray (MapLine7);
				levels[LevelName][8]         = readLineToArray (MapLine8);
				levels[LevelName][9]         = readLineToArray (MapLine9);
				levels[LevelName][10]        = readLineToArray (MapLine10);
				levels[LevelName][11]        = readLineToArray (MapLine11);
				levels[LevelName][12]        = readLineToArray (MapLine12);
				levels[LevelName][13]        = readLineToArray (MapLine13);
				
				for(mapx=0;mapx<16;mapx++)
						for(mapy=0;mapy<14;mapy++)
							if(levels[LevelName][mapy][mapx] == 3 || levels[LevelName][mapy][mapx] == 17)
							{
								/*
								25 BlastType Wall
								26 BlastType Chunk
								27 BlastType Cross
								28 BlastType Wave
								29 ItemType Corner
								30 ItemType Field
								31 ItemType Heal
								32 ItemType Upgrade
								33 ItemType Laser
								*/
								
								
								
								
								var D2 = getRandomInt(1,2);
								if(D2 == 1) // 1/2 chances
								{
									
									
									var D9 = getRandomInt(1,9); //
									
									levels[LevelName][mapy][mapx] = 24 + D9;
								}
							}
				
				
				//Will execute for the first room only
				if(FirstMap)
				{
					currentLevel = levels[LevelName];
					FirstMap = false;
				}
				
				//Remove enemies in first rooms of levels
				if(gameValues["Debug"] != 666)
				{
					if(LoadedAreas[levels[LevelName]["Type"]] != true)
					{
						
						for(mapx=0;mapx<16;mapx++)
							for(mapy=0;mapy<14;mapy++)
								if(
									levels[LevelName][mapy][mapx] == 10 || 
									levels[LevelName][mapy][mapx] == 11 ||
									levels[LevelName][mapy][mapx] == 12 ||
									levels[LevelName][mapy][mapx] == 13 ||
									levels[LevelName][mapy][mapx] == 14 ||
									levels[LevelName][mapy][mapx] == 21 ||
									levels[LevelName][mapy][mapx] == 22 ||
									false)
									levels[LevelName][mapy][mapx] = 0;
						
						LoadedAreas[levels[LevelName]["Type"]] = true;
					}
				}
				
			}
			
			break;
		}
	}
	
	document.getElementById("debugload").style.display = "none";
	//document.getElementById("debugnotes").style.display = "";
}

function getLevelTypeId()
{
	if(gameValues["BossMode"] == true)
		return 19;
	else
		return parseInt(currentLevel["Type"]);
}

function getPlayerPositionX()
{
	if(lastDirection == "Up")
		return lastPositionX;
	else if(lastDirection == "Left")
		return (256 - 32);
	else if(lastDirection == "Right")
		return 16;
	else if(lastDirection == "Down")
		return lastPositionX;
	
}
function getPlayerPositionY()
{
	if(lastDirection == "Up")
		return (224-32);
	else if(lastDirection == "Left")
		return lastPositionY;
	else if(lastDirection == "Right")
		return lastPositionY;
	else if(lastDirection == "Down")
		return 16;

	
}

function isDoorLeadingToShop(wallDirection)
{
	if(levels[currentLevel[wallDirection]]["Comment"] == "SHOP")
		return 1;
	else
		return 0;

	
}

function showpass()
{
	var restorebox = document.getElementById("restorecode");
	restorebox.style.display="block";
}

function hidepass()
{
	var restorebox = document.getElementById("restorecode");
	restorebox.style.display="none";
}

function updateMainValues(life, exp, currency, intensity, range, burst, speed, luck, trail, field, blastType)
{
	gameValues["Life"] = life;
	gameValues["Exp"] = exp;
	gameValues["Currency"] = currency;
	
	gameValues["Intensity"] = intensity;
	gameValues["Range"] = range;
	gameValues["Burst"] = burst;
	gameValues["Speed"] = speed;

	gameValues["Luck"] = luck;
	
	gameValues["Trail"] = trail;
	gameValues["Field"] = field;
	gameValues["BlastType"] = blastType;
}

function leaveArea(direction, position)
{
	allowedPausing = false;
	
	if(gameValues["BossMode"] == true)
	{
		gameValues["BossMode"] = false;
		gameValues["BossLevel"]++;
		visitedAreas[currentLevel["Type"]] = false;
		return 5;  //Room
	}
	
	if(lastDirection == "Start")
	{
		for(x=0; x<16; x++)
		{
			for(y=0; y<14; y++)
			{
				if(currentLevel[y][x] == 15)
				{
					currentLevel[y][x] = 0;
				}
			}
		}
	}
	
	
	lastDirection = direction;
	
	var arr = position.split(",");
	lastPositionX = parseInt(arr[0])-71;
	lastPositionY = parseInt(arr[1]);

	
	//currentLevel = levels[currentLevel[direction]];
	//return 5;
	
	
	if(levels[currentLevel[direction]]["Comment"] == "SHOP")
	{
		GenerateShop();
		
		levels[currentLevel[direction]]["Corrupted"] = 1;
		
		if(lastDirection == "Up")
			lastDirection = "Down";
		else if(lastDirection == "Left")
			lastDirection = "Right";
		else if(lastDirection == "Right")
			lastDirection = "Left";
		else if(lastDirection == "Down")
			lastDirection = "Up";
		
		return 6; // Shop
	}
	else if(levels[currentLevel[direction]]["Type"] == "19")
	{
		return 3; //EndGame
	}
	else
	{
		
		var prevLevel = currentLevel;
		
		currentLevel = levels[currentLevel[direction]];
		
		if(visitedAreas[currentLevel["Type"]] != true)
		{
			prevLevel["Corrupted"] = 1;
			//gameValues["BossMode"] = true; //this starts BossMode
			mapVisible = false;
		}
		

		
		
		
		return 5;  //Room
	}
	

}

function areaCorrupted()
{
	currentLevel["Corrupted"] = 1;
}

function getGameValue(key, x, y)
{
	if(key == "initBlock")
	{
		return initBlock(x, y);
	}
	
	//everything else, return from gameValues array
	return gameValues[key];
	

}


function setGameValue(key, value)
{
	gameValues[key] = value;

}



function levelStart()
{
	allowedPausing = true;
	
	mapVisible = true;
	
	var levelStarting;
	
	if(gameValues["BossMode"] == true)
	{
		levelStarting = bossLevel;
	}
	else
	{
		levelStarting = currentLevel;
	}
	
	
		//alert("called levelStart");
	music_playSong(levelStarting["Type"]);
	video_playVideo(levelStarting["Type"]);
	
	
	var debugNotes = document.getElementById('debugnotes'); 
	debugNotes.innerText = "Debug Notes\n"; 
    debugNotes.innerText += "Room ID: " + levelStarting["Name"] + "\n"; 
	debugNotes.innerText += "Room Type: " + levelStarting["Type"] + "\n";
	debugNotes.innerText += "Wall Up: " + levelStarting["Up"] + "\n";
	debugNotes.innerText += "Wall Left: " + levelStarting["Left"] + "\n";
	debugNotes.innerText += "Wall Right: " + levelStarting["Right"] + "\n";
	debugNotes.innerText += "Wall Down: " + levelStarting["Down"] + "\n";
	debugNotes.innerText += "Comment: " + levelStarting["Comment"] + "\n";
	
	levelStarting["visited"] = true;

	if(visitedAreas[levelStarting["Type"]] != true)
	{
		
		
		
		switch(levelStarting["Type"])
		{
			case "1":
				displayText("L1 : Breach");
				break;
			case "2":
				displayText("L2 : Compactor");
				break;
			case "3":
				displayText("L3 : Compressor");
				break;
			case "4":
				displayText("L4 : Pipeline");
				break;
			case "5":
				displayText("L5 : Analyzer");
				break;
			case "6":
				displayText("L6 : Generator");
				break;
			case "7":
				displayText("L3 : Eraser");
				break;
			case "8":
				displayText("L5 : Renderer");
				break;
			case "9":
				displayText("L2 : Oscilliator");
				break;
			case "10":
				displayText("L4 : Nullifier");
				break;
			case "11":
				displayText("L6 : Clock");
				break;
			case "12":
				displayText("L2 : Port");
				break;
			case "13":
				displayText("L3 : Collector");
				break;
			case "14":
				displayText("L5 : Interpreter");
				break;
			case "15":
				displayText("L4 : Memory");
				break;
			case "16":
				displayText("L6 : Terminal");
				break;
			case "17":
				displayText("L5 : Broker");
				break;
			case "18":
				displayText("L6 : Fracture");
				break;
			case "19":
				displayText("Encounter");
				break;
			case "20":
				displayText("L6 : Cruncher");
				break;
		}

		
		visitedAreas[levelStarting["Type"]] = true;
	}
	
}

function setStatus(ID, value)
{
	//alert(ID + " => " + value);
	var arr = ID.split(",");
	var x = parseInt(arr[0])/16;
	var y = parseInt(arr[1])/16;
	
	currentLevel["status_" + y][x] = value;
}

function readLineToArray(line)
{
	var arr = line.split(",");
	
	var obj = new Object();
	
	for (i = 0; i < arr.length; i++) { 
    obj[i] = parseInt(arr[i]);
	}
	
	return obj;
}

function initBlock(xPos, yPos)
{
	
	var x = xPos/16;
	var y = yPos/16;
	
	if(gameValues["BossMode"] == true)
	{
		if(x == 0 || x == 15 || y == 0 || y == 13)
			return getBlockNameById(1);
		
		if(x == 8 && y == 12)
			return getBlockNameById(15);
		
		else return 0;
	}
	

	var blockStatus = currentLevel["status_" + y][x];
	
	if (blockStatus == -1) //block was deleted
		return getBlockNameById(0);
	else if(blockStatus == 1) //block was corrupted
		return getBlockNameById(6);
	else
	{
		var blockId = currentLevel[y][x];
		
		//Change doors to locked purple if room is corrupted
		
		
		if((blockId == 7 || blockId == 18 || blockId == 19 || blockId == 20) && x == 0 && (levels[currentLevel["Left"]] === undefined || levels[currentLevel["Left"]]["Corrupted"] == 1))
			blockId = 16;
		else if((blockId == 7 || blockId == 18 || blockId == 19|| blockId == 20) && x == 15 && (levels[currentLevel["Right"]] === undefined || levels[currentLevel["Right"]]["Corrupted"] == 1))
			blockId = 16;
		else if((blockId == 7 || blockId == 18 || blockId == 19|| blockId == 20) && y == 0 && (levels[currentLevel["Up"]] === undefined || levels[currentLevel["Up"]]["Corrupted"] == 1))
			blockId = 16;
		else if((blockId == 7 || blockId == 18 || blockId == 19|| blockId == 20) && y == 13 && (levels[currentLevel["Down"]] === undefined || levels[currentLevel["Down"]]["Corrupted"] == 1))
			blockId = 16;		
		
		return getBlockNameById(blockId);
	}

}

function getBlockNameById(ID)
{
	switch(ID) {
    case 0:
        return "EMPTY";
    case 1:
        return "Block";
	case 2:
        return "Breakable Brick L1";
	case 3:
        return "Ressource L1 Square";
	case 4:
        return "Ressource L2 Square";
	case 5:
        return "Ressource L3 Square";
	case 6:
        return "Bad Sector";
	case 7:
        return "Door Unlocked";
	case 8:
        return "Tear";
	case 9:
        return "Super Tear";
	case 10:
        return "Horizontal Mover L1";
	case 11:
        return "Horizontal Mover L2";
	case 12:
        return "Horizontal Mover L3";
	case 13:
        return "Bouncing Block L1";
	case 14:
        return "Ghost Block L1";
	case 15:
        return "PLAYER";
	case 16:
		return "Door Super Tear Locked";
	case 17:
		return "Health Square";
	case 18:
		return "Door Area";
	case 19:
		return "Door Locked";
	case 20:
		return "Door Locked Area";
	case 21:
        return "Bouncing Block L2";
	case 22:
        return "Bouncing Block L3";
	case 23:
        return "Ghost Block L2";
	case 24:
		return "TypeNone";
	case 25:
		return "TypeWall";
	case 26:
		return "TypeChunk";
	case 27:
		return "TypeCross";
	case 28:
		return "TypeWave";
	case 29:
		return "ItemCorner";
	case 30:
		return "ItemField";
	case 31:
		return "ItemHeal";
	case 32:
		return "ItemUpgrade";
	case 33:
		return "ItemLaser";
	case 34:
		return "KeyBlock";
	case 35:
		return "SolidBlock";
	case 36:
		return "PointerBlue";
	case 37:
		return "PointerPink";
	case 38:
		return "Lens";
	case 39:
		return "LensMirrorLeft";
	case 40:
		return "LensMirrorRight";
	case 41:
		return "Lens KeyBlock";
	case 42:
		return "Red Grid";
	case 43:
		return "Red Grid Mover";
	case 44:
		return "Red Spikes Top";
	case 45:
		return "Red Spikes Bottom";
	case 46:
		return "Red Spikes Left";
	case 47:
		return "Red Spikes Right";
	case 48:
		return "Red Spikes TopLeft";
	case 49:
		return "Red Spikes TopRight";
	case 50:
		return "Red Spikes BottomLeft";
	case 51:
		return "Red Spikes BottomRight";
	case 52:
		return "BackdropGrid";
	case 53:
		return "BackdropHorizontal";
	case 54:
		return "BackdropVertical";
	case 55:
		return "BackdropCross";
	case 56:
		return "BackdropTopLeftCorner";
	case 57:
		return "BackdropTopRightCorner";
	case 58:
		return "BackdropBottomLeftCorner";
	case 59:
		return "BackdropBottomRightCorner";

		
    default:
        return "ERROR";
	}
}
