window['Runtime'] = (function Runtime(__can, __path){
	var __scope = this;
	// CService object
	// -----------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 * 
	 * Permission is hereby granted to any person obtaining a legal copy 
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for 
	 * debugging, optimizing, or customizing applications created with 
	 * Clickteam Multimedia Fusion 2. 
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	var CServices = {};

	CServices.extend = function (top, bot)
	{
		var topC = Object.create(top.prototype || top);
		if(bot !== undefined && (bot = bot.prototype || bot))
			for(var prop in bot)
				if(bot.hasOwnProperty(prop))
					topC[prop] = bot[prop];

		return topC;
	};

	CServices.HIWORD = function (ul)
	{
		return ul >> 16;
	}
	CServices.LOWORD = function (ul)
	{
		return ul & 0x0000FFFF;
	}
	CServices.MAKELONG = function (lo, hi)
	{
		return (hi << 16) | (lo & 0xFFFF);
	}
	CServices.getRValueFlash = function (rgb)
	{
		return (rgb >>> 16) & 0xFF;
	}
	CServices.getGValueFlash = function (rgb)
	{
		return (rgb >>> 8) & 0xFF;
	}
	CServices.getBValueFlash = function (rgb)
	{
		return rgb & 0xFF;
	}
	CServices.RGBFlash = function (r, g, b)
	{
		return (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF);
	}
	CServices.swapRGB = function (rgb)
	{
		var r = (rgb >>> 16) & 0xFF;
		var g = (rgb >>> 8) & 0xFF;
		var b = rgb & 0xFF;
		return (b & 0xFF) << 16 | (g & 0xFF) << 8 | (r & 0xFF);
	}
	CServices.clamp = function (val, a, b)
	{
		return Math.min(Math.max(val, a), b);
	}
	CServices.getColorString = function (rgb)
	{
		var r = ((rgb >>> 16) & 0xFF).toString(16);
		var g = ((rgb >>> 8) & 0xFF).toString(16);
		var b = (rgb & 0xFF).toString(16);
		while (r.length < 2)
			r = '0' + r;
		while (g.length < 2)
			g = '0' + g;
		while (b.length < 2)
			b = '0' + b;

		return '#' + r + g + b;
	}
	CServices.floatToInt = function (value)
	{
		if (value < 0)
			return Math.ceil(value);
		else
			return Math.floor(value);
	}
	CServices.approximateInt = function (value)
	{
		return Math.round(value);
	}
	CServices.isInt = function (value)
	{
		return Math.ceil(value) == value;
	}
	CServices.createEllipse = function (ctx, x, y, w, h)
	{
		var kappa = .5522848;
		ox = (w / 2) * kappa, // control point offset horizontal
			oy = (h / 2) * kappa, // control point offset vertical
			xe = x + w,           // x-end
			ye = y + h,           // y-end
			xm = x + w / 2,       // x-middle
			ym = y + h / 2;       // y-middle

		ctx.beginPath();
		ctx.moveTo(x, ym);
		ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
		ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
		ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
		ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
		ctx.closePath();
	}
	CServices.drawRect = function (context, rc)
	{
		context.beginPath();
		context.moveTo(rc.left, rc.top);
		context.lineTo(rc.right, rc.top);
		context.lineTo(rc.right, rc.bottom);
		context.lineTo(rc.left, rc.bottom);
		context.lineTo(rc.left, rc.top);
		context.closePath();
		context.stroke();
	}
	CServices.drawLine = function (context, x1, y1, x2, y2)
	{
		context.beginPath();
		context.moveTo(x1, y1);
		context.lineTo(x2, y2);
		context.closePath();
		context.stroke();
	}
	CServices.formatDiscName = function (number, extension)
	{
		var s = number.toString();
		while (s.length < 4)
			s = '0' + s;
		s += '.' + extension;
		return s;
	}
	CServices.compareStringsIgnoreCase = function (string1, string2)
	{
		if (string1 == string2) return true;
		string1 = string1.toLowerCase();
		string2 = string2.toLowerCase();
		return (string1 == string2);
	}
	CServices.parseName = function (name)
	{
		var pos = name.lastIndexOf("\\");
		if (pos > 0)
		{
			name = name.substring(pos + 1);
		}
		return name;
	}
	CServices.MAX_HEIGHTS = 40;
	CServices.aHeightNormalToLF =
		[
			0, // 0
			1, // 1
			2, // 2
			3, // 3
			5, // 4
			7, // 5
			8, // 6
			9, // 7
			11, // 8
			12, // 9
			13, // 10
			15, // 11
			16, // 12
			17, // 13
			19, // 14
			20, // 15
			21, // 16
			23, // 17
			24, // 18
			25, // 19
			27, // 20
			28, // 21
			29, // 22
			31, // 23
			32, // 24
			33, // 25
			35, // 26
			36, // 27
			37, // 28
			39, // 29
			40, // 30
			41, // 31
			43, // 32
			44, // 33
			45, // 34
			47, // 35
			48, // 36
			49, // 37
			51, // 38
			52		// 39
		];

	CServices.heightNormalToLF = function (height)
	{
	    if (height < CServices.MAX_HEIGHTS)
	    {
	        return CServices.aHeightNormalToLF[height];
	    }
	    return Math.round((height * 96) / 72);
	}

	CServices.DT_LEFT = 0x0000;
	CServices.DT_TOP = 0x0000;
	CServices.DT_CENTER = 0x0001;
	CServices.DT_RIGHT = 0x0002;
	CServices.DT_BOTTOM = 0x0008;
	CServices.DT_VCENTER = 0x0004;
	CServices.DT_SINGLELINE = 0x0020;
	CServices.DT_CALCRECT = 0x0400;
	CServices.DT_VALIGN = 0x0800;
	CServices.drawText = function (context, s, flags, rc, font, displayArray)
	{
		if (s.length == 0)
		{
			if ((flags & 0x0400) != 0)
			{
				rc.right = rc.left;
				rc.bottom = rc.top;
			}
			return 0;
		}

		if (!font.isGraphic)
			context.font = font.getFont();
		//CServices.fontHeight = font.getHeight();

		var maxHeight = 0;
		var char10 = String.fromCharCode(10);
		var char13 = String.fromCharCode(13);

	    // Is there a "new line" character?
		var index = s.indexOf(char10);
		if (index >= 0)
		{
	        // Yes, draw lines one by one
			var rc2 = new CRect();
			rc2.copyRect(rc);
			var sub;
			var h;
			var prevIndex = 0;
			var maxWidth = 0;
			var index2, nextIndex;

			do
			{
				index2 = -1;
				if (prevIndex < s.length)
				{
					index2 = s.indexOf(char13, prevIndex);
				}
				nextIndex = Math.max(index, index2);
				if (index2 == index - 1)
				{
					index--;
				}
				sub = s.substring(prevIndex, index);
				h = CServices.drawIt(context, sub, flags, rc2, displayArray, font);
				maxWidth = Math.max(maxWidth, rc2.right - rc2.left);
				maxHeight += h;
				rc2.top += h;
				rc2.bottom = rc.bottom;
				rc2.right = rc.right;
				prevIndex = nextIndex + 1;
				index = -1;
				if (prevIndex < s.length) {
				    index = s.indexOf(char10, prevIndex);
				}
				else {
	                // Draw an empty line if the text ends with CR/LF characters
				    h = CServices.drawIt(context, "", flags, rc2, displayArray, font);
				    maxWidth = Math.max(maxWidth, rc2.right - rc2.left);
				    maxHeight += h;
				    rc2.top += h;
				    rc2.bottom = rc.bottom;
				    rc2.right = rc.right;
				}
			} while (index >= 0);
			if (prevIndex < s.length)
			{
				sub = s.substring(prevIndex);
				h = CServices.drawIt(context, sub, flags, rc2, displayArray, font);
				maxWidth = Math.max(maxWidth, rc2.right - rc2.left);
				maxHeight += h;
			}
			if ((flags & CServices.DT_CALCRECT) != 0)
			{
				rc.right = rc.left + maxWidth;
				rc.bottom = rc2.bottom;
				return maxHeight;
			}
			return maxHeight;
		}

	    // No "new line" character, draw a single line
		maxHeight = CServices.drawIt(context, s, (flags | CServices.DT_VALIGN), rc, displayArray, font);
		return maxHeight;
	}
	CServices.xPos = null;
	//CServices.fontHeight = 0;
	CServices.drawIt = function (context, s, flags, rc, displayArray, font)
	{
		if (s.length == 0)
		{
			s = " ";
		}

		var hLine;
		var spaceWidth;
		hLine = font.getHeight();
		if (font.isGraphic)
			spaceWidth = font.measureText(" ");
		else
			spaceWidth = context.measureText(" ").width;

		var rectWidth = rc.right - rc.left;
		var startSpace = 0;
		var currentSpace = 0;
		var previousSpace;
		var firstSpace = 0;
		var x;
		var width = 0;
		var height = 0;
		var currentXPos;
		if (CServices.xPos == null)
		{
			CServices.xPos = new Array(100);
		}
		var sx;
		var ss;
		var bQuit = false;
		var bContinue = false;

		var y = rc.top;
		var hCalcul = hLine;
		if ((hCalcul & 1) != 0)
		{
			hCalcul++;
		}
		/*    if ((flags & CServices.DT_VALIGN) != 0)
		 {
		 if ((flags & CServices.DT_VCENTER) != 0)
		 {
		 y = rc.top + (rc.bottom - rc.top) / 2 - hCalcul / 2;
		 }
		 else if ((flags & CServices.DT_BOTTOM) != 0)
		 {
		 y = rc.bottom - hLine;
		 }
		 }
		 */
		var yTop = y;
		do
		{
			firstSpace = startSpace;
			currentXPos = 0;
			x = 0;
			height += hLine;
			do
			{
				CServices.xPos[currentXPos] = x;
				currentXPos += 1;
				previousSpace = currentSpace;
				currentSpace = -1;
				if (firstSpace < s.length)
					currentSpace = s.indexOf(" ", firstSpace);
				if (currentSpace == -1)
					currentSpace = s.length;
				if (currentSpace < firstSpace)
				{
					x -= spaceWidth;
					break;
				}
				ss = s.substring(firstSpace, currentSpace);
				if (font.isGraphic)
					sx = font.measureText(ss);
				else
					sx = context.measureText(ss).width;
				if (x + sx > rectWidth)
				{
					currentXPos--;
					if (currentXPos > 0)
					{
						sx -= spaceWidth;
						x -= spaceWidth;
						currentSpace = previousSpace;
						break;
					}
					var c;
					for (c = firstSpace; c < currentSpace; c++)
					{
						if (font.isGraphic)
							sx = font.measureText(s.substring(c, c + 1));
						else
							sx = context.measureText(s.substring(c, c + 1)).width;
						if (x + sx >= rectWidth)
						{
							c--;
							if (c > 0)
							{
								width = Math.max(x, width);
								if ((flags & CServices.DT_CALCRECT) == 0)
								{
									if ((flags & CServices.DT_CENTER) != 0)
									{
										x = rc.left + (rc.right - rc.left) / 2 - x / 2;
									}
									else if ((flags & CServices.DT_RIGHT) != 0)
									{
										x = rc.right - x;
									}
									else
									{
										x = rc.left;
									}
									ss = s.substring(firstSpace, c);
									displayArray.push(new CDisplayText(x, y, ss));
								}
								currentSpace = c - 1;
								bQuit = true;
								bContinue = true;
								break;
	x						}
							currentSpace = -1;
							if (c < s.length)
							{
								currentSpace = s.indexOf(" ", c);
							}
							else
							{
								currentSpace = -1;
							}
							bQuit = true;
							if (currentSpace >= 0)
							{
								bContinue = true;
							}
							break;
						}
						x += sx;
					}
				}
				if (bQuit)
				{
					break;
				}
				x += sx;
				if (x + spaceWidth > rectWidth)
				{
					break;
				}
				x += spaceWidth;
				firstSpace = currentSpace + 1;
			} while (true);
			if (bContinue == false)
			{
				if (bQuit)
				{
					break;
				}
				width = Math.max(x, width);
				var n;
				if ((flags & CServices.DT_CALCRECT) == 0)
				{
					if ((flags & CServices.DT_CENTER) != 0)
						x = rc.left + (rc.right - rc.left) / 2 - x / 2;
					else if ((flags & CServices.DT_RIGHT) != 0)
						x = rc.right - x;
					else
						x = rc.left;
					firstSpace = startSpace;
					for (n = 0; n < currentXPos; n++)
					{
						currentSpace = -1;
						if (firstSpace < s.length)
							currentSpace = s.indexOf(" ", firstSpace);
						if (currentSpace == -1)
							currentSpace = s.length;
						if (currentSpace < firstSpace)
							break;
						ss = s.substring(firstSpace, currentSpace);
						displayArray.push(new CDisplayText(x + CServices.xPos[n], y, ss));
						firstSpace = currentSpace + 1;
					}
				}
			}
			bQuit = false;
			bContinue = false;
			y += hLine;
			startSpace = currentSpace + 1;
		} while (startSpace < s.length);

		rc.right = rc.left + width;
		rc.bottom = yTop + height;
		return height;
	}

	CServices.displayText = function (context, x, y, displayArray, font, color, effect, effectParam)
	{
		var n, element;
		if (!font.isGraphic)
		{
			context.font = font.getFont();
			//CServices.fontHeight = font.getHeight();
			context.fillStyle = CServices.getColorString(color);
			context.textAlign = "left";
			context.textBaseline = "top";
			for (n = 0; n < displayArray.length; n++)
			{
				element = displayArray[n];
				context.fillText(element.text, x + element.x, y + element.y);
			}
		}
		else
		{
			for (n = 0; n < displayArray.length; n++)
			{
				element = displayArray[n];
				font.fillText(context, element.text, x + element.x, y + element.y);
			}
		}
	}

	CServices.intToString = function (value, displayFlags)
	{
		var s = value.toString();
		if ((displayFlags & CCounter.CPTDISPFLAG_INTNDIGITS) != 0)
		{
			var nDigits = displayFlags & CCounter.CPTDISPFLAG_INTNDIGITS;
			if (s.length > nDigits)
			{
				s = s.substring(s.length - nDigits);
			}
			else
			{
				while (s.length < nDigits)
				{
					s = "0" + s;
				}
			}
		}
		return s;
	}

	CServices.doubleToString = function (value, displayFlags)
	{
		var s;
		if ((displayFlags & CCounter.CPTDISPFLAG_FLOAT_FORMAT) == 0)
		{
			s = value.toString();
		}
		else
		{
			var bRemoveTrailingZeros = false;
			var nDigits = Math.floor(((displayFlags & CCounter.CPTDISPFLAG_FLOATNDIGITS) >> CCounter.CPTDISPFLAG_FLOATNDIGITS_SHIFT) + 1);
			var nDecimals = -1;
			if ((displayFlags & CCounter.CPTDISPFLAG_FLOAT_USENDECIMALS) != 0)
				nDecimals = ((displayFlags & CCounter.CPTDISPFLAG_FLOATNDECIMALS) >> CCounter.CPTDISPFLAG_FLOATNDECIMALS_SHIFT);
			else if (value != 0.0 && value > -1.0 && value < 1.0)
			{
				nDecimals = nDigits;
				bRemoveTrailingZeros = true;
			}
			if (nDecimals < 0)
			{
				s = value.toPrecision(nDigits);
			}
			else
			{
				s = value.toFixed(nDecimals);
			}
			var l, n;
			var ss;
			if ((displayFlags & CCounter.CPTDISPFLAG_FLOAT_PADD) != 0)
			{
				l = 0;
				for (n = 0; n < s.length; n++)
				{
					ss = s.charAt(n);
					if (ss != "." && ss != "+" && ss != "-" && ss != "e" && ss != "E")
						l++;
				}
			}
			var bFlag = false;
			if (s.charAt(0) == "-")
			{
				bFlag = true;
				s = s.substr(1);
			}
			while (l < nDigits)
			{
				s = "0" + s;
				l++;
			}
			if (bFlag)
			{
				s = "-" + s;
			}
		}
		return s;
	}

	CServices.subtractFilename = function (destination, source)
	{
		var tempDest = destination;
		var tempSource = source;
		var pos = tempSource.indexOf("\\");
		while (pos >= 0)
		{
			if (tempDest.substring(0, pos) == tempSource.substring(0, pos))
			{
				tempSource = tempSource.substring(pos + 1);
				tempDest = tempDest.substring(pos + 1);
			}
			pos = tempSource.indexOf("\\", pos + 1);
		}
		return tempDest;
	}

	// CDisplayText object
	// --------------------------------------------------------------
	function CDisplayText(xx, yy, s)
	{
		this.x = xx;
		this.y = yy;
		this.text = s;
	}


	// CFile Object 
	// -----------------------------------------------------------------


	// For IE9
	var bUseAjax = false;
	var bUseBlob = false;
	var bUseBinaryString = false;

	var req = window['XMLHttpRequest'] ? new XMLHttpRequest() : null;

	if (!req || !req.overrideMimeType)
	{
		bUseAjax = true;
		var script = document.createElement('script');
		script.type = "text/vbscript";
		script.innerHTML = 'Function BinFileReaderImpl_IE_VBAjaxLoader(fileName)\n\
	                Dim xhr\n\
	                Set xhr = CreateObject("Microsoft.XMLHTTP")\n\
	                xhr.Open "GET", fileName, False\n\
	                xhr.setRequestHeader "Accept-Charset", "x-user-defined"\n\
	                xhr.send\n\
	                Dim byteArray()\n\
	                if xhr.Status = 200 Then\n\
	                    Dim byteString\n\
	                    Dim i\n\
	                    byteString=xhr.responseBody\n\
	                    ReDim byteArray(LenB(byteString))\n\
	                    For i = 1 To LenB(byteString)\n\
	                        byteArray(i-1) = AscB(MidB(byteString, i, 1))\n\
	                    Next\n\
	                End If\n\
	                BinFileReaderImpl_IE_VBAjaxLoader=byteArray\n\
	            End Function';

		document.head.appendChild(script);
	}
	else
	{
		try
		{
			bUseBlob = typeof new XMLHttpRequest()["responseType"] === 'string';
			if (navigator.userAgent.toLowerCase().indexOf('safari') >= 0)
				bUseBlob = false;
		}
		catch (e)
		{
		}
	}
	if (bUseBlob)
	{
		var reader = new FileReader();
		try
		{
			if (reader["readAsBinaryString"])
				bUseBinaryString = true;
		}
		catch (e)
		{
		}
		reader = null;
	}
	req = null;

	function CFile()
	{
		this.ccfBytes = "";
		this.pointer = 0;
		this.offset = 0;
		this.bUnicode = false;
	}

	CFile.prototype =
	{

		readUnsignedByte: function ()
		{
			return this.ccfBytes.charCodeAt(this.pointer++) & 0xFF;
		},
		getChecksum:      function ()
		{
			var n;
			var count = 0;
			for (n = 0; n < this.end; n++)
				count += (this.ccfBytes.charCodeAt(n) & 0xFF) ^ 0xAA;
			return count;
		},
		getFile:          function (fileName, callback, size)
		{
			this.callback = callback;
	        
			if (!bUseAjax)
			{
				var request = new XMLHttpRequest();
				request["open"]('GET', fileName, true);
				var that = this;

				if (bUseBlob)
				{
					request["responseType"] = "blob";
					request["onload"] = function ()
					{
						if (request["readyState"] == 4)
						{
							if (request["status"] == 200)
							{
								var reader = new FileReader();
								reader["onloadend"] = function ()
								{
									if (bUseBinaryString)
										that.ccfBytes += reader["result"];
									else
									{
										var array = new Uint8Array(reader["result"]);
										var n;
										for (n = 0; n < array.length; n++)
											that.ccfBytes += String.fromCharCode(array[n]);
									}
									that.end = that.ccfBytes.length;
									that.callback();
								}
								if (bUseBinaryString)
									reader.readAsBinaryString(request["response"]);
								else
									reader.readAsArrayBuffer(request["response"]);
							}
						}
					}
					request["send"](null);
				}
				else
				{
					request["overrideMimeType"]('text/plain; charset=x-user-defined');
					request["onload"] = function ()
					{
						if (request["readyState"] == 4)
						{
							if (request["status"] == 200)
							{
								that.ccfBytes += request["responseText"];
								that.end = that.ccfBytes.length;
								that.callback();
							}
						}
					}
					request.send(null);
				}
			}
			else
			{
				try
				{
					var array = BinFileReaderImpl_IE_VBAjaxLoader(fileName)['toArray']()
					var n;
					var length = array.length;
					if (length > size)
						length = size;
					for (n = 0; n < length; n++)
						this.ccfBytes += String.fromCharCode(array[n]);
					this.end = this.ccfBytes.length;
					this.callback();
				}
				catch (error)
				{
				}
			}
		},
		openFileASync:    function (fileName, parent)
		{
			this.parent = parent;
			var request = new XMLHttpRequest();
			request.open('GET', fileName, true);
			request.overrideMimeType('text/plain; charset=x-user-defined');
			var that = this;
			request.onload = function ()
			{
				if (request.readyState == 4)
				{
					if (request.status == 200)
					{
						that.ccfBytes = request.responseText;
						that.end = that.ccfBytes.length;
						that.pointer = 0;
						that.offset = 0;
						that.bUnicode = false;
						that.parent.dataReceived(true);
						return;
					}
				}
			}
			request.send(null);
		},
		getBytes:         function ()
		{
			return this.ccfBytes;
		},
		setBinary:        function (binary)
		{
			this.ccfBytes = binary;
			this.end = binary.length;
			var that = this;
			this.readUnsignedByte = function ()
			{
				return that.ccfBytes.charCodeAt(that.pointer++) & 0xFF;
			}
		},
		createFromFile:   function (offset, length)
		{
			var file = new CFile();
			file.ccfBytes = this.ccfBytes;
			file.offset = offset;
			file.pointer = offset;
			file.end = offset + length;
			file.bUnicode = this.bUnicode;
			return file;
		},

		getLength: function ()
		{
			return this.end - this.offset;
		},

		setUnicode: function (unicode)
		{
			this.bUnicode = unicode;
		},
		detectUnicode: function()
		{
			var b1 = this.readUnsignedByte();
			var b2 = this.readUnsignedByte();
			var b3 = this.readUnsignedByte();
			if (b1 == 0xFF && b2 == 0xFE)
			{
				this.bUnicode = true;               // UTF16
				this.pointer--;
			}
			else if (b1 == 0xEF && b2 == 0xBB && b3 == 0xBF)
			{
				this.bUnicode = false;              // UTF8
			}
			else
			{
				this.bUnicode = false;              // ASCII
				this.pointer -= 3;
			}
		},
		skipBytes: function (skip)
		{
			this.pointer += skip;
		},

		adjustTo8: function ()
		{
			if ((this.pointer & 0x07) != 0)
			{
				this.pointer += 8 - (this.pointer & 0x07);
			}
		},

		isEOF: function ()
		{
			return this.pointer >= this.end;
		},

		readInString: function (len)
		{
			var n, s = "";
			for (n = 0; n < len; n++)
				s += String.fromCharCode(this.readUnsignedByte());
			return s;
		},

		readAByte: function ()
		{
			return this.readUnsignedByte();
		},

		readAShort: function ()
		{
			var b1, b2;
			b1 = this.readUnsignedByte();
			b2 = this.readUnsignedByte();
			return b2 * 256 + b1;
		},

		readShort: function ()
		{
			var b1, b2;
			b1 = this.readUnsignedByte();
			b2 = this.readUnsignedByte();
			var value = b2 * 256 + b1;
			if (value < 32768)
				return value;
			else
				return value - 65536;
		},

		readAChar: function ()
		{
			var b1, b2;
			b1 = this.readUnsignedByte();
			b2 = this.readUnsignedByte();
			return (b2 * 256 + b1);
		},

		readACharArray: function (size)
		{
			var c = new Array();
			var b1, b2;
			var n;
			for (n = 0; n < size; n++)
			{
				b1 = this.readUnsignedByte();
				b2 = this.readUnsignedByte();
				c[n] = (b2 * 256 + b1);
			}
			return c;
		},

		readAInt: function ()
		{
			var b1, b2, b3, b4;
			b1 = this.readUnsignedByte();
			b2 = this.readUnsignedByte();
			b3 = this.readUnsignedByte();
			b4 = this.readUnsignedByte();
			var value = b4 * 0x01000000 + b3 * 0x00010000 + b2 * 0x00000100 + b1;
			if (value <= 0x7FFFFFFF)
				return value;
			else
				return value - 0x100000000;

		},

		readAColor: function ()
		{
			var b1, b2, b3;
			var c;

			b1 = this.readUnsignedByte();
			b2 = this.readUnsignedByte();
			b3 = this.readUnsignedByte();
			this.readUnsignedByte();

			c = b1 * 0x00010000 + b2 * 0x00000100 + b3;
			return c;
		},

		readAFloat: function ()
		{
			var b1, b2, b3, b4;

			b1 = this.readUnsignedByte();
			b2 = this.readUnsignedByte();
			b3 = this.readUnsignedByte();
			b4 = this.readUnsignedByte();
			var total = b4 * 0x01000000 + b3 * 0x00010000 + b2 * 0x00000100 + b1;
			if (total > 0x80000000)
			{
				total -= 0xFFFFFFFF;
			}
			return total / 65536.0;
		},

		readADouble: function ()
		{
			var b1, b2, b3, b4, b5, b6, b7, b8;

			b1 = this.readUnsignedByte();
			b2 = this.readUnsignedByte();
			b3 = this.readUnsignedByte();
			b4 = this.readUnsignedByte();
			b5 = this.readUnsignedByte();
			b6 = this.readUnsignedByte();
			b7 = this.readUnsignedByte();
			b8 = this.readUnsignedByte();

			var total = b8 * 0x0100000000000000 + b7 * 0x0001000000000000 + b6 * 0x0000010000000000 + b5 * 0x0000000100000000 + b4 * 0x01000000 + b3 * 0x00010000 + b2 * 0x00000100 + b1;
			if (total > 0x8000000000000000)
			{
				total -= 0xFFFFFFFFFFFFFFFF;
			}
			return total / 0x100000000;
		},

		readAString:    function (length)
		{
			var string = "";
			if (!this.bUnicode)
			{
				if (arguments.length < 1)
				{
					if (this.isEOF())
						return string;

					var begin = this.pointer;
					var b = this.readUnsignedByte();
					while (b && !this.isEOF())
						b = this.readUnsignedByte();

					var stringLength = this.pointer - begin - 1;
					this.pointer = begin;

					string = this.readAString(stringLength);
					this.readUnsignedByte();

					return string;
				}
				else
				{
					var c;
					var begin = this.pointer;
					for (var i = 0; i < length; ++i)
					{
						c = this.readUnsignedByte();
						if (c == 0)
							break;
						string += String.fromCharCode(c);
					}
					this.pointer = begin + length;
					return string;
				}
			}
			else
			{
				if (arguments.length < 1)
				{
					if (this.isEOF())
						return string;

					var begin = this.pointer;

					var b = this.readAChar();
					while (b && !this.isEOF())
						b = this.readAChar();

					var stringLength = (this.pointer - begin - 2) / 2;
					this.pointer = begin;

					string = this.readAString(stringLength);
					this.readUnsignedByte();
					this.readUnsignedByte();

					return string;
				}
				else
				{
					string = '';
					var begin = this.pointer;
					var c;
					for (var i = 0; i < length; i++)
					{
						c = this.readAChar();
						if (c == 0)
							break;
						string += String.fromCharCode(c);
					}
					this.pointer = begin + length * 2;
					return string;
				}
			}
		},
		readAStringEOL: function ()
		{
			var debut = this.pointer;
			var b;
			var ret = "";
			var end;
			var delta;
			var bb;

			if (this.bUnicode == false)
			{
				if (this.isEOF())
					return;

				b = this.readUnsignedByte();
				while (b != 10 && b != 13 && !this.isEOF())
					b = this.readUnsignedByte();

				end = this.pointer;
				this.pointer = debut;
				delta = 1;
				if (b != 10 && b != 13)
					delta = 0;

				if (end > debut + delta)
				{
					ret = this.readAString(end - debut - delta);
				}
				if (b == 10 || b == 13)
				{
					this.readUnsignedByte();
					bb = this.readAByte();
					if (b == 10 && bb != 13)
					{
						this.pointer--;
					}
					if (b == 13 && bb != 10)
					{
						this.pointer--;
					}
				}
				return ret;
			}
			else
			{
				if (this.isEOF())
					return;

				b = this.readAChar();
				while (b != 10 && b != 13 && !this.isEOF())
					b = this.readAChar();

				end = this.pointer;
				this.pointer = debut;
				delta = 2;
				if (b != 10 && b != 13)
					delta = 0;
				if (end > debut + delta)
					ret = this.readAString((end - debut - delta) / 2);

				if (b == 10 || b == 13)
				{
					this.pointer += 2;
					bb = this.readAChar();
					if (b == 10 && bb != 13)
						this.pointer -= 2;
					if (b == 13 && bb != 10)
						this.pointer -= 2;
				}
				return ret;
			}
		},

		skipAString: function ()
		{
			var b;
			if (this.bUnicode == false)
			{
				do
				{
					b = this.readUnsignedByte();
				} while (b != 0 && !this.EOF());
			}
			else
			{
				do
				{
					b = this.readAChar();
				} while (b != 0 && !this.EOF());
			}
		},

		getFilePointer: function ()
		{
			return this.pointer;
		},

		seek: function (pos)
		{
			if (pos >= this.end)
			{
				pos = this.end;
			}
			this.pointer = pos;
		},

		skipBack: function (n)
		{
			var pos = this.pointer;
			pos -= n;
			if (pos < 0)
				pos = 0;
			this.pointer = pos;
		},

		readBytesAsArray: function (a)
		{
			var n;
			var size = a.length;
			for (n = 0; n < size; n++)
				a[n] = this.readUnsignedByte();
		},

		readBuffer: function (size)
		{
			var buffer = new Array();
			var i;

			for (i = 0; i < size; i++)
				buffer[i] = this.readUnsignedByte();

			return buffer;
		},

		readLogFont: function ()
		{
			var lf = new CFontInfo();
			lf.readLogFont(this);
			return lf;
		},

		readLogFont16: function ()
		{
			var lf = new CFontInfo();
			lf.readLogFont16(this);
			return lf;
		}
	}


	// CArrayList Object 
	// -----------------------------------------------------------------
	function CArrayList()
	{
		this.array = new Array();
	}
	CArrayList.prototype =
	{
		add:          function (o)
		{
			this.array.push(o);
		},
		isEmpty:      function ()
		{
			return this.array.length();
		},
		insert:       function (index, o)
		{
			this.array.splice(index, 0, o);
		},
		get:          function (index)
		{
			if (index < this.array.length)
			{
				return this.array[index];
			}
			return null;
		},
		put:          function (index, o)
		{
			this.array[index] = o;
		},
		set:          function (index, o)
		{
			if (index < this.array.length)
			{
				this.array[index] = o;
			}
		},
		removeIndex:  function (index)
		{
			if (index < this.array.length)
			{
				this.array.splice(index, 1);
			}
		},
		indexOf:      function (o)
		{
			return this.array.indexOf(o);
		},
		contains:     function (o)
		{
			return this.array.indexOf(o) >= 0;
		},
		removeObject: function (o)
		{
			var n = this.array.indexOf(o);
			if (n >= 0)
				this.array.splice(n, 1);
		},
		size:         function ()
		{
			return this.array.length;
		},
		clear:        function ()
		{
			this.array.length = 0;
		}
	}

	// CRect object
	// -------------------------------------------------------------
	function CRect(l, t, r, b)
	{
		if (l)
			this.left = l
		else
			this.left = 0;

		if (t)
			this.top = t
		else
			this.top = 0;

		if (r)
			this.right = r;
		else
			this.right = 0;

		if (b)
			this.bottom = b;
		else
			this.bottom = 0;
	}
	CRect.prototype =
	{
		load: function (file)
		{
			this.left = file.readAInt();
			this.top = file.readAInt();
			this.right = file.readAInt();
			this.bottom = file.readAInt();
		},

		copyRect: function (srce)
		{
			this.left = srce.left;
			this.right = srce.right;
			this.top = srce.top;
			this.bottom = srce.bottom;
		},

		ptInRect: function (x, y)
		{
			if (x >= this.left && x < this.right && y >= this.top && y < this.bottom)
				return true;
			return false;
		},

		intersectRect: function (rc)
		{
			if ((this.left >= rc.left && this.left < rc.right) || (this.right >= rc.left && this.right < rc.right) || (rc.left >= this.left && rc.left < this.right) || (rc.right >= this.left && rc.right < this.right))
			{
				if ((this.top >= rc.top && this.top < rc.bottom) || (this.bottom >= rc.top && this.bottom < rc.bottom) || (rc.top >= this.top && rc.top < this.bottom) || (rc.bottom >= this.top && rc.bottom < this.bottom))
				{
					return true;
				}
			}
			return false;
		}
	}

	// CPoint object
	// ------------------------------------------------------------
	function CPoint()
	{
		this.x = 0;
		this.y = 0;
	}

	// CZone object
	// ------------------------------------------------------------
	function CZone()
	{
		this.x1 = 0;
		this.y1 = 0;
		this.x2 = 0;
		this.y2 = 0;
	}


	// CFontthis object
	// ------------------------------------------------------------
	function CFontInfo()
	{
		this.lfHeight = 12;
		this.lfWeight = 400;
		this.lfItalic = 0;
		this.lfFaceName = "Arial";
		this.isGraphic = false;
	}
	CFontInfo.prototype =
	{
		copy:    function (f)
		{
			this.lfHeight = f.lfHeight;
			this.lfWeight = f.lfWeight;
			this.lfItalic = f.lfItalic;
			this.lfFaceName = f.lfFaceName;
		},
		getFont: function ()
		{
			var result;
			if (this.lfItalic)
				result = "italic ";
			else
				result = "normal "

			var weight = Math.floor(this.lfWeight / 100) * 100;
			weight = Math.max(weight, 100);
			weight = Math.min(weight, 900);
			result += weight + " ";

			var height = this.lfHeight; // CServices.heightNormalToLF(this.lfHeight);
			result += height + "px ";
			result += this.lfFaceName;

			return result;
		},

		getHeight: function () {
		    return this.lfHeight + Math.ceil(this.lfHeight / 8);
		},

		init: function ()
		{
			this.lfFaceName = "Arial";
			this.lfHeight = 13;
			this.lfWeight = 400;
			this.lfItalic = 0;
		},
		readLogFont:   function (file)
		{
			this.lfHeight = file.readAInt();
			if (this.lfHeight < 0)
				this.lfHeight = -this.lfHeight;
			file.skipBytes(12);
			this.lfWeight = file.readAInt();
			this.lfItalic = file.readAByte();
			this.lfUnderline = file.readAByte();
			this.lfStrikeOut = file.readAByte();
			file.skipBytes(5);
			this.lfFaceName = file.readAString(32);
		},
		readLogFont16: function (file)
		{
			this.lfHeight = file.readShort();
			if (this.lfHeight < 0)
				this.lfHeight = -this.lfHeight;
			file.skipBytes(6);
			this.lfWeight = file.readAShort();
			this.lfItalic = file.readAByte();
			this.lfUnderline = file.readAByte();
			this.lfStrikeOut = file.readAByte();
			file.skipBytes(5);
			var oldUnicode = file.bUnicode;
			file.bUnicode = false;
			this.lfFaceName = file.readAString(32);
			file.bUnicode = oldUnicode;
		}
	}


	// CIni object
	// ------------------------------------------------------------
	CIni.separator = "{@24}";
	CIni.INIFLAG_UTF8 = 0x0001;
	CIni.INIFLAG_UTF16 = 0x0002;
	function CIni(a, flags)
	{
		this.app = a;
		this.flags = flags;
		this.strings = new CArrayList();
		this.currentFileName = null;
	}
	CIni.prototype =
	{
		saveIni:     function ()
		{
			if (this.strings != null && this.currentFileName != null)
			{
				var value = "";
				var n;
				for (n = 0; n < this.strings.size(); n++)
					value += this.strings.get(n) + CIni.separator;
				localStorage.setItem(this.currentFileName, value);
			}
		},
		loadIni:     function (fileName)
		{
			var reload = true;
			if (this.currentFileName != null)
			{
				if (CServices.compareStringsIgnoreCase(fileName, this.currentFileName))
				{
					reload = false;
				}
			}
			if (reload)
			{
				this.saveIni();

				this.currentFileName = fileName;
				this.strings = new CArrayList();

				var value = localStorage.getItem(this.currentFileName);
				if (value)
				{
					var begin = 0;
					var end = value.indexOf(CIni.separator, 0);
					while (end >= 0)
					{
						this.strings.add(value.substring(begin, end));
						begin = end + CIni.separator.length;
						end = value.indexOf(CIni.separator, begin);
					}
					;
				}
				else
				{
					/*		     	var cFile=new CFile();
					 cFile.openFile(this.currentFileName);
					 if (cFile.getLength()==0)
					 {
					 cFile=null;
					 }
					 */
					var cFile = null;
					if (cFile == null)
					{
						var eFile = this.app.getEmbeddedFile(this.currentFileName);
						if (eFile != null)
						{
							cFile = eFile.open();
						}
					}
					if (cFile)
					{
						cFile.detectUnicode();
						if (typeof this.flags != 'undefined')
						{
							if (this.flags & CIni.INIFLAG_UTF8)
								this.bUnicode = false;
							if (this.flags & CIni.INIFLAG_UTF16)
								this.bUnicode = true;
						}
						while (cFile.isEOF() == false)
						{
							var currentLine = cFile.readAStringEOL();
							if (currentLine.substring(0, 1) == "<")
							{
								this.strings.clear();
								break;
							}
							if (currentLine == null)
							{
								break;
							}
							this.strings.add(currentLine);
						}
					}
				}
			}
		},
		findSection: function (sectionName)
		{
			var l;
			var s, s2;
			for (l = 0; l < this.strings.size(); l++)
			{
				s = this.strings.get(l);
				if (s.charAt(0) == "[")
				{
					var last = s.lastIndexOf("]");
					if (last >= 1)
					{
						s2 = s.substring(1, last);
						if (CServices.compareStringsIgnoreCase(sectionName, s2))
						{
							return l;
						}
					}
				}
			}
			return -1;
		},

		findKey: function (l, keyName)
		{
			var s, s2;
			var last;
			for (; l < this.strings.size(); l++)
			{
				s = this.strings.get(l);
				if (s.charAt(0) == "[")
				{
					return -1;
				}
				last = s.indexOf('=');
				if (last >= 0)
				{
					var start = 0;
					while (start < last && s.charCodeAt(start) == 32)
					{
						start++;
					}
					while (last > start && s.charCodeAt(last - 1) == 32)
					{
						last--;
					}
					if (last > start)
					{
						s2 = s.substring(0, last);
						if (CServices.compareStringsIgnoreCase(s2, keyName))
						{
							return l;
						}
					}
				}
			}
			return -1;
		},

		getPrivateProfileString: function (sectionName, keyName, defaultString, fileName)
		{
			this.loadIni(fileName);

			var l = this.findSection(sectionName);
			if (l >= 0)
			{
				l = this.findKey(l + 1, keyName);
				if (l >= 0)
				{
					var s = this.strings.get(l);
					var last = s.indexOf("=");
					return s.substring(last + 1);
				}
			}
			return defaultString;
		},

		writePrivateProfileString: function (sectionName, keyName, name, fileName)
		{
			this.loadIni(fileName);

			var s;
			var section = this.findSection(sectionName);
			if (section < 0)
			{
				s = "[" + sectionName + "]";
				this.strings.add(s);
				s = keyName + "=" + name;
				this.strings.add(s);
				//            this.saveIni();
				return;
			}

			var key = this.findKey(section + 1, keyName);
			if (key >= 0)
			{
				s = keyName + "=" + name;
				this.strings.set(key, s);
				//            this.saveIni();
				return;
			}

			for (key = section + 1; key < this.strings.size(); key++)
			{
				s = this.strings.get(key);
				if (s.charAt(0) == '[')
				{
					s = keyName + "=" + name;
					this.strings.insert(key, s);
					//	            this.saveIni();
					return;
				}
			}
			s = keyName + "=" + name;
			this.strings.add(s);
			//        this.saveIni();
		},

		deleteItem: function (group, item, iniName)
		{
			this.loadIni(iniName);

			var s = this.findSection(group);
			if (s >= 0)
			{
				var k = this.findKey(s + 1, item);
				if (k >= 0)
				{
					this.strings.removeIndex(k);
				}
				this.saveIni();
			}
		},

		deleteGroup: function (group, iniName)
		{
			this.loadIni(iniName);

			var s = this.findSection(group);
			if (s >= 0)
			{
				this.strings.removeIndex(s);
				while (true)
				{
					s++;
					if (s >= this.strings.size())
					{
						break;
					}
					if (this.strings.get(s).charAt(0) == '[')
					{
						break;
					}
					this.strings.removeIndex(s);
				}
				this.saveIni();
			}
		}
	}

	// CTextSurface
	// -----------------------------------------------------------------
	function CTextSurface(a, w, h)
	{
		this.app = a;
		this.width = w;
		this.height = h;
		this.canvas = document.createElement("canvas");
		this.canvas.width = w;
		this.canvas.height = h;
		this.canvasContext = this.canvas.getContext("2d");
	}
	CTextSurface.prototype =
	{
		measureText:    function (text, font)
		{
			font = this.app.getGraphicFont(font);
			if (font.isGraphic)
				return font.measureText(text);
			this.canvasContext.font = font.getFont();
			return this.canvasContext.measureText(text).width;
		},
		setText:        function (text, dtflags, rectangle, font, color)
		{
			/* TODO : fix rect comparison */

			if (text == this.lastText && dtflags == this.lastFlags
				&& rectangle == this.lastRect && font == this.lastFont
				&& color == this.lastColor)
			{
				return this.lastHt;
			}

			var context = this.canvasContext;
			context.clearRect(0, 0, this.width, this.height);

			if (!rectangle)
				rectangle = new CRect(0, 0, this.width, this.height);
			var displayArray = new Array(0);
			font = this.app.getGraphicFont(font);
			var ht = CServices.drawText(context, text, dtflags, rectangle, font, displayArray);
			if (ht != 0)
			{
				var deltaY = 0;
				if ((dtflags & CServices.DT_BOTTOM) != 0)
					deltaY = this.height - ht;
				else if ((dtflags & CServices.DT_VCENTER) != 0)
					deltaY = this.height / 2 - ht / 2;
				CServices.displayText(context, 0, deltaY, displayArray, font, color, 0, 0);
			}
			this.lastText = text;
			this.lastFlags = dtflags;
			this.lastRect = rectangle;
			this.lastFont = font;
			this.lastColor = color;
			this.lastHt = ht;

			return ht;
		},
		manualClear:    function (color)
		{
			if (!color)
			{
				this.canvasContext.clearRect(0, 0, this.width, this.height);
				return;
			}

			this.canvasContext.fillStyle = CServices.getColorString(color);
			this.canvasContext.fillRect(0, 0, this.width, this.height);
		},
		manualDrawText: function (s, flags, rect, color, font, relief, color2)
		{
			var context = this.canvasContext;

			var displayArray = new Array(0);
			if (!rect)
				rect = new CRect(0, 0, this.width, this.height);
			font = this.app.getGraphicFont(font);
			var ht = CServices.drawText(this.canvasContext, s, flags, rect, font, displayArray);
			if (ht != 0)
			{
				var deltaY = 0;
				if ((flags & CServices.DT_BOTTOM) != 0)
					deltaY = this.height - ht;
				else if ((flags & CServices.DT_VCENTER) != 0)
					deltaY = this.height / 2 - ht / 2;
				switch (relief)
				{
					case 1:
						CServices.displayText(this.canvasContext, 1, deltaY + 1, displayArray, font, color2, 0, 0);
						CServices.displayText(this.canvasContext, 0, deltaY, displayArray, font, color, 0, 0);
						break;
					case 2:
						CServices.displayText(this.canvasContext, 1, deltaY, displayArray, font, color2, 0, 0);
						CServices.displayText(this.canvasContext, 1, deltaY + 2, displayArray, font, color2, 0, 0);
						CServices.displayText(this.canvasContext, 0, deltaY + 1, displayArray, font, color2, 0, 0);
						CServices.displayText(this.canvasContext, 2, deltaY + 1, displayArray, font, color2, 0, 0);
						CServices.displayText(this.canvasContext, 1, deltaY + 1, displayArray, font, color, 0, 0);
						break;
					case 0:
						CServices.displayText(this.canvasContext, 0, deltaY, displayArray, font, color, 0, 0);
						break;
				}
			}
		},
		resize:         function (w, h)
		{
			if (w != this.width || h != this.height)
			{
				this.width = w;
				this.height = h;
				this.canvas.width = w;
				this.canvas.height = h;
			}
		},
		draw:           function (context, x, y, inkEffect, inkEffectParam)
		{
			context.renderSimpleImage(this.canvas, x, y, this.width, this.height, inkEffect, inkEffectParam);
		}
	}

	// Browser detection
	// ----------------------------------------------------------------------
	BrowserDetect.dataBrowser =
		[
			{
				string:    navigator.userAgent,
				subString: "Chrome",
				identity:  "Chrome"
			},
			{    string:       navigator.userAgent,
				subString:     "OmniWeb",
				versionSearch: "OmniWeb/",
				identity:      "OmniWeb"
			},
			{
				string:        navigator.vendor,
				subString:     "Apple",
				identity:      "Safari",
				versionSearch: "Version"
			},
			{
				prop:          window.opera,
				identity:      "Opera",
				versionSearch: "Version"
			},
			{
				string:    navigator.vendor,
				subString: "iCab",
				identity:  "iCab"
			},
			{
				string:    navigator.vendor,
				subString: "KDE",
				identity:  "Konqueror"
			},
			{
				string:    navigator.userAgent,
				subString: "Firefox",
				identity:  "Firefox"
			},
			{
				string:    navigator.vendor,
				subString: "Camino",
				identity:  "Camino"
			},
			{		// for newer Netscapes (6+)
				string:    navigator.userAgent,
				subString: "Netscape",
				identity:  "Netscape"
			},
			{
				string:        navigator.userAgent,
				subString:     "MSIE",
				identity:      "Explorer",
				versionSearch: "MSIE"
			},
			{
				string:        navigator.userAgent,
				subString:     "Gecko",
				identity:      "Mozilla",
				versionSearch: "rv"
			},
			{ 		// for older Netscapes (4-)
				string:        navigator.userAgent,
				subString:     "Mozilla",
				identity:      "Netscape",
				versionSearch: "Mozilla"
			}
		];
	BrowserDetect.dataOS =
		[
			{
				string:    navigator.platform,
				subString: "Win",
				identity:  "Windows"
			},
			{
				string:    navigator.platform,
				subString: "Mac",
				identity:  "MacOS"
			},
			{
				string:    navigator.userAgent,
				subString: "iPhone",
				identity:  "iOS"
			},
			{
				string:    navigator.userAgent,
				subString: "iPod",
				identity:  "iOS"
			},
			{
				string:    navigator.userAgent,
				subString: "iPad",
				identity:  "iOS"
			},
			{
				string:    navigator.userAgent,
				subString: "Android",
				identity:  "Android"
			},
			{
				string:    navigator.platform,
				subString: "Windows Phone",
				identity:  "Windows Phone"
			},
			{
				string:    navigator.platform,
				subString: "Linux",
				identity:  "Linux"
			}
		];
	function BrowserDetect()
	{
	    // New detection, taken from http://stackoverflow.com/questions/9847580/how-to-detect-safari-chrome-ie-firefox-and-opera-browser

	    // Opera 8.0+
	    this.isOpera = (!!window['opr'] && !!opr.addons) || !!window['opera'] || navigator.userAgent.indexOf(' OPR/') >= 0;

	    // Firefox 1.0+
	    this.isFirefox = typeof InstallTrigger !== 'undefined';

	    // Safari 3.0+ "[object HTMLElementConstructor]" 
	    this.isSafari = Object.prototype.toString.call(window['HTMLElement']).indexOf('Constructor') > 0 || (function (p) { return p.toString() === "[object SafariRemoteNotification]"; })(!window['safari'] || safari['pushNotification']);

	    // Internet Explorer 6-11
	    this.isIE = /*@cc_on!@*/false || !!document.documentMode;

	    // Edge 20+
	    this.isEdge = !this.isIE && !!window['StyleMedia'];

	    // Chrome 1+
	    this.isChrome = !!window.chrome && !!window.chrome.webstore;

	    if (this.isChrome)
	        this.browser = "Chrome";
	    else if (this.isEdge)
	        this.browser = "Edge";
	    else if (this.isIE)
	        this.browser = "Explorer";
	    else if (this.isFirefox)
	        this.browser = "Firefox";
	    else if (this.isOpera)
	        this.browser = "Opera";
	    else if (this.isSafari)
	        this.browser = "Safari";

	    // Old version
	    else
	        this.browser = this.searchString(BrowserDetect.dataBrowser) || "Unknown browser";

	    this.version = this.searchVersion(navigator.userAgent)
			|| this.searchVersion(navigator.appVersion)
			|| "Unknown version";
		this.OS = this.searchString(BrowserDetect.dataOS) || "Unknown OS";
	}
	BrowserDetect.prototype =
	{
		searchString:  function (data)
		{
			for (var i = 0; i < data.length; i++)
			{
				var dataString = data[i].string;
				var dataProp = data[i].prop;
				this.versionSearchString = data[i].versionSearch || data[i].identity;
				if (dataString)
				{
					if (dataString.indexOf(data[i].subString) != -1)
						return data[i].identity;
				}
				else if (dataProp)
					return data[i].identity;
			}
		},
		searchVersion: function (dataString)
		{
			var index = dataString.indexOf(this.versionSearchString);
			if (index == -1) return;
			return parseFloat(dataString.substring(index + this.versionSearchString.length + 1));
		}
	};

	// REPLACE COLOR
	// -----------------------------------------------------
	function CActReplaceColor()
	{
		this.mode = null;
		this.dwMax = null;
		this.pImages = null;
		this.pRh = null;
	}

	function CReplaceColor()
	{
		this.mode = 0;
		this.app = null;
		this.pImages = null;
	}
	CReplaceColor.prototype =
	{
		replaceColor: function (rhPtr, pHo, newColor, oldColor)
		{
			this.app = rhPtr.rhApp;

			// Changement des couleurs
			// ----------------------------------------------------------------------------
			var oi = pHo.hoOi;
			var poi = rhPtr.rhApp.OIList.getOIFromHandle(oi);
			if (poi == null)
				return;

			// Get image max
			this.dwMax = -1;
			this.mode = 0;
			poi.enumElements(this, null);

			// Rechercher le premier
			var pHoFirst = pHo;
			while ((pHoFirst.hoNumPrev & 0x80000000) == 0)
				pHoFirst = rhPtr.rhObjectList[pHoFirst.hoNumPrev & 0x7FFFFFFF];

			// Parcourir la liste
			do
			{
				if (pHoFirst.roc.rcImage != -1 && pHoFirst.roc.rcImage > this.dwMax)
					this.dwMax = pHoFirst.roc.rcImage;
				if (pHoFirst.roc.rcOldImage != -1 && pHoFirst.roc.rcOldImage > this.dwMax)
					this.dwMax = pHoFirst.roc.rcOldImage;

				// Le dernier?
				if ((pHoFirst.hoNumNext & 0x80000000) != 0)
					break;

				// Next OI
				pHoFirst = rhPtr.rhObjectList[pHoFirst.hoNumNext];

			} while (true);

			// Allocate memory
			this.pImages = new Array(this.dwMax + 1);
			var n;
			for (n = 0; n < this.dwMax + 1; n++)
			{
				this.pImages[n] = -1;
			}

			// List all images
			this.mode = 1;
			poi.enumElements(this, null);

			// Replace color in all images and create new images
			var i;
			var newImg;
			for (i = 0; i <= this.dwMax; i++)
			{
				if (this.pImages[i] == -1)
					continue;

				var sourceImg = rhPtr.rhApp.imageBank.getImageFromHandle(i);
				var destImg = CServices.performReplacement(rhPtr.rhApp, sourceImg, oldColor, newColor);
				if (destImg != null)
				{
					// Create new image in the bank
					this.pImages[i] = rhPtr.rhApp.imageBank.addImage(destImg);
				}
			}

			// Remplacer images dans les objets de m�me OI
			pHoFirst = pHo;
			while ((pHoFirst.hoNumPrev & 0x80000000) == 0)
				pHoFirst = rhPtr.rhObjectList[pHoFirst.hoNumPrev & 0x7FFFFFFF];

			// Parcourir la liste
			do
			{
				if (pHoFirst.roc.rcImage != -1 && this.pImages[pHoFirst.roc.rcImage] != -1)
				{
					pHoFirst.roc.rcImage = this.pImages[pHoFirst.roc.rcImage];
				}
				if (pHoFirst.roc.rcOldImage != -1 && this.pImages[pHoFirst.roc.rcOldImage] != -1)
				{
					pHoFirst.roc.rcOldImage = this.pImages[pHoFirst.roc.rcOldImage];
				}

				// Le dernier?
				if ((pHoFirst.hoNumNext & 0x80000000) != 0)
					break;
				// Next OI
				pHoFirst = rhPtr.rhObjectList[pHoFirst.hoNumNext];

			} while (true);

			this.mode = 2;
			poi.enumElements(this, null);

			// Replace old images by new ones
			this.mode = 3;
			poi.enumElements(this, null);

			// Mark OI to reload
			poi.oiLoadFlags |= COI.OILF_TORELOAD;
		},
		enumerate:    function (num)
		{
			switch (this.mode)
			{
				case 0:
					if (num > this.dwMax)
						this.dwMax = num;
					return -1;
				case 1:
					this.pImages[num] = 1;
					return -1;
				case 2:
					this.app.imageBank.delImage(num);
					return -1;
				case 3:
					var image = this.app.imageBank.getImageFromHandle(this.pImages[num]);
					image.useCount++;
					return this.pImages[num];
			}
			return -1;
		}
	}
	CServices.performReplacement = function (app, image, sourceColor, destColor)
	{
		var canvas = document.createElement("canvas");
		canvas.width = image.width;
		canvas.height = image.height;
		var context = canvas.getContext("2d");
		if (image.mosaic == 0)
		{
			context.drawImage(image.img, 0, 0);
		}
		else
		{
			context.drawImage(app.imageBank.mosaics[image.mosaic],
				image.mosaicX, image.mosaicY,
				image.width, image.height, 0, 0,
				image.width, image.height);
		}
		var imageData = context.getImageData(0, 0, image.width, image.height);
		var newR = (destColor >> 16) & 0xFF;
		var newG = (destColor >> 8) & 0xFF;
		var newB = destColor & 0xFF;
		var oldR = (sourceColor >> 16) & 0xFF;
		var oldG = (sourceColor >> 8) & 0xFF;
		var oldB = sourceColor & 0xFF;
		var index, x, y;
		for (y = 0; y < image.height; y++)
		{
			for (x = 0; x < image.width; x++)
			{
				index = (y * image.width + x) * 4;
				if (imageData.data[index] == oldR && imageData.data[index + 1] == oldG && imageData.data[index + 2] == oldB)
				{
					imageData.data[index] = newR;
					imageData.data[index + 1] = newG;
					imageData.data[index + 2] = newB;
				}
			}
		}
		context.putImageData(imageData, 0, 0);
		var newImage = new CImage();
		newImage.app = app;
		newImage.width = image.width;
		newImage.height = image.height;
		newImage.xSpot = image.xSpot;
		newImage.ySpot = image.ySpot;
		newImage.xAP = image.xAP;
		newImage.yAP = image.yAP;
		newImage.useCount = 0;
		newImage.img = canvas;
		newImage.maskNormal = image.maskNormal;
		newImage.maskPlatform = image.maskPlatform;
		newImage.maskRotation = image.maskRotation;

		return newImage;
	}

	// Graphic font
	// ---------------------------------------------------------
	CGraphicFont.FONTFLAG_ITALIC = 0x0001;
	CGraphicFont.FONTFLAG_UNDERLINE = 0x0002;
	CGraphicFont.FONTFLAG_BOLD = 0x0004;
	CGraphicFont.FLAG_PRIORITY = 0x0008;
	function CGraphicFont()
	{
		this.characters = null;
		this.width = 0;
		this.height = 0;
		this.image = null;
		this.color = 0;
		this.flags = 0;
		this.fontName = null;
		this.fontHeight = 0;
		this.fontFlags = 0;
		this.interline = 0;
		this.interchar = 0;
		this.nChars = 0;
		this.charWidths = null;
		this.isGraphic = true;
	}

	CGraphicFont.prototype =
	{
		compareFont: function (font)
		{
			if (this.fontName != font.lfFaceName)
				return false;
			if (this.fontHeight != font.lfHeight)
				return false;
			var b1 = (this.fontFlags & CGraphicFont.FONTFLAG_ITALIC) != 0;
			var b2 = (font.lfItalic) != 0;
			if (b1 != b2)
				return false;
			b1 = (this.fontFlags & CGraphicFont.FONTFLAG_BOLD) != 0;
			b2 = (font.lfWeight) > 400;
			if (b1 != b2)
				return false;
			return true;
		},

		getHeight: function () {
		    return this.height + this.interline;
		},

		measureText: function (s)
		{
			var w = 0;
			var l = s.length;
			var n, index;
			for (n = 0; n < l; n++)
			{
				index = this.characters.indexOf(s.charAt(n));
				if (index >= 0)
				{
					w += this.charWidths[index] + this.interchar;
				}
				else
				{
					w += this.width;
				}
			}
			return w;
		},

		measureChar: function (c)
		{
			var w;
			var index = characters.indexOf(String.fromCharCode(c));
			if (index >= 0)
				w = this.charWidths[index] + this.interchar;
			else
				w = this.width;
			return w;
		},

		fillText: function (context, s, x, y)
		{
			var l = s.length;
			var n, xs, ys, index, col, line, c;

			var image = this.image;

			if ((this.flags & CGraphicFont.FLAG_PRIORITY) == 0)
			{
				for (n = 0; n < l; n++)
				{
					index = this.characters.indexOf(s.charAt(n));
					if (index >= 0)
					{
						line = Math.floor(index / this.nChars);
						col = index - (line * this.nChars);
						ys = line * (this.height + 1);
						xs = col * (this.width + 1);

						if (image.mosaic == 0)
						{
						    context.drawImage(image.img, xs, ys, this.width, this.height, Math.round(x), Math.round(y), this.width, this.height);
						}
						else
						{
							context.drawImage(image.app.imageBank.mosaics[image.mosaic],
								xs + image.mosaicX, ys + image.mosaicY, this.width, this.height,
								Math.round(x), Math.round(y), this.width, this.height);
						}
						x += this.charWidths[index] + this.interchar;
					}
					else
					{
						context.fillStyle = CServices.getColorString(this.color);
						context.fillRect(x, y, this.width, this.height);
						x += this.width;
					}
				}
			}
			else
			{
				x += this.measureText(s);
				for (n = l - 1; n >= 0; n--)
				{
					index = this.characters.indexOf(s.charAt(n));
					if (index >= 0)
					{
						x -= (this.charWidths[index] + this.interchar);
						line = index / this.nChars;
						col = index - (line * this.nChars);
						ys = line * (this.height + 1);
						xs = col * (this.width + 1);
						if (image.mosaic == 0)
						{
						    context.drawImage(image.img, xs, ys, this.width, this.height, Math.round(x), Math.round(y), this.width, this.height);
						}
						else
						{
							context.drawImage(image.app.imageBank.mosaics[image.mosaic],
								xs + image.mosaicX, ys + image.mosaicY, this.width, this.height,
								Math.round(x), Math.round(y), this.width, this.height);
						}
					}
					else
					{
						x -= this.width;
						context.fillStyle = CServices.getColorString(this.color);
						context.fillRect(x, y, this.width, this.height);
					}
				}
			}
		}
	}

	// OBJECT SELECTION CLASS
	// ------------------------------------------------------------------------------
	function ObjectSelection(runApp)
	{
		this.rhPtr = runApp;
		this.run = this.rhPtr.run;
		this.eventProgram = this.run.rhEvtProg;
		this.ObjectList = this.run.rhObjectList;				//get a pointer to the mmf object list
		this.OiList = this.run.rhOiList;						//get a pointer to the mmf object info list
		this.QualToOiList = this.eventProgram.qualToOiList;	//get a pointer to the mmf qualifier to Oi list
	}
	ObjectSelection.prototype =
	{
		//Selects *all* objects of the given object-type
		selectAll:                 function (OiList)
		{
			var pObjectInfo = this.OiList[OiList];
			pObjectInfo.oilNumOfSelected = pObjectInfo.oilNObjects;
			pObjectInfo.oilListSelected = pObjectInfo.oilObject;
			pObjectInfo.oilEventCount = this.eventProgram.rh2EventCount;

			var i = pObjectInfo.oilObject;
			while ((i & 0x80000000) == 0)
			{
				var pObject = this.ObjectList[i];
				pObject.hoNextSelected = pObject.hoNumNext;
				i = pObject.hoNumNext;
			}
		},

		//Resets all objects of the given object-type
		selectNone:                function (OiList)
		{
			var pObjectInfo = this.OiList[OiList];
			if (pObjectInfo == null)
				return;
			pObjectInfo.oilNumOfSelected = 0;
			pObjectInfo.oilListSelected = -1;
			pObjectInfo.oilEventCount = this.eventProgram.rh2EventCount;
		},

		//Resets the SOL and inserts only one given object
		selectOneObject:           function (object)
		{
			var pObjectInfo = object.hoOiList;
			pObjectInfo.oilNumOfSelected = 1;
			pObjectInfo.oilEventCount = this.eventProgram.rh2EventCount;
			pObjectInfo.oilListSelected = object.hoNumber;
			this.ObjectList[object.hoNumber].hoNextSelected = -1;
		},

		//Resets the SOL and inserts the given list of objects
		selectObjects:             function (OiList, objects)
		{
			var pObjectInfo = this.OiList[OiList];

			if (pObjectInfo == null)
				return;

			pObjectInfo.oilNumOfSelected = objects.length;
			pObjectInfo.oilEventCount = eventProgram.rh2EventCount;

			if (objects.length == 0)
				return;

			var i = 0;
			var prevNumber = objects[i].hoNumber;
			pObjectInfo.oilListSelected = prevNumber;
			while (i < objects.length)
			{
				currentNumber = objects[i++].hoNumber;
				this.ObjectList[prevNumber].hoNextSelected = currentNumber;
				prevNumber = currentNumber;
			}
			this.ObjectList[prevNumber].hoNextSelected = -1;
		},

		//Run a custom filter on the SOL (via function callback)
		filterObjects:             function (rdPtr, OiList, negate, filter)
		{
			if ((OiList & 0x8000) != 0)
			{
				return ((this.filterQualifierObjects(rdPtr, OiList & 0x7FFF, negate, filter) ? 1 : 0) ^ (negate ? 1 : 0)) != 0;
			}
			return ((this.filterNonQualifierObjects(rdPtr, OiList, negate, filter) ? 1 : 0) ^ (negate ? 1 : 0)) != 0;
		},

		//Filter qualifier objects
		filterQualifierObjects:    function (rdPtr, OiList, negate, filter)
		{
			var CurrentQualToOi = this.QualToOiList[OiList];

			var hasSelected = false;
			var i = 0;

			while (i < CurrentQualToOi.qoiList.length)
			{
				var CurrentOi = CurrentQualToOi.qoiList[i + 1];
				hasSelected = (((hasSelected ? 1 : 0) |
					(this.filterNonQualifierObjects(rdPtr, CurrentOi, negate, filter) ? 1 : 0))) != 0;

				i += 2;
			}
			return hasSelected;
		},

		//Filter normal objects
		filterNonQualifierObjects: function (rdPtr, OiList, negate, filter)
		{
			var pObjectInfo = this.OiList[OiList];
			if (pObjectInfo == null)
				return false;
			var hasSelected = false;
			if (pObjectInfo.oilEventCount != this.eventProgram.rh2EventCount)
			{
				this.selectAll(OiList);	//The SOL is invalid, must reset.
			}

			//If SOL is empty
			if (pObjectInfo.oilNumOfSelected <= 0)
			{
				return false;
			}

			var firstSelected = -1;
			var count = 0;
			var current = pObjectInfo.oilListSelected;
			var previous = null;

			while ((current & 0x80000000) == 0)
			{
				var pObject = this.ObjectList[current];
				var filterResult = filter(rdPtr, pObject);
				var useObject = ((filterResult ? 1 : 0) ^ (negate ? 1 : 0)) != 0;
				hasSelected = ((hasSelected ? 1 : 0) | (useObject ? 1 : 0)) != 0;

				if (useObject)
				{
					if (firstSelected == -1)
					{
						firstSelected = current;
					}

					if (previous != null)
					{
						previous.hoNextSelected = current;
					}

					previous = pObject;
					count++;
				}
				current = pObject.hoNextSelected;
			}
			if (previous != null)
			{
				previous.hoNextSelected = -1;
			}

			pObjectInfo.oilListSelected = firstSelected;
			pObjectInfo.oilNumOfSelected = count;

			return hasSelected;
		},

		//Return the number of selected objects for the given object-type
		getNumberOfSelected:       function (OiList)
		{
			if ((OiList & 0x8000) != 0)
			{
				OiList &= 0x7FFF;	//Mask out the qualifier part
				var numberSelected = 0;

				var CurrentQualToOi = this.QualToOiList[OiList];

				var i = 0;
				while (i < CurrentQualToOi.qoiList.length)
				{
					var CurrentOi = this.OiList[CurrentQualToOi.qoiList[i + 1]];
					numberSelected += CurrentOi.oilNumOfSelected;
					i += 2;
				}
				return numberSelected;
			}
			else
			{
				var pObjectInfo = this.OiList[OiList];
				return pObjectInfo.oilNumOfSelected;
			}
		},

		objectIsOfType: function (obj, OiList)
		{
			if ((OiList & 0x8000) != 0)
			{
				OiList &= 0x7FFF;	//Mask out the qualifier part
				var CurrentQualToOi = this.QualToOiList[OiList];

				var i = 0;
				while (i < CurrentQualToOi.qoiList.length)
				{
					var CurrentOi = this.OiList[CurrentQualToOi.qoiList[i + 1]];
					if (CurrentOi.oilOi == obj.hoOi)
						return true;
					i += 2;
				}
				return false;
			}
			return (obj.hoOi == this.OiList[OiList].oilOi);
		},

		//Returns the object-info structure from a given object-type
		GetOILFromOI:   function (Oi)
		{
			for (i = 0; i < this.run.rhMaxOI; ++i)
			{
				var oil = this.OiList[i];
				if (oil.oilOi == Oi)
					return oil;
			}
			return null;
		}
	}


	// function decode_b64(d,b,c,u,r,q,x){b="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";for(r=q=x='';c=d.charAt(x++);~c&&(u=q%4?u*64+c:c,q++%4)?r+=String.fromCharCode(255&u>>(-2*q&6)):0)c=b.indexOf(c);return r}
	// function encode_b64(a,b,c,d,e,f){b="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";c="=";for(d=f='';e&=3,a.charAt(d++)||(b='=',e);f+=b.charAt(63&c>>++e*2))c=c<<8|a.charCodeAt(d-=!e);return f}


	//----------------------------------------------------------------------------------
	//
	// CTokenizer
	//
	//----------------------------------------------------------------------------------
	function CTokenizer(text, delimiter) {
	    this.tokens = new CArrayList();

	    var oldPos = 0;
	    var pos = text.indexOf(delimiter);

	    // Special case: if delimiter = \n, then remove \r from end of tokens
	    if (delimiter.length == 1 && delimiter.charCodeAt(0) == 10) {
	        while (pos >= 0) {
	            if (pos > oldPos) {
	                var str = text.substring(oldPos, pos);
	                if (str.length > 0 && str.charCodeAt(str.length - 1) == 13)
	                    str = str.substr(0, str.length - 1);
	                this.tokens.add(str);
	            }
	            oldPos = pos + delimiter.length;
	            pos = text.indexOf(delimiter, oldPos);
	        }

	        if (text.length > oldPos) {
	            var str = text.substring(oldPos, text.length);
	            if (str.length > 0 && str.charCodeAt(str.length - 1) == 13)
	                str = str.substr(0, str.length - 1);
	            this.tokens.add(str);
	        }
	    }
	    else {
	        while (pos >= 0) {
	            if (pos > oldPos) {
	                this.tokens.add(text.substring(oldPos, pos));
	            }
	            oldPos = pos + delimiter.length;
	            pos = text.indexOf(delimiter, oldPos);
	        }

	        if (text.length > oldPos) {
	            this.tokens.add(text.substring(oldPos, text.length));
	        }
	    }

	    this.numToken = 0;
	}
	CTokenizer.prototype =
	{
	    countTokens: function () {
	        return this.tokens.size();
	    },
	    nextToken: function () {
	        if (this.numToken < this.tokens.size()) {
	            var s = this.tokens.get(this.numToken++);
	            if (s == null) {
	                return "";
	            }
	            return s;
	        }
	        return "";
	    }
	}

	// CAct object
	// ----------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 * 
	 * Permission is hereby granted to any person obtaining a legal copy 
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for 
	 * debugging, optimizing, or customizing applications created with 
	 * Clickteam Multimedia Fusion 2. 
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	CAct.ACTFLAGS_REPEAT = 0x0001;
	CAct.ACT_EXTSETFRICTION = (68 << 8);
	CAct.ACT_EXTSETELASTICITY = (69 << 8);
	CAct.ACT_EXTAPPLYIMPULSE = (70 << 8);
	CAct.ACT_EXTAPPLYANGULARIMPULSE = (71 << 8);
	CAct.ACT_EXTAPPLYFORCE = (72 << 8);
	CAct.ACT_EXTAPPLYTORQUE = (73 << 8);
	CAct.ACT_EXTSETLINEARVELOCITY = (74 << 8);
	CAct.ACT_EXTSETANGULARVELOCITY = (75 << 8);
	CAct.ACT_EXTFOREACH = (76 << 8);
	CAct.ACT_EXTFOREACH2 = (77 << 8);
	CAct.ACT_EXTSTOPFORCE = (78 << 8);
	CAct.ACT_EXTSTOPTORQUE = (79 << 8);
	CAct.ACT_EXTSETDENSITY = (80 << 8);
	CAct.ACT_EXTSETGRAVITYSCALE = (81 << 8);
	CAct.ACT_STARTLOOP = ((14 << 16) | 0xFFFF);
	CAct.create = function (app)
	{
	    var bSetVarGConst = false;
	    var bAddVarGConst = false;
	    var bSubVarGConst = false;
	    var bExtSetVar = false;
	    var bExtAddVar = false;
	    var bExtSubVar = false;
	    var bExtSetFlag = false;
	    var bExtClrFlag = false;
	    var bExtChgFlag = false;

	    var debut = app.file.getFilePointer();

		var size = app.file.readAShort()
		var act = null;
		var c = app.file.readAInt();
		switch (c)
		{
			case ((0 << 16) | 0xFFFF):
				act = new ACT_SKIP();
				break;
			case ((1 << 16) | 0xFFFF):		// ACT_SKIPMONITOR			
				act = new ACT_SKIP();
				break;
			case ((3 << 16) | 0xFFFF):
				act = new ACT_SETVARG();
				break;
			case ((4 << 16) | 0xFFFF):
				act = new ACT_SUBVARG();
				break;
			case ((5 << 16) | 0xFFFF):
				act = new ACT_ADDVARG();
				break;
			case ((6 << 16) | 0xFFFF):
				act = new ACT_GRPACTIVATE();
				break;
			case ((7 << 16) | 0xFFFF):
				act = new ACT_GRPDEACTIVATE();
				break;
			case ((14 << 16) | 0xFFFF):
				act = new ACT_STARTLOOP();
				break;
			case ((15 << 16) | 0xFFFF):
				act = new ACT_STOPLOOP();
				break;
			case ((16 << 16) | 0xFFFF):
				act = new ACT_SETLOOPINDEX();
				break;
			case ((17 << 16) | 0xFFFF):
				act = new ACT_RANDOMIZE();
				break;
			case ((19 << 16) | 0xFFFF):
				act = new ACT_SETGLOBALSTRING();
				break;
			case ((23 << 16) | 0xFFFF):
				act = new ACT_SKIP();
				break;
			case ((24 << 16) | 0xFFFF):
				act = new ACT_SKIP();
				break;
		    case ((27 << 16) | 0xFFFF):
		        act = new ACT_SETVARGCONST();
		        bSetVarGConst = true;
		        break;
		    case ((28 << 16) | 0xFFFF):
		        act = new ACT_SETVARG();
		        break;
		    case ((29 << 16) | 0xFFFF):
		        act = new ACT_SETVARGCONST();
		        bSetVarGConst = true;
		        break;
		    case ((30 << 16) | 0xFFFF):
		        act = new ACT_SETVARG();
		        break;
		    case ((31 << 16) | 0xFFFF):
		        act = new ACT_ADDVARGCONST();
		        bAddVarGConst = true;
		        break;
		    case ((32 << 16) | 0xFFFF):
		        act = new ACT_ADDVARG();
		        break;
		    case ((33 << 16) | 0xFFFF):
		        act = new ACT_ADDVARGCONST();
		        bAddVarGConst = true;
		        break;
		    case ((34 << 16) | 0xFFFF):
		        act = new ACT_ADDVARG();
		        break;
		    case ((35 << 16) | 0xFFFF):
		        act = new ACT_SUBVARGCONST();
		        bSubVarGConst = true;
		        break;
		    case ((36 << 16) | 0xFFFF):
		        act = new ACT_SUBVARG();
		        break;
		    case ((37 << 16) | 0xFFFF):
		        act = new ACT_SUBVARGCONST();
		        bSubVarGConst = true;
		        break;
		    case ((38 << 16) | 0xFFFF):
		        act = new ACT_SUBVARG();
		        break;
		    case ((0 << 16) | 0xFFFE):
				act = new ACT_PLAYSAMPLE();
				break;
			case ((1 << 16) | 0xFFFE):
				act = new ACT_STOPSAMPLE();
				break;
			case ((4 << 16) | 0xFFFE):
				act = new ACT_PLAYLOOPSAMPLE();
				break;
			case ((6 << 16) | 0xFFFE):
				act = new ACT_STOPSPESAMPLE();
				break;
			case ((7 << 16) | 0xFFFE):
				act = new ACT_PAUSESAMPLE();
				break;
			case ((8 << 16) | 0xFFFE):
				act = new ACT_RESUMESAMPLE();
				break;
			case ((11 << 16) | 0xFFFE):
				act = new ACT_PLAYCHANNEL();
				break;
			case ((12 << 16) | 0xFFFE):
				act = new ACT_PLAYLOOPCHANNEL();
				break;
			case ((13 << 16) | 0xFFFE):
				act = new ACT_PAUSECHANNEL();
				break;
			case ((14 << 16) | 0xFFFE):
				act = new ACT_RESUMECHANNEL();
				break;
			case ((15 << 16) | 0xFFFE):
				act = new ACT_STOPCHANNEL();
				break;
			case ((16 << 16) | 0xFFFE):
				act = new ACT_SETCHANNELPOS();
				break;
			case ((17 << 16) | 0xFFFE):
				act = new ACT_SETCHANNELVOL();
				break;
			case ((18 << 16) | 0xFFFE):				// SETCHANNELPAN
				act = new ACT_SKIP();
				break;
			case ((19 << 16) | 0xFFFE):
				act = new ACT_SETSAMPLEPOS();
				break;
			case ((20 << 16) | 0xFFFE):
				act = new ACT_SETSAMPLEMAINVOL();
				break;
			case ((21 << 16) | 0xFFFE):
				act = new ACT_SETSAMPLEVOL();
				break;
			case ((22 << 16) | 0xFFFE):
				act = new ACT_SKIP();
				break;
			case ((23 << 16) | 0xFFFE):
				act = new ACT_SKIP();
				break;
			case ((24 << 16) | 0xFFFE):
				act = new ACT_PAUSEALLCHANNELS();
				break;
			case ((25 << 16) | 0xFFFE):
				act = new ACT_RESUMEALLCHANNELS();
				break;
			case ((30 << 16) | 0xFFFE):
				act = new ACT_LOCKCHANNEL();
				break;
			case ((31 << 16) | 0xFFFE):
				act = new ACT_UNLOCKCHANNEL();
				break;
			case ((32 << 16) | 0xFFFE):
				act = new ACT_SETCHANNELFREQ();
				break;
			case ((33 << 16) | 0xFFFE):
				act = new ACT_SETSAMPLEFREQ();
				break;
			case ((0 << 16) | 0xFFFD):
				act = new ACT_NEXTLEVEL();
				break;
			case ((1 << 16) | 0xFFFD):
				act = new ACT_PREVLEVEL();
				break;
			case ((2 << 16) | 0xFFFD):
				act = new ACT_GOLEVEL();
				break;
			case ((3 << 16) | 0xFFFD):
				act = new ACT_PAUSEKEY();
				break;
			case ((4 << 16) | 0xFFFD):
				act = new ACT_ENDGAME();
				break;
			case ((5 << 16) | 0xFFFD):
				act = new ACT_RESTARTGAME();
				break;
			case ((6 << 16) | 0xFFFD):
				act = new ACT_RESTARTLEVEL();
				break;
			case ((7 << 16) | 0xFFFD):
				act = new ACT_CDISPLAY();
				break;
			case ((8 << 16) | 0xFFFD):
				act = new ACT_CDISPLAYX();
				break;
			case ((9 << 16) | 0xFFFD):
				act = new ACT_CDISPLAYY();
				break;
			case ((14 << 16) | 0xFFFD):
				act = new ACT_FULLSCREENMODE();
				break;
			case ((15 << 16) | 0xFFFD):
				act = new ACT_WINDOWEDMODE();
				break;
			case ((16 << 16) | 0xFFFD):
				act = new ACT_SETFRAMERATE();
				break;
			case ((17 << 16) | 0xFFFD):
				act = new ACT_PAUSEKEY();
				break;
			case ((18 << 16) | 0xFFFD):
				act = new ACT_PAUSEANYKEY();
				break;
			case ((19 << 16) | 0xFFFD):
				act = new ACT_SETVSYNCON();
				break;
			case ((20 << 16) | 0xFFFD):
				act = new ACT_SETVSYNCOFF();
				break;
			case ((21 << 16) | 0xFFFD):
				act = new ACT_SETVIRTUALWIDTH();
				break;
			case ((22 << 16) | 0xFFFD):
				act = new ACT_SETVIRTUALHEIGHT();
				break;
			case ((23 << 16) | 0xFFFD):
				act = new ACT_SETFRAMEBDKCOLOR();
				break;
			case ((24 << 16) | 0xFFFD):
				act = new ACT_DELCREATEDBKDAT();
				break;
			case ((25 << 16) | 0xFFFD):
				act = new ACT_DELALLCREATEDBKD();
				break;
			case ((26 << 16) | 0xFFFD):
				act = new ACT_SETFRAMEWIDTH();
				break;
			case ((27 << 16) | 0xFFFD):
				act = new ACT_SETFRAMEHEIGHT();
				break;
			case ((31 << 16) | 0xFFFD):
				act = new ACT_PLAYDEMO();
				break;
			case ((32 << 16) | 0xFFFD): 		// ACT_SETFRAMEEFFECT				
				act = new ACT_SKIP();
				break;
			case ((33 << 16) | 0xFFFD):
				act = new ACT_SKIP();
				break;
			case ((34 << 16) | 0xFFFD):
				act = new ACT_SKIP();
				break;
			case ((35 << 16) | 0xFFFD):			// ACT_SETFRAMEALPHACOEF			
				act = new ACT_SKIP();
				break;
			case ((36 << 16) | 0xFFFD): 		// ACT_SETFRAMERGBCOEF				
				act = new ACT_SKIP();
				break;
			case ((0 << 16) | 0xFFFC):
				act = new ACT_SETTIMER();
				break;
			case ((1 << 16) | 0xFFFC):
				act = new ACT_EVENTAFTER();
				break;
			case ((2 << 16) | 0xFFFC):
				act = new ACT_NEVENTSAFTER();
				break;
			case ((0 << 16) | 0xFFFA):
				act = new ACT_HIDECURSOR();
				break;
			case ((1 << 16) | 0xFFFA):
				act = new ACT_SHOWCURSOR();
				break;
			case ((0 << 16) | 0xFFF9):
				act = new ACT_SETSCORE();
				break;
			case ((1 << 16) | 0xFFF9):
				act = new ACT_SETLIVES();
				break;
			case ((2 << 16) | 0xFFF9):
				act = new ACT_NOINPUT();
				break;
			case ((3 << 16) | 0xFFF9):
				act = new ACT_RESTINPUT();
				break;
			case ((4 << 16) | 0xFFF9):
				act = new ACT_ADDSCORE();
				break;
			case ((5 << 16) | 0xFFF9):
				act = new ACT_ADDLIVES();
				break;
			case ((6 << 16) | 0xFFF9):
				act = new ACT_SUBSCORE();
				break;
			case ((7 << 16) | 0xFFF9):
				act = new ACT_SUBLIVES();
				break;
			case ((8 << 16) | 0xFFF9):
				act = new ACT_SETINPUT();
				break;
			case ((9 << 16) | 0xFFF9):
				act = new ACT_SETINPUTKEY();
				break;
			case ((10 << 16) | 0xFFF9):
				act = new ACT_SETPLAYERNAME();
				break;
			case ((0 << 16) | 0xFFFB):
				act = new ACT_CREATE();
				break;
			case ((1 << 16) | 0xFFFB):
				act = new ACT_CREATEBYNAME();
				break;
			case (((80 + 0) << 16) | 3):
				act = new ACT_STRDESTROY();
				break;
			case (( (80 + 1) << 16) | 3):
				act = new ACT_STRDISPLAY();
				break;
			case (( (80 + 2) << 16) | 3):
				act = new ACT_STRDISPLAYDURING();
				break;
			case (( (80 + 3) << 16) | 3):
				act = new ACT_STRSETCOLOUR();
				break;
			case (( (80 + 4) << 16) | 3):
				act = new ACT_STRSET();
				break;
			case (( (80 + 5) << 16) | 3):
				act = new ACT_STRPREV();
				break;
			case (( (80 + 6) << 16) | 3):
				act = new ACT_STRNEXT();
				break;
			case (( (80 + 7) << 16) | 3):
				act = new ACT_STRDISPLAYSTRING();
				break;
			case (( (80 + 8) << 16) | 3):
				act = new ACT_STRSETSTRING();
				break;
			case (((80 + 0) << 16) | 2):
				act = new ACT_SPRPASTE();
				break;
			case (((80 + 1) << 16) | 2):
				act = new ACT_SPRFRONT();
				break;
			case (((80 + 2) << 16) | 2):
				act = new ACT_SPRBACK();
				break;
			case (((80 + 3) << 16) | 2):
				act = new ACT_SPRADDBKD();
				break;
			case (((80 + 4) << 16) | 2):
				act = new ACT_SPRREPLACECOLOR();
				break;
			case (((80 + 5) << 16) | 2):
				act = new ACT_SPRSETSCALE();
				break;
			case (((80 + 6) << 16) | 2):
				act = new ACT_SPRSETSCALEX();
				break;
			case (((80 + 7) << 16) | 2):
				act = new ACT_SPRSETSCALEY();
				break;
			case (((80 + 8) << 16) | 2):
				act = new ACT_SPRSETANGLE();
				break;
			case (( (80 + 0) << 16) | 7):
				act = new ACT_CSETVALUE();
				break;
			case (( (80 + 1) << 16) | 7):
				act = new ACT_CADDVALUE();
				break;
			case (( (80 + 2) << 16) | 7):
				act = new ACT_CSUBVALUE();
				break;
			case (( (80 + 3) << 16) | 7):
				act = new ACT_CSETMIN();
				break;
			case (( (80 + 4) << 16) | 7):
				act = new ACT_CSETMAX();
				break;
			case (( (80 + 5) << 16) | 7):
				act = new ACT_CSETCOLOR1();
				break;
			case (( (80 + 6) << 16) | 7):
				act = new ACT_CSETCOLOR2();
				break;
			case (( (80 + 0) << 16) | 4):
				act = new ACT_QASK();
				break;
			case (((80 + 0) << 16) | 9):
				act = new ACT_CCARESTARTAPP();
				break;
			case (((80 + 1) << 16) | 9):
				act = new ACT_CCARESTARTFRAME();
				break;
			case (((80 + 2) << 16) | 9):
				act = new ACT_CCANEXTFRAME();
				break;
			case (((80 + 3) << 16) | 9):
				act = new ACT_CCAPREVIOUSFRAME();
				break;
			case (((80 + 4) << 16) | 9):
				act = new ACT_CCAENDAPP();
				break;
			case (((80 + 6) << 16) | 9):
				act = new ACT_CCAJUMPFRAME();
				break;
			case (((80 + 7) << 16) | 9):
				act = new ACT_CCASETGLOBALVALUE();
				break;
			case (((80 + 8) << 16) | 9):
				act = new ACT_CCASHOW();
				break;
			case (((80 + 9) << 16) | 9):
				act = new ACT_CCAHIDE();
				break;
			case (((80 + 10) << 16) | 9):
				act = new ACT_CCASETGLOBALSTRING();
				break;
			case (((80 + 11) << 16) | 9):
				act = new ACT_CCAPAUSEAPP();
				break;
			case (((80 + 12) << 16) | 9):
				act = new ACT_CCARESUMEAPP();
				break;
			case (((80 + 13) << 16) | 9):
				act = new ACT_CCASETWIDTH();
				break;
			case (((80 + 14) << 16) | 9):
				act = new ACT_CCASETHEIGHT();
				break;

			    // Actions pour les objets extensions 
			default:
			{
				switch (c & 0xFFFF0000)
				{
					case (1 << 16):
						act = new ACT_EXTSETPOS();
						break;
					case (2 << 16):
						act = new ACT_EXTSETX();
						break;
					case (3 << 16):
						act = new ACT_EXTSETY();
						break;
					case (4 << 16):
						act = new ACT_EXTSTOP();
						break;
					case (5 << 16):
						act = new ACT_EXTSTART();
						break;
					case (6 << 16):
						act = new ACT_EXTSPEED();
						break;
					case (7 << 16):
						act = new ACT_EXTMAXSPEED();
						break;
					case (8 << 16):
						act = new ACT_EXTWRAP();
						break;
					case (9 << 16):
						act = new ACT_EXTBOUNCE();
						break;
					case (10 << 16):
						act = new ACT_EXTREVERSE();
						break;
					case (11 << 16):
						act = new ACT_EXTNEXTMOVE();
						break;
					case (12 << 16):
						act = new ACT_EXTPREVMOVE();
						break;
					case (13 << 16):
						act = new ACT_EXTSELMOVE();
						break;
					case (14 << 16):
						act = new ACT_EXTLOOKAT();
						break;
					case (15 << 16):
						act = new ACT_EXTSTOPANIM();
						break;
					case (16 << 16):
						act = new ACT_EXTSTARTANIM();
						break;
					case (17 << 16):
						act = new ACT_EXTFORCEANIM();
						break;
					case (18 << 16):
						act = new ACT_EXTFORCEDIR();
						break;
					case (19 << 16):
						act = new ACT_EXTFORCESPEED();
						break;
					case (20 << 16):
						act = new ACT_EXTRESTANIM();
						break;
					case (21 << 16):
						act = new ACT_EXTRESTDIR();
						break;
					case (22 << 16):
						act = new ACT_EXTRESTSPEED();
						break;
					case (23 << 16):
						act = new ACT_EXTSETDIR();
						break;
					case (24 << 16):
						act = new ACT_EXTDESTROY();
						break;
					case (25 << 16):
						act = new ACT_EXTSHUFFLE();
						break;
					case (26 << 16):
						act = new ACT_EXTHIDE();
						break;
					case (27 << 16):
						act = new ACT_EXTSHOW();
						break;
					case (28 << 16):
						act = new ACT_EXTDISPLAYDURING();
						break;
					case (29 << 16):
						act = new ACT_EXTSHOOT();
						break;
					case (30 << 16):
						act = new ACT_EXTSHOOTTOWARD();
						break;
					case (31 << 16):
						act = new ACT_EXTSETVAR();
						bExtSetVar = true;
						break;
					case (32 << 16):
						act = new ACT_EXTADDVAR();
						bExtAddVar = true;
						break;
					case (33 << 16):
						act = new ACT_EXTSUBVAR();
						bExtSubVar = true;
						break;
					case (34 << 16):
						act = new ACT_EXTDISPATCHVAR();
						break;
					case (35 << 16):
						act = new ACT_EXTSETFLAG();
						bExtSetFlag = true;
						break;
					case (36 << 16):
						act = new ACT_EXTCLRFLAG();
						bExtClrFlag = true;
						break;
					case (37 << 16):
						act = new ACT_EXTCHGFLAG();
						bExtChgFlag = true;
						break;
					case (38 << 16):
						act = new ACT_EXTINKEFFECT();
						break;
					case (39 << 16):
						act = new ACT_EXTSETSEMITRANSPARENCY();
						break;
					case (40 << 16):
						act = new ACT_EXTFORCEFRAME();
						break;
					case (41 << 16):
						act = new ACT_EXTRESTFRAME();
						break;
					case (42 << 16):
						act = new ACT_EXTSETACCELERATION();
						break;
					case (43 << 16):
						act = new ACT_EXTSETDECELERATION();
						break;
					case (44 << 16):
						act = new ACT_EXTSETROTATINGSPEED();
						break;
					case (45 << 16):
						act = new ACT_EXTSETDIRECTIONS();
						break;
					case (46 << 16):
						act = new ACT_EXTBRANCHNODE();
						break;
					case (47 << 16):
						act = new ACT_EXTSETGRAVITY();
						break;
					case (48 << 16):
						act = new ACT_EXTGOTONODE();
						break;
					case (49 << 16):
						act = new ACT_EXTSETVARSTRING();
						break;
					case (50 << 16):
						act = new ACT_EXTSETFONTNAME();
						break;
					case (51 << 16):
						act = new ACT_EXTSETFONTSIZE();
						break;
					case (52 << 16):
						act = new ACT_EXTSETBOLD();
						break;
					case (53 << 16):
						act = new ACT_EXTSETITALIC();
						break;
					case (54 << 16):
						act = new ACT_EXTSETUNDERLINE();
						break;
					case (55 << 16):
						act = new ACT_SKIP();
						break;
					case (56 << 16):
						act = new ACT_EXTSETTEXTCOLOR();
						break;
					case (57 << 16):
						act = new ACT_EXTSPRFRONT();
						break;
					case (58 << 16):
						act = new ACT_EXTSPRBACK();
						break;
					case (59 << 16):
						act = new ACT_EXTMOVEBEFORE();
						break;
					case (60 << 16):
						act = new ACT_EXTMOVEAFTER();
						break;
					case (61 << 16):
						act = new ACT_EXTMOVETOLAYER();
						break;
					case (62 << 16):				//  ACT_EXTADDTODEBUGGER		
						act = new ACT_SKIP();
						break;
					case (63 << 16):
						act = new ACT_EXTSETEFFECT();
						break;
					case (64 << 16):  //  ACT_EXTSETEFFECTPARAM
						act = new ACT_SKIP();
						break;
					case (65 << 16):
						act = new ACT_EXTSETALPHACOEF();
						break;
					case (66 << 16):
						act = new ACT_EXTSETRGBCOEF();
						break;
					case (67 << 16):  // ACT_EXTSETEFFECTPARAMTEXTURE
						act = new ACT_SKIP();
						break;
					case (68 << 16):
						act = new ACT_EXTSETFRICTION();
						break;
					case (69 << 16):
						act = new ACT_EXTSETELASTICITY();
						break;
					case (70 << 16):
						act = new ACT_EXTAPPLYIMPULSE();
						break;
					case (71 << 16):
						act = new ACT_EXTAPPLYANGULARIMPULSE();
						break;
					case (72 << 16):
						act = new ACT_EXTAPPLYFORCE();
						break;
					case (73 << 16):
						act = new ACT_EXTAPPLYTORQUE();
						break;
					case (74 << 16):
						act = new ACT_EXTSETLINEARVELOCITY();
						break;
					case (75 << 16):
						act = new ACT_EXTSETANGULARVELOCITY();
						break;
					case (76 << 16):
						act = new ACT_EXTFOREACH();
						break;
					case (77 << 16):
						act = new ACT_EXTFOREACH2();
						break;
					case (78 << 16):
						act = new ACT_EXTSTOPFORCE();
						break;
					case (79 << 16):
						act = new ACT_EXTSTOPTORQUE();
						break;
				    default:
						act = new CActExtension();
						break;
				}
			}
		}

		if (act != null)
		{
			act.evtCode = c;
			act.evtOi = app.file.readShort();
			act.evtOiList = app.file.readShort();
			act.evtFlags = app.file.readAByte();
			act.evtFlags2 = app.file.readAByte();
			act.evtNParams = app.file.readAByte();
			act.evtDefType = app.file.readAByte();

			if (act.evtNParams > 0)
			{
				act.evtParams = new Array(act.evtNParams);
				var n;
				for (n = 0; n < act.evtNParams; n++)
				{
					act.evtParams[n] = CParam.create(app);
				}
			}

			// Optimization of operations on global values for constant values
			if (bSetVarGConst || bAddVarGConst || bSubVarGConst)
	        {
		        var pParam = act.evtParams[0];
		        act.num = pParam.value;

		        var pExp1 = act.evtParams[1];
		        act.value = pExp1.tokens[0].value;
			}

		    // Optimization of operations on alterable values for constant values
			if (bExtSetVar || bExtAddVar || bExtSubVar) {
			    var newAct = null;
			    var pParam = act.evtParams[0];
			    if (pParam.code != 53) {
			        // Value number = constant
			        var num = pParam.value;

			        // Parameter = simple constant?
			        var pExp1 = act.evtParams[1];
			        if (num >= 0 && pExp1.tokens.length == 2 && (pExp1.tokens[1].code <= 0 || pExp1.tokens[1].code >= 0x00140000)) {
			            // INT
			            if (pExp1.tokens[0].code == ((0 << 16) | 65535) || pExp1.tokens[0].code == ((23 << 16) | 65535)) {
			                if (bExtSetVar) {
			                    newAct = new ACT_EXTSETVARCONST();
			                    newAct.num = num;
			                    newAct.value = pExp1.tokens[0].value;
			                }
			                else if (bExtAddVar) {
			                    newAct = new ACT_EXTADDVARCONST();
			                    newAct.num = num;
			                    newAct.value = pExp1.tokens[0].value;
			                }
			                else if (bExtSubVar) {
			                    newAct = new ACT_EXTSUBVARCONST();
			                    newAct.num = num;
			                    newAct.value = pExp1.tokens[0].value;
			                }
			            }
			        }
			        if (newAct != null) {
			            newAct.evtCode = act.evtCode;
			            newAct.evtOi = act.evtOi;
			            newAct.evtOiList = act.evtOiList;
			            newAct.evtFlags = act.evtFlags;
			            newAct.evtFlags2 = act.evtFlags2;
			            newAct.evtNParams = act.evtNParams;
			            newAct.evtDefType = act.evtDefType;
			            newAct.evtParams = act.evtParams;

			            act = newAct;
			        }
			    }
			}

		    // Optimization of operations on alterable flags for constant flag numbers
			if (bExtSetFlag || bExtClrFlag || bExtChgFlag) {
			    var newAct = null;

			    // Flag number = simple constant?
			    var pExp = act.evtParams[0];
			    if (pExp.tokens.length == 2 && (pExp.tokens[1].code <= 0 || pExp.tokens[1].code >= 0x00140000) && pExp.tokens[0].code == ((0 << 16) | 65535)) {
			        if (bExtSetFlag) {
			            newAct = new ACT_EXTSETFLAGCONST();
			            newAct.mask = (1 << pExp.tokens[0].value);
			        }
			        else if (bExtClrFlag) {
			            newAct = new ACT_EXTCLRFLAGCONST();
			            newAct.mask = (1 << pExp.tokens[0].value);
			        }
			        else if (bExtChgFlag) {
			            newAct = new ACT_EXTCHGFLAGCONST();
			            newAct.mask = (1 << pExp.tokens[0].value);
			        }
			    }
			    if (newAct != null) {
			        newAct.evtCode = act.evtCode;
			        newAct.evtOi = act.evtOi;
			        newAct.evtOiList = act.evtOiList;
			        newAct.evtFlags = act.evtFlags;
			        newAct.evtFlags2 = act.evtFlags2;
			        newAct.evtNParams = act.evtNParams;
			        newAct.evtDefType = act.evtDefType;
			        newAct.evtParams = act.evtParams;

			        act = newAct;
			    }
			}
	    }
		app.file.seek(debut + size);
		return act;
	}
	function CAct()
	{
	}

	CLoop.FLFLAG_STOP = 0x0001;
	function CLoop()
	{
		this.flags = 0;
		this.name = null;
		this.index = 0;
	}

	function ACT_SKIP()
	{
	}
	ACT_SKIP.prototype =
	{
		execute: function (rhPtr)
		{
		}
	}
	// CUT

	// System object
	// ------------------------------------------------------------------
	function ACT_ADDVARG()
	{
	}
	ACT_ADDVARG.prototype =
	{
		execute: function (rhPtr)
		{
			var num;
			if (this.evtParams[0].code == 52)
				num = (rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1);
			else
				num = this.evtParams[0].value;
			var value = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			rhPtr.rhApp.addGlobalValueAt(num, value);
		}
	}
	// -- CUT

	function ACT_ADDVARGCONST()
	{
	}
	ACT_ADDVARGCONST.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.addGlobalValueAt(this.num, this.value);
		}
	}
	// CUT

	function ACT_GRPACTIVATE()
	{
	}
	ACT_GRPACTIVATE.prototype =
	{
		execute:     function (rhPtr)
		{
			var p = this.evtParams[0];
			var evg = p.pointer;
			var evgPtr = rhPtr.rhEvtProg.events[evg];
			var evtPtr = evgPtr.evgEvents[0];

			var grpPtr = evtPtr.evtParams[0];
			var bFlag = (grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_GROUPINACTIVE) != 0;
			grpPtr.grpFlags &= ~PARAM_GROUP.GRPFLAGS_GROUPINACTIVE;

			if (bFlag)
				this.grpActivate(rhPtr, evg);
		},
		grpActivate: function (rhPtr, evg)
		{
			var evgPtr = rhPtr.rhEvtProg.events[evg];
			var evtPtr = evgPtr.evgEvents[0];
			var grpPtr = evtPtr.evtParams[0];
			var cpt;
			var bQuit = false;

			if ((grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_PARENTINACTIVE) == 0)
			{
				evgPtr.evgFlags &= ~CEventGroup.EVGFLAGS_INACTIVE;

				for (evg++, bQuit = false, cpt = 1; ;)
				{
					evgPtr = rhPtr.rhEvtProg.events[evg];
					evtPtr = evgPtr.evgEvents[0];
					switch (evtPtr.evtCode)
					{
						case ((-10 << 16) | 65535):
							grpPtr = evtPtr.evtParams[0];
							if (cpt == 1)
								grpPtr.grpFlags &= ~PARAM_GROUP.GRPFLAGS_PARENTINACTIVE;
							if ((grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_GROUPINACTIVE) == 0)
							{
								evg = this.grpActivate(rhPtr, evg);
								continue;
							}
							else
								cpt++;
							break;
						case ((-11 << 16) | 65535):
							cpt--;
							if (cpt == 0)
							{
								evgPtr.evgFlags &= ~CEventGroup.EVGFLAGS_INACTIVE;
								bQuit = true;
								evg++;
							}
							break;
						case ((-23 << 16) | 65535):
							if (cpt == 1)
							{
								evgPtr.evgFlags &= ~CEventGroup.EVGFLAGS_INACTIVE;
								evgPtr.evgFlags &= ~CEventGroup.EVGFLAGS_ONCE;
							}
							break;
						default:
							if (cpt == 1)
								evgPtr.evgFlags &= ~CEventGroup.EVGFLAGS_INACTIVE;
							break;
					}
					if (bQuit)
						break;
					evg++;
				}
			}
			else
			{
				for (evg++, bQuit = false, cpt = 1; ; evg++)
				{
					evgPtr = rhPtr.rhEvtProg.events[evg];
					evtPtr = evgPtr.evgEvents[0];
					switch (evtPtr.evtCode)
					{
						case ((-10 << 16) | 65535):
							cpt++;
							break;
						case ((-11 << 16) | 65535):
							cpt--;
							if (cpt == 0)
							{
								bQuit = true;
								evg++;
							}
							break;
					}
					if (bQuit)
						break;
				}
			}
			return evg;
		}
	}
	// CUT

	function ACT_GRPDEACTIVATE()
	{
	}
	ACT_GRPDEACTIVATE.prototype =
	{
		execute:       function (rhPtr)
		{
			var p = this.evtParams[0];
			var evg = p.pointer;
			var evgPtr = rhPtr.rhEvtProg.events[evg];
			var evtPtr = evgPtr.evgEvents[0];

			var grpPtr = evtPtr.evtParams[0];
			var bFlag = (grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_GROUPINACTIVE) == 0;
			grpPtr.grpFlags |= PARAM_GROUP.GRPFLAGS_GROUPINACTIVE;

			if (bFlag == true && (grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_PARENTINACTIVE) == 0)
				this.grpDeactivate(rhPtr, evg);
		},
		grpDeactivate: function (rhPtr, evg)
		{
			var evgPtr = rhPtr.rhEvtProg.events[evg];
			var evtPtr = evgPtr.evgEvents[0];
			var grpPtr = evtPtr.evtParams[0];

			evgPtr.evgFlags |= CEventGroup.EVGFLAGS_INACTIVE;

			var cpt;
			var bQuit, bFlag;

			for (evg++, bQuit = false, cpt = 1; ;)
			{
				evgPtr = rhPtr.rhEvtProg.events[evg];
				evtPtr = evgPtr.evgEvents[0];
				switch (evtPtr.evtCode)
				{
					case ((-10 << 16) | 65535):
						grpPtr = evtPtr.evtParams[0];
						bFlag = (grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_PARENTINACTIVE) == 0;
						if (cpt == 1)
							grpPtr.grpFlags |= PARAM_GROUP.GRPFLAGS_PARENTINACTIVE;
						if (bFlag != false && (grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_GROUPINACTIVE) == 0)
						{
							evg = this.grpDeactivate(rhPtr, evg);
							continue;
						}
						else
							cpt++;
						break;
					case ((-11 << 16) | 65535):
						cpt--;
						if (cpt == 0)
						{
							evgPtr.evgFlags |= CEventGroup.EVGFLAGS_INACTIVE;
							bQuit = true;
							evg++;
						}
						break;
					default:
						if (cpt == 1)
							evgPtr.evgFlags |= CEventGroup.EVGFLAGS_INACTIVE;
						break;
				}
				if (bQuit)
					break;

				evg++;
			}
			return evg;
		}
	}
	// CUT

	function ACT_RANDOMIZE()
	{
	}
	ACT_RANDOMIZE.prototype =
	{
		execute: function (rhPtr)
		{
			var seed = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.rh3Graine = seed;
		}
	}
	// CUT

	function ACT_SETGLOBALSTRING()
	{
	}
	ACT_SETGLOBALSTRING.prototype =
	{
		execute: function (rhPtr)
		{
			var num;
			if (this.evtParams[0].code == 59)
				num = (rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1);
			else
				num = this.evtParams[0].value;

			var string = rhPtr.get_EventExpressionString(this.evtParams[1]);
			rhPtr.rhApp.setGlobalStringAt(num, string);
		}
	}
	// CUT

	function ACT_SETLOOPINDEX()
	{
	}
	ACT_SETLOOPINDEX.prototype =
	{
		execute: function (rhPtr)
		{
			var expression = this.evtParams[0];
			if (expression.tokens[0].code == CExp.EXP_LONG && expression.tokens[1].code == 0)
			{
				var number = rhPtr.get_EventExpressionInt(this.evtParams[1]);
				var pLoop = rhPtr.rh4FastLoops.get(expression.tokens[0].value);
				pLoop.index = number;
			}
			else
			{
				var name = rhPtr.get_EventExpressionString(this.evtParams[0]);
				if (name.length == 0)
					return;
				var number = rhPtr.get_EventExpressionInt(this.evtParams[1]);

				var pLoop;
				var n;
				for (n = 0; n < rhPtr.rh4FastLoops.size(); n++)
				{
					pLoop = rhPtr.rh4FastLoops.get(n);
					if (CServices.compareStringsIgnoreCase(pLoop.name, name))
					{
						pLoop.index = number;
						return;
					}
				}
			}
		}
	}
	// CUT

	function ACT_SETVARG()
	{
	}
	ACT_SETVARG.prototype =
	{
		execute: function (rhPtr)
		{
			var num;
			if (this.evtParams[0].code == 52)
				num = (rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1);
			else
				num = this.evtParams[0].value;

			var value = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			rhPtr.rhApp.setGlobalValueAt(num, value);
		}
	}
	// -- CUT

	function ACT_SETVARGCONST()
	{
	}
	ACT_SETVARGCONST.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.setGlobalValueAt(this.num, this.value);
		}
	}
	// CUT

	function ACT_STOPLOOP()
	{
	}
	ACT_STOPLOOP.prototype =
	{
		execute: function (rhPtr)
		{
			var expression = this.evtParams[0];
			if (expression.tokens[0].code == CExp.EXP_LONG && expression.tokens[1].code == 0)
			{
				var pLoop = rhPtr.rh4FastLoops.get(expression.tokens[0].value);
				pLoop.flags |= CLoop.FLFLAG_STOP;
			}
			else
			{
				var name = rhPtr.get_EventExpressionString(this.evtParams[0]);
				if (name.length == 0)
					return;

				var pLoop;
				var n;
				for (n = 0; n < rhPtr.rh4FastLoops.size(); n++)
				{
					pLoop = rhPtr.rh4FastLoops.get(n);
					if (CServices.compareStringsIgnoreCase(pLoop.name, name))
						pLoop.flags |= CLoop.FLFLAG_STOP;
				}
			}
		}
	}
	// CUT

	function ACT_SUBVARG()
	{
	}
	ACT_SUBVARG.prototype =
	{
		execute: function (rhPtr)
		{
			var num;
			if (this.evtParams[0].code == 52)
				num = (rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1);
			else
				num = this.evtParams[0].value;

			var value = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			rhPtr.rhApp.addGlobalValueAt(num, -value);
		}
	}
	// -- CUT

	function ACT_SUBVARGCONST()
	{
	}
	ACT_SUBVARGCONST.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.addGlobalValueAt(this.num, -this.value);
		}
	}
	// CUT

	function ACT_STARTLOOP()
	{
	}
	ACT_STARTLOOP.prototype =
	{
		execute: function (rhPtr)
		{
			var name;
			var number;

			// Accelerated handling
			if (rhPtr.rhEvtProg.complexOnLoop == false && this.evtParams[0].fastFastLoop)
			{
				var infoLoop = rhPtr.rh4PosOnLoop[this.evtParams[0].fastFastLoop - 1];
				if (infoLoop.m_bOR == false)
				{
					//name = infoLoop.name;
					number = Math.floor(rhPtr.get_EventExpressionInt(this.evtParams[1]));

					var pLoop = rhPtr.rh4FastLoops.get(infoLoop.fastLoopIndex);
					pLoop.flags &= ~CLoop.FLFLAG_STOP;

					var bInfinite = false;
					if (number < 0)
					{
						bInfinite = true;
						number = 10;
					}
					var save = rhPtr.rh4CurrentFastLoop;
					var actionLoop = rhPtr.rhEvtProg.rh2ActionLoop;
					var actionLoopCount = rhPtr.rhEvtProg.rh2ActionLoopCount;
					var eventGroup = rhPtr.rhEvtProg.rhEventGroup;
					for (pLoop.index = 0; pLoop.index < number; pLoop.index++)
					{
						rhPtr.rh4CurrentFastLoop = pLoop.name;
						rhPtr.rhEvtProg.rh2ActionOn = false;
						rhPtr.rhEvtProg.computeEventFastLoopList(infoLoop.pointers);
						if ((pLoop.flags & CLoop.FLFLAG_STOP) != 0)
							break;
						if (bInfinite)
							number = pLoop.index + 10;
					}
					rhPtr.rhEvtProg.rh2ActionLoopCount = actionLoopCount;
					rhPtr.rhEvtProg.rh2ActionLoop = actionLoop;
					rhPtr.rh4CurrentFastLoop = save;
					rhPtr.rhEvtProg.rh2ActionOn = true;

	//				rhPtr.rh4FastLoops.removeIndex(index);
					return;
				}
			}

			// Normal handling
			name = rhPtr.get_EventExpressionString(this.evtParams[0]);
			if (name.length == 0)
				return;
			number = Math.floor(rhPtr.get_EventExpressionInt(this.evtParams[1]));

			var index = rhPtr.addFastLoop(name);
			var pLoop = rhPtr.rh4FastLoops.get(index);
			pLoop = rhPtr.rh4FastLoops.get(index);
			pLoop.flags &= ~CLoop.FLFLAG_STOP;

			var bInfinite = false;
			if (number < 0)
			{
				bInfinite = true;
				number = 10;
			}
			var save = rhPtr.rh4CurrentFastLoop;
			var actionLoop = rhPtr.rhEvtProg.rh2ActionLoop;
			var actionLoopCount = rhPtr.rhEvtProg.rh2ActionLoopCount;
			var eventGroup = rhPtr.rhEvtProg.rhEventGroup;
			for (pLoop.index = 0; pLoop.index < number; pLoop.index++)
			{
				rhPtr.rh4CurrentFastLoop = pLoop.name;
				rhPtr.rhEvtProg.rh2ActionOn = false;
				rhPtr.rhEvtProg.handle_GlobalEvents(((-16 << 16) | 65535));
				if ((pLoop.flags & CLoop.FLFLAG_STOP) != 0)
					break;
				if (bInfinite)
					number = pLoop.index + 10;
			}
			//			rhPtr.rhEvtProg.rhEventGroup=eventGroup;
			rhPtr.rhEvtProg.rh2ActionLoopCount = actionLoopCount;
			rhPtr.rhEvtProg.rh2ActionLoop = actionLoop;
			rhPtr.rh4CurrentFastLoop = save;
			rhPtr.rhEvtProg.rh2ActionOn = true;

			//rhPtr.rh4FastLoops.removeIndex(index);
		}
	}
	// CUT


	// Keyboard object
	// ------------------------------------------------------------------
	function ACT_HIDECURSOR()
	{
	}
	ACT_HIDECURSOR.prototype =
	{
		execute: function (rhPtr)
		{
			if (rhPtr.rhMouseUsed == 0)
				rhPtr.hideMouse();
		}
	}
	// CUT

	function ACT_SHOWCURSOR()
	{
	}
	ACT_SHOWCURSOR.prototype =
	{
		execute: function (rhPtr)
		{
			if (rhPtr.rhMouseUsed == 0)
				rhPtr.showMouse();
		}
	}
	// CUT

	// Speaker object
	// ------------------------------------------------------------------
	function ACT_LOCKCHANNEL()
	{
	}
	ACT_LOCKCHANNEL.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.rhApp.soundPlayer.lockChannel(channel - 1);
		}
	}
	// CUT

	function ACT_PAUSEALLCHANNELS()
	{
	}
	ACT_PAUSEALLCHANNELS.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.soundPlayer.pause();
		}
	}
	// CUT

	function ACT_PAUSECHANNEL()
	{
	}
	ACT_PAUSECHANNEL.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.rhApp.soundPlayer.pauseChannel(channel - 1);
		}
	}
	// CUT

	function ACT_PAUSESAMPLE()
	{
	}
	ACT_PAUSESAMPLE.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			rhPtr.rhApp.soundPlayer.pauseSample(p.sndHandle);
		}
	}
	// CUT

	function ACT_PLAYCHANNEL()
	{
	}
	ACT_PLAYCHANNEL.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			var bPrio = (p.sndFlags & PARAM_SAMPLE.PSOUNDFLAG_UNINTERRUPTABLE) != 0;
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			rhPtr.rhApp.soundPlayer.play(p.sndHandle, 1, channel - 1, bPrio);
		}
	}
	// CUT

	function ACT_PLAYLOOPCHANNEL()
	{
	}
	ACT_PLAYLOOPCHANNEL.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			var bPrio = (p.sndFlags & PARAM_SAMPLE.PSOUNDFLAG_UNINTERRUPTABLE) != 0;
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			var nLoops = rhPtr.get_EventExpressionInt(this.evtParams[2]);
			rhPtr.rhApp.soundPlayer.play(p.sndHandle, nLoops, channel - 1, bPrio);
		}
	}
	// CUT

	function ACT_PLAYLOOPSAMPLE()
	{
	}
	ACT_PLAYLOOPSAMPLE.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			var nLoops = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			var bPrio = (p.sndFlags & PARAM_SAMPLE.PSOUNDFLAG_UNINTERRUPTABLE) != 0;
			rhPtr.rhApp.soundPlayer.play(p.sndHandle, nLoops, -1, bPrio);
		}
	}
	// CUT

	function ACT_PLAYSAMPLE()
	{
	}
	ACT_PLAYSAMPLE.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			var bPrio = (p.sndFlags & PARAM_SAMPLE.PSOUNDFLAG_UNINTERRUPTABLE) != 0;
			rhPtr.rhApp.soundPlayer.play(p.sndHandle, 1, -1, bPrio);
		}
	}
	// CUT

	function ACT_RESUMEALLCHANNELS()
	{
	}
	ACT_RESUMEALLCHANNELS.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.soundPlayer.resume();
		}
	}
	// CUT

	function ACT_RESUMECHANNEL()
	{
	}
	ACT_RESUMECHANNEL.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.rhApp.soundPlayer.resumeChannel(channel - 1);
		}
	}
	// CUT

	function ACT_RESUMESAMPLE()
	{
	}
	ACT_RESUMESAMPLE.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			rhPtr.rhApp.soundPlayer.resumeSample(p.sndHandle);
		}
	}
	// CUT

	function ACT_SETCHANNELPOS()
	{
	}
	ACT_SETCHANNELPOS.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var position = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			if (position >= 0)
				rhPtr.rhApp.soundPlayer.setPositionChannel(channel - 1, position);
		}
	}
	// CUT

	function ACT_SETCHANNELFREQ()
	{
	}
	ACT_SETCHANNELFREQ.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var freq = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			if (freq >= 0)
				rhPtr.rhApp.soundPlayer.setFrequencyChannel(channel - 1, freq);
		}
	}
	// CUT

	function ACT_SETCHANNELVOL()
	{
	}
	ACT_SETCHANNELVOL.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var volume = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			if (volume >= 0 && volume <= 100)
				rhPtr.rhApp.soundPlayer.setVolumeChannel(channel - 1, volume);
		}
	}
	// CUT

	function ACT_RESUMESAMPLE()
	{
	}
	ACT_RESUMESAMPLE.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			rhPtr.rhApp.soundPlayer.resumeSample(p.sndHandle);
		}
	}
	// CUT

	function ACT_SETSAMPLEMAINVOL()
	{
	}
	ACT_SETSAMPLEMAINVOL.prototype =
	{
		execute: function (rhPtr)
		{
			var volume = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (volume >= 0 && volume <= 100)
				rhPtr.rhApp.soundPlayer.setMainVolume(volume);
		}
	}
	// CUT

	function ACT_SETSAMPLEPOS()
	{
	}
	ACT_SETSAMPLEPOS.prototype =
	{
		execute: function (rhPtr)
		{
			var sample = this.evtParams[0].sndHandle;
			var position = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			if (position >= 0)
				rhPtr.rhApp.soundPlayer.setPositionSample(sample, position);
		}
	}
	// CUT

	function ACT_SETSAMPLEFREQ()
	{
	}
	ACT_SETSAMPLEFREQ.prototype =
	{
		execute: function (rhPtr)
		{
			var sample = this.evtParams[0].sndHandle;
			var freq = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			if (freq >= 0)
				rhPtr.rhApp.soundPlayer.setFrequencySample(sample, freq);
		}
	}
	// CUT

	function ACT_SETSAMPLEVOL()
	{
	}
	ACT_SETSAMPLEVOL.prototype =
	{
		execute: function (rhPtr)
		{
			var sample = this.evtParams[0].sndHandle;
			var volume = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			if (volume >= 0 && volume <= 100)
				rhPtr.rhApp.soundPlayer.setVolumeSample(sample, volume);
		}
	}
	// CUT

	function ACT_STOPCHANNEL()
	{
	}
	ACT_STOPCHANNEL.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.rhApp.soundPlayer.stopChannel(channel - 1);
		}
	}
	// CUT

	function ACT_STOPSAMPLE()
	{
	}
	ACT_STOPSAMPLE.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.soundPlayer.stopAllSounds();
		}
	}
	// CUT

	function ACT_STOPSPESAMPLE()
	{
	}
	ACT_STOPSPESAMPLE.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[0];
			rhPtr.rhApp.soundPlayer.stopSample(p.sndHandle);
		}
	}
	// CUT

	function ACT_UNLOCKCHANNEL()
	{
	}
	ACT_UNLOCKCHANNEL.prototype =
	{
		execute: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.rhApp.soundPlayer.unlockChannel(channel - 1);
		}
	}
	// CUT

	// String object
	// ------------------------------------------------------------------
	function ACT_STRDESTROY()
	{
	}
	ACT_STRDESTROY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo != null)
			{
				if ((pHo.rsHidden & CRun.COF_FIRSTTEXT) != 0)
				{
					pHo.ros.obHide();
					pHo.ros.rsFlags &= ~CRSpr.RSFLAG_VISIBLE;
					pHo.hoFlags |= CObject.HOF_NOCOLLISION;
				}
				else
				{
					pHo.hoFlags |= CObject.HOF_DESTROYED;
					rhPtr.destroy_Add(pHo.hoNumber);
				}
			}
		}
	}
	// CUT

	function ACT_STRDISPLAY()
	{
	}
	ACT_STRDISPLAY.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[1];
			rhPtr.txtDoDisplay(this, p.value);
		}
	}
	// CUT

	function ACT_STRDISPLAYDURING()
	{
	}
	ACT_STRDISPLAYDURING.prototype =
	{
		execute: function (rhPtr)
		{
			var p = this.evtParams[1];
			var num = rhPtr.txtDoDisplay(this, p.value);
			if (num >= 0)
			{
				var p2 = this.evtParams[2];
				var hoPtr = rhPtr.rhObjectList[num];
				if (p2.code == 2)        // PARAM_TIME
				{
					hoPtr.ros.rsFlash = p2.timer;
					hoPtr.ros.rsFlashCpt = p2.timer;
				}
				else
				{
					hoPtr.ros.rsFlash = rhPtr.get_EventExpressionInt(p2);
					hoPtr.ros.rsFlashCpt = hoPtr.ros.rsFlash;
				}
			}
		}
	}
	// CUT

	function ACT_STRDISPLAYSTRING()
	{
	}
	ACT_STRDISPLAYSTRING.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo != null)
			{
				pHo.txtChange(-1);
			}
		}
	}
	// CUT

	function ACT_STRNEXT()
	{
	}
	ACT_STRNEXT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo != null)
			{
				var num = pHo.rsMini + 1;
				pHo.txtChange(num);
			}
		}
	}
	// CUT

	function ACT_STRPREV()
	{
	}
	ACT_STRPREV.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo != null)
			{
				var num = pHo.rsMini - 1;
				if (num < 0)
					num = 0;
				pHo.txtChange(num);
			}
		}
	}
	// CUT

	function ACT_STRSET()
	{
	}
	ACT_STRSET.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo != null)
			{
				var text;
				if (this.evtParams[0].code == 31)
					text = this.evtParams[0].value;
				else
					text = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
				pHo.txtChange(text)
			}
		}
	}
	// CUT

	function ACT_STRSETCOLOUR()
	{
	}
	ACT_STRSETCOLOUR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo != null)
			{
				var color;
				if (this.evtParams[0].code == 24)
					color = this.evtParams[0].color;
				else
				{
					color = rhPtr.get_EventExpressionInt(this.evtParams[0]);
					color = CServices.swapRGB(color);
				}
				CRun.setObjectTextColor(pHo, color);
			}
		}
	}
	// CUT

	function ACT_STRSETSTRING()
	{
	}
	ACT_STRSETSTRING.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo != null)
			{
				var text = rhPtr.get_EventExpressionString(this.evtParams[0]);
				if (pHo.rsTextBuffer == null || (pHo.rsTextBuffer != null && text != pHo.rsTextBuffer))
				{
					pHo.txtSetString(text);
					pHo.txtChange(-1);
				}
			}
		}
	}
	// CUT

	// Counter object
	// ------------------------------------------------------------------
	function ACT_CADDVALUE()
	{
	}
	ACT_CADDVALUE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			var pValue = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			pHo.cpt_Add(pValue);
		}
	}
	// CUT

	function ACT_CSETCOLOR1()
	{
	}
	ACT_CSETCOLOR1.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var color;
			if (this.evtParams[0].code == CParam.PARAM_EXPRESSIONNUM)
			{
				color = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				color = CServices.swapRGB(color);
			}
			else
				color = this.evtParams[0].color;

			pHo.cpt_SetColor1(color);
		}
	}
	// CUT

	function ACT_CSETCOLOR2()
	{
	}
	ACT_CSETCOLOR2.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var color;
			if (this.evtParams[0].code == CParam.PARAM_EXPRESSIONNUM)
			{
				color = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				color = CServices.swapRGB(color);
			}
			else
				color = this.evtParams[0].color;

			pHo.cpt_SetColor2(color);
		}
	}
	// CUT

	function ACT_CSETMAX()
	{
	}
	ACT_CSETMAX.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var pValue = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			pHo.cpt_SetMax(pValue);
		}
	}
	// CUT

	function ACT_CSETMIN()
	{
	}
	ACT_CSETMIN.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var pValue = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			pHo.cpt_SetMin(pValue);
		}
	}
	// CUT

	function ACT_CSETVALUE()
	{
	}
	ACT_CSETVALUE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var pValue = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			pHo.cpt_ToFloat(pValue);
			pHo.cpt_Change(pValue);
		}
	}
	// CUT

	function ACT_CSUBVALUE()
	{
	}
	ACT_CSUBVALUE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var pValue = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			pHo.cpt_Sub(pValue);
		}
	}
	// CUT

	// Sub-application object
	// ------------------------------------------------------------------
	function ACT_CCAENDAPP()
	{
	}
	ACT_CCAENDAPP.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.endApp();
		}
	}
	// CUT

	function ACT_CCAHIDE()
	{
	}
	ACT_CCAHIDE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.hide();
		}
	}
	// CUT

	function ACT_CCAJUMPFRAME()
	{
	}
	ACT_CCAJUMPFRAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var frame = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.jumpFrame(frame);
		}
	}
	// CUT

	function ACT_CCANEXTFRAME()
	{
	}
	ACT_CCANEXTFRAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.nextFrame();
		}
	}
	// CUT

	function ACT_CCAPAUSEAPP()
	{
	}
	ACT_CCAPAUSEAPP.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.pause();
		}
	}
	// CUT

	function ACT_CCAPREVIOUSFRAME()
	{
	}
	ACT_CCAPREVIOUSFRAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.previousFrame();
		}
	}
	// CUT

	function ACT_CCARESTARTAPP()
	{
	}
	ACT_CCARESTARTAPP.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.restartApp();
		}
	}
	// CUT

	function ACT_CCARESTARTFRAME()
	{
	}
	ACT_CCARESTARTFRAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.restartFrame();
		}
	}
	// CUT

	function ACT_CCARESUMEAPP()
	{
	}
	ACT_CCARESUMEAPP.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.resume();
		}
	}
	// CUT

	function ACT_CCASETWIDTH()
	{
	}
	ACT_CCASETWIDTH.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			var width = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.setWidth(width);
		}
	}
	// CUT

	function ACT_CCASETHEIGHT()
	{
	}
	ACT_CCASETHEIGHT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			var height = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.setHeight(height);
		}
	}
	// CUT

	function ACT_CCASETGLOBALSTRING()
	{
	}
	ACT_CCASETGLOBALSTRING.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var number = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
			var s = rhPtr.get_EventExpressionString(this.evtParams[1]);

			pHo.setGlobalString(number, s);
		}
	}
	// CUT

	function ACT_CCASETGLOBALVALUE()
	{
	}
	ACT_CCASETGLOBALVALUE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var number = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
			var value = rhPtr.get_EventExpressionAny(this.evtParams[1]);

			pHo.setGlobalValue(number, value);
		}
	}
	// CUT

	function ACT_CCASHOW()
	{
	}
	ACT_CCASHOW.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.show();
		}
	}
	// CUT


	// Player object
	// ------------------------------------------------------------------
	function ACT_ADDLIVES()
	{
	}
	ACT_ADDLIVES.prototype =
	{
		execute: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var joueur = this.evtOi;
			value = rhPtr.rhApp.getLives()[joueur] + value;
			rhPtr.actPla_FinishLives(joueur, value);
		}
	}
	// CUT

	function ACT_NOINPUT()
	{
	}
	ACT_NOINPUT.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rh2InputMask[this.evtOi] = 0;
		}
	}
	// CUT

	function ACT_RESTINPUT()
	{
	}
	ACT_RESTINPUT.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rh2InputMask[this.evtOi] = 0xFF;
		}
	}
	// CUT

	function ACT_SETINPUT()
	{
	}
	ACT_SETINPUT.prototype =
	{
		execute: function (rhPtr)
		{
			var input = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (input > CRunApp.CTRLTYPE_KEYBOARD)
				return;
			if (input == CRunApp.CTRLTYPE_MOUSE)
				input = CRunApp.CTRLTYPE_KEYBOARD;
			var joueur = this.evtOi;
			if (joueur >= 4)
				return;
			rhPtr.rhApp.getCtrlType()[joueur] = input;

		}
	}
	// CUT

	function ACT_SETINPUTKEY()
	{
	}
	ACT_SETINPUTKEY.prototype =
	{
		execute: function (rhPtr)
		{
			var touche = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (touche >= 8)
				return;
			var joueur = this.evtOi;
			if (joueur >= 4)
				return;
			var key = this.evtParams[1].key;
			rhPtr.rhApp.pcCtrlKeys[joueur * CRunApp.MAX_KEY + touche] = key;
		}
	}
	// CUT

	function ACT_SETLIVES()
	{
	}
	ACT_SETLIVES.prototype =
	{
		execute: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var joueur = this.evtOi;
			rhPtr.actPla_FinishLives(joueur, value);
		}
	}
	// CUT

	function ACT_SETPLAYERNAME()
	{
	}
	ACT_SETPLAYERNAME.prototype =
	{
		execute: function (rhPtr)
		{
			var joueur = this.evtOi;
			if (joueur >= CRunApp.MAX_PLAYER)
				return;
			var pString = rhPtr.get_EventExpressionString(this.evtParams[0]);
			rhPtr.rhApp.playerNames[joueur] = pString;
		}
	}
	// CUT

	function ACT_SETSCORE()
	{
	}
	ACT_SETSCORE.prototype =
	{
		execute: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var joueur = this.evtOi;
			var scores = rhPtr.rhApp.getScores();
			scores[joueur] = value;

			rhPtr.update_PlayerObjects(joueur, COI.OBJ_SCORE, scores[joueur]);
		}
	}

	function ACT_SUBLIVES()
	{
	}
	ACT_SUBLIVES.prototype =
	{
		execute: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var joueur = this.evtOi;
			value = rhPtr.rhApp.getLives()[joueur] - value;
			rhPtr.actPla_FinishLives(joueur, value);
		}
	}
	// CUT

	function ACT_SUBSCORE()
	{
	}
	ACT_SUBSCORE.prototype =
	{
		execute: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var joueur = this.evtOi;
			var scores = rhPtr.rhApp.getScores();
			scores[joueur] -= value;
			rhPtr.update_PlayerObjects(joueur, COI.OBJ_SCORE, scores[joueur]);
		}
	}
	// CUT

	function ACT_ADDSCORE()
	{
	}
	ACT_ADDSCORE.prototype =
	{
		execute: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var joueur = this.evtOi;
			var scores = rhPtr.rhApp.getScores();
			scores[joueur] += value;
			rhPtr.update_PlayerObjects(joueur, COI.OBJ_SCORE, scores[joueur]);
		}
	}
	// CUT


	// Timer object
	// -------------------------------------------------------------------
	function ACT_EVENTAFTER()
	{
	}
	ACT_EVENTAFTER.prototype =
	{
		execute: function (rhPtr)
		{
			var timer;
			if (this.evtParams[0].code == 22)
				timer = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				timer = this.evtParams[0].timer;
			var pName = rhPtr.get_EventExpressionString(this.evtParams[1]);

			var pLoop = rhPtr.rh4TimerEvents;
			var pPrevious = null;
			while (pLoop != null)
			{
				pPrevious = pLoop;
				pLoop = pLoop.next;
			}
			var pEvent = new TimerEvents();
			if (pPrevious == null)
				rhPtr.rh4TimerEvents = pEvent;
			else
				pPrevious.next = pEvent;
			pEvent.type = TimerEvents.TIMEREVENTTYPE_ONESHOT;
			pEvent.timer = rhPtr.rhTimer + timer;
			pEvent.name = pName;
			pEvent.next = null;
		}
	}
	// CUT

	function ACT_NEVENTSAFTER()
	{
	}
	ACT_NEVENTSAFTER.prototype =
	{
		execute: function (rhPtr)
		{
			var timer;
			if (this.evtParams[0].code == 22)
				timer = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				timer = this.evtParams[0].timer;
			var loops = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			var timerNext;
			if (this.evtParams[2].code == 22)
				timerNext = rhPtr.get_EventExpressionInt(this.evtParams[2]);
			else
				timerNext = this.evtParams[2].timer;
			var pName = rhPtr.get_EventExpressionString(this.evtParams[3]);

			var pLoop = rhPtr.rh4TimerEvents;
			var pPrevious = null;
			while (pLoop != null)
			{
				pPrevious = pLoop;
				pLoop = pLoop.next;
			}
			var pEvent = new TimerEvents();
			if (pPrevious == null)
				rhPtr.rh4TimerEvents = pEvent;
			else
				pPrevious.next = pEvent;
			pEvent.type = TimerEvents.TIMEREVENTTYPE_REPEAT;
			pEvent.timer = rhPtr.rhTimer + timer;
			pEvent.timerNext = timerNext;
			pEvent.timerPosition = 0;
			pEvent.loops = loops;
			pEvent.index = 0;
			pEvent.next = null;
			pEvent.name = pName;
		}
	}
	// CUT

	function ACT_SETTIMER()
	{
	}
	ACT_SETTIMER.prototype =
	{
		execute: function (rhPtr)
		{
			var newTime;
			if (this.evtParams[0].code == 22)
				newTime = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				newTime = this.evtParams[0].timer;

			var time = rhPtr.rhApp.timer;
			rhPtr.rhTimer = newTime;
			rhPtr.rhTimerOld = time - rhPtr.rhTimer;

			rhPtr.rhEvtProg.restartTimerEvents();
		}
	}
	// CUT

	// Storyboard object
	// -------------------------------------------------------------------
	function ACT_CDISPLAY()
	{
	}
	ACT_CDISPLAY.prototype =
	{
		execute: function (rhPtr)
		{
			var position = this.evtParams[0];
			var pInfo = new CPositionInfo();
			position.read_Position(rhPtr, 0, pInfo);
			rhPtr.setDisplay(pInfo.x, pInfo.y, pInfo.layer, 3);
		}
	}
	// CUT

	function ACT_CDISPLAYX()
	{
	}
	ACT_CDISPLAYX.prototype =
	{
		execute: function (rhPtr)
		{
			var x = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.setDisplay(x, 0, -1, 1);
		}
	}
	// CUT

	function ACT_CDISPLAYY()
	{
	}
	ACT_CDISPLAYY.prototype =
	{
		execute: function (rhPtr)
		{
			var y = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.setDisplay(0, y, -1, 2);
		}
	}
	// CUT

	function ACT_SETFRAMEBDKCOLOR()
	{
	}
	ACT_SETFRAMEBDKCOLOR.prototype =
	{
		execute: function (rhPtr)
		{
			var color;
			if (this.evtParams[0].code == 24)		// PARAM_COLOUR
				color = this.evtParams[0].color;
			else
			{
				color = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				color = CServices.swapRGB(color);
			}
			rhPtr.rhFrame.leBackground = color;
			rhPtr.rhApp.frameColor = color;
		}
	}
	// CUT

	function ACT_CDISPLAYY()
	{
	}
	ACT_CDISPLAYY.prototype =
	{
		execute: function (rhPtr)
		{
			var y = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.setDisplay(0, y, -1, 2);
		}
	}
	// CUT

	function ACT_DELALLCREATEDBKD()
	{
	}
	ACT_DELALLCREATEDBKD.prototype =
	{
		execute: function (rhPtr)
		{
			var layer = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
			rhPtr.deleteAllBackdrop2(layer);
		}
	}
	// CUT

	function ACT_DELCREATEDBKDAT()
	{
	}
	ACT_DELCREATEDBKDAT.prototype =
	{
		execute: function (rhPtr)
		{
			var layer = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
			var x = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			var y = rhPtr.get_EventExpressionInt(this.evtParams[2]);
			var bFineDetection = rhPtr.get_EventExpressionInt(this.evtParams[3]) != 0;

			rhPtr.deleteBackdropAt(layer, x, y, bFineDetection);
		}
	}
	// CUT

	function ACT_ENDGAME()
	{
	}
	ACT_ENDGAME.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.subAppStopped = true;
		}
	}
	// CUT

	function ACT_GOLEVEL()
	{
	}
	ACT_GOLEVEL.prototype =
	{
		execute: function (rhPtr)
		{
			var level;
			if (this.evtParams[0].code == 26)
			{
				level = this.evtParams[0].value;
				if (rhPtr.rhApp.HCellToNCell(level) == -1)
					return;
			}
			else
			{
				level = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
				if (level < 0 || level >= 4096)
					return;
				if (rhPtr.rhApp.bShiftFrameNumber)
					level++;
				level |= 0x8000;
			}
			rhPtr.rhQuit = CRun.LOOPEXIT_GOTOLEVEL;
			rhPtr.rhQuitParam = level;
			rhPtr.rhApp.subAppStopped = true;
		}
	}
	// CUT

	function ACT_NEXTLEVEL()
	{
	}
	ACT_NEXTLEVEL.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhQuit = CRun.LOOPEXIT_NEXTLEVEL;
			rhPtr.rhApp.subAppStopped = true;
		}
	}
	// CUT

	function ACT_PAUSEKEY()
	{
	}
	ACT_PAUSEKEY.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rh4PauseKey = this.evtParams[0].key;
			rhPtr.rhQuit = CRun.LOOPEXIT_PAUSEGAME;
		}
	}
	// CUT

	function ACT_SETFRAMERATE()
	{
	}
	ACT_SETFRAMERATE.prototype =
	{
		execute: function (rhPtr)
		{
			var rate = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			rhPtr.rhApp.gaFrameRate = rate;
		}
	}

	function ACT_SETVSYNCON()
	{
	}
	ACT_SETVSYNCON.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.gaNewFlags |= CRunApp.GANF_VSYNC;
		}
	}
	// CUT

	function ACT_SETVSYNCOFF()
	{
	}
	ACT_SETVSYNCOFF.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.gaNewFlags &= ~CRunApp.GANF_VSYNC;
		}
	}
	// CUT

	function ACT_FULLSCREENMODE()
	{
	}
	ACT_FULLSCREENMODE.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.enterFullScreen();
		}
	}
	// CUT

	function ACT_WINDOWEDMODE()
	{
	}
	ACT_WINDOWEDMODE.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.exitFullScreen();
		}
	}
	// CUT

	function ACT_PAUSEANYKEY()
	{
	}
	ACT_PAUSEANYKEY.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rh4PauseKey = -1;
			rhPtr.rhQuit = CRun.LOOPEXIT_PAUSEGAME;
		}
	}
	// CUT

	function ACT_PLAYDEMO()
	{
	}
	ACT_PLAYDEMO.prototype =
	{
		execute: function (rhPtr)
		{
			// TODO		
			/*		var pFilename:String;
			 if ( evtParams[0].code==63 )	    // PARAM_FILENAME2
			 pFilename=(PARAM_STRING(evtParams[0])).string;
			 else
			 pFilename=rhPtr.get_EventExpressionString(evtParams[0]);

			 if (rhPtr.rh4Demo==null)
			 {
			 rhPtr.rh4Demo=new CDemoRecord(rhPtr, pFilename);
			 rhPtr.rh4Demo.startPlaying();
			 }
			 */
		}
	}
	// CUT

	function ACT_PREVLEVEL()
	{
	}
	ACT_PREVLEVEL.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhApp.subAppStopped = true;
			rhPtr.rhQuit = CRun.LOOPEXIT_PREVLEVEL;
		}
	}
	// CUT

	function ACT_SETFRAMEHEIGHT()
	{
	}
	ACT_SETFRAMEHEIGHT.prototype =
	{
		execute: function (rhPtr)
		{
			var newHeight = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			var nOldHeight = rhPtr.rhFrame.leHeight;
			rhPtr.rhFrame.leHeight = newHeight;

			if (nOldHeight == rhPtr.rhFrame.leVirtualRect.bottom)
				rhPtr.rhFrame.leVirtualRect.bottom = rhPtr.rhLevelSy = newHeight;

			var n;
			for (n = 0; n < rhPtr.rhFrame.nLayers; n++)
				rhPtr.rhFrame.layers[n].resetLevelBackground();
			rhPtr.drawLevel();
		}
	}
	// CUT

	function ACT_SETFRAMEWIDTH()
	{
	}
	ACT_SETFRAMEWIDTH.prototype =
	{
		execute: function (rhPtr)
		{
			var newWidth = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			var nOldWidth = rhPtr.rhFrame.leWidth;
			rhPtr.rhFrame.leWidth = newWidth;

			if (nOldWidth == rhPtr.rhFrame.leVirtualRect.right)
				rhPtr.rhFrame.leVirtualRect.right = rhPtr.rhLevelSx = newWidth;

			var n;
			for (n = 0; n < rhPtr.rhFrame.nLayers; n++)
				rhPtr.rhFrame.layers[n].resetLevelBackground();
			rhPtr.drawLevel();
		}
	}
	// CUT

	function ACT_SETVIRTUALHEIGHT()
	{
	}
	ACT_SETVIRTUALHEIGHT.prototype =
	{
		execute: function (rhPtr)
		{
			var newHeight = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			if (newHeight < rhPtr.rhFrame.leHeight)
				newHeight = rhPtr.rhFrame.leHeight;
			if (newHeight > 0x7FFFF000)
				newHeight = 0x7FFFF000;

			if (rhPtr.rhFrame.leVirtualRect.bottom != newHeight)
				rhPtr.rhFrame.leVirtualRect.bottom = rhPtr.rhLevelSy = newHeight;
		}
	}
	// CUT

	function ACT_SETVIRTUALWIDTH()
	{
	}
	ACT_SETVIRTUALWIDTH.prototype =
	{
		execute: function (rhPtr)
		{
			var newWidth = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			if (newWidth < rhPtr.rhFrame.leWidth)
				newWidth = rhPtr.rhFrame.leWidth;
			if (newWidth > 0x7FFFF000)
				newWidth = 0x7FFFF000;

			if (rhPtr.rhFrame.leVirtualRect.right != newWidth)
				rhPtr.rhFrame.leVirtualRect.right = rhPtr.rhLevelSx = newWidth;
		}
	}
	// CUT

	// Active object
	// ---------------------------------------------------------------------
	function ACT_SPRFRONT()
	{
	}
	ACT_SPRFRONT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			var index = pHo.getChildMaxIndex();
			pHo.setChildIndex(index - 1);
		}
	}
	// CUT

	function ACT_SPRPASTE()
	{
	}
	ACT_SPRPASTE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.roa != null)
				pHo.roa.animIn(0);
			rhPtr.activeToBackdrop(pHo, this.evtParams[0].value);
		}
	}
	// CUT

	function ACT_SPRSETANGLE()
	{
	}
	ACT_SPRSETANGLE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var nAngle = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			nAngle %= 360;
			if (nAngle < 0)
			    nAngle += 360;

			// If physical movement
			var pMBase = rhPtr.GetMBase(pHo);
			if (pMBase)
			{
				pMBase.setAngle(nAngle);
				return;
			}

			var bAntiA = false;
			if (rhPtr.get_EventExpressionInt(this.evtParams[1]) != 0)
				bAntiA = true;

			var bOldAntiA = false;
			if ((pHo.ros.rsFlags & CRSpr.RSFLAG_ROTATE_ANTIA) != 0)
				bOldAntiA = true;
			if (pHo.roc.rcAngle != nAngle || bOldAntiA != bAntiA)
			{
				pHo.roc.rcAngle = nAngle;
				pHo.ros.rsFlags &= ~CRSpr.RSFLAG_ROTATE_ANTIA;
				if (bAntiA)
					pHo.ros.rsFlags |= CRSpr.RSFLAG_ROTATE_ANTIA;
				pHo.roc.rcChanged = true;

				var ifo = pHo.hoAdRunHeader.rhApp.imageBank.getImageInfoEx(pHo.roc.rcImage, pHo.roc.rcAngle, pHo.roc.rcScaleX, pHo.roc.rcScaleY);
				pHo.hoImgWidth = ifo.width;
				pHo.hoImgHeight = ifo.height;
				pHo.hoImgXSpot = ifo.xSpot;
				pHo.hoImgYSpot = ifo.ySpot;
			}
		}
	}
	// CUT

	function ACT_SPRREPLACECOLOR()
	{
		this.replace = null;
	}
	ACT_SPRREPLACECOLOR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			pHo.roa.animIn(0);

			var oldColor;
			if (this.evtParams[0].code == 24)
				oldColor = this.evtParams[0].color;
			else
			{
				oldColor = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				oldColor = CServices.swapRGB(oldColor);
			}

			var newColor;
			if (this.evtParams[1].code == 24)	    // PARAM_COLOUR)
				newColor = this.evtParams[1].color;
			else
			{
				newColor = rhPtr.get_EventExpressionInt(this.evtParams[1]);
				newColor = CServices.swapRGB(newColor);
			}
			if (oldColor != newColor)
			{
				if (this.replace == null)
					this.replace = new CReplaceColor();
				this.replace.replaceColor(rhPtr, pHo, newColor, oldColor);
			}
		}
	}
	// CUT


	function ACT_SPRSETSCALE()
	{
	}
	ACT_SPRSETSCALE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var fScale = rhPtr.get_EventExpressionDouble(this.evtParams[0]);
			if (fScale < 0)
				fScale = 0;

			var bResample = false;
			if (rhPtr.get_EventExpressionInt(this.evtParams[1]) != 0)
				bResample = true;

			pHo.ros.rsFlags &= ~CRSpr.RSFLAG_ROTATE_ANTIA;
			if (bResample)
				pHo.ros.rsFlags |= CRSpr.RSFLAG_ROTATE_ANTIA;
			pHo.setScale(fScale, fScale);
		}
	}
	// CUT

	function ACT_SPRSETSCALEX()
	{
	}
	ACT_SPRSETSCALEX.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var fScale = rhPtr.get_EventExpressionDouble(this.evtParams[0]);
			if (fScale < 0)
				fScale = 0;

			var bResample = false;
			if (rhPtr.get_EventExpressionInt(this.evtParams[1]) != 0)
				bResample = true;
			pHo.ros.rsFlags &= ~CRSpr.RSFLAG_ROTATE_ANTIA;
			if (bResample)
				pHo.ros.rsFlags |= CRSpr.RSFLAG_ROTATE_ANTIA;

			pHo.setScale(fScale, pHo.roc.rcScaleY);
		}
	}
	// CUT

	function ACT_SPRSETSCALEY()
	{
	}
	ACT_SPRSETSCALEY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var fScale = rhPtr.get_EventExpressionDouble(this.evtParams[0]);
			if (fScale < 0)
				fScale = 0;

			var bResample = false;
			if (rhPtr.get_EventExpressionInt(this.evtParams[1]) != 0)
				bResample = true;
			pHo.ros.rsFlags &= ~CRSpr.RSFLAG_ROTATE_ANTIA;
			if (bResample)
				pHo.ros.rsFlags |= CRSpr.RSFLAG_ROTATE_ANTIA;

			pHo.setScale(pHo.roc.rcScaleX, fScale);
		}
	}
	// CUT

	function ACT_SPRADDBKD()
	{
	}
	ACT_SPRADDBKD.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			// Un cran d'animation sans effet
			if (pHo.roa != null)
				pHo.roa.animIn(0);

			rhPtr.activeToBackdrop(pHo, this.evtParams[0].value);
		}
	}
	// CUT

	// Question object
	// ---------------------------------------------------------------------
	function ACT_QASK()
	{
	}
	ACT_QASK.prototype =
	{
		execute:   function (rhPtr)
		{
			if ((this.evtOiList & 0x8000) == 0)
			{
				this.qstCreate(rhPtr, this.evtOi);
				return;
			}

			if ((this.evtOiList & 0x7FFF) != 0x7FFF)
			{
				var qoil = rhPtr.rhEvtProg.qualToOiList[this.evtOiList & 0x7FFF];
				var qoi;
				for (qoi = 0; qoi < qoil.qoiList.length; qoi += 2)
					this.qstCreate(rhPtr, qoil.qoiList[qoi]);
			}
		},
		qstCreate: function (rhPtr, oi)
		{
			var c = this.evtParams[0];
			var info = new CPositionInfo();

			if (c.read_Position(rhPtr, 0x10, info))
			{
				rhPtr.f_CreateObject(c.cdpHFII, oi, info.x, info.y, info.dir, 0, rhPtr.rhFrame.nLayers - 1, -1);
			}
		}
	}
	// CUT

	function ACT_RESTARTGAME()
	{
	}
	ACT_RESTARTGAME.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhQuit = CRun.LOOPEXIT_NEWGAME;
		}
	}
	// CUT

	function ACT_RESTARTLEVEL()
	{
	}
	ACT_RESTARTLEVEL.prototype =
	{
		execute: function (rhPtr)
		{
			rhPtr.rhQuit = CRun.LOOPEXIT_RESTART;
		}
	}
	// CUT


	// Create object
	// ---------------------------------------------------------------------
	function ACT_CREATE()
	{
	}
	ACT_CREATE.prototype =
	{
		execute: function (rhPtr)
		{
			var pEvp = this.evtParams[0];
			var pInfo = new CPositionInfo();
			if (pEvp.read_Position(rhPtr, 0x11, pInfo))
			{
				if (pInfo.bRepeat)
				{
					this.evtFlags |= CAct.ACTFLAGS_REPEAT;
					rhPtr.rhEvtProg.rh2ActionLoop = true;
				}
				else
				{
					this.evtFlags &= ~CAct.ACTFLAGS_REPEAT;
				}
				var number = rhPtr.f_CreateObject(pEvp.cdpHFII, pEvp.cdpOi, pInfo.x, pInfo.y, pInfo.dir, 0, pInfo.layer, -1);
				if (number >= 0)
				{
					var pHo = rhPtr.rhObjectList[number];
					rhPtr.rhEvtProg.evt_AddCurrentObject(pHo);

				    // Build 283.2: add physics attractor
					if (pHo && pHo.hoType >= 32)
					    rhPtr.addPhysicsAttractor(pHo);

					var mBase = rhPtr.GetMBase(pHo);
					if (mBase)
						mBase.CreateBody();
					else
					{
						if (rhPtr.rhBox2DBase != null)
						{
							rhPtr.rh4Box2DBase.rAddNormalObject(pHo);
						}
					}
				}
			}
		}
	}
	// CUT

	function ACT_CREATEBYNAME()
	{
	}
	ACT_CREATEBYNAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);
			var pInfo = new CPositionInfo();
			if (this.evtParams[1].read_Position(rhPtr, 0x11, pInfo))
			{
				if (pInfo.bRepeat)
				{
					this.evtFlags |= CAct.ACTFLAGS_REPEAT;
					rhPtr.rhEvtProg.rh2ActionLoop = true;
				}
				else
					this.evtFlags &= ~CAct.ACTFLAGS_REPEAT;

				var oiPtr;
				for (oiPtr = rhPtr.rhApp.OIList.getFirstOI(); oiPtr != null; oiPtr = rhPtr.rhApp.OIList.getNextOI())
				{
					if (oiPtr.oiType >= 2)
					{
						if (CServices.compareStringsIgnoreCase(oiPtr.oiName, pName))
							break;
					}
				}

				if (oiPtr != null) {
				    var number = rhPtr.f_CreateObject(-1, oiPtr.oiHandle, pInfo.x, pInfo.y, pInfo.dir, 0, pInfo.layer, -1);
				    if (number >= 0) {
				        var pHo = rhPtr.rhObjectList[number];
				        rhPtr.rhEvtProg.evt_AddCurrentObject(pHo);

				        // Build 283.2: add physics attractor
				        if (pHo && pHo.hoType >= 32)
				            rhPtr.addPhysicsAttractor(pHo);

				        var mBase = rhPtr.GetMBase(pHo);
				        if (mBase)
				            mBase.CreateBody();
				        else {
				            if (rhPtr.rhBox2DBase != null) {
				                rhPtr.rh4Box2DBase.rAddNormalObject(pHo);
				            }
				        }
				    }
				}
			}
		}
	}
	// CUT

	// Common object actions
	// -----------------------------------------------------------------
	function ACT_EXTFOREACH()
	{
	}
	ACT_EXTFOREACH.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);
			rhPtr.rhEvtProg.addForEach(pName, pHo, this.evtOiList);
			rhPtr.rhEvtProg.callEndForEach = true;
		}
	}
	// CUT

	function ACT_EXTFOREACH2()
	{
	}
	ACT_EXTFOREACH2.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			var pName = rhPtr.get_EventExpressionString(this.evtParams[1]);
			rhPtr.rhEvtProg.addForEach(pName, pHo, this.evtOiList);

			pHo = rhPtr.rhEvtProg.get_CurrentObjects(this.evtParams[0].oiList);
			if (pHo != null)
				rhPtr.rhEvtProg.addForEach(pName, pHo, this.evtParams[0].oiList);

			rhPtr.rhEvtProg.callEndForEach = true;
		}
	}
	// CUT

	function ACT_EXTBOUNCE()
	{
	}
	ACT_EXTBOUNCE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rom != null && pHo.rom.rmMovement.bounce != null)
				pHo.rom.rmMovement.bounce();
		}
	}
	// CUT

	function ACT_EXTBRANCHNODE()
	{
	}
	ACT_EXTBRANCHNODE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);

			if (pHo.roc.rcMovementType == CMoveDef.MVTYPE_TAPED)
			{
				pHo.rom.rmMovement.mtBranchNode(pName);
			}
		}
	}
	// CUT

	function ACT_EXTCHGFLAG()
	{
	}
	ACT_EXTCHGFLAG.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rov != null)
			{
				var number = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				var mask = 1 << number;
				if ((pHo.rov.rvValueFlags & mask) != 0)
					pHo.rov.rvValueFlags &= ~mask;
				else
					pHo.rov.rvValueFlags |= mask;
			}
		}
	}
	// -- CUT

	function ACT_EXTCHGFLAGCONST()
	{
	}
	ACT_EXTCHGFLAGCONST.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rov != null)
			{
				if ((pHo.rov.rvValueFlags & this.mask) != 0)
					pHo.rov.rvValueFlags &= ~this.mask;
				else
					pHo.rov.rvValueFlags |= this.mask;
			}
		}
	}
	// CUT

	function ACT_EXTCLRFLAG()
	{
	}
	ACT_EXTCLRFLAG.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rov != null)
			{
				var number = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				pHo.rov.rvValueFlags &= ~(1 << number);
			}
		}
	}
	// -- CUT

	function ACT_EXTCLRFLAGCONST()
	{
	}
	ACT_EXTCLRFLAGCONST.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rov != null)
			{
				pHo.rov.rvValueFlags &= ~this.mask;
			}
		}
	}
	// CUT

	function ACT_EXTDESTROY()
	{
	}
	ACT_EXTDESTROY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.hoType == 3)
			{
				var pText = pHo;
				if ((pText.rsHidden & CRun.COF_FIRSTTEXT) != 0)
				{
					pHo.ros.obHide();
					pHo.ros.rsFlags &= ~CRSpr.RSFLAG_VISIBLE;
					pHo.hoFlags |= CObject.HOF_NOCOLLISION;
				}
				else
				{
					pHo.hoFlags |= CObject.HOF_DESTROYED;
					rhPtr.destroy_Add(pHo.hoNumber);
				}
				return;
			}
			if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
			{
				pHo.hoFlags |= CObject.HOF_DESTROYED;
				if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_ANIMATIONS) != 0 || (pHo.hoOEFlags & CObjectCommon.OEFLAG_SPRITES) != 0)
				{
					rhPtr.init_Disappear(pHo);
				}
				else
				{
					pHo.hoCallRoutine = false;
					rhPtr.destroy_Add(pHo.hoNumber);
				}
			}
		}
	}
	// CUT

	function ACT_EXTDISPATCHVAR()
	{
	}
	ACT_EXTDISPATCHVAR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var num;
			if (this.evtParams[0].code == 53)
				num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				num = this.evtParams[0].value;

			var pBuffer = this.evtParams[2];
			if (rhPtr.rhEvtProg.rh2ActionLoopCount == 0)
				pBuffer.value = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			else
				pBuffer.value++;
			if (num >= 0 && pHo.rov != null)
			{
				if (num >= pHo.rov.rvValues.length)
					pHo.rov.growValues(num + 10);
				pHo.rov.rvValues[num] = pBuffer.value;
			}
		}
	}
	// CUT

	function ACT_EXTDISPLAYDURING()
	{
	}
	ACT_EXTDISPLAYDURING.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.ros != null)
			{
				pHo.ros.obHide();
				pHo.ros.rsFlags &= ~CRSpr.RSFLAG_VISIBLE;

				if (this.evtParams[0].code == 2)        // PARAM_TIME
				{
					pHo.ros.rsFlash = this.evtParams[0].timer;
					pHo.ros.rsFlashCpt = this.evtParams[0].timer;
				}
				else
				{
					pHo.ros.rsFlash = rhPtr.get_EventExpressionInt(this.evtParams[0]);
					pHo.ros.rsFlashCpt = pHo.ros.rsFlash;
				}
			}
		}
	}
	// CUT

	function ACT_EXTFORCEANIM()
	{
	}
	ACT_EXTFORCEANIM.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var ani;
			if (this.evtParams[0].code == 10)
				ani = this.evtParams[0].value;
			else
				ani = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			pHo.roa.animation_Force(ani);
			pHo.roc.rcChanged = true;
		}
	}
	// CUT

	function ACT_EXTFORCEDIR()
	{
	}
	ACT_EXTFORCEDIR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var ani;
			if (this.evtParams[0].code == 29)
				ani = rhPtr.get_Direction(this.evtParams[0].value);
			else
				ani = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			pHo.roa.animDir_Force(ani);
			pHo.roc.rcChanged = true;
		}
	}
	// CUT

	function ACT_EXTFORCEFRAME()
	{
	}
	ACT_EXTFORCEFRAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var frame = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.roa.animFrame_Force(frame);
			pHo.roc.rcChanged = true;
		}
	}
	// CUT

	function ACT_EXTFORCESPEED()
	{
	}
	ACT_EXTFORCESPEED.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var speed;
			speed = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			pHo.roa.animSpeed_Force(speed);
		}
	}
	// CUT

	function ACT_EXTGOTONODE()
	{
	}
	ACT_EXTGOTONODE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);

			if (pHo.roc.rcMovementType == CMoveDef.MVTYPE_TAPED)
			{
				pHo.rom.rmMovement.mtGotoNode(pName);
			}
		}
	}
	// CUT

	function ACT_EXTHIDE()
	{
	}
	ACT_EXTHIDE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			CRun.objectHide(pHo);
		}
	}
	// CUT

	function ACT_EXTINKEFFECT()
	{
	}
	ACT_EXTINKEFFECT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.ros != null)
			{
				var p = this.evtParams[0];
				var param1 = p.value1;
				var param2 = p.value2;
				if (param1 == CRSpr.BOP_BLEND)
					param2 = 0;
				pHo.ros.modifSpriteEffect(param1, param2);
			}
		}
	}
	// CUT

	function ACT_EXTLOOKAT()
	{
	}
	ACT_EXTLOOKAT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var position = this.evtParams[0];
			var pInfo = new CPositionInfo();
			if (position.read_Position(rhPtr, 0, pInfo))
			{
				var x = pInfo.x;
				var y = pInfo.y;
				x -= pHo.hoX;
				y -= pHo.hoY;
				var pMovement = rhPtr.GetMBase(pHo);
				if (pMovement == null)
				{
					var dir = CRun.get_DirFromPente(x, y);
					dir &= 31;
					if (rhPtr.getDir(pHo) != dir)
					{
						pHo.roc.rcDir = dir;
						pHo.roc.rcChanged = true;
						pHo.rom.rmMovement.setDir(dir);
					}
				}
				else
				{
					var angle = Math.atan2(-y, x) * 180.0 / 3.141592653589;
					if (angle < 0)
						angle = 360 + angle;
					pMovement.setAngle(angle);
				}
			}
		}
	}
	// CUT

	function ACT_EXTMAXSPEED()
	{
	}
	ACT_EXTMAXSPEED.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var s = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (pHo.rom != null)
				pHo.rom.rmMovement.setMaxSpeed(s);
		}
	}
	// CUT

	function ACT_EXTMOVEAFTER()
	{
	}
	ACT_EXTMOVEAFTER.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.ros != null)
			{
				var pHo2 = rhPtr.rhEvtProg.get_ParamActionObjects(this.evtParams[0].oiList, this);
				if (pHo2 == null)
					return;
				var pos;
				var pos1 = pHo2.getChildIndex();
				var pos2 = pHo.getChildIndex();
				if (pos2 < pos1)
					pHo.setChildIndex(pos1 + 1);
			}
		}
	}
	// CUT

	function ACT_EXTMOVEBEFORE()
	{
	}
	ACT_EXTMOVEBEFORE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.ros != null)
			{
				var pHo2 = rhPtr.rhEvtProg.get_ParamActionObjects(this.evtParams[0].oiList, this);
				if (pHo2 == null)
					return;
				var pos1 = pHo2.getChildIndex();
				var pos2 = pHo.getChildIndex();
				if (pos1 < pos2)
					pHo.setChildIndex(pos1);
			}
		}
	}
	// CUT

	function ACT_EXTMOVETOLAYER()
	{
	}
	ACT_EXTMOVETOLAYER.prototype =
	{
		execute: function (rhPtr)
		{
			var hoPtr = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (hoPtr == null)
				return;

			if (hoPtr.ros != null)
			{
				var nLayer = rhPtr.get_EventExpressionInt(this.evtParams[0]);

				if (nLayer > 0 && nLayer <= rhPtr.rhFrame.nLayers && hoPtr.hoLayer != nLayer - 1)
				{
					nLayer -= 1;

					var pLayer = rhPtr.rhFrame.layers[nLayer];
					if (hoPtr.ros != null)
					{
						hoPtr.hoLayer = nLayer;
						hoPtr.ros.rsLayer = nLayer;
						hoPtr.delSprite();
						hoPtr.ros.createSprite(false);
					}
				}
			}
		}
	}
	// CUT

	function ACT_EXTNEXTMOVE()
	{
	}
	ACT_EXTNEXTMOVE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rom != null)
				pHo.rom.nextMovement(pHo);
		}
	}
	// CUT

	function ACT_EXTPREVMOVE()
	{
	}
	ACT_EXTPREVMOVE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rom != null)
				pHo.rom.previousMovement(pHo);
		}
	}
	// CUT

	function ACT_EXTRESTANIM()
	{
	}
	ACT_EXTRESTANIM.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			pHo.roa.animation_Restore();
			pHo.roc.rcChanged = true;
		}
	}
	// CUT

	function ACT_EXTRESTDIR()
	{
	}
	ACT_EXTRESTDIR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			pHo.roa.animDir_Restore();
			pHo.roc.rcChanged = true;
		}
	}
	// CUT

	function ACT_EXTRESTFRAME()
	{
	}
	ACT_EXTRESTFRAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			pHo.roa.animFrame_Restore();
			pHo.roc.rcChanged = true;
		}
	}
	// CUT

	function ACT_EXTRESTSPEED()
	{
	}
	ACT_EXTRESTSPEED.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			pHo.roa.animSpeed_Restore();
		}
	}
	// CUT

	function ACT_EXTREVERSE()
	{
	}
	ACT_EXTREVERSE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rom != null)
				pHo.rom.rmMovement.reverse();
		}
	}
	// CUT

	function ACT_EXTSELMOVE()
	{
	}
	ACT_EXTSELMOVE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var n;
			if (this.evtParams[0].code == 22)
				n = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				n = this.evtParams[0].value;
			if (pHo.rom != null)
				pHo.rom.selectMovement(pHo, n);
		}
	}
	// CUT

	function ACT_EXTSETACCELERATION()
	{
	}
	ACT_EXTSETACCELERATION.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var acc = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.rom.rmMovement.setAcc(acc);
		}
	}
	// CUT

	function ACT_EXTSETALPHACOEF()
	{
	}
	ACT_EXTSETALPHACOEF.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.ros == null)
				return;

			var alpha = CServices.clamp(255 - rhPtr.get_EventExpressionInt(this.evtParams[0]), 0, 255);
			var wasSemi = ((pHo.ros.rsEffect & CRSpr.BOP_RGBAFILTER) == 0);
			pHo.ros.rsEffect = (pHo.ros.rsEffect & CRSpr.BOP_MASK) | CRSpr.BOP_RGBAFILTER;

			var rgbaCoeff = 0x00FFFFFF;

			if (!wasSemi)
				rgbaCoeff = pHo.ros.rsEffectParam;

			var alphaPart = alpha << 24;
			var rgbPart = (rgbaCoeff & 0x00FFFFFF);
			pHo.ros.rsEffectParam = alphaPart | rgbPart;

			pHo.ros.modifSpriteEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
		}
	}
	// CUT

	function ACT_EXTSETBOLD()
	{
	}
	ACT_EXTSETBOLD.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var bFlag = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			var info = CRun.getObjectFont(pHo);
			if (bFlag != 0)
				info.lfWeight = 700;
			else
				info.lfWeight = 400;

			CRun.setObjectFont(pHo, info, null);
		}
	}
	// CUT

	function ACT_EXTSETDECELERATION()
	{
	}
	ACT_EXTSETDECELERATION.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var dec = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.rom.rmMovement.setDec(dec);
		}
	}
	// CUT

	function ACT_EXTSETDIR()
	{
	}
	ACT_EXTSETDIR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var dir;
			if (this.evtParams[0].code == 29)
				dir = rhPtr.get_Direction(this.evtParams[0].value);
			else
				dir = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			dir &= 31;
			if (rhPtr.getDir(pHo) != dir)
			{
				pHo.roc.rcDir = dir;
				pHo.roc.rcChanged = true;
				pHo.rom.rmMovement.setDir(dir);

				if (pHo.hoType == 2)
					pHo.roa.animIn(0);
			}
		}
	}
	// CUT

	function ACT_EXTSETDIRECTIONS()
	{
	}
	ACT_EXTSETDIRECTIONS.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var dirs = this.evtParams[0].value;
			pHo.rom.rmMovement.set8Dirs(dirs);
		}
	}
	// CUT

	function ACT_EXTSETEFFECT()
	{
	}
	ACT_EXTSETEFFECT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var effectName = this.evtParams[0].string;
			var effect = CRSpr.BOP_COPY;
			if (effectName != null && effectName.length != 0)
			{
				if (effectName == "Add")
					effect = CRSpr.BOP_ADD;
				else if (effectName == "Invert")
					effect = CRSpr.BOP_INVERT;
				else if (effectName == "Sub")
					effect = CRSpr.BOP_SUB;
				else if (effectName == "Mono")
					effect = CRSpr.BOP_MONO;
				else if (effectName == "Blend")
					effect = CRSpr.BOP_BLEND;
				else if (effectName == "XOR")
					effect = CRSpr.BOP_XOR;
				else if (effectName == "OR")
					effect = CRSpr.BOP_OR;
				else if (effectName == "AND")
					effect = CRSpr.BOP_AND;
			}
			pHo.ros.modifSpriteEffect(effect, pHo.ros.rsEffectParam);
		}
	}
	// CUT

	function ACT_EXTSETEFFECTPARAM()
	{
	}
	ACT_EXTSETEFFECTPARAM.prototype =
	{
		execute: function (rhPtr)
		{

		}
	}
	// CUT

	function ACT_EXTSETFLAG()
	{
	}
	ACT_EXTSETFLAG.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rov != null)
			{
				var number = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				pHo.rov.rvValueFlags |= (1 << number);
			}
		}
	}
	// -- CUT

	function ACT_EXTSETFLAGCONST()
	{
	}
	ACT_EXTSETFLAGCONST.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rov != null)
			{
				pHo.rov.rvValueFlags |= this.mask;
			}
		}
	}
	// CUT

	function ACT_EXTSETFONTNAME()
	{
	}
	ACT_EXTSETFONTNAME.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var name = rhPtr.get_EventExpressionString(this.evtParams[0]);
			var info = CRun.getObjectFont(pHo);
			info.lfFaceName = name;
			CRun.setObjectFont(pHo, info, null);
		}
	}
	// CUT

	function ACT_EXTSETFONTSIZE()
	{
	}
	ACT_EXTSETFONTSIZE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var newSize = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var bResize = rhPtr.get_EventExpressionInt(this.evtParams[1]);

			var lf = CRun.getObjectFont(pHo);

			var oldSize = lf.lfHeight;
			lf.lfHeight = CServices.heightNormalToLF(newSize);

			if (bResize == 0)
				CRun.setObjectFont(pHo, lf, null);
			else
			{
				if (newSize != oldSize)
				{
					var rc = new CRect();
					var coef = 1.0;
					if (oldSize != 0)
						coef = newSize / oldSize;
					rc.right = Math.floor(pHo.hoImgWidth * coef);
					rc.bottom = Math.floor(pHo.hoImgHeight * coef);
					rc.left = 0;
					rc.top = 0;
					CRun.setObjectFont(pHo, lf, rc);
				}
			}
		}
	}
	// CUT

	function ACT_EXTSETGRAVITY()
	{
	}
	ACT_EXTSETGRAVITY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var grav = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.rom.rmMovement.setGravity(grav);
		}
	}
	// CUT

	function ACT_EXTSETITALIC()
	{
	}
	ACT_EXTSETITALIC.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var bFlag = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			var info = CRun.getObjectFont(pHo);
			info.lfItalic = bFlag;
			CRun.setObjectFont(pHo, info, null);
		}
	}
	// CUT

	function ACT_EXTSETPOS()
	{
	}
	ACT_EXTSETPOS.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var position = this.evtParams[0];
			var pInfo = new CPositionInfo();
			if (position.read_Position(rhPtr, 1, pInfo))
			{
				CRun.setXPosition(pHo, pInfo.x);
				CRun.setYPosition(pHo, pInfo.y);
				if (pInfo.dir != -1)
				{
					var dir = pInfo.dir &= 31;
					if (rhPtr.getDir(pHo) != dir)
					{
						pHo.roc.rcDir = dir;
						pHo.roc.rcChanged = true;
						pHo.rom.rmMovement.setDir(dir);

						if (pHo.hoType == 2)
							pHo.roa.animIn(0);
					}
				}
			}
		}
	}
	// CUT

	function ACT_EXTSETRGBCOEF()
	{
	}
	ACT_EXTSETRGBCOEF.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.ros == null)
				return;

			var argb = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var wasSemi = ((pHo.ros.rsEffect & CRSpr.BOP_RGBAFILTER) == 0);
			pHo.ros.rsEffect = (pHo.ros.rsEffect & CRSpr.BOP_MASK) | CRSpr.BOP_RGBAFILTER;

			var rgbaCoeff = pHo.ros.rsEffectParam;
			var alphaPart;
			if (wasSemi)
			{
				if (pHo.ros.rsEffectParam == -1)
					alphaPart = 0xFF000000;
				else
					alphaPart = (255 - (pHo.ros.rsEffectParam * 2)) << 24;
			}
			else
				alphaPart = rgbaCoeff & 0xFF000000;

			var rgbPart = CServices.swapRGB(argb & 0x00FFFFFF);
			var filter = alphaPart | rgbPart;
			pHo.ros.rsEffectParam = filter;

			pHo.ros.modifSpriteEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
		}
	}
	// CUT

	function ACT_EXTSETROTATINGSPEED()
	{
	}
	ACT_EXTSETROTATINGSPEED.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var speed = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pHo.rom.rmMovement.setRotSpeed(speed);
		}
	}
	// CUT

	function ACT_EXTSETSEMITRANSPARENCY()
	{
	}
	ACT_EXTSETSEMITRANSPARENCY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.ros != null)
			{
				var val = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				if (val < 0) val = 0;
				if (val > 128) val = 128;

				pHo.roc.rcChanged = true;
				pHo.ros.setSemiTransparency(val);
			}
		}
	}
	// CUT

	function ACT_EXTSETTEXTCOLOR()
	{
	}
	ACT_EXTSETTEXTCOLOR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var rgb;
			if (this.evtParams[0].code == 22)
			{
				rgb = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				rgb = CServices.swapRGB(rgb);
			}
			else
				rgb = this.evtParams[0].color;

			CRun.setObjectTextColor(pHo, rgb);
		}
	}
	// CUT

	function ACT_EXTSETUNDERLINE()
	{
	}
	ACT_EXTSETUNDERLINE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var bFlag = rhPtr.get_EventExpressionInt(this.evtParams[0]);

			var info = CRun.getObjectFont(pHo);
			info.lfUnderline = bFlag;
			CRun.setObjectFont(pHo, info, null);
		}
	}
	// CUT

	function ACT_EXTSETVAR()
	{
	}
	ACT_EXTSETVAR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var num;
			if (this.evtParams[0].code == 53)
				num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				num = this.evtParams[0].value;

			if (num >= 0 && pHo.rov != null)
			{
				if (num >= pHo.rov.rvValues.length)
					pHo.rov.growValues(num + 10);
				var pValue2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);
				pHo.rov.rvValues[num] = pValue2;
			}
		}
	}
	// -- CUT

	function ACT_EXTSETVARCONST()
	{
	}
	ACT_EXTSETVARCONST.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (this.num >= 0 && pHo.rov != null)
			{
				if (this.num >= pHo.rov.rvValues.length)
					pHo.rov.growValues(this.num + 10);
				pHo.rov.rvValues[this.num] = this.value;
			}
		}
	}
	// CUT

	function ACT_EXTSETVARSTRING()
	{
	}
	ACT_EXTSETVARSTRING.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var num;
			if (this.evtParams[0].code == 62)
				num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				num = this.evtParams[0].value;

			if (num >= 0 && pHo.rov != null)
			{
				if (num > pHo.rov.rvStrings.length)
					pHo.rov.rvStrings.growStrings(num + 10);
				pHo.rov.rvStrings[num] = rhPtr.get_EventExpressionString(this.evtParams[1]);
			}
		}
	}
	// CUT

	function ACT_EXTSETX()
	{
	}
	ACT_EXTSETX.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var x = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			CRun.setXPosition(pHo, Math.floor(x));
		}
	}
	// CUT

	function ACT_EXTSETY()
	{
	}
	ACT_EXTSETY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var y = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			CRun.setYPosition(pHo, Math.floor(y));
		}
	}
	// CUT

	function ACT_EXTSHOOT()
	{
	}
	ACT_EXTSHOOT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var pEvp = this.evtParams[0];
			var pInfo = new CPositionInfo();
			if (pEvp.read_Position(rhPtr, 0x11, pInfo))
			{
				pHo.shtCreate(pEvp, pInfo.x, pInfo.y, pInfo.dir);
			}
		}
	}
	// CUT

	function ACT_EXTSHOOTTOWARD()
	{
	}
	ACT_EXTSHOOTTOWARD.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;

			var pInfo = new CPositionInfo();
			if (this.evtParams[0].read_Position(rhPtr, 0x11, pInfo))
			{
				var pInfoDest = new CPositionInfo();
				if (this.evtParams[1].read_Position(rhPtr, 0, pInfoDest))
				{
					var x2 = pInfoDest.x;
					var y2 = pInfoDest.y;
					var dir = CRun.get_DirFromPente(x2 - pInfo.x, y2 - pInfo.y);

					pHo.shtCreate(this.evtParams[0], pInfo.x, pInfo.y, dir);
				}
			}
		}
	}
	// CUT

	function ACT_EXTSHOW()
	{
	}
	ACT_EXTSHOW.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;
			CRun.objectShow(pHo);
		}
	}
	// CUT

	function ACT_EXTSHUFFLE()
	{
	}
	ACT_EXTSHUFFLE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;

			rhPtr.rhEvtProg.rh2ShuffleBuffer.add(pHo);
		}
	}
	// CUT

	function ACT_EXTSPEED()
	{
	}
	ACT_EXTSPEED.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			var s = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (pHo.rom != null)
				pHo.rom.rmMovement.setSpeed(s);
		}
	}
	// CUT

	function ACT_EXTSPRBACK()
	{
	}
	ACT_EXTSPRBACK.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;
			pHo.setChildIndex(0);
		}
	}
	// CUT

	function ACT_EXTSPRFRONT()
	{
	}
	ACT_EXTSPRFRONT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;
			var index = pHo.getChildMaxIndex();
			pHo.setChildIndex(index);
		}
	}
	// CUT

	function ACT_SPRBACK()
	{
	}
	ACT_SPRBACK.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;
			pHo.setChildIndex(0);
		}
	}
	// CUT

	function ACT_SPRFRONT()
	{
	}
	ACT_SPRFRONT.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;
			var index = pHo.getChildMaxIndex();
			pHo.setChildIndex(index);
		}
	}
	// CUT

	function ACT_EXTSTART()
	{
	}
	ACT_EXTSTART.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rom != null)
				pHo.rom.rmMovement.start();
		}
	}
	// CUT

	function ACT_EXTSTARTANIM()
	{
	}
	ACT_EXTSTARTANIM.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.roa.raAnimStopped = false;
		}
	}
	// CUT

	function ACT_EXTSTOP()
	{
	}
	ACT_EXTSTOP.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rom != null)
				pHo.rom.rmMovement.stop();
		}
	}
	// CUT

	function ACT_EXTSTOPANIM()
	{
	}
	ACT_EXTSTOPANIM.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;
			pHo.roa.raAnimStopped = true;
		}
	}
	// CUT

	function ACT_EXTADDVAR()
	{
	}
	ACT_EXTADDVAR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;

			var num;
			if (this.evtParams[0].code == 53)
				num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				num = this.evtParams[0].value;

			if (num >= 0 && pHo.rov != null)
			{
				if (num >= pHo.rov.rvValues.length)
					pHo.rov.growValues(num + 10);
				var pValue2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);
				pHo.rov.rvValues[num] += pValue2;
			}
		}
	}
	// -- CUT

	function ACT_EXTADDVARCONST()
	{
	}
	ACT_EXTADDVARCONST.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;

			if (this.num >= 0 && pHo.rov != null)
			{
				if (this.num >= pHo.rov.rvValues.length)
					pHo.rov.growValues(this.num + 10);
				pHo.rov.rvValues[this.num] += this.value;
			}
		}
	}
	// CUT

	function ACT_EXTSUBVAR()
	{
	}
	ACT_EXTSUBVAR.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;

			var num;
			if (this.evtParams[0].code == 53)
				num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				num = this.evtParams[0].value;

			if (num >= 0 && pHo.rov != null)
			{
				if (num >= pHo.rov.rvValues.length)
					pHo.rov.growValues(num + 10);
				var pValue2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);
				pHo.rov.rvValues[num] -= pValue2;
			}
		}
	}
	// -- CUT

	function ACT_EXTSUBVARCONST()
	{
	}
	ACT_EXTSUBVARCONST.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null) return;

			if (this.num >= 0 && pHo.rov != null)
			{
				if (this.num >= pHo.rov.rvValues.length)
					pHo.rov.growValues(this.num + 10);
				pHo.rov.rvValues[this.num] -= this.value;
			}
		}
	}
	// CUT

	function ACT_EXTWRAP()
	{
	}
	ACT_EXTWRAP.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (pHo.rom != null)
				pHo.rom.rmEventFlags |= CRMvt.EF_WRAP;
		}
	}
	// CUT

	// BOX2D MOVEMENTS
	//////////////////////////////////////////////////////////////////////////////////////

	function ACT_EXTSETFRICTION()
	{
	}
	ACT_EXTSETFRICTION.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var friction = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTSETFRICTION, friction);
			}
		}
	}
	// CUT

	function ACT_EXTSETELASTICITY()
	{
	}
	ACT_EXTSETELASTICITY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var elasticity = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTSETELASTICITY, elasticity);
			}
		}
	}
	// CUT

	function ACT_EXTAPPLYANGULARIMPULSE()
	{
	}
	ACT_EXTAPPLYANGULARIMPULSE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var torque = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTAPPLYANGULARIMPULSE, torque);
			}
		}
	}
	// CUT

	function ACT_EXTAPPLYFORCE()
	{
	}
	ACT_EXTAPPLYFORCE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var array = new Array();
				array[0] = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				array[1] = rhPtr.get_EventExpressionInt(this.evtParams[1]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTAPPLYFORCE, array);
			}
		}
	}
	// CUT

	function ACT_EXTAPPLYTORQUE()
	{
	}
	ACT_EXTAPPLYTORQUE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var torque = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTAPPLYTORQUE, torque);
			}
		}
	}
	// CUT

	function ACT_EXTSETLINEARVELOCITY()
	{
	}
	ACT_EXTSETLINEARVELOCITY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var array = new Array();
				array[0] = rhPtr.get_EventExpressionDouble(this.evtParams[0]);
				array[1] = rhPtr.get_EventExpressionDouble(this.evtParams[1]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTSETLINEARVELOCITY, array);
			}
		}
	}
	// CUT

	function ACT_EXTSETANGULARVELOCITY()
	{
	}
	ACT_EXTSETANGULARVELOCITY.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var torque = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTSETANGULARVELOCITY, torque);
			}
		}
	}
	// CUT

	function ACT_EXTAPPLYIMPULSE()
	{
	}
	ACT_EXTAPPLYIMPULSE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				var array = new Array();
				array[0] = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				array[1] = rhPtr.get_EventExpressionInt(this.evtParams[1]);
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTAPPLYIMPULSE, array);
			}
		}
	}
	// CUT

	function ACT_EXTSTOPFORCE()
	{
	}
	ACT_EXTSTOPFORCE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTSTOPFORCE, 0);
			}
		}
	}
	// CUT

	function ACT_EXTSTOPTORQUE()
	{
	}
	ACT_EXTSTOPTORQUE.prototype =
	{
		execute: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ActionObjects(this);
			if (pHo == null)
				return;

			if (rhPtr.GetMBase(pHo) != null)
			{
				pHo.rom.rmMovement.callMovement(CAct.ACT_EXTSTOPTORQUE, 0);
			}
		}
	}
	// CUT

	// CCnd object
	// ----------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 * 
	 * Permission is hereby granted to any person obtaining a legal copy 
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for 
	 * debugging, optimizing, or customizing applications created with 
	 * Clickteam Multimedia Fusion 2. 
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	CCnd.NUM_ONEVENT = 6;
	CCnd.CND_ONLOOP = ((-16 << 16) | 0xFFFF);
	CCnd.CND_OR = ((-24 << 16) | 65535);
	CCnd.CND_ORLOGICAL = ((-25 << 16) | 65535);
	function CCnd()
	{
	}
	CCnd.create = function (app)
	{
		var debut = app.file.getFilePointer();

		var size = app.file.readAShort();
		var cnd = null;
		var c = app.file.readAInt();
		switch (c)
		{
		    case ((-40 << 16) | 0xFFFF):
		        cnd = new CND_RUNNINGAS();
		        break;
		    case ((-39 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_GT();
		        break;
		    case ((-38 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_GE();
		        break;
		    case ((-37 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_LT();
		        break;
		    case ((-36 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_LE();
		        break;
		    case ((-35 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_NE();
		        break;
		    case ((-34 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_EQ();
		        break;
		    case ((-33 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_GT();
		        break;
		    case ((-32 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_GE();
		        break;
		    case ((-31 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_LT();
		        break;
		    case ((-30 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_LE();
		        break;
		    case ((-29 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_NE();
		        break;
		    case ((-28 << 16) | 0xFFFF):
		        cnd = new CND_COMPAREGCONST_EQ();
		        break;
		    case ((-27 << 16) | 0xFFFF):    // ELSE IF
				cnd = new CND_NEVER();
				break;
			case ((-26 << 16) | 0xFFFF):
				cnd = new CND_CHANCE();
				break;
			case ((-25 << 16) | 0xFFFF):		// CND_ORLOGICAL
				cnd = new CND_NEVER();
				break;
			case ((-24 << 16) | 0xFFFF):		// CND_OR		
				cnd = new CND_NEVER();
				break;
			case ((-23 << 16) | 0xFFFF):
				cnd = new CND_GROUPSTART();
				break;
			case ((-20 << 16) | 0xFFFF):
				cnd = new CND_COMPAREGSTRING();
				break;
			case ((-16 << 16) | 0xFFFF):
				cnd = new CND_ONLOOP();
				break;
			case ((-12 << 16) | 0xFFFF):
				cnd = new CND_GROUPACTIVATED();
				break;
			case ((-11 << 16) | 0xFFFF):
				cnd = new CND_NEVER();
				break;
			case ((-10 << 16) | 0xFFFF):
				cnd = new CND_NEVER();
				break;
			case ((-9 << 16) | 0xFFFF):
				cnd = new CND_NEVER();
				break;
			case ((-8 << 16) | 0xFFFF):
				cnd = new CND_COMPAREG();
				break;
			case ((-7 << 16) | 0xFFFF):
				cnd = new CND_NOTALWAYS();
				break;
			case ((-6 << 16) | 0xFFFF):
				cnd = new CND_ONCE();
				break;
			case ((-5 << 16) | 0xFFFF):
				cnd = new CND_REPEAT();
				break;
			case ((-4 << 16) | 0xFFFF):
				cnd = new CND_NOMORE();
				break;
			case ((-3 << 16) | 0xFFFF):
				cnd = new CND_COMPARE();
				break;
			case ((-2 << 16) | 0xFFFF):
				cnd = new CND_NEVER();
				break;
			case ((-1 << 16) | 0xFFFF):
				cnd = new CND_ALWAYS();
				break;
			case ((-9 << 16) | 0xFFFE):
				cnd = new CND_SPCHANNELPAUSED();
				break;
			case ((-8 << 16) | 0xFFFE):
				cnd = new CND_NOSPCHANNELPLAYING();
				break;
			case ((-6 << 16) | 0xFFFE):
				cnd = new CND_SPSAMPAUSED();
				break;
			case ((-3 << 16) | 0xFFFE):
				cnd = new CND_NOSAMPLAYING;
				break;
			case ((-1 << 16) | 0xFFFE):
				cnd = new CND_NOSPSAMPLAYING();
				break;
			case ((-8 << 16) | 0xFFFD):
				cnd = new CND_ENDOFPAUSE();
				break;
			case ((-7 << 16) | 0xFFFD):
				cnd = new CND_ISVSYNCON();
				break;
			case ((-6 << 16) | 0xFFFD):
				cnd = new CND_ISLADDER();
				break;
			case ((-5 << 16) | 0xFFFD):
				cnd = new CND_ISOBSTACLE();
				break;
			case ((-4 << 16) | 0xFFFD):
				cnd = new CND_QUITAPPLICATION();
				break;
			case ((-3 << 16) | 0xFFFD):
				cnd = new CND_NEVER();
				break;
			case ((-2 << 16) | 0xFFFD):
				cnd = new CND_ALWAYS();
				break;
			case ((-1 << 16) | 0xFFFD):
				cnd = new CND_START();
				break;
			case ((-8 << 16) | 0xFFFC):
				cnd = new CND_EVERY2();
				break;
			case ((-7 << 16) | 0xFFFC):
				cnd = new CND_TIMEREQUALS();
				break;
			case ((-6 << 16) | 0xFFFC):
				cnd = new CND_ONEVENT();
				break;
			case ((-5 << 16) | 0xFFFC):
				cnd = new CND_TIMEOUT();
				break;
			case ((-4 << 16) | 0xFFFC):
				cnd = new CND_EVERY();
				break;
			case ((-3 << 16) | 0xFFFC):
				cnd = new CND_TIMER();
				break;
			case ((-2 << 16) | 0xFFFC):
				cnd = new CND_TIMERINF();
				break;
			case ((-1 << 16) | 0xFFFC):
				cnd = new CND_TIMERSUP();
				break;
			case ((-12 << 16) | 0xFFFA):
				cnd = new CND_ONMOUSEWHEELDOWN();
				break;
			case ((-11 << 16) | 0xFFFA):
				cnd = new CND_ONMOUSEWHEELUP();
				break;
			case ((-10 << 16) | 0xFFFA):
				cnd = new CND_MOUSEON();
				break;
			case ((-9 << 16) | 0xFFFA):
				cnd = new CND_ANYKEY();
				break;
			case ((-8 << 16) | 0xFFFA):
				cnd = new CND_MKEYDEPRESSED();
				break;
			case ((-7 << 16) | 0xFFFA):
				cnd = new CND_MCLICKONOBJECT();
				break;
			case ((-6 << 16) | 0xFFFA):
				cnd = new CND_MCLICKINZONE();
				break;
			case ((-5 << 16) | 0xFFFA):
				cnd = new CND_MCLICK();
				break;
			case ((-4 << 16) | 0xFFFA):
				cnd = new CND_MONOBJECT();
				break;
			case ((-3 << 16) | 0xFFFA):
				cnd = new CND_MINZONE();
				break;
			case ((-2 << 16) | 0xFFFA):
				cnd = new CND_KBKEYDEPRESSED();
				break;
			case ((-1 << 16) | 0xFFFA):
				cnd = new CND_KBPRESSKEY();
				break;
			case ((-6 << 16) | 0xFFF9):
				cnd = new CND_JOYPUSHED();
				break;
			case ((-5 << 16) | 0xFFF9):
				cnd = new CND_NOMORELIVE();
				break;
			case ((-4 << 16) | 0xFFF9):
				cnd = new CND_JOYPRESSED();
				break;
			case ((-3 << 16) | 0xFFF9):
				cnd = new CND_LIVE();
				break;
			case ((-2 << 16) | 0xFFF9):
				cnd = new CND_SCORE();
				break;
			case ((-1 << 16) | 0xFFF9):
				cnd = new CND_PLAYERPLAYING();
				break;
			case ((-23 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEALLINLINE();
				break;
			case ((-22 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEFLAGRESET();
				break;
			case ((-21 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEFLAGSET();
				break;
			case ((-20 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEVALUE();
				break;
			case ((-19 << 16) | 0xFFFB):
				cnd = new CND_PICKFROMID();
				break;
			case ((-18 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEALLINZONE();
				break;
			case ((-17 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEALL();
				break;
			case ((-16 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEZONE();
				break;
			case ((-15 << 16) | 0xFFFB):
				cnd = new CND_NUMOFALLOBJECT();
				break;
			case ((-14 << 16) | 0xFFFB):
				cnd = new CND_NUMOFALLZONE();
				break;
			case ((-13 << 16) | 0xFFFB):
				cnd = new CND_NOMOREALLZONE();
				break;
			case ((-12 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEFLAGRESET_OLD();
				break;
			case ((-11 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEFLAGSET_OLD();
				break;
			case ((-8 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEVALUE_OLD();
				break;
			case ((-7 << 16) | 0xFFFB):
				cnd = new CND_PICKFROMID_OLD();
				break;
			case ((-6 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEALLINZONE_OLD();
				break;
			case ((-5 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEALL_OLD();
				break;
			case ((-4 << 16) | 0xFFFB):
				cnd = new CND_CHOOSEZONE_OLD();
				break;
			case ((-3 << 16) | 0xFFFB):
				cnd = new CND_NUMOFALLOBJECT_OLD();
				break;
			case ((-2 << 16) | 0xFFFB):
				cnd = new CND_NUMOFALLZONE_OLD();
				break;
			case ((-1 << 16) | 0xFFFB):
				cnd = new CND_NOMOREALLZONE_OLD();
				break;
			case (((-80 - 1) << 16) | 7):
				cnd = new CND_CCOUNTER();
				break;
			case (((-80 - 3) << 16) | 4):
				cnd = new CND_QEQUAL();
				break;
			case (((-80 - 2) << 16) | 4):
				cnd = new CND_QFALSE();
				break;
			case (((-80 - 1) << 16) | 4):
				cnd = new CND_QEXACT();
				break;
			case (((-80 - 4) << 16) | (9 & 0x00FF)):
				cnd = new CND_CCAISPAUSED();
				break;
			case (((-80 - 3) << 16) | (9 & 0x00FF)):
				cnd = new CND_CCAISVISIBLE();
				break;
			case (((-80 - 2) << 16) | (9 & 0x00FF)):
				cnd = new CND_CCAAPPFINISHED();
				break;
			case (((-80 - 1) << 16) | (9 & 0x00FF)):
				cnd = new CND_CCAFRAMECHANGED();
				break;
			default:
				switch (c & 0xFFFF0000)
				{
				    case (-43 << 16):
				        cnd = new CND_EXTCMPVARCONST();
				        break;
				    case (-42 << 16):
				        cnd = new CND_EXTCMPVARCONST();
				        break;
				    case (-41 << 16):
						cnd = new CND_EXTONLOOP();
						break;
					case (-40 << 16):
						cnd = new CND_EXTISSTRIKEOUT();
						break;
					case (-39 << 16):
						cnd = new CND_EXTISUNDERLINE();
						break;
					case (-38 << 16):
						cnd = new CND_EXTISITALIC();
						break;
					case (-37 << 16):
						cnd = new CND_EXTISBOLD();
						break;
					case (-36 << 16):
						cnd = new CND_EXTCMPVARSTRING();
						break;
					case (-35 << 16):
						cnd = new CND_EXTPATHNODENAME();
						break;
					case (-34 << 16):
						cnd = new CND_EXTCHOOSE();
						break;
					case (-33 << 16):
						cnd = new CND_EXTNOMOREOBJECT();
						break;
					case (-32 << 16):
						cnd = new CND_EXTNUMOFOBJECT();
						break;
					case (-31 << 16):
						cnd = new CND_EXTNOMOREZONE();
						break;
					case (-30 << 16):
						cnd = new CND_EXTNUMBERZONE();
						break;
					case (-29 << 16):
						cnd = new CND_EXTSHOWN();
						break;
					case (-28 << 16):
						cnd = new CND_EXTHIDDEN();
						break;
					case (-27 << 16):
						cnd = new CND_EXTCMPVAR();
						break;
					case (-26 << 16):
						cnd = new CND_EXTCMPVARFIXED();
						break;
					case (-25 << 16):
						cnd = new CND_EXTFLAGSET();
						break;
					case (-24 << 16):
						cnd = new CND_EXTFLAGRESET();
						break;
					case (-23 << 16):
						cnd = new CND_EXTISCOLBACK();
						break;
					case (-22 << 16):
						cnd = new CND_EXTNEARBORDERS();
						break;
					case (-21 << 16):
						cnd = new CND_EXTENDPATH();
						break;
					case (-20 << 16):
						cnd = new CND_EXTPATHNODE();
						break;
					case (-19 << 16):
						cnd = new CND_EXTCMPACC();
						break;
					case (-18 << 16):
						cnd = new CND_EXTCMPDEC();
						break;
					case (-17 << 16):
						cnd = new CND_EXTCMPX();
						break;
					case (-16 << 16):
						cnd = new CND_EXTCMPY();
						break;
					case (-15 << 16):
						cnd = new CND_EXTCMPSPEED();
						break;
					case (-14 << 16):
						cnd = new CND_EXTCOLLISION();
						break;
					case (-13 << 16):
						cnd = new CND_EXTCOLBACK();
						break;
					case (-12 << 16):
						cnd = new CND_EXTOUTPLAYFIELD();
						break;
					case (-11 << 16):
						cnd = new CND_EXTINPLAYFIELD();
						break;
					case (-10 << 16):
						cnd = new CND_EXTISOUT();
						break;
					case (-9 << 16):
						cnd = new CND_EXTISIN();
						break;
					case (-8 << 16):
						cnd = new CND_EXTFACING();
						break;
					case (-7 << 16):
						cnd = new CND_EXTSTOPPED();
						break;
					case (-6 << 16):
						cnd = new CND_EXTBOUNCING();
						break;
					case (-5 << 16):
						cnd = new CND_EXTREVERSED();
						break;
					case (-4 << 16):
						cnd = new CND_EXTISCOLLIDING();
						break;
					case (-3 << 16):
						cnd = new CND_EXTANIMPLAYING();
						break;
					case (-2 << 16):
						cnd = new CND_EXTANIMENDOF();
						break;
					case (-1 << 16):
						cnd = new CND_EXTCMPFRAME();
						break;
					default:
						cnd = new CCndExtension();
						break;
				}
		}
		if (cnd != null)
		{
			cnd.evtCode = c;
			cnd.evtOi = app.file.readShort();
			cnd.evtOiList = app.file.readShort();
			cnd.evtFlags = app.file.readAByte();
			cnd.evtFlags2 = app.file.readAByte();
			cnd.evtNParams = app.file.readAByte();
			cnd.evtDefType = app.file.readAByte();
			cnd.evtIdentifier = app.file.readAShort();

			if (cnd.evtNParams > 0)
			{
				cnd.evtParams = new Array(cnd.evtNParams);
				var n;
				for (n = 0; n < cnd.evtNParams; n++)
				{
					cnd.evtParams[n] = CParam.create(app);
				}
			}
		}
		app.file.seek(debut + size);

		return cnd;
	}
	CCnd.negaTRUE = function (evtPtr)
	{
		if (evtPtr.evtFlags2 & CEvent.EVFLAG2_NOT)
			return false;
		return true;
	}
	CCnd.negaFALSE = function (evtPtr)
	{
		if (evtPtr.evtFlags2 & CEvent.EVFLAG2_NOT)
			return true;
		return false;
	}
	CCnd.negate = function (evtPtr, b)
	{
		if (evtPtr.evtFlags2 & CEvent.EVFLAG2_NOT)
			return !b;
		return b;
	}
	CCnd.compute_GlobalNoRepeat = function (rhPtr)
	{
		var evgPtr = rhPtr.rhEvtProg.rhEventGroup;
		var inhibit = evgPtr.evgInhibit;
		evgPtr.evgInhibit = rhPtr.rhLoopCount;
		var loopCount = rhPtr.rhLoopCount;
		if (loopCount == inhibit)
			return false;
		loopCount--;
		if (loopCount == inhibit)
			return false;
		return true;
	}
	CCnd.compute_NoRepeatCol = function (identifier, pHo)
	{
		var id;
		var n;

		var pArray = pHo.hoBaseNoRepeat;
		if (pArray == null)
		{
			pArray = new CArrayList();
			pHo.hoBaseNoRepeat = pArray;
		}
		else
		{
			for (n = 0; n < pArray.size(); n++)
			{
				if (pArray.get(n) == identifier)
					return false;
			}
		}
		pArray.add(identifier);

		pArray = pHo.hoPrevNoRepeat;
		if (pArray == null)
			return true;
		for (n = 0; n < pArray.size(); n++)
		{
			if (pArray.get(n) == identifier)
				return false;
		}
		return true;
	}
	CCnd.checkMark = function (rhPtr, mark)
	{
		if (mark == 0) return false;
		if (mark == rhPtr.rhLoopCount) return true;
		if (mark == rhPtr.rhLoopCount - 1) return true;
		return false;
	}
	function CND_NEVER()
	{
	}
	CND_NEVER.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return false;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	function CND_ALWAYS()
	{
	}
	CND_ALWAYS.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			return true;
		}
	}
	function CCnd()
	{
	}
	CCnd.prototype =
	{
		compute_NoRepeat:  function (pHo)
		{
			return CCnd.compute_NoRepeatCol(this.evtIdentifier, pHo);
		},
		evaChooseValueOld: function (rhPtr, pRoutine)
		{
			var cpt = 0;

			var pHo = rhPtr.rhEvtProg.evt_FirstObjectFromType(COI.OBJ_SPR);
			while (pHo != null)
			{
				cpt++;
				var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				if (pRoutine.evaluate(pHo, value) == false)
				{
					cpt--;
					rhPtr.rhEvtProg.evt_DeleteCurrentObject();
				}
				pHo = rhPtr.rhEvtProg.evt_NextObjectFromType();
			}
			if (cpt != 0)
				return true;
			return false;
		},
		evaChooseValue:    function (rhPtr, pRoutine)
		{
			var cpt = 0;

			var pHo = rhPtr.rhEvtProg.evt_FirstObjectFromType(-1);
			while (pHo != null)
			{
				cpt++;
				var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				if (pRoutine.evaluate(pHo, value) == false)
				{
					cpt--;
					rhPtr.rhEvtProg.evt_DeleteCurrentObject();
				}
				pHo = rhPtr.rhEvtProg.evt_NextObjectFromType();
			}
			if (cpt != 0)
				return true;
			return false;
		},
		evaExpObject:      function (rhPtr, pRoutine)
		{
			var pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
			var cpt = rhPtr.rhEvtProg.evtNSelectedObjects;
			var p = this.evtParams[0];
			var value;

			var token = p.tokens[0];
			if ( (token.code == CExp.EXP_LONG || token.code == CExp.EXP_DOUBLE) && p.tokens[1].code == 0 )
			{
				var value = token.value;
				while (pHo != null)
				{
					if (pRoutine.evaExpRoutine(pHo, value, p.comparaison) == false)
					{
						cpt--;
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
					}
					pHo = rhPtr.rhEvtProg.evt_NextObject();
				}
			}
			else
			{
				while (pHo != null)
				{
					value = rhPtr.get_EventExpressionInt(p);
					if (pRoutine.evaExpRoutine(pHo, value, p.comparaison) == false)
					{
						cpt--;
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
					}
					pHo = rhPtr.rhEvtProg.evt_NextObject();
				}
			}
			if (cpt != 0)
				return true;
			return false;
		},
		evaObject:         function (rhPtr, pRoutine)
		{
			var pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
			var cpt = rhPtr.rhEvtProg.evtNSelectedObjects;
			while (pHo != null)
			{
				if (pRoutine.evaObjectRoutine(pHo) == false)
				{
					cpt--;
					rhPtr.rhEvtProg.evt_DeleteCurrentObject();
				}
				pHo = rhPtr.rhEvtProg.evt_NextObject();
			}
			if (cpt != 0)
				return true;
			return false;
		},
		compareCondition:  function (rhPtr, param, v)
		{
			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[param]);
			var comp = this.evtParams[param].comparaison;
			return CRun.compareTo(v, value2, comp);
		},
		isColliding:       function (rhPtr)
		{
			if (rhPtr.rhEvtProg.rh4ConditionsFalse)
			{
				rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
				rhPtr.rhEvtProg.evt_FirstObject(this.evtParams[0].oiList);
				return false;
			}

			var negate = false;
			if ((this.evtFlags2 & CEvent.EVFLAG2_NOT) != 0)
				negate = true;

			var pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
			if (pHo == null)
				return CCnd.negaFALSE(this);
			var cpt = rhPtr.rhEvtProg.evtNSelectedObjects;

			var oi = this.evtParams[0].oi;
			var oi2List;
			if (oi >= 0)
			{
				rhPtr.isColArray[0] = oi;
				rhPtr.isColArray[1] = this.evtParams[0].oiList;
				oi2List = rhPtr.isColArray;
			}
			else
			{
				var qoil = rhPtr.rhEvtProg.qualToOiList[this.evtParams[0].oiList & 0x7FFF];
				oi2List = qoil.qoiList;
			}

			var bFlag = false;
			var list;
			var list2 = new CArrayList();
			var index, n;
			var pHo2;
			do
			{
				list = rhPtr.objectAllCol_IXY(pHo, pHo.roc.rcImage, pHo.roc.rcAngle, pHo.roc.rcScaleX, pHo.roc.rcScaleY, pHo.hoX, pHo.hoY, oi2List);
				if (list == null)
				{
					if (negate == false)
					{
						cpt--;
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
					}
				}
				else
				{
					bFlag = false;
					for (index = 0; index < list.size(); index++)
					{
						pHo2 = list.get(index);
						if ((pHo2.hoFlags & CObject.HOF_DESTROYED) == 0)
						{
							list2.add(pHo2);
							bFlag = true;
						}
					}

					if (negate == true)
					{
						if (bFlag == true)
						{
							cpt--;
							rhPtr.rhEvtProg.evt_DeleteCurrentObject();
						}
					}
					else
					{
						if (bFlag == false)
						{
							cpt--;
							rhPtr.rhEvtProg.evt_DeleteCurrentObject();
						}
					}
				}
				pHo = rhPtr.rhEvtProg.evt_NextObject();
			} while (pHo != null);

			if (cpt == 0)
				return false;

			pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtParams[0].oiList);
			if (pHo == null) return false;
			cpt = rhPtr.rhEvtProg.evtNSelectedObjects;
			if (negate == false)
			{
				do
				{
					for (index = 0; index < list2.size(); index++)
					{
						pHo2 = list2.get(index);
						if (pHo == pHo2)
						{
							break;
						}
					}
					if (index == list2.size())
					{
						cpt--;
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
					}
					pHo = rhPtr.rhEvtProg.evt_NextObject();
				} while (pHo != null);
				if (cpt != 0) return true;
				return false;
			}

			do
			{
				for (index = 0; index < list2.size(); index++)
				{
					pHo2 = list2.get(index);
					if (pHo == pHo2)
					{
						cpt--;
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
						break;
					}
				}
				pHo = rhPtr.rhEvtProg.evt_NextObject();
			} while (pHo != null);
			if (cpt != 0) return true;
			return false;
		}
	}
	// CUT

	// System conditions
	// ------------------------------------------------------------------

	function CND_CHANCE()
	{
	}
	CND_CHANCE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var param1 = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var param2 = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			if (param1 >= param2)
			    return true;
			if (param2 >= 1 && param1 > 0 && param1 <= param2)
			{
				var rnd = rhPtr.random(param2);
				if (rnd <= param1)
				{
					return true;
				}
			}
			return false;
		}
	}
	// CUT

	function CND_COMPARE()
	{
	}
	CND_COMPARE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var value1 = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			var comp = this.evtParams[1].comparaison;
			return CRun.compareTo(value1, value2, comp);
		}
	}
	// CUT

	function CND_COMPAREG()
	{
	}
	CND_COMPAREG.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var num;
			if (this.evtParams[0].code == 52)
				num = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
			else
				num = this.evtParams[0].value;

			var gValue = rhPtr.rhApp.getGlobalValueAt(num);
			var value = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			var comp = this.evtParams[1].comparaison;
			return CRun.compareTo(gValue, value, comp);
		}
	}
	// -- CUT

	function CND_COMPAREGCONST_EQ() {
	}
	CND_COMPAREGCONST_EQ.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var num = this.evtParams[0].value;
	        var gValue = rhPtr.rhApp.getGlobalValueAt(num);
	        var p = this.evtParams[1];
	        var value = p.tokens[0].value;
	        return gValue == value;
	    }
	}
	// -- CUT

	function CND_COMPAREGCONST_NE() {
	}
	CND_COMPAREGCONST_NE.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var num = this.evtParams[0].value;
	        var gValue = rhPtr.rhApp.getGlobalValueAt(num);
	        var p = this.evtParams[1];
	        var value = p.tokens[0].value;
	        return gValue != value;
	    }
	}
	// -- CUT

	function CND_COMPAREGCONST_LE() {
	}
	CND_COMPAREGCONST_LE.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var num = this.evtParams[0].value;
	        var gValue = rhPtr.rhApp.getGlobalValueAt(num);
	        var p = this.evtParams[1];
	        var value = p.tokens[0].value;
	        return gValue <= value;
	    }
	}
	// -- CUT

	function CND_COMPAREGCONST_LT() {
	}
	CND_COMPAREGCONST_LT.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var num = this.evtParams[0].value;
	        var gValue = rhPtr.rhApp.getGlobalValueAt(num);
	        var p = this.evtParams[1];
	        var value = p.tokens[0].value;
	        return gValue < value;
	    }
	}
	// -- CUT

	function CND_COMPAREGCONST_GE() {
	}
	CND_COMPAREGCONST_GE.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var num = this.evtParams[0].value;
	        var gValue = rhPtr.rhApp.getGlobalValueAt(num);
	        var p = this.evtParams[1];
	        var value = p.tokens[0].value;
	        return gValue >= value;
	    }
	}
	// -- CUT

	function CND_COMPAREGCONST_GT() {
	}
	CND_COMPAREGCONST_GT.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var num = this.evtParams[0].value;
	        var gValue = rhPtr.rhApp.getGlobalValueAt(num);
	        var p = this.evtParams[1];
	        var value = p.tokens[0].value;
	        return gValue > value;
	    }
	}
	// CUT

	function CND_COMPAREGSTRING()
	{
	}
	CND_COMPAREGSTRING.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var num;
			if (this.evtParams[0].code == 59)
				num = rhPtr.get_EventExpressionInt(this.evtParams[0]) - 1;
			else
				num = this.evtParams[0].value;

			var gString = rhPtr.rhApp.getGlobalStringAt(num);
			var value = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			var comp = this.evtParams[1].comparaison;
			return CRun.compareTo(gString, value, comp);
		}
	}
	// CUT

	function CND_GROUPACTIVATED()
	{
	}
	CND_GROUPACTIVATED.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pEvg = rhPtr.rhEvtProg.events[this.evtParams[0].pointer];
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_INACTIVE) != 0)
				return CCnd.negaFALSE(this);
			return CCnd.negaTRUE(this);
		}
	}
	// CUT

	function CND_GROUPSTART()
	{
	}
	CND_GROUPSTART.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pEvg = rhPtr.rhEvtProg.rhEventGroup;
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_ONCE) != 0)
				return false;
			pEvg.evgFlags |= CEventGroup.EVGFLAGS_ONCE;
			return true;
		}
	}
	// CUT

	function CND_NOMORE()
	{
	}
	CND_NOMORE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pEvg = rhPtr.rhEvtProg.rhEventGroup;
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_NOMORE) != 0)
				return true;
			if ((pEvg.evgFlags & (CEventGroup.EVGFLAGS_REPEAT | CEventGroup.EVGFLAGS_NOTALWAYS)) != 0)
				return false;

			if (this.evtParams[0].code == CParam.PARAM_EXPRESSIONNUM)
				pEvg.evgInhibit = rhPtr.get_EventExpressionInt(this.evtParams[0]) / 10;
			else
				pEvg.evgInhibit = (this.evtParams[0].timer / 10);
			pEvg.evgInhibitCpt = 0;
			pEvg.evgFlags |= CEventGroup.EVGFLAGS_NOMORE;
			return true;
		}
	}
	// CUT

	function CND_NOTALWAYS()
	{
	}
	CND_NOTALWAYS.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pEvg = rhPtr.rhEvtProg.rhEventGroup;
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_NOTALWAYS) != 0)
				return true;
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_NOMORE) != 0)
				return false;
			pEvg.evgInhibit = -2;
			pEvg.evgFlags |= CEventGroup.EVGFLAGS_NOTALWAYS;
			return true;
		}
	}
	// CUT

	function CND_ONCE()
	{
	}
	CND_ONCE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pEvg = rhPtr.rhEvtProg.rhEventGroup;
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_ONCE) != 0)
				return false;
			pEvg.evgFlags |= CEventGroup.EVGFLAGS_ONCE;
			return true;
		}
	}
	// CUT

	function CND_ONLOOP()
	{
	}
	CND_ONLOOP.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			var pExp = this.evtParams[0];
			if (pExp.tokens.length == 2 && pExp.tokens[0].code == ((3 << 16) | 65535) && pExp.tokens[1].code == 0)
			{
				if (CServices.compareStringsIgnoreCase(rhPtr.rh4CurrentFastLoop, pExp.tokens[0].string))
				{
					return true;
				}
				return false;
			}

			var pName = rhPtr.get_EventExpressionString(pExp);
			if (CServices.compareStringsIgnoreCase(rhPtr.rh4CurrentFastLoop, pName) == false)
				return false;
			rhPtr.rhEvtProg.rh2ActionOn = false;
			return true;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	function CND_REPEAT()
	{
	}
	CND_REPEAT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pEvg = rhPtr.rhEvtProg.rhEventGroup;
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_REPEAT) != 0)
				return true;
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_NOMORE) != 0)
				return false;

			pEvg.evgInhibitCpt = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			pEvg.evgFlags |= CEventGroup.EVGFLAGS_REPEAT;
			return true;
		}
	}
	// CUT


	// Create object conditions
	// -----------------------------------------------------------------
	function CND_CHOOSEALL()
	{
	}
	CND_CHOOSEALL.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ObjectsFromType(0, -1);
			if (rhPtr.rhEvtProg.evtNSelectedObjects == 0)
				return false;
			var rnd = rhPtr.random(rhPtr.rhEvtProg.evtNSelectedObjects);
			var pHo = rhPtr.rhEvtProg.count_ObjectsFromType(0, rnd);
			rhPtr.rhEvtProg.evt_DeleteCurrent();
			rhPtr.rhEvtProg.evt_AddCurrentObject(pHo);
			return true;
		}
	}
	// CUT

	function CND_CHOOSEALL_OLD()
	{
	}
	CND_CHOOSEALL_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ObjectsFromType(COI.OBJ_SPR, -1);
			if (rhPtr.rhEvtProg.evtNSelectedObjects == 0)
				return false;
			var rnd = rhPtr.random(rhPtr.rhEvtProg.evtNSelectedObjects);
			var pHo = rhPtr.rhEvtProg.count_ObjectsFromType(COI.OBJ_SPR, rnd);
			rhPtr.rhEvtProg.evt_DeleteCurrentType(COI.OBJ_SPR);
			rhPtr.rhEvtProg.evt_AddCurrentObject(pHo);
			return true;
		}
	}
	// CUT

	function CND_CHOOSEALLINLINE()
	{
	}
	CND_CHOOSEALLINLINE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var x1 = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var y1 = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			var x2 = rhPtr.get_EventExpressionInt(this.evtParams[2]);
			var y2 = rhPtr.get_EventExpressionInt(this.evtParams[3]);

			if (rhPtr.rhEvtProg.select_LineOfSight(x1, y1, x2, y2) != 0)
				return true;
			return false;
		}
	}
	// CUT

	function CND_CHOOSEALLINZONE()
	{
	}
	CND_CHOOSEALLINZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rhEvtProg.select_ZoneTypeObjects(this.evtParams[0], 0) != 0)
				return true;
			return false;
		}
	}
	// CUT

	function CND_CHOOSEALLINZONE_OLD()
	{
	}
	CND_CHOOSEALLINZONE_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rhEvtProg.select_ZoneTypeObjects(this.evtParams[0], COI.OBJ_SPR) != 0)
				return true;
			return false;
		}
	}
	// CUT

	function CND_CHOOSEFLAGRESET()
	{
	}
	CND_CHOOSEFLAGRESET.prototype = CServices.extend(new CCnd(),
		{
			eva1:     function (rhPtr, hoPtr)
			{
				return this.eva2(rhPtr);
			},
			eva2:     function (rhPtr)
			{
				return this.evaChooseValue(rhPtr, this);
			},
			evaluate: function (pHo, value)
			{
				if (pHo.rov != null)
				{
					if ((pHo.rov.rvValueFlags & (1 << value)) == 0)
						return true;
				}
				return false;
			}
		});
	// CUT

	function CND_CHOOSEFLAGRESET_OLD()
	{
	}
	CND_CHOOSEFLAGRESET_OLD.prototype = CServices.extend(new CCnd(),
		{
			eva1:     function (rhPtr, hoPtr)
			{
				return this.eva2(rhPtr);
			},
			eva2:     function (rhPtr)
			{
				return this.evaChooseValueOld(rhPtr, this);
			},
			evaluate: function (pHo, value)
			{
				if (pHo.rov != null)
				{
					if ((pHo.rov.rvValueFlags & (1 << value)) == 0)
						return true;
				}
				return false;
			}
		});
	// CUT

	function CND_CHOOSEFLAGSET()
	{
	}
	CND_CHOOSEFLAGSET.prototype = CServices.extend(new CCnd(),
		{
			eva1:     function (rhPtr, hoPtr)
			{
				return this.eva2(rhPtr);
			},
			eva2:     function (rhPtr)
			{
				return this.evaChooseValue(rhPtr, this);
			},
			evaluate: function (pHo, value)
			{
				if (pHo.rov != null)
				{
					if ((pHo.rov.rvValueFlags & (1 << value)) != 0)
						return true;
				}
				return false;
			}
		});
	// CUT

	function CND_CHOOSEFLAGSET_OLD()
	{
	}
	CND_CHOOSEFLAGSET_OLD.prototype = CServices.extend(new CCnd(),
		{
			eva1:     function (rhPtr, hoPtr)
			{
				return this.eva2(rhPtr);
			},
			eva2:     function (rhPtr)
			{
				return this.evaChooseValueOld(rhPtr, this);
			},
			evaluate: function (pHo, value)
			{
				if (pHo.rov != null)
				{
					if ((pHo.rov.rvValueFlags & (1 << value)) != 0)
						return true;
				}
				return false;
			}
		});
	// CUT

	function CND_CHOOSEVALUE()
	{
	}
	CND_CHOOSEVALUE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var cpt = 0;

			var pHo = rhPtr.rhEvtProg.evt_FirstObjectFromType(-1);
			while (pHo != null)
			{
				cpt++;

				var number;
				if (this.evtParams[0].code == 53)
					number = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				else
					number = this.evtParams[0].value;
				var value2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);

				if (pHo.rov != null)
				{
					var value = pHo.rov.getValue(number);
					var comp = this.evtParams[1].comparaison;
					if (CRun.compareTo(value, value2, comp) == false)
					{
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
						cpt--;
					}
				}
				pHo = rhPtr.rhEvtProg.evt_NextObjectFromType();
			}
			;
			if (cpt != 0)
				return true;
			return false;
		}
	}
	// CUT

	function CND_CHOOSEVALUE_OLD()
	{
	}
	CND_CHOOSEVALUE_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var cpt = 0;

			var pHo = rhPtr.rhEvtProg.evt_FirstObjectFromType(COI.OBJ_SPR);
			while (pHo != null)
			{
				cpt++;

				var number;
				if (evtParams[0].code == 53)
					number = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				else
					number = this.evtParams[0].value;
				var value2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);

				if (pHo.rov != null)
				{
					var value = pHo.rov.getValue(number);
					var comp = this.evtParams[1].comparaison;
					if (CRun.compareTo(value, value2, comp) == false)
					{
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
						cpt--;
					}
				}
				pHo = rhPtr.rhEvtProg.evt_NextObjectFromType();
			}
			;
			if (cpt != 0)
				return true;
			return false;
		}
	}
	// CUT

	function CND_CHOOSEZONE()
	{
	}
	CND_CHOOSEZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var p = this.evtParams[0];
			rhPtr.rhEvtProg.count_ZoneTypeObjects(p, -1, 0);
			if (rhPtr.rhEvtProg.evtNSelectedObjects == 0)
				return false;

			var rnd = rhPtr.random(rhPtr.rhEvtProg.evtNSelectedObjects);
			var pHo = rhPtr.rhEvtProg.count_ZoneTypeObjects(p, rnd, 0);
			rhPtr.rhEvtProg.evt_DeleteCurrent();
			rhPtr.rhEvtProg.evt_AddCurrentObject(pHo);
			return true;
		}
	}
	// CUT

	function CND_CHOOSEZONE_OLD()
	{
	}
	CND_CHOOSEZONE_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var p = this.evtParams[0];
			rhPtr.rhEvtProg.count_ZoneTypeObjects(p, -1, COI.OBJ_SPR);
			if (rhPtr.rhEvtProg.evtNSelectedObjects == 0)
				return false;

			var rnd = rhPtr.random(rhPtr.rhEvtProg.evtNSelectedObjects);
			var pHo = rhPtr.rhEvtProg.count_ZoneTypeObjects(p, rnd, COI.OBJ_SPR);
			rhPtr.rhEvtProg.evt_DeleteCurrent();
			rhPtr.rhEvtProg.evt_AddCurrentObject(pHo);
			return true;
		}
	}
	// CUT

	function CND_NOMOREALLZONE()
	{
	}
	CND_NOMOREALLZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ZoneTypeObjects(this.evtParams[0], -1, 0);
			if (rhPtr.rhEvtProg.evtNSelectedObjects != 0)
				return false;
			return true;
		}
	}
	// CUT

	function CND_NOMOREALLZONE_OLD()
	{
	}
	CND_NOMOREALLZONE_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ZoneTypeObjects(this.evtParams[0], -1, COI.OBJ_SPR);
			if (rhPtr.rhEvtProg.evtNSelectedObjects != 0)
				return false;
			return true;
		}
	}
	// CUT

	function CND_NUMOFALLOBJECT()
	{
	}
	CND_NUMOFALLOBJECT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			var comp = this.evtParams[0].comparaison;
			return CRun.compareTo(rhPtr.rhNObjects, value2, comp);
		}
	}
	// CUT

	function CND_NUMOFALLOBJECT_OLD()
	{
	}
	CND_NUMOFALLOBJECT_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ObjectsFromType(COI.OBJ_SPR, -1);
			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			var comp = this.evtParams[0].comparaison;
			return CRun.compareTo(rhPtr.rhEvtProg.evtNSelectedObjects, value2, comp);
		}
	}
	// CUT

	function CND_NUMOFALLZONE()
	{
	}
	CND_NUMOFALLZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ZoneTypeObjects(this.evtParams[0], -1, 0);
			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			var comp = this.evtParams[1].comparaison;
			return CRun.compareTo(rhPtr.rhEvtProg.evtNSelectedObjects, value2, comp);
		}
	}
	// CUT

	function CND_NUMOFALLZONE_OLD()
	{
	}
	CND_NUMOFALLZONE_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ZoneTypeObjects(this.evtParams[0], -1, COI.OBJ_SPR);

			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);
			var comp = this.evtParams[1].comparaison;
			return CRun.compareTo(rhPtr.rhEvtProg.evtNSelectedObjects, value2, comp);
		}
	}
	// CUT

	function CND_PICKFROMID()
	{
	}
	CND_PICKFROMID.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			return rhPtr.rhEvtProg.pickFromId(value);
		}
	}
	// CUT

	function CND_PICKFROMID_OLD()
	{
	}
	CND_PICKFROMID_OLD.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			return rhPtr.rhEvtProg.pickFromId(value);
		}
	}
	// CUT

	function CND_EXTCHOOSE()
	{
	}
	CND_EXTCHOOSE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			rhPtr.rhEvtProg.count_ObjectsFromOiList(this.evtOiList, -1);
			if (rhPtr.rhEvtProg.evtNSelectedObjects == 0)
				return false;
			var rnd = rhPtr.random(rhPtr.rhEvtProg.evtNSelectedObjects);
			var pHo = rhPtr.rhEvtProg.count_ObjectsFromOiList(this.evtOiList, rnd);
			rhPtr.rhEvtProg.evt_ForceOneObject(this.evtOiList, pHo);
			return true;
		}
	}
	// CUT

	function CND_EXTONLOOP()
	{
	}
	CND_EXTONLOOP.prototype =
	{
		eva1: function (rhPtr, pHo)
		{
			var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);
			if (rhPtr.rh4CurrentForEach != null)
			{
				if (CServices.compareStringsIgnoreCase(rhPtr.rh4CurrentForEach.name, pName))
				{
					rhPtr.rhEvtProg.evt_ForceOneObject(this.evtOiList, pHo);
					return true;
				}
			}
			if (rhPtr.rh4CurrentForEach2 != null)
			{
				if (CServices.compareStringsIgnoreCase(rhPtr.rh4CurrentForEach2.name, pName))
				{
					rhPtr.rhEvtProg.evt_ForceOneObject(this.evtOiList, pHo);
					return true;
				}
			}
			return false;
		},
		eva2: function (rhPtr)
		{
			var pHo2 = null;
			var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);
			var pForEach = rhPtr.rh4CurrentForEach;
			if (pForEach != null)
			{
				if (CServices.compareStringsIgnoreCase(pForEach.name, pName))
				{
				    if (pForEach.oi == this.evtOiList)
					{
						var index = pForEach.index % pForEach.number;
						pHo2 = pForEach.objects[index];
					}
				}
			}
			pForEach = rhPtr.rh4CurrentForEach2;
			if (pForEach != null)
			{
				if (CServices.compareStringsIgnoreCase(pForEach.name, pName))
				{
				    if (pForEach.oi == this.evtOiList)
					{
						var index = pForEach.index % pForEach.number;
						pHo2 = pForEach.objects[index];
					}
				}
			}
			if (pHo2 != null)
			{
				rhPtr.rhEvtProg.evt_ForceOneObject(this.evtOiList, pHo2);
				return true;
			}
			return false;
		}
	}
	// CUT


	// Storyboard object
	// ---------------------------------------------------------------------
	function CND_ENDOFPAUSE()
	{
	}
	CND_ENDOFPAUSE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rh4EndOfPause != rhPtr.rhLoopCount - 1)
				return false;
			return true;
		}
	}
	// CUT


	function CND_ISVSYNCON()
	{
	}
	CND_ISVSYNCON.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return (rhPtr.rhApp.gaNewFlags & CRunApp.GANF_VSYNC) != 0 && window.requestAnimationFrame;
			;
		},
		eva2: function (rhPtr)
		{
			return (rhPtr.rhApp.gaNewFlags & CRunApp.GANF_VSYNC) != 0 && window.requestAnimationFrame;
			;
		}
	}
	// CUT

	function CND_ISLADDER()
	{
	}
	CND_ISLADDER.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var x = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			var y = rhPtr.get_EventExpressionInt(this.evtParams[1]);

			if (rhPtr.y_GetLadderAt(-1, x, y) != null)
				return CCnd.negaTRUE(this);
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_ISOBSTACLE()
	{
	}
	CND_ISOBSTACLE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var x = rhPtr.get_EventExpressionInt(this.evtParams[0]) - rhPtr.rhWindowX;
			var y = rhPtr.get_EventExpressionInt(this.evtParams[1]) - rhPtr.rhWindowY;

			if (rhPtr.colMask_Test_XY(x, y, -1, CRunFrame.CM_TEST_OBSTACLE))
				return CCnd.negaTRUE(this);
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_QUITAPPLICATION()
	{
	}
	CND_QUITAPPLICATION.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	function CND_START()
	{
	}
	CND_START.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			if (rhPtr.rhLoopCount > 2)
				return false;
			return true;
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rhLoopCount > 2)
				return false;
			return true;
		}
	}
	// CUT


	// Timer object
	// -----------------------------------------------------------------------
	function CND_ONEVENT()
	{
	}
	CND_ONEVENT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);
			return CServices.compareStringsIgnoreCase(pName, rhPtr.rhEvtProg.rhCurParam0);
		}
	}
	// CUT
	function CND_EVERY()
	{
	}
	CND_EVERY.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var p = this.evtParams[0];
			p.compteur -= rhPtr.rhTimerDelta;
			if (p.compteur > 0)
				return false;
			p.compteur += p.delay;
			return true;
		}
	}
	// CUT

	function CND_TIMEOUT()
	{
	}
	CND_TIMEOUT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var time;
			if (this.evtParams[0].code == 22)
				time = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				time = this.evtParams[0].timer;

			if (rhPtr.rh4TimeOut > time)
				return true;
			return false;
		}
	}
	// CUT

	function CND_TIMER()
	{
	}
	CND_TIMER.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			if ((this.evtFlags & CEvent.EVFLAGS_DONE) != 0)
				return  false;

			var time = this.evtParams[0].timer;
			if (rhPtr.rhTimer < time)
				return false;
			this.evtFlags |= CEvent.EVFLAGS_DONE;
			return true;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	function CND_TIMERINF()
	{
	}
	CND_TIMERINF.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var time;
			if (this.evtParams[0].code == 22)
				time = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				time = this.evtParams[0].timer;

			if (rhPtr.rhTimer > time)
				return false;

			return true;
		}
	}
	// CUT

	function CND_EVERY2()
	{
	}
	CND_EVERY2.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var param2 = this.evtParams[1];
			var time;

			if (param2.value2 == 0)
			{
				if (this.evtParams[0].code == 22)
					time = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				else
					time = this.evtParams[0].timer;
				param2.value = time;
				param2.value2 = -1;
			}
			else
			{
				param2.value -= rhPtr.rhTimerDelta;
				if (param2.value <= 0)
				{
					if (this.evtParams[0].code == 22)
						time = rhPtr.get_EventExpressionInt(this.evtParams[0]);
					else
						time = this.evtParams[0].timer;
					param2.value += time;
					return true;
				}
			}
			return false;
		}
	}
	// CUT

	function CND_TIMEREQUALS()
	{
	}
	CND_TIMEREQUALS.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var time;
			if (this.evtParams[0].code == 22)
				time = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				time = this.evtParams[0].timer;

			var param2 = this.evtParams[1];
			if (rhPtr.rhTimer >= time)
			{
				if (param2.value == rhPtr.rhLoopCount)
				{
					param2.value = rhPtr.rhLoopCount + 1;
					return false;
				}
				param2.value = rhPtr.rhLoopCount + 1;
				return true;
			}
			return false;
		}
	}
	// CUT

	function CND_TIMERSUP()
	{
	}
	CND_TIMERSUP.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var time;
			if (this.evtParams[0].code == 22)
				time = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			else
				time = this.evtParams[0].timer;

			if (rhPtr.rhTimer > time)
				return true;

			return false;
		}
	}
	// CUT


	// Player object
	// --------------------------------------------------------------------
	function CND_JOYPRESSED()
	{
	}
	CND_JOYPRESSED.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			var joueur = this.evtOi;
			if (joueur != rhPtr.rhEvtProg.rhCurOi)
				return false;

			var j = rhPtr.rhEvtProg.rhCurParam0;
			j &= this.evtParams[0].value;
			if (j != this.evtParams[0].value)
				return false;
			return true;
		},
		eva2: function (rhPtr)
		{
			var joueur = this.evtOi;
			var b = (rhPtr.rh2NewPlayer[joueur] & rhPtr.rhPlayer[joueur]);

			var s = b;
			s &= this.evtParams[0].value;
			if (this.evtParams[0].value != s)
				return false;
			return true;
		}
	}
	// CUT

	function CND_JOYPUSHED()
	{
	}
	CND_JOYPUSHED.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var s = rhPtr.rhPlayer[this.evtOi];
			s &= this.evtParams[0].value;
			if (s != this.evtParams[0].value)
				return CCnd.negaFALSE(this);
			return CCnd.negaTRUE(this);
		}
	}
	// CUT

	function CND_LIVE()
	{
	}
	CND_LIVE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			var comp = this.evtParams[0].comparaison;
			return CRun.compareTo(rhPtr.rhApp.getLives()[this.evtOi], value2, comp);
		}
	}
	// CUT

	function CND_NOMORELIVE()
	{
	}
	CND_NOMORELIVE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rhApp.getLives()[this.evtOi] != 0)
				return false;
			return true;
		}
	}
	// CUT

	// TODO dans tous les runtimes
	function CND_PLAYERPLAYING()
	{
	}
	CND_PLAYERPLAYING.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return false;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	function CND_SCORE()
	{
	}
	CND_SCORE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var scores = rhPtr.rhApp.getScores();
			var value2 = rhPtr.get_EventExpressionAny(this.evtParams[0]);
			var comp = this.evtParams[0].comparaison;
			return CRun.compareTo(scores[this.evtOi], value2, comp);
		}
	}
	// CUT


	// Keyboard object
	// -------------------------------------------------------------------
	function CND_KBKEYDEPRESSED()
	{
	}
	CND_KBKEYDEPRESSED.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			return CCnd.negate(this, rhPtr.rhApp.keyBuffer[this.evtParams[0].key]);
		}
	}
	// CUT

	function CND_KBPRESSKEY()
	{
	}
	CND_KBPRESSKEY.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rhApp.keyBuffer[this.evtParams[0].key] == false)
				return CCnd.negaFALSE(this);
			if (CCnd.compute_GlobalNoRepeat(rhPtr))
				return CCnd.negaTRUE(this);
			else
				return CCnd.negaFALSE(this);
		}
	}

	// CUT
	function CND_MCLICK()
	{
	}
	CND_MCLICK.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			var key = rhPtr.rhEvtProg.rhCurParam0;
			if (this.evtParams[0].value != key)
				return false;
			return true;
		},
		eva2: function (rhPtr)
		{
			if (this.evtParams[0].value == rhPtr.rhEvtProg.rh2CurrentClick)
				return true;
			return false;
		}
	}
	// CUT

	function CND_MCLICKINZONE()
	{
	}
	CND_MCLICKINZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			var key = rhPtr.rhEvtProg.rhCurParam0;
			if (this.evtParams[0].value == key)
			{
				var p = this.evtParams[1];
				if (rhPtr.rh2MouseX >= p.x1 && rhPtr.rh2MouseX < p.x2 && rhPtr.rh2MouseY >= p.y1 && rhPtr.rh2MouseY < p.y2)
				{
					return true;
				}
			}
			return false;
		},
		eva2: function (rhPtr)
		{
			if (this.evtParams[0].value == rhPtr.rhEvtProg.rh2CurrentClick)
			{
				var p = this.evtParams[1];
				if (rhPtr.rh2MouseX >= p.x1 && rhPtr.rh2MouseX < p.x2 && rhPtr.rh2MouseY >= p.y1 && rhPtr.rh2MouseY < p.y2)
				{
					return true;
				}
			}
			return false;
		}
	}
	// CUT

	function CND_MCLICKONOBJECT()
	{
	}
	CND_MCLICKONOBJECT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			var p = this.evtParams[0];
			if (rhPtr.rhEvtProg.rhCurParam0 != p.value)
				return false;

			var oi = rhPtr.rhEvtProg.rhCurParam1;
			var po = this.evtParams[1];
			if (oi == po.oi)
			{
				rhPtr.rhEvtProg.evt_AddCurrentObject(rhPtr.rhEvtProg.rh4_2ndObject);
				return true;
			}

			var oil = po.oiList;
			if ((oil & 0x8000) == 0)
				return false;
			var qoil = rhPtr.rhEvtProg.qualToOiList[oil & 0x7FFF];
			var qoi;
			for (qoi = 0; qoi < qoil.qoiList.length; qoi += 2)
			{
				if (qoil.qoiList[qoi] == oi)
				{
					rhPtr.rhEvtProg.evt_AddCurrentQualifier(oil);
					rhPtr.rhEvtProg.evt_AddCurrentObject(rhPtr.rhEvtProg.rh4_2ndObject);
					return true;
				}
			}
			return false;
		},
		eva2: function (rhPtr)
		{
			var p = this.evtParams[0];
			if (rhPtr.rhEvtProg.rh2CurrentClick != p.value)
				return false;

			var po = this.evtParams[1];
			return rhPtr.getMouseOnObjectsEDX(po.oiList, false);
		}
	}
	// CUT

	function CND_MINZONE()
	{
	}
	CND_MINZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var p = this.evtParams[0];
			if (rhPtr.rh2MouseX >= p.x1 && rhPtr.rh2MouseX < p.x2 && rhPtr.rh2MouseY >= p.y1 && rhPtr.rh2MouseY < p.y2)
				return CCnd.negaTRUE(this);
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_MKEYDEPRESSED()
	{
	}
	CND_MKEYDEPRESSED.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var code = 0;
			switch (this.evtParams[0].key)
			{
				case 1:
					code = CRunApp.VK_LBUTTON;
					break;
				case 2:
					code = CRunApp.VK_RBUTTON;
					break;
				case 4:
					code = CRunApp.VK_MBUTTON;
					break;
			}
			if (rhPtr.rhApp.keyBuffer[code] == false)
				return CCnd.negaFALSE(this);
			return CCnd.negaTRUE(this);
		}
	}
	// CUT

	function CND_MONOBJECT()
	{
	}
	CND_MONOBJECT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var flag = (this.evtFlags2 & CEvent.EVFLAG2_NOT) != 0;
			return rhPtr.getMouseOnObjectsEDX(this.evtParams[0].oiList, flag);
		}
	}
	// CUT

	function CND_MOUSEON()
	{
	}
	CND_MOUSEON.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.isMouseOn())
			{
				return CCnd.negaTRUE(this);
			}
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_ONMOUSEWHEELDOWN()
	{
	}
	CND_ONMOUSEWHEELDOWN.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rhWheelCount == rhPtr.rh4EventCount)
			{
				return true;
			}
			return false;
		}
	}
	// CUT

	function CND_ONMOUSEWHEELUP()
	{
	}
	CND_ONMOUSEWHEELUP.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			if (rhPtr.rhWheelCount == rhPtr.rh4EventCount)
			{
				return true;
			}
			return false;
		}
	}
	// CUT

	function CND_ANYKEY()
	{
	}
	CND_ANYKEY.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	// Speaker object
	// -----------------------------------------------------------------------
	function CND_NOSAMPLAYING()
	{
	}
	CND_NOSAMPLAYING.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			if (!rhPtr.rhApp.soundPlayer.isSoundPlaying())
			{
				return CCnd.negaTRUE(this);
			}
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_NOSPCHANNELPLAYING()
	{
	}
	CND_NOSPCHANNELPLAYING.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (!rhPtr.rhApp.soundPlayer.isChannelPlaying(channel - 1))
			{
				return CCnd.negaTRUE(this);
			}
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_NOSPSAMPLAYING()
	{
	}
	CND_NOSPSAMPLAYING.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			if (!rhPtr.rhApp.soundPlayer.isSamplePlaying(this.evtParams[0].sndHandle))
			{
				return CCnd.negaTRUE(this);
			}
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_SPCHANNELPAUSED()
	{
	}
	CND_SPCHANNELPAUSED.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var channel = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (rhPtr.rhApp.soundPlayer.isChannelPaused(channel - 1))
			{
				return CCnd.negaTRUE(this);
			}
			return CCnd.negaFALSE(this);
		}
	}
	// CUT

	function CND_SPSAMPAUSED()
	{
	}
	CND_SPSAMPAUSED.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var p = this.evtParams[0];
			if (rhPtr.rhApp.soundPlayer.isSamplePaused(p.sndHandle))
			{
				return CCnd.negaTRUE(this);
			}
			return CCnd.negaFALSE(this);
		}
	}
	// CUT


	// Question and Answer object
	// --------------------------------------------------------------
	function CND_QEQUAL()
	{
	}
	CND_QEQUAL.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			var num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			if (rhPtr.rhEvtProg.rhCurParam0 == num)
				return true;
			return false;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	function CND_QEXACT()
	{
	}
	CND_QEXACT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	function CND_QFALSE()
	{
	}
	CND_QFALSE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return true;
		},
		eva2: function (rhPtr)
		{
			return false;
		}
	}
	// CUT

	// Sub-Application object
	// ------------------------------------------------------------
	function CND_CCAAPPFINISHED()
	{
	}
	CND_CCAAPPFINISHED.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, hoPtr.appFinished());
			}
		});
	// CUT

	function CND_CCAFRAMECHANGED()
	{
	}
	CND_CCAFRAMECHANGED.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, hoPtr.frameChanged());
			}
		});
	// CUT

	function CND_CCAISPAUSED()
	{
	}
	CND_CCAISPAUSED.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, hoPtr.isPaused());
			}
		});
	// CUT

	function CND_CCAISVISIBLE()
	{
	}
	CND_CCAISVISIBLE.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, hoPtr.isVisible());
			}
		});
	// CUT

	// Counter object
	// -------------------------------------------------------------
	function CND_CCOUNTER()
	{
	}
	CND_CCOUNTER.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
			var cpt = rhPtr.rhEvtProg.evtNSelectedObjects;
			var value1, value2;
			while (pHo != null)
			{
				value1 = pHo.cpt_GetValue();
				value2 = rhPtr.get_EventExpressionAny(this.evtParams[0]);
				if (CRun.compareTo(value1, value2, this.evtParams[0].comparaison) == false)
				{
					cpt--;
					rhPtr.rhEvtProg.evt_DeleteCurrentObject();
				}
				pHo = rhPtr.rhEvtProg.evt_NextObject();
			}
			;
			return (cpt != 0);
		}
	}
	// CUT

	// Active and extension objects
	// ----------------------------------------------------------------
	function CND_EXTHIDDEN()
	{
	}
	CND_EXTHIDDEN.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				if ((hoPtr.ros.rsFlags & CRSpr.RSFLAG_HIDDEN) != 0)
					return true;
				return false;
			}
		});
	// CUT

	function CND_EXTANIMENDOF()
	{
	}
	CND_EXTANIMENDOF.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				var ani;
				if (this.evtParams[0].code == 10)
					ani = this.evtParams[0].value;
				else
					ani = rhPtr.get_EventExpressionInt(this.evtParams[0]);

				if (ani != rhPtr.rhEvtProg.rhCurParam0)
					return false;
				rhPtr.rhEvtProg.evt_AddCurrentObject(hoPtr);
				return true;
			},
			eva2:             function (rhPtr)
			{
				if (this.evtParams[0].code == 10)
					return this.evaObject(rhPtr, this);
				return this.evaExpObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				var anim = this.evtParams[0].value;
				if (anim != hoPtr.roa.raAnimOn)
					return false;
				if (hoPtr.roa.raAnimNumberOfFrame == 0)
					return true;
				return false;
			},
			evaExpRoutine:    function (hoPtr, value, comp)
			{
				if (value != hoPtr.roa.raAnimOn)
					return false;
				if (hoPtr.roa.raAnimNumberOfFrame == 0)
					return true;
				return false;
			}
		});
	// CUT

	function CND_EXTANIMPLAYING()
	{
	}
	CND_EXTANIMPLAYING.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.eva2(rhPtr);
			},
			eva2:             function (rhPtr)
			{
				if (this.evtParams[0].code == 10)
					return this.evaObject(rhPtr, this);
				return this.evaExpObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				var anim = this.evtParams[0].value;
				if (anim != hoPtr.roa.raAnimOn)
					return CCnd.negaFALSE(this);
				if (hoPtr.roa.raAnimNumberOfFrame != 0)
					return CCnd.negaTRUE(this);
				return CCnd.negaFALSE(this);
			},
			evaExpRoutine:    function (hoPtr, value, comp)
			{
				if (value != hoPtr.roa.raAnimOn)
					return CCnd.negaFALSE(this);
				if (hoPtr.roa.raAnimNumberOfFrame != 0)
					return CCnd.negaTRUE(this);
				return CCnd.negaFALSE(this);
			}
		});
	// CUT

	function CND_EXTBOUNCING()
	{
	}
	CND_EXTBOUNCING.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, hoPtr.rom.rmBouncing);
			}
		});
	// CUT

	function CND_EXTCMPACC()
	{
	}
	CND_EXTCMPACC.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				return CRun.compareTer(hoPtr.rom.rmMovement.rmAcc, value, comp);
			}
		});
	// CUT

	function CND_EXTCMPDEC()
	{
	}
	CND_EXTCMPDEC.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				return CRun.compareTer(hoPtr.rom.rmMovement.rmDec, value, comp);
			}
		});
	// CUT

	function CND_EXTCMPFRAME()
	{
	}
	CND_EXTCMPFRAME.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				return CRun.compareTer(hoPtr.roa.raAnimFrame, value, comp);
			}
		});
	// CUT

	function CND_EXTCMPSPEED()
	{
	}
	CND_EXTCMPSPEED.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				return CRun.compareTer(hoPtr.roc.rcSpeed, value, comp);
			}
		});
	// CUT

	function CND_EXTCMPVAR()
	{
	}
	CND_EXTCMPVAR.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
			if (pHo == null) return false;

			var cpt = rhPtr.rhEvtProg.evtNSelectedObjects;
			var value1;
			var value2;
			var p = this.evtParams[1];
			do
			{
				var num;
				if (this.evtParams[0].code == 53)
					num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				else
					num = this.evtParams[0].value;

				if (num >= 0 && pHo.rov != null)
				{
					if (num < pHo.rov.rvValues.length)
						value1 = pHo.rov.getValue(num);
					else
						value1 = 0;
					value2 = rhPtr.get_EventExpressionAny(p);

					if (CRun.compareTo(value1, value2, p.comparaison) == false)
					{
						cpt--;
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
					}
				}
				else
				{
					cpt--;
					rhPtr.rhEvtProg.evt_DeleteCurrentObject();
				}
				pHo = rhPtr.rhEvtProg.evt_NextObject();
			} while (pHo != null);
			return (cpt != 0);
		}
	}
	// -- CUT

	function CND_EXTCMPVARCONST() {
	}
	CND_EXTCMPVARCONST.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
	        if (pHo == null) return false;

	        var cpt = rhPtr.rhEvtProg.evtNSelectedObjects;
	        var num = this.evtParams[0].value;
	        var p = this.evtParams[1];
	        var value1;
	        var value2 = p.tokens[0].value;
	        do {

	            if (num >= 0 && pHo.rov != null)
	            {
	                if (num < pHo.rov.rvValues.length)
	                    value1 = pHo.rov.getValue(num);
	                else
	                    value1 = 0;

	                if (CRun.compareTo(value1, value2, p.comparaison) == false) {
	                    cpt--;
	                    rhPtr.rhEvtProg.evt_DeleteCurrentObject();
	                }
	            }
	            else {
	                cpt--;
	                rhPtr.rhEvtProg.evt_DeleteCurrentObject();
	            }
	            pHo = rhPtr.rhEvtProg.evt_NextObject();
	        } while (pHo != null);
	        return (cpt != 0);
	    }
	}
	// CUT

	function CND_EXTCMPVARFIXED()
	{
	}
	CND_EXTCMPVARFIXED.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				var fixed = (hoPtr.hoCreationId << 16) | ( (hoPtr.hoNumber) & 0xFFFF );
				return CRun.compareTer(fixed, value, comp);
			}
		});
	// CUT

	function CND_EXTCMPVARSTRING()
	{
	}
	CND_EXTCMPVARSTRING.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.evt_FirstObject(this.evtOiList);
			if (pHo == null) return false;

			var cpt = rhPtr.rhEvtProg.evtNSelectedObjects;
			var value1;
			var value2;
			do
			{
				var num;
				if (this.evtParams[0].code == 62)
					num = rhPtr.get_EventExpressionInt(this.evtParams[0]);
				else
					num = this.evtParams[0].value;

				if (num >= 0 && num < CRVal.STRINGS_NUMBEROF_ALTERABLE && pHo.rov != null)
				{
					value1 = pHo.rov.getString(num);
					value2 = rhPtr.get_EventExpressionAny(this.evtParams[1]);

					if (CRun.compareTo(value1, value2, this.evtParams[1].comparaison) == false)
					{
						cpt--;
						rhPtr.rhEvtProg.evt_DeleteCurrentObject();
					}
				}
				else
				{
					cpt--;
					rhPtr.rhEvtProg.evt_DeleteCurrentObject();
				}
				pHo = rhPtr.rhEvtProg.evt_NextObject();
			} while (pHo != null);
			return (cpt != 0);
		}
	}
	// CUT

	function CND_EXTCMPX()
	{
	}
	CND_EXTCMPX.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				return CRun.compareTer(hoPtr.hoX, value, comp);
			}
		});
	// CUT

	function CND_EXTCMPY()
	{
	}
	CND_EXTCMPY.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				return CRun.compareTer(hoPtr.hoY, value, comp);
			}
		});
	// CUT

	function CND_EXTCOLBACK()
	{
	}
	CND_EXTCOLBACK.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				if (this.compute_NoRepeat(hoPtr))
				{
					rhPtr.rhEvtProg.evt_AddCurrentObject(hoPtr);
					return true;
				}

				var pEvg = rhPtr.rhEvtProg.rhEventGroup;
				if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_STOPINGROUP) == 0)
					return false;
				rhPtr.rhEvtProg.rh3DoStop = true;
				return true;
			},
			eva2:             function (rhPtr)
			{
				return CCnd.negate(this, this.evaObject(rhPtr, this));
			},
			evaObjectRoutine: function (hoPtr)
			{
				return hoPtr.hoAdRunHeader.colMask_TestObject_IXY(hoPtr, hoPtr.roc.rcImage, hoPtr.roc.rcAngle, hoPtr.roc.rcScaleX, hoPtr.roc.rcScaleY, hoPtr.hoX, hoPtr.hoY, 0, CColMask.CM_TEST_PLATFORM);
			}
		});
	// CUT

	function CND_EXTCOLLISION()
	{
	}
	CND_EXTCOLLISION.prototype = CServices.extend(new CCnd(),
		{
			eva1:       function (rhPtr, pHo)
			{
				var pHo1 = rhPtr.rhObjectList[rhPtr.rhEvtProg.rh1stObjectNumber];
				if (pHo1 == null)
				{
					var toto = 2;
				}
				var oiEvent = this.evtOi;
				var p = this.evtParams[0];
				var oiParam = p.oi;

				while (true)
				{
					if (oiEvent == pHo.hoOi)
					{
						if (oiParam == pHo1.hoOi)
							break;
						if (oiParam >= 0)
							return false;
						if (this.colGetList(rhPtr, p.oiList, pHo1.hoOi))
							break;
						return false;
					}
					if (oiParam == pHo.hoOi)
					{
						if (oiEvent == pHo1.hoOi)
							break;
						if (oiEvent >= 0)
							return false;
						if (this.colGetList(rhPtr, this.evtOiList, pHo1.hoOi))
							break;
						return false;
					}
					if (oiEvent < 0)
					{
						if (oiParam < 0)
						{
							if (this.colGetList(rhPtr, this.evtOiList, pHo.hoOi))
							{
								if (this.colGetList(rhPtr, p.oiList, pHo1.hoOi))
									break;
								if (this.colGetList(rhPtr, p.oiList, pHo.hoOi) == false)
									return false;
								if (this.colGetList(rhPtr, this.evtOiList, pHo1.hoOi))
									break;
								return false;
							}
							else
							{
								if (this.colGetList(rhPtr, this.evtOiList, pHo1.hoOi))
									break;
								return false;
							}
						}
						else
						{
							if (oiParam == pHo1.hoOi)
								break;
							return false;
						}
					}
					if (oiParam >= 0)
						return false;
					if (oiEvent != pHo1.hoOi)
						return false;
					break;
				}

				var id = ( (pHo1.hoCreationId) << 16) | ((this.evtIdentifier) & 0x0000FFFF);
				if (CCnd.compute_NoRepeatCol(id, pHo) == false)
				{
					if ((rhPtr.rhEvtProg.rhEventGroup.evgFlags & CEventGroup.EVGFLAGS_STOPINGROUP) == 0)
						return false;
					rhPtr.rhEvtProg.rh3DoStop = true;
				}
				id = ( (pHo.hoCreationId) << 16) | ((this.evtIdentifier) & 0x0000FFFF);
				if (CCnd.compute_NoRepeatCol(id, pHo1) == false)
				{
					if ((rhPtr.rhEvtProg.rhEventGroup.evgFlags & CEventGroup.EVGFLAGS_STOPINGROUP) == 0)
						return false;
					rhPtr.rhEvtProg.rh3DoStop = true;
				}

				rhPtr.rhEvtProg.evt_AddCurrentObject(pHo);
				rhPtr.rhEvtProg.evt_AddCurrentObject(pHo1);

				if (pHo1.rom.rmMovement.rmCollisionCount == rhPtr.rh3CollisionCount)
					pHo.rom.rmMovement.rmCollisionCount = rhPtr.rh3CollisionCount;
				else if (pHo.rom.rmMovement.rmCollisionCount == rhPtr.rh3CollisionCount)
					pHo1.rom.rmMovement.rmCollisionCount = rhPtr.rh3CollisionCount;

				return true;
			},
			eva2:       function (rhPtr)
			{
				return this.isColliding(rhPtr);
			},
			colGetList: function (rhPtr, oiList, lookFor)
			{
				if (oiList == -1)
					return false;
				var qoil = rhPtr.rhEvtProg.qualToOiList[oiList & 0x7FFF];
				var index;
				for (index = 0; index < qoil.qoiList.length; index += 2)
				{
					if (qoil.qoiList[index] == lookFor)
						return true;
				}
				return false;
			}
		});
	// CUT

	function CND_EXTENDPATH()
	{
	}
	CND_EXTENDPATH.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return true;
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				if (hoPtr.roc.rcMovementType != CMoveDef.MVTYPE_TAPED)
					return false;
				return CCnd.checkMark(hoPtr.hoAdRunHeader, hoPtr.hoMark2);
			}
		});
	// CUT

	function CND_EXTFACING()
	{
	}
	CND_EXTFACING.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.eva2(rhPtr);
			},
			eva2:             function (rhPtr)
			{
				if (this.evtParams[0].code == 29)
					return this.evaObject(rhPtr, this);
				return this.evaExpObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				var mask = this.evtParams[0].value;
				var dir;
				for (dir = 0; dir < 32; dir++)
				{
					if (((1 << dir) & mask) != 0)
					{
						if (hoPtr.hoAdRunHeader.getDir(hoPtr) == dir)
						{
							return CCnd.negaTRUE(this);
						}
					}
				}
				return CCnd.negaFALSE(this);
			},
			evaExpRoutine:    function (hoPtr, value, comp)
			{
				value &= 31;
				return CCnd.negate(this, hoPtr.roc.rcDir == value);
			}
		});
	// CUT

	function CND_EXTFLAGRESET()
	{
	}
	CND_EXTFLAGRESET.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				value &= 31;
				if (hoPtr.rov != null)
				{
					if ((hoPtr.rov.rvValueFlags & (1 << value)) != 0) return false;
				}
				return true;
			}
		});
	// CUT

	function CND_EXTFLAGSET()
	{
	}
	CND_EXTFLAGSET.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, value, comp)
			{
				value &= 31;
				if (hoPtr.rov != null)
				{
					if ((hoPtr.rov.rvValueFlags & (1 << value)) != 0)
					{
						return true;
					}
				}
				return false;
			}
		});
	// CUT

	function CND_EXTINPLAYFIELD()
	{
	}
	CND_EXTINPLAYFIELD.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				var evpPtr = this.evtParams[0];
				if ((evpPtr.value & (rhPtr.rhEvtProg.rhCurParam0)) == 0)
					return false;

				if (this.compute_NoRepeat(hoPtr))
				{
					rhPtr.rhEvtProg.evt_AddCurrentObject(hoPtr);
					return true;
				}

				var pEvg = rhPtr.rhEvtProg.rhEventGroup;
				if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_STOPINGROUP) == 0)
					return false;
				rhPtr.rhEvtProg.rh3DoStop = true;
				return true;
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, (hoPtr.rom.rmEventFlags & CRMvt.EF_GOESOUTPLAYFIELD) != 0);
			}
		});
	// CUT

	function CND_EXTISBOLD()
	{
	}
	CND_EXTISBOLD.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				var info = CRun.getObjectFont(hoPtr);
				if (info.lfWeight >= 400)
					return true;
				return false;
			}
		});
	// CUT

	function CND_EXTISCOLBACK()
	{
	}
	CND_EXTISCOLBACK.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				if (hoPtr.hoAdRunHeader.colMask_TestObject_IXY(hoPtr, hoPtr.roc.rcImage, hoPtr.roc.rcAngle, hoPtr.roc.rcScaleX, hoPtr.roc.rcScaleY, hoPtr.hoX, hoPtr.hoY, 0, CColMask.CM_TEST_OBSTACLE))
					return CCnd.negaTRUE(this);
				if (hoPtr.hoAdRunHeader.colMask_TestObject_IXY(hoPtr, hoPtr.roc.rcImage, hoPtr.roc.rcAngle, hoPtr.roc.rcScaleX, hoPtr.roc.rcScaleY, hoPtr.hoX, hoPtr.hoY, 0, CColMask.CM_TEST_PLATFORM))
					return CCnd.negaTRUE(this);
				return CCnd.negaFALSE(this);
			}
		});
	// CUT

	function CND_EXTISCOLLIDING()
	{
	}
	CND_EXTISCOLLIDING.prototype = CServices.extend(new CCnd(),
		{
			eva1: function (rhPtr, hoPtr)
			{
				return this.isColliding(rhPtr);
			},
			eva2: function (rhPtr)
			{
				return this.isColliding(rhPtr);
			}
		});
	// CUT

	function CND_EXTISIN()
	{
	}
	CND_EXTISIN.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (pHo)
			{
				var x1 = pHo.hoX - pHo.hoImgXSpot;
				var x2 = x1 + pHo.hoImgWidth;
				var y1 = pHo.hoY - pHo.hoImgYSpot;
				var y2 = y1 + pHo.hoImgHeight;
				if (pHo.hoAdRunHeader.quadran_In(x1, y1, x2, y2) != 0)
					return CCnd.negaFALSE(this);
				return CCnd.negaTRUE(this);
			}
		});
	// CUT

	function CND_EXTISITALIC()
	{
	}
	CND_EXTISITALIC.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				var info = CRun.getObjectFont(hoPtr);
				if (info.lfItalic != 0)
					return true;
				return false;
			}
		});
	// CUT

	function CND_EXTISOUT()
	{
	}
	CND_EXTISOUT.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (pHo)
			{
				var x1 = pHo.hoX - pHo.hoImgXSpot;
				var x2 = x1 + pHo.hoImgWidth;
				var y1 = pHo.hoY - pHo.hoImgYSpot;
				var y2 = y1 + pHo.hoImgHeight;
				if (pHo.hoAdRunHeader.quadran_In(x1, y1, x2, y2) != 0)
					return CCnd.negaTRUE(this);
				return CCnd.negaFALSE(this);
			}
		});
	// CUT

	function CND_EXTISSTRIKEOUT()
	{
	}
	CND_EXTISSTRIKEOUT.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				var info = CRun.getObjectFont(hoPtr);
				if (info.lfStrikeOut != 0)
					return true;
				return false;
			}
		});
	// CUT

	function CND_EXTISUNDERLINE()
	{
	}
	CND_EXTISUNDERLINE.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
			    var info = CRun.getObjectFont(hoPtr);
				if (info.lfUnderline != 0)
					return true;
				return false;
			}
		});
	// CUT

	function CND_EXTNEARBORDERS()
	{
	}
	CND_EXTNEARBORDERS.prototype = CServices.extend(new CCnd(),
		{
			eva1:          function (rhPtr, hoPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			eva2:          function (rhPtr)
			{
				return this.evaExpObject(rhPtr, this);
			},
			evaExpRoutine: function (hoPtr, bord, comp)
			{
				var xw = hoPtr.hoAdRunHeader.rhWindowX + bord;
				var x = hoPtr.hoX - hoPtr.hoImgXSpot;
				if (x <= xw) return CCnd.negaTRUE(this);

				xw = hoPtr.hoAdRunHeader.rhWindowX + hoPtr.hoAdRunHeader.rh3WindowSx - bord;
				x += hoPtr.hoImgWidth;
				if (x >= xw) return CCnd.negaTRUE(this);

				var yw = hoPtr.hoAdRunHeader.rhWindowY + bord;
				var y = hoPtr.hoY - hoPtr.hoImgYSpot;
				if (y <= yw) return CCnd.negaTRUE(this);

				yw = hoPtr.hoAdRunHeader.rhWindowY + hoPtr.hoAdRunHeader.rh3WindowSy - bord;
				y += hoPtr.hoImgHeight;
				if (y >= yw) return CCnd.negaTRUE(this);

				return CCnd.negaFALSE(this);
			}
		});
	// CUT

	function CND_EXTNOMOREOBJECT()
	{
	}
	CND_EXTNOMOREOBJECT.prototype =
	{
		eva1:            function (rhPtr, hoPtr)
		{
			if (hoPtr == null)
				return this.eva2(rhPtr);
			if (this.evtOi >= 0)
			{
				if (hoPtr.hoOi != this.evtOi)
					return false;
				return true;
			}
			return this.evaNoMoreObject(rhPtr, 1);
		},
		eva2:            function (rhPtr)
		{
			return this.evaNoMoreObject(rhPtr, 0);
		},
		evaNoMoreObject: function (rhPtr, sub)
		{
			var oil = this.evtOiList;

			var poil;
			if ((oil & 0x8000) == 0)
			{
				poil = rhPtr.rhOiList[oil];
				if (poil.oilNObjects == 0)
					return true;
				return false;
			}

			if ((oil & 0x7FFF) == 0x7FFF)
				return false;
			var pqoi = rhPtr.rhEvtProg.qualToOiList[oil & 0x7FFF];
			var count = 0;
			var qoi;
			for (qoi = 0; qoi < pqoi.qoiList.length; qoi += 2)
			{
				poil = rhPtr.rhOiList[pqoi.qoiList[qoi + 1]];
				count += poil.oilNObjects;
			}
			count -= sub;
			if (count == 0)
				return true;
			return false;
		}
	}
	// CUT

	function CND_EXTNOMOREZONE()
	{
	}
	CND_EXTNOMOREZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var count = rhPtr.rhEvtProg.count_ZoneOneObject(this.evtOiList, this.evtParams[0]);
			return count == 0;
		}
	}
	// CUT

	function CND_EXTNUMBERZONE()
	{
	}
	CND_EXTNUMBERZONE.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var count = rhPtr.rhEvtProg.count_ZoneOneObject(this.evtOiList, this.evtParams[0]);
			var number = rhPtr.get_EventExpressionInt(this.evtParams[1]);
			return CRun.compareTer(count, number, this.evtParams[1].comparaison);
		}
	}
	// CUT

	function CND_EXTNUMOFOBJECT()
	{
	}
	CND_EXTNUMOFOBJECT.prototype =
	{
		eva1: function (rhPtr, hoPtr)
		{
			return this.eva2(rhPtr);
		},
		eva2: function (rhPtr)
		{
			var count = 0;
			var poil;
			var oil = this.evtOiList;
			if ((oil & 0x8000) == 0)
			{
				poil = rhPtr.rhOiList[oil];
				count = poil.oilNObjects;
			}
			else
			{
				if ((oil & 0x7FFF) != 0x7FFF)
				{
					var pqoi = rhPtr.rhEvtProg.qualToOiList[oil & 0x7FFF];
					var qoi;
					for (qoi = 0; qoi < pqoi.qoiList.length; qoi += 2)
					{
						poil = rhPtr.rhOiList[pqoi.qoiList[qoi + 1]];
						count += poil.oilNObjects;
					}
				}
			}
			var value = rhPtr.get_EventExpressionInt(this.evtParams[0]);
			return CRun.compareTer(count, value, this.evtParams[0].comparaison);
		}
	}
	// CUT

	function CND_EXTOUTPLAYFIELD()
	{
	}
	CND_EXTOUTPLAYFIELD.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				var evpPtr = this.evtParams[0];
				if ((evpPtr.value & (rhPtr.rhEvtProg.rhCurParam0)) == 0)
					return false;
				//        if (rhPtr.rhEvtProg.curParam1 == 0x12345678)
				//            return true;

				if (this.compute_NoRepeat(hoPtr))
				{
					rhPtr.rhEvtProg.evt_AddCurrentObject(hoPtr);
					return true;
				}

				var pEvg = rhPtr.rhEvtProg.rhEventGroup;
				if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_STOPINGROUP) == 0)
					return false;
				rhPtr.rhEvtProg.rh3DoStop = true;
				return true;
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, (hoPtr.rom.rmEventFlags & CRMvt.EF_GOESOUTPLAYFIELD) != 0);
			}
		});
	// CUT

	function CND_EXTPATHNODE()
	{
	}
	CND_EXTPATHNODE.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return true;
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				if (hoPtr.roc.rcMovementType != CMoveDef.MVTYPE_TAPED)
					return false;
				return CCnd.checkMark(hoPtr.hoAdRunHeader, hoPtr.hoMark1);
			}
		});
	// CUT

	function CND_EXTPATHNODENAME()
	{
	}
	CND_EXTPATHNODENAME.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				var pName = rhPtr.get_EventExpressionString(this.evtParams[0]);
				if (hoPtr.hoMT_NodeName != null)
				{
					if (hoPtr.hoMT_NodeName == pName)
					{
						return true;
					}
				}
				return false;
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				if (hoPtr.roc.rcMovementType != CMoveDef.MVTYPE_TAPED)
					return false;
				if (CCnd.checkMark(hoPtr.hoAdRunHeader, hoPtr.hoMark1))
				{
					var pName = hoPtr.hoAdRunHeader.get_EventExpressionString(this.evtParams[0]);
					if (hoPtr.hoMT_NodeName != null)
					{
						if (hoPtr.hoMT_NodeName == pName)
						{
							return true;
						}
					}
				}
				return false;
			}
		});
	// CUT

	function CND_EXTREVERSED()
	{
	}
	CND_EXTREVERSED.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, hoPtr.rom.rmReverse == 0);
			}
		});
	// CUT

	function CND_EXTSHOWN()
	{
	}
	CND_EXTSHOWN.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, (hoPtr.ros.rsFlags & CRSpr.RSFLAG_HIDDEN) == 0);
			}
		});
	// CUT

	function CND_EXTSTOPPED()
	{
	}
	CND_EXTSTOPPED.prototype = CServices.extend(new CCnd(),
		{
			eva1:             function (rhPtr, hoPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			eva2:             function (rhPtr)
			{
				return this.evaObject(rhPtr, this);
			},
			evaObjectRoutine: function (hoPtr)
			{
				return CCnd.negate(this, hoPtr.roc.rcSpeed == 0);
			}
		});
	// CUT

	function CND_RUNNINGAS() {
	}
	CND_RUNNINGAS.prototype =
	{
	    eva1: function (rhPtr, hoPtr) {
	        return this.eva2(rhPtr);
	    },
	    eva2: function (rhPtr) {
	        var number;
	        if (this.evtParams[0].code == 67)   // PARAM_RUNTIME
	            number = this.evtParams[0].value;
	        else
	            number = rhPtr.get_EventExpressionInt(this.evtParams[0]);
	        if (number == 5)		// RUNTIME_HTML5
	            return CCnd.negaTRUE(this);
	        return CCnd.negaFALSE(this);
	    }
	}
	// CUT













































	// CExp object
	// -------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 * 
	 * Permission is hereby granted to any person obtaining a legal copy 
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for 
	 * debugging, optimizing, or customizing applications created with 
	 * Clickteam Multimedia Fusion 2. 
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	CExp.EXP_EXTGETFRICTION = (35 << 8);
	CExp.EXP_EXTGETRESTITUTION = (36 << 8);
	CExp.EXP_EXTGETDENSITY = (37 << 8);
	CExp.EXP_EXTGETVELOCITY = (38 << 8);
	CExp.EXP_EXTGETANGLE = (39 << 8);
	CExp.EXP_EXTGETMASS = (42 << 8);
	CExp.EXP_EXTGETANGULARVELOCITY = (43 << 8);
	CExp.EXP_STRING = ((3 << 16) | 0xFFFF);
	CExp.EXP_LONG = ((0 << 16) | 0xFFFF);
	CExp.EXP_DOUBLE = ((23 << 16) | 0xFFFF);

	CExp.create = function (file)
	{
		var debut = file.getFilePointer();
		var exp = null;
		var c = file.readAInt();
		switch (c)
		{
			case 0x00000000:
				exp = new EXP_ZERO();
				break;
			case 0x00020000:
				exp = new EXP_PLUS();
				break;
			case 0x00040000:
				exp = new EXP_MINUS();
				break;
			case 0x00060000:
				exp = new EXP_MULT();
				break;
			case 0x00080000:
				exp = new EXP_DIV();
				break;
			case 0x000A0000:
				exp = new EXP_MOD();
				break;
			case 0x000C0000:
				exp = new EXP_POW();
				break;
			case 0x000E0000:
				exp = new EXP_AND();
				break;
			case 0x00100000:
				exp = new EXP_OR();
				break;
			case 0x00120000:
				exp = new EXP_XOR();
				break;
			case ((0 << 16) | 0xFFFF):
				exp = new EXP_LONG();
				break;
			case ((1 << 16) | 0xFFFF):
				exp = new EXP_RANDOM();
				break;
			case ((2 << 16) | 0xFFFF):
				exp = new EXP_VARGLO();
				break;
			case ((3 << 16) | 0xFFFF):
				exp = new EXP_STRING();
				break;
			case ((4 << 16) | 0xFFFF):
				exp = new EXP_STR();
				break;
			case ((5 << 16) | 0xFFFF):
				exp = new EXP_VAL();
				break;
			case ((6 << 16) | 0xFFFF):
			case ((7 << 16) | 0xFFFF):
			case ((8 << 16) | 0xFFFF):
			case ((9 << 16) | 0xFFFF):
				exp = new EXP_EMPTY();
				break;
			case ((10 << 16) | 0xFFFF):
				exp = new EXP_SIN();
				break;
			case ((11 << 16) | 0xFFFF):
				exp = new EXP_COS();
				break;
			case ((12 << 16) | 0xFFFF):
				exp = new EXP_TAN();
				break;
			case ((13 << 16) | 0xFFFF):
				exp = new EXP_SQR();
				break;
			case ((14 << 16) | 0xFFFF):
				exp = new EXP_LOG();
				break;
			case ((15 << 16) | 0xFFFF):
				exp = new EXP_LN();
				break;
			case ((16 << 16) | 0xFFFF):
				exp = new EXP_HEX();
				break;
			case ((17 << 16) | 0xFFFF):
				exp = new EXP_BIN();
				break;
			case ((18 << 16) | 0xFFFF):
				exp = new EXP_EXP();
				break;
			case ((19 << 16) | 0xFFFF):
				exp = new EXP_LEFT();
				break;
			case ((20 << 16) | 0xFFFF):
				exp = new EXP_RIGHT();
				break;
			case ((21 << 16) | 0xFFFF):
				exp = new EXP_MID();
				break;
			case ((22 << 16) | 0xFFFF):
				exp = new EXP_LEN();
				break;
			case ((23 << 16) | 0xFFFF):
				exp = new EXP_DOUBLE();
				break;
			case ((24 << 16) | 0xFFFF):
				exp = new EXP_VARGLONAMED();
				break;
			case ((28 << 16) | 0xFFFF):
				exp = new EXP_INT();
				break;
			case ((29 << 16) | 0xFFFF):
				exp = new EXP_ABS();
				break;
			case ((30 << 16) | 0xFFFF):
				exp = new EXP_CEIL();
				break;
			case ((31 << 16) | 0xFFFF):
				exp = new EXP_FLOOR();
				break;
			case ((32 << 16) | 0xFFFF):
				exp = new EXP_ACOS();
				break;
			case ((33 << 16) | 0xFFFF):
				exp = new EXP_ASIN();
				break;
			case ((34 << 16) | 0xFFFF):
				exp = new EXP_ATAN();
				break;
			case ((35 << 16) | 0xFFFF):
				exp = new EXP_NOT();
				break;
			case ((40 << 16) | 0xFFFF):
				exp = new EXP_MIN();
				break;
			case ((41 << 16) | 0xFFFF):
				exp = new EXP_MAX();
				break;
			case ((42 << 16) | 0xFFFF):
				exp = new EXP_GETRGB();
				break;
			case ((43 << 16) | 0xFFFF):
				exp = new EXP_GETRED();
				break;
			case ((44 << 16) | 0xFFFF):
				exp = new EXP_GETGREEN();
				break;
			case ((45 << 16) | 0xFFFF):
				exp = new EXP_GETBLUE();
				break;
			case ((46 << 16) | 0xFFFF):
				exp = new EXP_LOOPINDEX();
				break;
			case ((47 << 16) | 0xFFFF):
				exp = new EXP_NEWLINE();
				break;
			case ((48 << 16) | 0xFFFF):
				exp = new EXP_ROUND();
				break;
			case ((49 << 16) | 0xFFFF):
				exp = new EXP_STRINGGLO();
				break;
			case ((50 << 16) | 0xFFFF):
				exp = new EXP_STRINGGLONAMED();
				break;
			case ((51 << 16) | 0xFFFF):
				exp = new EXP_LOWER();
				break;
			case ((52 << 16) | 0xFFFF):
				exp = new EXP_UPPER();
				break;
			case ((53 << 16) | 0xFFFF):
				exp = new EXP_FIND();
				break;
			case ((54 << 16) | 0xFFFF):
				exp = new EXP_REVERSEFIND();
				break;
			case ((58 << 16) | 0xFFFF):
				exp = new EXP_FLOATTOSTRING();
				break;
			case ((59 << 16) | 0xFFFF):
				exp = new EXP_ATAN2();
				break;
			case ((60 << 16) | 0xFFFF):
				exp = new EXP_ZERO();
				break;
			case ((61 << 16) | 0xFFFF):
				exp = new EXP_EMPTY();
				break;
			case ((62 << 16) | 0xFFFF):
				exp = new EXP_DISTANCE();
				break;
			case ((63 << 16) | 0xFFFF):
				exp = new EXP_ANGLE();
				break;
			case ((64 << 16) | 0xFFFF):
				exp = new EXP_RANGE();
				break;
			case ((65 << 16) | 0xFFFF):
				exp = new EXP_RANDOMRANGE();
				break;
		    case ((67 << 16) | 0xFFFF):
		        exp = new EXP_RUNTIMENAME();
		        break;
		    case ((-1 << 16) | 0xFFFF):
				exp = new EXP_PARENTH1();
				break;
			case ((-2 << 16) | 0xFFFF):
				exp = new EXP_PARENTH2();
				break;
			case ((-3 << 16) | 0xFFFF):
				exp = new EXP_VIRGULE();
				break;
			case ((0 << 16) | 0xFFFE):
				exp = new EXP_GETSAMPLEMAINVOL();
				break;
			case ((1 << 16) | 0xFFFE):
				exp = new EXP_GETSAMPLEVOL();
				break;
			case ((2 << 16) | 0xFFFE):
				exp = new EXP_GETCHANNELVOL();
				break;
			case ((3 << 16) | 0xFFFE):
				exp = new EXP_ZERO();
				break;
			case ((4 << 16) | 0xFFFE):
				exp = new EXP_GETSAMPLEPAN();
				break;
			case ((5 << 16) | 0xFFFE):
				exp = new EXP_GETCHANNELPAN();
				break;
			case ((6 << 16) | 0xFFFE):
				exp = new EXP_GETSAMPLEPOS();
				break;
			case ((7 << 16) | 0xFFFE):
				exp = new EXP_GETCHANNELPOS();
				break;
			case ((8 << 16) | 0xFFFE):
				exp = new EXP_GETSAMPLEDUR();
				break;
			case ((9 << 16) | 0xFFFE):
				exp = new EXP_GETCHANNELDUR();
				break;
			case ((10 << 16) | 0xFFFE):
				exp = new EXP_GETSAMPLEFREQ();
				break;
			case ((11 << 16) | 0xFFFE):
				exp = new EXP_GETCHANNELFREQ();
				break;
			case ((0 << 16) | 0xFFFD):
				exp = new EXP_GAMLEVEL();
				break;
			case ((1 << 16) | 0xFFFD):
				exp = new EXP_GAMNPLAYER();
				break;
			case ((2 << 16) | 0xFFFD):
				exp = new EXP_PLAYXLEFT();
				break;
			case ((3 << 16) | 0xFFFD):
				exp = new EXP_PLAYXRIGHT();
				break;
			case ((4 << 16) | 0xFFFD):
				exp = new EXP_PLAYYTOP();
				break;
			case ((5 << 16) | 0xFFFD):
				exp = new EXP_PLAYYBOTTOM();
				break;
			case ((6 << 16) | 0xFFFD):
				exp = new EXP_PLAYWIDTH();
				break;
			case ((7 << 16) | 0xFFFD):
				exp = new EXP_PLAYHEIGHT();
				break;
			case ((8 << 16) | 0xFFFD):
				exp = new EXP_GAMLEVELNEW();
				break;
			case ((9 << 16) | 0xFFFD):
				exp = new EXP_GETCOLLISIONMASK();
				break;
			case ((10 << 16) | 0xFFFD):
				exp = new EXP_FRAMERATE();
				break;
			case ((11 << 16) | 0xFFFD):
				exp = new EXP_GETVIRTUALWIDTH();
				break;
			case ((12 << 16) | 0xFFFD):
				exp = new EXP_GETVIRTUALHEIGHT();
				break;
			case ((13 << 16) | 0xFFFD):
				exp = new EXP_GETFRAMEBKDCOLOR();
				break;
			case ((14 << 16) | 0xFFFD):
				exp = new EXP_ZERO();
				break;
			case ((15 << 16) | 0xFFFD):
				exp = new EXP_ZERO();
				break;
			case ((16 << 16) | 0xFFFD):
				exp = new EXP_FRAMEALPHACOEF();
				break;
			case ((17 << 16) | 0xFFFD):
				exp = new EXP_FRAMERGBCOEF();
				break;
			case ((18 << 16) | 0xFFFD):
				exp = new EXP_ZERO();
				break;
			case ((0 << 16) | 0xFFFC):
				exp = new EXP_TIMVALUE();
				break;
			case ((1 << 16) | 0xFFFC):
				exp = new EXP_TIMCENT();
				break;
			case ((2 << 16) | 0xFFFC):
				exp = new EXP_TIMSECONDS();
				break;
			case ((3 << 16) | 0xFFFC):
				exp = new EXP_TIMHOURS();
				break;
			case ((4 << 16) | 0xFFFC):
				exp = new EXP_TIMMINITS();
				break;
			case ((5 << 16) | 0xFFFC):
				exp = new EXP_EVENTAFTER();
				break;
			case ((0 << 16) | 0xFFFA):
				exp = new EXP_XMOUSE();
				break;
			case ((1 << 16) | 0xFFFA):
				exp = new EXP_YMOUSE();
				break;
			case ((2 << 16) | 0xFFFA):
				exp = new EXP_MOUSEWHEELDELTA();
				break;
			case ((0 << 16) | 0xFFF9):
				exp = new EXP_PLASCORE();
				break;
			case ((1 << 16) | 0xFFF9):
				exp = new EXP_PLALIVES();
				break;
			case ((2 << 16) | 0xFFF9):
				exp = new EXP_GETINPUT();
				break;
			case ((3 << 16) | 0xFFF9):
				exp = new EXP_GETINPUTKEY();
				break;
			case ((4 << 16) | 0xFFF9):
				exp = new EXP_GETPLAYERNAME();
				break;
			case ((0 << 16) | 0xFFFB):
				exp = new EXP_CRENUMBERALL();
				break;
			case (( (80 + 0) << 16) | 3):
				exp = new EXP_STRNUMBER();
				break;
			case (( (80 + 1) << 16) | 3):
				exp = new EXP_STRGETCURRENT();
				break;
			case (( (80 + 2) << 16) | 3):
				exp = new EXP_STRGETNUMBER();
				break;
			case (( (80 + 3) << 16) | 3):
				exp = new EXP_STRGETNUMERIC();
				break;
			case (( (80 + 4) << 16) | 3):
				exp = new EXP_STRGETNPARA();
				break;
			case ((80 + 0) << 16 | 2):
				exp = new EXP_GETRGBAT();
				break;
			case ((80 + 1) << 16 | 2):
				exp = new EXP_GETSCALEX();
				break;
			case ((80 + 2) << 16 | 2):
				exp = new EXP_GETSCALEY();
				break;
			case ((80 + 3) << 16 | 2):
				exp = new EXP_GETANGLE();
				break;
			case (( (80 + 0) << 16) | 7):
				exp = new EXP_CVALUE();
				break;
			case (( (80 + 1) << 16) | 7):
				exp = new EXP_CGETMIN();
				break;
			case (( (80 + 2) << 16) | 7):
				exp = new EXP_CGETMAX();
				break;
			case (( (80 + 3) << 16) | 7):
				exp = new EXP_CGETCOLOR1();
				break;
			case (( (80 + 4) << 16) | 7):
				exp = new EXP_CGETCOLOR2();
				break;
			case (((80 + 0) << 16) | 9):
				exp = new EXP_CCAGETFRAMENUMBER();
				break;
			case (((80 + 1) << 16) | 9):
				exp = new EXP_CCAGETGLOBALVALUE();
				break;
			case (((80 + 2) << 16) | 9):
				exp = new EXP_CCAGETGLOBALSTRING();
				break;
			default:
				switch (c & 0xFFFF0000)
				{
					case ( 1 << 16):
						exp = new EXP_EXTYSPR();
						break;
					case ( 2 << 16):
						exp = new EXP_EXTISPR();
						break;
					case ( 3 << 16):
						exp = new EXP_EXTSPEED();
						break;
					case ( 4 << 16):
						exp = new EXP_EXTACC();
						break;
					case ( 5 << 16):
						exp = new EXP_EXTDEC();
						break;
					case ( 6 << 16):
						exp = new EXP_EXTDIR();
						break;
					case ( 7 << 16):
						exp = new EXP_EXTXLEFT();
						break;
					case ( 8 << 16):
						exp = new EXP_EXTXRIGHT();
						break;
					case ( 9 << 16):
						exp = new EXP_EXTYTOP();
						break;
					case (10 << 16):
						exp = new EXP_EXTYBOTTOM();
						break;
					case (11 << 16):
						exp = new EXP_EXTXSPR();
						break;
					case (12 << 16):
						exp = new EXP_EXTIDENTIFIER();
						break;
					case (13 << 16):
						exp = new EXP_EXTFLAG();
						break;
					case (14 << 16):
						exp = new EXP_EXTNANI();
						break;
					case (15 << 16):
						exp = new EXP_EXTNOBJECTS();
						break;
					case (16 << 16):
						exp = new EXP_EXTVAR();
						break;
					case (17 << 16):
						exp = new EXP_EXTGETSEMITRANSPARENCY();
						break;
					case (18 << 16):
						exp = new EXP_EXTNMOVE();
						break;
					case (19 << 16):
						exp = new EXP_EXTVARSTRING();
						break;
					case (20 << 16):
						exp = new EXP_EXTGETFONTNAME();
						break;
					case (21 << 16):
						exp = new EXP_EXTGETFONTSIZE();
						break;
					case (22 << 16):
						exp = new EXP_EXTGETFONTCOLOR();
						break;
					case (23 << 16):
						exp = new EXP_EXTGETLAYER();
						break;
					case (24 << 16):
						exp = new EXP_EXTGETGRAVITY();
						break;
					case (25 << 16):
						exp = new EXP_EXTXAP();
						break;
					case (26 << 16):
						exp = new EXP_EXTYAP();
						break;
					case (27 << 16):
						exp = new EXP_EXTALPHACOEF();
						break;
					case (28 << 16):
						exp = new EXP_EXTRGBCOEF();
						break;
					case (29 << 16):
						exp = new EXP_ZERO();
						break;
					case (30 << 16):
						exp = new EXP_EXTVARBYINDEX();
						break;
					case (31 << 16):
						exp = new EXP_EXTVARSTRINGBYINDEX();
						break;

					case (32 << 16):
						exp = new EXP_EXTDISTANCE();
						break;
					case (33 << 16):
						exp = new EXP_EXTANGLE();
						break;
					case (34 << 16):
						exp = new EXP_EXTLOOPINDEX();
						break;

					case (35 << 16):
						exp = new EXP_EXTGETFRICTION();
						break;
					case (36 << 16):
						exp = new EXP_EXTGETRESTITUTION();
						break;
					case (37 << 16):
						exp = new EXP_EXTGETDENSITY();
						break;
					case (38 << 16):
						exp = new EXP_EXTGETVELOCITY();
						break;
					case (39 << 16):
						exp = new EXP_EXTGETANGLE();
						break;
					case (40 << 16):
						exp = new EXP_EXTWIDTH();
						break;
					case (41 << 16):
						exp = new EXP_EXTHEIGHT();
						break;
				    case (42 << 16):
				        exp = new EXP_EXTGETMASS();
				        break;
				    case (43 << 16):
				        exp = new EXP_EXTGETANGULARVELOCITY();
				        break;
				    case (44 << 16):
				        exp = new EXP_EXTGETNAME();
				        break;

					default:
						exp = new CExpExtension();
						break;
				}
		}
		if (exp != null)
		{
			exp.code = c;

			if (c != 0x00000000)
			{
				var size = file.readAShort();

				var type;
				switch (c)
				{
					case ((3 << 16) | 0xFFFF):
						exp.string = file.readAString();
						break;
					case ((0 << 16) | 0xFFFF):
						exp.value = file.readAInt();
						break;
					case ((23 << 16) | 0xFFFF):
						exp.value = file.readADouble();
						break;
					case ((24 << 16) | 0xFFFF):
						file.skipBytes(4);
						exp.number = file.readAShort();
						break;
					case ((50 << 16) | 0xFFFF):
						file.skipBytes(4);
						exp.number = file.readAShort();
						break;
					default:
						type = c & 0xFFFF;
						if ((type & 0x8000) != 0)
							type = type - 65536;
						if (type >= 2 || type == COI.OBJ_PLAYER)
						{
							exp.oi = file.readShort();
							exp.oiList = file.readShort();
							switch (c & 0xFFFF0000)
							{
								case (16 << 16):		// EXP_EXTVAR
									exp.number = file.readAShort();
									break;
								case (19 << 16):		// EXP_EXTVARSTRING			
									exp.number = file.readAShort();
									break;
								default:
									break;
							}
						}
				}
				file.seek(debut + size);
			}
		}
		return exp;
	}
	function CExp()
	{
	}

	function EXP_EMPTY()
	{
	}
	EXP_EMPTY.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
		}
	}

	function EXP_ZERO()
	{
	}
	EXP_ZERO.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}

	function EXP_LONG()
	{
	}
	EXP_LONG.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = this.value;

		}
	}

	function EXP_DOUBLE()
	{
	}
	EXP_DOUBLE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = this.value;
			rhPtr.flagFloat = true;
		}
	}
	function EXP_EXTVAR()
	{
	}
	EXP_EXTVAR.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var value;
			if (pHo.rov != null)
				value = pHo.rov.getValue(this.number);
			else
				value = 0;
			if (!CServices.isInt(value))
				rhPtr.flagFloat = true;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = value;
		}
	}
	function EXP_EXTVARSTRING()
	{
	}
	EXP_EXTVARSTRING.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rov.getString(this.number);
		}
	}

	function EXP_STRINGGLONAMED()
	{
	}
	EXP_STRINGGLONAMED.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.getGlobalStringAt(this.number);
		}
	}

	function EXP_VARGLONAMED()
	{
	}
	EXP_VARGLONAMED.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.getGlobalValueAt(this.number);
		}
	}

	function EXP_STRING()
	{
	}
	EXP_STRING.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = this.string;
		}
	}

	function EXP_EXTVARBYINDEX()
	{
	}
	EXP_EXTVARBYINDEX.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			var number = rhPtr.get_ExpressionInt();
			if (pHo != null && pHo.rov != null)
			{
				if (number >= 0 && number < pHo.rov.rvValues.length)
				{
					var value = pHo.rov.getValue(number);
					if (!CServices.isInt(value))
						rhPtr.flagFloat = true;

					rhPtr.rh4Results[rhPtr.rh4PosPile] = value;
					return;
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}

	function EXP_EXTVARSTRINGBYINDEX()
	{
	}
	EXP_EXTVARSTRINGBYINDEX.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			var number = rhPtr.get_ExpressionInt();
			if (pHo != null && pHo.rov != null)
			{
				if (number >= 0 && number < CRVal.STRINGS_NUMBEROF_ALTERABLE)
				{
					rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rov.getString(number);
					return;
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
		}
	}

	// CUT


	// System object
	// ---------------------------------------------------------------
	function EXP_DISTANCE()
	{
	}
	EXP_DISTANCE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var x1 = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var y1 = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var x2 = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var y2 = rhPtr.getExpression();
			var deltaX = x2 - x1;
			var deltaY = y2 - y1;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.approximateInt(Math.sqrt(deltaX * deltaX + deltaY * deltaY));
		}
	}
	// CUT

	function EXP_ANGLE()
	{
	}
	EXP_ANGLE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var x1 = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var y1 = rhPtr.getExpression();
			var angle = Math.atan2(-y1, x1) * 180.0 / 3.141592653589;
			if (angle < 0)
				angle = 360 + angle;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.approximateInt(angle);
		}
	}
	// CUT

	function EXP_RANGE()
	{
	}
	EXP_RANGE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var minimum = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var maximum = rhPtr.getExpression();

			value = Math.max(value, minimum);
			value = Math.min(value, maximum);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = value;
		}
	}
	// CUT

	function EXP_RANDOMRANGE()
	{
	}
	EXP_RANDOMRANGE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var minimum = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var maximum = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = minimum + rhPtr.random(maximum - minimum + 1);
		}
	}
	// CUT

	function EXP_RUNTIMENAME()
	{
	}
	EXP_RUNTIMENAME.prototype =
	{
	    evaluate: function (rhPtr) {
	        rhPtr.rh4Results[rhPtr.rh4PosPile] = "Html5";
	    }
	}
	// CUT

	function EXP_ABS()
	{
	}
	EXP_ABS.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.abs(value);
		}
	}
	// CUT

	function EXP_ABS()
	{
	}
	EXP_ABS.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.abs(value);
		}
	}
	// CUT

	function EXP_ACOS()
	{
	}
	EXP_ACOS.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.acos(value) * 57.295779513082320876798154814105;
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_AND()
	{
	}
	EXP_AND.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] &= rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
		}
	}
	// CUT

	function EXP_ASIN()
	{
	}
	EXP_ASIN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.asin(value) * 57.295779513082320876798154814105;
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_ATAN()
	{
	}
	EXP_ATAN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.atan(value) * 57.295779513082320876798154814105;
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_ATAN2()
	{
	}
	EXP_ATAN2.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value1 = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var value2 = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.atan2(value1, value2) * 57.295779513082320876798154814105;
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_CEIL()
	{
	}
	EXP_CEIL.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.ceil(value);
		}
	}
	// CUT

	function EXP_BIN()
	{
	}
	EXP_BIN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var a = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = "0b" + a.toString(2);
		}
	}
	// CUT

	function EXP_COS()
	{
	}
	EXP_COS.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.cos(value / 57.295779513082320876798154814105);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_DIV()
	{
	}
	EXP_DIV.prototype =
	{
		evaluate: function (rhPtr)
		{
			var value1 = rhPtr.rh4Results[rhPtr.rh4PosPile];
			var value2 = rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
			//		if (Math.floor(value1)==value1 &&  (value2)==value2)
			if (value2 != 0)
			{
				if (rhPtr.flagFloat == false)
					rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.floatToInt(value1 / value2);
				else
					rhPtr.rh4Results[rhPtr.rh4PosPile] /= rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
			}
			else
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}
	// CUT

	function EXP_EXP()
	{
	}
	EXP_EXP.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.exp(value);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_FIND()
	{
	}
	EXP_FIND.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var pMainString = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var pSubString = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var firstChar = rhPtr.get_ExpressionInt();

			if (firstChar >= pMainString.length)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = -1;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pMainString.indexOf(pSubString, firstChar);
		}
	}
	// CUT

	function EXP_FLOATTOSTRING()
	{
	}
	EXP_FLOATTOSTRING.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();

			rhPtr.rh4CurToken++;
			var nDigits = rhPtr.get_ExpressionInt();
			if (nDigits < 1)
				nDigits = 1;

			rhPtr.rh4CurToken++;
			var nDecimals = rhPtr.get_ExpressionInt();

			var temp = value.toString();
			var result = new String();

			var point = temp.indexOf(".");

			var cpt;
			if (point >= 0)
			{
				for (cpt = point + 1; cpt < temp.length; cpt++)
				{
					if (temp.charAt(cpt) != "0")
					{
						break;
					}
				}
				if (cpt == temp.length)
					point = -1;
			}

			var pos = 0;
			if (point >= 0)
			{
				if (value < 0.0)
				{
					result += "-";
					pos++;
				}

				while (pos < point)
				{
					result += temp.charAt(pos);
					pos++;
				}

				if (nDecimals > 0)
				{
					result += ".";
					pos++;

					for (cpt = 0; cpt < nDecimals && cpt + pos < temp.length; cpt++)
						result += temp.charAt(pos + cpt);
				}
				else if (nDecimals < 0)
				{
					result += ".";
					pos++;
					while (pos < temp.length)
					{
						result += temp.charAt(pos);
						pos++;
					}
				}
			}
			else
			{
				while (pos < temp.length && temp.charAt(pos) != ".")
				{
					result += temp.charAt(pos);
					pos++;
				}
				if (nDecimals > 0)
				{
					result += ".";
					for (cpt = 0; cpt < nDecimals; cpt++)
					{
						result += "0";
					}
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = result;
		}
	}
	// CUT

	function EXP_FLOOR()
	{
	}
	EXP_FLOOR.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.floor(value);
		}
	}
	// CUT

	function EXP_GETBLUE()
	{
	}
	EXP_GETBLUE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var rgb = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = (rgb >>> 16) & 255;
		}
	}
	// CUT

	function EXP_GETGREEN()
	{
	}
	EXP_GETGREEN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var rgb = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = (rgb >>> 8) & 255;
		}
	}
	// CUT

	function EXP_GETRED()
	{
	}
	EXP_GETRED.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var rgb = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rgb & 255;
		}
	}
	// CUT

	function EXP_GETRGB()
	{
	}
	EXP_GETRGB.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var r = rhPtr.get_ExpressionInt();
			rhPtr.rh4CurToken++;
			var g = rhPtr.get_ExpressionInt();
			rhPtr.rh4CurToken++;
			var b = rhPtr.get_ExpressionInt();
			var rgb = ((b & 255) << 16) + ((g & 255) << 8) + (r & 255);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rgb;
		}
	}
	// CUT

	function EXP_HEX()
	{
	}
	EXP_HEX.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var a = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = "0x" + a.toString(16);
		}
	}
	// CUT

	function EXP_INT()
	{
	}
	EXP_INT.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.floatToInt(value);

		}
	}
	// CUT

	function EXP_LEFT()
	{
	}
	EXP_LEFT.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var string = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var pos = rhPtr.get_ExpressionInt();
			if (pos < 0)
				pos = 0;
			if (pos > string.length)
				pos = string.length;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = string.substring(0, pos);

		}
	}
	// CUT

	function EXP_LEN()
	{
	}
	EXP_LEN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var pString = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pString.length;
		}
	}
	// CUT

	function EXP_LN()
	{
	}
	EXP_LN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.log(value);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_LOG()
	{
	}
	EXP_LOG.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.log(value) / Math.log(10);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_LOOPINDEX()
	{
	}
	EXP_LOOPINDEX.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var token = rhPtr.rh4Tokens[rhPtr.rh4CurToken];
			var pLoop;

			// Simple expression?
			if ( rhPtr.rh4Tokens[rhPtr.rh4CurToken+1].code<=0 || rhPtr.rh4Tokens[rhPtr.rh4CurToken+1].code>=0x00140000 )
			{
				// Index?
				if ( token.code == CExp.EXP_LONG )
				{
					pLoop = rhPtr.rh4FastLoops.get(token.value);
					rhPtr.rh4CurToken++;
					rhPtr.rh4Results[rhPtr.rh4PosPile] = pLoop.index;
					return;
				}

				// Name = simple string?
				if ( token.code == CExp.EXP_STRING )
				{
					var curToken = rhPtr.rh4CurToken;
					var pName = token.string;	// rhPtr.getExpression();
					rhPtr.rh4CurToken++;

					var n;
					for (n = 0; n < rhPtr.rh4FastLoops.size(); n++)
					{
						pLoop = rhPtr.rh4FastLoops.get(n);
						if (CServices.compareStringsIgnoreCase(pLoop.name, pName))
						{
							rhPtr.rh4Tokens[curToken] = new EXP_LONG();
							rhPtr.rh4Tokens[curToken].code = CExp.EXP_LONG;
							rhPtr.rh4Tokens[curToken].value = n;

							rhPtr.rh4Results[rhPtr.rh4PosPile] = pLoop.index;
							return;
						}
					}
					rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
					return;
				}
			}

			var pName = rhPtr.getExpression();

			var n;
			for (n = 0; n < rhPtr.rh4FastLoops.size(); n++)
			{
				pLoop = rhPtr.rh4FastLoops.get(n);
				if (CServices.compareStringsIgnoreCase(pLoop.name, pName))
				{
					rhPtr.rh4Results[rhPtr.rh4PosPile] = pLoop.index;
					return;
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}
	// CUT

	function EXP_LOWER()
	{
	}
	EXP_LOWER.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var pString = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pString.toLowerCase();

		}
	}
	// CUT

	function EXP_MAX()
	{
	}
	EXP_MAX.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var aValue = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var bValue = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.max(aValue, bValue);
		}
	}
	// CUT

	function EXP_MID()
	{
	}
	EXP_MID.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var string = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var start = rhPtr.get_ExpressionInt();
			rhPtr.rh4CurToken++;
			var len = rhPtr.get_ExpressionInt();

			if (start < 0)
				start = 0;
			if (start > string.length)
				start = string.length;
			if (len < 0)
				len = 0;
			if (start + len > string.length)
				len = string.length - start;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = string.substr(start, len);
		}
	}
	// CUT

	function EXP_MIN()
	{
	}
	EXP_MIN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var aValue = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var bValue = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.min(aValue, bValue);
		}
	}
	// CUT

	function EXP_MINUS()
	{
	}
	EXP_MINUS.prototype =
	{
		evaluate: function (rhPtr)
		{
			if (rhPtr.bOperande)
			{
				rhPtr.rh4CurToken++;
				rhPtr.rh4Tokens[rhPtr.rh4CurToken].evaluate(rhPtr);
				rhPtr.rh4Results[rhPtr.rh4PosPile] = -rhPtr.rh4Results[rhPtr.rh4PosPile];
			}
			else
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] -= rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
			}
		}
	}
	// CUT

	function EXP_MOD()
	{
	}
	EXP_MOD.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] %= rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
		}
	}
	// CUT

	function EXP_MULT()
	{
	}
	EXP_MULT.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] *= rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
		}
	}
	// CUT

	function EXP_NEWLINE()
	{
	}
	EXP_NEWLINE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = "\n";
		}
	}
	// CUT

	function EXP_OR()
	{
	}
	EXP_OR.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] |= rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
		}
	}
	// CUT

	function EXP_NOT()
	{
	}
	EXP_NOT.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = value ^ 0xFFFFFFFF;
		}
	}
	// CUT

	function EXP_PARENTH1()
	{
	}
	EXP_PARENTH1.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.getExpression();
		}
	}
	// CUT

	function EXP_PARENTH2()
	{
	}
	EXP_PARENTH2.prototype =
	{
		evaluate: function (rhPtr)
		{
		}
	}
	// CUT

	function EXP_PLUS()
	{
	}
	EXP_PLUS.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] += rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
		}
	}
	// CUT

	function EXP_POW()
	{
	}
	EXP_POW.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.pow(rhPtr.rh4Results[rhPtr.rh4PosPile], rhPtr.rh4Results[rhPtr.rh4PosPile + 1]);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_RANDOM()
	{
	}
	EXP_RANDOM.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var num = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.random(num);
		}
	}
	// CUT

	function EXP_REVERSEFIND()
	{
	}
	EXP_REVERSEFIND.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var pMainString = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var pSubString = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var firstChar = rhPtr.get_ExpressionInt();

			if (firstChar > pMainString.length)
			{
				firstChar = pMainString.length;
			}

			var oldPos;
			var pos = -1;
			while (true)
			{
				oldPos = pos;
				var pFound = pMainString.indexOf(pSubString, pos + 1);
				if (pFound == -1)
					break;
				pos = pFound;
				if (pos > firstChar)
					break;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = oldPos;
		}
	}
	// CUT

	function EXP_RIGHT()
	{
	}
	EXP_RIGHT.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var str = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var pos = rhPtr.get_ExpressionInt();

			if (pos < 0)
				pos = 0;
			if (pos > str.length)
				pos = str.length;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = str.substring(str.length - pos, str.length);
		}
	}
	// CUT

	function EXP_ROUND()
	{
	}
	EXP_ROUND.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.round(value);
		}
	}
	// CUT

	function EXP_SIN()
	{
	}
	EXP_SIN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.sin(value / 57.295779513082320876798154814105);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_SQR()
	{
	}
	EXP_SQR.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			if (value < 0)
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
			else
				rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.sqrt(value);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_STR()
	{
	}
	EXP_STR.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var pValue = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pValue.toString();
		}
	}
	// CUT

	function EXP_STRINGGLO()
	{
	}
	EXP_STRINGGLO.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var num = (rhPtr.get_ExpressionInt() - 1);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.getGlobalStringAt(num);
		}
	}
	// CUT

	function EXP_TAN()
	{
	}
	EXP_TAN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.tan(value / 57.295779513082320876798154814105);
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_UPPER()
	{
	}
	EXP_UPPER.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var pString = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pString.toUpperCase();
		}
	}
	// CUT

	function EXP_VAL()
	{
	}
	EXP_VAL.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;

			var s = rhPtr.getExpression();

			var n = 0;
			while(n < s.length && s.charAt(n) == 32)
				n++;
			var result = 0;
			if (n < s.length)
			{
				s = s.substr(n);
				if (s.substr(0, 2) == '0b' || s.substr(n, 2) == '0B')
					result = parseInt(s.substr(n + 2), 2);
				else
				{
					var result1 = parseInt(s);
					result = parseFloat(s);
					if (!isNaN(result) && !isNaN(result1))
					{
						if (result == 0 && result1 != 0)
							result = result1;
						var iValue = CServices.floatToInt(result);
						if (iValue != result)
							rhPtr.flagFloat = true;
					}
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = result;
		}
	}
	// CUT

	function EXP_VARGLO()
	{
	}
	EXP_VARGLO.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var num = (rhPtr.get_ExpressionInt() - 1);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.getGlobalValueAt(num);
		}
	}
	// CUT

	function EXP_VIRGULE()
	{
	}
	EXP_VIRGULE.prototype =
	{
		evaluate: function (rhPtr)
		{
		}
	}
	// CUT

	function EXP_XOR()
	{
	}
	EXP_XOR.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] ^= rhPtr.rh4Results[rhPtr.rh4PosPile + 1];
		}
	}
	// CUT

	function EXP_VIRGULE()
	{
	}
	EXP_VIRGULE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}
	// CUT

	// Timer object
	// ------------------------------------------------------------------
	function EXP_EVENTAFTER()
	{
	}
	EXP_EVENTAFTER.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhEvtProg.rhCurParam1;
		}
	}
	// CUT

	function EXP_TIMCENT()
	{
	}
	EXP_TIMCENT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var c = CServices.floatToInt(rhPtr.rhTimer / 10);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = c % 100;
		}
	}
	// CUT

	function EXP_TIMHOURS()
	{
	}
	EXP_TIMHOURS.prototype =
	{
		evaluate: function (rhPtr)
		{
			var c = CServices.floatToInt(rhPtr.rhTimer / 3600000);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = c;
		}
	}
	// CUT

	function EXP_TIMMINITS()
	{
	}
	EXP_TIMMINITS.prototype =
	{
		evaluate: function (rhPtr)
		{
			var c = CServices.floatToInt(rhPtr.rhTimer / 60000);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = c % 60;
		}
	}
	// CUT

	function EXP_TIMSECONDS()
	{
	}
	EXP_TIMSECONDS.prototype =
	{
		evaluate: function (rhPtr)
		{
			var s = CServices.floatToInt(rhPtr.rhTimer / 1000);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = s % 60;
		}
	}
	// CUT

	function EXP_TIMVALUE()
	{
	}
	EXP_TIMVALUE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhTimer;

			// For benchmarks only
			//var date = new Date();
		    //rhPtr.rh4Results[rhPtr.rh4PosPile] = date.getTime() % 100000;
		}
	}
	// CUT

	// Storyboard object
	// ------------------------------------------------------------------
	function EXP_FRAMEALPHACOEF()
	{
	}
	EXP_FRAMEALPHACOEF.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 255;
		}
	}
	// CUT

	function EXP_FRAMERGBCOEF()
	{
	}
	EXP_FRAMERGBCOEF.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 0x00FFFFFF;
		}
	}
	// CUT

	function EXP_FRAMERATE()
	{
	}
	EXP_FRAMERATE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var n;
			var total = 0;
			for (n = 0; n < CRun.MAX_FRAMERATE; n++)
				total += rhPtr.rh4FrameRateArray[n];
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.round((1000 * CRun.MAX_FRAMERATE) / total);
		}
	};


	// CUT

	function EXP_GAMLEVEL()
	{
	}
	EXP_GAMLEVEL.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.currentFrame;
		}
	}
	// CUT

	function EXP_GAMLEVELNEW()
	{
	}
	EXP_GAMLEVELNEW.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.currentFrame + 1;
		}
	}
	// CUT

	function EXP_GAMNPLAYER()
	{
	}
	EXP_GAMNPLAYER.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhNPlayers;
		}
	}
	// CUT

	function EXP_GETCOLLISIONMASK()
	{
	}
	EXP_GETCOLLISIONMASK.prototype =
	{
		evaluate: function (rhPtr)
		{
			var x, y;

			rhPtr.rh4CurToken++;
			x = rhPtr.get_ExpressionInt();
			rhPtr.rh4CurToken++;
			y = rhPtr.get_ExpressionInt();

			var result = 0;
			if (rhPtr.y_GetLadderAt(-1, x, y) != null)
				result = 2;
			else
			{
				if (rhPtr.colMask_Test_XY(x, y, -1, CRunFrame.CM_TEST_OBSTACLE))
					result = 1;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = result;
		}
	}
	// CUT

	function EXP_GETFRAMEBKDCOLOR()
	{
	}
	EXP_GETFRAMEBKDCOLOR.prototype =
	{
		evaluate: function (rhPtr)
		{
			var color = rhPtr.rhFrame.leBackground;
			if (rhPtr.rhApp.bPreloader)
				color = rhPtr.rhApp.parentApp.frame.leBackground;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.swapRGB(color);
		}
	}
	// CUT

	function EXP_GETVIRTUALHEIGHT()
	{
	}
	EXP_GETVIRTUALHEIGHT.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhFrame.leVirtualRect.bottom;
		}
	}
	// CUT

	function EXP_GETVIRTUALWIDTH()
	{
	}
	EXP_GETVIRTUALWIDTH.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhFrame.leVirtualRect.right;
		}
	}
	// CUT

	function EXP_PLAYHEIGHT()
	{
	}
	EXP_PLAYHEIGHT.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhFrame.leHeight;
		}
	}
	// CUT

	function EXP_PLAYWIDTH()
	{
	}
	EXP_PLAYWIDTH.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhFrame.leWidth;
		}
	}
	// CUT

	function EXP_PLAYXLEFT()
	{
	}
	EXP_PLAYXLEFT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var r = rhPtr.rhWindowX;
			if ((rhPtr.rh3Scrolling & CRun.RH3SCROLLING_SCROLL) != 0)
				r = rhPtr.rh3DisplayX;
			if (r < 0)
				r = 0;

			rhPtr.rh4Results[rhPtr.rh4PosPile] = r;
		}
	}
	// CUT

	function EXP_PLAYXRIGHT()
	{
	}
	EXP_PLAYXRIGHT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var r = rhPtr.rhWindowX;
			if ((rhPtr.rh3Scrolling & CRun.RH3SCROLLING_SCROLL) != 0)
				r = rhPtr.rh3DisplayX;
			r += rhPtr.rh3WindowSx;
			if (r > rhPtr.rhLevelSx)
				r = rhPtr.rhLevelSx;

			rhPtr.rh4Results[rhPtr.rh4PosPile] = r;
		}
	}
	// CUT

	function EXP_PLAYYBOTTOM()
	{
	}
	EXP_PLAYYBOTTOM.prototype =
	{
		evaluate: function (rhPtr)
		{
			var r = rhPtr.rhWindowY;
			if ((rhPtr.rh3Scrolling & CRun.RH3SCROLLING_SCROLL) != 0)
				r = rhPtr.rh3DisplayY;
			r += rhPtr.rh3WindowSy;
			if (r > rhPtr.rhLevelSy)
				r = rhPtr.rhLevelSy;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = r;
		}
	}
	// CUT

	function EXP_PLAYYTOP()
	{
	}
	EXP_PLAYYTOP.prototype =
	{
		evaluate: function (rhPtr)
		{
			var r = rhPtr.rhWindowY;
			if ((rhPtr.rh3Scrolling & CRun.RH3SCROLLING_SCROLL) != 0)
				r = rhPtr.rh3DisplayY;
			if (r < 0)
				r = 0;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = r;
		}
	}
	// CUT

	// Create object
	// ------------------------------------------------------------------
	function EXP_CRENUMBERALL()
	{
	}
	EXP_CRENUMBERALL.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhNObjects;
		}
	}
	// CUT

	// Counter object
	// ------------------------------------------------------------------
	function EXP_CGETCOLOR1()
	{
	}
	EXP_CGETCOLOR1.prototype =
	{
		evaluate: function (rhPtr)
		{
			var hoPtr = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (hoPtr == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var rgb = hoPtr.cpt_GetColor1();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.swapRGB(rgb);
		}
	}
	// CUT

	function EXP_CGETCOLOR2()
	{
	}
	EXP_CGETCOLOR2.prototype =
	{
		evaluate: function (rhPtr)
		{
			var hoPtr = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (hoPtr == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var rgb = hoPtr.cpt_GetColor2();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.swapRGB(rgb);
		}
	}
	// CUT

	function EXP_CGETMAX()
	{
	}
	EXP_CGETMAX.prototype =
	{
		evaluate: function (rhPtr)
		{
			var hoPtr = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (hoPtr == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = hoPtr.cpt_GetMax();
		}
	}
	// CUT

	function EXP_CGETMIN()
	{
	}
	EXP_CGETMIN.prototype =
	{
		evaluate: function (rhPtr)
		{
			var hoPtr = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (hoPtr == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = hoPtr.cpt_GetMin();
		}
	}
	// CUT

	function EXP_CVALUE()
	{
	}
	EXP_CVALUE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var hoPtr = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (hoPtr == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = hoPtr.cpt_GetValue();
			if (hoPtr.bFloat)
				rhPtr.flagFloat = true;
		}
	}
	// CUT

	// Sub application object
	// ------------------------------------------------------------------
	function EXP_CCAGETGLOBALSTRING()
	{
	}
	EXP_CCAGETGLOBALSTRING.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			var num = rhPtr.get_ExpressionInt() - 1;
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.getGlobalString(num);
		}
	}
	// CUT

	function EXP_CCAGETGLOBALVALUE()
	{
	}
	EXP_CCAGETGLOBALVALUE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			var num = rhPtr.get_ExpressionInt() - 1;
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.getGlobalValue(num);
		}
	}
	// CUT

	function EXP_CCAGETFRAMENUMBER()
	{
	}
	EXP_CCAGETFRAMENUMBER.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.getFrameNumber();
		}
	}
	// CUT

	// String object
	// ----------------------------------------------------------------------
	function EXP_STRGETCURRENT()
	{
	}
	EXP_STRGETCURRENT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
				return;
			}
			if (pHo.rsTextBuffer != null)
				rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rsTextBuffer;
			else
				rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
		}
	}
	// CUT

	function EXP_STRGETNPARA()
	{
	}
	EXP_STRGETNPARA.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.getCurrentResult().forceInt(0);
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rsMaxi;
		}
	}
	// CUT

	function EXP_STRGETNUMBER()
	{
	}
	EXP_STRGETNUMBER.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
				return;
			}
			var num = rhPtr.get_ExpressionInt();

			if (num < 0)
			{
				if (pHo.rsTextBuffer != null)
					rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rsTextBuffer;
				else
					rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
				return;
			}

			if (num >= pHo.rsMaxi)
				num = pHo.rsMaxi - 1;
			var txt = pHo.hoCommon.ocObject;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = txt.otTexts[num].tsText;
		}
	}
	// CUT

	function EXP_STRGETNUMERIC()
	{
	}
	EXP_STRGETNUMERIC.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.getCurrentResult().forceInt(0);
				return;
			}
			if (pHo.rsTextBuffer != null)
				rhPtr.rh4Results[rhPtr.rh4PosPile] = parseFloat(pHo.rsTextBuffer);
			else
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}
	// CUT

	function EXP_STRNUMBER()
	{
	}
	EXP_STRNUMBER.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rsMini + 1;
		}
	}
	// CUT

	// Common object expressions
	// -----------------------------------------------------------------------

	function EXP_EXTDISTANCE()
	{
	}
	EXP_EXTDISTANCE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			var x2 = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var y2 = rhPtr.getExpression();
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var deltaX = x2 - pHo.hoX;
			var deltaY = y2 - pHo.hoY;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.approximateInt(Math.sqrt(deltaX * deltaX + deltaY * deltaY));
		}
	}
	// CUT

	function EXP_EXTANGLE()
	{
	}
	EXP_EXTANGLE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			var x2 = rhPtr.getExpression();
			rhPtr.rh4CurToken++;
			var y2 = rhPtr.getExpression();
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var angle = Math.atan2(-(y2 - pHo.hoY), (x2 - pHo.hoX)) * 180.0 / 3.141592653589;
			if (angle < 0)
				angle = 360 + angle;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = CServices.approximateInt(angle);
		}
	}
	// CUT

	function EXP_EXTACC()
	{
	}
	EXP_EXTACC.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.getAcc();
		}
	}
	// CUT

	function EXP_EXTALPHACOEF()
	{
	}
	EXP_EXTALPHACOEF.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var effect = pHo.ros.rsEffect;
			var effectParam = pHo.ros.rsEffectParam;
			var alpha = 0;
			var rgbaCoeff = effectParam;

			switch (effect & CRSpr.BOP_MASK)
			{
				case CRSpr.BOP_EFFECTEX:
					alpha = 255 - ((effectParam >> 24) & 0xFF);
					break;
				case CRSpr.BOP_BLEND:
					alpha = 255 - ((effectParam == 128) ? 0 : (255 - effectParam * 2));
					break;
				default:
					if (effect & CRSpr.BOP_RGBAFILTER)
						alpha = 255 - ((effectParam >> 24) & 0xFF);
					break;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = alpha;
		}
	}
	// CUT

	function EXP_EXTDEC()
	{
	}
	EXP_EXTDEC.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.getDec();
		}
	}
	// CUT

	function EXP_EXTDIR()
	{
	}
	EXP_EXTDIR.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.getDir(pHo);
		}
	}
	// CUT

	function EXP_EXTFLAG()
	{
	}
	EXP_EXTFLAG.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			var num = rhPtr.get_ExpressionInt();
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			num &= 31;
			if (pHo.rov != null)
			{
				var result = 0;
				if (((1 << num) & pHo.rov.rvValueFlags) != 0)
					result = 1;
				rhPtr.rh4Results[rhPtr.rh4PosPile] = result;
			}
			else
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}
	// CUT

	function EXP_EXTGETFONTCOLOR()
	{
	}
	EXP_EXTGETFONTCOLOR.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var rgb = CRun.getObjectTextColor(pHo);
			rgb = CServices.swapRGB(rgb);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rgb;
		}
	}
	// CUT

	function EXP_EXTGETFONTNAME()
	{
	}
	EXP_EXTGETFONTNAME.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
				return;
			}
			var info = CRun.getObjectFont(pHo);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = info.lfFaceName;
		}
	}
	// CUT

	function EXP_EXTGETFONTSIZE()
	{
	}
	EXP_EXTGETFONTSIZE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var info = CRun.getObjectFont(pHo);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = Math.round((info.lfHeight * 72) / 96);
		}
	}
	// CUT

	function EXP_EXTGETGRAVITY()
	{
	}
	EXP_EXTGETGRAVITY.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.getGravity();
		}
	}
	// CUT

	function EXP_EXTGETLAYER()
	{
	}
	EXP_EXTGETLAYER.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoLayer + 1;
		}
	}
	// CUT

	function EXP_EXTGETSEMITRANSPARENCY()
	{
	}
	EXP_EXTGETSEMITRANSPARENCY.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var t = 0;
			if (pHo.ros != null)
				t = pHo.ros.getSemiTransparency();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = t;
		}
	}
	// CUT

	function EXP_EXTIDENTIFIER()
	{
	}
	EXP_EXTIDENTIFIER.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var id = (pHo.hoCreationId << 16) | (pHo.hoNumber & 0xFFFF);
			rhPtr.rh4Results[rhPtr.rh4PosPile] = id;
		}
	}
	// CUT

	function EXP_EXTISPR()
	{
	}
	EXP_EXTISPR.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var i = 0;
			if (pHo.roa != null)
				i = pHo.roa.raAnimFrame;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = i;
		}
	}
	// CUT

	function EXP_EXTNANI()
	{
	}
	EXP_EXTNANI.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var i = 0;
			if (pHo.roa != null)
				i = pHo.roa.raAnimOn;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = i;
		}
	}
	// CUT

	function EXP_EXTNMOVE()
	{
	}
	EXP_EXTNMOVE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var i = 0;
			if (pHo.roa != null)
				i = pHo.rom.rmMvtNum;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = i;
		}
	}
	// CUT

	function EXP_EXTNOBJECTS()
	{
	}
	EXP_EXTNOBJECTS.prototype =
	{
		evaluate: function (rhPtr)
		{
			var qoil = this.oiList;
			var poil;
			if ((qoil & 0x8000) == 0)
			{
				poil = rhPtr.rhOiList[qoil];
				rhPtr.rh4Results[rhPtr.rh4PosPile] = poil.oilNObjects;
			}
			else
			{
				var count = 0;
				if (qoil != -1)
				{
					var pqoi = rhPtr.rhEvtProg.qualToOiList[qoil & 0x7FFF];
					var qoi;
					for (qoi = 0; qoi < pqoi.qoiList.length; qoi += 2)
					{
						poil = rhPtr.rhOiList[pqoi.qoiList[qoi + 1]];
						count += poil.oilNObjects;
					}
				}
				rhPtr.rh4Results[rhPtr.rh4PosPile] = count;
			}
		}
	}
	// CUT

	function EXP_EXTRGBCOEF()
	{
	}
	EXP_EXTRGBCOEF.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var effect = pHo.ros.rsEffect;
			var effectParam = pHo.ros.rsEffectParam;
			var rgb = 0;
			var rgbaCoeff = effectParam;

			if ((effect & CRSpr.BOP_MASK) == CRSpr.BOP_EFFECTEX || (effect & CRSpr.BOP_RGBAFILTER) != 0)
				rgb = CServices.swapRGB((rgbaCoeff & 0x00FFFFFF));
			else
				rgb = 0x00FFFFFF;

			rhPtr.rh4Results[rhPtr.rh4PosPile] = rgb;
		}
	}
	// CUT

	function EXP_EXTSPEED()
	{
	}
	EXP_EXTSPEED.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var i = 0;
			if (pHo.roa != null)
				i = pHo.rom.rmMovement.getSpeed();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = i;
		}
	}
	// CUT

	function EXP_EXTXAP()
	{
	}
	EXP_EXTXAP.prototype =
	{
		evaluate: function (rhPtr)
		{
			var x = 0;
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo != null)
			{
				x = pHo.hoX;
				if (pHo.roa != null)
				{
					if (pHo.roc.rcImage >= 0)
					{
						var ifo;
						ifo = rhPtr.rhApp.imageBank.getImageInfoEx(pHo.roc.rcImage, pHo.roc.rcAngle, pHo.roc.rcScaleX, pHo.roc.rcScaleY);
						if (ifo != null)
						{
							rhPtr.rh4Results[rhPtr.rh4PosPile] = x + ifo.xAP - ifo.xSpot;
							return;
						}
					}
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = x;
		}
	}
	// CUT

	function EXP_EXTXLEFT()
	{
	}
	EXP_EXTXLEFT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoX - pHo.hoImgXSpot;
		}
	}
	// CUT

	function EXP_EXTXRIGHT()
	{
	}
	EXP_EXTXRIGHT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoX - pHo.hoImgXSpot + pHo.hoImgWidth;
		}
	}
	// CUT

	function EXP_EXTXSPR()
	{
	}
	EXP_EXTXSPR.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoX;
		}
	}
	// CUT

	function EXP_EXTYAP()
	{
	}
	EXP_EXTYAP.prototype =
	{
		evaluate: function (rhPtr)
		{
			var y = 0;
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo != null)
			{
				y = pHo.hoY;
				if (pHo.roa != null)
				{
					if (pHo.roc.rcImage >= 0)
					{
						var ifo;
						ifo = rhPtr.rhApp.imageBank.getImageInfoEx(pHo.roc.rcImage, pHo.roc.rcAngle, pHo.roc.rcScaleX, pHo.roc.rcScaleY);
						if (ifo != null)
						{
							rhPtr.rh4Results[rhPtr.rh4PosPile] = y + ifo.yAP - ifo.ySpot;
							return;
						}
					}
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = y;
		}
	}
	// CUT

	function EXP_EXTACC()
	{
	}
	EXP_EXTACC.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.getAcc();
		}
	}
	// CUT

	function EXP_EXTYBOTTOM()
	{
	}
	EXP_EXTYBOTTOM.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoY - pHo.hoImgYSpot + pHo.hoImgHeight;
		}
	}
	// CUT

	function EXP_EXTYSPR()
	{
	}
	EXP_EXTYSPR.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoY;
		}
	}
	// CUT

	function EXP_EXTYTOP()
	{
	}
	EXP_EXTYTOP.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoY - pHo.hoImgYSpot;
		}
	}
	// CUT

	// Active object
	// -----------------------------------------------------------------------
	function EXP_GETANGLE()
	{
	}
	EXP_GETANGLE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var angle = pHo.roc.rcAngle;
			var pMovement = rhPtr.GetMBase(pHo);
			if (pMovement)
			{
				angle = pMovement.getAngle();
				if (angle == CRunMBase.ANGLE_MAGIC)
					angle = pHo.roc.rcAngle;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = angle;
		}
	}
	// CUT


	function EXP_GETRGBAT()
	{
	}
	EXP_GETRGBAT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var hoPtr = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			rhPtr.rh4CurToken++;
			if (hoPtr == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			var x = rhPtr.get_ExpressionInt();
			rhPtr.rh4CurToken++;
			var y = rhPtr.get_ExpressionInt();

			var rgb = 0;
			if (hoPtr.roc.rcImage != -1)
			{
				var image = rhPtr.rhApp.imageBank.getImageFromHandle(hoPtr.roc.rcImage);
				rgb = image.getPixel(x, y);
				rgb = CServices.swapRGB(rgb);
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rgb;
		}
	}
	// CUT

	function EXP_GETSCALEX()
	{
	}
	EXP_GETSCALEX.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.roc.rcScaleX;
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	function EXP_GETSCALEY()
	{
	}
	EXP_GETSCALEY.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.roc.rcScaleY;
			rhPtr.flagFloat = true;
		}
	}
	// CUT

	// Speaker object
	// -----------------------------------------------------------------------
	function EXP_GETCHANNELDUR()
	{
	}
	EXP_GETCHANNELDUR.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getDurationChannel(value - 1);
		}
	}
	// CUT

	function EXP_GETCHANNELFREQ()
	{
	}
	EXP_GETCHANNELFREQ.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getFrequencyChannel(value - 1);
		}
	}
	// CUT

	function EXP_GETCHANNELPOS()
	{
	}
	EXP_GETCHANNELPOS.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getPositionChannel(value - 1);
		}
	}
	// CUT


	function EXP_GETSAMPLEDUR()
	{
	}
	EXP_GETSAMPLEDUR.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var name = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getDurationSample(name);
		}
	}
	// CUT

	function EXP_GETSAMPLEFREQ()
	{
	}
	EXP_GETSAMPLEFREQ.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var name = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getFrequencySample(name);
		}
	}
	// CUT

	function EXP_GETSAMPLEMAINPAN()
	{
	}
	EXP_GETSAMPLEMAINPAN.prototype =
	{
		evaluate: function (rhPtr)
		{
			var p = rhPtr.rhApp.soundPlayer.getMainPan() * 100;
			if (p < 0)
				p -= 0.5;
			else
				p += 0.5;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = p;
		}
	}
	// CUT

	function EXP_GETSAMPLEMAINVOL()
	{
	}
	EXP_GETSAMPLEMAINVOL.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getMainVolume();
		}
	}
	// CUT

	function EXP_GETSAMPLEPOS()
	{
	}
	EXP_GETSAMPLEPOS.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var name = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getPositionSample(name);
		}
	}
	// CUT

	function EXP_GETCHANNELVOL()
	{
	}
	EXP_GETCHANNELVOL.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var value = rhPtr.get_ExpressionInt();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getVolumeChannel(value - 1);
		}
	}
	// CUT

	function EXP_GETSAMPLEVOL()
	{
	}
	EXP_GETSAMPLEVOL.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var name = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.soundPlayer.getVolumeSample(name);
		}
	}

	function EXP_GETSAMPLEPAN()
	{
	}
	EXP_GETSAMPLEPAN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var name = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}
	// CUT

	function EXP_GETCHANNELPAN()
	{
	}
	EXP_GETCHANNELPAN.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4CurToken++;
			var name = rhPtr.getExpression();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
		}
	}
	// CUT

	// Keyboard object
	// ---------------------------------------------------------
	function EXP_MOUSEWHEELDELTA()
	{
	}
	EXP_MOUSEWHEELDELTA.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.deltaWheel * 40;
		}
	}
	// CUT

	function EXP_XMOUSE()
	{
	}
	EXP_XMOUSE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.getXMouse();
		}
	}
	// CUT

	function EXP_YMOUSE()
	{
	}
	EXP_YMOUSE.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.getYMouse();
		}
	}
	// CUT

	// Player object
	// ---------------------------------------------------------
	function EXP_GETINPUT()
	{
	}
	EXP_GETINPUT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var joueur = this.oi;
			var r = CRunApp.CTRLTYPE_KEYBOARD;
			if (joueur < CRunApp.MAX_PLAYER)
				r = rhPtr.rhApp.getCtrlType()[joueur];
			if (r == CRunApp.CTRLTYPE_KEYBOARD)
				r = CRunApp.CTRLTYPE_MOUSE;
			rhPtr.rh4Results[rhPtr.rh4PosPile] = r;
		}
	}
	// CUT

	function EXP_GETINPUTKEY()
	{
	}
	EXP_GETINPUTKEY.prototype =
	{
		evaluate: function (rhPtr)
		{
			var joueur = this.oi;

			rhPtr.rh4CurToken++;
			var kvCode = rhPtr.get_ExpressionInt();
			var s = "";
			if (key < CRunApp.MAX_KEY)
			{
				if (vkCode >= 96 && vkCode <= 105)
				{
					c = vkCode - 96;
					s = "Numpad" + c.toString();
				}
				else if (vkCode >= 112 && vkCode <= 126)
				{
					c = vkCode - 112;
					s = "F" + c.toString();
				}
				else if (vkCode >= 48 && vkCode <= 57)
				{
					c = vkCode - 48;
					s = c.toString();
				}
				else if (vkCode >= 65 && vkCode <= 90)
				{
					s = String.fromCharCode(vkCode);
				}
				else
				{
					s = "Control key";
					/*TODO		    var n;
					 for (n=0; n<NB_SPECIAL_KEYS; n++)
					 {
					 if (keys[n*2+1]==vkCode)
					 {
					 s=keyNames[n];
					 break;
					 }
					 }
					 */
				}
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = s;
		}
	}
	// CUT

	function EXP_GETPLAYERNAME()
	{
	}
	EXP_GETPLAYERNAME.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.playerNames[this.oi];
		}
	}
	// CUT

	function EXP_PLALIVES()
	{
	}
	EXP_PLALIVES.prototype =
	{
		evaluate: function (rhPtr)
		{
			rhPtr.rh4Results[rhPtr.rh4PosPile] = rhPtr.rhApp.getLives()[this.oi];
		}
	}
	// CUT

	function EXP_PLASCORE()
	{
	}
	EXP_PLASCORE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var scores = rhPtr.rhApp.getScores();
			rhPtr.rh4Results[rhPtr.rh4PosPile] = scores[this.oi];
		}
	}
	// CUT

	function EXP_EXTLOOPINDEX()
	{
	}
	EXP_EXTLOOPINDEX.prototype =
	{
		evaluate: function (rhPtr)
		{
			var x = 0;
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo != null)
			{
				if (rhPtr.rh4CurrentForEach != null)
				    if (this.oiList == rhPtr.rh4CurrentForEach.oi)
						x = rhPtr.rh4CurrentForEach.index;

				if (rhPtr.rh4CurrentForEach2 != null)
				    if (this.oiList == rhPtr.rh4CurrentForEach2.oi)
						x = rhPtr.rh4CurrentForEach2.index;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = x;
		}
	}
	// CUT

	// BOX2D MOVEMENTS
	//////////////////////////////////////////////////////////////////////

	function EXP_EXTGETFRICTION()
	{
	}
	EXP_EXTGETFRICTION.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (rhPtr.GetMBase(pHo) == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETFRICTION, 0);
		}
	}
	// CUT

	function EXP_EXTGETRESTITUTION()
	{
	}
	EXP_EXTGETRESTITUTION.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (rhPtr.GetMBase(pHo) == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETRESTITUTION, 0);
		}
	}
	// CUT

	function EXP_EXTGETDENSITY()
	{
	}
	EXP_EXTGETDENSITY.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (rhPtr.GetMBase(pHo) == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETDENSITY, 0);
		}
	}
	// CUT

	function EXP_EXTGETVELOCITY()
	{
	}
	EXP_EXTGETVELOCITY.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (rhPtr.GetMBase(pHo) == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETVELOCITY, 0);
		}
	}
	// CUT

	function EXP_EXTGETANGLE()
	{
	}
	EXP_EXTGETANGLE.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (rhPtr.GetMBase(pHo) == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETANGLE, 0);
		}
	}
	// CUT

	function EXP_EXTGETRESTITUTION()
	{
	}
	EXP_EXTGETRESTITUTION.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (rhPtr.GetMBase(pHo) == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETRESTITUTION, 0);
		}
	}
	// CUT

	function EXP_EXTWIDTH()
	{
	}
	EXP_EXTWIDTH.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoImgWidth;
		}
	}
	// CUT

	function EXP_EXTHEIGHT()
	{
	}
	EXP_EXTHEIGHT.prototype =
	{
		evaluate: function (rhPtr)
		{
			var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
			if (pHo == null)
			{
				rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
				return;
			}
			rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoImgHeight;
		}
	}
	// CUT

	function EXP_EXTGETMASS() {
	}
	EXP_EXTGETMASS.prototype =
	{
	    evaluate: function (rhPtr) {
	        var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
	        if (rhPtr.GetMBase(pHo) == null) {
	            rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
	            return;
	        }
	        rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETMASS, 0);
	    }
	}
	// CUT

	function EXP_EXTGETANGULARVELOCITY() {
	}
	EXP_EXTGETANGULARVELOCITY.prototype =
	{
	    evaluate: function (rhPtr) {
	        var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
	        if (rhPtr.GetMBase(pHo) == null) {
	            rhPtr.rh4Results[rhPtr.rh4PosPile] = 0;
	            return;
	        }
	        rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.rom.rmMovement.callMovement(CExp.EXP_EXTGETANGULARVELOCITY, 0);
	    }
	}
	// CUT

	function EXP_EXTGETNAME() {
	}
	EXP_EXTGETNAME.prototype =
	{
	    evaluate: function (rhPtr) {
	        var pHo = rhPtr.rhEvtProg.get_ExpressionObjects(this.oiList);
	        if (pHo == null) {
	            rhPtr.rh4Results[rhPtr.rh4PosPile] = "";
	            return;
	        }
	        rhPtr.rh4Results[rhPtr.rh4PosPile] = pHo.hoOiList.oilName;
	    }
	}
	// CUT
	// CRunApp object
	// -----------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	__scope["FusionVersion"] = "Clickteam Fusion HTML5 Exporter Build 288.1";

	CRunApp.MAX_PLAYER = 4;
	CRunApp.RUNTIME_VERSION = 0x0302;
	CRunApp.MAX_KEY = 8;
	CRunApp.GA_NOHEADING = 0x0002;
	CRunApp.GA_STRETCHTOFIT = 0x0004;
	CRunApp.GA_SPEEDINDEPENDANT = 0x0008;
	CRunApp.GA_STRETCH = 0x0010;
	CRunApp.GA_MENUHIDDEN = 0x0080;
	CRunApp.GA_MENUBAR = 0x0100;
	CRunApp.GA_MAXIMISE = 0x0200;
	CRunApp.GA_MIX = 0x0400;
	CRunApp.GA_FULLSCREENATSTART = 0x0800;
	CRunApp.GANF_SAMPLESOVERFRAMES = 0x0001;
	CRunApp.GANF_RUNFRAME = 0x0004;
	CRunApp.GANF_SAMPLESEVENIFNOTFOCUS = 0x0008;
	CRunApp.GANF_NOTHICKFRAME = 0x0040;
	CRunApp.GANF_DONOTCENTERFRAME = 0x0080;
	CRunApp.GANF_DISABLE_CLOSE = 0x0200;
	CRunApp.GANF_HIDDENATSTART = 0x0400;
	CRunApp.GANF_VSYNC = 0x1000;
	CRunApp.GAOF_JAVASWING = 0x1000;
	CRunApp.GAOF_JAVAAPPLET = 0x2000;
	CRunApp.RUNTIME_CM = 1;
	CRunApp.SL_RESTART = 0;
	CRunApp.SL_STARTFRAME = 1;
	CRunApp.SL_FRAMEFADEINLOOP = 2;
	CRunApp.SL_FRAMELOOP = 3;
	CRunApp.SL_FRAMEFADEOUTLOOP = 4;
	CRunApp.SL_ENDFRAME = 5;
	CRunApp.SL_QUIT = 6;
	CRunApp.SL_WAITFORMOCHI = 7;
	CRunApp.MAX_VK = 203;
	CRunApp.VK_LEFT = 0x25;
	CRunApp.VK_RIGHT = 0x27;
	CRunApp.VK_UP = 0x26;
	CRunApp.VK_DOWN = 0x28;
	CRunApp.VK_LBUTTON = 200;
	CRunApp.VK_MBUTTON = 201;
	CRunApp.VK_RBUTTON = 202;
	CRunApp.VK_NUMPAD0 = 0x60;
	CRunApp.VK_NUMPAD1 = 0x61;
	CRunApp.VK_NUMPAD2 = 0x62;
	CRunApp.VK_NUMPAD3 = 0x63;
	CRunApp.VK_NUMPAD4 = 0x64;
	CRunApp.VK_NUMPAD5 = 0x65;
	CRunApp.VK_NUMPAD6 = 0x66;
	CRunApp.VK_NUMPAD7 = 0x67;
	CRunApp.VK_NUMPAD8 = 0x68;
	CRunApp.VK_NUMPAD9 = 0x69;
	CRunApp.VK_S = 0x53;
	CRunApp.VK_D = 0x44;
	CRunApp.VK_E = 0x45;
	CRunApp.VK_X = 0x58;
	CRunApp.VK_F12 = 0x7B;
	CRunApp.VK_SHIFT = 0x10;
	CRunApp.VK_CONTROL = 0x11;
	CRunApp.VK_MENU = 0x12;
	CRunApp.CTRLTYPE_MOUSE = 0;
	CRunApp.CTRLTYPE_JOY1 = 1;
	CRunApp.CTRLTYPE_JOY2 = 2;
	CRunApp.CTRLTYPE_JOY3 = 3;
	CRunApp.CTRLTYPE_JOY4 = 4;
	CRunApp.CTRLTYPE_KEYBOARD = 5;
	CRunApp.ARF_INGAMELOOP = 0x0004;
	CRunApp.BUILDFLAG_TEST = 0x0080;
	CRunApp.AH2OPT_KEEPSCREENRATIO = 0x0001;
	CRunApp.AH2OPT_RESAMPLESTRETCH = 0x0004;
	CRunApp.AH2OPT_WEBGL = 0x10000;
	CRunApp.AH2OPT_KEEPRESOURCESBETWEENFRAMES = 0x8000;
	CRunApp.AH2OPT_RUNEVENIFNOTFOCUS = 0x100000;
	CRunApp.AH2OPT_PRELOADERQUIT = 0x800000;
	CRunApp.AH2OPT_LOADDATAATSTART = 0x1000000;
	CRunApp.AH2OPT_LOADSOUNDSONTOUCH = 0x2000000;
	CRunApp.AH2OPT_DESTROYIFNOINACTIVATE = 0x4000000;
	CRunApp.MAX_TOUCHES = 10;
	CRunApp.FAKE_TOUCHIDENTIFIER = 0x2356A465;
	CRunApp.TOUCHID_EMPTY = 0x69865358;

	function loadApplication()
	{
		__scope.application.loadApplication();
	}
	function loadInfo()
	{
		__scope.application.loadInfo();
	}
	__scope['loadApplication'] = loadApplication;
	__scope['loadInfo'] = loadInfo;

	function CRunApp(cName, cfile, path, sub)
	{
		this.isSubApp = (sub === true);
		if(this.isSubApp)
		{
			this.canvas = cName.canvas;
			this.parent_element = cName.parent_element;
			this.cName = null;
		}
		else if(typeof cName === 'string')
		{
			this.canvas = document.getElementById(cName);
			this.parent_element = this.canvas.parentElement;
			this.cName = cName;
		}
		else if(cName instanceof HTMLElement)
		{
			this.canvas = document.createElement('canvas');
			this.parent_element = cName;
			this.cName = null;
		}

		var cont = this.container = cName.container || document.createElement('div');
		cont.appendChild(this.canvas);
		this.parent_element.appendChild(cont);

		cont.style.overflow = 'hidden';
		cont.style.position = 'relative';
		cont.style.transform = 'translateZ(0)';
		cont.style.margin = '0';
		cont.style.padding = '0';
		cont.style.display = 'block';
		cont.style.boxSizing = 'content-box';
		cont.className = "MMFDiv";

		this.frameOffsets = null;
		this.frameEffects = null;
		this.frameEffectParams = null;
		this.frameMaxIndex = 0;
		this.framePasswords = null;
		this.appName = null;
		this.nGlobalValuesInit = 0;
		this.globalValuesInitTypes = null;
		this.globalValuesInit = null;
		this.nGlobalStringsInit = 0;
		this.globalStringsInit = null;
		this.OIList = null;
		this.imageBank = null;
		this.fontBank = null;
		this.soundBank = null;
		this.soundPlayer = null;
		this.soundContext = null;
		this.soundContextType = 0;
		this.appRunningState = 0;
		this.lives = null;
		this.scores = null;
		this.playerNames = null;
		this.gValues = null;
		this.gStrings = null;
		this.startFrame = 0;
		this.nextFrame = 0;
		this.currentFrame = 0;
		this.frame = null;
		this.file = null;
		this.parentApp = null;
		this.parentOptions = 0;
		this.parentWidth = 0;
		this.parentHeight = 0;
		this.refTime = 0;
		this.run = null;
		this.preloader = null;
		this.loadPreloader = false;

		this.xOffset = 0;
		this.yOffset = 0;
		this.gaFlags = 0;
		this.gaNewFlags = 0;
		this.gaMode = 0;
		this.gaOtherFlags = 0;
		this.gaCxWin = 0;
		this.gaCyWin = 0;
		this.gaScoreInit = 0;
		this.gaLivesInit = 0;
		this.gaBorderColour = 0;
		this.gaNbFrames = 0;
		this.gaFrameRate = 0;
		this.pcCtrlType = null;
		this.pcCtrlKeys = null;
		this.frameHandleToIndex = null;
		this.frameMaxHandle = 0;
		this.cx = 0;
		this.cy = 0;
		this.mouseX = 0;
		this.mouseY = 0;
		this.bMouseIn = false;
		this.keyBuffer = null;

		this.cursorCount = 0;
		this.cursor = 'auto';
		this.sysEvents = null;
		this.quit = false;
		this.m_bLoading = false;
		this.extensionStorage = null;
		this.extLoader = null;
		this.embeddedFiles = null;
		this.bUnicode = false;
		this.xMouseOffset = 0;
		this.yMouseOffset = 0;
		this.deltaWheel = 0;
		this.effect = 0;
		this.effectParam = 0;
		this.alpha = 0;

		this.dwOptions = 0;
		this.dwBuildType = 0;
		this.dwBuildFlags = 0;
		this.wScreenRatioTolerance = 0;
		this.wScreenAngle = 0;

		this.file = cfile;
		this.resources = "";
		this.path = path;
		var pos = path.lastIndexOf("/");
		if (pos >= 0)
			this.resources = path.substring(0, pos + 1);

		this.frameColor = 0;
		this.appEditorFilename = null;

		this.run = null;
		this.timer = 0;
		this.imagesToLoad = 0;
		this.imagesLoaded = 0;
		this.bLoading = false;
		this.keyNew = false;
		this.subApps = new Array(0);
		this.preloaderType = -1;                        // HTML5PRELOADER_IMAGE (0) ou HTML5PRELOADER_FRAMENUM (1)
		this.preloaderCircleCenterX = 0;
		this.preloaderCircleCenterY = 0;
		this.preloaderCircleRadius = 0;
		this.preloaderCircleThickness = 0;
		this.preloaderCircleColor = 0;
		this.preloaderBackColor = 0;
		this.preloaderFrameNumber = 0;        // première frame = 0
		this.transition = null;
		this.transitionManager = null;
		this.transitionDisplay = null;
		this.transitionOldSurface = null;
		this.bStartFadeIn = false;
		// Browser detection
		this.browserDetect = new BrowserDetect();
		this.touchesID = null;
		this.touchesX = null;
		this.touchesY = null;
		this.mouseTouch = CRunApp.TOUCHID_EMPTY;
		this.nTouches = 0;

		this.joystick = null;
		this.joystickOn = 0;

		this.accelerometer = 0;
		this.accelerometerHandler = null;
		this.accX = 0;
		this.accY = 0;
		this.accZ = 0;
		this.accGravX = 0;
		this.accGravY = 0;
		this.accGravZ = 0;
		this.scaleX = this.scaleY = 1;

		this.hasFocus = true;
		this.bStoppedFocus = false;
		this.iOS = false;
		this.firstFrameColor = 0;
		this.previousFrameGraphics = null;
		this.graphicFonts = null;

		this.infoVersion = -1;
		this.infoFile = null;
		this.infoCounter = 1000000000;
		this.infoPath = null;
		if (window.location.href.indexOf("192.") >= 0)
		{
			var pos = window.location.href.indexOf("21700/");
			if (pos >= 0)
			{
				this.infoPath = window.location.href.substring(0, pos + 6);
				this.infoVersion = -1;
				this.infoCounter = 25;
			}
		}
		this.bZoom = false;
		this.dataLoadingStep = 3;
		this.dataToLoad = new CArrayList();
		this.dataLoading = new CArrayList();
		this.mosaics = new Array();
		this.mosaicMaxHandle = 0;
		this.silentSound = null;
		this.m_touchMe = "Please touch the screen to start";
		this.oldFrameRate = -1000;
		this.fullScreen = false;
		this.versionCode = "***version***";
		this.versionCodePos = 0;
		this.versionCodeDisplay = 0;
		this.codePage = -1;


	}
	CRunApp.prototype =
	{
		loadInfo:        function ()
		{
			var version = this.infoFile.readAInt();
			if (this.infoVersion < 0)
				this.infoVersion = version;
			if (version != this.infoVersion)
			{
				this.infoFile.setUnicode(true);
				var name = this.infoFile.readAString();
				var path = this.infoPath + name;
				window.open(path, "_self");
			}
			this.infoCounter = 25;
		},
		load:            function ()
		{
			this.numberOfFiles = this.file.readAShort();
			this.currentFile = 1;
			this.loadingFile = new CFile();
			var size = this.file.readAInt();
			var filePath = this.path.substring(0, this.path.length - 1) + this.currentFile.toString();
			this.loadingFile.getFile(filePath, loadApplication, size);
		},
		loadApplication: function ()
		{
			this.currentFile++;
			if (this.currentFile > this.numberOfFiles)
			{
				var zip = new JSZip(this.loadingFile.getBytes(), "content");
				var unzipped = zip.file("Application.ccj").asBinary();
				this.loadingFile = null;
				this.file = new CFile();
				this.file.setBinary(unzipped);
				this.digest();
				this.startApplication();
				return;
			}
			var size = this.file.readAInt();
			var filePath = this.path.substring(0, this.path.length - 1) + this.currentFile.toString();
			this.loadingFile.getFile(filePath, loadApplication, size);
		},
		digest:          function ()
		{
			// Charge le mini-header
			this.file.seek(0);
			var b = this.file.readBuffer(4);
			this.bUnicode = false;
			if (b[0] == 80 && b[1] == 65 && b[2] == 77 && b[3] == 85)
			{
				this.bUnicode = true;
			}
			this.file.setUnicode(this.bUnicode);
			this.file.skipBytes(8);
			this.file.skipBytes(4);

			// Reserve les objets
			this.OIList = new COIList();
			this.imageBank = new CImageBank(this);
			this.fontBank = new CFontBank(this);
			this.soundBank = new CSoundBank(this);
			this.soundPlayer = new CSoundPlayer(this);

			// Lis les chunks
			var posEnd;
			var nbPass = 0, n;
			var chID = 0;
			var chFlags;
			var chSize;
			while (chID != 0x7F7F)
			{
				chID = this.file.readAShort();
				chFlags = this.file.readAShort();
				chSize = this.file.readAInt();

				if (chSize == 0)
				{
					continue;
				}
				posEnd = this.file.getFilePointer() + chSize;

				switch (chID)
				{
					// CHUNK_APPHEADER
					case 0x2223:
						this.loadAppHeader();
						// Buffer pour les offsets frame
						this.frameOffsets = new Array(this.gaNbFrames);
						this.frameEffects = new Array(this.gaNbFrames);
						this.frameEffectParams = new Array(this.gaNbFrames);
						// Pour les password
						this.framePasswords = new Array(this.gaNbFrames);
						for (n = 0; n < this.gaNbFrames; n++)
							this.framePasswords[n] = null;
						break;
					// CHUNK_APPHDR2
					case 0x2245:
						this.dwOptions = this.file.readAInt();
						this.dwBuildType = this.file.readAInt();
						this.dwBuildFlags = this.file.readAInt();
						this.wScreenRatioTolerance = this.file.readAShort();
						this.wScreenAngle = this.file.readAShort();
						break;
					// CHUNK_APPNAME
					case 0x2224:
						this.appName = this.file.readAString();
						break;
				    // CHUNK_APPCODEPAGE
				    case 0x2246:
				        this.codePage = this.file.readAInt();
				        break;
				   // Target file name
					case 0x222E:		// CHUNK_APPEDITORFILENAME:
						this.appEditorFilename = this.file.readAString();
						break;
					// Touch Screen message for iOS
					case 0x224E:        // CHUNK_HTML5_TOUCHME
						this.m_touchMe = this.file.readAString();
						break;
					// CHUNK_GLOBALVALUES
					case 0x2232:
						this.loadGlobalValues();
						break;
					// CHUNK_GLOBALSTRINGS
					case 0x2233:
						this.loadGlobalStrings();
						break;
					// CHUNK_FRAMEITEMS
					// CHUNK_FRAMEITEMS_2
					case 0x2229:
				    case 0x223F:
					    this.extLoader = new CExtLoader(this);
					    this.extLoader.createList(this.file);
					    this.OIList.preLoad(this.file);
						break;
					// CHUNK_FRAMEHANDLES
					case 0x222B:
						this.loadFrameHandles(chSize);
						break;
					// CHUNK_HTML5PRELOADER
					case 0x224A:
						this.preloaderType = this.file.readAInt();
						this.preloaderCircleCenterX = this.file.readAInt();
						this.preloaderCircleCenterY = this.file.readAInt();
						this.preloaderCircleRadius = this.file.readAInt();
						this.preloaderCircleThickness = this.file.readAInt();
						this.preloaderCircleColor = this.file.readAColor();
						this.preloaderBackColor = this.file.readAInt();
						if (this.preloaderBackColor != -1)
						{
							this.file.skipBack(4);
							this.preloaderBackColor = this.file.readAColor();
						}
						this.preloaderFrameNumber = this.file.readAInt();
						this.loadPreloader = true;
						break;
					// CHUNK_FRAME
					case 0x3333:
						// Repere les positions des frames dans le fichier
						this.frameOffsets[this.frameMaxIndex] = this.file.getFilePointer();
						var frID = 0;
						var frFlags;
						var frSize;
						while (frID != 0x7F7F)		// CHUNK_LAST
						{
							frID = this.file.readAShort();
							frFlags = this.file.readAShort();
							frSize = this.file.readAInt();

							if (frSize == 0)
							{
								continue;
							}
							var frPosEnd = this.file.getFilePointer() + frSize;

							switch (frID)
							{
								case 0x3334:
									if (this.frameMaxIndex == 0)
									{
										this.file.skipBytes(2 * 4);
										this.firstFrameColor = this.file.readAColor();
									}
									break;
								case 0x3336:
									this.framePasswords[this.frameMaxIndex] = this.file.readAString();
									break;
								case 0x3349:
									this.frameEffects[this.frameMaxIndex] = this.file.readAInt();
									this.frameEffectParams[this.frameMaxIndex] = this.file.readAInt();
									break;
								// CHUNK_MOSAICIMAGETABLE
								case 0x3348:
									var number = frSize / (3 * 2);
									var n;
									for (n = 0; n < number; n++)
									{
										var handle = this.file.readAShort();
										this.file.skipBytes(4);
										if (handle != 0)
										{
											this.mosaics[handle] = 1;
											this.mosaicMaxHandle = Math.max(this.mosaicMaxHandle, handle + 1);
										}
									}
									break;
							}
							this.file.seek(frPosEnd);
						}
						this.frameMaxIndex++;
						break;
					// CHUNK_BINARYFILES
					case 0x2238:
						var nFiles = this.file.readAInt();
						this.embeddedFiles = new Array(nFiles);
						for (n = 0; n < nFiles; n++)
						{
							this.embeddedFiles[n] = new CEmbeddedFile(this);
							this.embeddedFiles[n].preLoad();
						}
						break;
					// CHUNK_IMAGE
					case 0x6666:
						this.imageBank.preLoad(this.file);
						break;
					// CHUNK_FONT
					case 0x6667:
						this.fontBank.preLoad(this.file);
						break;
					// CHUNK_SOUNDS
					case 0x6668:
						this.soundBank.preLoad(this.file);
						break;
				}

				// Positionne a la fin du chunk
				this.file.seek(posEnd);
			}

			this.context = new StandardRenderer(this.canvas);

			// Fixe le flags multiple samples
			this.soundPlayer.setMultipleSounds((this.gaFlags & CRunApp.GA_MIX) != 0);

			// Cree le sprite principal
			if (this.parentApp == null)
			{
				this.mainSprite = new Sprite();
			}

		},

		setParentApp: function (pApp, sFrame, options, sprite, width, height)
		{
			this.parentApp = pApp;
			this.parentOptions = options;
			this.mainSprite = sprite;
			this.startFrame = sFrame;
			this.parentWidth = width;
			this.parentHeight = height;
		},

		initScreenZoom:     function ()
		{
			this.bZoom = false;
			this.scAngle = 0;
			this.scScale = this.scScaleX = this.scScaleY = 1;
			this.scXSpot = this.scXDest = this.gaCxWin / 2;
			this.scYSpot = this.scYDest = this.gaCyWin / 2;
		},
		setUpdate:          function ()
		{
			window.setTimeout(updateApplication.bind(this), 20);
		},
		startApplication:   function ()
		{
			//	    this.dwOptions |= CRunApp.AH2OPT_LOADDATAATSTART;        // FRANCOIS
			//	    this.dwOptions |= CRunApp.AH2OPT_LOADSOUNDSONTOUCH;

			// Specific sound handling if on iOS
			this.iOS = /iPad/i.test(navigator.userAgent) || /iPhone/i.test(navigator.userAgent) || /iPod/i.test(navigator.userAgent);
			if (this.iOS && this.soundBank.nHandlesReel > 0) // && (this.dwOptions & CRunApp.AH2OPT_LOADSOUNDSONTOUCH) != 0)
			{
				this.silentSound = new CSound(this);
				this.silentSound.loadSilent();
			}

			//		if (this.gaFlags&CRunApp.GA_STRETCH)
			this.resizeCanvas();

			this.sysEvents = new CArrayList();

			this.keyBuffer = new Array(CRunApp.MAX_VK);
			var n;
			for (n = 0; n < CRunApp.MAX_VK; n++)
				this.keyBuffer[n] = false;

			this.canvas.application = this;
			if (this.parentApp == null)
			{
				var that = this;
				window.addEventListener("keypress", function (e)
				{
					that.doKeyPress(e);
				}, false);
				window.addEventListener("keydown", function (e)
				{
					that.doKeyDown(e);
				}, false);
				window.addEventListener("keyup", function (e)
				{
					that.doKeyUp(e);
				}, false);
				window.addEventListener("blur", function (e)
				{
					that.hasFocus = false;
				}, false);
				window.addEventListener("focus", function (e)
				{
					that.hasFocus = true;
				}, false);
				if(window !== window.top)
				{
					try
					{
						var win2 = window.top;
						win2.addEventListener("focus", function()
						{
							that.hasFocus = true;
							that.canvas.focus();
						});
						win2.addEventListener("blur", function()
						{
							that.hasFocus = false;
						});
					}
					catch(e){}

				}
				window.addEventListener("resize", function (e)
				{
					that.resizeCanvas();
				}, false);
				document.addEventListener("blur", function (e)
				{
					that.hasFocus = false;
				}, false);
				document.addEventListener("focus", function (e)
				{
					that.hasFocus = true;
				}, false);
				document.addEventListener("fullscreenchange", function ()
				{
					that.fullScreen = document.fullscreen;
					that.resizeCanvas();
				}, false);
				document.addEventListener("mozfullscreenchange", function ()
				{
					that.fullScreen = document.mozFullScreen;
					that.resizeCanvas();
				}, false);
				document.addEventListener("webkitfullscreenchange", function ()
				{
					that.fullScreen = document.webkitIsFullScreen;
					that.resizeCanvas();
				}, false);
				this.canvas.addEventListener("mousemove", function (e)
				{
					that.mouseMove(e, that.canvas);
					if (e.preventDefault) e.preventDefault();
				}, false);
				this.canvas.addEventListener("mousedown", function (e)
				{
					that.mouseDown(e);
					if (e.preventDefault) e.preventDefault();
				}, false);
				this.canvas.addEventListener("mouseup", function (e)
				{
					that.mouseUp(e);
					if (e.preventDefault) e.preventDefault();
				}, false);
				this.canvas.addEventListener("mouseout", function (e)
				{
					that.mouseOut(e);
					if (e.preventDefault) e.preventDefault();
				}, false);
				this.canvas.addEventListener("click", function (e)
				{
				    that.click(e);
					if (e.preventDefault) e.preventDefault();
				}, false);
				this.canvas.addEventListener("dblclick", function (e)
				{
			        that.dblClick(e);
					if (e.preventDefault) e.preventDefault();
				}, false);
				this.canvas.addEventListener("contextmenu", function (e)
				{
					if (e.preventDefault) e.preventDefault();
				}, false);
				var mousewheelevt = (/Firefox/i.test(navigator.userAgent)) ? "DOMMouseScroll" : "mousewheel"
				if (document.attachEvent)
					document.attachEvent("on" + mousewheelevt, function (e)
					{
						that.mouseWheel(e);
					})
				else if (document.addEventListener)
					document.addEventListener(mousewheelevt, function (e)
					{
						that.mouseWheel(e);
					}, false)

				document.onselectstart = function ()
				{
					return false;
				}
				this.canvas.onselectstart = function (e)
				{
					if (e.preventDefault) e.preventDefault();
					return false;
				}

				this.touchable = this.isTouchable();
				this.touchCalls = new CArrayList();
				this.touchesID = new Array(CRunApp.MAX_TOUCHES);
				this.bTouchesLocked = new Array(CRunApp.MAX_TOUCHES);
				this.touchesLocked = new Array(CRunApp.MAX_TOUCHES);
				this.touchesX = new Array(CRunApp.MAX_TOUCHES);
				this.touchesY = new Array(CRunApp.MAX_TOUCHES);
				for (n = 0; n < CRunApp.MAX_TOUCHES; n++)
				{
					this.touchesID[n] = CRunApp.TOUCHID_EMPTY;
					this.touchesX[n] = 0;
					this.touchesY[n] = 0;
					this.bTouchesLocked[n] = false;
					this.touchesLocked[n] = 0;
				}
				this.nTouches = 0;

				if (this.touchable)
				{
					this.canvas.addEventListener('touchstart', function (e)
					{
						that.touchStart(e);
						if (e.preventDefault) e.preventDefault();
					}, false);
					this.canvas.addEventListener('touchmove', function (e)
					{
						that.touchMove(e);
						if (e.preventDefault) e.preventDefault();
					}, false);
					this.canvas.addEventListener('touchend', function (e)
					{
						that.touchEnd(e);
						if (e.preventDefault) e.preventDefault();
					}, false);
					this.canvas.addEventListener('touchcancel', function (e)
					{
						that.touchEnd(e);
						if (e.preventDefault) e.preventDefault();
					}, false);
					/*
					 var body=document.getElementsByTagName("body")[0];
					 body.addEventListener( 'touchstart', function(e)
					 {
					 e.preventDefault();
					 }, false );
					 */
				}
				window.focus();
				this.setUpdate();
			}
			else
			{
				this.touchable = this.parentApp.touchable;
				this.touchCalls = new CArrayList();
				this.touchesID = new Array(CRunApp.MAX_TOUCHES);
				this.bTouchesLocked = new Array(CRunApp.MAX_TOUCHES);
				this.touchesLocked = new Array(CRunApp.MAX_TOUCHES);
				this.touchesX = new Array(CRunApp.MAX_TOUCHES);
				this.touchesY = new Array(CRunApp.MAX_TOUCHES);
				for (n = 0; n < CRunApp.MAX_TOUCHES; n++)
				{
					this.touchesID[n] = CRunApp.TOUCHID_EMPTY;
					this.touchesX[n] = 0;
					this.touchesY[n] = 0;
					this.bTouchesLocked[n] = false;
					this.touchesLocked[n] = 0;
				}
				this.nTouches = 0;
			}
			this.xMouseOffset = 0;
			this.yMouseOffset = 0;

			this.appRunningState = 0;
			this.currentFrame = -2;

			this.run = new CRun(this);
		},
		resizeCanvas:       function ()
		{

			/*		if(navigator.userAgent.match(/Android/i))
			 {
			 window.scrollTo(0,1);
			 }
			 */
			var width = this.gaCxWin;
			var height = this.gaCyWin;

			var innerWidth;
			var innerHeight;
			if (this.fullScreen || (this.gaFlags & CRunApp.GA_STRETCH))
			{
				innerWidth = window.innerWidth;
				innerHeight = window.innerHeight;
				document.documentElement.style.overflow = 'hidden';
				document.body.scroll = "no";
			}
			else
			{
				innerWidth = width;
				innerHeight = height;
			}
			var scaleX = innerWidth / width,
				scaleY = innerHeight / height;

			if ((this.dwOptions & CRunApp.AH2OPT_KEEPSCREENRATIO) || ((this.gaFlags & CRunApp.GA_STRETCH) && (this.gaFlags & CRunApp.GA_STRETCHTOFIT)))
				scaleX = scaleY = Math.min(scaleX, scaleY);

			if (scaleX != this.scaleX || scaleY != this.scaleY)
			{
				this.scaleX = scaleX;
				this.scaleY = scaleY;

				this.canvas.width = Math.floor(this.scaleX * width);
				this.canvas.height = Math.floor(this.scaleY * height);
				this.context.setScale(this.scaleX, this.scaleY);
				var leftX = window.innerWidth / 2 - this.canvas.width / 2;
				var topY = window.innerHeight / 2 - this.canvas.height / 2;
				/*
				this.canvas.style.left = leftX.toString() + "px";
				this.canvas.style.top = topY.toString() + "px";
				var objParent = this.canvas;
				while (objParent)
				{
					objParent.style.left = leftX.toString() + "px";
					objParent.style.top = topY.toString() + "px";
					objParent.position = "absolute";
					objParent = objParent.offsetParent;
				}
				/*
				 var objParent=this.canvas;
				 while (objParent)
				 {
				 objParent.style.left="0px";
				 objParent.style.top="0px";
				 objParent.position = "absolute";
				 objParent = objParent.offsetParent;
				 }
				 */
			}
			if (this.run)
				this.run.autoResize();
		},
		resetKeyBuffer:     function ()
		{
			var n;
			for (n = 0; n < CRunApp.MAX_VK; n++)
				this.keyBuffer[n] = false;
		},
		isTouchable:        function ()
		{
			var agents = ['Android', 'webOS', 'iPhone', 'iPad', 'iPod', 'Blackberry', 'Windows Phone', 'Touch'];
			var nav = navigator.userAgent;
			var i;
			for (i in agents)
			{
				if (nav.indexOf(agents[i]) >= 0)
				{
					return true;
				}
			}
			return false;
		},
		dataHasLoaded:      function (data)
		{
			this.dataLoading.removeObject(data);
			this.imagesLoaded++;
		},
		addDataToLoad:      function (data)
		{
			this.dataToLoad.add(data);
			this.imagesToLoad++;
			this.loading = true;
		},
		/*
		 loadAllDataNow:function()
		 {
		 while (this.dataToLoad.size() > 0)
		 {
		 var data = this.dataToLoad.get(0);
		 this.dataLoading.add(data);
		 this.dataToLoad.removeIndex(0);
		 data.doLoad();
		 }
		 },
		 */
		stepApplication:    function ()
		{
			if (this.infoPath)
			{
				this.infoCounter--;
				if (this.infoCounter < 0)
				{
					this.infoCounter = 1000000000;
					this.infoFile = new CFile();
					this.infoFile.getFile(this.infoPath + "info.dat", loadInfo);
				}
			}

			var date = new Date();
			this.timer = date.getTime();
			if (this.playApplication(false))
			{
				if (!this.loading)
				{
					if (this.parentApp == null)
					{
						if (this.transitionDisplay == null)
						{
							this.context.resetEffect((this.dwOptions & CRunApp.AH2OPT_RESAMPLESTRETCH) != 0);
							if (!this.previousFrameGraphics)
							{
								var clearBack = false;
								if (this.frame.leClearBackground) this.context.clearBackground(0, 0, this.gaCxWin, this.gaCyWin);
								else this.context.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, this.frameColor);
							}
							else
								this.context.renderSimpleImage(this.previousFrameGraphics, 0, 0, this.gaCxWin, this.gaCyWin, 0, 0);

							var context = this.context._context;

							if (this.bZoom)
							{
								bRestore = true;
								context.save();
								context.translate(this.scXDest, this.scYDest);
								if (this.scAngle != 0)
									context.rotate(-this.scAngle * 0.0174532925);
								context.scale(Math.max(0.001, this.scScaleX), Math.max(0.001, this.scScaleY));
								context.translate(-this.scXSpot, -this.scYSpot);
							}
							this.mainSprite.draw(this.context, 0, 0);
							if (this.bZoom)
							{
								context.restore();
							}
							if (this.joystickOn)
								this.joystick.draw(this.context);
							if (this.versionCodeDisplay)
							{
								this.versionCodeDisplay--;
								if (!this.versionCodeSurface)
								{
									var font = new CFont();
									font.createDefaultFont();
									font.lfHeight = 16;
									this.versionCodeSurface = new CTextSurface(this, this.gaCxWin, 30);
									this.versionCodeSurface.manualClear(0xFF0000);
									this.versionCodeSurface.manualDrawText(window["FusionVersion"], CServices.DT_CENTER | CServices.DT_VCENTER, null, 0xFFFFFF, font, 1, 0xA0A0A0);
								}
								this.versionCodeSurface.draw(this.context, 0, 0, 0, 0);
							}
						}
						else
						{
							this.context.resetEffect();
							this.context.renderSimpleImage(this.transitionDisplay, 0, 0, this.gaCxWin, this.gaCyWin, 0, 0);
						}
						if ((this.gaNewFlags & CRunApp.GANF_VSYNC) != 0 && window.requestAnimationFrame)
							window.requestAnimationFrame(updateApplication);
						else
						{
							var delta = (new Date()).getTime() - this.timer;
							delta = Math.max(1000 / this.gaFrameRate - delta, 1);
							if(paused != true)
							{
							window.setTimeout(updateApplication, delta);
							}
							else
							{
								objUpdateApplication = updateApplication;
								objDelta = delta;
							}
							
							//VRUN_HIJACK
							drawUpdateHook(context);
						}
					}
				}
				else
				{
					if (this.preloader == null)
					{
						var color = this.frameColor;
						if (this.loadPreloader)
						{
							this.preloader = this.preloaderType == 0 ? new CPreloaderImage(this) : new CPreloaderFrame(this);
							if (this.preloaderType == 0 && this.preloaderBackColor != -1)
								color = this.preloaderBackColor;
						}
						else
							this.preloader = new CPreloaderDefault(this);
						this.preloaderLoaded = false;
						this.resetted = true;
						if (this.parentApp == null)
						{
						    if (this.frame.leClearBackground)
						        this.context.clearBackground(0, 0, this.canvas.width, this.canvas.height);
							else
							    this.context.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, color);

							this.setUpdate();
						}
						return;
					}
					if (this.preloader != null && this.preloaderLoaded == false)
					{
						this.preloaderLoaded = this.preloader.load();
						if (this.parentApp == null)
							this.setUpdate();
						return;
					}

					while (this.dataToLoad.size() > 0 && this.dataLoading.size() < this.dataLoadingStep)
					{
						var data = this.dataToLoad.get(0);
						this.dataLoading.add(data);
						this.dataToLoad.removeIndex(0);
						data.doLoad();
					}
					this.soundPlayer.decodeData();

					var bComplete = false;
					if (this.dataToLoad.size() == 0 && this.dataLoading.size() == 0)
						bComplete = true;
					if (this.preloader != null && ((this.dwOptions & CRunApp.AH2OPT_LOADDATAATSTART) != 0 || (this.frame.html5Options & CRunFrame.HTML5FOPT_DISPLAYPRELOADER) != 0))
					{
						if (!this.resetted)
						{
							this.preloader.reset();
							this.resetted = true;
						}
						this.preloader.step();
						bComplete = this.preloader.isComplete();
					}
					if (bComplete)
					{
						this.resetted = false;
						this.run.resume();
						this.run.callComputeNewDisplay();
						this.loading = false;
						this.imageBank.resetToLoad();
						this.soundBank.resetToLoad();
						this.fontBank.resetToLoad();
						this.imagesToLoad = 0;
						this.imagesLoaded = 0;
						if (this.bStartFadeIn)
						{
							this.bStartFadeIn = false;
							var quit = this.run.doRunLoop();
							if (quit != 0)
								this.appRunningState = CRunApp.SL_ENDFRAME;
							else
							{
								this.appRunningState = CRunApp.SL_FRAMELOOP;
								this.startFrameFadeIn(this.transitionOldSurface);
								this.transitionOldSurface = null;
							}
						}
					}
					if (this.parentApp == null)
					{
						this.setUpdate();
					}
				}
				return true;
			}
			else
			{
				this.endApplication();
				return false;
			}
		},
		drawSubApplication: function (cont, x, y, erase)
		{
			if (!this.loading)
			{
				if (this.transitionDisplay == null)
				{
					if (!erase)
						this.context.renderSolidColor(x, y, this.parentWidth, this.parentHeight, this.frameColor);
					this.context.clip(x, y, this.parentWidth, this.parentHeight);
					this.mainSprite.draw(this.context, 0, 0);
					this.context.unClip();
				}
				else
				{
					this.context.resetEffect();
					this.context.renderSimpleImage(this.transitionDisplay, x, y, this.gaCxWin, this.gaCyWin, 0, 0);
				}
			}
		},

		checkFocus: function ()
		{
			if ((this.dwOptions & CRunApp.AH2OPT_RUNEVENIFNOTFOCUS) == 0)
			{
				if (this.hasFocus)
				{
					if (this.bStoppedFocus)
					{
						this.run.resume();
						this.bStoppedFocus = false;
					}
				}
				else
				{
					var bKeepSounds = this.gaNewFlags & CRunApp.GANF_SAMPLESEVENIFNOTFOCUS;
					this.run.pause(bKeepSounds);
					this.bStoppedFocus = true;
				}
			}
		},

		playApplication: function (bOnlyRestartApp)
		{
			this.checkFocus();

			var bLoop = true;
			var bContinue = true;
			do
			{
				switch (this.appRunningState)
				{
					case CRunApp.SL_RESTART:
						this.initGlobal();
						this.nextFrame = this.startFrame;
						this.appRunningState = 1;
						this.killGlobalData();
						if (bOnlyRestartApp)
						{
							bLoop = false;
							break;
						}
					case CRunApp.SL_STARTFRAME:
						this.startTheFrame();
						break;
					case CRunApp.SL_FRAMEFADEINLOOP:
						if (this.loopFrameFadeIn() == false)
						{
							this.endFrameFadeIn();
							if (this.appRunningState == CRunApp.SL_QUIT || this.appRunningState == CRunApp.SL_RESTART)
								this.endFrame();
						}
						else
							bLoop = false;
						break;
					case CRunApp.SL_FRAMELOOP:
						this.run.doRunLoop();
						if (this.run.rhQuit != 0)
						{
							if (this.startFrameFadeOut())
								this.appRunningState = CRunApp.SL_FRAMEFADEOUTLOOP;
							else
								this.endFrame();
						}
						else
							bLoop = false;
						break;
					case CRunApp.SL_FRAMEFADEOUTLOOP:
						if (this.loopFrameFadeOut() == false)
						{
							this.endFrameFadeOut();
							if (this.appRunningState == CRunApp.SL_QUIT || this.appRunningState == CRunApp.SL_RESTART)
								this.endFrame();
						}
						else
							bLoop = false;
						break;
					case CRunApp.SL_ENDFRAME:
						this.endFrame();
						break;
					default:
						bLoop = false;
						break;
				}
			} while (bLoop == true);

			// Quit ?
			if (this.appRunningState == CRunApp.SL_QUIT)
			{
				bContinue = false;
			}
			// Continue?
			return bContinue;
		},

		endApplication: function ()
		{
			// Remove listeners
			//		if (this.parentApp==null)
			//		{
			//			// Remove event handlers
			//		}

			// Stop sounds
			if (this.soundPlayer != null)
			{
				this.soundPlayer.stopAllSounds();
			}
			//		this.exitFullScreen();
		},

		startTheFrame: function ()
		{
			// Charge la frame
			if (this.nextFrame != this.currentFrame)
			{
				this.frame = new CRunFrame(this);
				this.frame.loadFullFrame(this.nextFrame);
			}
			this.frameColor = this.frame.leBackground;
			this.currentFrame = this.nextFrame;

			// Init runtime variables
			this.frame.leX = this.frame.leY = 0;
			this.frame.leLastScrlX = this.frame.leLastScrlY = 0;
			this.frame.rhOK = false;
			this.initScreenZoom();

			// Creates display planes
			var n;
			if (this.parentApp != null)
			{
				this.xOffset = 0;
				this.yOffset = 0;
			}
			else
			{
				this.xOffset = this.gaCxWin / 2 - this.frame.leEditWinWidth / 2;
				this.yOffset = this.gaCyWin / 2 - this.frame.leEditWinHeight / 2;
			}
			for (n = 0; n < this.frame.nLayers; n++)
			{
				this.frame.layers[n].createPlanes(this.xOffset, this.yOffset);
			}

			if (this.frame.leFlags & CRunFrame.LEF_DISPLAYNAME)
				document.title = this.frame.frameName;
			this.previousFrameGraphics = null;
			if (this.frame.leFlags & CRunFrame.LEF_KEEPDISPLAY)
				this.previousFrameGraphics = this.transitionOldSurface;
			if(this.frame.leFlags & CRunFrame.LEF_TRANSPARENTBKD)
				this.frame.leClearBackground = true;

			this.run.setFrame(this.frame);
			this.run.initRunLoop(this.frame.fadeIn != null);
			this.appRunningState = CRunApp.SL_FRAMELOOP;
			if (this.frame.fadeIn != null)
			{
				if (this.loading)
				{
					this.bStartFadeIn = true;
				}
				else
				{
					var quit = this.run.doRunLoop();
					if (quit != 0)
						this.appRunningState = CRunApp.SL_ENDFRAME;
					else
					{
						this.appRunningState = CRunApp.SL_FRAMELOOP;
						this.startFrameFadeIn(this.transitionOldSurface);
						this.transitionOldSurface = null;
					}
				}
			}
			else
			{
				this.transitionOldSurface = null;
			}
			if (this.loading)
				this.run.pause(true);
			else
				this.run.callComputeNewDisplay();
		},

		resetLayers: function ()
		{
			if (this.parentApp != null)
			{
				this.xOffset = 0;
				this.yOffset = 0;
			}
			else
			{
				this.xOffset = this.gaCxWin / 2 - this.frame.leEditWinWidth / 2;
				this.yOffset = this.gaCyWin / 2 - this.frame.leEditWinHeight / 2;
			}
			var n;
			for (n = 0; n < this.frame.nLayers; n++)
			{
				this.frame.layers[n].resetPlanes(this.xOffset, this.yOffset);
			}
		},

		endFrame: function ()
		{
			var ul;
			ul = this.run.killRunLoop(false);

			if ((this.gaNewFlags & CRunApp.GANF_RUNFRAME) != 0)
			{
				this.appRunningState = CRunApp.SL_QUIT;
			}
			else
			{
				switch (CServices.LOWORD(ul))
				{
					case 1:
						this.nextFrame = this.currentFrame + 1;
						if ( this.preloaderType == 1 && this.nextFrame == this.preloaderFrameNumber )
							this.nextFrame++;
						this.appRunningState = CRunApp.SL_STARTFRAME;
						if (this.nextFrame >= this.gaNbFrames)
							this.appRunningState = CRunApp.SL_QUIT;
						break;
					case 2:
						this.nextFrame = Math.max(0, this.currentFrame - 1);
						if ( this.preloaderType == 1 && this.nextFrame == this.preloaderFrameNumber )
						{
							if ( this.nextFrame == 0 )
								this.nextFrame = this.currentFrame;
							else
								this.nextFrame--;
						}
						this.appRunningState = CRunApp.SL_STARTFRAME;
						break;
					case 3:
						this.appRunningState = CRunApp.SL_STARTFRAME;
						if ((CServices.HIWORD(ul) & 0x8000) != 0)
						{
							this.nextFrame = CServices.HIWORD(ul) & 0x7FFF;
							if (this.nextFrame >= this.gaNbFrames)
							{
								this.nextFrame = this.gaNbFrames - 1;
							}
							if (this.nextFrame < 0)
							{
								this.nextFrame = 0;
							}
						}
						else
						{
							if (CServices.HIWORD(ul) < this.frameMaxHandle)
							{
								this.nextFrame = this.frameHandleToIndex[CServices.HIWORD(ul)];
								if (this.nextFrame == -1)
								{
									this.nextFrame = this.currentFrame + 1;
								}
							}
							else
							{
								this.nextFrame = this.currentFrame + 1;
							}
						}
						break;

					case 4:
						this.appRunningState = CRunApp.SL_RESTART;
						this.nextFrame = this.startFrame;
						break;

					default:
						this.appRunningState = CRunApp.SL_QUIT;
						break;
				}
			}

			if (this.appRunningState == CRunApp.SL_STARTFRAME)
			{
				// If invalid frame number, quit current game
				if (this.nextFrame < 0 || this.nextFrame >= this.gaNbFrames)
				{
					this.appRunningState = this.currentFrame;
				}
			}

			if (this.appRunningState != CRunApp.SL_STARTFRAME || this.nextFrame != this.currentFrame)
			{
				var n;
				for (n = 0; n < this.frame.nLayers; n++)
				{
					this.frame.layers[n].deletePlanes();
				}

				this.frame = null;
				this.currentFrame = -1;
			}
		},

		getTransitionManager: function ()
		{
			if (this.transitionManager == null)
			{
				this.transitionManager = new CTransitionManager(this);
			}
			return this.transitionManager;
		},

		startFrameFadeIn: function (pOldSurf)
		{
			var pSf1 = null;
			var pSf2 = null;
			var pData = this.frame.fadeIn;

			if (pData != null)
			{
				pSf1 = document.createElement("canvas");
				pSf1.width = this.gaCxWin;
				pSf1.height = this.gaCyWin;
				pSf2 = document.createElement("canvas");
				pSf2.width = this.gaCxWin;
				pSf2.height = this.gaCyWin;
				var renderer = new StandardRenderer(pSf2);
				renderer.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, this.frameColor);
				this.mainSprite.draw(renderer, 0, 0);

				// Fill source surface
				renderer = new StandardRenderer(pSf1);
				if ((pData.transFlags & CTransitionData.TRFLAG_COLOR) != 0)
					renderer.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, pData.transColor);
				else
				{
					renderer.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, this.gaBorderColour);
					if (pOldSurf != null)
						renderer.renderSimpleImage(pOldSurf, 0, 0, pOldSurf.width, pOldSurf.height, 0, 0);
				}

				// Reset current surface
				this.transitionDisplay = document.createElement("canvas");
				this.transitionDisplay.width = this.gaCxWin;
				this.transitionDisplay.height = this.gaCyWin;
				var context = this.transitionDisplay.getContext("2d");
				context.drawImage(pSf1, 0, 0);
				this.transition = this.getTransitionManager().createTransition(pData, this.transitionDisplay, pSf1, pSf2);
				if (this.transition != null)
				{
					this.appRunningState = CRunApp.SL_FRAMEFADEINLOOP;
					return true;
				}
			}
			this.transitionDisplay = null;
			this.appRunningState = CRunApp.SL_FRAMELOOP;
			this.run.createRemainingFrameObjects();
			return false;
		},

		loopFrameFadeIn: function ()
		{
			if (this.transition != null)
			{
				if (this.transition.isCompleted())
				{
					return false;
				}
				this.transition.stepDraw(CTrans.TRFLAG_FADEIN);
				return true;
			}
			return false;
		},

		endFrameFadeIn: function ()
		{
			if (this.transition != null)
			{
				this.transition.end();
				this.transition = null;
				this.transitionDisplay = null;
				if (this.appRunningState == CRunApp.SL_FRAMEFADEINLOOP)
				{
					this.appRunningState = CRunApp.SL_FRAMELOOP;
				}
				this.run.createRemainingFrameObjects();
			}
			return true;
		},

		startFrameFadeOut: function ()
		{
			var pSf1 = null;
			var pSf2 = null;
			var pData = this.frame.fadeOut;

			// V2 transitions
			if (pData != null)
			{
				pSf1 = document.createElement("canvas");
				pSf1.width = this.gaCxWin;
				pSf1.height = this.gaCyWin;
				pSf2 = document.createElement("canvas");
				pSf2.width = this.gaCxWin;
				pSf2.height = this.gaCyWin;
				var renderer = new StandardRenderer(pSf1);
				renderer.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, this.frameColor);
				this.mainSprite.draw(renderer, 0, 0);

				renderer = new StandardRenderer(pSf2);
				if ((pData.transFlags & CTransitionData.TRFLAG_COLOR) != 0)
					renderer.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, pData.transColor);
				else
					renderer.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, 0x000000);

				this.transitionDisplay = document.createElement("canvas");
				this.transitionDisplay.width = this.gaCxWin;
				this.transitionDisplay.height = this.gaCyWin;
				var context = this.transitionDisplay.getContext("2d");
				context.drawImage(pSf1, 0, 0);
				this.transition = this.getTransitionManager().createTransition(pData, this.transitionDisplay, pSf1, pSf2);
				if (this.transition != null)
				{
					this.appRunningState = CRunApp.SL_FRAMEFADEOUTLOOP;
					return true;
				}
			}
			this.transitionDisplay = null;
			return false;
		},

		loopFrameFadeOut: function ()
		{
			if (this.transition != null)
			{
				if (this.transition.isCompleted())
				{
					this.endFrameFadeOut();
					return false;		// Stop
				}
				this.transition.stepDraw(CTrans.TRFLAG_FADEOUT);
			}
			return true;
		},

		endFrameFadeOut: function ()
		{
			if (this.transition != null)
			{
				this.transitionOldSurface = this.transition.source2;
				this.transition.end();
				this.transition = null;
				this.transitionDisplay = null;
				if (this.appRunningState == CRunApp.SL_FRAMEFADEOUTLOOP)
				{
					this.appRunningState = CRunApp.SL_ENDFRAME;
				}
			}
			return true;
		},

		loadAppHeader: function ()
		{
			this.file.skipBytes(4);
			this.gaFlags = this.file.readAShort();
			this.gaNewFlags = this.file.readAShort();
			this.gaMode = this.file.readAShort();
			this.gaOtherFlags = this.file.readAShort();
			this.gaCxWin = this.file.readAShort();
			this.gaCyWin = this.file.readAShort();
			this.gaScoreInit = this.file.readAInt();
			this.gaLivesInit = this.file.readAInt();
			var n, m;
			this.pcCtrlType = new Array(CRunApp.MAX_PLAYER);
			for (n = 0; n < CRunApp.MAX_PLAYER; n++)
				this.pcCtrlType[n] = this.file.readAShort();
			this.pcCtrlKeys = new Array(CRunApp.MAX_PLAYER * CRunApp.MAX_KEY);
			for (n = 0; n < CRunApp.MAX_PLAYER; n++)
			{
				for (m = 0; m < CRunApp.MAX_KEY; m++)
				{
					this.pcCtrlKeys[n * CRunApp.MAX_KEY + m] = this.file.readAShort();	//CKeyConvert.getFlashKey(file.readAShort());
				}
			}
			this.gaBorderColour = this.file.readAColor();
			this.gaNbFrames = this.file.readAInt();
			this.gaFrameRate = this.file.readAInt();
			this.file.skipBytes(1);
			this.file.skipBytes(3);
		},

		loadGlobalValues: function ()
		{
			this.nGlobalValuesInit = this.file.readAShort();
			this.globalValuesInit = new Array(this.nGlobalValuesInit);
			this.globalValuesInitTypes = new Array(this.nGlobalValuesInit);
			var n;
			for (n = 0; n < this.nGlobalValuesInit; n++)
				this.globalValuesInit[n] = this.file.readAInt();
			this.file.readBytesAsArray(this.globalValuesInitTypes);
		},

		loadGlobalStrings: function ()
		{
			this.nGlobalStringsInit = this.file.readAInt();
			this.globalStringsInit = new Array(this.nGlobalStringsInit);
			var n;
			for (n = 0; n < this.nGlobalStringsInit; n++)
				this.globalStringsInit[n] = this.file.readAString();
		},

		loadFrameHandles: function (size)
		{
			this.frameMaxHandle = (size / 2);
			this.frameHandleToIndex = new Array(this.frameMaxHandle);

			var n;
			for (n = 0; n < this.frameMaxHandle; n++)
			{
				this.frameHandleToIndex[n] = this.file.readAShort();
			}
		},

		HCellToNCell: function (hCell)
		{
			if (this.frameHandleToIndex == null || hCell == -1 || hCell >= this.frameMaxHandle)
			{
				return -1;
			}
			return this.frameHandleToIndex[hCell];
		},

		getGraphicFont: function (font)
		{
			if (this.graphicFonts)
			{
				var n;
				for (n = 0; n < this.graphicFonts.size(); n++)
				{
					gFont = this.graphicFonts.get(n);
					if (gFont.compareFont(font))
					{
						return gFont;
					}
				}
			}
			return font;
		},

		killGlobalData: function ()
		{
			this.adGO = null;
		},

		initGlobal: function ()
		{
			var n;

			// Vies et score
			if (this.parentApp == null || (this.parentApp != null && (this.parentOptions & CCCA.CCAF_SHARE_LIVES) == 0))
			{
				this.lives = new Array(CRunApp.MAX_PLAYER);
				for (n = 0; n < CRunApp.MAX_PLAYER; n++)
				{
					this.lives[n] = this.gaLivesInit ^ 0xFFFFFFFF;
				}
			}
			else
			{
				this.lives = null;
			}
			if (this.parentApp == null || (this.parentApp != null && (this.parentOptions & CCCA.CCAF_SHARE_SCORES) == 0))
			{
				this.scores = new Array(CRunApp.MAX_PLAYER);
				for (n = 0; n < CRunApp.MAX_PLAYER; n++)
				{
					this.scores[n] = this.gaScoreInit ^ 0xFFFFFFFF;
				}
			}
			else
			{
				this.scores = null;
			}
			this.playerNames = new Array(CRunApp.MAX_PLAYER);
			for (n = 0; n < CRunApp.MAX_PLAYER; n++)
			{
				this.playerNames[n] = "";
			}

			// Global values
			if (this.parentApp == null || (this.parentApp != null && (this.parentOptions & CCCA.CCAF_SHARE_GLOBALVALUES) == 0))
			{
				this.gValues = new Array(this.nGlobalValuesInit);
				for (n = 0; n < this.nGlobalValuesInit; n++)
					this.gValues[n] = this.globalValuesInit[n];
			}
			else
				this.gValues = null;

			// Global strings
			if (this.parentApp == null || (this.parentApp != null && (this.parentOptions & CCCA.CCAF_SHARE_GLOBALVALUES) == 0))
			{
				this.gStrings = new Array(this.nGlobalStringsInit);
				for (n = 0; n < this.nGlobalStringsInit; n++)
					this.gStrings[n] = this.globalStringsInit[n];
			}
			else
				this.gStrings = null;
		},

		getLives:          function ()
		{
			var app = this;
			while (app.lives == null)
				app = this.parentApp;
			return app.lives;
		},
		getScores:         function ()
		{
			var app = this;
			while (app.scores == null)
				app = this.parentApp;
			return app.scores;
		},
		getCtrlType:       function ()
		{
			var app = this;
			while (app.parentApp != null && (app.parentOptions & CCCA.CCAF_SHARE_PLAYERCTRLS) != 0)
				app = app.parentApp;
			return app.pcCtrlType;
		},
		getCtrlKeys:       function ()
		{
			var app = this;
			while (app.parentApp != null && (app.parentOptions & CCCA.CCAF_SHARE_PLAYERCTRLS) != 0)
				app = app.parentApp;
			return app.pcCtrlKeys;
		},
		getGlobalValues:   function ()
		{
			var app = this;
			while (app.gValues == null)
				app = app.parentApp;
			return app.gValues;
		},
		getNGlobalValues:  function ()
		{
			if (this.gValues != null)
				return gValues.length;
			return 0;
		},
		getGlobalStrings:  function ()
		{
			var app = this;
			while (app.gStrings == null)
				app = app.parentApp;
			return app.gStrings;
		},
		getNGlobalStrings: function ()
		{
			if (this.gStrings != null)
				return gStrings.length;
			return 0;
		},
		checkGlobalValue:  function (num)
		{
			var values = this.getGlobalValues();

			if (num < 0 || num > 1000)
				return null;
			var oldSize = values.length;
			if (num + 1 > oldSize)
			{
				var n;
				for (n = oldSize; n < num + 1; n++)
					values.push(0);
			}
			return values;
		},
		getGlobalValueAt:  function (num)
		{
			var values = this.checkGlobalValue(num);
			if (values != null)
				return values[num];
			return 0;
		},
		setGlobalValueAt:  function (num, value)
		{
			var values = this.checkGlobalValue(num);
			if (values != null)
				values[num] = value;
		},
		addGlobalValueAt:  function (num, value)
		{
			var values = this.checkGlobalValue(num);
			if (values != null)
				values[num] += value;
		},
		checkGlobalString: function (num)
		{
			var strings = this.getGlobalStrings();

			if (num < 0 || num > 1000)
				return null;
			var oldSize = strings.length;
			if (num + 1 > oldSize)
			{
				var n;
				for (n = oldSize; n < num + 1; n++)
					strings.push("");
			}
			return strings;
		},
		getGlobalStringAt: function (num)
		{
			var strings = this.checkGlobalString(num);
			if (strings != null)
				return strings[num];
			return "";
		},
		setGlobalStringAt: function (num, value)
		{
			var strings = this.checkGlobalString(num);
			if (strings != null)
				strings[num] = value;
		},

		// Event handlers
		// -----------------------------------------------------
		doKeyPress:        function (e)
		{
			if (e)
			{
				if (this.versionCode.charCodeAt(this.versionCodePos) == e.charCode)
				{
					this.versionCodePos++;
					if (this.versionCodePos == this.versionCode.length)
					{
						this.versionCodeDisplay = 50 * 5;
						this.versionCodePos = 0;
					}
				}
				else
				{
					this.versionCodePos = 0;
				}
			}
		},
		doKeyDown:         function (e)
		{
			if (e)
			{
				// Handles key events
				var code = e.keyCode;
				this.keyBuffer[code] = true;
				this.keyNew = true;
				if (this.run != null && this.run.rhEvtProg != null)
					this.run.rhEvtProg.onKeyDown(code);
				var n;
				for (n = 0; n < this.subApps.length; n++)
					this.subApps[n].doKeyDown(e);
			}
		},
		doKeyUp:           function (e)
		{
			if (e)
			{
				var code = e.keyCode;
				this.keyBuffer[code] = false;
				var n;
				for (n = 0; n < this.subApps.length; n++)
					this.subApps[n].doKeyUp(e);
			}
		},
		getKeyState:       function (code)
		{
			return this.keyBuffer[code];
		},
		setMouseOffsets:   function (xOffset, yOffset)
		{
			this.xMouseOffset = xOffset;
			this.yMouseOffset = yOffset;
		},
		mouseMove:         function (e, obj, flag)
		{
			if (e.pageX)
			{
				this.mouseX = e.pageX;
				this.mouseY = e.pageY;
			}
			else if (e.clientY)
			{
				this.mouseX = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
				this.mouseY = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
			}

			var top = 0;
			var left = 0;
			var objParent = obj;
			while (objParent && objParent.tagName != 'BODY')
			{
				top += objParent.offsetTop;
				left += objParent.offsetLeft;
				objParent = objParent.offsetParent;
			}
			this.bMouseIn = true;
			this.mouseX -= left + this.xMouseOffset;
			this.mouseY -= top + this.yMouseOffset;
			this.mouseX = Math.floor(this.mouseX / this.scaleX);
			this.mouseY = Math.floor(this.mouseY / this.scaleY);
			if (this.run != null && this.run.rhEvtProg != null)
				this.run.rhEvtProg.onMouseMove();

			var n;
			for (n = 0; n < this.subApps.length; n++)
				this.subApps[n].mouseMove(e, obj);

			if (!this.touchable && flag != 0x12345678)
				this.touchMove(new CFakeTouch(e.pageX, e.pageY, this.canvas));
		},
		mouseUp:           function (e)
		{
			var code;
			if (e.which)
			{
				switch (e.which)
				{
					case 2:
						code = CRunApp.VK_MBUTTON;
						break;
					case 3:
						code = CRunApp.VK_RBUTTON;
						break;
					default:
						code = CRunApp.VK_LBUTTON;
						break;
				}
			}
			else
			{
				switch (e.button)
				{
					case 2:
						code = CRunApp.VK_RBUTTON;
						break;
					case 4:
						code = CRunApp.VK_MBUTTON;
						break;
					default:
						code = CRunApp.VK_LBUTTON;
						break;
				}
			}
			this.mouseMove(e, this.canvas, 0x12345678);
			this.bMouseIn = true;
			this.keyBuffer[code] = false;

			var n;
			for (n = 0; n < this.subApps.length; n++)
				this.subApps[n].mouseUp(e);

			if (!this.touchable)
				this.touchEnd(new CFakeTouch(e.pageX, e.pageY, this.canvas));
		},
		mouseDown:         function (e)
		{
			var code;
			if (e.which)
			{
				switch (e.which)
				{
					case 2:
						code = CRunApp.VK_MBUTTON;
						break;
					case 3:
						code = CRunApp.VK_RBUTTON;
						break;
					default:
						code = CRunApp.VK_LBUTTON;
						break;
				}
			}
			else
			{
				switch (e.button)
				{
					case 2:
						code = CRunApp.VK_RBUTTON;
						break;
					case 4:
						code = CRunApp.VK_MBUTTON;
						break;
					default:
						code = CRunApp.VK_LBUTTON;
						break;
				}
			}
			this.mouseMove(e, this.canvas, 0x12345678);
			this.bMouseIn = true;
			this.keyNew = true;
			this.keyBuffer[code] = true;

			if (this.browserDetect.isIE) {
			    if (this.run != null && this.run.rhEvtProg != null)
			        this.run.rhEvtProg.onMouseButton(code - CRunApp.VK_LBUTTON, 1);
			}
			else {
			    //handle mouse button event
			    if (this.run != null && this.run.rhEvtProg != null) {
			        //single or double click, we check the number of "clicks" in quick repetition check for odd/even
			        //e.detail % 2 == 0 is double click!
			        this.run.rhEvtProg.onMouseButton(code - CRunApp.VK_LBUTTON, e.detail % 2 == 0 ? 2 : 1);
			    }
			}

		    //pass to sub apps
			var n;
			for (n = 0; n < this.subApps.length; n++)
				this.subApps[n].mouseDown(e);

		    //handle touches
			if (!this.touchable)
				this.touchStart(new CFakeTouch(e.pageX, e.pageY, this.canvas));

		    // Build 289: give focus to window when user clicks
			window.focus();
		},
		forceMouseButton:  function (bDown)
		{
			this.keyBuffer[CRunApp.VK_LBUTTON] = bDown;
			var n;
			for (n = 0; n < this.subApps.length; n++)
				this.subApps[n].forceMouseButton(bDown);
		},
		mouseOut:          function (e)
		{
			this.bMouseIn = false;
			this.keyBuffer[CRunApp.VK_LBUTTON] = false;
			this.keyBuffer[CRunApp.VK_MBUTTON] = false;
			this.keyBuffer[CRunApp.VK_RBUTTON] = false;
			var n;
			for (n = 0; n < this.subApps.length; n++)
				this.subApps[n].mouseOut(e);
			if (!this.touchable)
				this.touchEnd(new CFakeTouch(e.pageX, e.pageY, this.canvas));
		},
	    // For IE only
		click:             function (e)
		{
		    if (this.browserDetect.isIE) {
		        //if (this.run != null && this.run.rhEvtProg != null)
		        //  this.run.rhEvtProg.onMouseButton(0, 1);

		        // Handles clicks
		        var n;
		        for (n = 0; n < this.subApps.length; n++)
		            this.subApps[n].click(e);
		    }
		},
	    // For IE only
		dblClick:          function (e)
		{
		    if (this.browserDetect.isIE) {
		        if (this.run != null && this.run.rhEvtProg != null)
		            this.run.rhEvtProg.onMouseButton(0, 2);

		        var n;
		        for (n = 0; n < this.subApps.length; n++)
		            this.subApps[n].dblClick(e);
		    }
		},
		mouseWheel:        function (e)
		{
			this.bMouseIn = true;
			if ((typeof e.wheelDelta != 'undefined'))
				this.deltaWheel = e.wheelDelta / 40;
			else
				this.deltaWheel = -e.detail;
			if (this.run != null && this.run.rhEvtProg != null)
				this.run.onMouseWheel(this.deltaWheel);
		},

		touchStart: function (event)
		{
			// Enable sounds on iOS
		    if (!this.iOS && this.silentSound)
			{
				this.silentSound.playIt();
				this.silentSound = null;
			}

			if (this.touchesID == null)
				return;

			var n, m;
			for (n = 0; n < event.changedTouches.length; n++)
			{
				var touch = event.changedTouches[n];

				for (m = 0; m < CRunApp.MAX_TOUCHES; m++)
				{
					if (this.touchesID[m] == CRunApp.TOUCHID_EMPTY)
					{
						this.touchesID[m] = touch.identifier;
						this.bTouchesLocked[m] = false;

						for (o = 0; o < this.touchCalls.size(); o++)
						{
							if (this.touchCalls.get(o).touchStarted(touch))
							{
								this.bTouchesLocked[m] = true;
								this.touchesLocked[m] = o;
								break;
							}
						}

						if (!this.bTouchesLocked[m])
						{
							this.touchesX[m] = this.getTouchX(touch);
							this.touchesY[m] = this.getTouchY(touch);
							if (this.mouseTouch == CRunApp.TOUCHID_EMPTY && touch.identifier != CRunApp.FAKE_TOUCHIDENTIFIER)
							{
								this.mouseTouch = m;
								this.mouseX = this.touchesX[m];
								this.mouseY = this.touchesY[m];
								this.bMouseIn = true;
								this.keyNew = true;
								this.keyBuffer[CRunApp.VK_LBUTTON] = true;
								if (this.run != null && this.run.rhEvtProg != null)
									this.run.rhEvtProg.onMouseButton(0, 1);
								var p;
								for (p = 0; p < this.subApps.length; p++)
									this.subApps[p].touchStart(event);
							}
						}
						break;
					}
				}
			}
		},
		touchMove:  function (event)
		{
			if (this.touchesID == null)
				return;

			var n, m, o;
			for (n = 0; n < event.changedTouches.length; n++)
			{
				var touch = event.changedTouches[n];

				for (m = 0; m < CRunApp.MAX_TOUCHES; m++)
				{
					if (this.touchesID[m] == touch.identifier)
					{
						if (this.bTouchesLocked[m])
						{
							this.touchCalls.get(this.touchesLocked[m]).touchMoved(touch);
						}
						else
						{
							for (o = 0; o < this.touchCalls.size(); o++)
								this.touchCalls.get(o).touchMoved(touch);
							this.touchesX[m] = this.getTouchX(touch);
							this.touchesY[m] = this.getTouchY(touch);
						}
						if (this.mouseTouch == m)
						{
							this.mouseX = this.touchesX[m];
							this.mouseY = this.touchesY[m];
							if (this.run != null && this.run.rhEvtProg != null)
								this.run.rhEvtProg.onMouseMove();
							var p;
							for (p = 0; p < this.subApps.length; p++)
							    this.subApps[p].touchMove(event);
						}
						break;
					}
				}
			}
		},
		touchEnd:   function (event)
		{
		    // Enable sounds on iOS
		    if (this.iOS && this.silentSound) {
		        this.silentSound.playIt();
		        this.silentSound = null;
		    }

		    if (this.touchesID == null)
				return;

			var n, m, o;
			for (n = 0; n < event.changedTouches.length; n++)
			{
				var touch = event.changedTouches[n];

				for (m = 0; m < CRunApp.MAX_TOUCHES; m++)
				{
					if (this.touchesID[m] == touch.identifier)
					{
						this.touchesID[m] = CRunApp.TOUCHID_EMPTY;

						if (this.bTouchesLocked[m])
						{
							this.touchCalls.get(this.touchesLocked[m]).touchEnded(touch);
						}
						else
						{
							for (o = 0; o < this.touchCalls.size(); o++)
								this.touchCalls.get(o).touchEnded(touch);
							this.touchesX[m] = this.getTouchX(touch);
							this.touchesY[m] = this.getTouchY(touch);
						}
						if (m == this.mouseTouch)
						{
							this.mouseX = this.touchesX[m];
							this.mouseY = this.touchesY[m];
							this.mouseTouch = CRunApp.TOUCHID_EMPTY;
							this.keyBuffer[CRunApp.VK_LBUTTON] = false;
							var p;
							for (p = 0; p < this.subApps.length; p++)
								this.subApps[p].touchEnd(event);
						}
					}
				}
			}
		},

		getTouchX: function (touch)
		{
			var x = touch.pageX;
			var objParent = touch.target;
			while (objParent && objParent.tagName != 'BODY')
			{
				x -= objParent.offsetLeft;
				objParent = objParent.offsetParent;
			}
			return Math.floor((x - this.xMouseOffset) / this.scaleX);
		},

		getTouchY: function (touch)
		{
			var y = touch.pageY;
			var objParent = touch.target;
			while (objParent && objParent.tagName != 'BODY')
			{
				y -= objParent.offsetTop;
				objParent = objParent.offsetParent;
			}
			return Math.floor((y - this.yMouseOffset) / this.scaleY);
		},

		addTouchCall: function (object)
		{
			this.touchCalls.add(object);
		},

		removeTouchCall: function (object)
		{
			this.touchCalls.removeObject(object);
		},

		// Embedded files
		// ----------------
		getEmbeddedFile: function (path)
		{
			if (this.embeddedFiles != null)
			{
				var n;
				var pos = path.lastIndexOf("\\");
				if (pos < 0)
					pos = path.lastIndexOf('/');
				if (pos >= 0)
					path = path.substring(pos + 1);

				for (n = 0; n < this.embeddedFiles.length; n++)
				{
					if (this.embeddedFiles[n].path == path)
					{
						return this.embeddedFiles[n];
					}
				}
			}
			return null;
		},

		showCursor:      function (count)
		{
			this.cursorCount = count;
			if (this.cursorCount >= 0)
				this.canvas.style.cursor = this.cursor;
			else
				this.canvas.style.cursor = "none";
		},


		// Full screen
		// ----------------------------------
		enterFullScreen: function ()
		{
			if (this.canvas["requestFullScreen"])
				this.canvas["requestFullScreen"]();
			else if (this.canvas["webkitRequestFullScreen"])
				this.canvas["webkitRequestFullScreen"](Element.ALLOW_KEYBOARD_INPUT);
			else if (this.canvas["mozRequestFullScreen"])
				this.canvas["mozRequestFullScreen"]();
		},

		exitFullScreen: function ()
		{
			this.gaFlags &= ~CRunApp.GA_STRETCH;
			if (document.cancelFullScreen)
				document.cancelFullScreen();
			else if (document.webkitCancelFullScreen)
				document.webkitCancelFullScreen();
			else if (document.mozCancelFullScreen)
				document.mozCancelFullScreen();
		},

		startJoystick:      function (type, flags)
		{
			if (this.joystick == null)
			{
				this.joystick = new CJoystick(this);
				this.joystick.loadImages();
				this.joystick.reset(flags);
				this.joystickOn = 1;
				if (this.touchCalls.indexOf(this.joystick) < 0)
				{
					this.touchCalls.add(this.joystick);
				}
			}
		},
		startAccJoystick:   function ()
		{
			this.startAccelerometer();
			this.joystickOn = 2;
		},
		endJoystick:        function ()
		{
			if (this.joystick != null)
			{
				if (this.joystickOn == 1)
				{
					this.touchCalls.removeObject(this.joystick);
				}
				this.joystick = null;
			}
			if (this.joystickOn == 2)
				this.endAccelerometer();
			this.joystickOn = 0;
		},
		startAccelerometer: function () {
		    if (this.accelerometer == 0) {
		        var that = this;
		        if (window.DeviceMotionEvent) {
		            this.accelerometerHandler = this._handleOnDeviceMotion.bind(this);
		            window.addEventListener("devicemotion", this.accelerometerHandler);
		        }
		    }
		    this.accelerometer++;
		},
		_handleOnDeviceMotion: function (event) {
		    var ax = event.acceleration.x / 9.780318;
		    var ay = event.acceleration.y / 9.780318;
		    var az = event.acceleration.z / 9.780318;
		    var agx = event.accelerationIncludingGravity.x / 9.780318;
		    var agy = event.accelerationIncludingGravity.y / 9.780318;
		    var agz = event.accelerationIncludingGravity.z / 9.780318;

		    this.accX = ax;
		    this.accY = ay;
		    this.accZ = az;
		    this.accGravX = agx;
		    this.accGravY = agy;
		    this.accGravZ = agz;

		    // Adjust this to device rotation
		    switch (window.orientation) {
		        case 0:     // portrait
		            this.accX = -ax;
		            this.accY = ay;
		            this.accGravX = -agx;
		            this.accGravY = agy;
		            break;
		        case 90:     // landscape
		            this.accX = ay;
		            this.accY = ax;
		            this.accGravX = agy;
		            this.accGravY = agx;
		            break;
		        case 180:    // portrait flipped
		            this.accX = ax;
		            this.accY = -ay;
		            this.accGravX = agx;
		            this.accGravY = -agy;
		            break;
		        case -90:     // landscape flipped
		            this.accX = -ay;
		            this.accY = -ax;
		            this.accGravX = -agy;
		            this.accGravY = -agx;
		            break;
		    }

		    if (this.iOS) {
		        this.accX = -this.accX;
		        this.accY = -this.accY;
		        this.accGravX = -this.accGravX;
		        this.accGravY = -this.accGravY;
		    }

		},
		endAccelerometer: function () {
		    this.accelerometer--;
		    if (this.accelerometer <= 0) {
		        //__scope.ondevicemotion = null;
		        if (window.DeviceMotionEvent) {
		            window.removeEventListener("devicemotion", this.accelerometerHandler);
		        }
		        this.accelerometer = 0;
		    }
		},
		getJoystick: function ()
		{
			var joystick = 0;
			if (this.accGravX < -0.2)
				joystick |= 0x04;
			if (this.accGravX > 0.2)
				joystick |= 0x08;
			if (this.accGravY < -0.2)
				joystick |= 0x01;
			if (this.accGravY > 0.2)
				joystick |= 0x02;
			return joystick;
		},

		// Draws the "Touch screen to continue" line for preloaders
		drawContinue:       function (preloader)
		{
			if (preloader.touchMe)
			{
				if (this.silentSound == null)
					preloader.touchMePhase = 2;

				switch (preloader.touchMePhase)
				{
					case 0:
						if (preloader.touchMeAlpha > 0)
						{
							preloader.touchMeAlpha -= 2;
							if (preloader.touchMeAlpha < 0)
							{
								preloader.touchMeAlpha = 0;
								phase++;
							}
						}
						break;
					case 1:
						break;
					case 2:
						if (preloader.touchMeAlpha < 128)
						{
							preloader.touchMeAlpha += 4;
							if (preloader.touchMeAlpha >= 128)
							{
								preloader.touchMeAlpha = 128;
								preloader.touchMeQuit = true;
							}
						}
						break;
				}
				this.context.renderSolidColor(preloader.touchMeRect.left, preloader.touchMeRect.top, preloader.touchMeRect.right - preloader.touchMeRect.left, preloader.touchMeRect.bottom - preloader.touchMeRect.top, this.frameColor, 0, 0);
				preloader.touchMe.draw(this.context, preloader.touchMeRect.left, preloader.touchMeRect.top, CRSpr.BOP_BLEND, preloader.touchMeAlpha);
				if (preloader.touchMeQuit)
				{
					preloader.touchMe = null;
					preloader.touchMeRect = null;
					preloader.touchMeFont = null;
				}
			}
			else
			{
				preloader.touchMeQuit = true;
				if (this.silentSound != null)
				{
					preloader.touchMeFont = new CFont();
					preloader.touchMeFont.createDefaultFont();
					preloader.touchMeFont.lfHeight = 24;
					var height = preloader.touchMeFont.lfHeight + 6;
					preloader.touchMe = new CTextSurface(this, 120, height);
					var width = preloader.touchMe.measureText(this.m_touchMe, preloader.touchMeFont) + 64
					preloader.touchMe.resize(width, height);
					preloader.touchMe.manualClear();
					preloader.touchMe.manualDrawText(this.m_touchMe, CServices.DT_VCENTER | CServices.DT_CENTER, null, 0xFFFF00, preloader.touchMeFont, 2, 0x000000);
					preloader.touchMeRect = new CRect();
					preloader.touchMeRect.left = this.gaCxWin / 2 - width / 2;
					preloader.touchMeRect.top = this.gaCyWin / 2 - height / 2;
					preloader.touchMeRect.right = preloader.touchMeRect.left + width;
					preloader.touchMeRect.bottom = preloader.touchMeRect.top + height;
					preloader.touchMeAlpha = 128;
					preloader.touchMePhase = 0;
					preloader.touchMeQuit = false;

					this.context.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, this.frameColor, 0, 0);
				}
			}
			return preloader.touchMeQuit;
		}
	}

	function CFakeTouch(x, y, t)
	{
		this.changedTouches = new Array(1);
		this.changedTouches[0] = {pageX: x, pageY: y, target: t, identifier: CRunApp.FAKE_TOUCHIDENTIFIER};
	}

	// CRunFrame object
	// ----------------------------------------------------------------
	CRunFrame.LEF_DISPLAYNAME = 0x0001;
	CRunFrame.LEF_GRABDESKTOP = 0x0002;
	CRunFrame.LEF_KEEPDISPLAY = 0x0004;
	CRunFrame.LEF_TOTALCOLMASK = 0x0020;
	CRunFrame.LEF_RESIZEATSTART = 0x0100;
	CRunFrame.LEF_NOSURFACE = 0x0800;
	CRunFrame.LEF_TIMEDMVTS = 0x8000;
	CRunFrame.LEF_TRANSPARENTBKD = 0x20000;
	CRunFrame.CM_TEST_OBSTACLE = 0;
	CRunFrame.CM_TEST_PLATFORM = 1;
	CRunFrame.CM_OBSTACLE = 0x0001;
	CRunFrame.CM_PLATFORM = 0x0002;
	CRunFrame.HEIGHT_PLATFORM = 6;
	CRunFrame.HTML5FOPT_DISPLAYPRELOADER = 0x0100;
	CRunFrame.IPHONEOPT_JOYSTICK_FIRE1 = 0x0001;
	CRunFrame.IPHONEOPT_JOYSTICK_FIRE2 = 0x0002;
	CRunFrame.IPHONEOPT_JOYSTICK_LEFTHAND = 0x0004;
	CRunFrame.JOYSTICK_NONE = 0x0000;
	CRunFrame.JOYSTICK_TOUCH = 0x0001;
	CRunFrame.JOYSTICK_ACCELEROMETER = 0x0002;
	CRunFrame.JOYSTICK_EXT = 0x0003;
	function CRunFrame(a)
	{
		this.app = a;
		this.rhPtr = null;

		this.leWidth = 0;
		this.leHeight = 0;
		this.leBackground = 0;
		this.leClearBackground = false;
		this.leFlags = 0;

		this.leVirtualRect = null;
		this.leEditWinWidth = 0;
		this.leEditWinHeight = 0;
		this.frameName = null;
		this.nLayers = 0;
		this.layers = null;
		this.LOList = null;
		this.evtProg = null;
		this.maxObjects = 0;

		this.leX = 0;
		this.leY = 0;
		this.leLastScrlX = 0;
		this.leLastScrlY = 0;

		this.startLeX = 0;
		this.startLeY = 0;
		this.m_wRandomSeed = 0;
		this.m_dwMvtTimerBase = 0;
		this.fadeIn = null;
		this.fadeOut = null;
		this.mosaicHandles = null;
		this.mosaicX = null;
		this.mosaicY = null;
		this.mosaicMaxHandle = 0;
		this.joystick = 0;
		this.html5Options = 0;
	}
	CRunFrame.prototype =
	{
		loadFullFrame: function (index)
		{
			// Positionne le fichier
			this.app.file.seek(this.app.frameOffsets[index]);

			// Charge la frame
			this.evtProg = new CEventProgram(this.app);
			this.LOList = new CLOList();
			this.leVirtualRect = new CRect();

			var chID = 0, chFlags, chSize;
			var posEnd;
			var nOldFrameWidth = 0;
			var nOldFrameHeight = 0;
			this.m_wRandomSeed = -1;
			while (chID != 0x7F7F)
			{
				chID = this.app.file.readAShort();
				chFlags = this.app.file.readAShort();
				chSize = this.app.file.readAInt();
				if (chSize == 0)
				{
					continue;
				}
				this.posEnd = this.app.file.getFilePointer() + chSize;
				switch (chID)
				{
					case 0x3334:
						this.loadHeader();
						if (this.app.parentApp != null && (this.app.parentOptions & CCCA.CCAF_DOCKED) != 0)
						{
							this.leEditWinWidth = this.app.cx;
							this.leEditWinHeight = this.app.cy;
						}
						else
						{
							this.leEditWinWidth = Math.min(this.app.gaCxWin, this.leWidth);
							this.leEditWinHeight = Math.min(this.app.gaCyWin, this.leHeight);
						}
						break;

					// CHUNK_MOSAICIMAGETABLE
					case 0x3348:
						var number = chSize / (3 * 2);
						this.mosaicHandles = new Array(number);
						this.mosaicX = new Array(number);
						this.mosaicY = new Array(number);
						this.mosaicMaxHandle = 0;
						var n;
						for (n = 0; n < number; n++)
						{
							this.mosaicHandles[n] = this.app.file.readAShort();
							this.mosaicMaxHandle = Math.max(this.mosaicMaxHandle, this.mosaicHandles[n]);
							this.mosaicX[n] = this.app.file.readAShort();
							this.mosaicY[n] = this.app.file.readAShort();
						}
						this.mosaicMaxHandle++;
						break;

					// CHUNK_FRAME_HTML5_OPTIONS
					case 0x334A:
						this.joystick = this.app.file.readAShort();
						this.html5Options = this.app.file.readAShort();
						break;

					case 0x3342:
						this.leVirtualRect.load(this.app.file);
						break;

					case 0x3344:
						this.m_wRandomSeed = this.app.file.readAShort();
						break;

					case 0x3347:
						this.m_dwMvtTimerBase = this.app.file.readAInt();
						break;

					case 0x3335:
						this.frameName = this.app.file.readAString();
						break;

					// CHUNK_FRAMEFADEIN
					case 0x333B:
						this.fadeIn = new CTransitionData();
						this.fadeIn.load(this.app.file);
						break;

					// CHUNK_FRAMEFADEOUT
					case 0x333C:
						this.fadeOut = new CTransitionData();
						this.fadeOut.load(this.app.file);
						break;

					case 0x3341:
						this.loadLayers();
						break;

					case 0x3345:
						this.loadLayerEffects();
						break;

					case 0x3338:
						this.LOList.load(this.app);
						break;

					case 0x333D:
						this.evtProg.load(this.app);
						this.maxObjects = this.evtProg.maxObjects;
						break;
				}
				// Positionne a la fin du chunk
				this.app.file.seek(this.posEnd);
			}

			this.app.OIList.resetToLoad();
			var n;
			for (n = 0; n < this.LOList.nIndex; n++)
			{
				var loTemp = this.LOList.getLOFromIndex(n);
				this.app.OIList.setToLoad(loTemp.loOiHandle);
			}

			this.app.imageBank.resetToLoad();
			this.app.soundBank.resetToLoad();
			this.app.fontBank.resetToLoad();
			this.app.OIList.load(this.app.file);
			this.app.OIList.enumElements(this.app.imageBank, this.app.fontBank);
			if (this.app.dwOptions & CRunApp.AH2OPT_LOADDATAATSTART)
			{
				this.app.fontBank.setAllToLoad();
				this.app.soundBank.setAllToLoad();
				if (this.app.mosaicMaxHandle == 0)
					this.app.imageBank.setAllToLoad();
			}
			this.app.imageBank.load(this.app.file);
			this.app.fontBank.load(this.app.file);
			this.evtProg.enumSounds(this.app.soundBank);
			this.app.soundBank.load();

			this.app.OIList.resetOICurrent();
			for (n = 0; n < this.LOList.nIndex; n++)
			{
				var lo = this.LOList.list[n];
				if (lo.loType >= COI.OBJ_SPR)
				{
					this.app.OIList.setOICurrent(lo.loOiHandle);
				}
			}
		},

		loadLayers: function ()
		{
			this.nLayers = this.app.file.readAInt();
			this.layers = new Array(this.nLayers);

			var n;
			for (n = 0; n < this.nLayers; n++)
			{
				this.layers[n] = new CLayer(this.app);
				this.layers[n].load(this.app.file);
			}
		},

		loadLayerEffects: function ()
		{
			var l;
			for (l = 0; l < this.nLayers; l++)
			{
				this.layers[l].effect = this.app.file.readAInt();
				this.layers[l].effectParam = this.app.file.readAInt();
				this.app.file.skipBytes(12);
			}
		},

		loadHeader: function ()
		{
			this.leWidth = this.app.file.readAInt();
			this.leHeight = this.app.file.readAInt();
			this.leBackground = this.app.file.readAColor();
			this.leFlags = this.app.file.readAInt();
		}
	}

	// CSoundPlayer object
	// ----------------------------------------------------------------
	CSoundPlayer.NCHANNELS = 32;
	function CSoundPlayer(a)
	{
		this.app = a;
		this.channels = null;
		this.bMultipleSounds = false;
		this.bOn = true;
		this.volumes = null;
		this.bLocked = null;
		this.pans = null;
		this.mainVolume = 0;
		this.mainPan = 0;
		this.dataToDecode = null;
		this.decoding = false;

		this.channels = new Array(CSoundPlayer.NCHANNELS);
		this.volumes = new Array(CSoundPlayer.NCHANNELS);
		this.bLocked = new Array(CSoundPlayer.NCHANNELS);
		this.bOn = true;
		this.bMultipleSounds = true;
		var n;
		for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
		{
			this.channels[n] = null;
			this.volumes[n] = 100;
			this.bLocked[n] = false;
		}
		this.mainVolume = 100;
		this.mainPan = 0;

		var sound = new Audio();
		var canPlay = new Array(4);
		canPlay[0] = sound.canPlayType('audio/ogg');
		canPlay[1] = sound.canPlayType('audio/x-m4a');
		canPlay[2] = sound.canPlayType('audio/mpeg');
		canPlay[3] = sound.canPlayType('audio/wav');
		this.probablePlayableFormats = 0;
		this.maybePlayableFormats = 0;
		for (n = 0; n < 4; n++)
		{
			if (canPlay[n] == 'probably')
				this.probablePlayableFormats |= (1 << n);
			if (canPlay[n] == 'maybe')
				this.maybePlayableFormats |= (1 << n);
		}

		// Use WEB AUDIO?
		var papp = a;
		while (papp.parentApp != null)
		    papp = papp.parentApp;
		this.context = papp.soundContext;
		this.contextType = papp.soundContextType;
		if (this.context == null)
		{
		    if (typeof AudioContext !== "undefined")
		    {
		        this.context = new AudioContext();
		        this.contextType = 1;
		    }
		    else if (typeof webkitAudioContext !== "undefined")
		    {
		        this.context = new webkitAudioContext();
		        this.contextType = 0;
		    }
		    papp.soundContext = this.context;
		    papp.soundContextType = this.contextType;
	    }
	}
	CSoundPlayer.prototype =
	{
		addDataToDecode: function (cSound)
		{
			if (this.dataToDecode == null)
				this.dataToDecode = new CArrayList();
			this.dataToDecode.add(cSound);
		},
		decodeData:      function ()
		{
			if (this.dataToDecode != null && this.dataToDecode.size() > 0)
			{
				if (!this.decoding)
				{
					var cSound = this.dataToDecode.get(0);
					this.dataToDecode.removeIndex(0);
					this.decoding = true;
					var that = this;
					that.context["decodeAudioData"](cSound.response, function (buffer)
					{
						cSound.buffer = buffer;
						cSound.response = null;
						that.app.dataHasLoaded(cSound);
						that.decoding = false;
					});
				}
			}
		},
		reset:           function ()
		{
			var n;
			for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
			{
				this.bLocked[n] = false;
			}
		},
		lockChannel:     function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				this.bLocked[channel] = true;
			}
		},
		unlockChannel:   function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				this.bLocked[channel] = false;
			}
		},

		play: function (handle, nLoops, channel, bPrio)
		{
			var n;

			if (this.bOn == false)
				return;

			var sound = this.app.soundBank.getSoundFromHandle(handle);
			if (sound == null)
				return;
			if (this.bMultipleSounds == false)
				channel = 0;
			/*      	else
			 {
			 for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
			 {
			 if (this.channels[n] == sound)
			 {
			 sound=sound.createFromSound();
			 break;
			 }
			 }
			 }
			 */
			if (channel < 0)
			{
				for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
				{
					if (this.channels[n] == null && this.bLocked[n] == false)
					{
						break;
					}
				}
				if (n == CSoundPlayer.NCHANNELS)
				{
					for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
					{
						if (this.bLocked[n] == false)
						{
							if (this.channels[n] != null)
							{
								if (this.channels[n].bUninterruptible == false)
								{
									break;
								}
							}
						}
					}
				}
				channel = n;
				if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
				{
					this.volumes[channel] = this.mainVolume;
				}
			}
			if (channel < 0 || channel >= CSoundPlayer.NCHANNELS)
				return;

			if (this.channels[channel] != null)
			{
				if (this.channels[channel].bUninterruptible == true)
					return;
				if (this.channels[channel] != sound)
				{
					this.channels[channel].stop();
					this.channels[channel] = null;
				}
			}
			for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
			{
				if (this.channels[n] == sound)
				{
					this.channels[n].stop();
					this.channels[n] = null;
				}
			}
			this.channels[channel] = sound;
			sound.play(nLoops, bPrio, this.volumes[channel]);
		},

		setMultipleSounds: function (bMultiple)
		{
			this.bMultipleSounds = bMultiple;
		},

		keepCurrentSounds: function ()
		{
			var n;
			for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
			{
				if (this.channels[n] != null)
				{
					if (this.channels[n].isPlaying())
					{
						this.app.soundBank.setToLoad(this.channels[n].handle);
					}
				}
			}
		},

		setOnOff: function (bState)
		{
			if (bState != bOn)
			{
				this.bOn = bState;
				if (this.bOn == false)
					this.stopAllSounds();
			}
		},

		getOnOff: function ()
		{
			return this.bOn;
		},

		stopAllSounds: function ()
		{
			var n;
			for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
			{
				if (this.channels[n] != null)
				{
					this.channels[n].stop();
					this.channels[n] = null;
				}
			}
		},

		stopSample: function (handle)
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						this.channels[c].stop();
						this.channels[c] = null;
					}
				}
			}
		},

		stopChannel: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					this.channels[channel].stop();
					this.channels[channel] = null;
				}
			}
		},

		isSamplePaused: function (handle)
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						return this.channels[c].isPaused();
					}
				}
			}
			return false;
		},

		isSoundPlaying: function ()
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].isPlaying())
						return true;
				}
			}
			return false;
		},

		isSamplePlaying: function (handle)
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						return this.channels[c].isPlaying();
					}
				}
			}
			return false;
		},

		isChannelPlaying: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					return this.channels[channel].isPlaying();
				}
			}
			return false;
		},

		isChannelPaused: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					return this.channels[channel].isPaused();
				}
			}
			return false;
		},

		pause: function ()
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					this.channels[c].pause();
				}
			}
		},

		pauseChannel: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					this.channels[channel].pause();
				}
			}
		},

		pauseSample: function (handle)
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						this.channels[c].pause();
					}
				}
			}
		},

		resume: function ()
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					this.channels[c].resume();
				}
			}
		},

		resumeChannel: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					this.channels[channel].resume();
				}
			}
		},

		resumeSample: function (handle)
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						this.channels[c].resume();
					}
				}
			}
		},

		setVolumeChannel: function (channel, volume)
		{
			if (volume < 0) volume = 0;
			if (volume > 100) volume = 100;

			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				this.volumes[channel] = volume;
				if (this.channels[channel] != null)
				{
					this.channels[channel].setVolume(volume);
				}
			}
		},

		setFrequencyChannel: function (channel, freq)
		{
			//        if (freq<0) freq=0;
			//        if (freq>100000) freq= 100000;

			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					this.channels[channel].setFrequency(freq);
				}
			}
		},

		setFrequencySample: function (handle, freq)
		{
			//        if (freq<0) freq=0;
			//        if (freq>100000) freq= 100000;

			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						this.channels[c].setFrequency(freq);
					}
				}
			}
		},

		setPositionChannel: function (channel, pos)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					this.channels[channel].setPosition(pos);
				}
			}
		},

		setPositionSample: function (handle, pos)
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						this.channels[c].setPosition(pos);
					}
				}
			}
		},

		getVolumeChannel: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					return this.volumes[channel];
				}
			}
			return 0;
		},

		setVolumeSample: function (handle, volume)
		{
			if (volume < 0) volume = 0;
			if (volume > 100) volume = 100;

			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].handle == handle)
					{
						this.volumes[c] = volume;
						this.channels[c].setVolume(volume);
					}
				}
			}
		},

		setMainVolume: function (volume)
		{
			var n;
			this.mainVolume = volume;
			for (n = 0; n < CSoundPlayer.NCHANNELS; n++)
			{
				this.volumes[n] = volume;
				if (this.channels[n] != null)
				{
					this.channels[n].setVolume(volume);
				}
			}
		},

		getMainVolume: function ()
		{
			return this.mainVolume;
		},

		getChannel: function (name)
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].name == name)
					{
						return c;
					}
				}
			}
			return -1;
		},

		getDurationChannel: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					return this.channels[channel].getDuration();
				}
			}
			return 0;
		},

		getPositionChannel: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					return this.channels[channel].getPosition();
				}
			}
			return 0;
		},

		getFrequencyChannel: function (channel)
		{
			if (channel >= 0 && channel < CSoundPlayer.NCHANNELS)
			{
				if (this.channels[channel] != null)
				{
					return this.channels[channel].getFrequency();
				}
			}
			return 0;
		},

		getVolumeSample: function (name)
		{
			var channel = this.getChannel(name);
			if (channel >= 0)
			{
				return this.volumes[channel];
			}
			return 0;
		},

		getDurationSample: function (name)
		{
			var channel = this.getChannel(name);
			if (channel >= 0)
			{
				return this.channels[channel].getDuration();
			}
			return 0;
		},

		getPositionSample: function (name)
		{
			var channel = this.getChannel(name);
			if (channel >= 0)
			{
				return this.channels[channel].getPosition();
			}
			return 0;
		},

		getFrequencySample: function (name)
		{
			var channel = this.getChannel(name);
			if (channel >= 0)
			{
				return this.channels[channel].getFrequency();
			}
			return 0;
		},

		checkSounds: function ()
		{
			var c;
			for (c = 0; c < CSoundPlayer.NCHANNELS; c++)
			{
				if (this.channels[c] != null)
				{
					if (this.channels[c].checkSound())
					{
						this.channels[c] = null;
					}
				}
			}
		}
	}

	// Embedded Files
	// ------------------------------------------------------------
	function CEmbeddedFile(a)
	{
		this.app = a;
	}
	CEmbeddedFile.prototype =
	{
		preLoad: function ()
		{
			var l = this.app.file.readAShort();
			this.path = this.app.file.readAString(l);
			var pos = this.path.lastIndexOf("\\");
			if (pos >= 0)
			{
				this.path = this.path.substring(pos + 1);
			}
			this.length = this.app.file.readAInt();
			this.offset = this.app.file.getFilePointer();
			this.app.file.skipBytes(this.length);
		},
		open:    function ()
		{
			return this.app.file.createFromFile(this.offset, this.length)
		}
	}

	// Preloader
	// -------------------------------------------------------------
	function CPreloaderImage(a)
	{
		this.app = a;
		this.isLoaded = false;
		this.subApp = null;
		this.context = this.app.context;
		this.radius = this.app.preloaderCircleRadius;   // * (this.app.scaleX + this.app.scaleY) / 2;
		this.color = this.app.preloaderCircleColor;
		this.xCenter = this.app.preloaderCircleCenterX;
		if (this.xCenter < 0)
			this.xCenter = this.app.gaCxWin / 2;
		this.yCenter = this.app.preloaderCircleCenterY;
		if (this.yCenter < 0)
			this.yCenter = this.app.gaCyWin / 2;
		this.currentAngle = 0;
		this.size = this.app.preloaderCircleThickness;  // * (this.app.scaleX + this.app.scaleY) / 2;
		this.oldAngle = 0;
		this.counter = 25;
		this.phase = 0;

		this.image = new Image();
		var that = this;
		this.image.onload = function ()
		{
			that.isLoaded = true;
		}
		this.image.src = this.app.resources + "Preloader.png";
	}
	CPreloaderImage.prototype =
	{
		load:  function ()
		{
			return this.isLoaded;
		},
		reset: function ()
		{
			this.phase = 0;
			this.oldAngle = 0;
			this.counter = 25;
		},
		step:  function ()
		{
			switch (this.phase)
			{
				case 0:
					if (this.app.preloaderBackColor != -1)
					    this.context.renderSolidColor(0, 0, this.app.gaCxWin, this.app.gaCyWin, this.app.preloaderBackColor);
	                else
					    this.context.clearBackground(0, 0, this.app.gaCxWin, this.app.gaCyWin);
	                this.context.renderSimpleImage(this.image, this.xCenter - this.image.width / 2, this.yCenter - this.image.height / 2, this.image.width, this.image.height, 0, 0);
					this.phase++;
					break;
				case 1:
					this.angle = this.app.imagesLoaded / this.app.imagesToLoad * 2 * Math.PI;
					this.drawIt(this.angle);
					if (this.app.imagesLoaded == this.app.imagesToLoad)
						this.phase++;
					break;
				case 2:
					if (this.counter > 0)
						this.counter--;
					if (this.counter == 0)
						this.phase++;
					break;
				case 3:
					if (this.app.drawContinue(this))
						this.phase++;
					break;
				default:
					break;
			}
		},

		isComplete: function ()
		{
			return this.phase == 4;
		},
		drawIt:     function (angle)
		{
			var a;
			var x1, y1, x2, y2;
			for (a = this.oldAngle; a <= angle; a += 0.005)
			{
				x1 = this.xCenter + Math.cos(a) * (this.radius - this.size);
				y1 = this.yCenter - Math.sin(a) * (this.radius - this.size);
				x2 = this.xCenter + Math.cos(a) * this.radius;
				y2 = this.yCenter - Math.sin(a) * this.radius;
				this.context.renderLine(x1, y1, x2, y2, this.color, 1, 0, 0);

				var n;
				for (n = 0; n < 3; n++)
				{
					x1 = this.xCenter + Math.cos(a) * (this.radius - this.size - n);
					y1 = this.yCenter - Math.sin(a) * (this.radius - this.size - n);
					x2 = this.xCenter + Math.cos(a) * (this.radius - this.size - n - 1);
					y2 = this.yCenter - Math.sin(a) * (this.radius - this.size - n - 1);
					this.context.renderLine(x1, y1, x2, y2, this.color, 1, 0, 0);

					x1 = this.xCenter + Math.cos(a) * (this.radius + n);
					y1 = this.yCenter - Math.sin(a) * (this.radius + n);
					x2 = this.xCenter + Math.cos(a) * (this.radius + n + 1);
					y2 = this.yCenter - Math.sin(a) * (this.radius + n + 1);
					this.context.renderLine(x1, y1, x2, y2, this.color, 1, 0, 0);
				}
			}
			this.oldAngle = angle;
		}
	}
	function CPreloaderDefault(a)
	{
		this.app = a;
		this.context = this.app.context;
		this.currentPosition = 0;
		this.width = 100;
		this.height = 12;
		this.position = 0;
		this.backColor = 0xA0A0A0;
		this.borderColor = 0x808080;
		this.barColor = 0x000000;
		this.rect = new CRect();
		this.rect.left = this.app.gaCxWin / 2 - this.width / 2;
		this.rect.top = this.app.gaCyWin / 2 - this.height / 2;
		this.rect.right = this.rect.left + this.width;
		this.rect.bottom = this.rect.top + this.height;
		this.reset();
	}
	CPreloaderDefault.prototype =
	{
		load:  function ()
		{
			return true;
		},
		reset: function ()
		{
			this.quit = false;
			this.phase = 0;
			this.alpha = 128;
			this.position = 0;
		},
		step:  function ()
		{
			if (this.app.imagesLoaded < this.app.imagesToLoad)
			{
				switch (this.phase)
				{
					case 0:
						if (this.alpha > 0)
						{
							this.alpha -= 2;
							if (this.alpha <= 0)
							{
								this.alpha = 0;
								this.phase++;
							}
						}
						break;
					case 1:
						break;
				}
			}
			else
			{
				switch (this.phase)
				{
					case 0:
					case 1:
						this.phase = 2;
						break;
					case 2:
						if (this.alpha < 128)
						{
							this.alpha += 4;
						}
						if (this.alpha >= 128)
						{
							this.alpha = 128;
							if (this.app.silentSound == null)
								this.quit = true;
							else
								this.phase++;
						}
						break;
					default:
						this.quit = this.app.drawContinue(this);
						return;
				}
			}
			//            this.context.renderSolidColor(this.rect.left, this.rect.top, this.width, this.height, this.app.frameColor, 0, 0);
			this.context.renderSolidColor(this.rect.left, this.rect.top, this.width, this.height, this.backColor, CRSpr.BOP_BLEND, this.alpha);
			this.context.renderRect(this.rect.left, this.rect.top, this.width, this.height, this.borderColor, 1, CRSpr.BOP_BLEND, this.alpha);
			this.position = this.app.imagesLoaded / this.app.imagesToLoad * (this.width - 2);
			this.context.renderSolidColor(this.rect.left + 1, this.rect.top + 1, this.position, this.height - 2, this.barColor, CRSpr.BOP_BLEND, this.alpha);
		},

		isComplete: function ()
		{
			return this.quit && (this.app.imagesLoaded == this.app.imagesToLoad);
		}
	}

	function CPreloaderFrame(a)
	{
		this.app = a;
		this.isLoaded = false;
		this.appSprite = new Sprite();
		this.subApp = new CRunApp(this.app, this.app.file, this.app.path, true);
		this.subApp.setParentApp(this.app, this.app.preloaderFrameNumber, 0, this.appSprite, this.app.gaCxWin, this.app.gaCyWin);
		this.subApp.digest();
		this.subApp.loadPreloader = false;
		this.subApp.subAppStopped = false;
		this.subApp.dwOptions &= ~CRunApp.AH2OPT_LOADDATAATSTART;
		this.subApp.startApplication();
		this.subApp.setMouseOffsets(0, 0);
		this.subApp.stepApplication();
		this.appSprite.x = this.app.gaCxWin / 2 - this.subApp.frame.leWidth / 2;
		this.appSprite.y = this.app.gaCyWin / 2 - this.subApp.frame.leHeight / 2;
		this.stopOnLoad = (this.app.dwOptions & CRunApp.AH2OPT_PRELOADERQUIT) != 0;
		this.app.subApps.push(this.subApp);
		this.delay = 0;
	}
	CPreloaderFrame.prototype =
	{
		load:       function ()
		{
			this.step();
			return !this.subApp.loading;
		},
		reset:      function ()
		{
			this.subApp.run.f_StopSamples();
			this.subApp.run.killFrameObjects();
			this.subApp.run.y_KillLevel(false);
			this.subApp.run.resetFrameLayers(-1, false);
			this.subApp.run.rhEvtProg.unBranchPrograms();
			this.subApp.run.freeMouse();
			this.subApp.run.freeRunHeader();

			this.subApp.run.rhFrame.leX = this.subApp.run.rhFrame.leLastScrlX = this.subApp.run.rh3DisplayX = 0;
			this.subApp.run.rhFrame.leY = this.subApp.run.rhFrame.leLastScrlY = this.subApp.run.rh3DisplayY = 0;
			this.subApp.resetLayers();
			this.subApp.run.allocRunHeader();
			this.subApp.run.initAsmLoop();
			this.subApp.run.resetFrameLayers(-1, false);
			this.subApp.run.prepareFrame();
			this.subApp.run.createFrameObjects(false);
			this.subApp.run.drawLevel();
			this.subApp.run.loadGlobalObjectsData();
			this.subApp.run.rhEvtProg.prepareProgram();
			this.subApp.run.rhEvtProg.assemblePrograms(this.subApp.run);
			this.subApp.run.f_InitLoop();
			this.subApp.run.captureMouse();
			this.subApp.run.rhQuit = 0;
			this.subApp.run.rhQuitParam = 0;
			this.subApp.subAppStopped = false;
			this.app.subApps.push(this.subApp);
			this.delay = 0;
		},
		step:       function ()
		{
			if (!this.subApp.subAppStopped)
			{
				if (this.stopOnLoad)
					this.subApp.subAppStopped = (this.app.imagesLoaded == this.app.imagesToLoad);
				if (this.subApp.stepApplication() == false)
					this.subApp.subAppStopped = true;
				this.subApp.drawSubApplication(this.context, this.appSprite.x, this.appSprite.y, false);
			}
			if (this.subApp.subAppStopped && this.app.silentSound)
			{
				this.app.drawContinue(this);
			}
		},
		isComplete: function ()
		{
			var bComplete = this.subApp.subAppStopped;
			if (this.app.silentSound)
				bComplete = false;
			if (bComplete)
			{
				if (this.delay > 0)
				{
					this.delay--;
					if (this.delay > 0)
						return false;
				}
				var n;
				for (n = 0; n < this.app.subApps.length; n++)
				{
					if (this.app.subApps[n] == this.subApp)
					{
						this.app.subApps.splice(n, 1);
						break;
					}
				}
			}
			return bComplete;
		}
	}

	// Virtual joystick
	// ----------------------------------------------------------------
	CJoystick.KEY_JOYSTICK = 0;
	CJoystick.KEY_FIRE1 = 1;
	CJoystick.KEY_FIRE2 = 2;
	CJoystick.KEY_NONE = -1;
	CJoystick.MAX_TOUCHES = 3;
	CJoystick.JFLAG_JOYSTICK = 0x0001;
	CJoystick.JFLAG_FIRE1 = 0x0002;
	CJoystick.JFLAG_FIRE2 = 0x0004;
	CJoystick.JFLAG_LEFTHANDED = 0x0008;
	CJoystick.JPOS_NOTDEFINED = 0x80000000;
	CJoystick.JOY_ANGLEGAP = 70;
	CJoystick.DPAD_ANGLEGAP = 60;
	CJoystick.DEADZONE = 0.5;

	function CJoystick(a)
	{
		this.app = a;
		this.joyBack = null;
		this.joyFront = null;
		this.fire1U = null;
		this.fire2U = null;
		this.fire1D = null;
		this.fire2D = null;
		this.imagesX = new Array(3);
		this.imagesY = new Array(3);
		this.joystickX = 0;
		this.joystickY = 0;
		this.joystick = 0;
		this.flags = 0;
		this.touches = new Array(3);
		this.bSetPositions = false;
		this.isJoystick = true;
		this.joydeadzone = 0;
		this.joyanglezone = 0;
		this.joyradsize = 0;
	}
	CJoystick.prototype =
	{
		loadImages:   function ()
		{
			if (this.joyBack == null)
			{
				this.joyBack = CImage.createFromFile(this.app, "joyback.png");
				this.joyFront = CImage.createFromFile(this.app, "joyfront.png");
				this.fire1U = CImage.createFromFile(this.app, "fire1U.png");
				this.fire2U = CImage.createFromFile(this.app, "fire2U.png");
				this.fire1D = CImage.createFromFile(this.app, "fire1D.png");
				this.fire2D = CImage.createFromFile(this.app, "fire2D.png");
			}
		},
		reset:        function (f)
		{
			this.flags = f;
			if (this.joyBack != null && this.joyBack.width != 0)
				this.setPositions();
			else
				this.bSetPositions = true;

			if (this.isJoystick)
				this.joyanglezone = CJoystick.JOY_ANGLEGAP * Math.PI / 180;
			else
				this.joyanglezone = CJoystick.DPAD_ANGLEGAP * Math.PI / 180;
		},
		setPositions: function ()
		{
			var sx, sy;
			sx = this.app.gaCxWin;
			sy = this.app.gaCyWin;
			if ((this.flags & CJoystick.JFLAG_LEFTHANDED) == 0)
			{
				if ((this.flags & CJoystick.JFLAG_JOYSTICK) != 0)
				{
					this.imagesX[CJoystick.KEY_JOYSTICK] = 16 + this.joyBack.width / 2;
					this.imagesY[CJoystick.KEY_JOYSTICK] = sy - 16 - this.joyBack.height / 2;
				}
				if ((this.flags & CJoystick.JFLAG_FIRE1) != 0 && (this.flags & CJoystick.JFLAG_FIRE2) != 0)
				{
					this.imagesX[CJoystick.KEY_FIRE1] = sx - this.fire1U.width / 2 - 32;
					this.imagesY[CJoystick.KEY_FIRE1] = sy - this.fire1U.height / 2 - 16;
					this.imagesX[CJoystick.KEY_FIRE2] = sx - this.fire2U.width / 2 - 16;
					this.imagesY[CJoystick.KEY_FIRE2] = sy - this.fire2U.height / 2 - this.fire1U.height - 24;
				}
				else if ((this.flags & CJoystick.JFLAG_FIRE1) != 0)
				{
					this.imagesX[CJoystick.KEY_FIRE1] = sx - this.fire1U.width / 2 - 16;
					this.imagesY[CJoystick.KEY_FIRE1] = sy - this.fire1U.height / 2 - 16;
				}
				else if ((this.flags & CJoystick.JFLAG_FIRE2) != 0)
				{
					this.imagesX[CJoystick.KEY_FIRE2] = sx - this.fire2U.width / 2 - 16;
					this.imagesY[CJoystick.KEY_FIRE2] = sy - this.fire2U.height / 2 - 16;
				}
			}
			else
			{
				if ((this.flags & CJoystick.JFLAG_JOYSTICK) != 0)
				{
					this.imagesX[CJoystick.KEY_JOYSTICK] = sx - 16 - this.joyBack.width / 2;
					this.imagesY[CJoystick.KEY_JOYSTICK] = sy - 16 - this.joyBack.height / 2;
				}
				if ((this.flags & CJoystick.JFLAG_FIRE1) != 0 && (this.flags & CJoystick.JFLAG_FIRE2) != 0)
				{
					this.imagesX[CJoystick.KEY_FIRE1] = this.fire1U.width / 2 + 16 + this.fire2U.width * 2 / 3;
					this.imagesY[CJoystick.KEY_FIRE1] = sy - this.fire1U.height / 2 - 16;
					this.imagesX[CJoystick.KEY_FIRE2] = this.fire2U.width / 2 + 16;
					this.imagesY[CJoystick.KEY_FIRE2] = sy - this.fire2U.height / 2 - this.fire1U.height - 24;
				}
				else if ((this.flags & CJoystick.JFLAG_FIRE1) != 0)
				{
					this.imagesX[CJoystick.KEY_FIRE1] = this.fire1U.width / 2 + 16;
					this.imagesY[CJoystick.KEY_FIRE1] = sy - this.fire1U.height / 2 - 16;
				}
				else if ((this.flags & CJoystick.JFLAG_FIRE2) != 0)
				{
					this.imagesX[CJoystick.KEY_FIRE2] = this.fire2U.width / 2 + 16;
					this.imagesY[CJoystick.KEY_FIRE2] = sy - this.fire2U.height / 2 - 16;
				}
			}
		},
		setXPosition: function (f, p)
		{
			if ((f & CJoystick.JFLAG_JOYSTICK) != 0)
			{
				this.imagesX[CJoystick.KEY_JOYSTICK] = p;
			}
			else if ((f & CJoystick.JFLAG_FIRE1) != 0)
			{
				this.imagesX[CJoystick.KEY_FIRE1] = p;
			}
			else if ((f & CJoystick.JFLAG_FIRE2) != 0)
			{
				this.imagesX[CJoystick.KEY_FIRE2] = p;
			}
		},
		setYPosition: function (f, p)
		{
			if ((f & CJoystick.JFLAG_JOYSTICK) != 0)
			{
				this.imagesY[CJoystick.KEY_JOYSTICK] = p;
			}
			else if ((f & CJoystick.JFLAG_FIRE1) != 0)
			{
				this.imagesY[CJoystick.KEY_FIRE1] = p;
			}
			else if ((f & CJoystick.JFLAG_FIRE2) != 0)
			{
				this.imagesY[CJoystick.KEY_FIRE2] = p;
			}
		},
		draw:         function (context)
		{
			if (this.bSetPositions)
			{
				this.bSetPositions = false;
				this.setPositions();
			}

			var x, y, width, height;
			if ((this.flags & CJoystick.JFLAG_JOYSTICK) != 0)
			{
				x = this.imagesX[CJoystick.KEY_JOYSTICK] - this.joyBack.width / 2;
				y = this.imagesY[CJoystick.KEY_JOYSTICK] - this.joyBack.height / 2;
				context.renderImage(this.joyBack, x, y, 0, 1, 1, 0, 0);
				x = this.imagesX[CJoystick.KEY_JOYSTICK] + this.joystickX - this.joyFront.width / 2;
				y = this.imagesY[CJoystick.KEY_JOYSTICK] + this.joystickY - this.joyFront.height / 2;
				context.renderImage(this.joyFront, x, y, 0, 1, 1, 0, 0);
			}
			if ((this.flags & CJoystick.JFLAG_FIRE1) != 0)
			{
				var tex = ((this.joystick & 0x10) == 0) ? this.fire1U : this.fire1D;
				x = this.imagesX[CJoystick.KEY_FIRE1] - tex.width / 2;
				y = this.imagesY[CJoystick.KEY_FIRE1] - tex.height / 2;
				context.renderImage(tex, x, y, 0, 1, 1, 0, 0);
			}
			if ((this.flags & CJoystick.JFLAG_FIRE2) != 0)
			{
				var tex = ((this.joystick & 0x20) == 0) ? this.fire2U : this.fire2D;
				x = this.imagesX[CJoystick.KEY_FIRE2] - tex.width / 2;
				y = this.imagesY[CJoystick.KEY_FIRE2] - tex.height / 2;
				context.renderImage(tex, x, y, 0, 1, 1, 0, 0);
			}
		},

		touchStarted: function (touch)
		{
			var bFlag = false;
			var x = this.app.getTouchX(touch);
			var y = this.app.getTouchY(touch);

			this.joydeadzone = CJoystick.DEADZONE * Math.ceil(Math.sqrt(this.joyBack.width / 2 * this.joyBack.width / 2 + this.joyBack.height / 2 * this.joyBack.height / 2));	//Radius Size percentage
			// Max circle radius for the joystick or d-pad
			this.joyradsize = Math.ceil(Math.sqrt(this.joyBack.width / 4 * this.joyBack.width / 4 + this.joyBack.height / 4 * this.joyBack.height / 4));

			var key = this.getKey(x, y);
			if (key != CJoystick.KEY_NONE)
			{
				this.touches[key] = touch.identifier;
				if (key == CJoystick.KEY_JOYSTICK)
				{
					this.joystick &= 0xF0;
					bFlag = true;
				}
				if (key == CJoystick.KEY_FIRE1)
				{
					this.joystick |= 0x10;
					bFlag = true;
				}
				else if (key == CJoystick.KEY_FIRE2)
				{
					this.joystick |= 0x20;
					bFlag = true;
				}
			}
			return bFlag;
		},

		touchMoved: function (touch)
		{
			var x = this.app.getTouchX(touch);
			var y = this.app.getTouchY(touch);
			var key = this.getKey(x, y);
			if (key == CJoystick.KEY_JOYSTICK && touch.identifier == this.touches[CJoystick.KEY_JOYSTICK])
			{
				this.joystickX = x - this.imagesX[CJoystick.KEY_JOYSTICK];
				this.joystickY = y - this.imagesY[CJoystick.KEY_JOYSTICK];

				// angles ranges from 0 to 360 degrees in radians
				var angle = (Math.PI * 2 - Math.atan2(this.joystickY, this.joystickX)) % (Math.PI * 2);
				this.joystick &= 0xF0;
				var h = Math.sqrt(this.joystickX * this.joystickX + this.joystickY * this.joystickY);

				if (this.isJoystick)
				{
					this.joystickX = Math.cos(angle) * this.joyradsize;
					this.joystickY = Math.sin(angle) * -this.joyradsize;
				}
				else
				{
					if (this.joystickX < -this.joyradsize)
					{
						this.joystickX = -this.joyradsize;
					}
					if (this.joystickX > this.joyradsize)
					{
						this.joystickX = this.joyradsize;
					}
					if (this.joystickY < -this.joyradsize)
					{
						this.joystickY = -this.joyradsize;
					}
					if (this.joystickY > this.joyradsize)
					{
						this.joystickY = this.joyradsize;
					}
				}

				// Is the radius vector above the deadzone and border of the joystick base
				if (h > this.joydeadzone && h < this.joyradsize * 3)
				{

					var j = 0;
					// Checking in 45 degrees zone equal (PI/4); 1/4, 2/4, 3/4, 4/4, 5/4, 6/4, 7/4, 8/4
					// organized like 8/4, 2/4, 4/4, 6/4,  priority for right, up, left and down
					if (angle >= 0.0)
					{
						while (true)
						{
							// Right
							if (this.insideZone(angle, 0, this.joyanglezone) || this.insideZone(angle, (Math.PI) * 2, this.joyanglezone))
							{
								j = 8;
								break;
							}
							// Up
							if (this.insideZone(angle, Math.PI / 2, this.joyanglezone))
							{
								j = 1;
								break;
							}
							// Left
							if (this.insideZone(angle, (Math.PI), this.joyanglezone))
							{
								j = 4;
								break;
							}
							// Down
							if (this.insideZone(angle, (Math.PI / 4) * 6, this.joyanglezone))
							{
								j = 2;
								break;
							}
							// Right/Up
							if (this.insideZone(angle, Math.PI / 4, Math.PI / 2 - this.joyanglezone))
							{
								j = 9;
								break;
							}
							// Left/Up
							if (this.insideZone(angle, (Math.PI / 4) * 3, Math.PI / 2 - this.joyanglezone))
							{
								j = 5;
								break;
							}
							// Left/Down
							if (this.insideZone(angle, (Math.PI / 4) * 5, Math.PI / 2 - this.joyanglezone))
							{
								j = 6;
								break;
							}
							// Right/Down
							if (this.insideZone(angle, (Math.PI / 4) * 7, Math.PI / 2 - this.joyanglezone))
							{
								j = 10;
								break;
							}
							break;
						}
					}
					this.joystick |= j;
				}
			}
		},
		insideZone: function (angle, angle_ref, gap)
		{
			// check if the angle is in the range, could be ported using degrees instead.
			return (angle > (angle_ref - gap / 2) && angle < (angle_ref + gap / 2));
		},

		touchEnded: function (touch)
		{
			var n;
			for (n = 0; n < CJoystick.MAX_TOUCHES; n++)
			{
				if (this.touches[n] == touch.identifier)
				{
					this.touches[n] = 0;
					switch (n)
					{
						case CJoystick.KEY_JOYSTICK:
							this.joystickX = 0;
							this.joystickY = 0;
							this.joystick &= 0xF0;
							break;
						case CJoystick.KEY_FIRE1:
							this.joystick &= ~0x10;
							break;
						case CJoystick.KEY_FIRE2:
							this.joystick &= ~0x20;
							break;
					}
					break;
				}
			}
		},
		getKey:     function (x, y)
		{
			if ((this.flags & CJoystick.JFLAG_JOYSTICK) != 0)
			{
				if (x >= this.imagesX[CJoystick.KEY_JOYSTICK] - this.joyBack.width / 2 && x < this.imagesX[CJoystick.KEY_JOYSTICK] + this.joyBack.width / 2)
				{
					if (y > this.imagesY[CJoystick.KEY_JOYSTICK] - this.joyBack.height / 2 && y < this.imagesY[CJoystick.KEY_JOYSTICK] + this.joyBack.height / 2)
					{
						return CJoystick.KEY_JOYSTICK;
					}
				}
			}
			if ((this.flags & CJoystick.JFLAG_FIRE1) != 0)
			{
				if (x >= this.imagesX[CJoystick.KEY_FIRE1] - this.fire1U.width / 2 && x < this.imagesX[CJoystick.KEY_FIRE1] + this.fire1U.width / 2)
				{
					if (y > this.imagesY[CJoystick.KEY_FIRE1] - this.fire1U.height / 2 && y < this.imagesY[CJoystick.KEY_FIRE1] + this.fire1U.height / 2)
					{
						return CJoystick.KEY_FIRE1;
					}
				}
			}
			if ((this.flags & CJoystick.JFLAG_FIRE2) != 0)
			{
				if (x >= this.imagesX[CJoystick.KEY_FIRE2] - this.fire2U.width / 2 && x < this.imagesX[CJoystick.KEY_FIRE2] + this.fire2U.width / 2)
				{
					if (y > this.imagesY[CJoystick.KEY_FIRE2] - this.fire2U.height / 2 && y < this.imagesY[CJoystick.KEY_FIRE2] + this.fire2U.height / 2)
					{
						return CJoystick.KEY_FIRE2;
					}
				}
			}
			return CJoystick.KEY_NONE;
		},

		getJoystick: function ()
		{
			return this.joystick;
		}
	}
	// CRun Object
	// -----------------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 * 
	 * Permission is hereby granted to any person obtaining a legal copy 
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for 
	 * debugging, optimizing, or customizing applications created with 
	 * Clickteam Multimedia Fusion 2. 
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	CRun.GAMEFLAGS_VBLINDEP = 0x0002;
	CRun.GAMEFLAGS_LIMITEDSCROLL = 0x0004;
	CRun.GAMEFLAGS_FIRSTLOOPFADEIN = 0x0010;
	CRun.GAMEFLAGS_LOADONCALL = 0x0020;
	CRun.GAMEFLAGS_REALGAME = 0x0040;
	CRun.GAMEFLAGS_PLAY = 0x0080;
	CRun.GAMEFLAGS_INITIALISING = 0x0200;
	CRun.DLF_DONTUPDATE = 0x0002;
	CRun.DLF_DRAWOBJECTS = 0x0004;
	CRun.DLF_RESTARTLEVEL = 0x0008;
	CRun.DLF_DONTUPDATECOLMASK = 0x0010;
	CRun.DLF_COLMASKCLIPPED = 0x0020;
	CRun.DLF_SKIPLAYER0 = 0x0040;
	CRun.DLF_REDRAWLAYER = 0x0080;
	CRun.DLF_STARTLEVEL = 0x0100;
	CRun.GAME_XBORDER = 480;
	CRun.GAME_YBORDER = 300;
	CRun.COLMASK_XMARGIN = 64;
	CRun.COLMASK_YMARGIN = 16;
	CRun.WRAP_X = 1;
	CRun.WRAP_Y = 2;
	CRun.WRAP_XY = 4;
	CRun.RH3SCROLLING_SCROLL = 0x0001;
	CRun.RH3SCROLLING_REDRAWLAYERS = 0x0002;
	CRun.RH3SCROLLING_REDRAWALL = 0x0004;
	CRun.RH3SCROLLING_REDRAWTOTALCOLMASK = 0x0008;
	CRun.OBSTACLE_NONE = 0;
	CRun.OBSTACLE_SOLID = 1;
	CRun.OBSTACLE_PLATFORM = 2;
	CRun.OBSTACLE_LADDER = 3;
	CRun.OBSTACLE_TRANSPARENT = 4;
	CRun.COF_NOMOVEMENT = 0x0001;
	CRun.COF_HIDDEN = 0x0002;
	CRun.COF_FIRSTTEXT = 0x0004;
	CRun.COF_CREATEDATSTART = 0x0008;
	CRun.MAX_FRAMERATE = 10;
	CRun.LOOPEXIT_NEXTLEVEL = 1;
	CRun.LOOPEXIT_PREVLEVEL = 2;
	CRun.LOOPEXIT_GOTOLEVEL = 3;
	CRun.LOOPEXIT_NEWGAME = 4;
	CRun.LOOPEXIT_PAUSEGAME = 5;
	CRun.LOOPEXIT_SAVEAPPLICATION = 6;
	CRun.LOOPEXIT_LOADAPPLICATION = 7;
	CRun.LOOPEXIT_SAVEFRAME = 8;
	CRun.LOOPEXIT_LOADFRAME = 9;
	CRun.LOOPEXIT_ENDGAME = -2;
	CRun.LOOPEXIT_QUIT = 100;
	CRun.LOOPEXIT_RESTART = 101;
	CRun.BORDER_LEFT = 1;
	CRun.BORDER_RIGHT = 2;
	CRun.BORDER_TOP = 4;
	CRun.BORDER_BOTTOM = 8;
	CRun.BORDER_ALL = 15;
	CRun.MAX_INTERMEDIATERESULTS = 128;
	CRun.INTBAD = 0x7FFFFFFF;
	CRun.FANIDENTIFIER = 0x42324641;
	CRun.TREADMILLIDENTIFIER = 0x4232544D;
	CRun.PARTICULESIDENTIFIER = 0x42326AF3;
	CRun.MAGNETIDENTIFIER = 0x42369856;
	CRun.ROPEANDCHAINIDENTIFIER = 0x4232EFFA;
	CRun.BASEIDENTIFIER = 0x42324547;
	var bAlerted = false;

	CRun.plMasks =
		[
			0x00, 0x00, 0x00, 0x00,
			0xFF, 0x00, 0x00, 0x00,
			0xFF, 0xFF, 0x00, 0x00,
			0xFF, 0xFF, 0xFF, 0x00,
			0xFF, 0xFF, 0xFF, 0xFF
		];
	CRun.Table_InOut =
		[
			0,
			CRun.BORDER_LEFT,
			CRun.BORDER_RIGHT,
			0,
			CRun.BORDER_TOP,
			CRun.BORDER_TOP + CRun.BORDER_LEFT,
			CRun.BORDER_TOP + CRun.BORDER_RIGHT,
			0,
			CRun.BORDER_BOTTOM,
			CRun.BORDER_BOTTOM + CRun.BORDER_LEFT,
			CRun.BORDER_BOTTOM + CRun.BORDER_RIGHT,
			0,
			0,
			0,
			0,
			0
		];
	CRun.bMoveChanged = false;

	CRun.compareTo = function (pValue1, pValue2, comp)
	{
		switch (comp)
		{
			case 0:	// COMPARE_EQ:
				return pValue1 == pValue2;
			case 1:	// COMPARE_NE:
				return pValue1 != pValue2;
			case 2:	// COMPARE_LE:
				return pValue1 <= pValue2;
			case 3:	// COMPARE_LT:
				return pValue1 < pValue2;
			case 4:	// COMPARE_GE:
				return pValue1 >= pValue2;
			case 5:	// COMPARE_GT:
				return pValue1 > pValue2;
		}
		return false;
	}

	CRun.compareTer = function (value1, value2, comparaison)
	{
		switch (comparaison)
		{
			case 0:	// COMPARE_EQ:
				return (value1 == value2);
			case 1:	// COMPARE_NE:
				return (value1 != value2);
			case 2:	// COMPARE_LE:
				return (value1 <= value2);
			case 3:	// COMPARE_LT:
				return (value1 < value2);
			case 4:	// COMPARE_GE:
				return (value1 >= value2);
			case 5:	// COMPARE_GT:
				return (value1 > value2);
		}
		return false;
	}

	function CRun(app)
	{
		this.rhApp = app;
		this.rhFrame = null;
		this.rhMaxOI = 0;
		this.rhStopFlag = 0;
		this.rhEvFlag = 0;
		this.rhNPlayers = 0;
		this.rhGameFlags = 0;
		this.rhPlayer = 0;
		this.rhQuit = 0;
		this.rhQuitBis = 0;
		this.rhReturn = 0;
		this.rhQuitParam = 0;
		this.rhNObjects = 0;
		this.rhMaxObjects = 0;
		this.rhOiList = null;
		this.rhEvtProg = null;
		this.rhLevelSx = 0;
		this.rhLevelSy = 0;
		this.rhWindowX = 0;
		this.rhWindowY = 0;
		this.rhVBLDeltaOld = 0;
		this.rhVBLObjet = 0;
		this.rhVBLOld = 0;
		this.rhMT_VBLStep = 0;
		this.rhMT_VBLCount = 0;
		this.rhMT_MoveStep = 0;
		this.rhLoopCount = 0;
		this.rhTimer = 0;
		this.rhTimerOld = 0;
		this.rhTimerDelta = 0;
		this.rhOiListPtr = 0;
		this.rhObListNext = 0;
		this.rhDestroyPos = 0;
		this.rhMouseUsed = 0;
		this.rh2OldPlayer = null;
		this.rh2NewPlayer = null;
		this.rh2InputMask = null;
		this.rh2MouseKeys = 0;
		this.rh2CreationCount = 0;
		this.rh2MouseX = 0;
		this.rh2MouseY = 0;
		this.rh2MouseSaveX = 0;
		this.rh2MouseSaveY = 0;
		this.rh2PauseCompteur = 0;
		this.rh2PauseTimer = 0;
		this.rh2PauseVbl = 0;
		this.rh3DisplayX = 0;
		this.rh3DisplayY = 0;
		this.rh3WindowSx = 0;
		this.rh3WindowSy = 0;
		this.rh3CollisionCount = 0;
		this.rh3Scrolling = 0;
		this.rh3XMinimum = 0;
		this.rh3YMinimum = 0;
		this.rh3XMaximum = 0;
		this.rh3YMaximum = 0;
		this.rh3XMinimumKill = 0;
		this.rh3YMinimumKill = 0;
		this.rh3XMaximumKill = 0;
		this.rh3YMaximumKill = 0;
		this.rh3Graine = 0;
		this.rh4DemoMode = 0;
		//	this.rh4Demo=null;
		this.rh4PauseKey = 0;
		this.rh4CurrentFastLoop = null;
		this.rh4EndOfPause = 0;
		this.rh4MouseWheelDelta = 0;
		this.rh4OnMouseWheel = 0;
		this.rh4FastLoops = null;
		this.rh4ExpValue1 = 0;
		this.rh4ExpValue2 = 0;
		this.rh4KpxReturn = 0;
		this.rh4ObjectCurCreate = 0;
		this.rh4ObjectAddCreate = 0;
		this.rh4DoUpdate = 0;
		this.rh4VBLDelta = 0;
		this.rh4LoopTheoric = 0;
		this.rh4EventCount = 0;
		this.rh4BackDrawRoutines = null;
		this.rh4WindowDeltaX = 0;
		this.rh4WindowDeltaY = 0;
		this.rh4TimeOut = 0;
		this.rh4TabCounter = 0;
		this.rh4PosPile = 0;
		this.rh4Results = null;
		this.rh4Operators = null;
		this.rh4OpeNull = null;
		this.rh4CurToken = 0;
		this.rh4Tokens = null;
		this.rh4FrameRateArray = null;
		this.rh4FrameRatePos = 0;
		this.rh4FrameRatePrevious = 0;
		this.rhDestroyList = null;
		this.rh4SaveFrame = 0;
		this.rh4SaveFrameCount = 0;
		this.rh4MvtTimerCoef = 0;
		this.questionObjectOn = null;
		this.bOperande = false;
		this.rhWheelCount = 0;
		this.rhObjectList = null;
		this.currentTabObject = null;
		this.buttonClickCount = -1;
		this.isColArray = new Array(2);
		this.flagFloat = false;
		this.fadeTimerDelta = 0;
		this.rhJoystickMask = 0xFF;
		this.noResume = false;
		this.quitPause = false;
	}
	CRun.getObjectFont = function (hoPtr)
	{
		var info = null;

		if (hoPtr.hoType >= COI.KPX_BASE)
		{
			info = hoPtr.ext.getRunObjectFont();
		}
		else
		{
			info = hoPtr.getFont();
		}
		if (info == null)
		{
			info = new CFontInfo();
		}
		return info;
	}
	CRun.setObjectFont = function (hoPtr, pLf, pNewSize)
	{
		if (hoPtr.hoType >= COI.KPX_BASE)
		{
			hoPtr.ext.setRunObjectFont(pLf, pNewSize);
		}
		else
		{
			hoPtr.setFont(pLf, pNewSize);
		}
	}
	CRun.getObjectTextColor = function (hoPtr)
	{
		if (hoPtr.hoType >= COI.KPX_BASE)
		{
			return hoPtr.ext.getRunObjectTextColor();
		}
		return hoPtr.getFontColor();
	}
	CRun.setObjectTextColor = function (hoPtr, rgb)
	{
		if (hoPtr.hoType >= COI.KPX_BASE)
		{
			hoPtr.ext.setRunObjectTextColor(rgb);
		}
		else
		{
			hoPtr.setFontColor(rgb);
		}
	}
	CRun.objectShow = function (pHo)
	{
		if (pHo.ros != null)
		{
			pHo.ros.obShow();
			pHo.ros.rsFlags |= CRSpr.RSFLAG_VISIBLE;
			pHo.ros.rsFlash = 0;
		}
	}
	CRun.objectHide = function (pHo)
	{
		if (pHo.ros != null)
		{
			pHo.ros.obHide();
			pHo.ros.rsFlags &= ~CRSpr.RSFLAG_VISIBLE;
			pHo.ros.rsFlash = 0;
		}
	}
	CRun.setXPosition = function (hoPtr, x)
	{
		if (hoPtr.rom != null)
		{
			hoPtr.rom.rmMovement.setXPosition(x);
		}
		else
		{
			if (hoPtr.hoX != x)
			{
				hoPtr.hoX = x;
				if (hoPtr.roc != null)
				{
					hoPtr.roc.rcChanged = true;
					hoPtr.roc.rcCheckCollides = true;
				}
			}
		}
	}
	CRun.setYPosition = function (hoPtr, y)
	{
		if (hoPtr.rom != null)
		{
			hoPtr.rom.rmMovement.setYPosition(y);
		}
		else
		{
			if (hoPtr.hoY != y)
			{
				hoPtr.hoY = y;
				if (hoPtr.roc != null)
				{
					hoPtr.roc.rcChanged = true;
					hoPtr.roc.rcCheckCollides = true;
				}
			}
		}
	}
	CRun.get_DirFromPente = function (x, y)
	{
		if (x == 0)
		{
			if (y >= 0) return 24;
			return 8;
		}
		if (y == 0)
		{
			if (x >= 0) return 0;
			return 16;
		}

		var dir;
		var flagX = false;
		var flagY = false;
		if (x < 0)
		{
			flagX = true;
			x = -x;
		}
		if (y < 0)
		{
			flagY = true;
			y = -y;
		}

		var d = (x * 256) / y;
		var index;
		for (index = 0; ; index += 2)
		{
			if (d >= CMove.CosSurSin32[index])
				break;
		}
		dir = CMove.CosSurSin32[index + 1];

		if (flagY)
		{
			dir = -dir + 32;
			dir &= 31;
		}
		if (flagX)
		{
			dir -= 8;
			dir &= 31;
			dir = -dir;
			dir &= 31;
			dir += 8;
			dir &= 31;
		}
		return dir;
	}


	CRun.prototype =
	{
		setFrame:       function (f)
		{
			this.rhFrame = f;
		},
		allocRunHeader: function ()
		{
			this.rhObjectList = new Array(this.rhFrame.maxObjects);
			this.rhEvtProg = this.rhFrame.evtProg;

			this.rhMaxOI = 0;
			var oi;
			for (oi = this.rhApp.OIList.getFirstOI(); oi != null; oi = this.rhApp.OIList.getNextOI())
			{
				if (oi.oiType >= COI.OBJ_SPR)
				{
					this.rhMaxOI++;
				}
			}

			if (this.rhFrame.m_wRandomSeed == -1)
			{
				this.rh3Graine = this.rhApp.timer & 0xFFFF;
			}
			else
			{
				this.rh3Graine = this.rhFrame.m_wRandomSeed;
			}

			var no = Math.round(this.rhFrame.maxObjects / 32 + 1);
			this.rhDestroyList = new Array(no);

			this.rh4FastLoops = new CArrayList();
			this.rh4CurrentFastLoop = "";

			this.rhMaxObjects = this.rhFrame.maxObjects;

			this.rhNPlayers = this.rhEvtProg.nPlayers;
			this.rhFrame.leX = 0;
			this.rhFrame.leY = 0;
			this.rhWindowX = this.rhFrame.leX;
			this.rhWindowY = this.rhFrame.leY;
			this.rh4WindowDeltaX = 0;
			this.rh4WindowDeltaY = 0;
			this.rhLevelSx = this.rhFrame.leVirtualRect.right;
			if (this.rhLevelSx == -1)
				this.rhLevelSx = 0x7FFFF000;
			this.rhLevelSy = this.rhFrame.leVirtualRect.bottom;
			if (this.rhLevelSy == -1)
				this.rhLevelSy = 0x7FFFF000;
			this.rhNObjects = 0;
			this.rhStopFlag = 0;
			this.rhQuit = 0;
			this.rhQuitBis = 0;
			this.rhGameFlags &= (CRun.GAMEFLAGS_PLAY);
			this.rhGameFlags |= CRun.GAMEFLAGS_LIMITEDSCROLL;
			this.rh4FrameRatePos = 0;
			this.rh4FrameRatePrevious = 0;
			this.rh4FrameRateArray = new Array(CRun.MAX_FRAMERATE);
			this.rh4BackDrawRoutines = null;
			this.rh4SaveFrame = 0;
			this.rh4SaveFrameCount = -3;
			this.rhWheelCount = -1;
			this.rh4PosOnLoop = null;

			this.rhGameFlags |= CRun.GAMEFLAGS_REALGAME;

			this.rh4Results = new Array(CRun.MAX_INTERMEDIATERESULTS);
			this.rh4Operators = new Array(CRun.MAX_INTERMEDIATERESULTS);
			this.rh4OpeNull = new EXP_ZERO();
			this.rh4OpeNull.code = 0;

			this.rh2OldPlayer = new Array(4);
			this.rh2NewPlayer = new Array(4);
			this.rh2InputMask = new Array(4);
			this.rhPlayer = new Array(4);
			//		this.rhEvtProg.rh2CurrentClick = -1;
			this.rh4MvtTimerCoef = 0;

			var n;
			for (n = 0; n < CRun.MAX_FRAMERATE; n++)
				this.rh4FrameRateArray[n] = 50;
			this.quitPause = false;
			this.bodiesCreated = false;
			this.rhFrame.rhOK = true;
		},

		freeRunHeader: function ()
		{
			this.rhFrame.rhOK = false;

			this.rhObjectList = null;
			this.rhOiList = null;
			this.rhDestroyList = null;
			this.rh4CurrentFastLoop = null;
			this.rh4FastLoops = null;
			this.rh4BackDrawRoutines = null;
			this.rh4PosOnLoop = null;

			var n;
			for (n = 0; n < CRun.MAX_INTERMEDIATERESULTS; n++)
				this.rh4Results[n] = 0;
			this.rh4OpeNull = null;
		},

		initRunLoop: function (bFade)
		{
			this.allocRunHeader();

			this.rhApp.joystickOn = 0;
			if (this.rhApp.parentApp == null)
			{
				if (this.rhApp.touchable)
				{
					if (this.rhFrame.joystick == CRunFrame.JOYSTICK_EXT)
					{
						if (this.rhApp.joystick == null)
						{
							this.rhApp.joystick = new CJoystick(this.rhApp);
							this.rhApp.joystick.loadImages();
						}
						this.rhApp.joystick.reset(0);
						this.rhApp.startJoystick();
					}
					else if (this.rhFrame.joystick != CRunFrame.JOYSTICK_NONE)
					{
						var flags = 0;
						if ((this.rhFrame.html5Options & CRunFrame.IPHONEOPT_JOYSTICK_FIRE1) != 0)
						{
							flags = CJoystick.JFLAG_FIRE1;
						}
						if ((this.rhFrame.html5Options & CRunFrame.IPHONEOPT_JOYSTICK_FIRE2) != 0)
						{
							flags |= CJoystick.JFLAG_FIRE2;
						}
						if ((this.rhFrame.html5Options & CRunFrame.IPHONEOPT_JOYSTICK_LEFTHAND) != 0)
						{
							flags |= CJoystick.JFLAG_LEFTHANDED;
						}
						if (this.rhFrame.joystick == CRunFrame.JOYSTICK_TOUCH)
						{
							flags |= CJoystick.JFLAG_JOYSTICK;
						}
						if ((flags & (CJoystick.JFLAG_FIRE1 | CJoystick.JFLAG_FIRE2 | CJoystick.JFLAG_JOYSTICK)) != 0)
						{
							this.rhApp.startJoystick(flags);
							this.rhApp.joystick.reset(flags);
						}

						// Accelerometer joystick
						if (this.rhFrame.joystick == CRunFrame.JOYSTICK_ACCELEROMETER)
						{
							this.rhApp.startAccJoystick();
						}
					}
				}
			}
			this.rhJoystickMask = 0xFF;

			if (bFade)
				this.rhGameFlags |= CRun.GAMEFLAGS_FIRSTLOOPFADEIN;

			this.initAsmLoop();

			this.resetFrameLayers(-1, false);

			this.prepareFrame();

			this.rhLoopCount = 0;
			this.createFrameObjects(bFade);

			this.drawLevel();
			this.hideShowLayers();

			this.loadGlobalObjectsData();

			this.rhEvtProg.prepareProgram();
			this.rhEvtProg.assemblePrograms(this);

			this.showMouse();
			this.captureMouse();
			this.rhQuitParam = 0;
			this.f_InitLoop();
			this.bodiesCreated = false;

			//TODO		rhEvtProg.HandleKeyRepeat();
		},

		doRunLoop: function ()
		{
			if (this.rh2PauseCompteur > 0)
			{
				if (this.quitPause)
				{
					if (this.rhApp.keyNew == true)
					{
						if (this.rh4PauseKey >= 0)
						{
							if (this.rhApp.keyBuffer[this.rh4PauseKey])
							{
								this.resume();
								this.rhQuit = 0;
								this.rh4EndOfPause = this.rhLoopCount;
								this.rhEvtProg.handle_GlobalEvents((-8 << 16) | 0xFFFD);
							}
						}
						else
						{
							if (this.rhApp.keyNew)
							{
								this.resume();
								this.rhQuit = 0;
								this.rh4EndOfPause = this.rhLoopCount;
								this.rhEvtProg.handle_GlobalEvents((-8 << 16) | 0xFFFD);
							}
						}
					}
					this.rhApp.keyNew = false;
				}
				if (this.questionObjectOn != null)
				{
					this.questionObjectOn.handleQuestion();
				}
				quit = this.rhQuit;
			}
			else
			{
				// Calls the game
				this.rhApp.appRunFlags |= CRunApp.ARF_INGAMELOOP;
				var quit = this.f_GameLoop();
				this.rhApp.appRunFlags &= ~CRunApp.ARF_INGAMELOOP;

				// Si fin de FADE IN, detruit les sprites
				if ((this.rhGameFlags & CRun.GAMEFLAGS_FIRSTLOOPFADEIN) != 0)
				{
					var date = new Date();
					this.fadeTimerDelta = date.getTime() - this.rhTimerOld;
					// TODO rhFrame.fadeVblDelta = rhApp.newGetCptVbl() - rhVBLOld;
					this.y_KillLevel(true);
					this.rhEvtProg.unBranchPrograms();
				}
			}

			if (quit == CRun.LOOPEXIT_NEXTLEVEL || quit == CRun.LOOPEXIT_PREVLEVEL || quit == CRun.LOOPEXIT_GOTOLEVEL)
			{
				this.rhApp.transitionOldSurface = document.createElement("canvas");
				this.rhApp.transitionOldSurface.width = this.rhApp.gaCxWin;
				this.rhApp.transitionOldSurface.height = this.rhApp.gaCyWin;
				var renderer = new StandardRenderer(this.rhApp.transitionOldSurface);

				if (this.rhApp.frame.leClearBackground) renderer.clearBackground(0, 0, this.gaCxWin, this.gaCyWin);
				else renderer.renderSolidColor(0, 0, this.gaCxWin, this.gaCyWin, this.frameColor);

				renderer.renderSolidColor(0, 0, this.rhApp.gaCxWin, this.rhApp.gaCyWin, this.rhApp.frameColor);
				this.rhApp.mainSprite.draw(renderer, 0, 0);
			}

			if (quit != 0)
			{
				var frame = 0;
				switch (quit)
				{
					case 5:
						this.pause();
						this.rhApp.keyNew = false;
						this.quitPause = true;
						quit = 0;
						break;

					case 101:
						if (this.rhFrame.fade)
							break;
						this.f_StopSamples();
						this.killFrameObjects();
						this.y_KillLevel(false);
						this.resetFrameLayers(-1, false);
						this.rhEvtProg.unBranchPrograms();
						this.freeMouse();
						this.freeRunHeader();

						this.rhFrame.leX = this.rhFrame.leLastScrlX = this.rh3DisplayX = 0;
						this.rhFrame.leY = this.rhFrame.leLastScrlY = this.rh3DisplayY = 0;
						this.rhApp.resetLayers();
						this.allocRunHeader();
						this.initAsmLoop();
						this.resetFrameLayers(-1, false);
						this.prepareFrame();
						this.createFrameObjects(false);
						this.drawLevel();
						this.loadGlobalObjectsData();
						this.rhEvtProg.prepareProgram();
						this.rhEvtProg.assemblePrograms(this);
						this.f_InitLoop();
						//				this.rhEvtProg.HandleKeyRepeat();
						this.showMouse();
						this.captureMouse();
						quit = 0;
						this.rhQuitParam = 0;
						break;

					case 100:
					case -2:
						this.rhEvtProg.handle_GlobalEvents(((-4 << 16) | 65533));
						break;

				}
			}
			this.rhQuit = quit;
			return quit;
		},

		killRunLoop:  function (bLeaveSamples)
		{
			var quitParam;

			// Filtre les codes internes
			if (this.rhQuit > 100)
			{
				this.rhQuit = CRun.LOOPEXIT_ENDGAME;
			}
			quitParam = this.rhQuitParam;
			this.saveGlobalObjectsData();
			this.killFrameObjects();

			this.y_KillLevel(bLeaveSamples);
			this.rhEvtProg.unBranchPrograms();
			this.freeRunHeader();
			this.freeMouse();
			this.resetFrameLayers(-1, true);
			this.rhApp.endJoystick();

			return (CServices.MAKELONG(this.rhQuit, quitParam));
		},
		initAsmLoop:  function ()
		{
			var i;
			for (i = 0; i < this.rhMaxObjects; i++)
				this.rhObjectList[i] = null;
		},
		prepareFrame: function ()
		{
			var oiPtr;
			var ocPtr;
			var n, type;

			this.rhGameFlags |= CRun.GAMEFLAGS_LOADONCALL;
			this.rhGameFlags |= CRun.GAMEFLAGS_INITIALISING;

			this.rh2CreationCount = 0;

			var loPtr;
			var count = 0;
			this.rhOiList = new Array(this.rhMaxOI);
			this.rhMouseUsed = 0;
			for (oiPtr = this.rhApp.OIList.getFirstOI(); oiPtr != null; oiPtr = this.rhApp.OIList.getNextOI())
			{
				type = oiPtr.oiType;
				if (type >= COI.OBJ_SPR)
				{
					this.rhOiList[count] = new CObjInfo();
					this.rhOiList[count].copyData(oiPtr);

					this.rhOiList[count].oilHFII = -1;
					if (type == COI.OBJ_TEXT || type == COI.OBJ_QUEST)
					{
						for (loPtr = this.rhFrame.LOList.first_LevObj(); loPtr != null; loPtr = this.rhFrame.LOList.next_LevObj())
						{
							if (loPtr.loOiHandle == this.rhOiList[count].oilOi)
							{
								this.rhOiList[count].oilHFII = loPtr.loHandle;
								break;
							}
						}
					}
					count++;

					ocPtr = oiPtr.oiOC;
					if ((ocPtr.ocOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0 && ocPtr.ocMovements != null)
					{
						for (n = 0; n < ocPtr.ocMovements.nMovements; n++)
						{
							var mvPtr = ocPtr.ocMovements.moveList[n];
							if (mvPtr.mvType == CMoveDef.MVTYPE_MOUSE)
							{
								this.rhMouseUsed |= 1 << (mvPtr.mvControl - 1);
							}
						}
					}
				}
			}

			var i;
			for (i = 0; i < this.rhFrame.nLayers; i++)
			{
				this.rhFrame.layers[i].nZOrderMax = 1;
			}
			return 0;
		},

		createRemainingFrameObjects: function ()
		{
			var error = 0;
			var num;
			var oiPtr;
			var ocPtr;
			var type;
			var n;
			var creatFlags;
			var loPtr;

			this.rhGameFlags &= ~CRun.GAMEFLAGS_FIRSTLOOPFADEIN;

			for (n = 0, loPtr = this.rhFrame.LOList.first_LevObj(); loPtr != null; n++, loPtr = this.rhFrame.LOList.next_LevObj())
			{
				oiPtr = this.rhApp.OIList.getOIFromHandle(loPtr.loOiHandle);
				ocPtr = oiPtr.oiOC;
				type = oiPtr.oiType;

				if (type < COI.KPX_BASE)
				{
					continue;
				}
				if ((ocPtr.ocOEFlags & CObjectCommon.OEFLAG_RUNBEFOREFADEIN) != 0)
				{
					continue;
				}

				creatFlags = CRun.COF_CREATEDATSTART;

				// Objet pas dans le bon mode || cree au milieu du jeu. SKIP
				if (loPtr.loParentType != CLO.PARENT_NONE)
				{
					continue;
				}

				// Objet iconise non texte . SKIP
				if ((ocPtr.ocFlags2 & CObjectCommon.OCFLAGS2_VISIBLEATSTART) == 0)
				{
					if (type != COI.OBJ_TEXT)
					{
						continue;
					}
					creatFlags |= CRun.COF_HIDDEN;
				}

				// Creation de l'objet                
				if ((ocPtr.ocOEFlags & CObjectCommon.OEFLAG_DONTCREATEATSTART) == 0)
				{
					this.f_CreateObject(loPtr.loHandle, loPtr.loOiHandle, 0x80000000, 0x80000000, -1, creatFlags, -1, -1);
				}
			}
			this.rhEvtProg.assemblePrograms(this);

			// Remet le timer
			var date = new Date();
			this.rhTimerOld = date.getTime() - this.fadeTimerDelta;
			// TODO rhVBLOld = (rhApp.newGetCptVbl() - rhFrame.fadeVblDelta);
		},

		createFrameObjects: function (fade)
		{
			var oiPtr;
			var ocPtr;
			var type;
			var n;
			var creatFlags;
			var loPtr;

			for (n = 0, loPtr = this.rhFrame.LOList.first_LevObj(); loPtr != null; n++, loPtr = this.rhFrame.LOList.next_LevObj())
			{
				oiPtr = this.rhApp.OIList.getOIFromHandle(loPtr.loOiHandle);
				ocPtr = oiPtr.oiOC;
				type = oiPtr.oiType;

				creatFlags = CRun.COF_CREATEDATSTART;

				if (loPtr.loParentType != CLO.PARENT_NONE)
					continue;

				if (type == COI.OBJ_TEXT)
					creatFlags |= CRun.COF_FIRSTTEXT;

				if ((ocPtr.ocFlags2 & CObjectCommon.OCFLAGS2_VISIBLEATSTART) == 0)
				{
					if (type == COI.OBJ_QUEST)
						continue;
					creatFlags |= CRun.COF_HIDDEN;
				}
				if (fade)
				{
					if (type >= COI.KPX_BASE)
					{
						if ((ocPtr.ocOEFlags & CObjectCommon.OEFLAG_RUNBEFOREFADEIN) == 0)
						{
							continue;
						}
					}
				}

				if ((ocPtr.ocOEFlags & CObjectCommon.OEFLAG_DONTCREATEATSTART) == 0)
				{
					this.f_CreateObject(loPtr.loHandle, loPtr.loOiHandle, 0x80000000, 0x80000000, -1, creatFlags, -1, -1);
				}
			}
			this.rhGameFlags &= ~CRun.GAMEFLAGS_INITIALISING;
		},
		killFrameObjects:   function ()
		{
			var n;
			for (n = 0; n < this.rhMaxObjects && this.rhNObjects != 0; n++)
			{
				if (this.rhObjectList[n] != null)
				{
					var pHo = this.rhObjectList[n];
					if (pHo.hoType < 32 || pHo.hoCommon.ocIdentifier != CRun.BASEIDENTIFIER)
						this.f_KillObject(n, true);
				}
			}

			for (n = 0; n < this.rhMaxObjects && this.rhNObjects != 0; n++)
			{
				if (this.rhObjectList[n] != null)
				{
					var pHo = this.rhObjectList[n];
					if (pHo.hoType >= 32 && pHo.hoCommon.ocIdentifier == CRun.BASEIDENTIFIER)
						this.f_KillObject(n, true);
				}
			}
		},

		y_KillLevel:      function (bLeaveSamples)
		{
			if (!bLeaveSamples)
			{
				if ((this.rhApp.gaNewFlags & CRunApp.GANF_SAMPLESOVERFRAMES) == 0)
				{
					this.rhApp.soundPlayer.stopAllSounds();
				}
				else
				{
					this.rhApp.soundPlayer.keepCurrentSounds();
				}
			}
		},
		resetFrameLayers: function (nLayer, bDeleteFrame)
		{
			var i, nLayers;

			if (nLayer == -1)
			{
				i = 0;
				nLayers = this.rhFrame.nLayers;
			}
			else
			{
				i = nLayer;
				nLayers = (nLayer + 1);
			}

			for (i = 0; i < nLayers; i++)
			{
				var pLayer = this.rhFrame.layers[i];

				pLayer.reset();
				pLayer.deleteBackObjects();
				if (bDeleteFrame)
				{
					pLayer.deletePlanes();
				}
			}
		},

		captureMouse:   function ()
		{
			if (this.rhMouseUsed != 0)
			{
				this.setCursorCount(-1);
			}
		},
		freeMouse:      function ()
		{
			if (this.rhMouseUsed != 0)
			{
				this.setCursorCount(0);
			}
		},
		setCursorCount: function (count)
		{
			if (count >= 0)
				this.rhApp.showCursor(1);
			else
				this.rhApp.showCursor(-1);
		},
		showMouse:      function ()
		{
			this.rhApp.showCursor(1);
		},
		hideMouse:      function ()
		{
			this.rhApp.showCursor(-1);
		},
		addFastLoop: function(name)
		{
			var pLoop;
			var index;
			for (index = 0; index < this.rh4FastLoops.size(); index++)
			{
				pLoop = this.rh4FastLoops.get(index);
				if (CServices.compareStringsIgnoreCase(pLoop.name, name))
					break;
			}
			if (index == this.rh4FastLoops.size())
			{
				var loop = new CLoop();
				this.rh4FastLoops.add(loop);
				index = this.rh4FastLoops.size() - 1;
				loop.name = name;
				loop.flags = 0;
			}
			return index;
		},
		saveGlobalObjectsData: function ()
		{
			var hoPtr;
			var oilPtr;
			var oil, obj;
			var oiPtr;
			var name;
			var o;

			for (oil = 0; oil < this.rhOiList.length; oil++)
			{
				oilPtr = this.rhOiList[oil];

				o = oilPtr.oilObject;
				if (oilPtr.oilOi != 0x7FFF && (o & 0x80000000) == 0)
				{
					oiPtr = this.rhApp.OIList.getOIFromHandle(oilPtr.oilOi);

					if ((oiPtr.oiFlags & COI.OIF_GLOBAL) != 0)
					{
						hoPtr = this.rhObjectList[o];

						if (oilPtr.oilType != COI.OBJ_TEXT && oilPtr.oilType != COI.OBJ_COUNTER && hoPtr.rov == null)
							continue;

						name = oilPtr.oilName + oilPtr.oilType.toString();

						if (this.rhApp.adGO == null)
						{
							this.rhApp.adGO = new CArrayList();
						}

						var flag = false;
						var save = null;
						for (obj = 0; obj < this.rhApp.adGO.size(); obj++)
						{
							save = this.rhApp.adGO.get(obj);
							if (name == save.name)
							{
								flag = true;
								break;
							}
						}
						if (flag == false)
						{
							save = new CSaveGlobal();
							save.name = name;
							save.objects = new CArrayList();
							this.rhApp.adGO.add(save);
						}
						else
						{
							save.objects.clear();
						}

						var n;
						while (true)
						{
							hoPtr = this.rhObjectList[o];

							if (oilPtr.oilType == COI.OBJ_TEXT)
							{
								var saveText = new CSaveGlobalText();
								saveText.text = hoPtr.rsTextBuffer;
								saveText.rsMini = hoPtr.rsMini;
								save.objects.add(saveText);
							}
							else if (oilPtr.oilType == COI.OBJ_COUNTER)
							{
								var saveCounter = new CSaveGlobalCounter();
								saveCounter.value = hoPtr.rsValue;
								saveCounter.rsMini = hoPtr.rsMini;
								saveCounter.rsMaxi = hoPtr.rsMaxi;
								saveCounter.rsMiniDouble = hoPtr.rsMiniDouble;
								saveCounter.rsMaxiDouble = hoPtr.rsMaxiDouble;
								save.objects.add(saveCounter);
							}
							else
							{
								var saveValues = new CSaveGlobalValues();
								saveValues.flags = hoPtr.rov.rvValueFlags;
								saveValues.values = new Array(hoPtr.rov.rvValues.length);
								for (n = 0; n < hoPtr.rov.rvValues.length; n++)
								{
									saveValues.values[n] = hoPtr.rov.rvValues[n];
								}
								saveValues.strings = new Array(hoPtr.rov.rvStrings.length);
								for (n = 0; n < hoPtr.rov.rvStrings.length; n++)
								{
									saveValues.strings[n] = hoPtr.rov.rvStrings[n];
								}
								save.objects.add(saveValues);
							}

							o = hoPtr.hoNumNext;
							if ((o & 0x80000000) != 0)
								break;
						}
					}
				}
			}
		},

		loadGlobalObjectsData: function ()
		{
			var hoPtr;
			var oilPtr;
			var oil, obj;
			var oiPtr;
			var name;
			var o;

			if (this.rhApp.adGO == null)
				return;

			for (oil = 0; oil < this.rhOiList.length; oil++)
			{
				oilPtr = this.rhOiList[oil];

				o = oilPtr.oilObject;
				if (oilPtr.oilOi != 0x7FFF && o >= 0)
				{
					oiPtr = this.rhApp.OIList.getOIFromHandle(oilPtr.oilOi);

					if ((oiPtr.oiFlags & COI.OIF_GLOBAL) != 0)
					{
						name = oilPtr.oilName + oilPtr.oilType.toString();

						for (obj = 0; obj < this.rhApp.adGO.size(); obj++)
						{
							var save = this.rhApp.adGO.get(obj);
							if (name == save.name)
							{
								var count = 0;
								while (true)
								{
									hoPtr = this.rhObjectList[o];

									if (oilPtr.oilType == COI.OBJ_TEXT)
									{
										var saveText = save.objects.get(count);
										hoPtr.rsTextBuffer = saveText.text;
										hoPtr.rsMini = saveText.rsMini;
										hoPtr.roc.rcChanged = true;
										hoPtr.bTxtChanged = true;
									}
									else if (oilPtr.oilType == COI.OBJ_COUNTER)
									{
										var saveCounter = save.objects.get(count);
										hoPtr.rsValue = saveCounter.value;
										hoPtr.rsMini = saveCounter.rsMini;
										hoPtr.rsMaxi = saveCounter.rsMaxi;
										hoPtr.rsMiniDouble = saveCounter.rsMiniDouble;
										hoPtr.rsMaxiDouble = saveCounter.rsMaxiDouble;
										hoPtr.bCounterChanged = true;
										hoPtr.roc.rcChanged = true;
									}
									else
									{
										var saveValues = save.objects.get(count);
										hoPtr.rov.rvValueFlags = saveValues.flags;
										hoPtr.rov.growValues(saveValues.values.length);
										hoPtr.rov.growStrings(saveValues.strings.length);
										var n;
										for (n = 0; n < saveValues.values.length; n++)
										{
											hoPtr.rov.rvValues[n] = saveValues.values[n];
										}
										for (n = 0; n < saveValues.strings.length; n++)
										{
											hoPtr.rov.rvStrings[n] = saveValues.strings[n];
										}
									}

									o = hoPtr.hoNumNext;
									if ((o & 0x80000000) != 0)
										break;

									count++;
									if (count >= save.objects.size())
										break;
								}
								break;
							}
						}
					}
				}
			}
		},

		f_CreateObject: function (hlo, oi, coordX, coordY, initDir, flags, nLayer, numCreation)
		{
			while (true)
			{
				var cob = new CCreateObjectInfo();

				var loPtr = null;
				if (hlo != -1)
					loPtr = this.rhFrame.LOList.getLOFromHandle(hlo);

				var oiPtr = this.rhApp.OIList.getOIFromHandle(oi);
				var ocPtr = oiPtr.oiOC;

				if ((ocPtr.ocFlags2 & CObjectCommon.OCFLAGS2_VISIBLEATSTART) == 0)
				{
					flags |= CRun.COF_HIDDEN;
				}

				if (this.rhNObjects >= this.rhMaxObjects)
					break;

				var hoPtr = null;
				var proto = new CObject();
				switch (oiPtr.oiType)
				{
					case 2:
						hoPtr = new CActive();
						break;
					case 3:
						hoPtr = new CText();
						break;
					case 4:
						hoPtr = new CQuestion();
						break;
					case 5:
						hoPtr = new CScore();
						break;
					case 6:
						hoPtr = new CLives();
						break;
					case 7:
						hoPtr = new CCounter();
						break;
					case 8:
						//	                    hoPtr=new CRtf();
						break;
					case 9:
						hoPtr = new CCCA();
						break;
					default:
						hoPtr = new CExtension(oiPtr.oiType, this);
						if (hoPtr.ext == null)
						{
							hoPtr = null;
						}
						break;
				}
				if (hoPtr == null)
					break;
				hoPtr.prototype = proto;
				hoPtr.lo = loPtr;

				if (numCreation < 0)
				{
					for (numCreation = 0; numCreation < this.rhMaxObjects; numCreation++)
					{
						if (this.rhObjectList[numCreation] == null)
						{
							break;
						}
					}
				}
				if (numCreation >= this.rhMaxObjects)
				{
					return -1;
				}
				this.rhObjectList[numCreation] = hoPtr;
				this.rhNObjects++;
				hoPtr.hoIdentifier = ocPtr.ocIdentifier;
				hoPtr.hoOEFlags = ocPtr.ocOEFlags;

				if (numCreation > this.rh4ObjectCurCreate)
					this.rh4ObjectAddCreate++;

				hoPtr.hoNumber = numCreation;
				this.rh2CreationCount++;
				if (this.rh2CreationCount == 0)
					this.rh2CreationCount = 1;
				hoPtr.hoCreationId = this.rh2CreationCount;
				hoPtr.hoOi = oi;
				hoPtr.hoHFII = hlo;
				hoPtr.hoType = oiPtr.oiType;
				this.oi_Insert(hoPtr);
				hoPtr.hoAdRunHeader = this;
				hoPtr.hoCallRoutine = true;

				hoPtr.hoCommon = ocPtr;

				var x = coordX;									// X
				if (x == 0x80000000)
					x = loPtr.loX;
				cob.cobX = x;
				hoPtr.hoX = x;

				var y = coordY;									// Y
				if (y == 0x80000000)
					y = loPtr.loY;
				cob.cobY = y;
				hoPtr.hoY = y;

				if (loPtr != null)
				{
					if (nLayer == -1)
					{
						nLayer = loPtr.loLayer;
					}
				}
				cob.cobLayer = nLayer;
				hoPtr.hoLayer = nLayer;

				var pLayer = this.rhFrame.layers[nLayer];
				pLayer.nZOrderMax++;
				cob.cobZOrder = pLayer.nZOrderMax;

				cob.cobFlags = flags;
				cob.cobDir = initDir;
				cob.cobLevObj = loPtr;

				hoPtr.roc = null;
				if ((hoPtr.hoOEFlags & (CObjectCommon.OEFLAG_ANIMATIONS | CObjectCommon.OEFLAG_MOVEMENTS | CObjectCommon.OEFLAG_SPRITES)) != 0)
				{
					hoPtr.roc = new CRCom();
					hoPtr.roc.init();
				}

				hoPtr.rom = null;
				if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0)
				{
					hoPtr.rom = new CRMvt();
					if ((cob.cobFlags & CRun.COF_NOMOVEMENT) == 0)
					{
						hoPtr.rom.init(0, hoPtr, ocPtr, cob, -1);
					}
				}

				hoPtr.roa = null;
				if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_ANIMATIONS) != 0)
				{
					hoPtr.roa = new CRAni();
					hoPtr.roa.init(hoPtr);
				}

				hoPtr.ros = null;
				if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_SPRITES) != 0)
				{
					hoPtr.ros = new CRSpr();
					hoPtr.ros.init1(hoPtr, ocPtr, cob);
				}

				hoPtr.rov = null;
				if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_VALUES) != 0)
				{
					hoPtr.rov = new CRVal();
					hoPtr.rov.init(hoPtr, ocPtr, cob);
				}

				hoPtr.init(ocPtr, cob);

				if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_SPRITES) != 0)
				{
					hoPtr.ros.init2(true);
				}

				if (this.rhLoopCount >= 1)
					hoPtr.callComputeNewDisplay();

				return numCreation;
			}
			return -1;
		},

		f_KillObject: function (nObject, bFast)
		{
			var hoPtr = this.rhObjectList[nObject];
			if (hoPtr == null)
			{
				return;
			}

			if (bFast == true && hoPtr.hoCreationId == 0)
			{
				this.rhObjectList[nObject] = null;
				this.rhNObjects--;
				return;
			}

			this.killShootPtr(hoPtr);

			if (hoPtr.rom != null)
				hoPtr.rom.kill(bFast);
			if (hoPtr.rov != null)
				hoPtr.rov.kill(bFast);
			if (hoPtr.ros != null)
				hoPtr.ros.kill(bFast);
			if (hoPtr.roc != null)
				hoPtr.roc.kill(bFast);

			hoPtr.kill(bFast);

			this.oi_Delete(hoPtr);

			this.rhObjectList[nObject] = null;

			this.rhNObjects--;

		},

		destroy_Add: function (hoNumber)
		{
			var pos = Math.floor(hoNumber / 32);
			var bit = 1 << (hoNumber & 31);
			this.rhDestroyList[pos] |= bit;
			this.rhDestroyPos++;
		},

		destroy_List: function ()
		{
			if (this.rhDestroyPos == 0)
			{
				return;
			}

			var nob = 0;
			var dw;
			var count;
			while (nob < this.rhMaxObjects)
			{
				dw = this.rhDestroyList[nob / 32];
				if (dw != 0)
				{
					this.rhDestroyList[nob / 32] = 0;
					for (count = 0; dw != 0 && count < 32; count++)
					{
						if ((dw & 1) != 0)
						{
							var pHo = this.rhObjectList[nob + count];
							if (pHo != null)
							{
								if (pHo.hoOiList.oilNObjects == 1)
								{
									this.rhEvtProg.handle_Event(pHo, (pHo.hoType | (-33 << 16)));
								}
							}
							this.f_KillObject(nob + count, false);
							this.rhDestroyPos--;
						}
						dw = dw >> 1;
					}
					if (this.rhDestroyPos == 0)
					{
						return;
					}
				}
				nob += 32;
			}
		},

		killShootPtr: function (hoSource)
		{
			var count = 0;
			var nObject;
			var hoPtr;
			for (nObject = 0; nObject < this.rhNObjects; nObject++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				hoPtr = this.rhObjectList[count];
				count++;

				if (hoPtr.rom != null)
				{
					if (hoPtr.roc.rcMovementType == CMoveDef.MVTYPE_BULLET)
					{
						var mBullet = hoPtr.rom.rmMovement;
						if (mBullet.MBul_ShootObject == hoSource && mBullet.MBul_Wait == true)
						{
							mBullet.startBullet();
						}
					}
				}
			}
		},

		callComputeNewDisplay: function ()
		{
			var nObject;
			var hoPtr;
			var count;
			for (nObject = 0, count = 0; nObject < this.rhNObjects; nObject++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				hoPtr = this.rhObjectList[count];
				count++;
				hoPtr.createFont();
			}
			for (nObject = 0, count = 0; nObject < this.rhNObjects; nObject++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				hoPtr = this.rhObjectList[count];
				count++;
				hoPtr.callComputeNewDisplay();
			}
		},

		oi_Insert: function (pHo)
		{
			var oi = pHo.hoOi;

			var num;
			for (num = 0; num < this.rhMaxOI; num++)
			{
				if (this.rhOiList[num].oilOi == oi)
				{
					break;
				}
			}
			var poil = this.rhOiList[num];

			if ((poil.oilObject & 0x80000000) != 0)
			{
				poil.oilObject = pHo.hoNumber;
				pHo.hoNumPrev = (num | 0x80000000);
				pHo.hoNumNext = 0x80000000;
			}
			else
			{
				var pHo2 = this.rhObjectList[poil.oilObject];
				pHo.hoNumPrev = pHo2.hoNumPrev;
				pHo2.hoNumPrev = pHo.hoNumber;
				pHo.hoNumNext = pHo2.hoNumber;
				poil.oilObject = pHo.hoNumber;
			}

			pHo.hoEvents = poil.oilEvents;
			pHo.hoOiList = poil;
			pHo.hoLimitFlags = poil.oilLimitFlags;
			if (pHo.hoHFII == -1)
				pHo.hoHFII = poil.oilHFII;
			else
			{
				if (poil.oilHFII == -1)
					poil.oilHFII = pHo.hoHFII;
			}
			poil.oilNObjects += 1;
		},

		oi_Delete: function (pHo)
		{
			var poil = pHo.hoOiList;
			poil.oilNObjects -= 1;

			var pHo2;
			if ((pHo.hoNumPrev & 0x80000000) == 0)
			{
				pHo2 = this.rhObjectList[pHo.hoNumPrev];
				if ((pHo.hoNumNext & 0x80000000) == 0)
				{
					var pHo3 = this.rhObjectList[pHo.hoNumNext];
					if (pHo2 != null)
						pHo2.hoNumNext = pHo.hoNumNext;
					if (pHo3 != null)
						pHo3.hoNumPrev = pHo.hoNumPrev;
				}
				else
				{
					if (pHo2 != null)
						pHo2.hoNumNext = 0x80000000;
				}
			}
			else
			{
				if ((pHo.hoNumNext & 0x80000000) == 0)
				{
					pHo2 = this.rhObjectList[pHo.hoNumNext];
					if (pHo2 != null)
					{
						pHo2.hoNumPrev = pHo.hoNumPrev;
						poil.oilObject = pHo2.hoNumber;
					}
				}
				else
				{
					poil.oilObject = 0x80000000;
				}
			}
		},

		CreateBodies: function ()
		{
			var pBase = this.GetBase();
			if (pBase == null)
				return;

			var pOL = 0;
			var nObjects;
			for (nObjects = 0; nObjects < this.rhNObjects; pOL++, nObjects++)
			{
				while (this.rhObjectList[pOL] == null) pOL++;
				var pHo = this.rhObjectList[pOL];
				if (pHo.hoType >= 32)
				{
					if (pHo.hoCommon.ocIdentifier == CRun.FANIDENTIFIER
						|| pHo.hoCommon.ocIdentifier == CRun.TREADMILLIDENTIFIER
						|| pHo.hoCommon.ocIdentifier == CRun.PARTICULESIDENTIFIER
						|| pHo.hoCommon.ocIdentifier == CRun.ROPEANDCHAINIDENTIFIER
						|| pHo.hoCommon.ocIdentifier == CRun.MAGNETIDENTIFIER)
					{
						pHo.ext.rStartObject();
					}
					else if (pHo.hoCommon.ocIdentifier == CRun.BASEIDENTIFIER)
					{
						pHo.ext.rStartObject();
					}
				}
			}
			pOL = 0;
			for (nObjects = 0; nObjects < this.rhNObjects; pOL++, nObjects++)
			{
				while (this.rhObjectList[pOL] == null) pOL++;
				var pHo = this.rhObjectList[pOL];
				if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0)
				{
					var flag = false;
					if (pHo.roc.rcMovementType == CMoveDef.MVTYPE_EXT)
					{
						var mvPtr = (pHo.hoCommon.ocMovements.moveList[pHo.rom.rmMvtNum]);
						if (CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2d8directions')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dspring')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dspaceship')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dstatic')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dracecar')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2daxial')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dplatform')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dbouncingball')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dbackground')
							)
						{
							pHo.rom.rmMovement.movement.CreateBody();
							flag = true;
						}
					}
					if (flag == false && pHo.hoType == 2)
					{
						pBase.rAddNormalObject(pHo);
					}
				}
			}
			pOL = 0;
			for (nObjects = 0; nObjects < this.rhNObjects; pOL++, nObjects++)
			{
				while (this.rhObjectList[pOL] == null) pOL++;
				var pHo = this.rhObjectList[pOL];
				if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0)
				{
					if (pHo.roc.rcMovementType == CMoveDef.MVTYPE_EXT)
					{
						var mvPtr = (pHo.hoCommon.ocMovements.moveList[pHo.rom.rmMvtNum]);
						if (CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2d8directions')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dspring')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dspaceship')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dstatic')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dracecar')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2daxial')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dplatform')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dbouncingball')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dbackground')
							)
						{
							pHo.rom.rmMovement.movement.CreateJoint();
						}
					}
				}
			}
		},

		GetBase: function ()
		{
			if (this.rh4Box2DSearched == false)
			{
				this.rh4Box2DSearched = true;
				this.rh4Box2DBase = null;

				var pOL = 0;
				var nObjects;
				for (nObjects = 0; nObjects < this.rhNObjects; pOL++, nObjects++)
				{
					while (this.rhObjectList[pOL] == null) pOL++;
					var pHo = this.rhObjectList[pOL];
					if (pHo.hoType >= 32)
					{
						if (pHo.hoCommon.ocIdentifier == CRun.BASEIDENTIFIER)
						{
							this.rh4Box2DBase = pHo.ext;
							break;
						}
					}
				}
			}
			return this.rh4Box2DBase;
		},

		GetMBase: function (pHo)
		{
			if (pHo && (pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
			{
				if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0)
				{
					if (pHo.roc.rcMovementType == CMoveDef.MVTYPE_EXT)
					{
						var mvPtr = (pHo.hoCommon.ocMovements.moveList[pHo.rom.rmMvtNum]);
						if (CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2d8directions')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dspring')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dspaceship')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dstatic')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dracecar')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2daxial')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dplatform')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dbouncingball')
							|| CServices.compareStringsIgnoreCase(mvPtr.moduleName, 'box2dbackground')
							)
						{
							return pHo.rom.rmMovement.movement;
						}
					}
				}
			}
			return null;
		},

	    // Build 283.2: add fans, treadmills and magnet to engine
	    // Build 286.0: add ropes too
		addPhysicsAttractor: function(pObject)
		{
		    if (pObject.hoCommon.ocIdentifier == CRun.FANIDENTIFIER || pObject.hoCommon.ocIdentifier == CRun.TREADMILLIDENTIFIER || pObject.hoCommon.ocIdentifier == CRun.MAGNETIDENTIFIER || pObject.hoCommon.ocIdentifier == CRun.ROPEANDCHAINIDENTIFIER)
			{
				var pOL=0;
				var nObjects;
				for (nObjects = 0; nObjects < this.rhNObjects; pOL++, nObjects++)
				{
					while (this.rhObjectList[pOL] == null) pOL++;
					var pBase = this.rhObjectList[pOL];
					if (pBase.hoType>=32 && pBase.hoCommon.ocIdentifier==CRun.BASEIDENTIFIER)
					{
						if (pObject.hoCommon.ocIdentifier == CRun.FANIDENTIFIER)
						{
							if ( pObject.ext.identifier == pBase.ext.identifier)
								pBase.ext.fans.add(pObject.ext);
						}
						else if (pObject.hoCommon.ocIdentifier == CRun.TREADMILLIDENTIFIER)
						{
							if ( pObject.ext.identifier == pBase.ext.identifier)
								pBase.ext.treadmills.add(pObject.ext);
						}
						else if (pObject.hoCommon.ocIdentifier == CRun.MAGNETIDENTIFIER)
						{
							if ( pObject.ext.identifier == pBase.ext.identifier)
								pBase.ext.magnets.add(pObject.ext);
						}
						else if (pObject.hoCommon.ocIdentifier == CRun.ROPEANDCHAINIDENTIFIER)
						{
						    if (pObject.ext.identifier == pBase.ext.identifier)
						        pBase.ext.ropes.add(pObject.ext);
						}
	                }
				}

		        // Object added to base list, now add the physical objects to the fan/treadmill/magnet list
				if (pObject.hoCommon.ocIdentifier != CRun.ROPEANDCHAINIDENTIFIER)
	            {
			        pOL=0;
			        for (nObjects = 0; nObjects < this.rhNObjects; pOL++, nObjects++)
			        {
				        while (this.rhObjectList[pOL] == null) pOL++;
				        var pActive=this.rhObjectList[pOL];
				        if ( pActive.hoType == COI.OBJ_SPR )
				        {
					        var pMBase = this.GetMBase(pActive);
					        if ( pMBase )
					        {
						        pObject.ext.rAddObject(pMBase);
					        }
				        }
			        }
	            }
		    }
		},

		getDir: function (hoPtr)
		{
			if (hoPtr.rom != null)
				if (hoPtr.rom.rmMovement != null)
					return hoPtr.rom.rmMovement.getDir();
			return hoPtr.roc.rcDir;
		},

		pause: function (bKeepSounds)
		{
			if (this.rh2PauseCompteur == 0)
			{
				this.rh2PauseCompteur = 1;

				this.rh2PauseTimer = this.rhApp.timer;

				var count = 0;
				var no;
				for (no = 0; no < this.rhNObjects; no++)
				{
					while (this.rhObjectList[count] == null)
						count++;
					var hoPtr = this.rhObjectList[count];
					count++;
					if (hoPtr.hoType >= COI.KPX_BASE)
					{
						hoPtr.ext.pauseRunObject();
					}
				}

				if (!bKeepSounds)
					this.rhApp.soundPlayer.pause();

				// TODO		   Mouse.show();		   
				//		   	this.rhApp.keyNew=false;
			}
		},

		resume: function ()
		{
			if (!this.noResume && this.rh2PauseCompteur != 0)
			{
				this.rh2PauseCompteur = 0;
				this.captureMouse();

				var count = 0;
				var no;
				for (no = 0; no < this.rhNObjects; no++)
				{
					while (this.rhObjectList[count] == null)
						count++;
					var hoPtr = this.rhObjectList[count];
					count++;
					if (hoPtr.hoType >= COI.KPX_BASE)
					{
						hoPtr.ext.continueRunObject();
					}
				}

				this.rhApp.soundPlayer.resume();

				// TODO     this.rhApp.flushKeyboard();

				var tick = this.rhApp.timer;
				tick -= this.rh2PauseTimer;
				this.rhTimerOld += tick;
				this.rh4PauseKey = 0;
				this.quitPause = false;
			}
		},

		f_StopSamples: function ()
		{
			this.rhApp.soundPlayer.stopAllSounds();
		},

		autoResize: function ()
		{
			var count = 0;
			var no;
			for (no = 0; no < this.rhNObjects; no++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				var hoPtr = this.rhObjectList[count];
				count++;
				hoPtr.autoResize();
			}
		},

		/* TODO    
		 public function sendKey(keyCode, bState:Boolean):void
		 {
		 var count=0;
		 var no;
		 for (no=0; no<rhNObjects; no++)
		 {
		 while (rhObjectList[count]==null)
		 count++;
		 var hoPtr:CObject=rhObjectList[count];
		 count++;
		 if (hoPtr is CCCA)
		 {
		 var cca:CCCA=CCCA(hoPtr);
		 cca.sendKey(keyCode, bState);
		 }
		 }	
		 }
		 */

		find_HeaderObject: function (hlo)
		{
			var count = 0;
			var nObjects;
			for (nObjects = 0; nObjects < this.rhNObjects; nObjects++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				if (hlo == this.rhObjectList[count].hoHFII)
					return rhObjectList[count];
				count++;
			}
			return null;
		},

		check_Ladder: function (nLayer, x, y)
		{
			var prc = this.y_GetLadderAt(nLayer, x, y);
			if (prc != null)
			{
				return prc.top;
			}
			return CRun.INTBAD;
		},

		y_GetLadderAt: function (nLayer, x, y)
		{
			x -= this.rhWindowX;
			y -= this.rhWindowY;

			var nl;
			var nLayers;
			if (nLayer == -1)
			{
				nl = 0;
				nLayers = this.rhFrame.nLayers;
			}
			else
			{
				nl = nLayer;
				nLayers = (nLayer + 1);
			}
			for (; nl < nLayers; nl++)
			{
				var pLayer = this.rhFrame.layers[nl];
				var rc = pLayer.getLadderAt(x, y);
				if (rc != null)
				{
					return rc;
				}
			}
			return null;
		},

		f_InitLoop: function ()
		{
			var tick = this.rhApp.timer;
			this.rhTimerOld = tick;
			this.rhTimer = 0;

			this.rhLoopCount = 0;
			this.rh4LoopTheoric = 0;
			//	rh2PushedEvents=0;

			this.rhQuit = 0;
			this.rhQuitBis = 0;
			this.rhDestroyPos = 0;

			var n;
			for (n = 0; n < (this.rhMaxObjects + 31) / 32; n++)
				this.rhDestroyList[n] = 0;

			this.rh3WindowSx = this.rhFrame.leEditWinWidth;
			this.rh3WindowSy = this.rhFrame.leEditWinHeight;

			this.rh3XMinimumKill = -CRun.GAME_XBORDER;
			this.rh3YMinimumKill = -CRun.GAME_YBORDER;
			this.rh3XMaximumKill = this.rhLevelSx + CRun.GAME_XBORDER;
			this.rh3YMaximumKill = this.rhLevelSy + CRun.GAME_YBORDER;

			var dx = this.rhWindowX;
			this.rh3DisplayX = dx;
			dx -= CRun.COLMASK_XMARGIN;
			if (dx < 0)
				dx = this.rh3XMinimumKill;
			this.rh3XMinimum = dx;

			var dy = this.rhWindowY;
			this.rh3DisplayY = dy;
			dy -= CRun.COLMASK_YMARGIN;
			if (dy < 0)
				dy = this.rh3YMinimumKill;
			this.rh3YMinimum = dy;

			var wx = this.rhWindowX;
			wx += this.rh3WindowSx + CRun.COLMASK_XMARGIN;
			if (wx > this.rhLevelSx)
				wx = this.rh3XMaximumKill;
			this.rh3XMaximum = wx;

			var wy = this.rhWindowY;
			wy += this.rh3WindowSy + CRun.COLMASK_YMARGIN;
			if (wy > this.rhLevelSy)
				wy = this.rh3YMaximumKill;
			this.rh3YMaximum = wy;

			this.rh3Scrolling = 0;
			this.rh4DoUpdate = 0;
			this.rh4EventCount = 0;
			this.rh4TimeOut = 0;

			this.rh2PauseCompteur = 0;

			this.rh4FakeKey = 0;
			for (n = 0; n < 4; n++)
			{
				this.rhPlayer[n] = 0;
				this.rh2OldPlayer[n] = 0;
				this.rh2InputMask[n] = 0xFF;
			}
			this.rh2MouseKeys = 0;

			this.rhEvtProg.callEndForEach = false;
			this.rh4EndOfPause = -1;
			this.rh4OnMouseWheel = -1;
			this.rh4LoadCount = -1;
			this.rhEvtProg.rh4CheckDoneInstart = false;
			this.rh4PauseKey = 0;
			this.rh4Box2DBase = null;
			this.rh4Box2DSearched = false;
			this.rh4ForEachs = null;
			this.rh4CurrentForEach = null;
			this.rh4CurrentForEach2 = null;
			this.rh4TimerEvents = null;

			// TODO rh4DemoMode=CDemoRecord.DEMONOTHING;
			//      rh4Demo=null;

			for (n = 0; n < CRun.MAX_FRAMERATE; n++)
				this.rh4FrameRateArray[n] = 20;
			this.rh4FrameRatePos = 0;
		},

		f_GameLoop: function ()
		{
			this.rhApp.soundPlayer.checkSounds();

		    // For some reason the event loop of subapps is called while the images are still loading O_o
	        // Wait for all the data to be loaded
		    if (this.rhApp.parentApp != null && this.rhApp.loading) {
		        this.rhTimerOld = this.rhApp.timer;
		        this.rhTimer = 0;
		        return this.rhQuit;
		    }

			if (!this.bodiesCreated)
			{
				this.CreateBodies();
				this.bodiesCreated = true;
			}

			var timerBase = this.rhApp.timer;
			var delta = timerBase - this.rhTimerOld;
			var oldtimer = this.rhTimer;
			this.rhTimer = delta;
			delta -= oldtimer;
			this.rhTimerDelta = delta;
			this.rh4TimeOut += delta;
			this.rhLoopCount += 1;
			this.rh4MvtTimerCoef = (this.rhTimerDelta * this.rhFrame.m_dwMvtTimerBase) / 1000.0;

			this.rh4FrameRateArray[this.rh4FrameRatePos] = delta;
			this.rh4FrameRatePos++;
			if (this.rh4FrameRatePos >= CRun.MAX_FRAMERATE)
				this.rh4FrameRatePos = 0;

			var n;
			for (n = 0; n < 4; n++)
			{
				this.rh2OldPlayer[n] = this.rhPlayer[n];
			}
			this.joyTest();
			if (this.rhApp.joystickOn == 1)
				this.rhPlayer[0] |= this.rhApp.joystick.getJoystick() & this.rhJoystickMask;
			else if (this.rhApp.joystickOn == 2)
				this.rhPlayer[0] |= this.rhApp.getJoystick() & this.rhJoystickMask;

			if (this.rhMouseUsed != 0)
			{
				this.getMouseCoords();

				this.rh2MouseKeys = 0;

				if (this.rhApp.keyBuffer[CRunApp.VK_LBUTTON])
					this.rh2MouseKeys |= 0x10;				//00010000B;

				if (this.rhApp.keyBuffer[CRunApp.VK_RBUTTON])
					this.rh2MouseKeys |= 0x20;				//00100000B;

				var mouseUsed = this.rhMouseUsed;
				for (n = 0; n < this.rhNPlayers; n++)
				{
					if ((this.mouseUsed & 1) != 0)
					{
						var key = (this.rhPlayer[n] & 0xCF);		//11001111B;
						key |= this.rh2MouseKeys;
						this.rhPlayer[n] = key;
					}
					mouseUsed >>= 1;
				}
			}
			else
			{
				this.getMouseCoords();
			}

			var b;
			for (n = 0; n < 4; n++)
			{
				b = (this.rhPlayer[n] & CRun.plMasks[this.rhNPlayers * 4 + n]);
				b &= this.rh2InputMask[n];
				this.rhPlayer[n] = b;
				b ^= this.rh2OldPlayer[n];
				this.rh2NewPlayer[n] = b;
				if (b != 0)
				{
					b &= this.rhPlayer[n];
					if ((b & 0xF0) != 0)
					{
						this.rhEvtProg.rhCurOi = n;
						b = this.rh2NewPlayer[n];
						if ((b & 0xF0) != 0)
						{
							this.rhEvtProg.rhCurParam0 = b;
							this.rhEvtProg.handle_GlobalEvents(((-4 << 16) | 0xFFF9));	// CNDL_JOYPRESSED);
						}
						if ((b & 0x0F) != 0)
						{
							this.rhEvtProg.rhCurParam0 = b;
							this.rhEvtProg.handle_GlobalEvents(((-4 << 16) | 0xFFF9));	// CNDL_JOYPRESSED);
						}
					}
					else
					{
						var num = this.rhEvtProg.listPointers[this.rhEvtProg.rhEvents[-COI.OBJ_PLAYER] + 4];		// -NUM_JOYPRESSEZD
						if (num != 0)
						{
							this.rhEvtProg.rhCurParam0 = b;
							this.rhEvtProg.computeEventList(num, null);
						}
					}
				}
			}

			if (this.rhNObjects != 0)
			{
				var cptObject = this.rhNObjects;
				var count = 0;
				do
				{
					this.rh4ObjectAddCreate = 0;
					while (this.rhObjectList[count] == null)
						count++;
					var pObject = this.rhObjectList[count];

					pObject.hoPrevNoRepeat = pObject.hoBaseNoRepeat;
					pObject.hoBaseNoRepeat = null;
					if (pObject.hoCallRoutine)
					{
						this.rh4ObjectCurCreate = count;
						pObject.handle();
					}
					cptObject += this.rh4ObjectAddCreate;
					count++;
					cptObject--;
				} while (cptObject != 0);
			}
			this.rh3CollisionCount++;

			this.rhEvtProg.compute_TimerEvents();
			this.rhEvtProg.handle_TimerEvents();

			if (this.rhEvtProg.rhEventAlways)
			{
				if ((this.rhGameFlags & CRun.GAMEFLAGS_FIRSTLOOPFADEIN) == 0)
					this.rhEvtProg.computeEventList(0, null);
			}
			this.rhEvtProg.handle_PushedEvents();

			this.destroy_List();
			this.doScroll();
			//		this.modif_ChangedObjects();

			this.rhEvtProg.rh2CurrentClick = -1;
			this.rh4EventCount++;
			this.rh4FakeKey = 0;

			if (this.rhQuit == 0)
			{
				return this.rhQuitBis;
			}

			if (this.rhQuit == CRun.LOOPEXIT_NEXTLEVEL ||
				this.rhQuit == CRun.LOOPEXIT_PREVLEVEL ||
				this.rhQuit == CRun.LOOPEXIT_ENDGAME ||
				this.rhQuit == CRun.LOOPEXIT_GOTOLEVEL ||
				this.rhQuit == CRun.LOOPEXIT_QUIT ||
				this.rhQuit == CRun.LOOPEXIT_NEWGAME)
			{
				this.rhEvtProg.handle_GlobalEvents((-2 << 16) | 0xFFFD);
			}
			return this.rhQuit;
		},

		/*    modif_ChangedObjects:function()
		 {
		 var count=0;
		 var no;
		 for (no=0; no<this.rhNObjects; no++)		// Des objets à voir?
		 {
		 while(this.rhObjectList[count]==null)
		 count++;
		 var pHo=this.rhObjectList[count];
		 count++;

		 if ( (pHo.hoOEFlags & (CObjectCommon.OEFLAG_ANIMATIONS|CObjectCommon.OEFLAG_MOVEMENTS|CObjectCommon.OEFLAG_SPRITES)) != 0 )
		 {
		 if ( pHo.roc.rcChanged )
		 {
		 pHo.roc.rcChanged=false;
		 }
		 }
		 }
		 },
		 */
		joyTest:    function ()
		{
			var i;

			for (i = 0; i < 4; i++)
				this.rhPlayer[i] = 0;

			//		var ctrlType=this.rhApp.getCtrlType();
			var ctrlKeys = this.rhApp.getCtrlKeys();

			for (i = 0; i < 4; i++)
			{
				var k;
				for (k = 0; k < CRunApp.MAX_KEY; k++)
				{
					if (this.rhApp.keyBuffer[ctrlKeys[i * CRunApp.MAX_KEY + k]])
						this.rhPlayer[i] |= 1 << k;
				}
			}
		},

		getMouseCoords: function ()
		{
		    this.rh2MouseX = this.rhApp.mouseX + this.rhWindowX - this.rhApp.xOffset;
		    this.rh2MouseY = this.rhApp.mouseY + this.rhWindowY - this.rhApp.yOffset;
		},

		newHandle_Collisions: function (pHo)
		{
			pHo.rom.rmMoveFlag = false;
			CRun.bMoveChanged = false;
			pHo.rom.rmEventFlags = 0;

			var cadran, cadran1, cadran2;
			var chgDir;
			if ((pHo.hoLimitFlags & CObjInfo.OILIMITFLAGS_QUICKBORDER) != 0)
			{
				cadran1 = this.quadran_In(pHo.roc.rcOldX1, pHo.roc.rcOldY1, pHo.roc.rcOldX2, pHo.roc.rcOldY2);
				if (cadran1 != 0)
				{
					cadran2 = this.quadran_In(pHo.hoX - pHo.hoImgXSpot, pHo.hoY - pHo.hoImgYSpot, pHo.hoX - pHo.hoImgXSpot + pHo.hoImgWidth, pHo.hoY - pHo.hoImgYSpot + pHo.hoImgHeight);
					if (cadran2 == 0)
					{
						chgDir = (cadran1 ^ cadran2);
						if (chgDir != 0)
						{
							pHo.rom.rmEventFlags |= CRMvt.EF_GOESINPLAYFIELD;
							this.rhEvtProg.rhCurParam0 = chgDir;
							this.rhEvtProg.handle_Event(pHo, (-11 << 16) | (pHo.hoType & 0xFFFF));
						}
					}
				}

				cadran = this.quadran_In(pHo.hoX - pHo.hoImgXSpot, pHo.hoY - pHo.hoImgYSpot, pHo.hoX - pHo.hoImgXSpot + pHo.hoImgWidth, pHo.hoY - pHo.hoImgYSpot + pHo.hoImgHeight);
				if ((cadran & pHo.rom.rmWrapping) != 0)
				{
				    var oldMoveFlag = pHo.rom.rmMoveFlag;

					if ((cadran & CRun.BORDER_LEFT) != 0)
						pHo.rom.rmMovement.setXPosition(pHo.hoX + this.rhLevelSx);
					else if ((cadran & CRun.BORDER_RIGHT) != 0)
						pHo.rom.rmMovement.setXPosition(pHo.hoX - this.rhLevelSx);

					if ((cadran & CRun.BORDER_TOP) != 0)
						pHo.rom.rmMovement.setYPosition(pHo.hoY + this.rhLevelSy);
					else if ((cadran & CRun.BORDER_BOTTOM) != 0)
						pHo.rom.rmMovement.setYPosition(pHo.hoY - this.rhLevelSy);

				    // Fix for bug 3468: rmMoveFlag must not be forced when wrapping (see specific SetXPos / SetYPos in Windows runtime)
					if (pHo.roc.rcMovementType != CMoveDef.MVTYPE_PLATFORM && pHo.roc.rcMovementType != CMoveDef.MVTYPE_EXT)
					    pHo.rom.rmMoveFlag = oldMoveFlag;
				}

				cadran1 = this.quadran_Out(pHo.roc.rcOldX1, pHo.roc.rcOldY1, pHo.roc.rcOldX2, pHo.roc.rcOldY2);
				if (cadran1 != CRun.BORDER_ALL)		// Si deja completement dehors, on ne teste pas
				{
					cadran2 = this.quadran_Out(pHo.hoX - pHo.hoImgXSpot, pHo.hoY - pHo.hoImgYSpot,
						pHo.hoX - pHo.hoImgXSpot + pHo.hoImgWidth, pHo.hoY - pHo.hoImgYSpot + pHo.hoImgHeight);

					chgDir = (~cadran1 & cadran2);
					if (chgDir != 0)
					{
						pHo.rom.rmEventFlags |= CRMvt.EF_GOESOUTPLAYFIELD;
						this.rhEvtProg.rhCurParam0 = chgDir;		// ou LOWORD?
						this.rhEvtProg.handle_Event(pHo, (-12 << 16) | (pHo.hoType & 0xFFFF));  // CNDL_EXTOUTPLAYFIELD 
					}
				}
			}

			if ((pHo.hoLimitFlags & CObjInfo.OILIMITFLAGS_QUICKBACK) != 0)
			{
				if (pHo.roc.rcMovementType == CMoveDef.MVTYPE_PLATFORM)
				{
					pHo.rom.rmMovement.mpHandle_Background();
				}
				else
				{
					if (this.colMask_TestObject_IXY(pHo, pHo.roc.rcImage, pHo.roc.rcAngle, pHo.roc.rcScaleX, pHo.roc.rcScaleY, pHo.hoX, pHo.hoY, 0, CRunFrame.CM_TEST_PLATFORM))
					{
						this.rhEvtProg.handle_Event(pHo, ( (-13 << 16) | (pHo.hoType & 0xFFFF) ));
					}
				}
			}

			if ((pHo.hoLimitFlags & CObjInfo.OILIMITFLAGS_ONCOLLIDE) != 0)
			{
				var cnt = this.objectAllCol_IXY(pHo, pHo.roc.rcImage, pHo.roc.rcAngle, pHo.roc.rcScaleX, pHo.roc.rcScaleY, pHo.hoX, pHo.hoY, pHo.hoOiList.oilColList);
				if (cnt != null)
				{
					var obj;
					for (obj = 0; obj < cnt.size(); obj++)
					{
						var pHox = cnt.get(obj);
						if ((pHox.hoFlags & CObject.HOF_DESTROYED) == 0)
						{
							var type = pHo.hoType;
							var pHo_esi = pHo;
							var pHo_ebx = pHox;
							if (pHo_esi.hoType > pHo_ebx.hoType)
							{
								pHo_esi = pHox;
								pHo_ebx = pHo;
								type = pHo_esi.hoType;
							}
							this.rhEvtProg.rhCurParam0 = pHo_ebx.hoOi;
							this.rhEvtProg.rh1stObjectNumber = pHo_ebx.hoNumber;
							this.rhEvtProg.handle_Event(pHo_esi, (-14 << 16) | (type & 0xFFFF));
						}
					}
				}
			}
			return CRun.bMoveChanged;
		},

		objectAllCol_IXY: function (pHo, newImg, newAngle, newScaleX, newScaleY, newX, newY, pOiColList)
		{
			var list = null;

			var rectX1 = newX - pHo.hoImgXSpot;
			var rectX2 = rectX1 + pHo.hoImgWidth;
			var rectY1 = newY - pHo.hoImgYSpot;
			var rectY2 = rectY1 + pHo.hoImgHeight;

			var image1;
			var pMask2;
			var image2;
			if ((pHo.hoFlags & CObject.HOF_NOCOLLISION) != 0 || (pHo.hoFlags & CObject.HOF_DESTROYED) != 0)
			{
				return list;
			}
			var bMask1 = false;
			var pMask1 = null;
			var image;
			var nLayer = -1;
			if (pHo.hoType == COI.OBJ_SPR && (pHo.ros.rsFlags & CRSpr.RSFLAG_COLBOX) == 0)
			{
				bMask1 = true;
			}
			if (pHo.hoType == COI.OBJ_SPR)
			{
				nLayer = pHo.ros.rsLayer;
			}

			var oldHoFlags = pHo.hoFlags;
			pHo.hoFlags |= CObject.HOF_NOCOLLISION;
			var count = 0;
			var i;
			var pHox;
			var xHox, yHox;
			if (pOiColList != null)
			{
				var nOi = 0;
				for (nOi = 0; nOi < pOiColList.length; nOi += 2)
				{
					var pOil = this.rhOiList[pOiColList[nOi + 1]];
					var object = pOil.oilObject;
					while ((object & 0x80000000) == 0)
					{
						pHox = this.rhObjectList[object];
						object = pHox.hoNumNext;

						if ((pHox.hoFlags & CObject.HOF_NOCOLLISION) == 0 && (pHox.hoFlags & CObject.HOF_DESTROYED) == 0)
						{
							xHox = pHox.hoX - pHox.hoImgXSpot;
							yHox = pHox.hoY - pHox.hoImgYSpot;
							if (xHox < rectX2 &&
								xHox + pHox.hoImgWidth > rectX1 &&
								yHox < rectY2 &&
								yHox + pHox.hoImgHeight > rectY1)
							{
								switch (pHox.hoType)
								{
									case COI.OBJ_SPR:
										if (nLayer < 0 || (nLayer >= 0 && nLayer == pHox.ros.rsLayer))
										{
											if ((pHox.ros.rsFlags & CRSpr.RSFLAG_RAMBO) != 0)
											{
												if (bMask1 == false || (pHox.ros.rsFlags & CRSpr.RSFLAG_COLBOX) != 0)
												{
													if (list == null)
													{
														list = new CArrayList();
													}
													list.add(pHox);
													break;
												}
												if (pMask1 == null)
												{
													image = this.rhApp.imageBank.getImageFromHandle(newImg);
													if (image != null)
													{
														pMask1 = image.getMask(0, newAngle, newScaleX, newScaleY);
													}
												}
												image2 = this.rhApp.imageBank.getImageFromHandle(pHox.roc.rcImage);
												if (image2 != null)
												{
													pMask2 = image2.getMask(0, pHox.roc.rcAngle, pHox.roc.rcScaleX, pHox.roc.rcScaleY);
												}
												if (pMask1 != null && pMask2 != null)
												{
													if (pMask1.testMask(rectX1, rectY1, 0, pMask2, xHox, yHox, 0))
													{
														if (list == null)
														{
															list = new CArrayList();
														}
														list.add(pHox);
														break;
													}
												}
											}
										}
										break;
									case COI.OBJ_TEXT:
									case COI.OBJ_COUNTER:
									case COI.OBJ_LIVES:
									case COI.OBJ_SCORE:
									case COI.OBJ_CCA:
										if (list == null)
										{
											list = new CArrayList();
										}
										list.add(pHox);
										break;
									default:
										if (list == null)
										{
											list = new CArrayList();
										}
										list.add(pHox);
										break;
								}
							}
						}
					}
				}
			}
			else
			{
				for (i = 0; i < this.rhNObjects; i++)
				{
					while (this.rhObjectList[count] == null)
						count++;
					pHox = this.rhObjectList[count];
					count++;

					if ((pHox.hoFlags & CObject.HOF_NOCOLLISION) == 0)
					{
						xHox = pHox.hoX - pHox.hoImgXSpot;
						yHox = pHox.hoY - pHox.hoImgYSpot;
						if (xHox < rectX2 &&
							xHox + pHox.hoImgWidth > rectX1 &&
							yHox < rectY2 &&
							yHox + pHox.hoImgHeight > rectY1)
						{
							switch (pHox.hoType)
							{
								case COI.OBJ_SPR:
									if (nLayer < 0 || (nLayer >= 0 && nLayer == pHox.ros.rsLayer))
									{
										if ((pHox.ros.rsFlags & CRSpr.RSFLAG_RAMBO) != 0)
										{
											if (bMask1 == false || (pHox.ros.rsFlags & CRSpr.RSFLAG_COLBOX) != 0)
											{
												if (list == null)
												{
													list = new CArrayList();
												}
												list.add(pHox);
												break;
											}
											if (pMask1 == null)
											{
												image = this.rhApp.imageBank.getImageFromHandle(newImg);
												if (image != null)
												{
													pMask1 = image.getMask(0, newAngle, newScaleX, newScaleY);
												}
											}
											image2 = this.rhApp.imageBank.getImageFromHandle(pHox.roc.rcImage);
											if (image2 != null)
											{
												pMask2 = image2.getMask(0, pHox.roc.rcAngle, pHox.roc.rcScaleX, pHox.roc.rcScaleY);
											}
											if (pMask1 != null && pMask2 != null)
											{
												if (pMask1.testMask(rectX1, rectY1, 0, pMask2, xHox, yHox, 0))
												{
													if (list == null)
													{
														list = new CArrayList();
													}
													list.add(pHox);
													break;
												}
											}
										}
									}
									break;
								case COI.OBJ_TEXT:
								case COI.OBJ_COUNTER:
								case COI.OBJ_LIVES:
								case COI.OBJ_SCORE:
								case COI.OBJ_CCA:
									if (list == null)
									{
										list = new CArrayList();
									}
									list.add(pHox);
									break;
								default:
									if (list == null)
									{
										list = new CArrayList();
									}
									list.add(pHox);
									break;
							}
						}
					}
				}
			}
			// Remettre anciens flags
			pHo.hoFlags = oldHoFlags;
			return list;
		},

		colMask_TestObject_IXY: function (pHo, newImg, newAngle, newScaleX, newScaleY, newX, newY, htFoot, plan)
		{
			var image;
			var mask;
			var x1;
			var y1;
			var x2;
			var y2;

			var pLayer = this.rhFrame.layers[pHo.hoLayer];
			switch (pHo.hoType)
			{
				case COI.OBJ_SPR:
					if ((pHo.ros.rsFlags & CRSpr.RSFLAG_COLBOX) == 0)
					{
						image = this.rhApp.imageBank.getImageFromHandle(pHo.roc.rcImage);
						if (image != null)
						{
							mask = image.getMask(CMask.GCMF_OBSTACLE, newAngle, newScaleX, newScaleY);
							return pLayer.testMask(mask, newX - this.rhWindowX, newY - this.rhWindowY, htFoot, plan) != null;
						}
					}
					else
					{
						x1 = newX - pHo.hoImgXSpot - this.rhWindowX;
						y1 = newY - pHo.hoImgYSpot - this.rhWindowY;
						x2 = x1 + pHo.hoImgWidth;
						y2 = y1 + pHo.hoImgHeight;
						var ret = pLayer.testRect(x1, y1, x2, y2, htFoot, plan) != null;
						return ret;
					}
					return false;
				//    		case COI.OBJ_TEXT:
				//    		case COI.OBJ_SCORE:
				//    		case COI.OBJ_LIVES:
				//    		case COI.OBJ_CCA:
				default:
					x1 = newX - pHo.hoImgXSpot - this.rhWindowX;
					y1 = newY - pHo.hoImgYSpot - this.rhWindowY;
					x2 = x1 + pHo.hoImgWidth;
					y2 = y1 + pHo.hoImgHeight;
					var ret = pLayer.testRect(x1, y1, x2, y2, htFoot, plan) != null;
					return ret;
			}
		},
		colMask_Test_Rect:      function (x1, y1, sx, sy, layer, plan)
		{
			var pLayer;
			var nLayerMax = layer;
			if (layer == -1)
			{
				layer = 0;
				nLayerMax = this.rhFrame.nLayers;
			}

			var n;
			var x2 = x1 + sx;
			var y2 = y1 + sy;
			for (n = layer; n < nLayerMax; n++)
			{
				pLayer = this.rhFrame.layers[n];
				if (pLayer.testRect(x1 - this.rhWindowX + pLayer.x, y1 - this.rhWindowY + pLayer.y, x2 - this.rhWindowX + pLayer.x, y2 - this.rhWindowY + pLayer.y, 0, plan) != null)
				{
					return true;
				}
			}
			return false;
		},
		colMask_Test_XY:        function (newX, newY, layer, plan)
		{
			var pLayer;
			var nLayerMax = layer;
			if (layer == -1)
			{
				layer = 0;
				nLayerMax = this.rhFrame.nLayers;
			}

			var n;
			for (n = layer; n < nLayerMax; n++)
			{
				pLayer = this.rhFrame.layers[n];
				if (pLayer.testPoint(newX - this.rhWindowX + pLayer.x, newY - this.rhWindowY + pLayer.y, plan))
				{
					return true;
				}
			}
			return false;
		},

		getObjectAtXY: function (x, y)
		{
			// Explore les sprites en collision
			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			var count = 0;
			var i;
			var pHox;
			var x1, y1, x2, y2;
			var currentHo = null;
			var currentIndex = -1;
			var index;

			for (i = 0; i < this.rhNObjects; i++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				pHox = this.rhObjectList[count];
				count++;

				x1 = pHox.hoX - pHox.hoImgXSpot;
				y1 = pHox.hoY - pHox.hoImgYSpot;
				x2 = x1 + pHox.hoImgWidth;
				y2 = y1 + pHox.hoImgHeight;
				if (x >= x1 && x < x2 && y >= y1 && y < y2)
				{
					if ((pHox.hoFlags & CObject.HOF_DESTROYED) == 0)
					{
						if (pHox.hoType == COI.OBJ_SPR)
						{
							if ((pHox.ros.rsFlags & CRSpr.RSFLAG_COLBOX) == 0)
							{
								var image = this.rhApp.imageBank.getImageFromHandle(pHox.roc.rcImage);
								var mask = image.getMask(CMask.GCMF_OBSTACLE, 0, 1.0, 1.0);
								if (mask.testPointEx(x - pHox.hoX, y - pHox.hoY, pHox.roc.rcAngle, pHox.roc.rcScaleX, pHox.roc.rcScaleY))
								{
									index = pHox.getChildIndex();
									if (index > currentIndex)
									{
										currentIndex = index;
										currentHo = pHox;
									}
								}
							}
							else
							{
								index = pHox.getChildIndex();
								if (index > currentIndex)
								{
									currentIndex = index;
									currentHo = pHox;
								}
							}
						}
					}
				}
			}
			return currentHo;
		},


		quadran_Out: function (x1, y1, x2, y2)
		{
			var cadran = 0;
			if (x1 < 0)
				cadran |= CRun.BORDER_LEFT;
			if (y1 < 0)
				cadran |= CRun.BORDER_TOP;
			if (x2 > this.rhLevelSx)
				cadran |= CRun.BORDER_RIGHT;
			if (y2 > this.rhLevelSy)
				cadran |= CRun.BORDER_BOTTOM;
			return CRun.Table_InOut[cadran];
		},

		quadran_In: function (x1, y1, x2, y2)
		{
			var cadran = 15;
			if (x1 < this.rhLevelSx)
				cadran &= ~CRun.BORDER_RIGHT;
			if (y1 < this.rhLevelSy)
				cadran &= ~CRun.BORDER_BOTTOM;
			if (x2 > 0)
				cadran &= ~CRun.BORDER_LEFT;
			if (y2 > 0)
				cadran &= ~CRun.BORDER_TOP;
			return CRun.Table_InOut[cadran];
		},

		random: function (wMax)
		{
			var calcul = this.rh3Graine * 31415 + 1;
			calcul &= 0x0000FFFF;
			this.rh3Graine = calcul;
			return ((calcul * wMax) >>> 16);
		},

		get_Direction: function (dir)
		{
			if (dir == 0 || dir == -1)
			{
				return this.random(32);
			}

			var loop;
			var found = 0;
			var count = 0;
			var dirShift = dir;
			for (loop = 0; loop < 32; loop++)
			{
				if ((dirShift & 1) != 0)
				{
					count++;
					found = loop;
				}
				dirShift >>>= 1;
			}

			if (count == 1)
			{
				return found;
			}

			count = this.random(count);
			dirShift = dir;
			for (loop = 0; loop < 32; loop++)
			{
				if ((dirShift & 1) != 0)
				{
					count--;
					if (count < 0)
					{
						return loop;
					}
				}
				dirShift >>>= 1;
			}
			return 0;
		},

		get_EventExpressionAny: function (pExp)
		{
			this.rh4Tokens = pExp.tokens;
			this.rh4CurToken = 0;
			this.flagFloat = false;
			return this.getExpression();

		},

		get_EventExpressionInt: function (pExp)
		{
			this.rh4Tokens = pExp.tokens;
			this.rh4CurToken = 0;
			this.flagFloat = false;
			return this.getExpression();
		},

		get_EventExpressionDouble: function (pExp)
		{
			this.rh4Tokens = pExp.tokens;
			this.rh4CurToken = 0;
			this.flagFloat = false;
			return this.getExpression();
		},

		get_EventExpressionString: function (pExp)
		{
			this.rh4Tokens = pExp.tokens;
			this.rh4CurToken = 0;
			this.flagFloat = false;
			return this.getExpression();
		},

		get_ExpressionInt: function ()
		{
			this.flagFloat = false;
			var value = this.getExpression();
			if (value < 0)
				return Math.ceil(value);
			else
				return Math.floor(value);
		},

		getExpression: function ()
		{
			var ope;
			var pileStart = this.rh4PosPile;
			this.rh4Operators[this.rh4PosPile] = this.rh4OpeNull;
			do
			{
				this.rh4PosPile++;
				this.bOperande = true;
				this.rh4Tokens[this.rh4CurToken].evaluate(this);
				this.bOperande = false;
				this.rh4CurToken++;

				do
				{
					ope = this.rh4Tokens[this.rh4CurToken];
					if (ope.code > 0 && ope.code < 0x00140000)
					{
						if (ope.code > this.rh4Operators[this.rh4PosPile - 1].code)
						{
							this.rh4Operators[this.rh4PosPile] = ope;
							this.rh4CurToken++;

							this.rh4PosPile++;
							this.bOperande = true;
							this.rh4Tokens[this.rh4CurToken].evaluate(this);
							this.bOperande = false;
							this.rh4CurToken++;
						}
						else
						{
							this.rh4PosPile--;
							this.rh4Operators[this.rh4PosPile].evaluate(this);
						}
					}
					else
					{
						this.rh4PosPile--;
						if (this.rh4PosPile == pileStart)
						{
							break;
						}
						this.rh4Operators[this.rh4PosPile].evaluate(this);
					}
				} while (true);
			} while (this.rh4PosPile > pileStart + 1);
			return this.rh4Results[pileStart + 1];
		},

		getCurrentResult: function ()
		{
			return this.rh4Results[this.rh4PosPile];
		},

		getPreviousResult: function ()
		{
			return this.rh4Results[this.rh4PosPile - 1];
		},

		getNextResult: function ()
		{
			return this.rh4Results[this.rh4PosPile + 1];
		},

		update_PlayerObjects: function (joueur, type, value)
		{
			joueur++;

			var count = 0;
			var no;
			for (no = 0; no < this.rhNObjects; no++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				var pHo = this.rhObjectList[count];
				if (pHo.hoType == type)
				{
					switch (type)
					{
						case 5:
							if (pHo.rsPlayer == joueur)
							{
								pHo.setValue(value);
							}
							break;
						case 6:
							if (pHo.rsPlayer == joueur)
							{
								pHo.setValue(value);
							}
							break;
					}
				}
				count++;
			}
		},

		actPla_FinishLives: function (joueur, live)
		{
			var lives = this.rhApp.getLives();
			if (live == lives[joueur])
			{
				return;
			}

			if (live == 0)
			{
				if (lives[joueur] != 0)
				{
					this.rhEvtProg.push_Event(0, ((-5 << 16) | 0xFFF9), 0, null, joueur);
				}
			}

			lives[joueur] = live;
			this.update_PlayerObjects(joueur, COI.OBJ_LIVES, live);
		},

		getMouseOnObjectsEDX: function (oiList, nega)
		{
			var pHo = this.rhEvtProg.evt_FirstObject(oiList);
			if (pHo == null)
			{
				if (nega)
				{
					return true;
				}
				return false;
			}
			var cpt = this.rhEvtProg.evtNSelectedObjects;

			var count = 0;
			var i;
			var pHox;
			var x1, y1, x2, y2;
			var list = new CArrayList();
			for (i = 0; i < this.rhNObjects; i++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				pHox = this.rhObjectList[count];
				count++;

				x1 = pHox.hoX - pHox.hoImgXSpot;
				y1 = pHox.hoY - pHox.hoImgYSpot;
				x2 = x1 + pHox.hoImgWidth;
				y2 = y1 + pHox.hoImgHeight;
				if (this.rh2MouseX >= x1 && this.rh2MouseX < x2 && this.rh2MouseY >= y1 && this.rh2MouseY < y2)
				{
					if ((pHox.hoFlags & CObject.HOF_DESTROYED) == 0)
					{
						if (pHox.hoType == COI.OBJ_SPR)
						{
							if ((pHox.ros.rsFlags & CRSpr.RSFLAG_COLBOX) == 0)
							{
								var image = this.rhApp.imageBank.getImageFromHandle(pHox.roc.rcImage);
								var mask = image.getMask(CMask.GCMF_OBSTACLE, 0, 1.0, 1.0);
								if (mask.testPointEx(this.rh2MouseX - pHox.hoX, this.rh2MouseY - pHox.hoY, pHox.roc.rcAngle, pHox.roc.rcScaleX, pHox.roc.rcScaleY))
								{
									list.add(pHox);
								}
							}
							else
							{
								list.add(pHox);
							}
						}
						else
						{
							list.add(pHox);
						}
					}
				}
			}

			if (list.size() == 0)
			{
				if (nega)
				{
					return true;
				}
				return false;
			}

			if (nega == false)
			{
				do
				{
					for (count = 0; count < list.size(); count++)
					{
						pHox = list.get(count);
						if (pHox == pHo)
							break;
					}
					if (count == list.size())
					{
						cpt--;						//; Pas trouve dans la liste. on le vire
						this.rhEvtProg.evt_DeleteCurrentObject();
					}
					pHo = this.rhEvtProg.evt_NextObject();
				} while (pHo != null);
				return cpt != 0;
			}
			else
			{
				do
				{
					for (count = 0; count < list.size(); count++)
					{
						pHox = list.get(count);
						if (pHox == pHo)
							return false;
					}
					pHo = this.rhEvtProg.evt_NextObject();
				} while (pHo != null);
				return true;
			}
		},


		txtDisplay: function (pe, oi, txtNumber)
		{
			var pEvp = pe.evtParams[0];
			var pInfo = new CPositionInfo();
			if (pEvp.read_Position(this, 0x10, pInfo))
			{
				var count = 0;
				var no;
				for (no = 0; no < this.rhNObjects; no++)
				{
					while (this.rhObjectList[count] == null)
						count++;
					var pHo = this.rhObjectList[count];
					count++;

					if (pHo.hoType == COI.OBJ_TEXT && pHo.hoOi == oi && pHo.hoX == pInfo.x && pHo.hoY == pInfo.y)
					{
						pHo.ros.obShow();
						pHo.hoFlags &= ~CObject.HOF_NOCOLLISION;
						pHo.rsMini = -2;
						pHo.txtChange(txtNumber);
						pHo.ros.rsFlash = 0;
						pHo.ros.rsFlags |= CRSpr.RSFLAG_VISIBLE;
						return pHo.hoNumber;
					}
				}
				var num = this.f_CreateObject(-1, oi, pInfo.x, pInfo.y, 0, 0, this.rhFrame.nLayers - 1, -1);
				if (num >= 0)
				{
					this.rhObjectList[num].txtChange(txtNumber);
					return num;
				}
			}
			return -1;
		},

		txtDoDisplay: function (pe, txtNumber)
		{
			if ((pe.evtOiList & 0x8000) == 0)
			{
				return this.txtDisplay(pe, pe.evtOi, txtNumber);
			}

			if ((pe.evtOiList & 0x7FFF) == 0x7FFF)
				return -1;
			var qoi = pe.evtOiList & 0x7FFF;
			var qoil = this.rhEvtProg.qualToOiList[qoi];
			var count = 0;
			while (count < qoil.qoiList.length)
			{
				this.txtDisplay(pe, qoil.qoiList[count], txtNumber);
				count += 2;
			}
			;
			return -1;
		},

		init_Disappear: function (hoPtr)
		{
			var bFlag = false;
			var dw = 0;

			if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_ANIMATIONS) != 0)
			{
				if (hoPtr.ros != null)
				{
					if (hoPtr.ros.initFadeOut())
					{
						return;
					}
				}
				if (hoPtr.roa != null)
				{
					if (hoPtr.roa.anim_Exist(CAnim.ANIMID_DISAPPEAR))
					{
						dw = 1;
					}
				}
			}
			if (dw == 0)
			{
				bFlag = true;
			}

			if (bFlag)
			{
				hoPtr.hoCallRoutine = false;
				this.destroy_Add(hoPtr.hoNumber);
				return;
			}

			if (hoPtr.ros != null)
			{
				hoPtr.ros.setColFlag(false);
				hoPtr.hoFlags |= CObject.HOF_NOCOLLISION;
			}
			if (hoPtr.rom != null)
			{
				hoPtr.rom.kill(false);
				hoPtr.rom.initSimple(hoPtr, CMoveDef.MVTYPE_DISAPPEAR, false);
				hoPtr.roc.rcSpeed = 0;
			}
			if ((dw & 1) != 0)
			{
				hoPtr.roa.animation_Force(CAnim.ANIMID_DISAPPEAR);
				hoPtr.roa.animation_OneLoop();
			}
		},

		isMouseOn: function ()
		{
			if (this.rhApp.cursorCount > 0)
			{
				return true;
			}
			return false;
		},

		getRGBAt: function (hoPtr, x, y)
		{
			var rgb = 0;
			if (hoPtr.roc.rcImage != -1)
			{
				var image = this.rhApp.imageBank.getImageFromHandle(hoPtr.roc.rcImage);
				rgb = image.getPixel(x, y);
				rgb = swapRGB(rgb);
			}
			return rgb;
		},

		drawLevel: function ()
		{
			var plo;
			var rc = new CRect();
			var nLayer;

			for (nLayer = 0; nLayer < this.rhFrame.nLayers; nLayer++)
			{
				var pLayer = this.rhFrame.layers[nLayer];

				var bWrapHorz = ((pLayer.dwOptions & CLayer.FLOPT_WRAP_HORZ) != 0);
				var bWrapVert = ((pLayer.dwOptions & CLayer.FLOPT_WRAP_VERT) != 0);

				if (nLayer == 0)
				{
					var sx = this.rhFrame.leWidth;
					if (bWrapHorz)
					{
						sx *= 2;
					}
					var sy = this.rhFrame.leHeight;
					if (bWrapVert)
					{
						sy *= 2;
					}
					//				pLayer.fillBack(sx, sy, rhFrame.leBackground);
				}

				var nLOs = pLayer.nBkdLOs;
				var i;
				for (i = 0; i < nLOs; i++)
				{
					plo = this.rhFrame.LOList.getLOFromIndex(pLayer.nFirstLOIndex + i);
					var typeObj = plo.loType;

					if (typeObj < COI.OBJ_SPR)
					{
						rc.left = plo.loX;
						rc.top = plo.loY;
					}
					/*				else
					 {
					 continue;
					 }
					 */
					var bi;
					bi = new CBackInstance(this.rhApp, rc.left, rc.top, plo, null, 0);
					bi.addInstance(0, pLayer);

					if (bWrapHorz)
					{
						bi = new CBackInstance(this.rhApp, this.rhFrame.leWidth + rc.left, rc.top, plo, null, 0);
						bi.addInstance(1, pLayer);
						if (rc.left + bi.width > this.rhFrame.leWidth)
						{
							bi = new CBackInstance(this.rhApp, rc.left - this.rhFrame.leWidth, rc.top, plo, null, 0);
							bi.addInstance(4, pLayer);
						}
						if (bWrapVert)
						{
							bi = new CBackInstance(this.rhApp, rc.left, this.rhFrame.leHeight + rc.top, plo, null, 0);
							bi.addInstance(2, pLayer);
							bi = new CBackInstance(this.rhApp, this.rhFrame.leWidth + rc.left, this.rhFrame.leHeight + rc.top, plo, null, 0);
							bi.addInstance(3, pLayer);
							if (rc.top + bi.height > this.rhFrame.leHeight)
							{
								bi = new CBackInstance(this.rhApp, rc.left, rc.top - this.rhFrame.leHeight, plo, null, 0);
								bi.addInstance(5, pLayer);
							}
						}
					}
					else if (bWrapVert)
					{
						bi = new CBackInstance(this.rhApp, rc.left, this.rhFrame.leHeight + rc.top, plo, null, 0);
						bi.addInstance(2, pLayer);
						if (rc.top + bi.height > this.rhFrame.leHeight)
						{
							bi = new CBackInstance(this.rhApp, rc.left, rc.top - this.rhFrame.leHeight, plo, null, 0);
							bi.addInstance(5, pLayer);
						}
					}
				}
			}
		},

		scrollLayers: function ()
		{
			var l;
			var layer;

			var x = this.rh3DisplayX;
			var y = this.rh3DisplayY;

			var dx, dy;
			for (l = 0; l < this.rhFrame.nLayers; l++)
			{
				layer = this.rhFrame.layers[l];
				dx = x * layer.xCoef + layer.dx;
				dy = y * layer.yCoef + layer.dy;

				var bWrapHorz = ((layer.dwOptions & CLayer.FLOPT_WRAP_HORZ) != 0);
				var bWrapVert = ((layer.dwOptions & CLayer.FLOPT_WRAP_VERT) != 0);
				if (bWrapHorz)
				{
					if (dx < 0)
					{
						dx = dx % this.rhFrame.leWidth + this.rhFrame.leWidth;
					}
					if (dx > this.rhFrame.leWidth)
					{
						dx = dx % this.rhFrame.leWidth;
					}
				}
				if (bWrapVert)
				{
					if (dy < 0)
					{
						dy = dy % this.rhFrame.leHeight + this.rhFrame.leHeight;
					}
					if (dy > this.rhFrame.leHeight)
					{
						dy = dy % this.rhFrame.leHeight;
					}
				}
				layer.x = dx;
				layer.y = dy;
				layer.planeBack.x = -dx + this.rhApp.xOffset;
				layer.planeBack.y = -dy + this.rhApp.yOffset;
				layer.planeQuickDisplay.x = -dx + this.rhApp.xOffset;
				layer.planeQuickDisplay.y = -dy + this.rhApp.yOffset;
				layer.planeSprites.x = -dx + this.rhApp.xOffset;
				layer.planeSprites.y = -dy + this.rhApp.yOffset;
			}
			this.rhFrame.leX = this.rh3DisplayX;
			this.rhFrame.leY = this.rh3DisplayY;
		},

		hideLayer:      function (nLayer)
		{
			if (nLayer >= 0 && nLayer < this.rhFrame.nLayers)
			{
				var layer = this.rhFrame.layers[nLayer];
				layer.hide();
			}
		},
		showLayer:      function (nLayer)
		{
			if (nLayer >= 0 && nLayer < this.rhFrame.nLayers)
			{
				var layer = this.rhFrame.layers[nLayer];
				layer.show();
			}
		},
		hideShowLayers: function ()
		{
			var n;
			for (n = 0; n < this.rhFrame.nLayers; n++)
			{
				var layer = this.rhFrame.layers[n];
				if (layer.dwOptions & CLayer.FLOPT_TOHIDE)
				{
					layer.hide();
				}
			}
		},

		setDisplay: function (x, y, nLayer, flags)
		{
			x -= Math.floor(this.rh3WindowSx / 2);
			y -= Math.floor(this.rh3WindowSy / 2);

			var xf = x;
			var yf = y;

			if (nLayer != -1 && nLayer < this.rhFrame.nLayers)
			{
				var pLayer = this.rhFrame.layers[nLayer];
				if (pLayer.xCoef > 1.0)
				{
					var dxf = (xf - this.rhWindowX);
					dxf /= pLayer.xCoef;
					xf = CServices.floatToInt(this.rhWindowX + dxf);
				}
				if (pLayer.yCoef > 1.0)
				{
					var dyf = (yf - this.rhWindowY);
					dyf /= pLayer.yCoef;
					yf = CServices.floatToInt(this.rhWindowY + dyf);
				}
			}

			x = xf;
			y = yf;

			if (x < 0)
			{
				x = 0;
			}
			if (y < 0)
			{
				y = 0;
			}
			var x2 = x + this.rh3WindowSx;
			var y2 = y + this.rh3WindowSy;
			if (x2 > this.rhLevelSx)
			{
				x2 = this.rhLevelSx - this.rh3WindowSx;
				if (x2 < 0)
				{
					x2 = 0;
				}
				x = x2;
			}
			if (y2 > this.rhLevelSy)
			{
				y2 = this.rhLevelSy - this.rh3WindowSy;
				if (y2 < 0)
				{
					y2 = 0;
				}
				y = y2;
			}

			if ((flags & 1) != 0)
			{
				if (x != this.rhWindowX)
				{
					this.rh3DisplayX = x;
					this.rh3Scrolling |= CRun.RH3SCROLLING_SCROLL;
				}
			}
			if ((flags & 2) != 0)
			{
				if (y != this.rhWindowY)
				{
					this.rh3DisplayY = y;
					this.rh3Scrolling |= CRun.RH3SCROLLING_SCROLL;
				}
			}
		},

		updateWindowPos: function (newX, newY)
		{
			var noMove = 0;
			this.rh4WindowDeltaX = newX - this.rhWindowX;
			if (this.rh4WindowDeltaX != 0)
			{
				noMove++;
			}
			this.rh4WindowDeltaY = newY - this.rhWindowY;
			if (this.rh4WindowDeltaY != 0)
			{
				noMove++;
			}

			var pLayer;
			var i;
			if (noMove == 0)
			{
				for (i = 0; i < this.rhFrame.nLayers; i++)
				{
					pLayer = this.rhFrame.layers[i];
					if (pLayer.dx != 0 || pLayer.dy != 0)
					{
						noMove++;
						break;
					}
				}
			}

			var nOldX = this.rhWindowX;
			var nOldY = this.rhWindowY;
			var nNewX = newX;
			var nNewY = newY;
			var nDeltaX = this.rh4WindowDeltaX;
			var nDeltaY = this.rh4WindowDeltaY;

			this.rhWindowX = newX;
			this.rh3XMinimum = newX - CRun.COLMASK_XMARGIN;
			if (this.rh3XMinimum < 0)
			{
				this.rh3XMinimum = this.rh3XMinimumKill;
			}

			this.rhWindowY = newY;
			this.rh3YMinimum = newY - CRun.COLMASK_YMARGIN;
			if (this.rh3YMinimum < 0)
			{
				this.rh3YMinimum = this.rh3YMinimumKill;
			}

			this.rh3XMaximum = newX + this.rh3WindowSx + CRun.COLMASK_XMARGIN;
			if (this.rh3XMaximum > this.rhLevelSx)
			{
				this.rh3XMaximum = this.rh3XMaximumKill;
			}

			this.rh3YMaximum = newY + this.rh3WindowSy + CRun.COLMASK_YMARGIN;
			if (this.rh3YMaximum > this.rhLevelSy)
			{
				this.rh3YMaximum = this.rh3YMaximumKill;
			}


			var count = 0;
			var nObjects;
			for (nObjects = 0; nObjects < this.rhNObjects; nObjects++)
			{
				while (this.rhObjectList[count] == null)
					count++;
				var pHo = this.rhObjectList[count];
				count++;

				if (noMove != 0)
				{
					if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_SCROLLINGINDEPENDANT) != 0)
					{
						var x = nDeltaX;
						var y = nDeltaY;

						if (pHo.rom == null)
						{
							pHo.hoX += x;
							pHo.hoY += y;
						}
						else
						{
							x += pHo.hoX;
							y += pHo.hoY;
							pHo.rom.rmMovement.setXPosition(x);
							pHo.rom.rmMovement.setYPosition(y);
						}
					}
					else
					{
						var nLayer = pHo.hoLayer;
						if (nLayer < this.rhFrame.nLayers)
						{
							var oldLayerDx = nOldX;
							var oldLayerDy = nOldY;
							var newLayerDx = nNewX;
							var newLayerDy = nNewY;

							pLayer = this.rhFrame.layers[nLayer];
							if ((pLayer.dwOptions & CLayer.FLOPT_XCOEF) != 0)
							{
								oldLayerDx = (pLayer.xCoef * oldLayerDx);
								newLayerDx = (pLayer.xCoef * newLayerDx);
							}
							if ((pLayer.dwOptions & CLayer.FLOPT_YCOEF) != 0)
							{
								oldLayerDy = (pLayer.yCoef * oldLayerDy);
								newLayerDy = (pLayer.yCoef * newLayerDy);
							}

							var nX = (pHo.hoX + oldLayerDx) - newLayerDx + nDeltaX - pLayer.dx;
							var nY = (pHo.hoY + oldLayerDy) - newLayerDy + nDeltaY - pLayer.dy;

							if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) == 0)
							{
								pHo.hoX = nX;
								pHo.hoY = nY;
							}
							else
							{
								pHo.rom.rmMovement.setXPosition(nX);
								pHo.rom.rmMovement.setYPosition(nY);
							}
							pHo.forcePosition();
						}
					}
				}
			}
		},

		doScroll: function ()
		{
			if ((this.rh3Scrolling & CRun.RH3SCROLLING_SCROLL) != 0)
			{
				this.rh3Scrolling = 0;

				if (this.rhFrame.leX != this.rh3DisplayX || this.rhFrame.leY != this.rh3DisplayY)
				{
					this.scrollLayers();
					this.updateWindowPos(this.rhFrame.leX, this.rhFrame.leY);
				}
				this.rh3DisplayX = this.rhWindowX;
				this.rh3DisplayY = this.rhWindowY;
			}
		},

		activeToBackdrop: function (pHo, colType)
		{
			var pLayer = this.rhFrame.layers[pHo.hoLayer];
			var image = this.rhApp.imageBank.getImageFromHandle(pHo.roc.rcImage);
			var bi = new CBackInstance(this.rhApp, pHo.hoX - this.rhWindowX + pLayer.x, pHo.hoY - this.rhWindowY + pLayer.y, null, image, colType);
			bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
			bi.addInstance(0, pLayer);

			if (colType == COC.OBSTACLE_SOLID || colType == COC.OBSTACLE_PLATFORM)
			{
				if (this.rh4Box2DBase != null)
				{
					bi.body = this.rh4Box2DBase.rAddABackdrop(pHo.hoX - this.rhWindowX + pLayer.x, pHo.hoY - this.rhWindowY + pLayer.y, pHo.roc.rcImage, colType);
				}
			}

			var bWrapHorz = ((pLayer.dwOptions & CLayer.FLOPT_WRAP_HORZ) != 0);
			var bWrapVert = ((pLayer.dwOptions & CLayer.FLOPT_WRAP_VERT) != 0);
			if (bWrapHorz)
			{
				bi = new CBackInstance(this.rhApp, this.rhFrame.leWidth + pHo.hoX - this.rhWindowX + pLayer.x, pHo.hoY - this.rhWindowY + pLayer.y, null, image, colType);
				bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
				bi.addInstance(1, pLayer);
				if (pHo.hoX + bi.width > this.rhFrame.leWidth)
				{
					bi = new CBackInstance(this.rhApp, pHo.hoX - this.rhWindowX + pLayer.x - this.rhFrame.leWidth, pHo.hoY - this.rhWindowY + pLayer.y, null, image, colType);
					bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
					bi.addInstance(4, pLayer);
				}
				if (bWrapVert)
				{
					bi = new CBackInstance(this.rhApp, pHo.hoX - this.rhWindowX + pLayer.x, this.rhFrame.leHeight + pHo.hoY - this.rhWindowY + pLayer.y, null, image, colType);
					bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
					bi.addInstance(2, pLayer);
					bi = new CBackInstance(this.rhApp, this.rhFrame.leWidth + pHo.hoX - this.rhWindowX + pLayer.x, this.rhFrame.leHeight + pHo.hoY - this.rhWindowY + pLayer.y, null, image, colType);
					bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
					bi.addInstance(3, pLayer);
					if (pHo.hoY + bi.height > this.rhFrame.leHeight)
					{
						bi = new CBackInstance(this.rhApp, pHo.hoX - this.rhWindowX + pLayer.x, pHo.hoY - this.rhWindowY + pLayer.y - this.rhFrame.leHeight, null, image, colType);
						bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
						bi.addInstance(5, pLayer);
					}
				}
			}
			else if (bWrapVert)
			{
				bi = new CBackInstance(this.rhApp, pHo.hoX - this.rhWindowX + pLayer.x, this.rhFrame.leHeight + pHo.hoY - this.rhWindowY + pLayer.y, null, image, colType);
				bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
				bi.addInstance(2, pLayer);
				if (pHo.hoY + bi.height > this.rhFrame.leHeight)
				{
					bi = new CBackInstance(this.rhApp, pHo.hoX - this.rhWindowX + pLayer.x, pHo.hoY - this.rhWindowY + pLayer.y - this.rhFrame.leHeight, null, image, colType);
					bi.setEffect(pHo.ros.rsEffect, pHo.ros.rsEffectParam);
					bi.addInstance(5, pLayer);
				}
			}
		},

		addBackdrop:        function (srceImage, x, y, layer, colType, addToWorld)
		{
			var pLayer = this.rhFrame.layers[layer];
			var bi = new CBackInstance(this.rhApp, x - this.rhWindowX + pLayer.x, y - this.rhWindowX + pLayer.y, null, srceImage, colType);
			bi.addInstance(0, pLayer);
			if (addToWorld)
			{
				if (colType == COC.OBSTACLE_SOLID || colType == COC.OBSTACLE_PLATFORM)
				{
					if (this.rh4Box2DBase != null)
					{
						bi.body = this.rh4Box2DBase.rAddABackdrop(pHo.hoX - this.rhWindowX + pLayer.x, pHo.hoY - this.rhWindowY + pLayer.y, pHo.roc.rcImage, colType);
					}
				}
			}

			var bWrapHorz = ((pLayer.dwOptions & CLayer.FLOPT_WRAP_HORZ) != 0);
			var bWrapVert = ((pLayer.dwOptions & CLayer.FLOPT_WRAP_VERT) != 0);

			// Wrap
			if (bWrapHorz)
			{
				bi = new CBackInstance(this.rhApp, this.rhFrame.leWidth + x - this.rhWindowX + pLayer.x, y - this.rhWindowY + pLayer.y, null, srceImage, colType);
				bi.addInstance(1, pLayer);
				if (x + bi.width > this.rhFrame.leWidth)
				{
					bi = new CBackInstance(this.rhApp, x - this.rhWindowX + pLayer.x - this.rhFrame.leWidth, y - this.rhWindowY + pLayer.y, null, srceImage, colType);
					bi.addInstance(4, pLayer);
				}
				if (bWrapVert)
				{
					bi = new CBackInstance(this.rhApp, x - this.rhWindowX + pLayer.x, this.rhFrame.leHeight + y - this.rhWindowY + pLayer.y, null, srceImage, colType);
					bi.addInstance(2, pLayer);
					bi = new CBackInstance(this.rhApp, this.rhFrame.leWidth + x - this.rhWindowX + pLayer.x, this.rhFrame.leHeight + y - this.rhWindowY + pLayer.y, null, srceImage, colType);
					bi.addInstance(3, pLayer);
					if (y + bi.height > this.rhFrame.leHeight)
					{
						bi = new CBackInstance(this.rhApp, x - this.rhWindowX + pLayer.x, y - this.rhWindowY + pLayer.y - this.rhFrame.leHeight, null, srceImage, colType);
						bi.addInstance(5, pLayer);
					}
				}
			}
			else if (bWrapVert)
			{
				bi = new CBackInstance(this.rhApp, x - this.rhWindowX + pLayer.x, this.rhFrame.leHeight + y - this.rhWindowY + pLayer.y, null, srceImage, colType);
				bi.addInstance(2, pLayer);
				if (y + bi.height > this.rhFrame.leHeight)
				{
					bi = new CBackInstance(this.rhApp, x - this.rhWindowX + pLayer.x, y - this.rhWindowY + pLayer.y - this.rhFrame.leHeight, null, srceImage, colType);
					bi.addInstance(5, pLayer);
				}
			}

		},
		deleteAllBackdrop2: function (layer)
		{
			if (layer < 0 || layer >= this.rhFrame.nLayers)
			{
				return;
			}
			var pLayer = this.rhFrame.layers[layer];
			pLayer.deleteAddedBackdrops();
		},
		deleteBackdropAt:   function (layer, xx, yy, fine)
		{
			if (layer < 0 || layer >= this.rhFrame.nLayers)
			{
				return;
			}
			var pLayer = this.rhFrame.layers[layer];
			pLayer.deleteAddedBackdropsAt(xx - this.rhWindowX, yy - this.rhWindowY, fine);
		},

		getStorage: function (id)
		{
			if (this.rhApp.extensionStorage != null)
			{
				var n;
				for (n = 0; n < this.rhApp.extensionStorage.size(); n++)
				{
					var e = this.rhApp.extensionStorage.get(n);
					if (e.id == id)
					{
						return e;
					}
				}
			}
			return null;
		},

		delStorage: function (id)
		{
			if (this.rhApp.extensionStorage != null)
			{
				var n;
				for (n = 0; n < this.rhApp.extensionStorage.size(); n++)
				{
					var e = this.rhApp.extensionStorage.get(n);
					if (e.id == id)
					{
						this.rhApp.extensionStorage.removeIndex(n);
					}
				}
			}
		},

		addStorage: function (data, id)
		{
			var e = this.getStorage(id);
			if (e == null)
			{
				if (this.rhApp.extensionStorage == null)
				{
					this.rhApp.extensionStorage = new CArrayList();
				}
				data.id = id;
				this.rhApp.extensionStorage.add(data);
			}
		},

		getXMouse: function ()
		{
			if (this.rhMouseUsed != 0)
				return 0;
			return this.rh2MouseX;
		},

		getYMouse: function ()
		{
			if (this.rhMouseUsed != 0)
				return 0;
			return this.rh2MouseY;
		},

		onMouseWheel: function (delta)
		{
			this.rhWheelCount = this.rh4EventCount;
			if (delta < 0)
				this.rhEvtProg.handle_GlobalEvents(((-12 << 16) | 0xFFFA));		// CNDL_ONMOUSEHWEELDOWN
			else
				this.rhEvtProg.handle_GlobalEvents(((-11 << 16) | 0xFFFA));		// CNDL_ONMOUSEHWEELUP
		},

		findFirstObject:function(name)
		{
			var n, explore;
			if (this.rhNObjects != 0)
			{
				for (n = 0; n < this.rhMaxObjects; n++)
				{
					explore = this.rhObjectList[n];
					if (explore && explore.hoOiList.oilName == name)
					{
						this.findObjectCount = explore.hoOiList.oilNObjects - 1;
						return explore;
					}
				}
			}
			return null;
		},

		findNextObject:function(object)
		{
			if (object && this.findObjectCount)
			{
				var n = object.hoNumber + 1;
				var name = object.hoOiList.oilName;
				var explore;
				while(true)
				{
					explore = this.rhObjectList[n];
					if (explore != null && explore.hoOiList.oilName == name)
					{
						this.findObjectCount--;
						return explore;
					}
					n++;
				}
			}
			this.findObjectCount = 0;
			return null;
		}

	}

	// CCreateObjectInfo object
	// --------------------------------------------------------------
	CCreateObjectInfo.COF_HIDDEN = 0x0002;
	function CCreateObjectInfo()
	{
		this.cobLevObj = null;
		this.cobLevObjSeg = 0;
		this.cobFlags = 0;
		this.cobX = 0;
		this.cobY = 0;
		this.cobDir = 0;
		this.cobLayer = 0;
		this.cobZOrder = 0;
	}

	// CObjInfo object
	// ---------------------------------------------------------------
	CObjInfo.OILIMITFLAGS_BORDERS = 0x000F;
	CObjInfo.OILIMITFLAGS_BACKDROPS = 0x0010;
	CObjInfo.OILIMITFLAGS_ONCOLLIDE = 0x0080;
	CObjInfo.OILIMITFLAGS_QUICKCOL = 0x0100;
	CObjInfo.OILIMITFLAGS_QUICKBACK = 0x0200;
	CObjInfo.OILIMITFLAGS_QUICKBORDER = 0x0400;
	CObjInfo.OILIMITFLAGS_QUICKSPR = 0x0800;
	CObjInfo.OILIMITFLAGS_QUICKEXT = 0x1000;
	CObjInfo.OILIMITFLAGS_ALL = 0xFFFF;
	function CObjInfo()
	{
		this.oilOi = 0;
		this.oilListSelected = 0;
		this.oilType = 0;
		this.oilObject = 0;
		this.oilEvents = 0;
		this.oilWrap = 0;
		this.oilNextFlag = false;
		this.oilNObjects = 0;
		this.oilActionCount = 0;
		this.oilActionLoopCount = 0;
		this.oilCurrentRoutine = 0;
		this.oilCurrentOi = 0;
		this.oilNext = 0;
		this.oilEventCount = 0;
		this.oilNumOfSelected = 0;
		this.oilOEFlags = 0;
		this.oilLimitFlags = 0;
		this.oilLimitList = 0;
		this.oilOIFlags = 0;
		this.oilOCFlags2 = 0;
		this.oilInkEffect = 0;
		this.oilEffectParam = 0;
		this.oilHFII = 0;
		this.oilBackColor = 0;
		this.oilQualifiers = null;
		this.oilName = null;
		this.oilEventCountOR = 0;
		this.oilColList = null;
	}
	CObjInfo.prototype =
	{
		copyData: function (oiPtr)
		{
			this.oilOi = oiPtr.oiHandle;
			this.oilType = oiPtr.oiType;

			this.oilOIFlags = oiPtr.oiFlags;
			var ocPtr = oiPtr.oiOC;
			this.oilOCFlags2 = ocPtr.ocFlags2;
			this.oilInkEffect = oiPtr.oiInkEffect;
			this.oilEffectParam = oiPtr.oiInkEffectParam;
			this.oilOEFlags = ocPtr.ocOEFlags;
			this.oilBackColor = ocPtr.ocBackColor;
			this.oilEventCount = 0;
			this.oilObject = -1;
			this.oilLimitFlags = CObjInfo.OILIMITFLAGS_ALL;
			if (oiPtr.oiName != null)
			{
				this.oilName = oiPtr.oiName;
			}
			var q;
			this.oilQualifiers = new Array(8);
			for (q = 0; q < 8; q++)
				this.oilQualifiers[q] = ocPtr.ocQualifiers[q];
		}
	}

	// Global object saving classes
	// ----------------------------------------------------------
	function CSaveGlobal()
	{
		this.name = null;
		this.objects = null;
	}
	function CSaveGlobalCounter()
	{
		this.value = null;
		this.rsMini = 0;
		this.rsMaxi = 0;
		this.rsMiniDouble = 0;
		this.rsMaxiDouble = 0;
	}
	function CSaveGlobalText()
	{
		this.text = null;
		this.rsMini = 0;
	}
	function CSaveGlobalValues()
	{
		this.values = null;
		this.strings = null;
		this.flags = 0;
	}

	// CRunMBase
	// ----------------------------------------------------------------------
	CRunMBase.MTYPE_OBJECT = 0;
	CRunMBase.MTYPE_ELEMENT = 1;
	CRunMBase.MTYPE_PARTICULE = 2;
	CRunMBase.MTYPE_FAKEOBJECT = 3;
	CRunMBase.MTYPE_BORDERLEFT = 4;
	CRunMBase.MTYPE_BORDERRIGHT = 5;
	CRunMBase.MTYPE_BORDERTOP = 6;
	CRunMBase.MTYPE_BORDERBOTTOM = 7;
	CRunMBase.MTYPE_OBSTACLE = 8;
	CRunMBase.MTYPE_PLATFORM = 9;
	CRunMBase.MSUBTYPE_OBJECT = 0;
	CRunMBase.MSUBTYPE_BOTTOM = 1;
	CRunMBase.MSUBTYPE_TOP = 2;
	CRunMBase.MSUBTYPE_LEFT = 3;
	CRunMBase.MSUBTYPE_RIGHT = 4;
	CRunMBase.ANGLE_MAGIC = 123456789;
	function CRunMBase()
	{
		this.m_type = 0;
		this.m_subType = CRunMBase.MSUBTYPE_OBJECT;
		this.m_identifier = 0;
		this.m_stopFlag = false;
		this.m_pHo = null;
		this.m_body = null;
		this.m_currentAngle = 0;
		this.m_eventCount = 0;
		this.m_collidingObject = null;
		this.ho = null;
		this.rh = null;
		this.rc = new CRect();
		this.m_addVX = 0;
		this.m_addVY = 0;
		this.m_addVFlag = false;
		this.m_setVX = 0;
		this.m_setVY = 0;
		this.m_setVFlag = false;
		this.m_image = -1;
		this.m_background = false;
	}
	CRunMBase.prototype =
	{
		InitBase:           function (pHo, type)
		{
			this.m_pHo = pHo;
			this.m_type = type;
			this.m_stopFlag = false;
			m_currentAngle = 0;
		},
		AddVelocity:        function (vx, vy)
		{
			this.m_addVX = vx;
			this.m_addVY = vy;
			this.m_addVFlag = true;
		},
		SetVelocity:        function (vx, vy)
		{
			var angle = this.m_body.GetAngle();
			var position = this.m_body.GetPosition();
			position.x += vx / 2.56;
			position.y += vy / 2.56;
			this.m_base.rBodySetTransform(this.m_body, position, angle);
		},
		ResetAddVelocity:   function ()
		{
			if (this.m_addVFlag)
			{
				this.m_addVFlag = false;
				this.m_addVX = 0;
				this.m_addVY = 0;
			}
			if (this.m_setVFlag)
			{
				this.m_setVFlag = false;
				this.m_setVX = 0;
				this.m_setVY = 0;
			}
		},
		PrepareCondition:   function ()
		{
			this.m_stopFlag = false;
			this.m_eventCount = this.m_pHo.hoAdRunHeader.rh4EventCount;
		},
		IsStop:             function ()
		{
			return this.m_stopFlag;
		},
		SetStopFlag:        function (flag)
		{
			this.m_stopFlag = flag;
		},
		SetCollidingObject: function (object)
		{
			this.m_collidingObject = object;
		},
		CreateBody:         function ()
		{
			return false;
		},
		CreateJoint:        function ()
		{
		},
		SetFriction:        function (friction)
		{
		},
		SetRestitution:     function (restitution)
		{
		},
		SetGravity:         function (gravity)
		{
		},
		SetDensity:         function (density)
		{
		},
		init:               function (hoPtr)
		{
			this.ho = hoPtr;
			this.rh = this.ho.hoAdRunHeader;
		},

		initialize: function (file)
		{
		},

		kill: function ()
		{
		},

		move: function ()
		{
			return false;
		},

		setPosition: function (x, y)
		{
		},

		setXPosition: function (x)
		{
		},

		setYPosition: function (y)
		{
		},

		stop: function (bCurrent)
		{
		},

		bounce: function (bCurrent)
		{
		},

		reverse: function ()
		{
		},

		start: function ()
		{
		},

		setSpeed: function (speed)
		{
		},

		setMaxSpeed: function (speed)
		{
		},

		setDir: function (dir)
		{
		},

		setAcc: function (acc)
		{
		},

		setDec: function (dec)
		{
		},

		setRotSpeed: function (speed)
		{
		},

		set8Dirs: function (dirs)
		{
		},

		setGravity: function (gravity)
		{
		},

		extension: function (func, param)
		{
			return 0;
		},

		actionEntry: function (action)
		{
			return 0;
		},

		getSpeed: function ()
		{
			return 0;
		},

		getAcceleration: function ()
		{
			return 0;
		},

		getDeceleration: function ()
		{
			return 0;
		},

		getGravity: function ()
		{
			return 0;
		},

		dirAtStart: function (dir)
		{
			return this.ho.rom.dirAtStart(this.ho, dir, 32);
		},

		animations: function (anm)
		{
			this.ho.roc.rcAnim = anm;
			if (this.ho.roa != null)
			{
				this.ho.roa.animate();
			}
		},

		collisions: function ()
		{
			this.ho.hoAdRunHeader.rh3CollisionCount++;
			this.ho.rom.rmMovement.rmCollisionCount = this.ho.hoAdRunHeader.rh3CollisionCount;
			this.ho.hoAdRunHeader.newHandle_Collisions(this.ho);
		},

		approachObject: function (destX, destY, originX, originY, htFoot, planCol, ptDest)
		{
			destX -= this.ho.hoAdRunHeader.rhWindowX;
			destY -= this.ho.hoAdRunHeader.rhWindowY;
			originX -= this.ho.hoAdRunHeader.rhWindowX;
			originY -= this.ho.hoAdRunHeader.rhWindowY;
			var bRet = this.ho.rom.rmMovement.mpApproachSprite(destX, destY, originX, originY, htFoot, planCol, ptDest);
			ptDest.x += this.ho.hoAdRunHeader.rhWindowX;
			ptDest.y += this.ho.hoAdRunHeader.rhWindowY;
			return bRet;
		},

		moveIt: function ()
		{
			return this.ho.rom.rmMovement.newMake_Move(this.ho.roc.rcSpeed, this.hoPtr.hoAdRunHeader.getDir(this.hoPtr));
		},

		testPosition: function (x, y, htFoot, planCol, flag)
		{
			return this.ho.rom.rmMovement.tst_SpritePosition(x, y, htFoot, planCol, flag);
		},

		getJoystick: function (player)
		{
			return this.ho.hoAdRunHeader.rhPlayer[player];
		},

		colMaskTestRect: function (x, y, sx, sy, layer, plan)
		{
			return !this.ho.hoAdRunHeader.colMask_Test_Rect(x, y, sx, sy, layer, plan);
		},

		colMaskTestPoint: function (x, y, layer, plan)
		{
			return !this.ho.hoAdRunHeader.colMask_Test_XY(x, y, layer, plan);
		},

		getParamDouble: function ()
		{
			return this.ho.rom.rmMovement.callParam;
		},

		getParam: function ()
		{
			return this.ho.rom.rmMovement.callParam;
		},

		getAngle: function ()
		{
			return 0;
		},

		setAngle: function (angle)
		{
		}


	}

	// CAnim object
	// -----------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	CAnim.ANIMID_STOP = 0;
	CAnim.ANIMID_WALK = 1;
	CAnim.ANIMID_RUN = 2;
	CAnim.ANIMID_APPEAR = 3;
	CAnim.ANIMID_DISAPPEAR = 4;
	CAnim.ANIMID_BOUNCE = 5;
	CAnim.ANIMID_SHOOT = 6;
	CAnim.ANIMID_JUMP = 7;
	CAnim.ANIMID_FALL = 8;
	CAnim.ANIMID_CLIMB = 9;
	CAnim.ANIMID_CROUCH = 10;
	CAnim.ANIMID_UNCROUCH = 11;
	CAnim.ANIMID_USER1 = 12;
	CAnim.tableAnimTwoSpeeds =
		[
			0,
			1,
			1,
			0,
			0,
			1,
			0,
			1,
			1,
			1,
			1,
			1,
			1,
			1,
			1,
			1
		];
	function CAnim()
	{
		this.anDirs = null;
		this.anTrigo = null;
		this.anAntiTrigo = null;
	}
	CAnim.prototype =
	{
		load:         function (file)
		{
			var debut = file.getFilePointer();

			var offsets = new Array(32);
			var n;
			for (n = 0; n < 32; n++)
			{
				offsets[n] = file.readAShort();
			}

			this.anDirs = new Array(32);
			this.anTrigo = new Array(32);
			this.anAntiTrigo = new Array(32);
			for (n = 0; n < 32; n++)
			{
				this.anDirs[n] = null;
				this.anTrigo[n] = 0;
				this.anAntiTrigo[n] = 0;
				if (offsets[n] != 0)
				{
					this.anDirs[n] = new CAnimDir();
					file.seek(debut + offsets[n]);
					this.anDirs[n].load(file);
				}
			}
		},
		enumElements: function (enumImages)
		{
			var n;
			for (n = 0; n < 32; n++)
			{
				if (this.anDirs[n] != null)
				{
					this.anDirs[n].enumElements(enumImages);
				}
			}
		},
		approximate:  function (nAnim)
		{
			var d, d2, d3;
			var cpt1, cpt2;

			for (d = 0; d < 32; d++)
			{
				if (this.anDirs[d] == null)
				{
					for (d2 = 0, cpt1 = d + 1; d2 < 32; d2++, cpt1++)
					{
						cpt1 = cpt1 & 0x1F;
						if (this.anDirs[cpt1] != null)
						{
							this.anTrigo[d] = cpt1;
							break;
						}
					}
					for (d3 = 0, cpt2 = d - 1; d3 < 32; d3++, cpt2--)
					{
						cpt2 = cpt2 & 0x1F;
						if (this.anDirs[cpt2] != null)
						{
							this.anAntiTrigo[d] = cpt2;
							break;
						}
					}
					if (cpt1 == cpt2 || d2 < d3)
					{
						this.anTrigo[d] |= 0x40;
					}
					else if (d3 < d2)
					{
						this.anAntiTrigo[d] |= 0x40;
					}
				}
				else
				{
					if (nAnim < 16)
					{
						if (CAnim.tableAnimTwoSpeeds[nAnim] == 0)
						{
							this.anDirs[d].adMinSpeed = this.anDirs[d].adMaxSpeed;
						}
					}
				}
			}
		}
	}


	// CAnimHeader object
	// -----------------------------------------------------------------
	CAnimHeader.tableApprox =
		[
			CAnim.ANIMID_APPEAR, CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, 0,		// 0  ANIMID_STOP
			CAnim.ANIMID_RUN, CAnim.ANIMID_STOP, 0, 0,                           // 1  ANIMID_WALK
			CAnim.ANIMID_WALK, CAnim.ANIMID_STOP, 0, 0,                          // 2  ANIMID_RUN
			CAnim.ANIMID_STOP, CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, 0,		// 3  ANIMID_APPEAR
			CAnim.ANIMID_STOP, 0, 0, 0,                                          // 4  ANIMID_DISAPPEAR
			CAnim.ANIMID_STOP, CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, 0,		// 5  ANIMID_BOUNCE
			CAnim.ANIMID_STOP, CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, 0,		// 6  ANIMID_SHOOT
			CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, CAnim.ANIMID_STOP, 0,		// 7  ANIMID_JUMP
			CAnim.ANIMID_STOP, CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, 0,		// 8  ANIMID_FALL
			CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, CAnim.ANIMID_STOP, 0,		// 9  ANIMID_CLIMB
			CAnim.ANIMID_STOP, CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, 0,		// 10 ANIMID_CROUCH
			CAnim.ANIMID_STOP, CAnim.ANIMID_WALK, CAnim.ANIMID_RUN, 0,		// 11 ANIMID_UNCROUCH
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0
		];
	function CAnimHeader()
	{
		this.ahAnimMax = 0;
		this.ahAnims = null;
		this.ahAnimExists = null;
	}
	CAnimHeader.prototype =
	{
		load: function (file)
		{
			var debut = file.getFilePointer();

			file.skipBytes(2);          // ahSize
			this.ahAnimMax = file.readAShort();

			var offsets = new Array(this.ahAnimMax);
			var n;
			for (n = 0; n < this.ahAnimMax; n++)
			{
				offsets[n] = file.readAShort();
			}

			this.ahAnims = new Array(this.ahAnimMax);
			this.ahAnimExists = new Array(this.ahAnimMax);
			for (n = 0; n < this.ahAnimMax; n++)
			{
				this.ahAnims[n] = null;
				this.ahAnimExists[n] = 0;
				if (offsets[n] != 0)
				{
					this.ahAnims[n] = new CAnim();
					file.seek(debut + offsets[n]);
					this.ahAnims[n].load(file);
					this.ahAnimExists[n] = 1;
				}
			}
			var cptAnim;
			for (cptAnim = 0; cptAnim < this.ahAnimMax; cptAnim++)
			{
				if (this.ahAnimExists[cptAnim] == 0)
				{
					var bFlag = false;
					if (cptAnim < 12)
					{
						for (n = 0; n < 4; n++)
						{
							var a = this.ahAnimExists[CAnimHeader.tableApprox[cptAnim * 4 + n]];
							if (a != 0)
							{
								this.ahAnims[cptAnim] = this.ahAnims[CAnimHeader.tableApprox[cptAnim * 4 + n]];
								bFlag = true;
								break;
							}
						}
					}
					if (bFlag == false)
					{
						for (n = 0; n < this.ahAnimMax; n++)
						{
							if (this.ahAnimExists[n] != 0)
							{
								this.ahAnims[cptAnim] = this.ahAnims[n];
								break;
							}
						}
					}
				}
				else
				{
					this.ahAnims[cptAnim].approximate(cptAnim);
				}
			}
		},

		enumElements: function (enumImages)
		{
			var n;
			for (n = 0; n < this.ahAnimMax; n++)
			{
				if (this.ahAnimExists[n] != 0)
				{
					this.ahAnims[n].enumElements(enumImages);
				}
			}
		}
	}

	// CAnimDir object
	// -----------------------------------------------------------------
	function CAnimDir()
	{
		this.adMinSpeed = 0;
		this.adMaxSpeed = 0;
		this.adRepeat = 0;
		this.adRepeatFrame = 0;
		this.adNumberOfFrame = 0;
		this.adFrames = null;
	}
	CAnimDir.prototype =
	{
		load:         function (file)
		{
			this.adMinSpeed = file.readAByte();
			this.adMaxSpeed = file.readAByte();
			this.adRepeat = file.readAShort();
			this.adRepeatFrame = file.readAShort();
			this.adNumberOfFrame = file.readAShort();

			this.adFrames = new Array(this.adNumberOfFrame);
			var n;
			for (n = 0; n < this.adNumberOfFrame; n++)
			{
				this.adFrames[n] = file.readAShort();
			}
		},
		enumElements: function (enumImages)
		{
			var n;
			for (n = 0; n < this.adNumberOfFrame; n++)
			{
				if (enumImages != null)
				{
					var num = enumImages.enumerate(this.adFrames[n]);
					if (num != -1)
					{
						this.adFrames[n] = num;
					}
				}
			}
		}
	}

	// CRAni object
	// -----------------------------------------------------------------
	CRAni.anim_Defined =
		[
			CAnim.ANIMID_STOP,
			CAnim.ANIMID_WALK,
			CAnim.ANIMID_RUN,
			CAnim.ANIMID_BOUNCE,
			CAnim.ANIMID_SHOOT,
			CAnim.ANIMID_JUMP,
			CAnim.ANIMID_FALL,
			CAnim.ANIMID_CLIMB,
			CAnim.ANIMID_CROUCH,
			CAnim.ANIMID_UNCROUCH,
			12,
			13,
			14,
			15,
			-1
		];
	function CRAni()
	{
		this.hoPtr = null;
		this.raAnimForced = 0;				// Flags if forced
		this.raAnimDirForced = 0;
		this.raAnimSpeedForced = 0;
		this.raAnimStopped = false;
		this.raAnimOn = 0;				// Current animation
		this.raAnimOffset = null;
		this.raAnimDir = 0;				// Direction of current animation
		this.raAnimPreviousDir = 0;                       // Previous OK direction
		this.raAnimDirOffset = null;
		this.raAnimSpeed = 0;
		this.raAnimMinSpeed = 0;                          // Minimum speed of movement
		this.raAnimMaxSpeed = 0;                          // Maximum speed of movement
		this.raAnimDeltaSpeed = 0;
		this.raAnimCounter = 0;                           // Animation speed counter
		this.raAnimDelta = 0;				// Speed counter
		this.raAnimRepeat = 0;				// Number of repeats
		this.raAnimRepeatLoop = 0;			// Looping picture
		this.raAnimFrame = 0;				// Current frame
		this.raAnimNumberOfFrame = 0;                     // Number of frames
		this.raAnimFrameForced = 0;
		this.raRoutineAnimation = 0;
		this.raOldAngle = -1;
	}
	CRAni.prototype =
	{
		init: function (ho)
		{
			this.hoPtr = ho;

			this.raRoutineAnimation = 0;
			this.init_Animation(CAnim.ANIMID_WALK);

			if (this.anim_Exist(CAnim.ANIMID_APPEAR))
			{
				this.raRoutineAnimation = 1;
				this.animation_Force(CAnim.ANIMID_APPEAR);
				this.animation_OneLoop();
				this.animations();
			}
			else
			{
				var i;
				for (i = 0; CRAni.anim_Defined[i] >= 0; i++)
				{
					if (this.anim_Exist(CRAni.anim_Defined[i]))
						break;
				}
				if (CRAni.anim_Defined[i] < 0)
				{
					if (this.anim_Exist(CAnim.ANIMID_DISAPPEAR))
					{
						this.raRoutineAnimation = 2;
						this.animation_Force(CAnim.ANIMID_DISAPPEAR);
						this.animation_OneLoop();
						this.animations();
					}
				}
			}
		},

		init_Animation: function (anim)
		{
			this.hoPtr.roc.rcAnim = anim;
			this.raAnimStopped = false;
			this.raAnimForced = 0;
			this.raAnimDirForced = 0;
			this.raAnimSpeedForced = 0;
			this.raAnimFrameForced = 0;
			this.raAnimCounter = 0;
			this.raAnimFrame = 0;
			this.raAnimOffset = null;
			this.raAnimDirOffset = null;
			this.raAnimOn = -1;
			this.raAnimMinSpeed = -1;
			this.raAnimPreviousDir = -1;
			this.raAnimOffset = null;
			this.raAnimDirOffset = null;
			this.animations();
		},

		check_Animate: function ()
		{
			this.animIn(0);
		},

		extAnimations: function (anim)
		{
			this.hoPtr.roc.rcAnim = anim;
			this.animate();
		},

		animate: function ()
		{
			switch (this.raRoutineAnimation)
			{
				case 0:
					return this.animations();
				case 1:
					this.anim_Appear();
					return false;
				case 2:
					this.anim_Disappear();
					return false;
			}
			return false;
		},

		animations: function ()
		{
			var x = this.hoPtr.hoX;
			this.hoPtr.roc.rcOldX = x;
			x -= this.hoPtr.hoImgXSpot;
			this.hoPtr.roc.rcOldX1 = x;
			x += this.hoPtr.hoImgWidth;
			this.hoPtr.roc.rcOldX2 = x;

			var y = this.hoPtr.hoY;
			this.hoPtr.roc.rcOldY = y;
			y -= this.hoPtr.hoImgYSpot;
			this.hoPtr.roc.rcOldY1 = y;
			y += this.hoPtr.hoImgHeight;
			this.hoPtr.roc.rcOldY2 = y;

			this.hoPtr.roc.rcOldImage = this.hoPtr.roc.rcImage;
			this.hoPtr.roc.rcOldAngle = this.hoPtr.roc.rcAngle;

			return this.animIn(1);
		},

		animIn: function (vbl)
		{
			var ocPtr = this.hoPtr.hoCommon;

			var speed = this.hoPtr.roc.rcSpeed;
			var anim = this.hoPtr.roc.rcAnim;

			if (this.raAnimSpeedForced != 0)
			{
				speed = this.raAnimSpeedForced - 1;
			}
			if (anim == CAnim.ANIMID_WALK)
			{
				if (speed == 0)
				{
					anim = CAnim.ANIMID_STOP;
				}
				if (speed >= 75)
				{
					anim = CAnim.ANIMID_RUN;
				}
			}
			if (this.raAnimForced != 0)
			{
				anim = this.raAnimForced - 1;
			}
			if (anim != this.raAnimOn)
			{
				this.raAnimOn = anim;
				if (anim >= ocPtr.ocAnimations.ahAnimMax)
				{
					anim = ocPtr.ocAnimations.ahAnimMax - 1;
				}
				var anPtr = ocPtr.ocAnimations.ahAnims[anim];
				if (anPtr != this.raAnimOffset)
				{
					this.raAnimOffset = anPtr;
					this.raAnimDir = -1;
					this.raAnimFrame = 0;
					if ((this.hoPtr.hoOEFlags & CObjectCommon.OEFLAG_DONTRESETANIMCOUNTER) == 0)		// Added for bug http://bugbox.clickteam.com/issues/3421, triggered by fix below...
					    this.raAnimCounter = 0;		// Build 284.11, report from Android, fixes bug http://bugbox.clickteam.com/issues/1882
	            }
			}

			var ifo;
			var image = 0;
			var frame = 0;
			var rhPtr = this.hoPtr.hoAdRunHeader;
			var dir = this.hoPtr.roc.rcDir % 32;
			var bAngle = false;

			if (this.raAnimDirForced != 0)
			{
				dir = this.raAnimDirForced - 1;
			}
			var adPtr;
			if (this.raAnimDir != dir)
			{
				this.raAnimDir = dir;

				adPtr = this.raAnimOffset.anDirs[dir];
				if (adPtr == null)
				{
					if ((this.raAnimOffset.anAntiTrigo[dir] & 0x40) != 0)
					{
						dir = this.raAnimOffset.anAntiTrigo[dir] & 0x3F;
					}
					else if ((this.raAnimOffset.anTrigo[dir] & 0x40) != 0)
					{
						dir = this.raAnimOffset.anTrigo[dir] & 0x3F;
					}
					else
					{
						var offset = dir;
						if (this.raAnimPreviousDir < 0)
						{
							dir = this.raAnimOffset.anTrigo[dir] & 0x3F;
							;
						}
						else
						{
							dir -= this.raAnimPreviousDir;
							dir &= 31;
							if (dir > 15)
							{
								dir = this.raAnimOffset.anTrigo[offset] & 0x3F;
								;
							}
							else
							{
								dir = this.raAnimOffset.anAntiTrigo[offset] & 0x3F;
							}
						}
					}
					adPtr = this.raAnimOffset.anDirs[dir];
				}
				else
				{
					this.raAnimPreviousDir = dir;
					adPtr = this.raAnimOffset.anDirs[dir];
				}

				if (this.raAnimOffset.anDirs[0] != null && (this.hoPtr.hoCommon.ocFlags2 & CObjectCommon.OCFLAGS2_AUTOMATICROTATION) != 0)
				{
					this.hoPtr.roc.rcAngle = (this.raAnimDir * 360) / 32;
					adPtr = this.raAnimOffset.anDirs[0];
					this.raAnimDirOffset = null;
					bAngle = true;
				}

				if (this.raAnimDirOffset != adPtr)
				{
					this.raAnimDirOffset = adPtr;
					this.raAnimRepeat = adPtr.adRepeat;
					this.raAnimRepeatLoop = adPtr.adRepeatFrame;

					var minSpeed = adPtr.adMinSpeed;
					var maxSpeed = adPtr.adMaxSpeed;

					if (minSpeed != this.raAnimMinSpeed || maxSpeed != this.raAnimMaxSpeed)
					{
						this.raAnimMinSpeed = minSpeed;
						this.raAnimMaxSpeed = maxSpeed;
						maxSpeed -= minSpeed;
						this.raAnimDeltaSpeed = maxSpeed;
						this.raAnimDelta = minSpeed;
						this.raAnimSpeed = -1;
					}

					this.raAnimNumberOfFrame = adPtr.adNumberOfFrame;
					if (this.raAnimFrameForced != 0 && this.raAnimFrameForced - 1 >= this.raAnimNumberOfFrame)
						this.raAnimFrameForced = 0;
					if (this.raAnimFrame >= this.raAnimNumberOfFrame)
						this.raAnimFrame = 0;
					image = adPtr.adFrames[this.raAnimFrame];
					if (this.raAnimStopped == false)
					{
						this.hoPtr.roc.rcImage = image;
						ifo = this.hoPtr.hoAdRunHeader.rhApp.imageBank.getImageInfoEx(image, this.hoPtr.roc.rcAngle, this.hoPtr.roc.rcScaleX, this.hoPtr.roc.rcScaleY);
						if (ifo != null)
						{
							this.hoPtr.hoImgWidth = ifo.width;
							this.hoPtr.hoImgHeight = ifo.height;
							this.hoPtr.hoImgXSpot = ifo.xSpot;
							this.hoPtr.hoImgYSpot = ifo.ySpot;
							this.hoPtr.hoImgXAP = ifo.xAP;
							this.hoPtr.hoImgYAP = ifo.yAP; 
						}
						this.hoPtr.roc.rcChanged = true;
						this.hoPtr.roc.rcCheckCollides = true;
					}
					if (this.raAnimNumberOfFrame == 1)
					{
						if (this.raAnimMinSpeed == 0)
						{
							this.raAnimNumberOfFrame = 0;
						}
						image = this.hoPtr.roc.rcImage;
						if (image == 0)
						{
							return false;
						}
						ifo = this.hoPtr.hoAdRunHeader.rhApp.imageBank.getImageInfoEx(image, this.hoPtr.roc.rcAngle, this.hoPtr.roc.rcScaleX, this.hoPtr.roc.rcScaleY);
						if (ifo != null)
						{
							this.hoPtr.hoImgWidth = ifo.width;
							this.hoPtr.hoImgHeight = ifo.height;
							this.hoPtr.hoImgXSpot = ifo.xSpot;
							this.hoPtr.hoImgYSpot = ifo.ySpot;
							this.hoPtr.hoImgXAP = ifo.xAP;
							this.hoPtr.hoImgYAP = ifo.yAP; 
						}
						return false;
					}
				}
			}

			if (vbl == 0 && this.raAnimFrameForced == 0)
			{
				return false;
			}
			if (bAngle == false && this.raAnimNumberOfFrame == 0)
			{
				return false;
			}

			var delta = this.raAnimDeltaSpeed;
			if (speed != this.raAnimSpeed)
			{
				this.raAnimSpeed = speed;

				if (delta == 0)
				{
					this.raAnimDelta = this.raAnimMinSpeed;
					if (this.raAnimSpeedForced != 0)
						this.raAnimDelta = this.raAnimSpeedForced - 1;
				}
				else
				{
					var deltaSpeed = this.hoPtr.roc.rcMaxSpeed - this.hoPtr.roc.rcMinSpeed;
					if (deltaSpeed == 0)
					{
						if (this.raAnimSpeedForced != 0)
						{
							delta *= speed;
							delta /= 100;
							delta += this.raAnimMinSpeed;
							if (delta > this.raAnimMaxSpeed)
								delta = this.raAnimMaxSpeed;
							this.raAnimDelta = delta;
						}
						else
						{
							delta /= 2;
							delta += this.raAnimMinSpeed;
							this.raAnimDelta = delta;
						}
					}
					else
					{
						delta *= speed;
						delta /= deltaSpeed;
						delta += this.raAnimMinSpeed;
						if (delta > this.raAnimMaxSpeed)
							delta = this.raAnimMaxSpeed;
						this.raAnimDelta = delta;
					}
				}
			}

			adPtr = this.raAnimDirOffset;
			frame = this.raAnimFrameForced;
			var counter;
			if (frame == 0)
			{
				if (this.raAnimDelta == 0 || this.raAnimStopped)
				{
					return false;
				}

				counter = this.raAnimCounter;
				frame = this.raAnimFrame;
				var aDelta = this.raAnimDelta;
				if ((this.hoPtr.hoAdRunHeader.rhFrame.leFlags & CRunFrame.LEF_TIMEDMVTS) != 0)
					aDelta = Math.round(aDelta * this.hoPtr.hoAdRunHeader.rh4MvtTimerCoef);
				counter += aDelta;
				while (counter > 100)
				{
					counter -= 100;
					frame++;
					if (frame >= this.raAnimNumberOfFrame)
					{
						frame = this.raAnimRepeatLoop;
						if (this.raAnimRepeat != 0)
						{
							this.raAnimRepeat--;
							if (this.raAnimRepeat == 0)
							{
								this.raAnimFrame = this.raAnimNumberOfFrame-1;
								this.raAnimNumberOfFrame = 0;
								if (this.raAnimForced != 0)
								{
									this.raAnimForced = 0;
									this.raAnimDirForced = 0;
									this.raAnimSpeedForced = 0;
								}

								if ( this.raAnimFrame < adPtr.adNumberOfFrame )
								{
									image = adPtr.adFrames[this.raAnimFrame];
									if ( image != this.hoPtr.roc.rcImage )
									{
										this.hoPtr.roc.rcImage = image;
										this.hoPtr.roc.rcChanged = true;
										this.hoPtr.roc.rcCheckCollides = true;
									}
								}
								this.raAnimCounter = counter;

								if ((this.hoPtr.hoAdRunHeader.rhGameFlags & CRun.GAMEFLAGS_INITIALISING) != 0)
									return false;
								if (bAngle)
								{
									this.hoPtr.roc.rcChanged = true;
									this.hoPtr.roc.rcCheckCollides = true;
									ifo = this.hoPtr.hoAdRunHeader.rhApp.imageBank.getImageInfoEx(this.hoPtr.roc.rcImage, this.hoPtr.roc.rcAngle, this.hoPtr.roc.rcScaleX, this.hoPtr.roc.rcScaleY);
									if (ifo != null)
									{
										this.hoPtr.hoImgWidth = ifo.width;
										this.hoPtr.hoImgHeight = ifo.height;
										this.hoPtr.hoImgXSpot = ifo.xSpot;
										this.hoPtr.hoImgYSpot = ifo.ySpot;
										this.hoPtr.hoImgXAP = ifo.xAP;
										this.hoPtr.hoImgYAP = ifo.yAP; 
									}
								}
								var cond = (-2 << 16);	    // CNDL_EXTANIMENDOF;
								cond |= (this.hoPtr.hoType & 0xFFFF);
								this.hoPtr.hoAdRunHeader.rhEvtProg.rhCurParam0 = this.hoPtr.roa.raAnimOn;
								return this.hoPtr.hoAdRunHeader.rhEvtProg.handle_Event(this.hoPtr, cond);
							}
						}
					}
				}
				this.raAnimCounter = counter;
			}
			else
			{
				frame--;
			}
			this.raAnimFrame = frame;
			this.hoPtr.roc.rcChanged = true;
			this.hoPtr.roc.rcCheckCollides = true;
			image = adPtr.adFrames[frame];
			if (this.hoPtr.roc.rcImage != image || this.raOldAngle != this.hoPtr.roc.rcAngle)
			{
				this.hoPtr.roc.rcImage = image;
				this.raOldAngle = this.hoPtr.roc.rcAngle;
				if (image >= 0)
				{
					ifo = this.hoPtr.hoAdRunHeader.rhApp.imageBank.getImageInfoEx(image, this.hoPtr.roc.rcAngle, this.hoPtr.roc.rcScaleX, this.hoPtr.roc.rcScaleY);
					if (ifo != null)
					{
						this.hoPtr.hoImgWidth = ifo.width;
						this.hoPtr.hoImgHeight = ifo.height;
						this.hoPtr.hoImgXSpot = ifo.xSpot;
						this.hoPtr.hoImgYSpot = ifo.ySpot;
						this.hoPtr.hoImgXAP = ifo.xAP;
						this.hoPtr.hoImgYAP = ifo.yAP; 
					}
				}
			}
			return false;
		},

		anim_Exist: function (animId)
		{
			var ahPtr = this.hoPtr.hoCommon.ocAnimations;
			if (ahPtr.ahAnimExists[animId] == 0)
				return false;
			return true;
		},

		animation_OneLoop: function ()
		{
			if (this.raAnimRepeat == 0)
			{
				this.raAnimRepeat = 1;
			}
		},

		animation_Force: function (anim)
		{
			this.raAnimForced = anim + 1;
			this.animIn(0);
		},

		animation_Restore: function ()
		{
			this.raAnimForced = 0;
			this.animIn(0);
		},

		animDir_Force: function (dir)
		{
			dir &= 31;
			this.raAnimDirForced = dir + 1;
			this.animIn(0);
		},

		animDir_Restore: function ()
		{
			this.raAnimDirForced = 0;
			this.animIn(0);
		},

		animSpeed_Force: function (speed)
		{
			if (speed < 0) speed = 0;
			if (speed > 100) speed = 100;
			this.raAnimSpeedForced = speed + 1;
			this.animIn(0);
		},

		animSpeed_Restore: function ()
		{
			this.raAnimSpeedForced = 0;
			this.animIn(0);
		},

		anim_Restart: function ()
		{
			this.raAnimOn = -1;
			this.animIn(0);
		},

		animFrame_Force: function (frame)
		{
			if (frame >= this.raAnimNumberOfFrame)
				frame = this.raAnimNumberOfFrame - 1;
			if (frame < 0)
				frame = 0;
			this.raAnimFrameForced = frame + 1;
			this.animIn(0);
		},

		animFrame_Restore: function ()
		{
			this.raAnimFrameForced = 0;
			this.animIn(0);
		},

		anim_Appear: function ()
		{
			this.animIn(1);

			if (this.raAnimForced != CAnim.ANIMID_APPEAR + 1)
			{
				if (this.anim_Exist(CAnim.ANIMID_STOP) || this.anim_Exist(CAnim.ANIMID_WALK) || this.anim_Exist(CAnim.ANIMID_RUN))
				{
					this.raRoutineAnimation = 0;
					this.animation_Restore();
				}
				else
				{
					this.raRoutineAnimation = 2;
					this.hoPtr.hoAdRunHeader.init_Disappear(this.hoPtr);
				}
			}
		},

		anim_Disappear: function ()
		{
			if ((this.hoPtr.hoFlags & CObject.HOF_FADEOUT) == 0)
			{
				this.animIn(1);									// Un cran d'animations
				if (this.raAnimForced != CAnim.ANIMID_DISAPPEAR + 1)
				{
					this.hoPtr.hoAdRunHeader.destroy_Add(this.hoPtr.hoNumber);
				}
			}
		}
	}	// CImageBank object
	// -----------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	function CMosaic(bank, h)
	{
		this.imageBank = bank;
		this.app = bank.app;
		this.handle = h;
	}
	CMosaic.prototype =
	{
		doLoad: function ()
		{
			var name = this.app.resources + "M" + CServices.formatDiscName(this.handle, "png");
			var image = new Image();
			this.imageBank.mosaics[this.handle] = image;
			var that = this;
			image.onload = function ()
			{
				that.app.dataHasLoaded(that);
			}
			image.onerror = function ()
			{
				that.app.dataHasLoaded(that);
			}
			image.src = name;
		}
	}
	function CImageBank(a)
	{
		this.app = a;
		this.file = null;
		this.images = null;
		this.nHandlesReel = 0;
		this.nHandlesTotal = 0;
		this.nImages = 0;
		this.offsetsToImage = null;
		this.handleToIndex = null;
		this.useCount = null;
		this.rcInfo = null;
		this.hsInfo = null;
		this.apInfo = null;
		this.pIfo = null;
		this.mosaics = null;
		this.oldMosaics = null;
		this.mosaicLoaded = null;
	}
	CImageBank.prototype =
	{
		preLoad:            function (f)
		{
			this.file = f;

			this.nHandlesReel = this.file.readAShort();
			this.offsetsToImage = new Array(this.nHandlesReel);

			var nImg = this.file.readAShort();
			var n;
			var offset;
			var image = new CImage();
			for (n = 0; n < nImg; n++)
			{
				offset = this.file.getFilePointer();
				image.loadHandle(this.file);
				this.offsetsToImage[image.handle] = offset;
			}

			this.useCount = new Array(this.nHandlesReel);
			var n;
			for (n = 0; n < this.nHandlesReel; n++)
				this.useCount[n] = 0;

			this.handleToIndex = null;
			this.nHandlesTotal = this.nHandlesReel;
			this.nImages = 0;
			this.images = null;
		},
		getImageFromHandle: function (handle)
		{
			if (handle >= 0 && handle < this.nHandlesTotal)
				if (this.handleToIndex[handle] != -1)
					return this.images[this.handleToIndex[handle]];
			return null;
		},
		getImageFromIndex:  function (index)
		{
			if (index >= 0 && index < this.nImages)
				return this.images[index];
			return null;
		},
		setAllToLoad:       function ()
		{
			var n;
			for (n = 0; n < this.nHandlesReel; n++)
			{
				if (this.offsetsToImage[n])
					this.useCount[n] = 1;
			}
		},
		resetToLoad:        function ()
		{
			if ((this.app.dwOptions & CRunApp.AH2OPT_LOADDATAATSTART) == 0 && (this.app.dwOptions & CRunApp.AH2OPT_KEEPRESOURCESBETWEENFRAMES) == 0)
			{
				var n;
				for (n = 0; n < this.nHandlesReel; n++)
				{
					this.useCount[n] = 0;
				}
			}
			this.oldMosaics = null;
		},
		setToLoad:          function (handle)
		{
			this.useCount[handle]++;
		},

		enumerate: function (num)
		{
			this.setToLoad(num);
			return -1;
		},

		loadMosaic: function (handle)
		{
			if (this.mosaics[handle] == null)
			{
				if (this.oldMosaics != null && handle < this.oldMosaics.length && this.oldMosaics[handle] != null)
				{
					this.mosaics[handle] = this.oldMosaics[handle];
				}
				else
				{
					this.mosaics[handle] = new CMosaic(this, handle);
					this.app.addDataToLoad(this.mosaics[handle]);
				}
			}
		},

		load: function (file)
		{
			var n;

			// Reset mosaics
			if (this.app.mosaicMaxHandle > 0)
			{
				if (this.mosaics == null)
				{
					this.mosaics = new Array(this.app.mosaicMaxHandle);
					if (this.app.dwOptions & CRunApp.AH2OPT_LOADDATAATSTART)
					{
						for (n = 0; n < this.app.mosaicMaxHandle; n++)
						{
							if (this.app.mosaics[n])
								this.loadMosaic(n);
						}
					}
				}
				else
				{
					if ((this.app.dwOptions & CRunApp.AH2OPT_LOADDATAATSTART) == 0)
					{
						this.oldMosaics = new Array(this.app.mosaicMaxHandle);
						for (n = 0; n < this.app.mosaicMaxHandle; n++)
							this.oldMosaics[n] = this.mosaics[n];

						this.mosaics = new Array(this.app.mosaicMaxHandle);
						for (n = 0; n < this.app.mosaicMaxHandle; n++)
							this.mosaics[n] = null;
					}
				}
			}

			this.nImages = 0;
			for (n = 0; n < this.nHandlesReel; n++)
			{
				if (this.useCount[n] != 0)
					this.nImages++;
			}

			var newImages = new Array(this.nImages);
			var count = 0;
			var h;
			for (h = 0; h < this.nHandlesReel; h++)
			{
				if (this.useCount[h] != 0)
				{
					if (this.images != null && this.handleToIndex[h] != -1 && this.images[this.handleToIndex[h]] != null)
					{
						newImages[count] = this.images[this.handleToIndex[h]];
						newImages[count].useCount = this.useCount[h];
						if (this.mosaics != null && this.oldMosaics != null)
						{
							var handle = newImages[count].mosaic;
							if (handle > 0)
								this.mosaics[handle] = this.oldMosaics[handle];
						}
					}
					else
					{
						if (this.offsetsToImage[h] != 0)
						{
							newImages[count] = new CImage();
							file.seek(this.offsetsToImage[h]);
							newImages[count].load(this.app);
							newImages[count].useCount = this.useCount[h];
						}
					}
					count++;
				}
				/*          else
				 {
				 }
				 */
			}
			this.images = newImages;

			this.handleToIndex = new Array(this.nHandlesReel);
			for (n = 0; n < this.nHandlesReel; n++)
			{
				this.handleToIndex[n] = -1;
			}
			for (n = 0; n < this.nImages; n++)
			{
				if (this.images[n])
				{
					this.handleToIndex[this.images[n].handle] = n;
				}
			}
			this.nHandlesTotal = this.nHandlesReel;
		},

		delImage:      function (handle)
		{
			var img = this.getImageFromHandle(handle);
			if (img != null)
			{
				img.useCount--;
				if (img.useCount <= 0)
				{
					var n;
					for (n = 0; n < this.nImages; n++)
					{
						if (this.images[n] == img)
						{
							this.images[n] = null;
							this.handleToIndex[handle] = -1;
							break;
						}
					}
				}
			}
		},
		/*
		 addImageCompare:function(newImage, xSpot, ySpot, xAP, yAP)
		 {
		 var i;
		 var width=newImage.width;
		 var height=newImage.height;
		 for (i=0; ithis.<nImages; i++)
		 {
		 if (this.images[i]!=null)
		 {
		 if (this.images[i].xSpot==xSpot && this.images[i].ySpot==ySpot && this.images[i].xAP==xAP && this.images[i].yAP==yAP)
		 {
		 if (width==this.images[i].img.width && height==this.images[i].img.height)
		 {
		 // Prend les pixels de la nouvelle image
		 if (newPixels==null)
		 {
		 var newRect:Rectangle=new Rectangle(0, 0, width, height);
		 newPixels=newImage.getPixels(newRect);
		 }

		 // Prend les pixels de l'image de la banque
		 var oldRect:Rectangle=new Rectangle(0, 0, width, height);
		 var oldPixels:ByteArray=images[i].img.getPixels(oldRect);

		 // Comparaison
		 var bEqual:Boolean=true;
		 var x:int, y:int;
		 for (y=0; y<height; y++)
		 {
		 for (x=0; x<width; x++)
		 {
		 if (newPixels[y*width+x]!=oldPixels[y*width+x])
		 {
		 bEqual=false;
		 break;
		 }
		 }
		 if (bEqual==false)
		 {
		 break;
		 }
		 }

		 // Image trouvee
		 if (bEqual)
		 {
		 images[i].useCount++;
		 return images[i].handle;
		 }
		 }
		 }
		 }
		 }
		 return addImage(newImage, xSpot, ySpot, xAP, yAP, 1);
		 },
		 */
		addImage:      function (image)
		{
			var h;

			// Cherche un handle libre
			var hFound = -1;
			for (h = this.nHandlesReel; h < this.nHandlesTotal; h++)
			{
				if (this.handleToIndex[h] == -1)
				{
					hFound = h;
					break;
				}
			}

			// Rajouter un handle
			if (hFound == -1)
			{
				this.handleToIndex.push(0);
				hFound = this.nHandlesTotal++;
			}

			// Cherche une image libre
			var i;
			var iFound = -1;
			for (i = 0; i < this.nImages; i++)
			{
				if (this.images[i] == null)
				{
					iFound = i;
					break;
				}
			}

			// Rajouter une image?
			if (iFound == -1)
			{
				this.images.push(0);
				iFound = this.nImages++;
			}

			// Ajoute la nouvelle image
			this.handleToIndex[hFound] = iFound;
			this.images[iFound] = image;
			this.useCount[hFound] = 1;

			return hFound;
		},
		loadImageList: function (handles)
		{
			var h;

			for (h = 0; h < handles.length; h++)
			{
				if (handles[h] >= 0 && handles[h] < this.nHandlesTotal)
				{
					if (this.offsetsToImage[handles[h]] != 0)
					{
						if (this.getImageFromHandle(handles[h]) == null)
						{
							var i;
							var iFound = -1;
							for (i = 0; i < this.nImages; i++)
							{
								if (this.images[i] == null)
								{
									iFound = i;
									break;
								}
							}
							if (iFound == -1)
							{
								var newImages = new Array(this.nImages + 10);
								for (i = 0; i < this.nImages; i++)
								{
									newImages[i] = this.images[i];
								}
								for (; i < this.nImages + 10; i++)
								{
									newImages[i] = null;
								}
								iFound = this.nImages;
								this.nImages += 10;
								this.images = newImages;
							}
							this.handleToIndex[handles[h]] = iFound;
							this.images[iFound] = new CImage();
							this.images[iFound].useCount = 1;
							this.file.seek(this.offsetsToImage[handles[h]]);
							this.images[iFound].load(this.app);
						}
					}
				}
			}
		},

		getImageInfoEx: function (nImage, nAngle, fScaleX, fScaleY)
		{
			var ptei;
			if (this.pIfo == null)
			{
				this.pIfo = new CImage();
			}

			ptei = this.getImageFromHandle(nImage);
			if (ptei != null)
			{
				var cx = ptei.width;
				var cy = ptei.height;
				var hsx = ptei.xSpot;
				var hsy = ptei.ySpot;
				var asx = ptei.xAP;
				var asy = ptei.yAP;

				if (nAngle == 0)
				{
					if (fScaleX != 1.0)
					{
						hsx = hsx * fScaleX;
						asx = asx * fScaleX;
						cx = cx * fScaleX;
					}

					if (fScaleY != 1.0)
					{
						hsy = hsy * fScaleY;
						asy = asy * fScaleY;
						cy = cy * fScaleY;
					}
				}
				else
				{
					if (fScaleX != 1.0)
					{
						hsx = hsx * fScaleX;
						asx = asx * fScaleX;
						cx = cx * fScaleX;
					}

					if (fScaleY != 1.0)
					{
						hsy = hsy * fScaleY;
						asy = asy * fScaleY;
						cy = cy * fScaleY;
					}

					if (this.rcInfo == null)
					{
						this.rcInfo = new CRect();
					}
					if (this.hsInfo == null)
					{
						this.hsInfo = new CPoint();
					}
					if (this.apInfo == null)
					{
						this.apInfo = new CPoint();
					}
					this.hsInfo.x = hsx;
					this.hsInfo.y = hsy;
					this.apInfo.x = asx;
					this.apInfo.y = asy;
					this.rcInfo.left = this.rcInfo.top = 0;
					this.rcInfo.right = cx;
					this.rcInfo.bottom = cy;
					this.doRotateRect(this.rcInfo, this.hsInfo, this.apInfo, nAngle);
					cx = this.rcInfo.right;
					cy = this.rcInfo.bottom;
					hsx = this.hsInfo.x;
					hsy = this.hsInfo.y;
					asx = this.apInfo.x;
					asy = this.apInfo.y;
				}
				this.pIfo.width = cx;
				this.pIfo.height = cy;
				this.pIfo.xSpot = hsx;
				this.pIfo.ySpot = hsy;
				this.pIfo.xAP = asx;
				this.pIfo.yAP = asy;

				return this.pIfo;
			}
			return ptei;
		},

		doRotateRect: function (prc, pHotSpot, pActionPoint, fAngle)
		{
			var x, y;
			var cosa, sina;

			if (fAngle == 90.0)
			{
				cosa = 0.0;
				sina = 1.0;
			}
			else if (fAngle == 180.0)
			{
				cosa = -1.0;
				sina = 0.0;
			}
			else if (fAngle == 270.0)
			{
				cosa = 0.0;
				sina = -1.0;
			}
			else
			{
				var arad = fAngle * Math.PI / 180.0;
				cosa = Math.cos(arad);
				sina = Math.sin(arad);
			}

			var topLeftX;
			var topLeftY;

			var nhxcos;
			var nhxsin;
			var nhycos;
			var nhysin;
			if (pHotSpot == null)
			{
				nhxcos = nhxsin = nhycos = nhysin = 0.0;
				topLeftX = topLeftY = 0;
			}
			else
			{
				nhxcos = -pHotSpot.x * cosa;
				nhxsin = -pHotSpot.x * sina;
				nhycos = -pHotSpot.y * cosa;
				nhysin = -pHotSpot.y * sina;
				topLeftX = nhxcos + nhysin;
				topLeftY = nhycos - nhxsin;
			}

			var topRightX;
			var topRightY;

			if (pHotSpot == null)
				x = prc.right;
			else
				x = prc.right - pHotSpot.x;
			nhxcos = x * cosa;
			nhxsin = x * sina;
			topRightX = nhxcos + nhysin;
			topRightY = nhycos - nhxsin;

			var bottomRightX
			var bottomRightY;

			if (pHotSpot == null)
				y = prc.bottom;
			else
				y = prc.bottom - pHotSpot.y;
			nhycos = y * cosa;
			nhysin = y * sina;
			bottomRightX = nhxcos + nhysin;
			bottomRightY = nhycos - nhxsin;

			var bottomLeftX;
			var bottomLeftY;
			bottomLeftX = topLeftX + bottomRightX - topRightX;
			bottomLeftY = topLeftY + bottomRightY - topRightY;

			var xmin = Math.min(topLeftX, Math.min(topRightX, Math.min(bottomRightX, bottomLeftX)));
			var ymin = Math.min(topLeftY, Math.min(topRightY, Math.min(bottomRightY, bottomLeftY)));
			var xmax = Math.max(topLeftX, Math.max(topRightX, Math.max(bottomRightX, bottomLeftX)));
			var ymax = Math.max(topLeftY, Math.max(topRightY, Math.max(bottomRightY, bottomLeftY)));

			if (pActionPoint != null)
			{
				if (pHotSpot == null)
				{
					x = pActionPoint.x;
					y = pActionPoint.y;
				}
				else
				{
					x = pActionPoint.x - pHotSpot.x;
					y = pActionPoint.y - pHotSpot.y;
				}
				pActionPoint.x = (x * cosa + y * sina) - xmin;
				pActionPoint.y = (y * cosa - x * sina) - ymin;
			}

			if (pHotSpot != null)
			{
				pHotSpot.x = -xmin;
				pHotSpot.y = -ymin;
			}

			prc.right = xmax - xmin;
			prc.bottom = ymax - ymin;
		}
	}

	// CImage Object
	// ----------------------------------------------------------------------------
	CImage.maxRotatedMasks = 10;
	function CImage()
	{
		this.app = null;
		this.handle = 0;
		this.width = 0;
		this.height = 0;
		this.xSpot = 0;
		this.ySpot = 0;
		this.xAP = 0;
		this.yAP = 0;
		this.useCount = 0;
		this.img = null;
		this.maskNormal = null;
		this.maskPlatform = null;
		this.maskRotation = null;
		this.filePointer = null;
		this.mosaic = 0;
		this.mosaicX = 0;
		this.mosaicY = 0;
		this.texID = -1;
		this.texCoords = null;
	}
	CImage.createFromFile = function (application, fileName)
	{
		var image = new CImage();
		image.app = application;
		image.img = new Image();
		image.img.onload = function ()
		{
			image.app.imagesLoaded++;
			image.width = image.img.width;
			image.height = image.img.height;
		}
		application.imagesToLoad++;
		application.loading = true;
		image.img.src = application.resources + fileName;
		return image;
	}
	CImage.prototype =
	{
		loadHandle:    function (file)
		{
			this.filePointer = file.getFilePointer();
			this.handle = file.readAShort();
			file.skipBytes(12);
		},
		doLoad:        function ()
		{
			this.img = new Image();
			var that = this;
			this.img.onload = function ()
			{
				that.app.dataHasLoaded(that);
			}
			this.img.onerror = function ()
			{
				that.app.dataHasLoaded(that);
			}
			var name = this.app.resources + CServices.formatDiscName(this.handle, "png");
			this.img.src = name;
		},
		load:          function (a)
		{
			this.app = a;
			this.filePointer = a.file.getFilePointer();

			this.handle = a.file.readAShort();
			this.width = a.file.readAShort();
			this.height = a.file.readAShort();
			this.xSpot = a.file.readShort();
			this.ySpot = a.file.readShort();
			this.xAP = a.file.readShort();
			this.yAP = a.file.readShort();
			this.mosaic = 0;
			this.img = null;
			if (this.app.frame.mosaicHandles != null)
			{
				this.mosaic = this.app.frame.mosaicHandles[this.handle];
				if (this.mosaic != 0)
				{
					this.app.imageBank.loadMosaic(this.mosaic);
					this.mosaicX = this.app.frame.mosaicX[this.handle];
					this.mosaicY = this.app.frame.mosaicY[this.handle];
				}
				else
				{
					this.app.addDataToLoad(this);
				}
			}
			else
				this.app.addDataToLoad(this);
		},
		createElement: function ()
		{
			var e = document.createElement('div');

			e.style.width = this.width + 'px';
			e.style.height = this.height + 'px';

			e.style.backgroundRepeat = 'no-repeat';

			if (this.mosaic == 0)
			{
				e.style.backgroundImage = "url('" + this.img.src + "')";
			}
			else
			{
				e.style.backgroundPosition = '-' + this.mosaicX + 'px -' + this.mosaicY + 'px';
				e.style.backgroundImage = "url('" + this.app.resources + "M" + CServices.formatDiscName(this.mosaic, "png") + "')";
			}

			return e;
		},
		getPixel:      function (x, y)
		{
			var canvas = document.createElement("canvas");
			canvas.width = this.width;
			canvas.height = this.height;
			var context = canvas.getContext("2d");
			if (this.mosaic == 0)
			{
				context.drawImage(this.img, 0, 0);
			}
			else
			{
				context.drawImage(this.app.imageBank.mosaics[this.mosaic],
					this.mosaicX, this.mosaicY,
					this.width, this.height, 0, 0,
					this.width, this.height);
			}
			var imgd = context.getImageData(x, y, 1, 1);
			return (imgd.data[0] << 16) | (imgd.data[1] << 8) | imgd.data[2];
		},
		getMask:       function (flags, angle, scaleX, scaleY)
		{
			if ((flags & CMask.GCMF_PLATFORM) == 0)
			{
				if (this.maskNormal == null)
				{
					this.maskNormal = new CMask();
					this.maskNormal.createMask(this.app, this, flags);
				}
				if (angle == 0 && scaleX == 1.0 && scaleY == 1.0)
				{
					return this.maskNormal;
				}

				var rMask;
				if (this.maskRotation == null)
				{
					this.maskRotation = new CArrayList();
				}
				var n;
				var tick = 0x7FFFFFFF;
				var nOldest = -1;
				for (n = 0; n < this.maskRotation.size(); n++)
				{
					rMask = this.maskRotation.get(n);
					if (angle == rMask.angle && scaleX == rMask.scaleX && scaleY == rMask.scaleY)
					{
						return rMask.mask;
					}
					if (rMask.tick < tick)
					{
						tick = rMask.tick;
						nOldest = n;
					}
				}
				if (this.maskRotation.size() < this.maxRotatedMasks)
				{
					nOldest = -1;
				}
				rMask = new CRotatedMask();
				rMask.mask = new CMask();
				rMask.mask.createRotatedMask(this.maskNormal, angle, scaleX, scaleY);
				rMask.angle = angle;
				rMask.scaleX = scaleX;
				rMask.scaleY = scaleY;
				rMask.tick = this.app.timer;
				if (nOldest < 0)
				{
					this.maskRotation.add(rMask);
				}
				else
				{
					this.maskRotation.set(nOldest, rMask);
				}
				return rMask.mask;
			}
			else
			{
				if (this.maskPlatform == null)
				{
					if (this.maskNormal == null)
					{
						this.maskNormal = new CMask();
						this.maskNormal.createMask(this.app, this, 0);
					}
					this.maskPlatform = new CMask();
					this.maskPlatform.createMask(this.app, this, flags);
				}
				return this.maskPlatform;
			}
		}
	}

	// CFontBank object
	// -----------------------------------------------------------------
	function CFontBank(a)
	{
		this.app = a;
		this.file = null;
		this.fonts = null;
		this.offsetsToFonts = null;
		this.nFonts = 0;
		this.handleToIndex = null;
		this.maxHandlesReel = 0;
		this.maxHandlesTotal = 0;
		this.useCount = null;
		this.nullFont = new CFont();
		this.nullFont.createDefaultFont();
	}
	CFontBank.prototype =
	{
		preLoad: function (file)
		{
			var number = file.readAInt();
			var n;

			this.maxHandlesReel = 0;
			var debut = file.getFilePointer();
			var temp = new CFont();
			for (n = 0; n < number; n++)
			{
				temp.loadHandle(file);
				this.maxHandlesReel = Math.max(this.maxHandlesReel, temp.handle + 1);
			}
			file.seek(debut);
			this.offsetsToFonts = new Array(this.maxHandlesReel);
			for (n = 0; n < number; n++)
			{
				debut = file.getFilePointer();
				temp.loadHandle(file);
				this.offsetsToFonts[temp.handle] = debut;
			}
			this.useCount = new Array(this.maxHandlesReel);
			var n;
			for (n = 0; n < this.maxHandlesReel; n++)
				this.useCount[n] = 0;
			this.handleToIndex = null;
			this.maxHandlesTotal = this.maxHandlesReel;
			this.nFonts = 0;
			this.fonts = null;
		},

		load: function (file)
		{
			var n;
			this.nFonts = 0;
			for (n = 0; n < this.maxHandlesReel; n++)
			{
				if (this.useCount[n] != 0)
				{
					this.nFonts++;
				}
			}

			var newFonts = new Array(this.nFonts);
			var count = 0;
			var h;
			for (h = 0; h < this.maxHandlesReel; h++)
			{
				if (this.useCount[h] != 0)
				{
					if (this.fonts != null && this.handleToIndex[h] != -1 && this.fonts[this.handleToIndex[h]] != null)
					{
						newFonts[count] = this.fonts[this.handleToIndex[h]];
						newFonts[count].useCount = this.useCount[h];
					}
					else
					{
						newFonts[count] = new CFont();
						file.seek(this.offsetsToFonts[h]);
						newFonts[count].load(file);
						newFonts[count].useCount = this.useCount[h];
					}
					count++;
				}
			}
			this.fonts = newFonts;

			this.handleToIndex = new Array(this.maxHandlesReel);
			for (n = 0; n < this.maxHandlesReel; n++)
			{
				this.handleToIndex[n] = -1;
			}
			for (n = 0; n < this.nFonts; n++)
			{
				this.handleToIndex[this.fonts[n].handle] = n;
			}
			this.maxHandlesTotal = this.maxHandlesReel;
		},

		getFontFromHandle: function (handle)
		{
			if (handle == -1)
			{
				return this.nullFont;
			}
			if (handle >= 0 && handle < this.maxHandlesTotal)
				if (this.handleToIndex[handle] != -1)
					return this.fonts[this.handleToIndex[handle]];
			return null;
		},

		getFontFromIndex: function (index)
		{
			if (index >= 0 && index < this.nFonts)
				return this.fonts[index];
			return null;
		},

		getFontInfoFromHandle: function (handle)
		{
			var font = this.getFontFromHandle(handle);
			return font.getFontInfo();
		},

		resetToLoad: function ()
		{
			if ((this.app.dwOption & CRunApp.AH2OPT_LOADDATAATSTART) == 0 && (this.app.dwOptions & CRunApp.AH2OPT_KEEPRESOURCESBETWEENFRAMES) == 0)
			{
				var n;
				for (n = 0; n < this.maxHandlesReel; n++)
				{
					this.useCount[n] = 0;
				}
			}
		},

		setAllToLoad: function ()
		{
			var n;
			for (n = 0; n < this.maxHandlesReel; n++)
			{
				if (this.offsetsToFonts[n])
					this.useCount[n] = 1;
			}
		},

		setToLoad: function (handle)
		{
			if (handle == -1)
			{
				if (this.nullFont == null)
				{
					this.nullFont = new CFont();
					this.nullFont.createDefaultFont();
				}
				return;
			}
			this.useCount[handle]++;
		},

		enumerate: function (num)
		{
			this.setToLoad(num);
			return -1;
		},

		addFont: function (info)
		{
			var h;

			// Cherche une fonte identique
			var n;
			for (n = 0; n < this.nFonts; n++)
			{
				if (this.fonts[n] == null) continue;
				if (this.fonts[n].lfHeight != info.lfHeight) continue;
				if (this.fonts[n].lfWeight != info.lfWeight) continue;
				if (this.fonts[n].lfItalic != info.lfItalic) continue;
				if (this.fonts[n].lfFaceName != info.lfFaceName) continue;
				break;
			}
			if (n < this.nFonts)
			{
				return this.fonts[n].handle;
			}

			var hFound = -1;
			for (h = this.maxHandlesReel; h < this.maxHandlesTotal; h++)
			{
				if (this.handleToIndex[h] == -1)
				{
					this.hFound = h;
					break;
				}
			}

			if (hFound == -1)
			{
				var newHToI = new Array(this.maxHandlesTotal + 10);
				for (h = 0; h < this.maxHandlesTotal; h++)
				{
					newHToI[h] = this.handleToIndex[h];
				}
				for (; h < this.maxHandlesTotal + 10; h++)
				{
					newHToI[h] = -1;
				}
				hFound = this.maxHandlesTotal;
				this.maxHandlesTotal += 10;
				this.handleToIndex = newHToI;
			}

			var f;
			var fFound = -1;
			for (f = 0; f < this.nFonts; f++)
			{
				if (this.fonts[f] == null)
				{
					fFound = f;
					break;
				}
			}

			if (fFound == -1)
			{
				fFound = this.nFonts;
				this.fonts.push(null);
			}

			this.handleToIndex[hFound] = fFound;
			this.fonts[fFound] = new CFont();
			this.fonts[fFound].handle = hFound;
			this.fonts[fFound].lfHeight = info.lfHeight;
			this.fonts[fFound].lfWeight = info.lfWeight;
			this.fonts[fFound].lfItalic = info.lfItalic;
			this.fonts[fFound].lfFaceName = info.lfFaceName;

			return hFound;
		}
	}

	// CFont object
	// ------------------------------------------------------
	function CFont()
	{
		this.useCount = 0;
		this.handle = 0;
		this.lfHeight = 0;
		this.lfWeight = 0;
		this.lfItalic = 0;
		this.lfFaceName = null;
		this.font = null;
		this.isGraphic = false;
	}
	CFont.prototype =
	{
		loadHandle: function (file)
		{
			this.handle = file.readAInt();
			if (file.bUnicode == false)
			{
				file.skipBytes(0x48);
			}
			else
			{
				file.skipBytes(0x68);
			}
		},

		load: function (file)
		{
			this.handle = file.readAInt();
			var debut = file.getFilePointer();
			file.skipBytes(12);

			this.lfHeight = file.readAInt();
			if (this.lfHeight < 0)
				this.lfHeight = -this.lfHeight;
			file.readAInt();
			file.readAInt();
			file.readAInt();
			this.lfWeight = file.readAInt();
			this.lfItalic = file.readAByte();
			file.readAByte();
			file.readAByte();
			file.readAByte();
			file.readAByte();
			file.readAByte();
			file.readAByte();
			file.readAByte();
			this.lfFaceName = file.readAString();

			if (file.bUnicode == false)
			{
				file.seek(debut + 0x48);
			}
			else
			{
				file.seek(debut + 0x68);
			}
		},

		getFontInfo: function ()
		{
			var info = new CFontInfo();
			info.lfHeight = this.lfHeight;
			info.lfWeight = this.lfWeight;
			info.lfItalic = this.lfItalic;
			info.lfFaceName = this.lfFaceName;
			return info;
		},

		createDefaultFont: function ()
		{
			this.lfFaceName = "Arial";
			this.lfHeight = 13;
			this.lfWeight = 400;
			this.lfItalic = 0;
		},

		getHeight: function ()
		{
		    return this.lfHeight + Math.ceil(this.lfHeight / 8);
		},

		getFont: function ()
		{
			if (this.font == null)
			{
				if (this.lfItalic)
					this.font = "italic ";
				else
					this.font = "normal "

				var weight = Math.floor(this.lfWeight / 100) * 100;
				weight = Math.max(weight, 100);
				weight = Math.min(weight, 900);
				this.font += weight + " ";

				var height = this.lfHeight; // CServices.heightNormalToLF(this.lfHeight);
				this.font += height + "px ";
				this.font += this.lfFaceName;
			}
			return this.font;
		}
	}

	// CSoundBank object
	// -----------------------------------------------------------------

	function CSoundBank(a)
	{
		this.app = a;
		this.sounds = null;
		this.nHandlesReel = 0;
		this.nHandlesTotal = 0;
		this.nSounds = 0;
		this.offsetsToSounds = null;
		this.handleToIndex = null;
		this.useCount = null;
		this.file = null;
		//  this.bChrome=navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
	}
	CSoundBank.prototype =
	{
		preLoad: function (f)
		{
			this.file = f;

			this.nHandlesReel = this.file.readAShort();
			this.offsetsToSounds = new Array(this.nHandlesReel);
			this.useCount = new Array(this.nHandlesReel);
			this.handleToIndex = new Array(this.nHandlesReel);
			var n;
			for (n = 0; n < this.nHandlesReel; n++)
			{
				this.useCount[n] = 0;
				this.handleToIndex[n] = -1;
			}

			var nSons = this.file.readAShort();
			var n;
			var sound = new CSound(this.app);
			var offset;
			for (n = 0; n < nSons; n++)
			{
				offset = this.file.getFilePointer();
				sound.loadHandle();
				this.offsetsToSounds[sound.handle] = offset;
			}

			this.nHandlesTotal = this.nHandlesReel;
			this.nSounds = 0;
			this.sounds = null;
		},

		getSoundFromHandle: function (handle)
		{
			if (handle >= 0 && handle < this.nHandlesTotal)
				if (this.handleToIndex[handle] != -1)
					return this.sounds[this.handleToIndex[handle]];
			return null;
		},
		checkLoad:          function ()
		{
			var index;
			for (index = 0; index < this.nSounds; index++)
			{
				if (this.sounds[index] != null)
				{
					this.sounds[index].checkLoad();
				}
			}
		},
		getSoundFromIndex:  function (index)
		{
			if (index >= 0 && index < this.nSounds)
				return this.sounds[index];
			return null;
		},

		resetToLoad: function ()
		{
			if ((this.app.dwOptions & CRunApp.AH2OPT_LOADDATAATSTART) == 0 && (this.app.dwOptions & CRunApp.AH2OPT_KEEPRESOURCESBETWEENFRAMES) == 0)
			{
				var n;
				for (n = 0; n < this.nHandlesReel; n++)
					this.useCount[n] = 0;
			}
		},

		setAllToLoad: function ()
		{
			var n;
			for (n = 0; n < this.nHandlesReel; n++)
			{
				if (this.offsetsToSounds[n])
					this.useCount[n] = 1;
			}
		},

		addAllToLoad: function ()
		{
			var n;
			for (n = 0; n < this.nHandlesReel; n++)
			{
				if (this.offsetsToSounds[n])
				{
					this.app.imagesToLoad++;
				}
			}
		},

		setToLoad: function (handle)
		{
			this.useCount[handle]++;
		},

		enumerate: function (num)
		{
			this.setToLoad(num);
			return -1;
		},


		load: function ()
		{
			var n;

			this.nSounds = 0;
			for (n = 0; n < this.nHandlesReel; n++)
			{
				if (this.useCount[n] != 0)
					this.nSounds++;
			}

			var newSounds = new Array(this.nSounds);
			var count = 0;
			var h;
			for (h = 0; h < this.nHandlesReel; h++)
			{
				if (this.useCount[h] != 0)
				{
					if (this.sounds != null && this.handleToIndex[h] != -1 && this.sounds[this.handleToIndex[h]] != null)
					{
						newSounds[count] = this.sounds[this.handleToIndex[h]];
						newSounds[count].useCount = this.useCount[h];
					}
					else
					{
						newSounds[count] = new CSound(this.app);
						this.file.seek(this.offsetsToSounds[h]);
						newSounds[count].load();
						newSounds[count].useCount = this.useCount[h];
					}
					count++;
				}
			}
			this.sounds = newSounds;

			this.handleToIndex = new Array(this.nHandlesReel);
			for (n = 0; n < this.nHandlesReel; n++)
				this.handleToIndex[n] = -1;
			for (n = 0; n < this.nSounds; n++)
				this.handleToIndex[this.sounds[n].handle] = n;
			this.nHandlesTotal = this.nHandlesReel;

			this.resetToLoad();
		}
	}

	// CSound object
	// -----------------------------------------------------------------
	function CSound(a)
	{
		this.application = a;
		this.context = a.soundPlayer.context;
		this.contextType = a.soundPlayer.contextType;
		this.gainNode = a.soundPlayer.gainNode;
		this.type = 0;
		this.file = a.file;
		this.handle = -1;
		this.source = null;
		this.sound = null;
		this.useCount = 0;
		this.bUninterruptible = false;
		this.nLoops = 0;
		this.numSound = 0;
		this.name = null;
		this.bPaused = false;
		this.bPlaying = false;
		this.frequency = 0;
		this.response = null;
		this.gain = null;
	}
	CSound.prototype =
	{
		loadHandle: function ()
		{
			this.handle = this.file.readAShort();
			this.file.skipBytes(5);
			var l = this.file.readAShort();
			if (this.file.bUnicode == false)
				this.file.skipBytes(l);
			else
				this.file.skipBytes(l * 2);
		},

		createFromSound: function ()
		{
			if (HTMLMediaElement.mozLoadFrom)
			{
				var snd = new CSound(this.application);
				snd.handle = this.handle;
				snd.sound = HTMLMediaElement.mozLoadFrom(this.sound);
				snd.name = this.name;
				snd.type = this.type;
				snd.song = this.song;
				snd.type = this.type;
				return snd;
			}
			return this;
		},

		doLoad:     function ()
		{
			var format;
			var playableFormats = this.application.soundPlayer.probablePlayableFormats & this.type;
			if (playableFormats == 0)
				playableFormats = this.application.soundPlayer.maybePlayableFormats & this.type;
			for (format = 0; format < 4; format++)
			{
				if (playableFormats & (1 << format))
				{
					break;
				}
			}
			if (format < 4)
			{
				var ext = "";
				switch (format)
				{
					case 0:
						ext = "ogg";
						break;
					case 1:
						ext = "m4a";
						break;
					case 2:
						ext = "mp3";
						break;
					case 3:
						ext = "wav"
						break;
				}

				if (this.context)
				{
					var that = this;
	                    
						var request = new XMLHttpRequest();
						request.open('GET', this.application.resources + CServices.formatDiscName(this.handle, ext), true);
						request.responseType = 'arraybuffer';
						request.addEventListener('load', function (event)
						{
							that.response = request.response;
							that.application.soundPlayer.addDataToDecode(that);
						});
						request.send();
				}
				else
				{
					this.sound = new Audio();
					this.sound.preload = "auto";

					var that = this;
					this.sound.addEventListener("loadeddata", function (e)
					{
						that.application.dataHasLoaded(that);
						that.sound.removeEventListener('loadeddata', arguments.callee, false);
					}, false);
					this.sound.addEventListener("error", function (e)
					{
						that.application.dataHasLoaded(that);
						that.sound = null;
					}, false);
					this.sound.src = this.application.resources + CServices.formatDiscName(this.handle, ext);
					this.sound.load();
					this.sound.autoplay = false;
				}
			}
			else
				this.application.dataHasLoaded(this);
		},
		load:       function ()
		{
			this.handle = this.file.readAShort();
			this.type = this.file.readAByte();
			this.frequency = this.file.readAInt();
			this.currentFrequency = this.frequency;
			var l = this.file.readAShort();
			this.name = this.file.readAString(l);
			this.sound = null;
			this.application.addDataToLoad(this);
		},
		loadSilent: function ()
		{
			this.handle = 9999;
			this.type = 0x04;
			this.frequency = 40000;
			this.currentFrequency = this.frequency;
			this.name = "";
			this.sound = null;
			this.application.addDataToLoad(this);
		},
		playIt:     function (time, frequency)
		{
			if (!time)
				time = 0;
			if (!frequency)
				frequency = this.frequency;
			if (this.sound)
			{
				this.sound.volume = (this.volume / 100.0);
				this.currentFrequency = frequency;
				this.sound.playbackRate = frequency / this.frequency;
				if (this.sound.duration)
					this.sound.currentTime = 0;
				this.sound.play();
			}
			else if (this.buffer)
			{
				this.source = this.context["createBufferSource"]();
				this.source["buffer"] = this.buffer;
				if (this.contextType == 0)
				{
					this.source["gain"]["value"] = (this.volume / 100.0);
					this.source["connect"](this.context["destination"]);
				}
				else
				{
					this.gain = this.context["createGain"]();
					this.source["connect"](this.gain);
					this.gain["connect"](this.context["destination"]);
					this.gain["gain"]["value"] = (this.volume / 100.0);
				}
				if (!time)
					time = 0;
				if (!frequency)
					frequency = this.frequency;
				this.currentFrequency = frequency;
				this.source["playbackRate"]["value"] = frequency / this.frequency;
				var d = new Date();
				this.startTime = d.getTime();
				if (typeof this.source["start"] !== "undefined")
					this.source["start"](time, time / 1000);
				else
					this.source["noteOn"](time);
				var that = this;
				this.source["onended"] = function (e)
				{
					that.bEnded = true;
				}
			}
			this.bPaused = false;
			this.bPlaying = true;
			this.bEnded = false;
		},
		play:       function (nl, bPrio, v)
		{
			this.nLoops = nl;
			if (this.nLoops == 0)
				this.nLoops = 10000000;
			this.volume = v;

			this.playIt();
		},
		stop:       function ()
		{
			if (this.sound)
				this.sound.pause();
			else if (this.source && this.bPlaying)
			{
				if (typeof this.source["stop"] !== "undefined")
					this.source["stop"](0);
				else
					this.source["noteOff"](0);
				this.source["onended"] = null;
			}
			this.bUninterruptible = false;
			this.bPlaying = false;
		},

		setVolume: function (v)
		{
			this.volume = v;
			if (this.sound)
				this.sound.volume = (v / 100.0);
			else if (this.source)
			{
				if (this.gain)
					this.gain["gain"]["value"] = (v / 100.0);
				else
					this.source["gain"]["value"] = (v / 100.0);
			}
		},

		pause: function ()
		{
			if (this.sound)
				this.sound.pause();
			else if (this.source)
			{
				if (this.gain)
					this.gain["gain"]["value"] = 0;
				else
					this.source["gain"]["value"] = 0;
			}
			this.bPaused = true;
		},

		resume: function ()
		{
			if (this.sound)
				this.sound.play();
			else if (this.source)
			{
				if (this.gain)
					this.gain["gain"]["value"] = this.volume / 100.0;
				else
					this.source["gain"]["value"] = this.volume / 100.0;
			}
			this.bPaused = false;
		},

		isPaused: function ()
		{
			return this.bPaused;
		},

		isPlaying: function ()
		{
			if ((this.sound || this.source) && this.bPlaying)
			{
				return !this.bPaused;
			}
			return false;
		},

		getDuration: function ()
		{
			if (this.sound && this.sound.duration != undefined && isNaN(this.sound.duration) == false && this.sound.duration != Infinity)
			{
				return Math.floor(this.sound.duration * 1000);
			}
			else if (this.source)
			{
				return this.buffer["duration"] * 1000;
			}
			return 0;
		},

		getPosition: function ()
		{
			if (this.sound)
				return Math.floor(this.sound.currentTime * 1000);
			else if (this.source)
			{
				var d = new Date();
				return Math.min(this.buffer["duration"] * 1000, d.getTime() - this.startTime);
			}
			return 0;
		},

		setPosition: function (t)
		{
			if (this.sound)
				this.sound.currentTime = t / 1000;
			else if (this.source)
			{
				if (this.bPlaying)
				{
					if (typeof this.source["stop"] !== "undefined")
						this.source["stop"](0);
					else
						this.source["noteOff"](0);
				}
				this.playIt(t);
			}
		},

		setFrequency: function (t)
		{
			var pitch = t / this.frequency;
			this.currentFrequency = t;
			if (this.sound)
				this.sound.playbackRate = pitch;
			else if (this.source)
				this.source["playbackRate"]["value"] = pitch;
		},

		getFrequency: function (t)
		{
			return this.currentFrequency;
		},

		checkSound: function ()
		{
			if (this.bPlaying == true && this.bPaused == false)
			{
				if (this.sound)
				{
					if (this.sound.ended)
					{
						if (this.nLoops > 0)
						{
							this.nLoops--;
							if (this.nLoops > 0)
							{
								this.playIt(0, this.currentFrequency);
								return false;
							}
						}
						this.bUninterruptible = false;
						this.bPlaying = false;
						return true;
					}
				}
				else if (this.source)
				{
					if (this.source["playbackState"] == 3 || this.bEnded)
					{
						if (this.nLoops > 0)
						{
							this.nLoops--;
							if (this.nLoops > 0)
							{
								this.playIt(0, this.currentFrequency);
								return false;
							}
						}
						this.bUninterruptible = false;
						this.bPlaying = false;
						return true;
					}
				}
			}
			return false;
		}

	}
	    

	    
	// CEventProgram object
	// ---------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 * 
	 * Permission is hereby granted to any person obtaining a legal copy 
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for 
	 * debugging, optimizing, or customizing applications created with 
	 * Clickteam Multimedia Fusion 2. 
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOastlTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	// Fast Loop acceleration
	//////////////////////////////////////////////////////////////////////////////
	function CPosOnLoop(name, index)
	{
		this.name = name;
		this.pointers = new Array();
		this.position = 0;
		this.m_bOR = false;
		this.fastLoopIndex = index;
	}
	CPosOnLoop.prototype =
	{
		AddOnLoop: function (evgPtr)
		{
			this.pointers[this.position++] = evgPtr;
		}
	}

	// CEventProgram
	//////////////////////////////////////////////////////////////////////////////
	CEventProgram.EVENTS_EXTBASE = 80;
	CEventProgram.PARAMCLICK_DOUBLE = 0x100;
	CEventProgram.bts = function (array, index)
	{
	    var d = (index >> 5);           // Build 284.2, fixes bug #2828
	    var mask = 1 << (index & 31);
		var b = (array[d] & mask) != 0;
		array[d] |= mask;
		return b;
	}
	CEventProgram.evg_FindAction = function (evgPtr, n)
	{
		return evgPtr.evgNCond + n;
	}
	CEventProgram.EVTTYPE = function (code)
	{
		var c = code & 0xFFFF;
		if ((c & 0x8000) != 0)
		{
			return c - 65536;
		}
		return c;
	}
	CEventProgram.EVTNUM = function (code)
	{
		return (code >> 16);
	}
	CEventProgram.getEventCode = function (code)
	{
		return code & 0xFFFF0000;
	}

	function CEventProgram(app)
	{
		this.application = app;
		this.rhPtr = null;
		this.maxObjects = 0;
		this.maxOi = 0;
		this.nPlayers = 0;
		this.nConditions = new Array(COI.NUMBEROF_SYSTEMTYPES + COI.OBJ_LAST);
		this.nQualifiers = 0;
		this.nEvents = 0;
		this.qualifiers = null;
		this.events = null;
		this.qualToOiList = null;
		this.listPointers = null;
		this.eventPointersGroup = null;
		this.eventPointersCnd = null;
		this.limitBuffer = null;
		this.rhEvents = new Array(COI.NUMBEROF_SYSTEMTYPES + 1);
		this.rhEventAlways = false;
		this.rh4TimerEventsBase = 0;
		this.colBuffer = null;
		this.qualOilPtr = 0;
		this.qualOilPos = 0;
		this.qualOilPtr2 = 0;
		this.qualOilPos2 = 0;
		this.rh4CheckDoneInstart = false;
		this.rhEventGroup = null;
		this.rhCurCode = 0;
		this.rh4PickFlags = new Array(4);
		this.rh2ActionLoop = false;
		this.rh2ActionOn = false;
		this.rh2EnablePick = false;
		this.rh2EventCount = 0;
		this.rh2ActionCount = 0;
		this.rh2ActionLoopCount = 0;
		this.rh4EventCountOR = 0;
		this.rh4ConditionsFalse = false;
		this.rh3DoStop = false;
		this.rh2EventQualPos = null;
		this.rh2EventQualPosNum = 0;
		this.rh2EventPos = 0;
		this.rh2EventPosOiList = 0;
		this.rh2EventPrev = null;
		this.rh2EventPrevOiList = null;
		this.evtNSelectedObjects = 0;
		this.repeatFlag = false;
		this.rh2EventType = 0;
		this.rhCurOi = 0;
		this.rhCurParam0 = 0;
		this.rhCurParam1 = 0;
		//  this.rh3CurrentMenu=0;
		this.rh2CurrentClick = 0;
		this.rh4_2ndObject = null;
		this.bReady = false;
		this.rh2ShuffleBuffer = null;
		this.rhCurObjectNumber = 0;
		this.rh1stObjectNumber = 0;
		this.rh2PushedEvents = null;
		this.callEndForEach = false;
		this.bTestAllKeys = false;
		this.maxEvents = 0;
		this.complexOnLoop = false;
	}
	CEventProgram.prototype =
	{
		evt_FirstObjectFromType: function (nType)
		{
			this.rh2EventType = nType;
			if (nType == -1)
			{
				var pHo;
				var pHoStore = null;
				var oil;
				var poil;
				var bStore = true;
				for (oil = 0; oil < this.rhPtr.rhOiList.length; oil++)
				{
					poil = this.rhPtr.rhOiList[oil];
					if (CEventProgram.bts(this.rh4PickFlags, poil.oilType) == false)
					{
						pHo = this.evt_SelectAllFromType(poil.oilType, bStore);
						if (pHo != null)
						{
							pHoStore = pHo;
							bStore = false;
						}
					}
				}
				if (pHoStore != null)
				{
					return pHoStore;
				}
			}
			else
			{
				if (CEventProgram.bts(this.rh4PickFlags, nType) == false)
				{
					return this.evt_SelectAllFromType(nType, true);
				}
			}

			var oil2 = 0;
			var oilPtr;
			do
			{
				oilPtr = this.rhPtr.rhOiList[oil2];
				if (oilPtr.oilType == nType)
				{
					if ((oilPtr.oilListSelected & 0x80000000) == 0)
					{
						var pHo = this.rhPtr.rhObjectList[oilPtr.oilListSelected];
						this.rh2EventPrev = null;
						this.rh2EventPrevOiList = oilPtr;
						this.rh2EventPos = pHo;
						this.rh2EventPosOiList = oil2;
						return pHo;
					}
				}
				oil2++; // Un autre OI?
			}
			while (oil2 < this.rhPtr.rhMaxOI);
			return null;
		},

		evt_NextObjectFromType: function ()
		{
			var pHo = this.rh2EventPos;
			var oilPtr;
			if (pHo == null)
			{
				oilPtr = this.rhPtr.rhOiList[this.rh2EventPosOiList];
				if ((oilPtr.oilListSelected & 0x80000000) == 0)
				{
					pHo = this.rhPtr.rhObjectList[oilPtr.oilListSelected];
					this.rh2EventPrev = null;
					this.rh2EventPrevOiList = oilPtr;
					this.rh2EventPos = pHo;
					return pHo;
				}
			}
			if (pHo != null)
			{
				if ((pHo.hoNextSelected & 0x80000000) == 0)
				{
					this.rh2EventPrev = pHo;
					this.rh2EventPrevOiList = null;
					pHo = this.rhPtr.rhObjectList[pHo.hoNextSelected];
					this.rh2EventPos = pHo;
					return pHo;
				}
			}

			var oil = this.rh2EventPosOiList;
			var nType = this.rhPtr.rhOiList[oil].oilType;
			oil++;
			while (oil < this.rhPtr.rhMaxOI)
			{
				if ((this.rh2EventType != -1 && this.rhPtr.rhOiList[oil].oilType == nType) || this.rh2EventType == -1)
				{
					if ((this.rhPtr.rhOiList[oil].oilListSelected & 0x80000000) == 0)
					{
						pHo = this.rhPtr.rhObjectList[this.rhPtr.rhOiList[oil].oilListSelected];
						this.rh2EventPrev = null;
						this.rh2EventPrevOiList = this.rhPtr.rhOiList[oil];
						this.rh2EventPos = pHo;
						this.rh2EventPosOiList = oil;
						return pHo;
					}
				}
				oil++;
			}
			return null;
		},

		evt_SelectAllFromType: function (nType, bStore)
		{
			var first = -1;
			var evtCount = this.rh2EventCount;

			var oil = 0;
			var oilPtr;
			var pHo;
			do
			{
				oilPtr = this.rhPtr.rhOiList[oil];
				if (oilPtr.oilType == nType && oilPtr.oilEventCount != evtCount)
				{
					oilPtr.oilEventCount = evtCount;
					if (this.rh4ConditionsFalse)
					{
						oilPtr.oilListSelected = -1;
						oilPtr.oilNumOfSelected = 0;
					}
					else
					{
						oilPtr.oilNumOfSelected = oilPtr.oilNObjects;
						var num = oilPtr.oilObject;
						if ((num & 0x80000000) == 0)
						{
							if (first == -1 && bStore == true)
							{
								first = num;
								this.rh2EventPrev = null;
								this.rh2EventPrevOiList = oilPtr;
								this.rh2EventPosOiList = oil;
							}
							do
							{
								pHo = this.rhPtr.rhObjectList[num];
								pHo.hoNextSelected = pHo.hoNumNext;
								num = pHo.hoNumNext;
							}
							while ((num & 0x80000000) == 0);

							num = oilPtr.oilObject;
						}
						oilPtr.oilListSelected = num;
					}
				}
				oil++;
			}
			while (oil < this.rhPtr.rhMaxOI);

			if (bStore == false)
			{
				return null;
			}
			if (first < 0)
			{
				return null;
			}

			pHo = this.rhPtr.rhObjectList[first];
			this.rh2EventPos = pHo;
			return pHo;
		},

		evt_FirstObject: function (sEvtOiList)
		{
			var pHo;

			this.evtNSelectedObjects = 0;
			this.rh2EventQualPos = null;
			this.rh2EventQualPosNum = -1;

			if ((sEvtOiList & 0x8000) != 0)
			{
				if ((sEvtOiList & 0x7FFF) == 0x7FFF)
				{
					return null;
				}
				return this.qualProc(sEvtOiList);
			}

			var oilPtr = this.rhPtr.rhOiList[sEvtOiList];
			if (oilPtr.oilEventCount == this.rh2EventCount)
			{
				if ((oilPtr.oilListSelected & 0x80000000) != 0)
				{
					return null;
				}
				pHo = this.rhPtr.rhObjectList[oilPtr.oilListSelected];
				this.rh2EventPrev = null;
				this.rh2EventPrevOiList = oilPtr;
				this.rh2EventPos = pHo;
				this.rh2EventPosOiList = sEvtOiList;
				this.evtNSelectedObjects = oilPtr.oilNumOfSelected;
				return pHo;
			}
			else
			{
				oilPtr.oilEventCount = this.rh2EventCount;

				if (this.rh4ConditionsFalse)
				{
					oilPtr.oilListSelected = -1;
					oilPtr.oilNumOfSelected = 0;
					return null;
				}

				oilPtr.oilListSelected = oilPtr.oilObject;
				if ((oilPtr.oilObject & 0x80000000) != 0)
				{
					oilPtr.oilNumOfSelected = 0;
					return null;
				}
				var num = oilPtr.oilObject;
				do
				{
					pHo = this.rhPtr.rhObjectList[num];
					num = pHo.hoNumNext;
					pHo.hoNextSelected = num;
				}
				while ((num & 0x80000000) == 0);


				pHo = this.rhPtr.rhObjectList[oilPtr.oilObject];
				this.rh2EventPrev = null;
				this.rh2EventPrevOiList = oilPtr;
				this.rh2EventPos = pHo;
				this.rh2EventPosOiList = sEvtOiList;
				oilPtr.oilNumOfSelected = oilPtr.oilNObjects;
				this.evtNSelectedObjects = oilPtr.oilNumOfSelected;
				return pHo;
			}
		},

		qualProc:       function (sEvtOiList)
		{
			var pHo;
			var oilPtr;
			var count = 0;

			var qoi = 0;
			var qoiList;
			var addCount;
			var pQoi = this.qualToOiList[sEvtOiList & 0x7FFF];
			while (qoi < pQoi.qoiList.length)
			{
				qoiList = pQoi.qoiList[qoi + 1];
				oilPtr = this.rhPtr.rhOiList[qoiList];
				if (oilPtr.oilEventCount == this.rh2EventCount)
				{
					addCount = 0;
					if ((oilPtr.oilListSelected & 0x80000000) == 0)
					{
						addCount = oilPtr.oilNumOfSelected;
						if (this.rh2EventQualPos == null)
						{
							this.rh2EventQualPos = pQoi;
							this.rh2EventQualPosNum = qoi;
						}
					}
				}
				else
				{
					addCount = 0;
					oilPtr.oilEventCount = this.rh2EventCount;

					if (this.rh4ConditionsFalse)
					{
						oilPtr.oilListSelected = -1;
						oilPtr.oilNumOfSelected = 0;
					}
					else
					{
						oilPtr.oilListSelected = oilPtr.oilObject;
						if ((oilPtr.oilObject & 0x80000000) != 0)
						{
							oilPtr.oilNumOfSelected = 0;
						}
						else
						{
							if (this.rh2EventQualPos == null)
							{
								this.rh2EventQualPos = pQoi;
								this.rh2EventQualPosNum = qoi;
							}
							var num = oilPtr.oilObject;
							do
							{
								pHo = this.rhPtr.rhObjectList[num];
								pHo.hoNextSelected = pHo.hoNumNext;
								num = pHo.hoNumNext;
							} while ((num & 0x80000000) == 0);

							oilPtr.oilNumOfSelected = oilPtr.oilNObjects;
							addCount = oilPtr.oilNObjects;
						}
					}
				}
				count += addCount;
				qoi += 2;
			}

			pQoi = this.rh2EventQualPos;
			if (pQoi != null)
			{
				oilPtr = this.rhPtr.rhOiList[pQoi.qoiList[this.rh2EventQualPosNum + 1]];
				this.rh2EventPrev = null;
				this.rh2EventPrevOiList = oilPtr;
				pHo = this.rhPtr.rhObjectList[oilPtr.oilListSelected];
				this.rh2EventPos = pHo;
				this.rh2EventPosOiList = pQoi.qoiList[this.rh2EventQualPosNum + 1];
				this.evtNSelectedObjects = count;
				return pHo;
			}
			return null;
		},
		evt_NextObject: function ()
		{
			var pHo = this.rh2EventPos;
			var oilPtr;
			if (pHo == null)
			{
				oilPtr = this.rhPtr.rhOiList[this.rh2EventPosOiList];
				if ((oilPtr.oilListSelected & 0x80000000) == 0)
				{
					pHo = this.rhPtr.rhObjectList[oilPtr.oilListSelected];
					this.rh2EventPrev = null;
					this.rh2EventPrevOiList = oilPtr;
					this.rh2EventPos = pHo;
					return pHo;
				}
			}
			if (pHo != null)
			{
				if ((pHo.hoNextSelected & 0x80000000) == 0)
				{
					this.rh2EventPrev = pHo;
					this.rh2EventPrevOiList = null;
					pHo = this.rhPtr.rhObjectList[pHo.hoNextSelected];
					this.rh2EventPos = pHo;
					return pHo;
				}
			}
			if (this.rh2EventQualPos == null)
			{
				return null;
			}

			do
			{
				this.rh2EventQualPosNum += 2;
				if (this.rh2EventQualPosNum >= this.rh2EventQualPos.qoiList.length)
				{
					return null;
				}
				oilPtr = this.rhPtr.rhOiList[this.rh2EventQualPos.qoiList[this.rh2EventQualPosNum + 1]];
			} while ((oilPtr.oilListSelected & 0x80000000) != 0);

			this.rh2EventPrev = null;
			this.rh2EventPrevOiList = oilPtr;
			pHo = this.rhPtr.rhObjectList[oilPtr.oilListSelected];
			this.rh2EventPos = pHo;
			this.rh2EventPosOiList = this.rh2EventQualPos.qoiList[this.rh2EventQualPosNum + 1];
			return pHo;
		},

		evt_AddCurrentQualifier: function (qual)
		{
			var pQoi = this.qualToOiList[qual & 0x7FFF];
			var noil = 0;
			var oilPtr;
			while (noil < pQoi.qoiList.length)
			{
				oilPtr = this.rhPtr.rhOiList[pQoi.qoiList[noil + 1]];
				if (oilPtr.oilEventCount != this.rh2EventCount)
				{
					oilPtr.oilEventCount = this.rh2EventCount;
					oilPtr.oilNumOfSelected = 0;
					oilPtr.oilListSelected = -1;
				}
				noil += 2;
			}
			;
		},

		evt_DeleteCurrentObject: function ()
		{
			this.rh2EventPos.hoOiList.oilNumOfSelected -= 1;
			if (this.rh2EventPrev != null)
			{
				this.rh2EventPrev.hoNextSelected = this.rh2EventPos.hoNextSelected;
				this.rh2EventPos = this.rh2EventPrev;
			}
			else
			{
				//            rhPtr.rhOiList[rh2EventPosOiList].oilListSelected=rh2EventPos.hoNextSelected;
				this.rh2EventPrevOiList.oilListSelected = this.rh2EventPos.hoNextSelected;
				this.rh2EventPos = null;
			}
		},

		evt_AddCurrentObject: function (pHo)
		{
			var oilPtr = pHo.hoOiList;
			if (oilPtr.oilEventCount != this.rh2EventCount)
			{
				oilPtr.oilEventCount = this.rh2EventCount;
				oilPtr.oilListSelected = pHo.hoNumber;
				oilPtr.oilNumOfSelected = 1;
				pHo.hoNextSelected = -1;
			}
			else
			{
				var oils = oilPtr.oilListSelected;
				if ((oils & 0x80000000) != 0)
				{
					oilPtr.oilListSelected = pHo.hoNumber;
					oilPtr.oilNumOfSelected += 1;
					pHo.hoNextSelected = -1;
				}
				else
				{
					var pHo1;
					do
					{
						if (pHo.hoNumber == oils)
						{
							return;
						}
						pHo1 = this.rhPtr.rhObjectList[oils];
						oils = pHo1.hoNextSelected;
					} while ((oils & 0x80000000) == 0);

					pHo1.hoNextSelected = pHo.hoNumber;
					pHo.hoNextSelected = -1;
					pHo.hoOiList.oilNumOfSelected += 1;
				}
			}
		},

		deselectThem: function (oil)
		{
			var poil = this.rhPtr.rhOiList[oil];
			poil.oilEventCount = this.rh2EventCount;
			poil.oilListSelected = -1;
			poil.oilNumOfSelected = 0;
		},

		evt_ForceOneObject: function (oil, pHo)
		{
			if ((oil & 0x8000) == 0)
			{
				this.deselectThem(oil);
			}
			else
			{
				if ((oil & 0x7FFF) == 0x7FFF)
				{
					return;
				}
				var pqoi = this.qualToOiList[oil & 0x7FFF];
				var qoi;
				for (qoi = 0; qoi < pqoi.qoiList.length; qoi += 2)
				{
					this.deselectThem(pqoi.qoiList[qoi + 1]);
				}
			}
			pHo.hoNextSelected = -1;
			pHo.hoOiList.oilListSelected = pHo.hoNumber;
			pHo.hoOiList.oilNumOfSelected = 1;
			pHo.hoOiList.oilEventCount = this.rh2EventCount;
		},

		evt_DeleteCurrentType: function (nType)
		{
			CEventProgram.bts(this.rh4PickFlags, nType);

			var oil;
			var oilPtr;
			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
			{
				oilPtr = this.rhPtr.rhOiList[oil];
				if (oilPtr.oilType == nType)
				{
					oilPtr.oilEventCount = this.rh2EventCount;
					oilPtr.oilListSelected = -1;
					oilPtr.oilNumOfSelected = 0;
				}
			}
		},

		evt_DeleteCurrent: function ()
		{
			this.rh4PickFlags[0] = -1;
			this.rh4PickFlags[1] = -1;
			this.rh4PickFlags[2] = -1;
			this.rh4PickFlags[3] = -1;

			var oil;
			var oilPtr;
			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
			{
				oilPtr = this.rhPtr.rhOiList[oil];
				oilPtr.oilEventCount = this.rh2EventCount;
				oilPtr.oilListSelected = -1;
				oilPtr.oilNumOfSelected = 0;
			}
		},

		evt_MarkSelectedObjects: function ()
		{
			var num;
			var pHO;
			var oil;
			var oilPtr;

			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
			{
				oilPtr = this.rhPtr.rhOiList[oil];
				if (oilPtr.oilEventCount == this.rh2EventCount)
				{
					if (oilPtr.oilEventCountOR != this.rh4EventCountOR)
					{
						oilPtr.oilEventCountOR = this.rh4EventCountOR;
						num = oilPtr.oilObject;
						while ((num & 0x80000000) == 0)
						{
							pHO = this.rhPtr.rhObjectList[num];
							pHO.hoSelectedInOR = 0;
							num = pHO.hoNumNext;
						}
					}
					num = oilPtr.oilListSelected;
					while ((num & 0x80000000) == 0)
					{
						pHO = this.rhPtr.rhObjectList[num];
						pHO.hoSelectedInOR = 1;
						num = pHO.hoNextSelected;
					}
				}
			}
		},

		evt_BranchSelectedObjects: function ()
		{
			var num;
			var pHO, pHOPrev;
			var oil;
			var oilPtr;

			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
			{
				oilPtr = this.rhPtr.rhOiList[oil];
				if (oilPtr.oilEventCountOR == this.rh4EventCountOR)
				{
					oilPtr.oilEventCount = this.rh2EventCount;

					num = oilPtr.oilObject;
					pHOPrev = null;
					while ((num & 0x80000000) == 0)
					{
						pHO = this.rhPtr.rhObjectList[num];
						if (pHO.hoSelectedInOR != 0)
						{
							if (pHOPrev != null)
							{
								pHOPrev.hoNextSelected = num;
							}
							else
							{
								oilPtr.oilListSelected = num;
							}
							pHO.hoNextSelected = -1;
							pHOPrev = pHO;
						}
						num = pHO.hoNumNext;
					}
				}
			}
		},

		get_ExpressionObjects: function (expoi)
		{
			var object;
			if (this.rh2ActionOn)
			{
				this.rh2EnablePick = false;
				var object = this.get_CurrentObjects(expoi);
				return object;
			}

			var oilPtr;
			if ((expoi & 0x8000) == 0)
			{
				oilPtr = this.rhPtr.rhOiList[expoi];
				if (oilPtr.oilEventCount == this.rh2EventCount)
				{
					if ((oilPtr.oilListSelected & 0x80000000) == 0)
					{
						return this.rhPtr.rhObjectList[oilPtr.oilListSelected];
					}
					if ((oilPtr.oilObject & 0x80000000) == 0)
					{
						return this.rhPtr.rhObjectList[oilPtr.oilObject];
					}
					return null;
				}
				else
				{
					if ((oilPtr.oilObject & 0x80000000) == 0)
					{
						return this.rhPtr.rhObjectList[oilPtr.oilObject];
					}
					return null;
				}
			}

			var pQoi = this.qualToOiList[expoi & 0x7FFF];
			var qoi = 0;
			if (qoi >= pQoi.qoiList.length)
			{
				return null;
			}
			do
			{
				oilPtr = this.rhPtr.rhOiList[pQoi.qoiList[qoi + 1]];
				if (oilPtr.oilEventCount == this.rh2EventCount)
				{
					if ((oilPtr.oilListSelected & 0x80000000) == 0)
					{
						return this.rhPtr.rhObjectList[oilPtr.oilListSelected];
					}
				}
				qoi += 2;
			} while (qoi < pQoi.qoiList.length);

			qoi = 0;
			do
			{
				oilPtr = this.rhPtr.rhOiList[pQoi.qoiList[qoi + 1]];
				if ((oilPtr.oilObject & 0x80000000) == 0)
				{
					return this.rhPtr.rhObjectList[oilPtr.oilObject];
				}
				qoi += 2;
			} while (qoi < pQoi.qoiList.length);
			return null;
		},

		get_ParamActionObjects: function (qoil, pAction)
		{
			this.rh2EnablePick = true;
			var pObject = this.get_CurrentObjects(qoil);
			if (pObject != null)
			{
				if (this.repeatFlag == false)
				{
					return pObject;
				}
				else
				{
					pAction.evtFlags |= CAct.ACTFLAGS_REPEAT;
					this.rh2ActionLoop = true;
					return pObject;
				}
			}
			pAction.evtFlags |= CEvent.EVFLAGS_NOTDONEINSTART;
			return pObject;
		},

		get_ActionObjects: function (pAction)
		{
			pAction.evtFlags &= ~CEvent.EVFLAGS_NOTDONEINSTART;
			this.rh2EnablePick = true;
			var qoil = pAction.evtOiList;
			var pObject = this.get_CurrentObjects(qoil);
			if (pObject != null)
			{
				if (this.repeatFlag == false)
				{
					return pObject;
				}
				else
				{
					pAction.evtFlags |= CAct.ACTFLAGS_REPEAT;
					this.rh2ActionLoop = true;
					return pObject;
				}
			}
			pAction.evtFlags |= CEvent.EVFLAGS_NOTDONEINSTART;
			return pObject;
		},

		get_CurrentObjects: function (qoil)
		{
			var object;
			if ((qoil & 0x8000) == 0)
			{
				object = this.get_CurrentObject(qoil);
			}
			else
			{
				object = this.get_CurrentObjectQualifier(qoil);
			}
			return object;
		},

		get_CurrentObject: function (qoil)
		{
			var pHo;
			var oilPtr = this.rhPtr.rhOiList[qoil];

			if (oilPtr.oilActionCount != this.rh2ActionCount)
			{
				oilPtr.oilActionCount = this.rh2ActionCount;
				oilPtr.oilActionLoopCount = this.rh2ActionLoopCount;

				if (oilPtr.oilEventCount == this.rh2EventCount)
				{
					if ((oilPtr.oilListSelected & 0x80000000) == 0)
					{
						oilPtr.oilCurrentOi = oilPtr.oilListSelected;
						pHo = this.rhPtr.rhObjectList[oilPtr.oilListSelected];
						oilPtr.oilNext = pHo.hoNextSelected;
						if ((pHo.hoNextSelected & 0x80000000) != 0)
						{
							oilPtr.oilNextFlag = false;
							oilPtr.oilCurrentRoutine = 1;
							this.repeatFlag = false;
							return pHo;
						}
						oilPtr.oilNextFlag = true;
						oilPtr.oilCurrentRoutine = 2;
						this.repeatFlag = true;
						return pHo;
					}
				}

				if (this.rh2EnablePick)
				{
					if (oilPtr.oilEventCount == this.rh2EventCount)
					{
						oilPtr.oilCurrentRoutine = 0;
						oilPtr.oilCurrentOi = -1;
						return null;
					}
				}
				if ((oilPtr.oilObject & 0x80000000) == 0)
				{
					oilPtr.oilCurrentOi = oilPtr.oilObject;
					pHo = this.rhPtr.rhObjectList[oilPtr.oilObject];
					if (pHo == null)
					{
						oilPtr.oilCurrentRoutine = 0;
						oilPtr.oilCurrentOi = -1;
						return null;
					}
					if ((pHo.hoNumNext & 0x80000000) == 0)
					{
						oilPtr.oilNext = pHo.hoNumNext;
						oilPtr.oilNextFlag = true;
						oilPtr.oilCurrentRoutine = 3;
						this.repeatFlag = true;
						return pHo;
					}
					oilPtr.oilNextFlag = false;
					oilPtr.oilCurrentRoutine = 1;
					this.repeatFlag = false;
					return pHo;
				}
				else
				{
					oilPtr.oilCurrentRoutine = 0;
					oilPtr.oilCurrentOi = -1;
					return null;
				}
			}

			if (oilPtr.oilActionLoopCount != this.rh2ActionLoopCount)
			{
				var next;
				oilPtr.oilActionLoopCount = this.rh2ActionLoopCount;
				switch (oilPtr.oilCurrentRoutine)
				{
					case 0:
						this.repeatFlag = oilPtr.oilNextFlag;
						return null;
					case 1:
						pHo = this.rhPtr.rhObjectList[oilPtr.oilCurrentOi];
						this.repeatFlag = oilPtr.oilNextFlag;
						return pHo;
					case 2:
						oilPtr.oilCurrentOi = oilPtr.oilNext;
						pHo = this.rhPtr.rhObjectList[oilPtr.oilNext];
						if (pHo == null)
						{
							return null;
						}
						next = pHo.hoNextSelected;
						if ((next & 0x80000000) != 0)
						{
							oilPtr.oilNextFlag = false;
							next = oilPtr.oilListSelected;
						}
						oilPtr.oilNext = next;
						this.repeatFlag = oilPtr.oilNextFlag;
						return pHo;
					case 3:
						oilPtr.oilCurrentOi = oilPtr.oilNext;
						pHo = this.rhPtr.rhObjectList[oilPtr.oilNext];
						if (pHo == null)
						{
							return null;
						}
						next = pHo.hoNumNext;
						if ((next & 0x80000000) != 0)
						{
							oilPtr.oilNextFlag = false;
							next = oilPtr.oilObject;
						}
						oilPtr.oilNext = next;
						this.repeatFlag = oilPtr.oilNextFlag;
						return pHo;
				}
			}
			if (oilPtr.oilCurrentOi < 0)
			{
				return null;
			}
			pHo = this.rhPtr.rhObjectList[oilPtr.oilCurrentOi];
			this.repeatFlag = oilPtr.oilNextFlag;
			return pHo;
		},

		get_CurrentObjectQualifier: function (qoil)
		{
			var pHo;
			var next, num;

			var pqoi = this.qualToOiList[qoil & 0x7FFF];
			if (pqoi.qoiActionCount != this.rh2ActionCount)
			{
				pqoi.qoiActionCount = this.rh2ActionCount;
				pqoi.qoiActionLoopCount = this.rh2ActionLoopCount;

				num = this.qoi_GetFirstListSelected(pqoi);
				if (num >= 0)
				{
					pqoi.qoiCurrentOi = num;
					pHo = this.rhPtr.rhObjectList[num];
					if (pHo == null)
					{
						pqoi.qoiCurrentRoutine = 0;
						pqoi.qoiCurrentOi = -1;
						return null;
					}
					next = pHo.hoNextSelected;
					if ((next & 0x80000000) != 0)
					{
						next = this.qoi_GetNextListSelected(pqoi);
						if (next < 0)
						{
							pqoi.qoiCurrentRoutine = 1;
							pqoi.qoiNextFlag = false;
							this.repeatFlag = false;
							return pHo;
						}
					}
					pqoi.qoiNext = next;
					pqoi.qoiCurrentRoutine = 2;
					pqoi.qoiNextFlag = true;
					this.repeatFlag = true;
					return pHo;
				}

				if (this.rh2EnablePick)
				{
					if (pqoi.qoiSelectedFlag)
					{
						pqoi.qoiCurrentRoutine = 0;
						pqoi.qoiCurrentOi = -1;
						return null;
					}
				}
				num = this.qoi_GetFirstList(pqoi);
				if (num >= 0)
				{
					pqoi.qoiCurrentOi = num;
					pHo = this.rhPtr.rhObjectList[num];
					if (pHo != null)
					{
						num = pHo.hoNumNext;
						if ((num & 0x80000000) != 0)
						{
							num = this.qoi_GetNextList(pqoi);
							if ((num & 0x80000000) != 0)
							{
								pqoi.qoiCurrentRoutine = 1;
								pqoi.qoiNextFlag = false;
								this.repeatFlag = false;
								return pHo;
							}
						}
						pqoi.qoiNext = num;
						pqoi.qoiCurrentRoutine = 3;
						pqoi.qoiNextFlag = true;
						this.repeatFlag = true;
						return pHo;
					}
				}
				pqoi.qoiCurrentRoutine = 0;
				pqoi.qoiCurrentOi = -1;
				return null;
			}

			if (pqoi.qoiActionLoopCount != this.rh2ActionLoopCount)
			{
				pqoi.qoiActionLoopCount = this.rh2ActionLoopCount;
				switch (pqoi.qoiCurrentRoutine)
				{
					case 0:
						this.repeatFlag = pqoi.qoiNextFlag;
						return null;
					case 1:
						pHo = this.rhPtr.rhObjectList[pqoi.qoiCurrentOi];
						this.repeatFlag = pqoi.qoiNextFlag;
						return pHo;
					case 2:
						pqoi.qoiCurrentOi = pqoi.qoiNext;
						pHo = this.rhPtr.rhObjectList[pqoi.qoiNext];
						if (pHo != null)
						{
							next = pHo.hoNextSelected;
							if ((next & 0x80000000) != 0)
							{
								next = this.qoi_GetNextListSelected(pqoi);
								if (next < 0)
								{
									pqoi.qoiNextFlag = false;
									next = this.qoi_GetFirstListSelected(pqoi);
								}
							}
							pqoi.qoiNext = next;
						}
						this.repeatFlag = pqoi.qoiNextFlag;
						return pHo;
					case 3:
						pqoi.qoiCurrentOi = pqoi.qoiNext;
						pHo = this.rhPtr.rhObjectList[pqoi.qoiNext];
						if (pHo != null)
						{
							next = pHo.hoNumNext;
							if ((next & 0x80000000) != 0)
							{
								next = this.qoi_GetNextList(pqoi);
								if ((next & 0x80000000) != 0)
								{
									pqoi.qoiNextFlag = false;
									next = this.qoi_GetFirstList(pqoi);
								}
							}
							pqoi.qoiNext = next;
						}
						this.repeatFlag = pqoi.qoiNextFlag;
						return pHo;
				}
			}

			if (pqoi.qoiCurrentOi < 0)
			{
				return null;
			}
			pHo = this.rhPtr.rhObjectList[pqoi.qoiCurrentOi];
			this.repeatFlag = pqoi.qoiNextFlag;
			return pHo;
		},

		qoi_GetNextListSelected: function (pqoi)
		{
			var pos = pqoi.qoiActionPos;
			var qoil;
			var oilPtr;
			while (pos < pqoi.qoiList.length)
			{
				qoil = pqoi.qoiList[pos + 1];
				oilPtr = this.rhPtr.rhOiList[qoil];
				if (oilPtr.oilEventCount == this.rh2EventCount)
				{
					pqoi.qoiSelectedFlag = true;
					if ((oilPtr.oilListSelected & 0x80000000) == 0)
					{
						pqoi.qoiActionPos = (pos + 2);
						return oilPtr.oilListSelected;
					}
				}
				pos += 2;
			}
			return -1;
		},

		qoi_GetFirstListSelected: function (pqoi)
		{
			pqoi.qoiActionPos = 0;
			pqoi.qoiSelectedFlag = false;
			return this.qoi_GetNextListSelected(pqoi);
		},

		qoi_GetNextList: function (pqoi)
		{
			var pos = pqoi.qoiActionPos;
			var qoil;
			var oilPtr;
			while (pos < pqoi.qoiList.length)
			{
				qoil = pqoi.qoiList[pos + 1];
				oilPtr = this.rhPtr.rhOiList[qoil];
				if ((oilPtr.oilObject & 0x80000000) == 0)
				{
					pqoi.qoiActionPos = (pos + 2);
					return oilPtr.oilObject;
				}
				pos += 2;
			}
			return -1;
		},

		qoi_GetFirstList: function (pqoi)
		{
			pqoi.qoiActionPos = 0;
			return this.qoi_GetNextList(pqoi);
		},

		endForEach: function ()
		{
			this.callEndForEach = false;

			var saveForEach = this.rhPtr.rh4CurrentForEach;
			var saveForEach2 = this.rhPtr.rh4CurrentForEach2;
			while (true)
			{
				var pForEach2 = null;
				var pPrevious = null;
				var pForEach = this.rhPtr.rh4ForEachs;
				while (pForEach != null)
				{
					if (pForEach.index < 0)
					{
						pForEach2 = pForEach.next;
						if (pForEach2)
						{
							if (!CServices.compareStringsIgnoreCase(pForEach.name, pForEach2.name))
								pForEach2 = null;
						}
						break;
					}
					pPrevious = pForEach;
					pForEach = pForEach.next;
				}

				if (pForEach == null)
					break;

				pForEach.stop = false;
				for (pForEach.index = 0; pForEach.index < pForEach.number; pForEach.index++)
				{
					this.rhPtr.rh4CurrentForEach = pForEach;
					this.rhPtr.rh4CurrentForEach2 = pForEach2;
					if (pForEach2)
						pForEach2.index = pForEach.index;
					this.rh2ActionOn = 0;
					this.handle_Event(pForEach.objects[pForEach.index], (-41 << 16));    // CNDL_EXTONLOOP);
					if (pForEach.stop)
						break;
				}
				if (pForEach2)
				{
					for (pForEach2.index = 0; pForEach2.index < pForEach2.number; pForEach2.index++)
					{
						this.rhPtr.rh4CurrentForEach = pForEach2;
						this.rhPtr.rh4CurrentForEach2 = pForEach;
						if (pForEach)
							pForEach.index = pForEach2.index;
						this.rh2ActionOn = 0;
						this.handle_Event(pForEach2.objects[pForEach2.index], (-41 << 16));    // CNDL_EXTONLOOP);
						if (pForEach2.stop)
							break;
					}
				}
				if (pForEach2)
					pForEach.next = pForEach2.next;
				if (pPrevious == null)
					this.rhPtr.rh4ForEachs = pForEach.next;
				else
					pPrevious.next = pForEach.next;
			}
			this.rhPtr.rh4CurrentForEach = saveForEach;
			this.rhPtr.rh4CurrentForEach2 = saveForEach2;
		},

		addForEach: function (pName, pHo, oi)
		{
			var pForEach = this.rhPtr.rh4ForEachs;
			var pForEachPrevious = null;
			while (pForEach != null)
			{
				if (pForEach.oi == oi && CServices.compareStringsIgnoreCase(pName, pForEach.name))
				{
					pForEach.objects[pForEach.number++] = pHo;
					return;
				}
				pForEachPrevious = pForEach;
				pForEach = pForEach.next;
			}

			var pForEach = new ForEach();
			if (pForEachPrevious)
				pForEachPrevious.next = pForEach;
			else
				this.rhPtr.rh4ForEachs = pForEach;
			pForEach.next = null;
			pForEach.number = 1;
			pForEach.oi = oi;
			pForEach.objects[0] = pHo;
			pForEach.index = -1;
			pForEach.name = pName;
		},

		handle_GlobalEvents: function (code)
		{
			var type = code & 0xFFFF;
			if ((type & 0x8000) != 0)
			{
				type = 65536 - type;
			}
			var cond = -(code >> 16);
			var num = this.listPointers[this.rhEvents[type] + cond];
			if (num != 0)
			{
				this.computeEventList(num, null);
			}
		},

		handle_Event: function (pHo, code)
		{
			this.rhCurCode = code;

			var cond = -(code >> 16);
			var num = this.listPointers[pHo.hoEvents + cond];
			if (num != 0)
			{
				this.computeEventList(num, pHo);
				return true;
			}
			return false;
		},

		handle_TimerEvents: function ()
		{
			var bDelete = false;
			var pEvent = this.rhPtr.rh4TimerEvents;
			while (pEvent)
			{
				if (this.rhPtr.rhTimer >= pEvent.timer)
				{
					if (pEvent.type == TimerEvents.TIMEREVENTTYPE_ONESHOT)
					{
						this.rhPtr.rhEvtProg.rhCurParam0 = pEvent.name;
						var num = this.listPointers[this.rhEvents[-COI.OBJ_TIMER] + CCnd.NUM_ONEVENT];
						if (num != 0)
						{
							this.computeEventList(num, null);
						}
						pEvent.bDelete = true;
						bDelete = true;
					}
					else
					{
						if (pEvent.timerPosition == 0)
						{
							pEvent.timerPosition = this.rhPtr.rhTimer;
						}
						while (this.rhPtr.rhTimer >= pEvent.timerPosition)
						{
							this.rhPtr.rhEvtProg.rhCurParam0 = pEvent.name;
							this.rhPtr.rhEvtProg.rhCurParam1 = pEvent.index;
							var num = this.listPointers[this.rhEvents[-COI.OBJ_TIMER] + CCnd.NUM_ONEVENT];
							if (num != 0)
							{
								this.computeEventList(num, null);
							}
							pEvent.index++;
							pEvent.loops--;
							if (pEvent.loops == 0)
							{
								pEvent.bDelete = true;
								bDelete = true;
								break;
							}
							pEvent.timerPosition += pEvent.timerNext;
						}
					}
				}
				pEvent = pEvent.next;
			}
			if (bDelete)
			{
				pEvent = this.rhPtr.rh4TimerEvents;
				var pPrevious = null;
				var pNext;
				while (pEvent)
				{
					pNext = pEvent.next;
					if (pEvent.bDelete)
					{
						if (pPrevious == null)
							this.rhPtr.rh4TimerEvents = pNext;
						else
							pPrevious.next = pNext;
					}
					else
					{
						pPrevious = pEvent;
					}
					pEvent = pNext;
				}
			}
		},

		compute_TimerEvents: function ()
		{

			var num;

			if ((this.rhPtr.rhGameFlags & CRun.GAMEFLAGS_FIRSTLOOPFADEIN) != 0)
			{
				num = this.listPointers[this.rhEvents[-COI.OBJ_GAME] + 1];
				if (num != 0)
				{
					this.listPointers[this.rhEvents[-COI.OBJ_GAME] + 1] = -1;
					this.computeEventList(num, null);
					this.rh4CheckDoneInstart = true;
				}
				return;
			}

			num = this.listPointers[this.rhEvents[-COI.OBJ_TIMER] + 3];
			if (num != 0)
			{
				this.computeEventList(num, null);
			}

			num = this.listPointers[this.rhEvents[-COI.OBJ_GAME] + 1];
			var num2, count;
			var evgPtr, evgGroup;
			var evtPtr;
			if (num != 0)
			{
				if (this.rh4CheckDoneInstart)
				{
					evgGroup = null;
					num2 = num;
					do
					{
						evgPtr = this.eventPointersGroup[num2];
						if (evgPtr != evgGroup)
						{
							evgGroup = evgPtr;

							for (count = evgPtr.evgNCond; count < evgPtr.evgNCond + evgPtr.evgNAct; count++)
							{
								evtPtr = evgPtr.evgEvents[count];
								if ((evtPtr.evtFlags & CEvent.EVFLAGS_NOTDONEINSTART) == 0)		// Une action BAD?
								{
									evtPtr.evtFlags |= CEvent.EVFLAGS_DONEBEFOREFADEIN;
								}
							}
						}
						num2++;
					} while (this.eventPointersGroup[num2] != null);
				}
				this.computeEventList(num, null);
				this.listPointers[this.rhEvents[-COI.OBJ_GAME] + 1] = 0;
				if (this.rh4CheckDoneInstart)
				{
					evgGroup = null;
					num2 = num;
					do
					{
						evgPtr = this.eventPointersGroup[num2];
						if (evgPtr != evgGroup)
						{
							evgGroup = evgPtr;
							for (count = evgPtr.evgNCond; count < evgPtr.evgNCond + evgPtr.evgNAct; count++)
							{
								evtPtr = evgPtr.evgEvents[count];
								evtPtr.evtFlags &= ~CEvent.EVFLAGS_DONEBEFOREFADEIN;
							}
						}
						num2++;
					} while (this.eventPointersGroup[num2] != null);
					this.rh4CheckDoneInstart = false;
				}
			}

			num = this.listPointers[this.rhEvents[-COI.OBJ_TIMER] + 2];
			if (num != 0)
			{
				this.computeEventList(num, null);
			}

			num = this.listPointers[this.rhEvents[-COI.OBJ_TIMER] + 1];
			if (num != 0)
			{
				this.computeEventList(num, null);
			}
		},

		restartTimerEvents: function ()
		{
			var time = this.rhPtr.rhTimer;

			var num = this.listPointers[this.rhEvents[-COI.OBJ_TIMER] + 3];
			var evtPtr;
			var evgPtr;
			if (num != 0)
			{
				do
				{
					evgPtr = this.eventPointersGroup[num];
					evtPtr = evgPtr.evgEvents[this.eventPointersCnd[num]];
					evtPtr.evtFlags |= CEvent.EVFLAGS_DONE;
					var p = evtPtr.evtParams[0];
					if (p.timer > time)
					{
						evtPtr.evtFlags &= ~CEvent.EVFLAGS_DONE;
					}
					num++;
				} while (this.eventPointersGroup[num] != null);
			}
		},

		computeEventFastLoopList: function (pointers)
		{
			var evgPtr;
			var count;
			var num = 0;
			do
			{
				evgPtr = pointers[num];
				if ((evgPtr.evgFlags & CEventGroup.EVGFLAGS_INACTIVE) == 0)
				{
					this.rhEventGroup = evgPtr;
					this.rh4PickFlags[0] = 0;
					this.rh4PickFlags[1] = 0;
					this.rh4PickFlags[2] = 0;
					this.rh4PickFlags[3] = 0;
					this.rh2EventCount += 1;
					this.rh4ConditionsFalse = false;

					for (count = 1; count < evgPtr.evgNCond; count++)
					{
							if (evgPtr.evgEvents[count].eva2(this.rhPtr) == false)
							{
								break;
							}
					}

					if (count == evgPtr.evgNCond)
					{
						this.call_Actions(evgPtr);
					}
				}
				num++;
			} while (num < pointers.length)
		},

		computeEventList: function (num, pHo)
		{
			var bTrue;
			var evgPtr, evgPtr2;
			var count;
			this.rh3DoStop = false;
			do
			{
				evgPtr = this.eventPointersGroup[num];

				if ((evgPtr.evgFlags & CEventGroup.EVGFLAGS_INACTIVE) == 0)
				{
					this.rhEventGroup = evgPtr;
					this.rh4PickFlags[0] = 0;
					this.rh4PickFlags[1] = 0;
					this.rh4PickFlags[2] = 0;
					this.rh4PickFlags[3] = 0;

					if ((evgPtr.evgFlags & CEventGroup.EVGFLAGS_ORINGROUP) == 0)
					{
						this.rh2EventCount += 1;
						this.rh4ConditionsFalse = false;

						count = 0;
							if (evgPtr.evgEvents[count].eva1(this.rhPtr, pHo))
							{
								for (count++; count < evgPtr.evgNCond; count++)
								{
										if (evgPtr.evgEvents[count].eva2(this.rhPtr) == false)
										{
											break;
										}
								}
							}

						if (count == evgPtr.evgNCond)
						{
							if (this.rh3DoStop)
							{
								if (pHo != null)
								{
									this.call_Stops(pHo);
								}
							}
							else
							{
								this.call_Actions(evgPtr);
							}
						}
						num++;
					}
					else
					{
						this.rh4EventCountOR++;
						if ((evgPtr.evgFlags & CEventGroup.EVGFLAGS_ORLOGICAL) == 0)
						{
							bTrue = false;
							do
							{
								this.rh2EventCount++;
								this.rh4ConditionsFalse = false;
								count = this.eventPointersCnd[num];
									if (evgPtr.evgEvents[count].eva1(this.rhPtr, pHo) == false)
									{
										this.rh4ConditionsFalse = true;
									}

								count++;
								while (count < evgPtr.evgNCond && evgPtr.evgEvents[count].evtCode != ((-24 << 16) | 65535))
								{
										if (evgPtr.evgEvents[count].eva2(this.rhPtr) == false)
										{
											this.rh4ConditionsFalse = true;
										}
									count++;
								}

								this.evt_MarkSelectedObjects();
								if (this.rh4ConditionsFalse == false)
								{
									bTrue = true;
								}

								num++;
								evgPtr = this.eventPointersGroup[num];
								if (evgPtr == null)
								{
									break;
								}
							} while (evgPtr == this.rhEventGroup);

							if (bTrue)
							{
								this.rh2EventCount++;
								this.evt_BranchSelectedObjects();
								this.call_Actions(this.rhEventGroup);
							}
						}
						else
						{
							var bFalse;
							this.rh4ConditionsFalse = false;

							bTrue = false;
							do
							{
								this.rh2EventCount++;
								bFalse = false;
								count = this.eventPointersCnd[num];

									if (evgPtr.evgEvents[count].eva1(this.rhPtr, pHo))
									{
										count++;
										while (count < evgPtr.evgNCond && evgPtr.evgEvents[count].evtCode != ((-25 << 16) | 65535))
										{
												if (evgPtr.evgEvents[count].eva2(this.rhPtr) == false)
												{
													bFalse = true;
													break;
												}
											count++;
										}
									}
									else
									{
										bFalse = true;
									}
								if (bFalse == false)
								{
									this.evt_MarkSelectedObjects();
									bTrue = true;
								}

								num++;
								evgPtr = this.eventPointersGroup[num];
								if (evgPtr == null)
								{
									break;
								}

							} while (evgPtr == this.rhEventGroup);

							if (bTrue)
							{
								this.rh2EventCount++;
								this.evt_BranchSelectedObjects();
								this.call_Actions(this.rhEventGroup);
							}
						}
					}
				}
				else
				{
					num++;
					if (this.eventPointersGroup[num] != null)
					{
						evgPtr2 = this.eventPointersGroup[num];
						while (evgPtr2 == evgPtr)
						{
							num++;
							if (this.eventPointersGroup[num] == null)
							{
								break;
							}
							evgPtr2 = this.eventPointersGroup[num];
						}
					}
				}
			} while (this.eventPointersGroup[num] != null);
		},

		call_Actions: function (pEvg)
		{
			if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_LIMITED) != 0)
			{
				if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_SHUFFLE) != 0)
				{
					this.rh2ShuffleBuffer = new CArrayList();
				}

				if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_NOTALWAYS) != 0)
				{
					var w_cx = this.rhPtr.rhLoopCount;
					var w_dx = pEvg.evgInhibit;
					pEvg.evgInhibit = w_cx;
					if (w_cx == w_dx)
					{
						return;
					}
					w_cx -= 1;
					if (w_cx == w_dx)
					{
						return;
					}
				}

				if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_REPEAT) != 0)
				{
					if (pEvg.evgInhibitCpt != 0)
					{
						pEvg.evgInhibitCpt--;
					}
					else
					{
						return;
					}
				}

				if ((pEvg.evgFlags & CEventGroup.EVGFLAGS_NOMORE) != 0)
				{
					var dwt = this.rhPtr.rhTimer / 10;
					var dwmax = pEvg.evgInhibitCpt;
					if (dwmax != 0 && dwt < dwmax)
					{
						return;
					}
					pEvg.evgInhibitCpt = (dwt + pEvg.evgInhibit);
				}
			}


			this.rh2ActionCount++;
			this.rh2ActionLoop = false;
			this.rh2ActionLoopCount = 0;
			this.rh2ActionOn = true;
			var count = 0;
			var actPtr;
			do
			{
				actPtr = pEvg.evgEvents[count + pEvg.evgNCond];
				if ((actPtr.evtFlags & (CEvent.EVFLAGS_BADOBJECT | CEvent.EVFLAGS_DONEBEFOREFADEIN)) == 0)
				{
					actPtr.evtFlags &= ~CAct.ACTFLAGS_REPEAT;
					actPtr.execute(this.rhPtr);
				}
				count++;
			} while (count < pEvg.evgNAct);

			if (this.rh2ActionLoop)
			{
				do
				{
					this.rh2ActionLoop = false;
					this.rh2ActionLoopCount++;
					for (count = 0; count < pEvg.evgNAct; count++)
					{
						actPtr = pEvg.evgEvents[count + pEvg.evgNCond];
						if ((actPtr.evtFlags & CAct.ACTFLAGS_REPEAT) != 0)
						{
							actPtr.evtFlags &= ~CAct.ACTFLAGS_REPEAT;
							actPtr.execute(this.rhPtr);
						}
					}
				} while (this.rh2ActionLoop);
			}

			this.rh2ActionOn = false;
			if (this.rh2ShuffleBuffer != null)
				this.endShuffle();
			if (this.callEndForEach)
				this.endForEach();
		},

		call_Stops: function (pHo)
		{
			var oi;

			oi = pHo.hoOi;
			this.rh2EventCount += 1;
			this.evt_AddCurrentObject(pHo);

			this.rh2ActionCount++;
			this.rh2ActionLoop = false;
			this.rh2ActionLoopCount = 0;
			this.rh2ActionOn = true;
			var actPtr;
			var count = 0;
			var num, numOi;
			do
			{
				actPtr = this.rhEventGroup.evgEvents[this.rhEventGroup.evgNCond + count];
				num = actPtr.evtCode & 0xFFFF0000;
				if (num == (4 << 16) || num == (9 << 16))
				{
					if (oi == actPtr.evtOi)
					{
						actPtr.execute(this.rhPtr);
					}
					else
					{
						var oil = actPtr.evtOiList;
						if ((oil & 0x8000) != 0)
						{
							var pq = this.qualToOiList[oil & 0x7FFF];
							numOi = 0;
							while (numOi < pq.qoiList.length)
							{
								if (pq.qoiList[numOi] == oi)
								{
									actPtr.execute(this.rhPtr);
									break;
								}
								numOi += 2;
							}
						}
					}
				}
				count++;
			} while (count < this.rhEventGroup.evgNAct);
			this.rh2ActionOn = false;
		},

		endShuffle: function ()
		{
			if (this.rh2ShuffleBuffer.size() <= 1)
			{
				return;
			}

			var num1 = this.rhPtr.random(this.rh2ShuffleBuffer.size());
			var num2;
			do
			{
				num2 = this.rhPtr.random(this.rh2ShuffleBuffer.size());
			} while (num1 == num2);

			var pHo1 = this.rh2ShuffleBuffer.get(num1);
			var pHo2 = this.rh2ShuffleBuffer.get(num2);

			var x1 = pHo1.hoX;
			var y1 = pHo1.hoY;
			var x2 = pHo2.hoX;
			var y2 = pHo2.hoY;
			CRun.setXPosition(pHo1, x2);
			CRun.setYPosition(pHo1, y2);
			CRun.setXPosition(pHo2, x1);
			CRun.setYPosition(pHo2, y1);
			this.rh2ShuffleBuffer = null;
		},

		onMouseButton: function (b, nClicks)
		{
			var mouse;
			this.rhPtr.getMouseCoords();

			if (this.rhPtr == null)
			{
				return;
			}
			if (this.rhPtr.rh2PauseCompteur != 0)
			{
				return;
			}
			if (this.bReady == false)
			{
				return;
			}

			mouse = b;
			if (nClicks == 2)
			{
				mouse += CEventProgram.PARAMCLICK_DOUBLE;
			}

			this.rhPtr.rh4TimeOut = 0;
			if ((this.rhPtr.rhMouseUsed) != 0)
			{
				return;
			}

			this.rhCurParam0 = mouse;
			this.rh2CurrentClick = mouse;
			this.handle_GlobalEvents(((-5 << 16) | 0xFFFA));
			this.handle_GlobalEvents(((-6 << 16) | 0xFFFA));

			var count = 0;
			var i;
			var pHox;
			var x1, y1, x2, y2;
			var list = new CArrayList();
			for (i = 0; i < this.rhPtr.rhNObjects; i++)
			{
				while (this.rhPtr.rhObjectList[count] == null)
					count++;
				pHox = this.rhPtr.rhObjectList[count];
				count++;

				x1 = pHox.hoX - pHox.hoImgXSpot;
				y1 = pHox.hoY - pHox.hoImgYSpot;
				x2 = x1 + pHox.hoImgWidth;
				y2 = y1 + pHox.hoImgHeight;
				if (this.rhPtr.rh2MouseX >= x1 && this.rhPtr.rh2MouseX < x2 && this.rhPtr.rh2MouseY >= y1 && this.rhPtr.rh2MouseY < y2)
				{
				    if ((pHox.hoLimitFlags & CObjInfo.OILIMITFLAGS_QUICKCOL) != 0 && (pHox.hoFlags & CObject.HOF_DESTROYED) == 0)
					{
						if (pHox.hoType == COI.OBJ_SPR)
						{
							if ((pHox.ros.rsFlags & CRSpr.RSFLAG_COLBOX) == 0)
							{
								var image = this.application.imageBank.getImageFromHandle(pHox.roc.rcImage);
							    var mask = image.getMask(CMask.GCMF_OBSTACLE, 0, 1.0, 1.0);
							    if (mask.testPointEx(this.rhPtr.rh2MouseX - pHox.hoX, this.rhPtr.rh2MouseY - pHox.hoY, pHox.roc.rcAngle, pHox.roc.rcScaleX, pHox.roc.rcScaleY))
								{
									list.add(pHox);
								}
							}
							else
							{
								list.add(pHox);
							}
						}
						else
						{
							list.add(pHox);
						}
					}
				}
			}
			for (count = 0; count < list.size(); count++)
			{
				pHox = list.get(count);
				this.rhCurParam1 = pHox.hoOi;
				this.rh4_2ndObject = pHox;
				this.handle_GlobalEvents(((-7 << 16) | 0xFFFA));
			}
		},

		onKeyDown: function (vk)
		{
			if (this.rhPtr != null)
			{
				if (this.bReady == false)
				{
					return;
				}
				/*
				 if (this.rhPtr.rh2PauseCompteur != 0)
				 {
				 if (this.rhPtr.rh4PauseKey == -1)
				 {
				 this.rhPtr.resume();
				 this.rhPtr.rh4EndOfPause = this.rhPtr.rhLoopCount;	    
				 this.handle_GlobalEvents(((-8 << 16) | 0xFFFD));	
				 }
				 if (this.rhPtr.rh4PauseKey != 0 && this.rhPtr.rh4PauseKey == vk)
				 {
				 this.rhPtr.resume();
				 this.rhPtr.rh4EndOfPause = this.rhPtr.rhLoopCount;	    
				 this.handle_GlobalEvents(((-8 << 16) | 0xFFFD));	    
				 }
				 return;
				 }
				 */
				this.rhPtr.rh4TimeOut = 0;
				this.handle_GlobalEvents(((-9 << 16) | 0xFFFA));
			}
		},

		onMouseMove: function ()
		{
			if (this.bReady == false)
				return;
			if (this.rhPtr.rh2PauseCompteur != 0)
				return;
			this.rhPtr.rh4TimeOut = 0;
		},

		ctoCompare: function (pZone, pHo)
		{
			if (pHo.hoImgWidth == 0 || pHo.hoImgHeight == 0)
			{
				return false;
			}
			if (pHo.hoX < pZone.x1 || pHo.hoX >= pZone.x2)
			{
				return false;
			}
			if (pHo.hoY < pZone.y1 || pHo.hoY >= pZone.y2)
			{
				return false;
			}
			return true;
		},

		count_ZoneTypeObjects: function (pZone, stop, type)
		{
			stop++;
			this.evtNSelectedObjects = 0;

			var oil = 0;
			var poilLoop = null;
			var pHo;
			var num;
			do
			{
				for (; oil < this.rhPtr.rhOiList.length; oil++)
				{
					poilLoop = this.rhPtr.rhOiList[oil];
					if (type == 0 || (type != 0 && type == poilLoop.oilType))
					{
						break;
					}
				}
				if (oil == this.rhPtr.rhOiList.length)
				{
					return null;
				}

				var poil = poilLoop;
				oil++;

				if (poil.oilEventCount != this.rh2EventCount)
				{
					if (this.rh4ConditionsFalse == false)
					{
						num = poil.oilObject;
						while ((num & 0x80000000) == 0)
						{
							pHo = this.rhPtr.rhObjectList[num];
							if (pHo == null)
							{
								return null;
							}
							if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
							{
								if (this.ctoCompare(pZone, pHo))
								{
									this.evtNSelectedObjects++;
									if (this.evtNSelectedObjects == stop)
									{
										return pHo;
									}
								}
							}
							num = pHo.hoNumNext;
						}
					}
				}
				else
				{
					num = poil.oilListSelected;
					while ((num & 0x80000000) == 0)
					{
						pHo = this.rhPtr.rhObjectList[num];
						if (pHo == null)
						{
							return null;
						}
						if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
						{
							if (this.ctoCompare(pZone, pHo))
							{
								this.evtNSelectedObjects++;
								if (this.evtNSelectedObjects == stop)
								{
									return pHo;
								}
							}
						}
						num = pHo.hoNextSelected;
					}
				}
			} while (true);
		},

		count_ObjectsFromType: function (type, stop)
		{
			stop++;
			this.evtNSelectedObjects = 0;

			var oil = 0;
			var poilLoop = null;
			var pHo;
			var num;

			do
			{
				for (; oil < this.rhPtr.rhOiList.length; oil++)
				{
					poilLoop = this.rhPtr.rhOiList[oil];
					if (type == 0 || (type != 0 && type == poilLoop.oilType))
					{
						break;
					}
				}
				if (oil == this.rhPtr.rhOiList.length)
				{
					return null;
				}

				var poil = poilLoop;
				oil++;

				if (poil.oilEventCount != this.rh2EventCount)
				{
					if (this.rh4ConditionsFalse == false)
					{
						num = poil.oilObject;
						while ((num & 0x80000000) == 0)
						{
							pHo = this.rhPtr.rhObjectList[num];
							if (pHo == null)
							{
								return null;
							}
							if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
							{
								this.evtNSelectedObjects++;
								if (this.evtNSelectedObjects == stop)
								{
									return pHo;
								}
							}
							num = pHo.hoNumNext;
						}
					}
				}
				else
				{
					num = poil.oilListSelected;
					while ((num & 0x80000000) == 0)
					{
						pHo = this.rhPtr.rhObjectList[num];
						if (pHo == null)
						{
							return null;
						}
						if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
						{
							this.evtNSelectedObjects++;
							if (this.evtNSelectedObjects == stop)
							{
								return pHo;
							}
						}
						num = pHo.hoNextSelected;
					}
				}
			} while (true);
		},

		czaCompare: function (pZone, pHo)
		{
			if (pHo.hoX < pZone.x1 || pHo.hoX >= pZone.x2)
			{
				return false;
			}
			if (pHo.hoY < pZone.y1 || pHo.hoY >= pZone.y2)
			{
				return false;
			}
			return true;
		},

		select_ZoneTypeObjects: function (p, type)
		{
			var cpt = 0;

			var oil = 0;
			var poilLoop = null;
			var pHoLoop, pHoFound;
			var num;
			do
			{
				for (; oil < this.rhPtr.rhOiList.length; oil++)
				{
					poilLoop = this.rhPtr.rhOiList[oil];
					if (type == 0 || (type != 0 && type == poilLoop.oilType))
					{
						break;
					}
				}
				if (oil == this.rhPtr.rhOiList.length)
				{
					return cpt;
				}

				var poil = poilLoop;
				oil++;

				if (poil.oilEventCount != this.rh2EventCount)
				{
					pHoLoop = null;
					poil.oilNumOfSelected = 0;
					poil.oilEventCount = this.rh2EventCount;
					poil.oilListSelected = -1;
					if (this.rh4ConditionsFalse == false)
					{
						num = poil.oilObject;
						while ((num & 0x80000000) == 0)
						{
							pHoFound = this.rhPtr.rhObjectList[num];
							if (pHoFound == null)
							{
								break;
							}
							if ((pHoFound.hoFlags & CObject.HOF_DESTROYED) == 0)
							{
								if (this.czaCompare(p, pHoFound))
								{
									cpt++;
									poil.oilNumOfSelected++;
									pHoFound.hoNextSelected = -1;
									if (pHoLoop == null)
									{
										poil.oilListSelected = pHoFound.hoNumber;
									}
									else
									{
										pHoLoop.hoNextSelected = pHoFound.hoNumber;
									}
									pHoLoop = pHoFound;
								}
							}
							num = pHoFound.hoNumNext;
						}
						;
					}
					continue;
				}

				pHoLoop = null;
				num = poil.oilListSelected;
				while ((num & 0x80000000) == 0)
				{
					pHoFound = rhPtr.rhObjectList[num];
					if (pHoFound == null)
					{
						break;
					}
					if ((pHoFound.hoFlags & CObject.HOF_DESTROYED) == 0)
					{
						if (this.czaCompare(p, pHoFound) == false)
						{
							poil.oilNumOfSelected--;
							if (pHoLoop == null)
							{
								poil.oilListSelected = pHoFound.hoNextSelected;
							}
							else
							{
								pHoLoop.hoNextSelected = pHoFound.hoNextSelected;
							}
						}
						else
						{
							cpt++;
							pHoLoop = pHoFound;
						}
					}
					num = pHoFound.hoNextSelected;
				}
				;
				continue;
			} while (true);
		},

		losCompare: function (x1, y1, x2, y2, pHo)
		{
			var delta;
			var x, y;

			var xLeft = pHo.hoX - pHo.hoImgXSpot;
			var xRight = xLeft + pHo.hoImgWidth;
			var yTop = pHo.hoY - pHo.hoImgYSpot;
			var yBottom = yTop + pHo.hoImgHeight;

			if (x2 - x1 > y2 - y1)
			{
				delta = (y2 - y1) / (x2 - x1);
				if (x2 > x1)
				{
					if (xRight < x1 || xLeft >= x2)
					{
						return false;
					}
				}
				else
				{
					if (xRight < x2 || xLeft >= x1)
					{
						return false;
					}
				}
				y = delta * (xLeft - x1) + y1;
				if (y >= yTop && y < yBottom)
				{
					return true;
				}

				y = delta * (xRight - x1) + y1;
				if (y >= yTop && y < yBottom)
				{
					return true;
				}

				return false;
			}
			else
			{
				delta = (x2 - x1) / (y2 - y1);
				if (y2 > y1)
				{
					if (yBottom < y1 || yTop >= y2)
					{
						return false;
					}
				}
				else
				{
					if (yBottom < y2 || yTop >= y1)
					{
						return false;
					}
				}
				x = delta * (yTop - y1) + x1;
				if (x >= xLeft && x < xRight)
				{
					return true;
				}

				x = delta * (yTop - y1) + x1;
				if (x >= xLeft && x < xRight)
				{
					return true;
				}

				return false;
			}
		},

		select_LineOfSight: function (x1, y1, x2, y2)
		{
			var cpt = 0;

			var poil;
			var oil;
			var pHoLoop, pHoFound;
			var num;
			for (oil = 0; oil < this.rhPtr.rhOiList.length; oil++)
			{
				poil = this.rhPtr.rhOiList[oil];
				if (poil.oilEventCount != this.rh2EventCount)
				{
					pHoLoop = null;
					poil.oilNumOfSelected = 0;
					poil.oilEventCount = this.rh2EventCount;
					poil.oilListSelected = -1;

					if (this.rh4ConditionsFalse == false)
					{
						num = poil.oilObject;
						while ((num & 0x80000000) == 0)
						{
							pHoFound = this.rhPtr.rhObjectList[num];
							if (pHoFound == null)
							{
								break;
							}
							if ((pHoFound.hoFlags & CObject.HOF_DESTROYED) == 0)
							{
								if (this.losCompare(x1, y1, x2, y2, pHoFound))
								{
									cpt++;
									poil.oilNumOfSelected++;
									pHoFound.hoNextSelected = -1;
									if (pHoLoop == null)
									{
										poil.oilListSelected = pHoFound.hoNumber;
									}
									else
									{
										pHoLoop.hoNextSelected = pHoFound.hoNumber;
									}
									pHoLoop = pHoFound;
								}
							}
							num = pHoFound.hoNumNext;
						}
					}
					continue;
				}

				pHoLoop = null;
				num = poil.oilListSelected;
				while ((num & 0x80000000) == 0)
				{
					pHoFound = this.rhPtr.rhObjectList[num];
					if (pHoFound == null)
					{
						break;
					}
					if ((pHoFound.hoFlags & CObject.HOF_DESTROYED) == 0)
					{
						if (this.losCompare(x1, y1, x2, y2, pHoFound) == false)
						{
							poil.oilNumOfSelected--;
							if (pHoLoop == null)
							{
								poil.oilListSelected = pHoFound.hoNextSelected;
							}
							else
							{
								pHoLoop.hoNextSelected = pHoFound.hoNextSelected;
							}
						}
						else
						{
							cpt++;
							pHoLoop = pHoFound;
						}
					}
					num = pHoFound.hoNextSelected;
				}

			}
			return cpt;
		},

		czoCountThem: function (oil, pZone)
		{
			var count = 0;
			var poil = this.rhPtr.rhOiList[oil];
			var pHo;
			var num;

			if (poil.oilEventCount != this.rh2EventCount)
			{
				if (this.rh4ConditionsFalse == false)
				{
					num = poil.oilObject;
					while ((num & 0x80000000) == 0)
					{
						pHo = this.rhPtr.rhObjectList[num];
						if (pHo == null)
						{
							return 0;
						}
						if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
						{
							if (this.czaCompare(pZone, pHo))
							{
								count++;
							}
						}
						num = pHo.hoNumNext;
					}
				}
				return count;
			}

			num = poil.oilListSelected;
			while ((num & 0x80000000) == 0)
			{
				pHo = this.rhPtr.rhObjectList[num];
				if (pHo == null)
				{
					return 0;
				}
				if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
				{
					if (this.czaCompare(pZone, pHo))
					{
						count++;
					}
				}
				num = pHo.hoNextSelected;
			}
			return count;
		},

		count_ZoneOneObject: function (oil, pZone)
		{
			if ((oil & 0x8000) == 0)
			{
				return this.czoCountThem(oil, pZone);
			}

			if ((oil & 0x7FFF) == 0x7FFF)
			{
				return 0;
			}
			var pqoi = this.qualToOiList[oil & 0x7FFF];
			var qoi;
			var count = 0;
			for (qoi = 0; qoi < pqoi.qoiList.length; qoi += 2)
			{
				count += this.czoCountThem(pqoi.qoiList[qoi + 1], pZone);
			}
			return count;
		},

		countThem: function (oil, stop)
		{
			var poil = this.rhPtr.rhOiList[oil];
			var pHo;
			var num;

			if (poil.oilEventCount != this.rh2EventCount)
			{
				if (this.rh4ConditionsFalse)
				{
					this.evtNSelectedObjects = 0;
					return null;
				}

				num = poil.oilObject;
				while ((num & 0x80000000) == 0)
				{
					pHo = this.rhPtr.rhObjectList[num];
					if (pHo == null)
					{
						return null;
					}
					if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
					{
						this.evtNSelectedObjects++;
						if (this.evtNSelectedObjects == stop)
						{
							return pHo;
						}
					}
					num = pHo.hoNumNext;
				}
				return null;
			}

			num = poil.oilListSelected;
			while ((num & 0x80000000) == 0)
			{
				pHo = this.rhPtr.rhObjectList[num];
				if (pHo == null)
				{
					return null;
				}
				if ((pHo.hoFlags & CObject.HOF_DESTROYED) == 0)
				{
					this.evtNSelectedObjects++;
					if (this.evtNSelectedObjects == stop)
					{
						return pHo;
					}
				}
				num = pHo.hoNextSelected;
			}
			return null;
		},

		count_ObjectsFromOiList: function (oil, stop)
		{
			stop++;
			this.evtNSelectedObjects = 0;
			if ((oil & 0x8000) == 0)
			{
				return this.countThem(oil, stop);
			}

			if ((oil & 0x7FFF) == 0x7FFF)
			{
				return null;
			}
			var pqoi = this.qualToOiList[oil & 0x7FFF];
			var qoi;
			for (qoi = 0; qoi < pqoi.qoiList.length; qoi += 2)
			{
				var pHo = this.countThem(pqoi.qoiList[qoi + 1], stop);
				if (pHo != null)
				{
					return pHo;
				}
			}
			return null;
		},

		pickFromId: function (value)
		{
			var number = value & 0xFFFF;
			if (number >= this.rhPtr.rhMaxObjects)
			{
				return false;
			}
			var pHo = this.rhPtr.rhObjectList[number];
			if (pHo == null)
			{
				return false;
			}

			var code = value >>> 16;
			if (code != pHo.hoCreationId)
			{
				return false;
			}

			var poil = pHo.hoOiList;
			if (poil.oilEventCount == this.rh2EventCount)
			{
				var next = poil.oilListSelected;
				var pHoFound = null;
				while ((next & 0x80000000) == 0)
				{
					pHoFound = this.rhPtr.rhObjectList[next];
					if (pHo == pHoFound)
					{
						break;
					}
					next = pHoFound.hoNextSelected;
				}
				;
				if (pHo != pHoFound)
				{
					return false;
				}
			}
			poil.oilEventCount = this.rh2EventCount;
			poil.oilListSelected = -1;
			poil.oilNumOfSelected = 0;
			pHo.hoNextSelected = -1;
			this.evt_AddCurrentObject(pHo);
			return true;
		},

		push_Event: function (routine, code, lParam, pHo, oi)
		{
			var p = new CPushedEvent(routine, code, lParam, pHo, oi);
			if (this.rh2PushedEvents == null)
			{
				this.rh2PushedEvents = new CArrayList();
			}
			this.rh2PushedEvents.add(p);
		},

		handle_PushedEvents: function ()
		{
			if (this.rh2PushedEvents != null)
			{
				var index;
				for (index = 0; index < this.rh2PushedEvents.size(); index++)
				{
					var pEvt = this.rh2PushedEvents.get(index);
					if (pEvt != null)
					{
						if (pEvt.code != 0)
						{
							this.rhCurParam0 = pEvt.param;
							this.rhCurOi = pEvt.oi;
							switch (pEvt.routine)
							{
								case 0:
									this.handle_GlobalEvents(pEvt.code);
									break;
								case 1:
									this.handle_Event(pEvt.pHo, pEvt.code);
									break;
							}
						}
					}
				}
				this.rh2PushedEvents.clear();
			}
		},

		load: function (app)
		{

			var code = new Array(4);
			var number;
			var n;
			var eventPos = 0;
			while (true)
			{
				var code = app.file.readBuffer(4);

				if (code[0] == 0x45 && code[1] == 0x52 && code[2] == 0x3E && code[3] == 0x3E)
				{
					this.maxObjects = app.file.readAShort();
					if (this.maxObjects < 300)
					{
						this.maxObjects = 300;
					}
					this.maxOi = app.file.readAShort();
					this.nPlayers = app.file.readAShort();
					for (n = 0; n < 7 + COI.OBJ_LAST; n++)
					{
						this.nConditions[n] = app.file.readAShort();
					}
					this.nQualifiers = app.file.readAShort();
					if (this.nQualifiers > 0)
					{
						this.qualifiers = new Array(this.nQualifiers);
						for (n = 0; n < this.nQualifiers; n++)
						{
							this.qualifiers[n] = new CLoadQualifiers();
							this.qualifiers[n].qOi = app.file.readShort();
							this.qualifiers[n].qType = app.file.readShort();
						}
					}
				}
				else if (code[0] == 0x45 && code[1] == 0x52 && code[2] == 0x65 && code[3] == 0x73)
				{
					app.file.readAInt();
					this.nEvents = app.file.readAInt();
					this.events = new Array(this.nEvents);
					this.eventPos = 0;
				}
				else if (code[0] == 0x45 && code[1] == 0x52 && code[2] == 0x65 && code[3] == 0x76)
				{
					app.file.readAInt();
					number = app.file.readAInt();
					for (n = 0; n < number; n++)
					{
						this.events[eventPos] = CEventGroup.create(app);
						eventPos++;
					}
				}
				else if (code[0] == 0x3C && code[1] == 0x3C && code[2] == 0x45 && code[3] == 0x52)
				{
					break;
				}
			}
			this.maxEvents = Math.max(this.maxEvents, eventPos);
		},

		inactiveGroup: function (evg)
		{
			var bQuit;
			var evgPtr;
			var evtPtr;
			var grpPtr;

			evgPtr = this.events[evg];
			evgPtr.evgFlags &= CEventGroup.EVGFLAGS_DEFAULTMASK;
			evgPtr.evgFlags |= CEventGroup.EVGFLAGS_INACTIVE;

			for (evg++  , bQuit = false; ;)
			{
				evgPtr = this.events[evg];
				evgPtr.evgFlags &= CEventGroup.EVGFLAGS_DEFAULTMASK;
				evgPtr.evgFlags |= CEventGroup.EVGFLAGS_INACTIVE;

				evtPtr = evgPtr.evgEvents[0];
				switch (evtPtr.evtCode)
				{
					case ((-10 << 16) | 65535):		// CNDL_GROUP:
						grpPtr = evtPtr.evtParams[0];
						grpPtr.grpFlags |= PARAM_GROUP.GRPFLAGS_PARENTINACTIVE;
						evg = this.inactiveGroup(evg);
						continue;
					case ((-11 << 16) | 65535):		// CNDL_ENDGROUP:
						bQuit = true;
						evg++;
						break;
				}
				if (bQuit)
				{
					break;
				}
				evg++;
			}
			return evg;
		},

		prepareProgram: function ()
		{
			var evgPtr;
			var evtPtr;
			var grpPtr;
			var evpPtr;
			var evg, evt, evp;
			var groups = new CArrayList();
			var g;

			for (evg = 0; evg < this.events.length;)
			{
				evgPtr = this.events[evg];
				evgPtr.evgFlags &= CEventGroup.EVGFLAGS_DEFAULTMASK;

				evtPtr = evgPtr.evgEvents[0];
				if (evtPtr.evtCode == ((-10 << 16) | 65535))
				{
					grpPtr = evtPtr.evtParams[0];
					g = new CGroupFind();
					g.id = grpPtr.grpId;
					g.evg = evg;
					groups.add(g);
					grpPtr.grpFlags &= ~(PARAM_GROUP.GRPFLAGS_PARENTINACTIVE | PARAM_GROUP.GRPFLAGS_GROUPINACTIVE);

					if ((grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_INACTIVE) != 0)
					{
						grpPtr.grpFlags |= PARAM_GROUP.GRPFLAGS_GROUPINACTIVE;
					}
				}
				evg++;
			}

			for (evg = 0; evg < this.events.length;)
			{
				evgPtr = this.events[evg];
				evgPtr.evgFlags &= CEventGroup.EVGFLAGS_DEFAULTMASK;

				evtPtr = evgPtr.evgEvents[0];
				if (evtPtr.evtCode == ((-10 << 16) | 65535))
				{
					grpPtr = evtPtr.evtParams[0];
					grpPtr.grpFlags &= ~PARAM_GROUP.GRPFLAGS_PARENTINACTIVE;

					if ((grpPtr.grpFlags & PARAM_GROUP.GRPFLAGS_GROUPINACTIVE) != 0)
					{
						evg = this.inactiveGroup(evg);
						continue;
					}
				}
				evg++;
			}

			for (evg = 0; evg < this.events.length; evg++)
			{
				evgPtr = this.events[evg];
				evtPtr = evgPtr.evgEvents[0];
				switch (evtPtr.evtCode)
				{
					case ((-10 << 16) | 65535):	    // CNDL_GROUP
					case ((-11 << 16) | 65535):	    // CNDL_ENDGROUP
						break;

					default:
						evgPtr.evgInhibit = 0;
						evgPtr.evgInhibitCpt = 0;
						for (evt = 0; evt < evgPtr.evgNCond + evgPtr.evgNAct; evt++)
						{
							evtPtr = evgPtr.evgEvents[evt];
							if (evtPtr.evtCode < 0)
							{
								evtPtr.evtFlags &= CEvent.EVFLAGS_DEFAULTMASK;
							}
							else
							{
								evtPtr.evtFlags &= ~(CAct.ACTFLAGS_REPEAT | CEvent.EVFLAGS_NOTDONEINSTART);
							}

							if (evtPtr.evtNParams != 0)
							{
								for (evp = 0; evp < evtPtr.evtNParams; evp++)
								{
									evpPtr = evtPtr.evtParams[evp];
									switch (evpPtr.code)
									{
										case 25:	    // PARAM_INT
											evpPtr.value2 = 0;
											break;
										case 13:	    // PARAM_EVERY
											evpPtr.compteur = evpPtr.delay;
											break;
										case 39:	    // PARAM_GROUPOINTER
											var n;
											for (n = 0; n < groups.size(); n++)
											{
												g = groups.get(n);
												if (g.id == evpPtr.id)
												{
													evpPtr.pointer = g.evg;
													break;
												}
											}
											break;
									}
								}
							}
						}
						break;
				}
			}
		},

		assemblePrograms: function (run)
		{
			var evgPtr;
			var evtPtr;
			var evpPtr;

			var o, oo;
			var oi, oi1, oi2;
			var type;
			var nOi, i, n, num, type1, type2;
			var d, evgF, evgM, q, d1, d2;
			var code;
			var fWrap;
			var evtAlways, evtAlwaysPos;
			var aTimers, ss;
			var bOrBefore;
			var cndOR;
			var oilPtr;
			var hoPtr;

			this.rhPtr = run;

			this.rh2ActionCount = 0;

			var oiMax = 0;
			for (nOi = 0  , n = 0; n < this.rhPtr.rhMaxOI; n++)
			{
				if (this.rhPtr.rhOiList[n].oilOi != -1)
				{
					this.rhPtr.rhOiList[n].oilActionCount = -1;
					this.rhPtr.rhOiList[n].oilLimitFlags = 0;
					this.rhPtr.rhOiList[n].oilLimitList = -1;
					nOi++;
					if (this.rhPtr.rhOiList[n].oilOi + 1 > oiMax)
					{
						oiMax = this.rhPtr.rhOiList[n].oilOi + 1;
					}
				}
			}

			this.qualToOiList = null;
			var oil;
			if (this.nQualifiers > 0)
			{
				var count = new Array(this.nQualifiers);
				for (q = 0; q < this.nQualifiers; q++)
				{
					oi = (this.qualifiers[q].qOi) & 0x7FFF;
					count[q] = 0;
					for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
					{
						if (this.rhPtr.rhOiList[oil].oilType == this.qualifiers[q].qType)
						{
							for (n = 0; n < 8 && this.rhPtr.rhOiList[oil].oilQualifiers[n] != -1; n++)
							{
								if (oi == this.rhPtr.rhOiList[oil].oilQualifiers[n])
								{
									count[q]++;
								}
							}
						}
					}
				}

				this.qualToOiList = new Array(this.nQualifiers);
				for (q = 0; q < this.nQualifiers; q++)
				{
					this.qualToOiList[q] = new CQualToOiList();

					if (count[q] != 0)
					{
						this.qualToOiList[q].qoiList = new Array(count[q] * 2);
					}

					i = 0;
					oi = (this.qualifiers[q].qOi) & 0x7FFF;
					for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
					{
						if (this.rhPtr.rhOiList[oil].oilType == this.qualifiers[q].qType)
						{
							for (n = 0; n < 8 && this.rhPtr.rhOiList[oil].oilQualifiers[n] != -1; n++)
							{
								if (oi == this.rhPtr.rhOiList[oil].oilQualifiers[n])
								{
									this.qualToOiList[q].qoiList[i * 2] = this.rhPtr.rhOiList[oil].oilOi;
									this.qualToOiList[q].qoiList[i * 2 + 1] = oil;
									i++;
								}
							}
						}
					}
					this.qualToOiList[q].qoiActionCount = -1;
				}
			}

			this.colBuffer = new Array(oiMax * 100 * 2 + 1);
			var colList = 0;
			var posStartLoop = new Array();
			var evg, evt, evp;
			for (evg = 0; evg < this.events.length; evg++)
			{
				evgPtr = this.events[evg];

				for (evt = 0; evt < evgPtr.evgNAct + evgPtr.evgNCond; evt++)
				{
					evtPtr = evgPtr.evgEvents[evt];

					evtPtr.evtFlags &= ~CEvent.EVFLAGS_BADOBJECT;

					if (CEventProgram.EVTTYPE(evtPtr.evtCode) >= 0)
					{
						evtPtr.evtOiList = this.get_OiListOffset(evtPtr.evtOi, CEventProgram.EVTTYPE(evtPtr.evtCode));
					}

					if (evtPtr.evtCode == CAct.ACT_STARTLOOP)
					{
						var expression = evtPtr.evtParams[0];
						if (expression.tokens[0].code == CExp.EXP_STRING && expression.tokens[1].code == 0)
						{
							var posStart = {};
							posStart.address = evtPtr.evtParams[0];
							posStart.name = expression.tokens[0].string;
							posStartLoop.push(posStart);

							this.rhPtr.addFastLoop(expression.tokens[0].string);
						}
					}
					else if (evtPtr.evtCode == CAct.ACT_STOPLOOP || evtPtr.evtCode == CAct.ACT_SETLOOPINDEX )
					{
						var expression = evtPtr.evtParams[0];
						if (expression.tokens[0].code == CExp.EXP_STRING && expression.tokens[1].code == 0)
						{
							expression.tokens[0] = new EXP_LONG();
							expression.tokens[0].code = CExp.EXP_LONG;
							expression.tokens[0].value = this.rhPtr.addFastLoop(expression.tokens[0].string);
						}
					}

					if (evtPtr.evtNParams > 0)
					{
						for (evp = 0; evp < evtPtr.evtNParams; evp++)
						{
							evpPtr = evtPtr.evtParams[evp];
							switch (evpPtr.code)
							{
								// Met un parametre buffer 4 a zero
								case 25:        // PARAM_BUFFER4:
									evpPtr.value = 0;
									break;

								// Trouve le levobj de creation
								case 21:        // PARAM_SYSCREATE:
									if ((evtPtr.evtOi & COI.OIFLAG_QUALIFIER) == 0)
									{
										var loPtr;
										for (loPtr = this.rhPtr.rhFrame.LOList.first_LevObj(); loPtr != null; loPtr = this.rhPtr.rhFrame.LOList.next_LevObj())
										{
											if (evtPtr.evtOi == loPtr.loOiHandle)
											{
												evpPtr.cdpHFII = loPtr.loHandle;
												break;
											}
										}
									}
									else
									{
										evpPtr.cdpHFII = -1;
									}
									oi = evpPtr.posOINUMParent;
									if (oi != -1)
									{
										evpPtr.posOiList = this.get_OiListOffset(oi, evpPtr.posTypeParent);
									}
									break;

								// Met l'adresse du levObj pour create object
								case 9:         // PARAM_CREATE:
								case 18:        // PARAM_SHOOT:
								case 16:        // PARAM_POSITION:
									oi = evpPtr.posOINUMParent;
									if (oi != -1)
									{
										evpPtr.posOiList = this.get_OiListOffset(oi, evpPtr.posTypeParent);
									}
									break;

								// Poke l'adresse de l'objet dans l'curFrame.m_oiList
								case 1:         // PARAM_OBJECT:
									evpPtr.oiList = this.get_OiListOffset(evpPtr.oi, evpPtr.type);
									break;

								// Expression : poke l'adresse de l'curFrame.m_oiList dans les parametres objets
								case 15:        // PARAM_SPEED:
								case 27:        // PARAM_SAMLOOP:
								case 28:        // PARAM_MUSLOOP:
								case 45:        // PARAM_EXPSTRING:
								case 46:        // PARAM_CMPSTRING:
								case 22:        // PARAM_EXPRESSION:
								case 23:        // PARAM_COMPARAISON:
								case 52:        // PARAM_VARGLOBAL_EXP:
								case 59:        // PARAM_STRINGGLOBAL_EXP:
								case 53:        // PARAM_ALTVALUE_EXP:
								case 54:        // PARAM_FLAG_EXP:
									var expPtr = evpPtr;
									for (n = 0; n < expPtr.tokens.length; n++)
									{
										// Un objet avec OI?
										if (CEventProgram.EVTTYPE(expPtr.tokens[n].code) > 0)
										{
											var expOi = expPtr.tokens[n];
											expOi.oiList = this.get_OiListOffset(expOi.oi, CEventProgram.EVTTYPE(expOi.code));
										}
									}
									;
									break;
							}
						}
					}
				}

				// Flags par defaut / Listes de limitation
				// ---------------------------------------
				evgF = 0;
				evgM = CEventGroup.EVGFLAGS_ONCE | CEventGroup.EVGFLAGS_LIMITED | CEventGroup.EVGFLAGS_STOPINGROUP;
				for (evt = 0; evt < evgPtr.evgNCond + evgPtr.evgNAct; evt++)
				{
					evtPtr = evgPtr.evgEvents[evt];

					type = CEventProgram.EVTTYPE(evtPtr.evtCode);
					code = evtPtr.evtCode;
					n = 0;
					d1 = 0;
					d2 = 0;
					evpPtr = null;
					if (type >= COI.OBJ_SPR)
					{
						switch (CEventProgram.getEventCode(code))
						{
							case (4 << 16):      // ACTL_EXTSTOP:
							case (9 << 16):      // ACTL_EXTBOUNCE:

								evgF |= CEventGroup.EVGFLAGS_STOPINGROUP;

								// Recherche dans le groupe, la cause du STOP. limitList
								// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
								oi = evtPtr.evtOi;
								if ((oi & COI.OIFLAG_QUALIFIER) != 0)
								{
									for (o = this.qual_GetFirstOiList2(evtPtr.evtOiList); o != -1; o = this.qual_GetNextOiList2())
									{
										colList = this.make_ColList1(evgPtr, colList, this.rhPtr.rhOiList[o].oilOi);
									}
								}
								else
								{
									colList = this.make_ColList1(evgPtr, colList, oi);
								}
								break;
							case (25 << 16):      // ACTL_EXTSHUFFLE:
								evgF |= CEventGroup.EVGFLAGS_SHUFFLE;
								break;
							case (-14 << 16):     // CNDL_EXTCOLLISION:
								evpPtr = evtPtr.evtParams[0];
								var pEvpObject = evtPtr.evtParams[0];
								this.addColList(evtPtr.evtOiList, evtPtr.evtOi, pEvpObject.oiList, pEvpObject.oi);
								this.addColList(pEvpObject.oiList, pEvpObject.oi, evtPtr.evtOiList, evtPtr.evtOi);
								// L'objet 1 est-il un sprite?
								type1 = CEventProgram.EVTTYPE(evtPtr.evtCode);
								if (this.isTypeRealSprite(type1))
								{
									d2 = CObjInfo.OILIMITFLAGS_QUICKCOL | CObjInfo.OILIMITFLAGS_ONCOLLIDE;
								}
								else
								{
									d2 = CObjInfo.OILIMITFLAGS_QUICKCOL | CObjInfo.OILIMITFLAGS_QUICKEXT | CObjInfo.OILIMITFLAGS_ONCOLLIDE;
								}

								// L'objet 2 est-il un sprite?
								type2 = pEvpObject.type;
								if (this.isTypeRealSprite(type2))
								{
									d1 = CObjInfo.OILIMITFLAGS_QUICKCOL | CObjInfo.OILIMITFLAGS_ONCOLLIDE;
								}
								else
								{
									d1 = CObjInfo.OILIMITFLAGS_QUICKCOL | CObjInfo.OILIMITFLAGS_QUICKEXT | CObjInfo.OILIMITFLAGS_ONCOLLIDE;
								}
								n = 3;
								break;
							case (-4 << 16):     // CNDL_EXTISCOLLIDING:
								// L'objet 1 est-il un sprite?
								type1 = CEventProgram.EVTTYPE(evtPtr.evtCode);
								if (this.isTypeRealSprite(type1))
								{
									d2 = CObjInfo.OILIMITFLAGS_QUICKCOL;
								}
								else
								{
									d2 = CObjInfo.OILIMITFLAGS_QUICKCOL | CObjInfo.OILIMITFLAGS_QUICKEXT;
								}

								// L'objet 2 est-il un sprite?
								evpPtr = evtPtr.evtParams[0];
								type2 = evtPtr.evtParams[0].type;
								if (this.isTypeRealSprite(type2))
								{
									d1 = CObjInfo.OILIMITFLAGS_QUICKCOL;
								}
								else
								{
									d1 = CObjInfo.OILIMITFLAGS_QUICKCOL | CObjInfo.OILIMITFLAGS_QUICKEXT;
								}
								n = 3;
								break;
							case (-11 << 16):     // CNDL_EXTINPLAYFIELD:
							case (-12 << 16):     // CNDL_EXTOUTPLAYFIELD:
								d1 = CObjInfo.OILIMITFLAGS_QUICKBORDER;
								n = 1;
								break;
							case (-13 << 16):     // CNDL_EXTCOLBACK:
								d1 = CObjInfo.OILIMITFLAGS_QUICKBACK;
								n = 1;
								break;
						}
					}
					else
					{
						switch (code)
						{
							case ((-6 << 16) | 65535):      // CNDL_ONCE
								evgM &= ~CEventGroup.EVGFLAGS_ONCE;
								break;
							case ((-7 << 16) | 65535):      // CNDL_NOTALWAYS:
								evgM |= CEventGroup.EVGFLAGS_NOMORE;
								break;
							case ((-5 << 16) | 65535):      // CNDL_REPEAT:
								evgM |= CEventGroup.EVGFLAGS_NOMORE;
								break;
							case ((-4 << 16) | 65535):      // CNDL_NOMORE:
								evgM |= CEventGroup.EVGFLAGS_NOTALWAYS + CEventGroup.EVGFLAGS_REPEAT;
								break;
							case ((-4 << 16) | 0xFFFA):     // CNDL_MONOBJECT:
								d2 = CObjInfo.OILIMITFLAGS_QUICKCOL;
								evpPtr = evtPtr.evtParams[0];
								n = 2;
								break;
							case ((-7 << 16) | 0xFFFA):     // CNDL_MCLICKONOBJECT:
								d2 = CObjInfo.OILIMITFLAGS_QUICKCOL;
								evpPtr = evtPtr.evtParams[1];
								n = 2;
								break;
						}
					}
					// Poke les flags collision
					if ((n & 1) != 0)
					{
						for (o = this.qual_GetFirstOiList(evtPtr.evtOiList); o != -1; o = this.qual_GetNextOiList())
						{
							this.rhPtr.rhOiList[o].oilLimitFlags |= d1;
						}
					}
					if ((n & 2) != 0)
					{
						for (o = this.qual_GetFirstOiList(evpPtr.oiList); o != -1; o = this.qual_GetNextOiList())
						{
							this.rhPtr.rhOiList[o].oilLimitFlags |= d2;
						}
					}
				}
				// Inhibe les anciens flags
				evgPtr.evgFlags &= ~evgM;
				evgPtr.evgFlags |= evgF;
			}
			this.colBuffer[colList] = -1;

			// Reserve le buffer des pointeurs sur listes d'events
			// ---------------------------------------------------
			var aListPointers = new Array(COI.NUMBEROF_SYSTEMTYPES + oiMax + 1);

			// Rempli cette table avec les offsets en fonction des types
			ss = 0;
			var alp;
			for (alp = 0  , type = -COI.NUMBEROF_SYSTEMTYPES; type < 0; type++, alp++)
			{
				aListPointers[alp] = ss;
				ss += this.nConditions[COI.NUMBEROF_SYSTEMTYPES + type];
			}
			// Continue avec les OI, la taille juste pour le type de l'oi
			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++, alp++)
			{
				aListPointers[alp] = ss;
				if (this.rhPtr.rhOiList[oil].oilType < COI.KPX_BASE)
				{
					ss += this.nConditions[COI.NUMBEROF_SYSTEMTYPES + this.rhPtr.rhOiList[oil].oilType] + CEventProgram.EVENTS_EXTBASE + 1;
				}
				else
				{
					ss += this.application.extLoader.getNumberOfConditions(this.rhPtr.rhOiList[oil].oilType) + CEventProgram.EVENTS_EXTBASE + 1;
				}
			}

			// Reserve le buffer des pointeurs
			var sListPointers = ss;
			this.listPointers = new Array(sListPointers);
			for (n = 0; n < sListPointers; n++)
			{
				this.listPointers[n] = 0;
			}
			evtAlways = 0;

			// Explore le programme et repere les evenements
			var wBufNear = new Array(this.rhPtr.rhFrame.maxObjects);
			var wPtrNear;
			for (evg = 0; evg < this.nEvents; evg++)
			{
				evgPtr = this.events[evg];
				evgPtr.evgFlags &= ~CEventGroup.EVGFLAGS_ORINGROUP;
				bOrBefore = true;
				cndOR = 0;
				for (evt = 0; evt < evgPtr.evgNCond; evt++)
				{
					evtPtr = evgPtr.evgEvents[evt];
					type = CEventProgram.EVTTYPE(evtPtr.evtCode);
					code = evtPtr.evtCode;
					num = -CEventProgram.EVTNUM(code);

					if (bOrBefore)
					{
						// Dans la liste des evenements ALWAYS
						if ((evtPtr.evtFlags & CEvent.EVFLAGS_ALWAYS) != 0)
						{
							evtAlways++;
						}

						// Dans la liste des evenements generaux si objet systeme
						if (type < 0)
						{
							this.listPointers[aListPointers[7 + type] + num]++;
						}
						else
						// Un objet normal / qualifier : relie aux objets
						{
							wPtrNear = 0;
							for (o = this.qual_GetFirstOiList(evtPtr.evtOiList); o != -1; o = this.qual_GetNextOiList())
							{
								this.listPointers[aListPointers[COI.NUMBEROF_SYSTEMTYPES + o] + num]++;
								wBufNear[wPtrNear++] = o;
							}
							wBufNear[wPtrNear] = -1;
							// Cas special pour les collisions de sprites : branche aux deux sprites (sauf si meme!)
							if (CEventProgram.getEventCode(code) == (-14 << 16))      // CNDL_EXTCOLLISION
							{
								evpPtr = evtPtr.evtParams[0];
								for (oo = this.qual_GetFirstOiList(evpPtr.oiList); oo != -1; oo = this.qual_GetNextOiList())
								{
									for (wPtrNear = 0; wBufNear[wPtrNear] != oo && wBufNear[wPtrNear] != -1;)
										wPtrNear++;
									if (wBufNear[wPtrNear] == -1)
									{
										this.listPointers[aListPointers[COI.NUMBEROF_SYSTEMTYPES + oo] + num]++;
									}
								}
							}
						}
					}
					bOrBefore = false;
					if (evtPtr.evtCode == ((-24 << 16) | 65535) || evtPtr.evtCode == ((-25 << 16) | 65535))     // CNDL_OR - CNDL_ORLOGICAL
					{
						bOrBefore = true;
						evgPtr.evgFlags |= CEventGroup.EVGFLAGS_ORINGROUP;
						// Un seul type de OR dans un groupe
						if (cndOR == 0)
						{
							cndOR = evtPtr.evtCode;
						}
						else
						{
							evtPtr.evtCode = cndOR;
						}
						// Marque les OR Logical
						if (cndOR == ((-25 << 16) | 65535))       // CNDL_ORLOGICAL)
						{
							evgPtr.evgFlags |= CEventGroup.EVGFLAGS_ORLOGICAL;
						}
					}
				}
			}

			// Calcule les tailles necessaires, poke les pointeurs dans les listes
			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			var sEventPointers = evtAlways + 1;
			var uil;
			for (uil = 0; uil < sListPointers; uil++)
			{
				if (this.listPointers[uil] != 0)
				{
					ss = this.listPointers[uil];
					this.listPointers[uil] = sEventPointers;
					sEventPointers += ss + 1;
				}
			}
			this.eventPointersGroup = new Array(sEventPointers);
			this.eventPointersCnd = new Array(sEventPointers);
			for (n = 0; n < sEventPointers; n++)
			{
				this.eventPointersGroup[n] = null;
				this.eventPointersCnd[n] = 0;
			}

			var lposBuffer = new Array(sListPointers);
			for (n = 0; n < sListPointers; n++)
			{
				lposBuffer[n] = this.listPointers[n];
			}

		    // 288.2 - fast loops were doubled if there was a frame fade-in transition
			this.rhPtr.rh4PosOnLoop = null;

			evtAlwaysPos = 0;
			evtAlways = 0;
			var lposPtr;
			this.complexOnLoop = false;
			for (evg = 0; evg < this.nEvents; evg++)
			{
				evgPtr = this.events[evg];
				bOrBefore = true;
				for (evt = 0; evt < evgPtr.evgNCond; evt++)
				{
					evtPtr = evgPtr.evgEvents[evt];
					type = CEventProgram.EVTTYPE(evtPtr.evtCode);
					code = evtPtr.evtCode;
					num = -CEventProgram.EVTNUM(code);

					if (bOrBefore)
					{
						// Dans la liste des evenements ALWAYS
						if ((evtPtr.evtFlags & CEvent.EVFLAGS_ALWAYS) != 0)
						{
							evtAlways++;
							this.eventPointersGroup[evtAlwaysPos] = evgPtr;
							this.eventPointersCnd[evtAlwaysPos] = evt;
							evtAlwaysPos++;
						}

						// Dans la liste des evenements generaux si objet systeme
						if (type < 0)
						{
							lposPtr = aListPointers[COI.NUMBEROF_SYSTEMTYPES + type] + num;
							this.eventPointersGroup[lposBuffer[lposPtr]] = evgPtr;
							this.eventPointersCnd[lposBuffer[lposPtr]] = evt;
							lposBuffer[lposPtr]++;

							if (evtPtr.evtCode == CCnd.CND_ONLOOP)
							{
								var n;
								var bOR = false;
								for (n = 0; n < evgPtr.evgNCond; n++)
								{
									if (evgPtr.evgEvents[n].evtCode == CCnd.CND_OR || evgPtr.evgEvents[n].evtCode == CCnd.CND_ORLOGICAL)
										break;
								}
								if (n < evgPtr.evgNCond)
									bOR = true;

								var expression = evtPtr.evtParams[0];
								if (expression.tokens[0].code == CExp.EXP_STRING && expression.tokens[1].code == 0)
								{
									var pName = expression.tokens[0].string;
									var fastLoopIndex = this.rhPtr.addFastLoop(pName);
									for (n = 0; n < posStartLoop.length; n++)
									{
										var pPos = posStartLoop[n];
										if (CServices.compareStringsIgnoreCase(pPos.name, pName))
										{
											if (!this.rhPtr.rh4PosOnLoop)
												this.rhPtr.rh4PosOnLoop = new Array();

											var posOnLoop = null;
											for (n = 0; n < this.rhPtr.rh4PosOnLoop.length; n++)
											{
												if (CServices.compareStringsIgnoreCase(pName, this.rhPtr.rh4PosOnLoop[n].name))
												{
													posOnLoop = this.rhPtr.rh4PosOnLoop[n];
													break;
												}
											}
											if (!posOnLoop)
											{
												posOnLoop = new CPosOnLoop(pName, fastLoopIndex);
												this.rhPtr.rh4PosOnLoop.push(posOnLoop);
											}
											posOnLoop.AddOnLoop(evgPtr);
											posOnLoop.m_bOR |= bOR;
											pPos.address.fastFastLoop = n + 1;
											break;
										}
									}
								}
								else
								{
									this.complexOnLoop = true;
								}
							}

						}
						else
						// Un objet normal : relie a l'objet
						{
							wPtrNear = 0;
							for (o = this.qual_GetFirstOiList(evtPtr.evtOiList); o != -1; o = this.qual_GetNextOiList())
							{
								lposPtr = aListPointers[COI.NUMBEROF_SYSTEMTYPES + o] + num;
								this.eventPointersGroup[lposBuffer[lposPtr]] = evgPtr;
								this.eventPointersCnd[lposBuffer[lposPtr]] = evt;
								lposBuffer[lposPtr]++;
								wBufNear[wPtrNear++] = o;
							}
							wBufNear[wPtrNear] = -1;
							// Cas special pour les collisions de sprites : branche aux deux sprites (sauf si meme!)
							if (CEventProgram.getEventCode(code) == (-14 << 16))      // CNDL_EXTCOLLISION
							{
								evpPtr = evtPtr.evtParams[0];
								for (oo = this.qual_GetFirstOiList(evpPtr.oiList); oo != -1; oo = this.qual_GetNextOiList())
								{
									for (wPtrNear = 0; wBufNear[wPtrNear] != oo && wBufNear[wPtrNear] != -1;)
										wPtrNear++;
									if (wBufNear[wPtrNear] == -1)
									{
										lposPtr = aListPointers[COI.NUMBEROF_SYSTEMTYPES + oo] + num;
										this.eventPointersGroup[lposBuffer[lposPtr]] = evgPtr;
										this.eventPointersCnd[lposBuffer[lposPtr]] = evt;
										lposBuffer[lposPtr]++;
									}
								}
							}
						}
					}
					bOrBefore = false;
					if (evtPtr.evtCode == ((-24 << 16) | 65535) || evtPtr.evtCode == ((-25 << 16) | 65535))     // CNDL_OR - CNDL_ORLOGICAL
					{
						bOrBefore = true;
					}
				}
			}
			;

			// Adresse des conditions timer
			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			uil = aListPointers[COI.NUMBEROF_SYSTEMTYPES + COI.OBJ_TIMER];
			aTimers = this.listPointers[uil - CEventProgram.EVTNUM(((-3 << 16) | 0xFFFC))];     // CNDL_TIMER

			// Poke les adresses et les autres flags des pointeurs dans tous OI
			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			this.limitBuffer = new Array(oiMax + 1 + colList / 2);
			var limitListStart = 0;
			var limitPos, limitCur;
			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
			{
				oilPtr = this.rhPtr.rhOiList[oil];

				// Poke l'offset dans les events
				// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				uil = aListPointers[COI.NUMBEROF_SYSTEMTYPES + oil];
				oilPtr.oilEvents = uil;

				// Traitement des flags particuliers
				// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				var act;
				if ((oilPtr.oilOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0)
				{
					// Recherche les flags WRAP dans les messages OUT OF PLAYFIELD
					fWrap = 0;
					ss = this.listPointers[uil - CEventProgram.EVTNUM(-12 << 16)];     // CNDL_EXTOUTPLAYFIELD
					if (ss != 0)
					{
						while (this.eventPointersGroup[ss] != null)
						{
							evgPtr = this.eventPointersGroup[ss];
							evtPtr = evgPtr.evgEvents[this.eventPointersCnd[ss]];
							d = evtPtr.evtParams[0].value;	// Prend la direction
							for (act = CEventProgram.evg_FindAction(evgPtr, 0), n = evgPtr.evgNAct; n > 0; n--, act++)
							{
								evtPtr = evgPtr.evgEvents[act];
								if (evtPtr.evtCode == ((8 << 16) | (oilPtr.oilType & 0xFFFF))) // ACT_EXTWRAP
								{
									fWrap |= d;
								}
							}
							ss++;
						}
					}
					oilPtr.oilWrap = fWrap;

					// Fabrique la table de limitations des mouvements
					// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
					oi1 = oilPtr.oilOi;
					for (colList = 0  , limitPos = 0; this.colBuffer[colList] != -1; colList += 2)
					{
						if (this.colBuffer[colList] == oi1)
						{
							oi2 = this.colBuffer[colList + 1];
							if ((oi2 & 0x8000) != 0)
							{
								oilPtr.oilLimitFlags |= oi2;
								continue;
							}
							for (limitCur = 0; limitCur < limitPos && this.limitBuffer[limitListStart + limitCur] != oi2;)
								limitCur++;
							if (limitCur == limitPos)
							{
								this.limitBuffer[limitListStart + limitPos++] = oi2;
							}
						}
					}
					// Marque la fin...
					if (limitPos > 0)
					{
						oilPtr.oilLimitList = limitListStart;
						this.limitBuffer[limitListStart + limitPos++] = -1;
						limitListStart += limitPos;
					}
				}
			}

			// Met les adresses des tables de pointeur systeme
			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			this.rhEvents[0] = 0;
			for (n = 1; n <= COI.NUMBEROF_SYSTEMTYPES; n++)
			{
				this.rhEvents[n] = aListPointers[COI.NUMBEROF_SYSTEMTYPES - n];
			}

			// Poke les adresses et les autres flags des pointeurs dans tous les objets definis
			// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
			{
				oilPtr = this.rhPtr.rhOiList[oil];

				// Explore tous les objets de meme OI dans le programme
				o = oilPtr.oilObject;
				if ((o & 0x80000000) == 0)
				{
					do
					{
						// Met les oi dans les ro
						hoPtr = this.rhPtr.rhObjectList[o];
						hoPtr.hoEvents = oilPtr.oilEvents;
						hoPtr.hoOiList = oilPtr;
						hoPtr.hoLimitFlags = oilPtr.oilLimitFlags;
						// Flags Wrap pour les objets avec movement
						if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0)
						{
							hoPtr.rom.rmWrapping = oilPtr.oilWrap;
						}
						// Si le sprite n'est pas implique dans les collisions . le passe en neutre
						if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_SPRITES) != 0 && (hoPtr.hoLimitFlags & (CObjInfo.OILIMITFLAGS_QUICKCOL)) == 0)
						{
							hoPtr.ros.setColFlag(false);
						}
						// Sprite en mode inbitate?
						if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_MANUALSLEEP) == 0)
						{
							// On detruit... sauf si...
							hoPtr.hoOEFlags &= ~CObjectCommon.OEFLAG_NEVERSLEEP;

							// On teste des collisions avec le decor?
							if ((hoPtr.hoLimitFlags & CObjInfo.OILIMITFLAGS_QUICKBACK) != 0)
							{
								// Si masque des collisions general
								if ((this.rhPtr.rhFrame.leFlags & CRunFrame.LEF_TOTALCOLMASK) != 0)
								{
									hoPtr.hoOEFlags |= CObjectCommon.OEFLAG_NEVERSLEEP;
								}
							}
							// Ou test des collisions normal
							if ((hoPtr.hoLimitFlags & (CObjInfo.OILIMITFLAGS_QUICKCOL | CObjInfo.OILIMITFLAGS_QUICKBORDER)) != 0)
							{
								hoPtr.hoOEFlags |= CObjectCommon.OEFLAG_NEVERSLEEP;
							}
						}
						o = hoPtr.hoNumNext;
					} while ((o & 0x80000000) == 0);
				}
			}
			// Les messages speciaux
			// ~~~~~~~~~~~~~~~~~~~~~
			if (evtAlways != 0)
			{
				this.rhEventAlways = true;
			}
			else
			{
				this.rhEventAlways = false;
			}
			// Messages Timer (a bulle!)
			if (aTimers != 0)
			{
				this.rh4TimerEventsBase = aTimers;
			}
			else
			{
				this.rh4TimerEventsBase = 0;
			}

			// Liberation
			this.colBuffer = null;
			this.bReady = true;

		},

		unBranchPrograms: function ()
		{
			this.bReady = false;
			this.qualToOiList = null;
			this.limitBuffer = null;
			this.listPointers = null;
			this.eventPointersGroup = null;
			this.eventPointersCnd = null;
		},

		get_OiListOffset: function (oi, type)
		{
			if ((oi & COI.OIFLAG_QUALIFIER) != 0)
			{
				var q;
				for (q = 0; oi != this.qualifiers[q].qOi || type != this.qualifiers[q].qType;)
					q++;
				return (q | 0x8000);
			}
			else
			{
				var n;
				for (n = 0; n < this.rhPtr.rhMaxOI && this.rhPtr.rhOiList[n].oilOi != oi;)
					n++;
				return n;
			}
		},

		isTypeRealSprite: function (type)
		{
			var oil;
			for (oil = 0; oil < this.rhPtr.rhMaxOI; oil++)
			{
				if (this.rhPtr.rhOiList[oil].oilOi != -1)
				{
					if (this.rhPtr.rhOiList[oil].oilType == type)
					{
						if ((this.rhPtr.rhOiList[oil].oilOEFlags & CObjectCommon.OEFLAG_SPRITES) != 0 && (this.rhPtr.rhOiList[oil].oilOEFlags & CObjectCommon.OEFLAG_QUICKDISPLAY) == 0)
						{
							return true;
						}
						else
						{
							return false;
						}
					}
				}
			}
			return true;
		},

		qual_GetFirstOiList: function (o)
		{
			if ((o & 0x8000) == 0)
			{
				this.qualOilPtr = -1;
				return (o);
			}
			if (o == -1)
			{
				return -1;
			}

			o &= 0x7FFF;
			this.qualOilPtr = o;
			this.qualOilPos = 0;
			return this.qual_GetNextOiList();
		},

		qual_GetNextOiList: function ()
		{
			var o;

			if (this.qualOilPtr == -1)
			{
				return -1;
			}
			if (this.qualOilPos >= this.qualToOiList[this.qualOilPtr].qoiList.length)
			{
				return -1;
			}
			o = this.qualToOiList[this.qualOilPtr].qoiList[this.qualOilPos + 1];
			this.qualOilPos += 2;
			return (o);
		},

		qual_GetFirstOiList2: function (o)
		{
			if ((o & 0x8000) == 0)
			{
				this.qualOilPtr2 = -1;
				return (o);
			}
			if (o == -1)
			{
				return -1;
			}

			o &= 0x7FFF;
			this.qualOilPtr2 = o;
			this.qualOilPos2 = 0;
			return this.qual_GetNextOiList2();
		},

		qual_GetNextOiList2: function ()
		{
			var o;

			if (this.qualOilPtr2 == -1)
			{
				return -1;
			}
			if (this.qualOilPos2 >= this.qualToOiList[this.qualOilPtr2].qoiList.length)
			{
				return -1;
			}
			o = this.qualToOiList[this.qualOilPtr2].qoiList[this.qualOilPos2 + 1];
			this.qualOilPos2 += 2;
			return (o);
		},

		addColList: function (oiList, oiNum, oiList2, oiNum2)
		{
			var qoil;
			var pOinOil;
			if (oiNum < 0)
			{
				if (this.qualToOiList != null)
				{
					qoil = this.qualToOiList[oiList & 0x7FFF];
					pOinOil = 0;
					while (pOinOil < qoil.qoiList.length)
					{
						this.addColList(qoil.qoiList[pOinOil + 1], qoil.qoiList[pOinOil], oiList2, oiNum2);
						pOinOil += 2;
					}
				}
				return;
			}

			if (oiNum2 < 0)
			{
				if (this.qualToOiList != null)
				{
					qoil = this.qualToOiList[oiList2 & 0x7FFF];
					pOinOil = 0;
					while (pOinOil < qoil.qoiList.length)
					{
						this.addColList(oiList, oiNum, qoil.qoiList[pOinOil + 1], qoil.qoiList[pOinOil]);
						pOinOil += 2;
					}
				}
				return;
			}

			var colList;
			var oilPtr = this.rhPtr.rhOiList[oiList];
			if (oilPtr.oilColList == null)
			{
				oilPtr.oilColList = new Array();
				colList = oilPtr.oilColList;
			}
			else
			{
				colList = oilPtr.oilColList;

				var n;
				for (n = 0; n < colList.length; n += 2)
				{
					if (oiNum2 == colList[n])
					{
						return;
					}
				}
			}
			colList.push(oiNum2);
			colList.push(oiList2);
		},

		make_ColList1: function (evgPtr, colList, oi1)
		{
			var oi2;
			var flag;
			var code;
			var o;
			var evtPtr;
			var evpPtr;
			var evt;

			for (evt = 0; evt < evgPtr.evgNCond; evt++)
			{
				evtPtr = evgPtr.evgEvents[evt];
				if (CEventProgram.EVTTYPE(evtPtr.evtCode) >= 2)
				{
					flag = (0x8000 + CObjInfo.OILIMITFLAGS_BACKDROPS);
					code = CEventProgram.getEventCode(evtPtr.evtCode);
					switch (code)
					{
						case (-14 << 16):
							evpPtr = evtPtr.evtParams[0];
							for (o = this.qual_GetFirstOiList(evtPtr.evtOiList); o != -1; o = this.qual_GetNextOiList())
							{
								oi2 = this.rhPtr.rhOiList[o].oilOi;
								if (oi1 == oi2)
								{
									flag = 0;
									colList = this.make_ColList2(colList, oi1, evpPtr.oiList);
								}
							}
							if (flag == 0)
							{
								break;
							}
							for (o = this.qual_GetFirstOiList(evpPtr.oiList); o != -1; o = this.qual_GetNextOiList())
							{
								oi2 = this.rhPtr.rhOiList[o].oilOi;
								if (oi1 == oi2)
								{
									colList = this.make_ColList2(colList, oi1, evtPtr.evtOiList);
								}
							}
							break;
						case (-12 << 16):
							evpPtr = evtPtr.evtParams[0];
							flag = (0x8000 + evpPtr.value);
						case (-13 << 16):
							for (o = this.qual_GetFirstOiList(evtPtr.evtOiList); o != -1; o = this.qual_GetNextOiList())
							{
								oi2 = this.rhPtr.rhOiList[o].oilOi;
								if (oi1 == oi2)
								{
									this.colBuffer[colList++] = oi1;
									this.colBuffer[colList++] = flag;
								}
							}
							break;
					}
				}
			}
			return (colList);
		},

		make_ColList2: function (colList, oi1, ol)
		{
			var oi2;
			var o;
			for (o = this.qual_GetFirstOiList(ol); o != -1; o = this.qual_GetNextOiList())
			{
				oi2 = this.rhPtr.rhOiList[o].oilOi;

				var pos;
				for (pos = 0; pos < colList; pos += 2)
				{
					if (this.colBuffer[pos] == oi1 && this.colBuffer[pos + 1] == oi2)
					{
						break;
					}
				}
				if (pos == colList)
				{
					this.colBuffer[colList++] = oi1;
					this.colBuffer[colList++] = oi2;
				}
			}
			return colList;
		},

		getCollisionFlags: function ()
		{
			var evgPtr;
			var evtPtr;
			var evpPtr;
			var evg, evt, evp;
			var flag;
			for (evg = 0; evg < this.events.length; evg++)
			{
				evgPtr = this.events[evg];

				for (evt = 0; evt < evgPtr.evgNAct + evgPtr.evgNCond; evt++)
				{
					evtPtr = evgPtr.evgEvents[evt];

					if (evtPtr.evtNParams > 0)
					{
						for (evp = 0; evp < evtPtr.evtNParams; evp++)
						{
							evpPtr = evtPtr.evtParams[evp];
							if (evpPtr.code == 43)
							{
								var p = evpPtr;
								switch (p.value)
								{
									case 1:
										flag |= CColMask.CM_OBSTACLE;
										break;
									case 2:
										flag |= CColMask.CM_PLATFORM;
										break;
								}
							}
						}
					}
				}
			}
			return flag;
		},

		enumSounds: function (sounds)
		{
			var evgPtr;
			var evtPtr;
			var evg, evt, p;
			var pSample;

			for (evg = 0; evg < this.nEvents; evg++)
			{
				evgPtr = this.events[evg];
				for (evt = 0; evt < evgPtr.evgNCond + evgPtr.evgNAct; evt++)
				{
					evtPtr = evgPtr.evgEvents[evt];
					for (p = 0; p < evtPtr.evtNParams; p++)
					{
						switch (evtPtr.evtParams[p].code)
						{
							case 6:
							case 35:
								pSample = evtPtr.evtParams[p];
								sounds.enumerate(pSample.sndHandle);
								break;
						}
					}
				}
			}
		},

		HandleKeyRepeat: function ()
		{
			var evgPtr;
			var evtPtr;
			var evg, evt, p;

			for (evg = 0; evg < this.nEvents; evg++)
			{
				evgPtr = this.events[evg];
				for (evt = 0; evt < evgPtr.evgNCond; evt++)
				{
					evtPtr = evgPtr.evgEvents[evt];
					if (evtPtr.evtCode == ((-1 << 16) | 0xFFFA))
					{
						evgPtr.evgInhibit = this.rhPtr.rhLoopCount;
						break;
					}
				}
			}
		}
	}


	// CEventGroup object
	// ----------------------------------------------------------
	CEventGroup.EVGFLAGS_ONCE = 0x0001;
	CEventGroup.EVGFLAGS_NOTALWAYS = 0x0002;
	CEventGroup.EVGFLAGS_REPEAT = 0x0004;
	CEventGroup.EVGFLAGS_NOMORE = 0x0008;
	CEventGroup.EVGFLAGS_SHUFFLE = 0x0010;
	CEventGroup.EVGFLAGS_UNDOMARK = 0x0040;
	CEventGroup.EVGFLAGS_COMPLEXGROUP = 0x0080;
	CEventGroup.EVGFLAGS_BREAKPOINT = 0x0100;
	CEventGroup.EVGFLAGS_ALWAYSCLEAN = 0x0200;
	CEventGroup.EVGFLAGS_ORINGROUP = 0x0400;
	CEventGroup.EVGFLAGS_STOPINGROUP = 0x0800;
	CEventGroup.EVGFLAGS_ORLOGICAL = 0x1000;
	CEventGroup.EVGFLAGS_GROUPED = 0x2000;
	CEventGroup.EVGFLAGS_INACTIVE = 0x4000;
	CEventGroup.EVGFLAGS_NOGOOD = 0x8000;
	CEventGroup.EVGFLAGS_LIMITED = CEventGroup.EVGFLAGS_SHUFFLE + CEventGroup.EVGFLAGS_NOTALWAYS + CEventGroup.EVGFLAGS_REPEAT + CEventGroup.EVGFLAGS_NOMORE;
	CEventGroup.EVGFLAGS_DEFAULTMASK = CEventGroup.EVGFLAGS_BREAKPOINT + CEventGroup.EVGFLAGS_GROUPED;

	function CEventGroup()
	{
		this.evgNCond = 0;
		this.evgNAct = 0;
		this.evgFlags = 0;
		this.evgInhibit = 0;
		this.evgInhibitCpt = 0;
	    this.evgEvents = null;
	}
	CEventGroup.create = function (app)
	{
		var debut = app.file.getFilePointer();

		var size = app.file.readShort();
		var evg = new CEventGroup();
		evg.evgNCond = app.file.readAByte();
		evg.evgNAct = app.file.readAByte();
		evg.evgFlags = app.file.readAShort();
		app.file.skipBytes(2);
		evg.evgInhibit = app.file.readAInt();
		evg.evgInhibitCpt = app.file.readAInt();

		evg.evgEvents = new Array(evg.evgNCond + evg.evgNAct);
		var n;
		var count = 0;
		for (n = 0; n < evg.evgNCond; n++)
		{
			evg.evgEvents[count++] = CCnd.create(app);
		}
		for (n = 0; n < evg.evgNAct; n++)
		{
			evg.evgEvents[count++] = CAct.create(app);
		}
		app.file.seek(debut - size);
		return evg;
	}

	// CEvent
	// ------------------------------------------------------------
	CEvent.EVFLAGS_REPEAT = 0x01;
	CEvent.EVFLAGS_DONE = 0x02;
	CEvent.EVFLAGS_DEFAULT = 0x04;
	CEvent.EVFLAGS_DONEBEFOREFADEIN = 0x08;
	CEvent.EVFLAGS_NOTDONEINSTART = 0x10;
	CEvent.EVFLAGS_ALWAYS = 0x20;
	CEvent.EVFLAGS_BAD = 0x40;
	CEvent.EVFLAGS_BADOBJECT = 0x80;
	CEvent.EVFLAGS_DEFAULTMASK = CEvent.EVFLAGS_ALWAYS + CEvent.EVFLAGS_REPEAT + CEvent.EVFLAGS_DEFAULT + CEvent.EVFLAGS_DONEBEFOREFADEIN + CEvent.EVFLAGS_NOTDONEINSTART;
	CEvent.EVFLAG2_NOT = 0x01;
	function CEvent()
	{
	}

	// Various objects
	// ------------------------------------------------------------
	function CGroupFind()
	{
		this.id = 0;
		this.evg = 0;
	}
	function CLoadQualifiers()
	{
		this.qOi = 0;
		this.qType = 0;
	}
	function CPushedEvent(r, c, p, hoPtr, o)
	{
		this.routine = r;
		this.code = c;
		this.param = p;
		this.pHo = hoPtr;
		this.oi = o;
	}
	function CQualToOiList()
	{
		this.qoiCurrentOi = 0
		this.qoiNext = 0;
		this.qoiActionPos = 0;
		this.qoiCurrentRoutine = 0;
		this.qoiActionCount = 0;
		this.qoiActionLoopCount = 0;
		this.qoiNextFlag = false;
		this.qoiSelectedFlag = false;
		this.qoiList = null;
	}

	// ForEach
	// -------------------------------------------------------------------------
	function ForEach()
	{
		this.next = null;
		this.oi = 0;
		this.index = 0;
		this.name = null;
		this.number = 0;
		this.stop = false;
		this.objects = new Array();
	}

	// TimerEvents
	// -------------------------------------------------------------------------
	TimerEvents.TIMEREVENTTYPE_ONESHOT = 0;
	TimerEvents.TIMEREVENTTYPE_REPEAT = 1;
	function TimerEvents()
	{
		this.next = null;
		this.type = 0;
		this.name = null;
		this.timer = 0;
		this.timerNext = 0;
		this.timerPosition = 0;
		this.loops = 0;
		this.index = 0;
		this.bDelete = false;
	}	// CLO Object
	// -------------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	CLO.PARENT_NONE = 0;
	CLO.PARENT_FRAME = 1;
	CLO.PARENT_FRAMEITEM = 2;
	CLO.PARENT_QUALIFIER = 3;
	function CLO()
	{
		this.loHandle = 0;
		this.loOiHandle = 0;
		this.loX = 0;
		this.loY = 0;
		this.loParentType = 0;
		this.loOiParentHandle = 0;
		this.loLayer = 0;
		this.loType = 0;
		this.loInstances = null;

		this.loInstances = new Array(4);
		var i;
		for (i = 0; i < 4; i++)
			this.loInstances[i] = null;
	}
	CLO.prototype =
	{
		load:        function (file)
		{
			this.loHandle = file.readAShort();
			this.loOiHandle = file.readAShort();
			this.loX = file.readAInt();
			this.loY = file.readAInt();
			this.loParentType = file.readAShort();
			this.loOiParentHandle = file.readAShort();
			this.loLayer = file.readAShort();
			file.skipBytes(2);
		},
		addInstance: function (num, bi)
		{
			this.loInstances[num] = bi;
		}
	}

	// CLOList object
	// --------------------------------------------------------------
	function CLOList()
	{
		this.list = null;
		this.handleToIndex = null;
		this.nIndex = 0;
		this.loFranIndex = 0;
	}
	CLOList.prototype =
	{
		load:            function (app)
		{
			this.nIndex = app.file.readAInt();
			this.list = new Array(this.nIndex);
			var n;
			var maxHandles = 0;
			for (n = 0; n < this.nIndex; n++)
			{
				this.list[n] = new CLO();
				this.list[n].load(app.file);
				if (this.list[n].loHandle + 1 > maxHandles)
				{
					maxHandles = this.list[n].loHandle + 1;
				}
				var pOI = app.OIList.getOIFromHandle(this.list[n].loOiHandle);
				this.list[n].loType = pOI.oiType;
			}
			this.handleToIndex = new Array(maxHandles);
			for (n = 0; n < this.nIndex; n++)
			{
				this.handleToIndex[this.list[n].loHandle] = n;
			}
		},
		getLOFromIndex:  function (index)
		{
			return this.list[index];
		},
		getLOFromHandle: function (handle)
		{
			if (handle < this.handleToIndex.length)
			{
				return this.list[this.handleToIndex[handle]];
			}
			return null;
		},

		next_LevObj: function ()
		{
			var plo;
			if (this.loFranIndex < this.nIndex)
			{
				do
				{
					plo = this.list[this.loFranIndex++];
					if (plo.loType >= 2)		// OBJ_SPR
					{
						return plo;
					}
				} while (this.loFranIndex < this.nIndex);
			}
			return null;
		},

		first_LevObj: function ()
		{
			this.loFranIndex = 0;
			return this.next_LevObj();
		}
	}

	// CLayer object
	// --------------------------------------------------------------------------
	CLayer.FLOPT_XCOEF = 0x0001;
	CLayer.FLOPT_YCOEF = 0x0002;
	CLayer.FLOPT_NOSAVEBKD = 0x0004;
	CLayer.FLOPT_VISIBLE = 0x0010;
	CLayer.FLOPT_WRAP_HORZ = 0x0020;
	CLayer.FLOPT_WRAP_VERT = 0x0040;
	CLayer.FLOPT_REDRAW = 0x000010000;
	CLayer.FLOPT_TOHIDE = 0x000020000;
	CLayer.FLOPT_TOSHOW = 0x000040000;
	function CLayer(a)
	{
		this.app = a;
		this.pName = null;
		this.x = 0;
		this.y = 0;
		this.dx = 0;
		this.dy = 0;
		this.pObstacles = null;
		this.pPlatforms = null;
		this.addedBackdrops = null;
		this.bVisible = false;
		this.pLadders = null;
		this.nZOrderMax = 0;
		this.dwOptions = 0;
		this.xCoef = 0;
		this.yCoef = 0;
		this.nBkdLOs = 0;
		this.nFirstLOIndex = 0;
		this.effect = 0;
		this.effectParam = 0;
		this.backUp_dwOptions = 0;
		this.backUp_xCoef = 0;
		this.backUp_yCoef = 0;
		this.backUp_nBkdLOs = 0;
		this.backUp_nFirstLOIndex = 0;
		this.planeBack = null;
		this.planeQuickDisplay = null;
		this.planeSprites = null;
		this.angle = 0;
		this.scale = this.scaleX = this.scaleY = 1;
		this.xSpot = this.xDest = 320;
		this.ySpot = this.yDest = 240;
	}
	CLayer.prototype =
	{
		load:                 function (file)
		{
			this.dwOptions = file.readAInt();
			this.xCoef = file.readAFloat();
			this.yCoef = file.readAFloat();
			this.nBkdLOs = file.readAInt();
			this.nFirstLOIndex = file.readAInt();
			this.pName = file.readAString();

			this.backUp_dwOptions = this.dwOptions;
			this.backUp_xCoef = this.xCoef;
			this.backUp_yCoef = this.yCoef;
			this.backUp_nBkdLOs = this.nBkdLOs;
			this.backUp_nFirstLOIndex = this.nFirstLOIndex;
		},
		reset:                function ()
		{
			this.dwOptions = this.backUp_dwOptions;
			this.xCoef = this.backUp_xCoef;
			this.yCoef = this.backUp_yCoef;
			this.nBkdLOs = this.backUp_nBkdLOs;
			this.nFirstLOIndex = this.backUp_nFirstLOIndex;
			this.x = this.y = this.dx = this.dy = 0;

			this.pObstacles = null;
			this.pPlatforms = null;
			this.pLadders = null;
			this.addedBackdrops = null;

			this.setAngle(0);
			this.scale = 1;
			this.setScaleX(1);
			this.setScaleY(1);
			this.setXSpot(this.app.gaCxWin / 2);
			this.setYSpot(this.app.gaCyWin / 2);
			this.setXDest(this.app.gaCxWin / 2);
			this.setYDest(this.app.gaCyWin / 2);
			this.setZoom(false);

			if (this.dwOptions & CLayer.FLOPT_TOHIDE)
			{
				this.bVisible = true;
				this.hide();
			}
			else
			{
				this.bVisible = false;
				this.show();
			}
		},
		deleteBackObjects:    function ()
		{
			this.planeBack.removeAll();
		},
		addObstacle:          function (bi)
		{
			if (this.pObstacles == null)
				this.pObstacles = new CArrayList();
			this.pObstacles.add(bi);
		},
		delObstacle:          function (bi)
		{
			if (this.pObstacles != null)
				this.pObstacles.removeObject(bi);
		},
		addPlatform:          function (bi)
		{
			if (this.pPlatforms == null)
				this.pPlatforms = new CArrayList();
			this.pPlatforms.add(bi);
		},
		delPlatform:          function (bi)
		{
			if (this.pPlatforms != null)
				this.pPlatforms.removeObject(bi);
		},
		addBackdrop:          function (bi)
		{
			if (this.addedBackdrops == null)
				this.addedBackdrops = new CArrayList();
			this.addedBackdrops.add(bi);
		},
		resetLevelBackground: function ()
		{
			this.pPlatforms = null;
			this.pObstacles = null;
			this.pLadders = null;
			this.addedBackdrops = null;
			this.planeBack.removeAll();
		},
		createPlanes:         function (xOffset, yOffset)
		{
			this.planeBack = new Sprite();
			this.planeBack.x = xOffset;
			this.planeBack.y = yOffset;
			this.planeQuickDisplay = new Sprite();
			this.planeQuickDisplay.x = xOffset;
			this.planeQuickDisplay.y = yOffset;
			this.planeSprites = new Sprite();
			this.planeSprites.x = xOffset;
			this.planeSprites.y = yOffset;

			this.setAngle(0);
			this.scale = 1;
			this.setScaleX(1);
			this.setScaleY(1);
			this.setXSpot(this.app.gaCxWin / 2);
			this.setYSpot(this.app.gaCyWin / 2);
			this.setXDest(this.app.gaCxWin / 2);
			this.setYDest(this.app.gaCyWin / 2);
			this.setZoom(false);

			this.app.mainSprite.addChild(this.planeBack);
			this.app.mainSprite.addChild(this.planeQuickDisplay);
			this.app.mainSprite.addChild(this.planeSprites);
			this.showHide();
		},

		setAngle:  function (angle)
		{
			this.angle = angle;
			this.planeBack.angle = angle;
			this.planeQuickDisplay.angle = angle;
			this.planeSprites.angle = angle;
		},
		setScaleX: function (scale)
		{
			this.scaleX = scale;
			this.planeBack.scaleX = scale;
			this.planeQuickDisplay.scaleX = scale;
			this.planeSprites.scaleX = scale;
		},
		setScaleY: function (scale)
		{
			this.scaleY = scale;
			this.planeBack.scaleY = scale;
			this.planeQuickDisplay.scaleY = scale;
			this.planeSprites.scaleY = scale;
		},
		setXSpot:  function (spot)
		{
			this.xSpot = spot;
			this.planeBack.xSpot = spot;
			this.planeQuickDisplay.xSpot = spot;
			this.planeSprites.xSpot = spot;
		},
		setYSpot:  function (spot)
		{
			this.ySpot = spot;
			this.planeBack.ySpot = spot;
			this.planeQuickDisplay.ySpot = spot;
			this.planeSprites.ySpot = spot;
		},
		setXDest:  function (spot)
		{
			spot = this.app.gaCxWin - spot;
			this.xDest = spot;
			this.planeBack.xDest = spot;
			this.planeQuickDisplay.xDest = spot;
			this.planeSprites.xDest = spot;
		},
		setYDest:  function (spot)
		{
			spot = this.app.gaCyWin - spot;
			this.yDest = spot;
			this.planeBack.yDest = spot;
			this.planeQuickDisplay.yDest = spot;
			this.planeSprites.yDest = spot;
		},
		setZoom:   function (zoom)
		{
			this.bZoom = zoom;
			this.planeBack.bZoom = zoom;
			this.planeQuickDisplay.bZoom = zoom;
			this.planeSprites.bZoom = zoom;
		},

		resetPlanes: function (xOffset, yOffset)
		{
			this.planeBack.x = xOffset;
			this.planeBack.y = yOffset;
			this.planeQuickDisplay.x = xOffset;
			this.planeQuickDisplay.y = yOffset;
			this.planeSprites.x = xOffset;
			this.planeSprites.y = yOffset;
			this.show();
		},

		fillBack: function (sx, sy, color)
		{
			// TODO!
		},

		showHide:               function ()
		{
			if (this.dwOptions & CLayer.FLOPT_VISIBLE)
				this.show();
			else
				this.hide();
		},
		hide:                   function ()
		{
			this.dwOptions &= ~CLayer.FLOPT_TOHIDE;
			if (this.bVisible)
			{
				this.planeBack.visible = false;
				this.planeQuickDisplay.visible = false;
				this.planeSprites.visible = false;
				this.bVisible = false;
			}
		},
		show:                   function ()
		{
			if (this.bVisible == false)
			{
				this.planeBack.visible = true;
				this.planeQuickDisplay.visible = true;
				this.planeSprites.visible = true;
				this.bVisible = true;
			}
		},
		deletePlanes:           function ()
		{
			if (this.planeBack != null)
			{
				this.app.mainSprite.removeChild(this.planeBack);
				this.planeBack = null;
			}
			if (this.planeQuickDisplay != null)
			{
				this.app.mainSprite.removeChild(this.planeQuickDisplay);
				this.planeQuickDisplay = null;
			}
			if (this.planeSprites != null)
			{
				this.app.mainSprite.removeChild(this.planeSprites);
				this.planeSprites = null;
			}
		},
		deleteAddedBackdrops:   function ()
		{
			var n;
			if (this.addedBackdrops != null)
			{
				for (n = 0; n < this.addedBackdrops.size(); n++)
				{
					var bi = this.addedBackdrops.get(n);
					bi.delInstance(this);
					if (bi.body != null)
					{
						this.app.run.rh4Box2DBase.rSubABackdrop(bi.body);
					}
				}
			}
			this.addedBackdrops = null;
		},
		deleteAddedBackdropsAt: function (xx, yy, fine)
		{
			xx += this.x;
			yy += this.y;

			var n;
			if (this.addedBackdrops != null)
			{
				for (n = 0; n < this.addedBackdrops.size(); n++)
				{
					var bi = this.addedBackdrops.get(n);
					if (xx >= bi.x && xx < bi.x + bi.width)
					{
						if (yy >= bi.y && yy < bi.y + bi.height)
						{
							var flag = true;
							if (fine)
							{
								flag = bi.testPoint(xx, yy);
							}
							if (flag)
							{
								bi.delInstance(this);
								this.addedBackdrops.removeObject(bi);
								if (bi.body != null)
								{
									this.app.run.rh4Box2DBase.rSubABackdrop(bi.body);
								}
								return;
							}
						}
					}
				}
			}
		},

		addLadder: function (x1, y1, x2, y2)
		{
			var rc = new CRect();
			rc.left = x1;
			rc.top = y1;
			rc.right = x2;
			rc.bottom = y2;
			if (this.pLadders == null)
				this.pLadders = new CArrayList();
			this.pLadders.add(rc);
		},

		ladderSub:   function (x1, y1, x2, y2)
		{
			if (pLadders != null)
			{
				var rc = new CRect();
				rc.left = Math.min(x1, x2);
				rc.top = Math.min(y1, y2);
				rc.right = Math.max(x1, x2);
				rc.bottom = Math.max(y1, y2);

				var i;
				var rcDst;
				for (i = 0; i < pLadders.size(); i++)
				{
					rcDst = this.pLadders.get(i);
					if (rcDst.intersectRect(rc) == true)
					{
						this.pLadders.removeIndex(i);
						i--;
					}
				}
			}
		},
		getLadderAt: function (xx, yy)
		{
			var nl, nLayers;
			xx += this.x;
			yy += this.y;

			if (this.pLadders != null)
			{
				var i;
				var rc;
				for (i = 0; i < this.pLadders.size(); i++)
				{
					rc = this.pLadders.get(i);
					if (xx >= rc.left)
					{
						if (yy >= rc.top)
						{
							if (xx < rc.right)
							{
								if (yy < rc.bottom)
								{
									return rc;
								}
							}
						}
					}
				}
			}
			return null;
		},
		testMask:    function (mask, xx, yy, htFoot, plan)
		{
			var xLeft = xx + this.x - mask.xSpot;
			var yTop = yy + this.y - mask.ySpot;
			var xRight = xLeft + mask.width;
			var yBottom = yTop + mask.height;
			var yFoot = yTop;
			if (htFoot != 0)
				yFoot = yBottom - htFoot;

			var o;
			var bi;
			var list;
			if (plan == CColMask.CM_TEST_OBSTACLE)
				list = this.pObstacles;
			else
				list = this.pPlatforms;
			if (list == null)
				return null;

			for (o = 0; o < list.size(); o++)
			{
				bi = list.get(o);
				if (bi.x < xRight && bi.x + bi.width > xLeft)
				{
					if (bi.y < yBottom && bi.y + bi.height > yFoot)
					{
						if (bi.testMask(mask, xLeft, yTop, htFoot))
						{
							return bi;
						}
					}
				}
			}
			return null;
		},
		testRect:    function (x1, y1, x2, y2, htFoot, plan)
		{
			var list;
			if (plan == CColMask.CM_TEST_OBSTACLE)
				list = this.pObstacles;
			else
				list = this.pPlatforms;
			if (list == null)
				return null;

			x1 += this.x;
			y1 += this.y;
			x2 += this.x;
			y2 += this.y;
			if (htFoot != 0)
				y1 = y2 - htFoot;

			var o;
			for (o = 0; o < list.size(); o++)
			{
				var bi = list.get(o);
				if (bi.x < x2 && bi.x + bi.width > x1)
				{
					if (bi.y < y2 && bi.y + bi.height > y1)
					{
						if (bi.testRect(x1, y1, x2, y2))
						{
							return bi;
						}
					}
				}
			}
			return null;
		},
		testPoint:   function (x1, y1, plan)
		{
			var list;
			if (plan == CColMask.CM_TEST_OBSTACLE)
				list = this.pObstacles;
			else
				list = this.pPlatforms;
			if (list == null)
				return null;

			x1 += this.x;
			y1 += this.y;

			var o;
			for (o = 0; o < list.size(); o++)
			{
				var bi = list.get(o);
				if (x1 >= bi.x && x1 < bi.x + bi.width)
				{
					if (y1 >= bi.y && y1 < bi.y + bi.height)
					{
						if (bi.testPoint(x1, y1))
						{
							return bi;
						}
					}
				}
			}
			return null;
		}
	}

	// CBackInstance object
	// ------------------------------------------------------------------
	function CBackInstance(a, xx, yy, plo, sprImage, colType)
	{
		this.app = a;
		this.levelObject = plo;
		this.type = 0;
		this.obstacleType = 0;
		this.x = xx;
		this.y = yy;
		this.width = 0;
		this.height = 0;
		this.poi = null;
		this.colBox = false;
		this.imageUsed = null;
		this.borderWidth = 0;
		this.color1 = null;
		this.color2 = null;
		this.borderColor = null;
		this.effect = 0;
		this.effectParam = 0;
		this.body = null;
		this.ho = null;

		if (plo)
		{
			this.poi = this.app.OIList.getOIFromHandle(plo.loOiHandle);
			this.type = this.poi.oiType;
			this.obstacleType = this.poi.oiOC.ocObstacleType;
			this.borderWidth = this.poi.oiOC.ocBorderSize;
			this.gradientFlags = this.poi.oiOC.ocGradientFlags;
			this.effect = this.poi.oiInkEffect;
			this.effectParam = this.poi.oiInkEffectParam;
			this.width = this.poi.oiOC.ocCx;
			this.height = this.poi.oiOC.ocCy;
			this.colBox = this.poi.oiOC.ocColMode != 0;
			this.color1 = this.poi.oiOC.ocColor1;
			this.color2 = this.poi.oiOC.ocColor2;
			this.borderColor = this.poi.oiOC.ocBorderColor;
			if (this.type == 1)
			{
				this.imageUsed = this.app.imageBank.getImageFromHandle(this.poi.oiOC.ocImage);
				this.width = this.imageUsed.width;
				this.height = this.imageUsed.height;
			}
			else if (this.type >= 32)
			{
				var rhPtr = this.app.run;
				var hoPtr = null;
				var count = 0;
				for (var nObject = 0; nObject < rhPtr.rhNObjects; nObject++)
				{
					while (rhPtr.rhObjectList[count] == null)
						count++;
					hoPtr = rhPtr.rhObjectList[count];
					count++;
					if (hoPtr.lo == plo)
					{
						break;
					}
				}
				this.ho = hoPtr;
			}
		}
		else
		{
			this.type = COI.OBJ_PASTED;
			this.imageUsed = sprImage;
			this.width = this.imageUsed.width;
			this.height = this.imageUsed.height;
			this.x -= this.imageUsed.xSpot;
			this.y -= this.imageUsed.ySpot;
			switch (colType)
			{
				case 0:
					this.obstacleType = COC.OBSTACLE_NONE;
					break;
				case 1:
					this.obstacleType = COC.OBSTACLE_SOLID;
					break;
				case 2:
					this.obstacleType = COC.OBSTACLE_PLATFORM;
					break;
				case 3:
					this.obstacleType = COC.OBSTACLE_LADDER;
					break;
			}
			this.colBox = false;
		}
	}
	CBackInstance.prototype =
	{
		draw:        function (context, xx, yy)
		{
			if (this.levelObject != null)
			{
				if (this.type == COI.OBJ_BOX)
				{
					var pCOCQB = this.poi.oiOC;
					var image;

					switch (pCOCQB.ocFillType)
					{
						case 0: /* no fill */
							break;

						case 1: /* solid */

							switch (pCOCQB.ocShape)
							{
								case 1: /* line */

									context.renderLine(xx + this.x, yy + this.y, this.width,
										this.height, this.color1, this.effect,
										this.effectParam);

									break;

								case 2: /* rectangle */

									context.renderSolidColor(xx + this.x, yy + this.y, this.width,
										this.height, this.color1, this.effect,
										this.effectParam);

									break;

								case 3: /* ellipse */
									context.renderSolidColorEllipse(xx + this.x, yy + this.y, this.width,
										this.height, this.color1, this.effect,
										this.effectParam);
									break;
							}
							;

							break;

						case 2: /* gradient */

							switch (pCOCQB.ocShape)
							{
								case 1: /* line */

									context.renderLine(xx + this.x, yy + this.y, this.width,
										this.height, this.color1, this.effect,
										this.effectParam);

									break;

								case 2: /* rectangle */

									context.renderGradient(xx + this.x, yy + this.y, this.width,
										this.height, this.color1, this.color2, this.gradientFlags != 0,
										this.effect, this.effectParam);

									break;

								case 3: /* ellipse */

									context.renderGradientEllipse(xx + this.x, yy + this.y, this.width,
										this.height, this.color1, this.color2, this.gradientFlags != 0,
										this.effect, this.effectParam);

									break;
							}
							;

							break;

						case 3: /* motif */

							switch (pCOCQB.ocShape)
							{
								case 1: /* line */
									break;

								case 2: /* rectangle */
									image = this.app.imageBank.getImageFromHandle(pCOCQB.ocImage);
									context.renderPattern(image, xx + this.x, yy + this.y, this.width,
										this.height, this.effect, this.effectParam);
									break;

								case 3: /* ellipse */
									image = this.app.imageBank.getImageFromHandle(pCOCQB.ocImage);
									context.renderPatternEllipse(image, xx + this.x, yy + this.y, this.width,
										this.height, this.effect, this.effectParam);
									break;
							}
							break;
					}

					if (this.borderWidth > 0)
					{
						switch (pCOCQB.ocShape)
						{
							case 1: /* line */

								var xLine = 0;
								var yLine = 0;
								var cxLine = this.width;
								var cyLine = this.height;
								if ((pCOCQB.ocLineFlags & COCQBackdrop.LINEF_INVX) != 0)
								{
									xLine += cxLine;
									cxLine = -cxLine;
								}
								if ((pCOCQB.ocLineFlags & COCQBackdrop.LINEF_INVY) != 0)
								{
									yLine += cyLine;
									cyLine = -cyLine;
								}

								context.renderLine(xx + this.x + xLine, yy + this.y + yLine,
									xx + this.x + xLine + cxLine, yy + this.y + yLine + cyLine,
									this.borderColor, this.borderWidth);

								break;

							case 2: /* rectangle */

								context.renderRect(xx + this.x, yy + this.y, this.width, this.height,
									this.borderColor, this.borderWidth);

								break;

							case 3: /* ellipse */

								context.renderEllipse(xx + this.x, yy + this.y, this.width,
									this.height, 1, this.borderColor, this.borderWidth);
								break;
						}
					}
				}
				else if (this.type == COI.OBJ_BKD)
				{
				    context.renderImageWithSubPixelCorrection(this.imageUsed, xx + this.x + this.imageUsed.xSpot, yy + this.y + this.imageUsed.ySpot, 0, 1.0, 1.0, this.effect, this.effectParam);
				}
				else
				{
				    if ( this.ho != null )
					    this.ho.draw(context, xx, yy);
				}
			}
			else
			{
			    context.renderImage(this.imageUsed, xx + this.x + this.imageUsed.xSpot, yy + this.y + this.imageUsed.ySpot, 0, 1.0, 1.0, this.effect, this.effectParam);
			}
		},
		setEffect:   function (e, ep)
		{
			this.effect = e;
			this.effectParam = ep;
		},
		addInstance: function (num, pLayer)
		{
			pLayer.planeBack.addChild(this);
			if (this.type == COI.OBJ_PASTED)
				pLayer.addBackdrop(this);

			switch (this.obstacleType)
			{
				case COC.OBSTACLE_SOLID:
					pLayer.addObstacle(this);
					pLayer.addPlatform(this);
					break;
				case COC.OBSTACLE_PLATFORM:
					pLayer.addPlatform(this);
					break;
				case COC.OBSTACLE_LADDER:
					pLayer.addLadder(this.x, this.y, this.x + this.width, this.y + this.height);
					break;
			}
		},
		delInstance: function (pLayer)
		{
			pLayer.planeBack.removeChild(this);
			switch (this.obstacleType)
			{
				case COC.OBSTACLE_SOLID:
					pLayer.delObstacle(this);
					pLayer.delPlatform(this);
					break;
				case COC.OBSTACLE_PLATFORM:
					pLayer.delPlatform(this);
					break;
				case COC.OBSTACLE_LADDER:
					pLayer.ladderSub(x, y, x + width, y + height);
					break;
			}
		},

		testMask:  function (mask, xx, yy, htFoot)
		{
			var flags;
			var mask2;

			switch (this.type)
			{
				case 0:
					var h = this.height;
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						h = CRunFrame.HEIGHT_PLATFORM;
					}
					return mask.testRect2(xx, yy, htFoot, this.x, this.y, this.width, h, 0);
				case 1:
					if (this.colBox != 0)
					{
						return true;
					}
					flags = CMask.GCMF_OBSTACLE;
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						flags = CMask.GCMF_PLATFORM;
					}
					mask2 = this.imageUsed.getMask(flags, 0, 1.0, 1.0);
					return mask.testMask(xx, yy, htFoot, mask2, this.x, this.y, 0);
				case 11:
					if (this.colBox != 0)
					{
						return true;
					}
					flags = CMask.GCMF_OBSTACLE;
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						flags = CMask.GCMF_PLATFORM;
					}
					mask2 = this.imageUsed.getMask(flags, 0, 1.0, 1.0);
					return mask.testMask(xx, yy, htFoot, mask2, this.x, this.y, 0);
			}
			return false;
		},
		testRect:  function (x1, y1, x2, y2)
		{
			var flags;
			var mask;

			switch (this.type)
			{
				case 0:
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						var yTop = this.y;
						var yBottom = this.y + Math.min(this.height, CRunFrame.HEIGHT_PLATFORM);
						if (yTop < y2 && yBottom > y1)
						{
							return true;
						}
						return false;
					}
					return true;
				case 1:
					if (this.colBox != 0)
					{
						return true;
					}
					flags = CMask.GCMF_OBSTACLE;
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						flags = CMask.GCMF_PLATFORM;
					}
					mask = this.imageUsed.getMask(flags, 0, 1.0, 1.0);
					return mask.testRect2(this.x, this.y, 0, x1, y1, x2, y2, 0);
				case 11:
					if (this.colBox != 0)
					{
						return true;
					}
					flags = CMask.GCMF_OBSTACLE;
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						flags = CMask.GCMF_PLATFORM;
					}
					mask = this.imageUsed.getMask(flags, 0, 1.0, 1.0);
					return mask.testRect2(this.x, this.y, 0, x1, y1, x2, y2, 0);
			}
			return false;
		},
		testPoint: function (x1, y1)
		{
			var flags;
			var mask;

			switch (this.type)
			{
				case 0:
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						var yTop = y + this.height - CRunFrame.HEIGHT_PLATFORM;
						var yBottom = this.y + this.height;
						if (y1 >= yTop && y1 < yBottom)
						{
							return true;
						}
						return false;
					}
					return true;
				case 1:
					if (this.colBox != 0)
					{
						return true;
					}
					flags = CMask.GCMF_OBSTACLE;
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						flags = CMask.GCMF_PLATFORM;
					}
					mask = this.imageUsed.getMask(flags, 0, 1.0, 1.0);
					return mask.testPoint(this.x, this.y, x1, y1);
				case 11:
					if (this.colBox != 0)
					{
						return true;
					}
					flags = CMask.GCMF_OBSTACLE;
					if (this.obstacleType == COC.OBSTACLE_PLATFORM)
					{
						flags = CMask.GCMF_PLATFORM;
					}
					mask = this.imageUsed.getMask(flags, 0, 1.0, 1.0);
					return mask.testPoint(this.x, this.y, x1, y1);
			}
			return false;
		}
	}


	// COI Object
	// -------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	COI.OILF_OCLOADED = 0x0001;
	COI.OILF_ELTLOADED = 0x0002;
	COI.OILF_TOLOAD = 0x0004;
	COI.OILF_TODELETE = 0x0008;
	COI.OILF_CURFRAME = 0x0010;
	COI.OILF_TORELOAD = 0x0020;
	COI.OILF_IGNORELOADONCALL = 0x0040;
	COI.OIF_LOADONCALL = 0x0001;
	COI.OIF_DISCARDABLE = 0x0002;
	COI.OIF_GLOBAL = 0x0004;
	COI.NUMBEROF_SYSTEMTYPES = 7;
	COI.OBJ_PLAYER = -7;
	COI.OBJ_KEYBOARD = -6;
	COI.OBJ_CREATE = -5;
	COI.OBJ_TIMER = -4;
	COI.OBJ_GAME = -3;
	COI.OBJ_SPEAKER = -2;
	COI.OBJ_SYSTEM = -1;
	COI.OBJ_BOX = 0;
	COI.OBJ_BKD = 1;
	COI.OBJ_SPR = 2;
	COI.OBJ_TEXT = 3;
	COI.OBJ_QUEST = 4;
	COI.OBJ_SCORE = 5;
	COI.OBJ_LIVES = 6;
	COI.OBJ_COUNTER = 7;
	COI.OBJ_RTF = 8;
	COI.OBJ_CCA = 9;
	COI.NB_SYSOBJ = 10;
	COI.OBJ_PASTED = 11;
	COI.OBJ_LAST = 10;
	COI.KPX_BASE = 32;
	COI.OIFLAG_QUALIFIER = 0x8000;

	function COI()
	{
		this.oiHandle = 0;
		this.oiType = 0;
		this.oiFlags = 0;
		this.oiInkEffect = 0;
		this.oiInkEffectParam = 0;
		this.oiName = null;
		this.oiOC = null;
		this.oiFileOffset = 0;
		this.oiLoadFlags = 0;
		this.oiLoadCount = 0;
		this.oiCount = 0;
	}
	COI.prototype =
	{
		loadHeader:   function (file)
		{
			this.oiHandle = file.readAShort();
			this.oiType = file.readAShort();
			this.oiFlags = file.readAShort();
			file.skipBytes(2);
			this.oiInkEffect = file.readAInt();
			this.oiInkEffectParam = file.readAInt();
		},
		load:         function (file)
		{
			file.seek(this.oiFileOffset);

			switch (this.oiType)
			{
				case 0:
					this.oiOC = new COCQBackdrop();
					break;
				case 1:
					this.oiOC = new COCBackground();
					break;
				default:
					this.oiOC = new CObjectCommon();
					break;
			}
			this.oiOC.load(file, this.oiType);
			this.oiLoadFlags = 0;
		},
		unLoad:       function ()
		{
			this.oiOC = null;
		},
		enumElements: function (enumImages, enumFonts)
		{
			this.oiOC.enumElements(enumImages, enumFonts);
		}
	}

	// COIList object
	// ----------------------------------------------------------------------
	function COIList()
	{
		this.oiMaxIndex = 0;
		this.ois = 0;
		this.oiMaxHandle = 0;
		this.oiHandleToIndex = null;
		this.oiToLoad = null;
		this.oiLoaded = null;
		this.currentOI = 0;
	}
	COIList.prototype =
	{
		preLoad:         function (file)
		{
			// Alloue la table de OI
			this.oiMaxIndex = file.readAInt();
			this.ois = new Array(this.oiMaxIndex);

			// Explore les chunks
			var index;
			this.oiMaxHandle = 0;
			for (index = 0; index < this.oiMaxIndex; index++)
			{
				var chID = 0;
				var chFlags;
				var chSize;
				var posEnd;
				while (chID != 0x7F7F)
				{
					chID = file.readAShort();
					chFlags = file.readAShort();
					chSize = file.readAInt();
					if (chSize == 0)
						continue;
					posEnd = file.getFilePointer() + chSize;

					switch (chID)
					{
						case 0x4444:
							this.ois[index] = new COI();
							this.ois[index].loadHeader(file);
							if (this.ois[index].oiHandle >= this.oiMaxHandle)
								this.oiMaxHandle = (this.ois[index].oiHandle + 1);
							break;
						case 0x4445:
							this.ois[index].oiName = file.readAString();
							break;
						case 0x4446:
							this.ois[index].oiFileOffset = file.getFilePointer();
							break;
					}
					file.seek(posEnd);
				}
			}

			this.oiHandleToIndex = new Array(this.oiMaxHandle);
			for (index = 0; index < this.oiMaxIndex; index++)
			{
				this.oiHandleToIndex[this.ois[index].oiHandle] = index;
			}

			this.oiToLoad = new Array(this.oiMaxHandle);
			this.oiLoaded = new Array(this.oiMaxHandle);
			var n;
			for (n = 0; n < this.oiMaxHandle; n++)
			{
				this.oiToLoad[n] = 0;
				this.oiLoaded[n] = 0;
			}
		},
		getOIFromHandle: function (handle)
		{
			return this.ois[this.oiHandleToIndex[handle]];
		},
		getOIFromIndex:  function (index)
		{
			return this.ois[index];
		},
		resetOICurrent:  function ()
		{
			var n;
			for (n = 0; n < this.oiMaxIndex; n++)
			{
				this.ois[n].oiFlags &= ~COI.OILF_CURFRAME;
			}
		},
		setOICurrent:    function (handle)
		{
			this.ois[this.oiHandleToIndex[handle]].oiFlags |= COI.OILF_CURFRAME;
		},
		getFirstOI:      function ()
		{
			var n;
			for (n = 0; n < this.oiMaxIndex; n++)
			{
				if ((this.ois[n].oiFlags & COI.OILF_CURFRAME) != 0)
				{
					this.currentOI = n;
					return this.ois[n];
				}
			}
			return null;
		},
		getNextOI:       function ()
		{
			if (this.currentOI < this.oiMaxIndex)
			{
				var n;
				for (n = this.currentOI + 1; n < this.oiMaxIndex; n++)
				{
					if ((this.ois[n].oiFlags & COI.OILF_CURFRAME) != 0)
					{
						this.currentOI = n;
						return this.ois[n];
					}
				}
			}
			return null;
		},

		resetToLoad:  function ()
		{
			var n;
			for (n = 0; n < this.oiMaxHandle; n++)
			{
				this.oiToLoad[n] = 0;
			}
		},
		setToLoad:    function (n)
		{
			this.oiToLoad[n] = 1;
		},
		load:         function (file)
		{
			var h;
			for (h = 0; h < this.oiMaxHandle; h++)
			{
				if (this.oiToLoad[h] != 0)
				{
					if (this.oiLoaded[h] == 0 || (this.oiLoaded[h] != 0 && (this.ois[this.oiHandleToIndex[h]].oiLoadFlags & COI.OILF_TORELOAD) != 0))
					{
						this.ois[this.oiHandleToIndex[h]].load(file);
						this.oiLoaded[h] = 1;
					}
				}
				else
				{
					if (this.oiLoaded[h] != 0)
					{
						this.ois[this.oiHandleToIndex[h]].unLoad();
						this.oiLoaded[h] = 0;
					}
				}
			}
			this.resetToLoad();
		},
		enumElements: function (enumImages, enumFonts)
		{
			var h;
			for (h = 0; h < this.oiMaxHandle; h++)
			{
				if (this.oiLoaded[h] != 0)
				{
					this.ois[this.oiHandleToIndex[h]].enumElements(enumImages, enumFonts);
				}
			}
		}
	}

	// COC object
	// -------------------------------------------------------------------
	COC.OBSTACLE_NONE = 0;
	COC.OBSTACLE_SOLID = 1;
	COC.OBSTACLE_PLATFORM = 2;
	COC.OBSTACLE_LADDER = 3;
	COC.OBSTACLE_TRANSPARENT = 4;
	function COC()
	{
	}

	// COCBackground object
	// -------------------------------------------------------------------
	function COCBackground()
	{
		this.ocImage = 0;
	}
	COCBackground.prototype =
	{
		load: function (file, type)
		{
			file.skipBytes(4);		// ocDWSize
			this.ocObstacleType = file.readAShort();
			this.ocColMode = file.readAShort();
			this.ocCx = file.readAInt();
			this.ocCy = file.readAInt();
			this.ocImage = file.readAShort();
		},

		enumElements: function (enumImages, enumFonts)
		{
			if (enumImages != null)
			{
				var num = enumImages.enumerate(this.ocImage);
				if (num != -1)
				{
					this.ocImage = num;
				}
			}
		}
	}

	// COCQBackdrop object
	// ------------------------------------------------------------------
	COCQBackdrop.LINEF_INVX = 0x0001;
	COCQBackdrop.LINEF_INVY = 0x0002;
	function COCQBackdrop()
	{
		this.ocBorderSize = 0;
		this.ocBorderColor = 0;
		this.ocShape = 0;
		this.ocFillType = 0;
		this.ocLineFlags = 0;
		this.ocColor1 = 0;
		this.ocColor2 = 0;
		this.ocGradientFlags = 0;
		this.ocImage = 0;
	}
	COCQBackdrop.prototype =
	{
		load: function (file, type)
		{
			file.skipBytes(4);
			this.ocObstacleType = file.readAShort();
			this.ocColMode = file.readAShort();
			this.ocCx = file.readAInt();
			this.ocCy = file.readAInt();
			this.ocBorderSize = file.readAShort();
			this.ocBorderColor = file.readAColor();
			this.ocShape = file.readAShort();

			this.ocFillType = file.readAShort();
			if (this.ocShape == 1)
			{
				this.ocLineFlags = file.readAShort();
			}
			else
			{
				switch (this.ocFillType)
				{
					case 1:
						this.ocColor1 = this.ocColor2 = file.readAColor();
						break;
					case 2:
						this.ocColor1 = file.readAColor();
						this.ocColor2 = file.readAColor();
						this.ocGradientFlags = file.readAInt();
						break;
					case 3:
						this.ocImage = file.readAShort();
						break;
				}
			}
		},

		enumElements: function (enumImages, enumFonts)
		{
			if (this.ocFillType == 3)
			{
				if (enumImages != null)
				{
					var num = enumImages.enumerate(this.ocImage);
					if (num != -1)
					{
						ocImage = num;
					}
				}
			}
		}
	}

	// CObjectCommon object
	// -------------------------------------------------------------------
	CObjectCommon.OEFLAG_DISPLAYINFRONT = 0x0001;
	CObjectCommon.OEFLAG_BACKGROUND = 0x0002;
	CObjectCommon.OEFLAG_BACKSAVE = 0x0004;
	CObjectCommon.OEFLAG_RUNBEFOREFADEIN = 0x0008;
	CObjectCommon.OEFLAG_MOVEMENTS = 0x0010;
	CObjectCommon.OEFLAG_ANIMATIONS = 0x0020;
	CObjectCommon.OEFLAG_TABSTOP = 0x0040;
	CObjectCommon.OEFLAG_WINDOWPROC = 0x0080;
	CObjectCommon.OEFLAG_VALUES = 0x0100;
	CObjectCommon.OEFLAG_SPRITES = 0x0200;
	CObjectCommon.OEFLAG_INTERNALBACKSAVE = 0x0400;
	CObjectCommon.OEFLAG_SCROLLINGINDEPENDANT = 0x0800;
	CObjectCommon.OEFLAG_QUICKDISPLAY = 0x1000;
	CObjectCommon.OEFLAG_NEVERKILL = 0x2000;
	CObjectCommon.OEFLAG_NEVERSLEEP = 0x4000;
	CObjectCommon.OEFLAG_MANUALSLEEP = 0x8000;
	CObjectCommon.OEFLAG_TEXT = 0x10000;
	CObjectCommon.OEFLAG_DONTCREATEATSTART = 0x20000;
	CObjectCommon.OEFLAG_DONTRESETANIMCOUNTER = 0x100000;
	CObjectCommon.OCFLAGS2_DONTSAVEBKD = 0x0001;
	CObjectCommon.OCFLAGS2_SOLIDBKD = 0x0002;
	CObjectCommon.OCFLAGS2_COLBOX = 0x0004;
	CObjectCommon.OCFLAGS2_VISIBLEATSTART = 0x0008;
	CObjectCommon.OCFLAGS2_OBSTACLESHIFT = 4;
	CObjectCommon.OCFLAGS2_OBSTACLEMASK = 0x0030;
	CObjectCommon.OCFLAGS2_OBSTACLE_SOLID = 0x0010;
	CObjectCommon.OCFLAGS2_OBSTACLE_PLATFORM = 0x0020;
	CObjectCommon.OCFLAGS2_OBSTACLE_LADDER = 0x0030;
	CObjectCommon.OCFLAGS2_AUTOMATICROTATION = 0x0040;
	CObjectCommon.OEPREFS_BACKSAVE = 0x0001;
	CObjectCommon.OEPREFS_SCROLLINGINDEPENDANT = 0x0002;
	CObjectCommon.OEPREFS_QUICKDISPLAY = 0x0004;
	CObjectCommon.OEPREFS_SLEEP = 0x0008;
	CObjectCommon.OEPREFS_LOADONCALL = 0x0010;
	CObjectCommon.OEPREFS_GLOBAL = 0x0020;
	CObjectCommon.OEPREFS_BACKEFFECTS = 0x0040;
	CObjectCommon.OEPREFS_KILL = 0x0080;
	CObjectCommon.OEPREFS_INKEFFECTS = 0x0100;
	CObjectCommon.OEPREFS_TRANSITIONS = 0x0200;
	CObjectCommon.OEPREFS_FINECOLLISIONS = 0x0400;
	CObjectCommon.prototype = COC;

	function CObjectCommon()
	{
		this.ocOEFlags = 0;
		this.ocQualifiers = null;
		this.ocFlags2 = 0;
		this.ocOEPrefs = 0;
		this.ocIdentifier = 0;
		this.ocBackColor = 0;
		this.ocMovements = null;
		this.ocValues = null;
		this.ocStrings = null;
		this.ocAnimations = null;
		this.ocCounters = null;
		this.ocObject = null;
		this.ocExtension = 0;
		this.ocVersion = 0;
		this.ocID = 0;
		this.ocPrivate = 0;
		this.ocFadeIn = null;
		this.ocFadeOut = null;
	}
	CObjectCommon.prototype =
	{
		load:         function (file, type)
		{
			// Position de debut
			var debut = file.getFilePointer();
			this.ocQualifiers = new Array(8);

			// Lis le header
			var n;
			file.skipBytes(4);
			file.skipBytes(2);      // var oMovements = file.readAShort();
			var oData = file.readAShort();  // var oAnimations = file.readAShort();
			file.skipBytes(2);
			var oCounter = file.readAShort();
			var oAnimations = file.readAShort(); // var oData = file.readAShort();
			var oMovements = file.readAShort();    // file.skipBytes(2);
			this.ocOEFlags = file.readAInt();
			for (n = 0; n < 8; n++)
			{
				this.ocQualifiers[n] = file.readShort();
			}
			this.ocOEPrefs = file.readAShort(); // var oExtension = file.readAShort();
			var oValues = file.readAShort();
			var oStrings = file.readAShort();
			this.ocFlags2 = file.readAShort();
			var oExtension = file.readAShort(); // this.ocOEPrefs = file.readAShort();
			this.ocIdentifier = file.readAInt();
			this.ocBackColor = file.readAColor();
			var oFadeIn = file.readAInt();
			var oFadeOut = file.readAInt();
			this.ocFadeIn = null;
			this.ocFadeOut = null;

			if (oMovements != 0)
			{
				file.seek(debut + oMovements);
				this.ocMovements = new CMoveDefList();
				this.ocMovements.load(file);
			}
			if (oValues != 0)
			{
				file.seek(debut + oValues);
				this.ocValues = new CDefValues();
				this.ocValues.load(file);
			}
			if (oStrings != 0)
			{
				file.seek(debut + oStrings);
				this.ocStrings = new CDefStrings();
				this.ocStrings.load(file);
			}
			if (oAnimations != 0)
			{
				file.seek(debut + oAnimations);
				this.ocAnimations = new CAnimHeader();
				this.ocAnimations.load(file);
			}
			if (oCounter != 0)
			{
				file.seek(debut + oCounter);
				this.ocObject = new CDefCounter();
				this.ocObject.load(file);
			}
			if (oExtension != 0)
			{
				file.seek(debut + oExtension);
				var size = file.readAInt();
				file.skipBytes(4);
				this.ocVersion = file.readAInt();
				this.ocID = file.readAInt();
				this.ocPrivate = file.readAInt();
				size -= 20;
				if (size != 0)
				{
					this.ocExtension = file.getFilePointer();
				}
			}
			if (oFadeIn != 0)
			{
				file.seek(debut + oFadeIn);
				this.ocFadeIn = new CTransitionData();
				this.ocFadeIn.load(file);
			}
			if (oFadeOut != 0)
			{
				file.seek(debut + oFadeOut);
				this.ocFadeOut = new CTransitionData();
				this.ocFadeOut.load(file);
			}

			if (oData != 0)
			{
				file.seek(debut + oData);
				switch (type)
				{
					case 3:
					case 4:
						this.ocObject = new CDefTexts();
						this.ocObject.load(file);
						break;

					case 5:
					case 6:
					case 7:
						this.ocCounters = new CDefCounters();
						this.ocCounters.load(file);
						break;

					case 8:
						this.ocObject = new CDefRtf();
						this.ocObject.load(file);
						this.ocOEFlags &= ~(CObjectCommon.OEFLAG_SPRITES | CObjectCommon.OEFLAG_QUICKDISPLAY | CObjectCommon.OEFLAG_BACKSAVE);
						break;
					case 9:         // OBJ_CCA
						this.ocObject = new CDefCCA();
						this.ocObject.load(file);
						break;
				}
			}
		},
		enumElements: function (enumImages, enumFonts)
		{
			if (this.ocAnimations != null)
			{
				this.ocAnimations.enumElements(enumImages);
			}
			if (this.ocObject != null)
			{
				this.ocObject.enumElements(enumImages, enumFonts);
			}
			if (this.ocCounters != null)
			{
				this.ocCounters.enumElements(enumImages, enumFonts);
			}
		}
	}

	// CDefCCA object
	// ---------------------------------------------------------
	function CDefCCA()
	{
		this.odCx = 0;
		this.odCy = 0;
		this.odVersion = 0;
		this.odNStartFrame = 0;
		this.odOptions = 0;
		this.odName = null;
	}
	CDefCCA.prototype =
	{
		load:         function (file)
		{
			file.skipBytes(4);
			this.odCx = file.readAInt();
			this.odCy = file.readAInt();
			this.odVersion = file.readAShort();
			this.odNStartFrame = file.readAShort();
			this.odOptions = file.readAInt();
			file.skipBytes(4 + 4);                  // odFree+pad bytes
			this.odName = file.readAString();
		},
		enumElements: function (enumImages, enumFonts)
		{
		}
	}

	// CDefCounter object 
	// ----------------------------------------------------------
	function CDefCounter()
	{
		this.ctInit = 0;
		this.ctMini = 0;
		this.ctMaxi = 0;
	}
	CDefCounter.prototype =
	{
		load:         function (file)
		{
			file.skipBytes(2);
			this.ctInit = file.readAInt();
			this.ctMini = file.readAInt();
			this.ctMaxi = file.readAInt();
		},
		enumElements: function (enumImages, enumFonts)
		{
		}
	}

	// CDefCounters object
	// --------------------------------------------------------------
	CDefCounters.CTA_HIDDEN = 0;
	CDefCounters.CTA_DIGITS = 1;
	CDefCounters.CTA_VBAR = 2;
	CDefCounters.CTA_HBAR = 3;
	CDefCounters.CTA_ANIM = 4;
	CDefCounters.CTA_TEXT = 5;
	CDefCounters.BARFLAG_INVERSE = 0x0100;

	function CDefCounters()
	{
		this.odCx = 0;
		this.odCy = 0;
		this.odPlayer = 0;
		this.odDisplayType = 0;
		this.odDisplayFlags = 0;
		this.odFont = 0;
		this.ocBorderSize = 0;
		this.ocBorderColor = 0;
		this.ocShape = 0;
		this.ocFillType = 0;
		this.ocLineFlags = 0;
		this.ocColor1 = 0;
		this.ocColor2 = 0;
		this.ocGradientFlags = 0;
		this.nFrames = 0;
		this.frames = null;
	}
	CDefCounters.prototype =
	{
		load: function (file)
		{
			file.skipBytes(4);
			this.odCx = file.readAInt();
			this.odCy = file.readAInt();
			this.odPlayer = file.readAShort();
			this.odDisplayType = file.readAShort();
			this.odDisplayFlags = file.readAShort();
			this.odFont = file.readAShort();

			switch (this.odDisplayType)
			{
				case 0:
					break;
				case 1:
				case 4:
					this.nFrames = file.readAShort();
					this.frames = new Array(this.nFrames);
					var n;
					for (n = 0; n < this.nFrames; n++)
					{
						this.frames[n] = file.readAShort();
					}
					break;
				case 2:
				case 3:
				case 5:
					this.ocBorderSize = file.readAShort();
					this.ocBorderColor = file.readAColor();
					this.ocShape = file.readAShort();
					this.ocFillType = file.readAShort();
					if (this.ocShape == 1)
						this.ocLineFlags = file.readAShort();
					else
					{
						switch (this.ocFillType)
						{
							case 1:
								this.ocColor1 = file.readAColor();
								break;
							case 2:
								this.ocColor1 = file.readAColor();
								this.ocColor2 = file.readAColor();
								this.ocGradientFlags = file.readAInt();
								break;
							case 3:
								break;
						}
					}
					break;
			}
		},

		enumElements: function (enumImages, enumFonts)
		{
			var num;
			switch (this.odDisplayType)
			{
				case 1:
				case 4:
					var n;
					for (n = 0; n < this.nFrames; n++)
					{
						if (enumImages != null)
						{
							num = enumImages.enumerate(this.frames[n]);
							/*						if (num!=-1)
							 {
							 this.frames[n]=num;
							 }
							 */
						}
					}
					break;
				case 5:
					if (enumFonts != null)
					{
						num = enumFonts.enumerate(this.odFont);
						/*			    	if (num!=-1)
						 {
						 this.odFont=num;
						 }
						 */
					}
					break;
			}
		}
	}

	// CDefRtf object
	// ----------------------------------------------------------
	function CDefRtf()
	{
		this.odDWSize = 0;
		this.odVersion = 0;
		this.odOptions = 0;
		this.odBackColor = 0;
		this.odCx = 0;
		this.odCy = 0;
		this.text = null;
	}
	CDefRtf.prototype =
	{
		load:         function (file)
		{
			this.odDWSize = file.readAInt();
			this.odVersion = file.readAInt();
			this.odOptions = file.readAInt();
			this.odBackColor = file.readAColor();
			this.odCx = file.readAInt();
			this.odCy = file.readAInt();

			file.skipBytes(4);
			var size = file.readAInt();
			this.text = file.readAString(size);
		},
		enumElements: function (enumImages, enumFonts)
		{
		}
	}

	// CDefText object
	// -------------------------------------------------------------------
	CDefText.TSF_LEFT = 0x0000;
	CDefText.TSF_HCENTER = 0x0001;
	CDefText.TSF_RIGHT = 0x0002;
	CDefText.TSF_VCENTER = 0x0004;
	CDefText.TSF_HALIGN = 0x000F;
	CDefText.TSF_CORRECT = 0x0100;
	CDefText.TSF_RELIEF = 0x0200;
	function CDefText()
	{
		this.tsFont = 0;
		this.tsFlags = 0;
		this.tsColor = 0;
		this.tsText = null;
	}
	CDefText.prototype =
	{
		load:         function (file)
		{
			this.tsFont = file.readShort();
			this.tsFlags = file.readAShort();
			this.tsColor = file.readAColor();
			this.tsText = file.readAString();
		},
		enumElements: function (enumImages, enumFonts)
		{
			if (enumFonts != null)
			{
				var num = enumFonts.enumerate(this.tsFont);
				/*		    if (num!=-1)
				 {
				 this.tsFont=num;
				 }
				 */
			}
		}
	}

	// CDefTexts object
	// -------------------------------------------------------------------
	function CDefTexts()
	{
		this.otCx = 0;
		this.otCy = 0;
		this.otNumberOfText = 0;
		this.otTexts = null;
	}
	CDefTexts.prototype =
	{
		load:         function (file)
		{
			var debut = file.getFilePointer();
			file.skipBytes(4);          // Size
			this.otCx = file.readAInt();
			this.otCy = file.readAInt();
			this.otNumberOfText = file.readAInt();

			this.otTexts = new Array(this.otNumberOfText);
			var offsets = new Array(this.otNumberOfText);
			var n;
			for (n = 0; n < this.otNumberOfText; n++)
			{
				offsets[n] = file.readAInt();
			}
			for (n = 0; n < this.otNumberOfText; n++)
			{
				this.otTexts[n] = new CDefText();
				file.seek(debut + offsets[n]);
				this.otTexts[n].load(file);
			}
		},
		enumElements: function (enumImages, enumFonts)
		{
			var n;
			for (n = 0; n < this.otNumberOfText; n++)
			{
				this.otTexts[n].enumElements(enumImages, enumFonts);
			}
		}
	}

	// CObject
	// ----------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	CObject.HOF_DESTROYED = 0x0001;
	CObject.HOF_TRUEEVENT = 0x0002;
	CObject.HOF_REALSPRITE = 0x0004;
	CObject.HOF_FADEIN = 0x0008;
	CObject.HOF_FADEOUT = 0x0010;
	CObject.HOF_OWNERDRAW = 0x0020;
	CObject.HOF_NOCOLLISION = 0x2000;
	CObject.HOF_FLOAT = 0x4000;
	CObject.HOF_STRING = 0x8000;
	function CObject()
	{
		this.hoNumber = 0;
		this.hoNextSelected = 0;
		this.hoAdRunHeader = null;
		this.hoHFII = 0;
		this.hoOi = 0;
		this.hoNumPrev = 0;
		this.hoNumNext = 0;
		this.hoType = 0;
		this.hoCreationId = 0;
		this.hoOiList = null;
		this.hoEvents = 0;
		this.hoPrevNoRepeat = null;
		this.hoBaseNoRepeat = null;
		this.hoMark1 = 0;
		this.hoMark2 = 0;
		this.hoMT_NodeName = null;
		this.hoEventNumber = 0;
		this.hoCommon = null;
		this.hoCalculX = 0;
		this.hoX = 0;
		this.hoCalculY = 0;
		this.hoY = 0;
		this.hoImgXSpot = 0;
		this.hoImgYSpot = 0;
		this.hoImgWidth = 0;
		this.hoImgHeight = 0;
		this.hoOEFlags = 0;
		this.hoFlags = 0;
		this.hoSelectedInOR = 0;
		this.hoOffsetValue = 0;
		this.hoLayer = 0;
		this.hoLimitFlags = 0;
		this.hoNextQuickDisplay = 0;
		this.hoCurrentParam = 0;
		this.hoIdentifier = 0;
		this.hoCallRoutine = false;
		this.roc = null;
		this.rom = null;
		this.roa = null;
		this.rov = null;
		this.ros = null;
	}
	CObject.prototype =
	{
		setScale:  function (fScaleX, fScaleY)
		{
			if (this.roc.rcScaleX != fScaleX || this.roc.rcScaleY != fScaleY)
			{
				if (fScaleX >= 0)
				{
					this.roc.rcScaleX = fScaleX;
				}
				if (fScaleY >= 0)
				{
					this.roc.rcScaleY = fScaleY;
				}
				this.roc.rcChanged = true;

				var ifo = this.hoAdRunHeader.rhApp.imageBank.getImageInfoEx(this.roc.rcImage, this.roc.rcAngle, this.roc.rcScaleX, this.roc.rcScaleY);
				this.hoImgWidth = ifo.width;
				this.hoImgHeight = ifo.height;
				this.hoImgXSpot = ifo.xSpot;
				this.hoImgYSpot = ifo.ySpot;
			}
		},
		shtCreate: function (p, x, y, dir)
		{
			var nLayer = this.hoLayer;
			var num = this.hoAdRunHeader.f_CreateObject(p.cdpHFII, p.cdpOi, x, y, dir, CRun.COF_NOMOVEMENT | CRun.COF_HIDDEN, nLayer, -1);
			if (num >= 0)
			{
				var pHo = this.hoAdRunHeader.rhObjectList[num];
				if (pHo.rom != null)
				{
					pHo.roc.rcDir = dir;
					pHo.rom.initSimple(pHo, CMoveDef.MVTYPE_BULLET, false);
					pHo.roc.rcSpeed = p.shtSpeed;
					pHo.rom.rmMovement.init2(this);

					if (nLayer != -1)
					{
						if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_SPRITES) != 0)
						{
							var layer = this.hoAdRunHeader.rhFrame.layers[nLayer];
							if ((layer.dwOptions & (CLayer.FLOPT_TOHIDE | CLayer.FLOPT_VISIBLE)) != CLayer.FLOPT_VISIBLE)
							{
								pHo.ros.obHide();
							}
						}
					}

					// Met l'objet dans la liste des objets selectionnes
					// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
					this.hoAdRunHeader.rhEvtProg.evt_AddCurrentObject(pHo);

					// Force l'animation SHOOT si definie
					// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
					if ((this.hoOEFlags & CObjectCommon.OEFLAG_ANIMATIONS) != 0)
					{
						if (this.roa.anim_Exist(CAnim.ANIMID_SHOOT))
						{
							this.roa.animation_Force(CAnim.ANIMID_SHOOT);
							this.roa.animation_OneLoop();
						}
					}
				}
				else
				{
					this.hoAdRunHeader.destroy_Add(pHo.hoNumber);
				}
			}
		},

		fixedValue: function ()
		{
			return (this.hoCreationId << 16) | (this.hoNumber & 0xFFFF);
		},

		init: function (ocPtr, cob)
		{
		},

		handle: function ()
		{
		},

		callComputeNewDisplay: function ()
		{

		},

		createFont: function ()
		{
		},

		display: function ()
		{
		},


		kill: function (bFast)
		{
		},

		getSurface: function (context)
		{
			return false;
		},

		getCollisionMask: function (flags)
		{
			return null;
		},

		setEffect: function (effect, effectParam)
		{
		},

		addSprite: function (x, y, i, layer, bShow)
		{
		},

		addOwnerDrawSprite: function (x, y, layer, bQD, bShow, index)
		{
		},

		delSprite: function ()
		{
			return 0;
		},

		showSprite: function ()
		{
		},

		hideSprite: function ()
		{
		},

		setTransparency: function (t)
		{
		},

		getChildIndex: function ()
		{
			return -1;
		},

		getChildMaxIndex: function ()
		{
			return 0;
		},

		setChildIndex: function (index)
		{
		},

		autoResize: function ()
		{
		},

		forcePosition: function ()
		{
		}
	}

	// CActive class
	// ----------------------------------------------------------------
	function CActive()
	{
		this.smoothing = false;
		this.image = null;
		this.bShown = false;
		this.nLayer = 0;
		this.pLayer = null;
		this.startFade = 0;
		this.sprite = null;
		this.bHandCursor = false;
		this.rcRotate = null;
		this.ptRotate = null;
		this.bVisible = true;
		this.scaleX = 1.0;
		this.scaleY = 1.0;
		this.angle = 0;
		this.x = 0;
		this.y = 0;
		this.transitionImage = null;
	}
	CActive.prototype = CServices.extend(new CObject(),
		{
			handle:           function ()
			{
				this.ros.handle();
				if (this.roc.rcChanged)
				{
					this.roc.rcChanged = false;
				}
			},
			addSprite:        function (xx, yy, ii, layer, bShow)
			{
				this.nLayer = layer;
				this.pLayer = this.hoAdRunHeader.rhFrame.layers[layer];
				this.bShown = bShow;
				this.pLayer.planeSprites.addChild(this);
			},
			draw:             function (context, xx, yy)
			{
				if (this.bShown)
				{
					if ((this.hoFlags & CObject.HOF_FADEIN) != 0 && !this.ros.rsTrans)
					{
						return;
					}

					var effect = this.ros.rsEffect;
					if (this.ros.rsFlags & CRSpr.RSFLAG_ROTATE_ANTIA)
						effect |= CRSpr.BOP_SMOOTHING;
					var image = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(this.roc.rcImage);
					if (image)
					{
						if (!this.transitionImage)
						{
							context.renderImage(image, xx + this.hoX - this.hoAdRunHeader.rhWindowX + this.pLayer.x,
								yy + this.hoY - this.hoAdRunHeader.rhWindowY + this.pLayer.y,
								this.roc.rcAngle, this.roc.rcScaleX, this.roc.rcScaleY,
								effect, this.ros.rsEffectParam);
						}
						else
						{
							context.renderSimpleImage(this.transitionImage, xx + this.hoX - this.hoAdRunHeader.rhWindowX + this.pLayer.x - image.xSpot,
								yy + this.hoY - this.hoAdRunHeader.rhWindowY + this.pLayer.y - image.ySpot,
								this.transitionImage.width * this.roc.rcScaleX, this.transitionImage.height * this.roc.rcScaleY,
								effect, this.ros.rsEffectParam);
						}
					}
				}
			},
			delSprite:        function ()
			{
				return this.pLayer.planeSprites.removeChild(this);
			},
			showSprite:       function ()
			{
				this.bShown = true;
			},
			hideSprite:       function ()
			{
				this.bShown = false;
			},
			getChildIndex:    function ()
			{
				return this.pLayer.planeSprites.getChildIndex(this);
			},
			getChildMaxIndex: function ()
			{
				return this.pLayer.planeSprites.children.length;
			},
			setChildIndex:    function (index)
			{
				if (index >= this.pLayer.planeSprites.children.length)
				{
					index = this.pLayer.planeSprites.children.length;
				}
				if (index < 0)
				{
					index = 0;
				}
				this.pLayer.planeSprites.setChildIndex(this, index);
			},

			setTransparency: function (t)
			{
				this.ros.rsEffect = CRSpr.BOP_BLEND;
				this.ros.rsEffectParam = t;
			}


		});

	// Sub application object
	// ----------------------------------------------------------------
	CCCA.CCAF_SHARE_GLOBALVALUES = 0x00000001;
	CCCA.CCAF_SHARE_LIVES = 0x00000002;
	CCCA.CCAF_SHARE_SCORES = 0x00000004;
	CCCA.CCAF_SHARE_WINATTRIB = 0x00000008;
	CCCA.CCAF_STRETCH = 0x00000010;
	CCCA.CCAF_POPUP = 0x00000020;
	CCCA.CCAF_CAPTION = 0x00000040;
	CCCA.CCAF_TOOLCAPTION = 0x00000080;
	CCCA.CCAF_BORDER = 0x00000100;
	CCCA.CCAF_WINRESIZE = 0x00000200;
	CCCA.CCAF_SYSMENU = 0x00000400;
	CCCA.CCAF_DISABLECLOSE = 0x00000800;
	CCCA.CCAF_MODAL = 0x00001000;
	CCCA.CCAF_DIALOGFRAME = 0x00002000;
	CCCA.CCAF_INTERNAL = 0x00004000;
	CCCA.CCAF_HIDEONCLOSE = 0x00008000;
	CCCA.CCAF_CUSTOMSIZE = 0x00010000;
	CCCA.CCAF_INTERNALABOUTBOX = 0x00020000;
	CCCA.CCAF_CLIPSIBLINGS = 0x00040000;
	CCCA.CCAF_SHARE_PLAYERCTRLS = 0x00080000;
	CCCA.CCAF_MDICHILD = 0x00100000;
	CCCA.CCAF_DOCKED = 0x00200000;
	CCCA.CCAF_DOCKING_AREA = 0x00C00000;
	CCCA.CCAF_DOCKED_LEFT = 0x00000000;
	CCCA.CCAF_DOCKED_TOP = 0x00400000;
	CCCA.CCAF_DOCKED_RIGHT = 0x00800000;
	CCCA.CCAF_DOCKED_BOTTOM = 0x00C00000;
	CCCA.CCAF_REOPEN = 0x01000000;
	CCCA.CCAF_MDIRUNEVENIFNOTACTIVE = 0x02000000;

	function CCCA()
	{
		this.flags = 0;
		this.odOptions = 0;
		this.subApp = null;
		this.oldX = 0;
		this.oldY = 0;
		this.level = -1;
		this.oldLevel = -1;
		this.layer = null;
		this.bVisible = true;
	}
	CCCA.prototype = CServices.extend(new CObject(),
		{
			//    init:function(ocPtr, cob)
			startCCA: function (ocPtr, bInit, nStartFrame)
			{
				var defCCA = ocPtr.ocObject;

				this.hoImgWidth = defCCA.odCx;
				this.hoImgHeight = defCCA.odCy;
				this.odOptions = defCCA.odOptions;

				if ((this.odOptions & CCCA.CCAF_STRETCH) != 0)
				{
					this.odOptions |= CCCA.CCAF_CUSTOMSIZE;
				}

				if (nStartFrame == -1)
				{
					nStartFrame = 0;
					if ((this.odOptions & CCCA.CCAF_INTERNAL) != 0)
					{
						nStartFrame = defCCA.odNStartFrame;
					}
				}

				// Change l'extension
				if (defCCA.odName == null || defCCA.odName.length != 0)
					return;
				if ((this.odOptions & CCCA.CCAF_INTERNAL) == 0)
					return;
				if (nStartFrame >= this.hoAdRunHeader.rhApp.gaNbFrames)
					return;
				if (nStartFrame == this.hoAdRunHeader.rhApp.currentFrame)
					return;

				if ((ocPtr.ocFlags2 & CObjectCommon.OCFLAGS2_VISIBLEATSTART) != 0)
					this.bVisible = true;
				else
					this.bVisible = false;
				this.appSprite = new Sprite();
				this.appSprite.x = this.hoX - this.hoAdRunHeader.rhWindowX;
				this.appSprite.y = this.hoY - this.hoAdRunHeader.rhWindowY;
				this.hoAdRunHeader.rhApp.mainSprite.addChild(this);
				this.oldX = this.hoX;
				this.oldY = this.hoY;

				this.subApp = new CRunApp(this.hoAdRunHeader.rhApp, this.hoAdRunHeader.rhApp.file, this.hoAdRunHeader.rhApp.path, true);
				this.subApp.setParentApp(this.hoAdRunHeader.rhApp, nStartFrame, this.odOptions, this.appSprite, this.hoImgWidth, this.hoImgHeight);

				this.subApp.digest();
				this.subApp.startApplication();
				this.subApp.setMouseOffsets((this.hoAdRunHeader.rhApp.xMouseOffset + this.appSprite.x) * this.hoAdRunHeader.rhApp.scaleX,
					(this.hoAdRunHeader.rhApp.yMouseOffset + this.appSprite.y) * this.hoAdRunHeader.rhApp.scaleY);
				this.subApp.stepApplication();
				this.hoAdRunHeader.rhApp.subApps.push(this.subApp);
			},

			init: function (ocPtr, cob)
			{
				this.startCCA(ocPtr, true, -1);
			},

			handle: function ()
			{
				this.rom.move();
				if (this.subApp != null)
				{
					if (this.oldX != this.hoX || this.oldY != this.hoY)
					{
						this.appSprite.x = this.hoX - this.hoAdRunHeader.rhWindowX;
						this.appSprite.y = this.hoY - this.hoAdRunHeader.rhWindowY;
						this.oldX = this.hoX;
						this.oldY = this.hoY;
						this.subApp.setMouseOffsets(this.appSprite.x * this.hoAdRunHeader.rhApp.scaleX, this.appSprite.y * this.hoAdRunHeader.rhApp.scaleY);
						this.updateChildControlPos();
					}
					if (this.subApp.stepApplication() == false)
					{
						this.destroyObject();
						this.subApp = null;
						return;
					}
					this.oldLevel = this.level;
					this.level = this.subApp.currentFrame;
				}
			},

			draw: function (context, xx, yy)
			{
				if (!this.bVisible) return;
				if (this.subApp != null)
				{
					this.subApp.drawSubApplication(context, this.appSprite.x, this.appSprite.y);
				}
			},

			kill: function (bFast)
			{
				if (this.subApp != null)
				{
					switch (this.subApp.appRunningState)
					{
						case 3:	    // SL_FRAMELOOP:
							this.subApp.endFrame();
							break;
					}
					this.destroyObject();
					this.subApp.endApplication();
					this.subApp = null;
				}
			},

			destroyObject: function ()
			{
				var n;
				for (n = 0; n < this.hoAdRunHeader.rhApp.subApps.length; n++)
				{
					if (this.hoAdRunHeader.rhApp.subApps[n] == this.subApp)
					{
						this.hoAdRunHeader.rhApp.subApps.splice(n, 1);
						break;
					}
				}
				this.hoAdRunHeader.rhApp.mainSprite.removeChild(this.appSprite);
			},

			restartApp: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						this.subApp.run.rhQuit = CRun.LOOPEXIT_NEWGAME;
						return;
					}
					this.kill(true);
				}
				this.startCCA(this.hoCommon, false, -1);
			},

			endApp: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						this.subApp.run.rhQuit = CRun.LOOPEXIT_ENDGAME;
					}
				}
			},

			hide: function ()
			{
				this.bVisible = false;
			},

			show: function ()
			{
				this.bVisible = true;
			},

			jumpFrame: function (frame)
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						if (frame >= 0 && frame < 4096)
						{
							this.subApp.run.rhQuit = CRun.LOOPEXIT_GOTOLEVEL;
							this.subApp.run.rhQuitParam = 0x8000 | frame;
						}
					}
				}
			},

			nextFrame: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						this.subApp.run.rhQuit = CRun.LOOPEXIT_NEXTLEVEL;
					}
				}
			},

			previousFrame: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						this.subApp.run.rhQuit = CRun.LOOPEXIT_PREVLEVEL;
					}
				}
			},

			restartFrame: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						this.subApp.run.rhQuit = CRun.LOOPEXIT_RESTART;
					}
				}
			},

			pause: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						this.subApp.run.pause();
					}
				}
			},

			resume: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						this.subApp.run.resume();
					}
				}
			},

			setGlobalValue: function (number, value)
			{
				if (this.subApp != null)
				{
					this.subApp.setGlobalValueAt(number, value);
				}
			},

			setGlobalString: function (number, value)
			{
				if (this.subApp != null)
				{
					this.subApp.setGlobalStringAt(number, value);
				}
			},

			isPaused: function ()
			{
				if (this.subApp != null)
				{
					if (this.subApp.run != null)
					{
						return this.subApp.run.rh2PauseCompteur != 0;
					}
				}
				return false;
			},

			appFinished: function ()
			{
				return this.subApp == null;
			},

			isVisible: function ()
			{
				return this.bVisible;
			},

			frameChanged: function ()
			{
				return this.level != this.oldLevel;
			},

			getGlobalString: function (num)
			{
				if (this.subApp != null)
				{
					return this.subApp.getGlobalStringAt(num);
				}
				return "";
			},

			getGlobalValue: function (num)
			{
				if (this.subApp != null)
				{
					return this.subApp.getGlobalValueAt(num);
				}
				return 0;
			},

			getFrameNumber: function ()
			{
				return this.level + 1;
			},

			setWidth: function (width)
			{
			},

			setHeight: function (height)
			{
			},

			bringToFront: function ()
			{
				if (this.subApp != null)
				{
					if (this.bVisible)
					{
						hoAdRunHeader.rhApp.planeControls.removeChild(this);
						hoAdRunHeader.rhApp.planeControls.addChild(this);
					}
				}
			},

			updateChildControlPos: function () {
			    if (this.subApp != null && this.subApp.run != null) {
			        var rh = this.subApp.run;
			        var count = 0;
			        var no;
			        for (no = 0; no < rh.rhNObjects; no++) {
			            while (rh.rhObjectList[count] == null)
			                count++;
			            var hoPtr = rh.rhObjectList[count];
			            count++;
			            hoPtr.forcePosition();
			        }
			    }
			},

			autoResize: function () {
			    this.subApp.setMouseOffsets((this.hoAdRunHeader.rhApp.xMouseOffset + this.appSprite.x) * this.hoAdRunHeader.rhApp.scaleX,
					(this.hoAdRunHeader.rhApp.yMouseOffset + this.appSprite.y) * this.hoAdRunHeader.rhApp.scaleY);
			    if (this.subApp != null)
			        this.subApp.resizeCanvas();
			}

		});

	// CRCom object
	// --------------------------------------------------------------------
	function CRCom()
	{
		this.rcPlayer = 0;
		this.rcMovementType = 0;
		this.rcAnim = 0;
		this.rcImage = -1;
		this.rcScaleX = 1.0;
		this.rcScaleY = 1.0;
		this.rcAngle = 0;
		this.rcDir = 0;
		this.rcSpeed = 0;
		this.rcMinSpeed = 0;
		this.rcMaxSpeed = 0;
		this.rcChanged = false;
		this.rcCheckCollides = false;

		this.rcOldX = 0;
		this.rcOldY = 0;
		this.rcOldImage = -1;
		this.rcOldAngle = 0;
		this.rcOldDir = 0;
		this.rcOldX1 = 0;
		this.rcOldY1 = 0;
		this.rcOldX2 = 0;
		this.rcOldY2 = 0;
	}
	CRCom.prototype =
	{
		init: function ()
		{
		    this.rcScaleX = 1.0;
		    this.rcScaleY = 1.0;
		    this.rcAngle = 0;
		    this.rcMovementType = -1;
		},
		kill: function (bFast)
		{
		}
	}

	// CCounter object
	// ---------------------------------------------------------------
	CCounter.CPTDISPFLAG_INTNDIGITS = 0x000F;
	CCounter.CPTDISPFLAG_FLOATNDIGITS = 0x00F0;
	CCounter.CPTDISPFLAG_FLOATNDIGITS_SHIFT = 4
	CCounter.CPTDISPFLAG_FLOATNDECIMALS = 0xF000;
	CCounter.CPTDISPFLAG_FLOATNDECIMALS_SHIFT = 12;
	CCounter.CPTDISPFLAG_FLOAT_FORMAT = 0x0200;
	CCounter.CPTDISPFLAG_FLOAT_USENDECIMALS = 0x0400;
	CCounter.CPTDISPFLAG_FLOAT_PADD = 0x0800;
	function CCounter()
	{
		this.type = 0;
		this.rsValue = 0;
		this.rsMini = 0;
		this.rsMaxi = 0;
		this.rsBoxCx = 0;
		this.rsBoxCy = 0;
		this.bShown = false;
		this.bQuickDisplay = false;
		this.rsColor1 = 0;
		this.rsColor2 = 0
		this.rsOldFrame = 0;
		this.nIndex = 0;
		this.displayFlags = 0;
		this.bDeleted = false;
		this.bFloat = false;
		this.plane = null;
		this.pLayer = null;
		this.fontHeight = 0;
		this.font = null;
		this.bAddedToPlane = false;
		this.computed = false;
	}

	CCounter.prototype = CServices.extend(new CObject(),
		{
			init: function (ocPtr, cob)
			{
				this.rsFont = -1;
				this.rsColor1 = 0;
				this.rsColor2 = 0;
				this.hoImgWidth = this.hoImgHeight = 1;

				if (this.hoCommon.ocCounters == null)
				{
					this.hoImgWidth = this.rsBoxCx = 1;
					this.hoImgHeight = this.rsBoxCy = 1;
				}
				else
				{
					var ctPtr = this.hoCommon.ocCounters;
					this.hoImgWidth = this.rsBoxCx = ctPtr.odCx;
					this.hoImgHeight = this.rsBoxCy = ctPtr.odCy;
					this.displayFlags = ctPtr.odDisplayFlags;
					this.type = ctPtr.odDisplayType;
					switch (this.type)
					{
						case 5:
							var nFont = this.rsFont;
							if (nFont == -1)
								nFont = ctPtr.odFont;
							this.font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(nFont);
							this.fontHeight = this.font.getHeight();
							this.rsColor1 = ctPtr.ocColor1;
							break;
						case 2:
						case 3:
							this.rsColor1 = ctPtr.ocColor1;
							this.rsColor2 = ctPtr.ocColor2;
							break;
						case 1:
							break;
						case 4:
							break;
					}
				}

				var cPtr = this.hoCommon.ocObject;
				this.rsMini = cPtr.ctMini;
				this.rsMaxi = cPtr.ctMaxi;
				this.rsValue = cPtr.ctInit;
				this.bFloat = false;
			},

			kill: function ()
			{
			},

			handle: function ()
			{
				this.ros.handle();
				if (this.roc.rcChanged)
				{
					this.roc.rcChanged = false;
				}
			},

			getFont: function ()
			{
				var adCta = this.hoCommon.ocCounters;
				if (this.type == 5)
				{
					var nFont = rsFont;
					if (nFont == -1)
						nFont = adCta.odFont;
					return this.hoAdRunHeader.rhApp.fontBank.getFontInfoFromHandle(nFont);
				}
				return null;
			},

			setFont: function (font, size)
			{
				if (this.type == 5)
				{
					this.rsFont = this.hoAdRunHeader.rhApp.fontBank.addFont(font);
					this.font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(this.rsFont);
					this.fontHeight = this.font.getHeight();
					if (size != null)
					{
						this.hoImgWidth = this.rsBoxCx = size.right - size.left;
						this.hoImgHeight = this.rsBoxCy = size.bottom - size.top;
					}
					this.computeNewDisplay();
				}
			},

			getFontColor: function ()
			{
				return this.rsColor1;
			},

			setFontColor: function (rgb)
			{
				this.rsColor1 = rgb;
				this.computeNewDisplay();
			},

			cpt_ToFloat: function (pValue)
			{
				if (this.bFloat == false)
				{
					if (CServices.isInt(pValue))
						return;
					this.bFloat = true;
				}
			},

			cpt_Change: function (pValue)
			{
				if (this.bFloat == false)
				{
					var value = CServices.floatToInt(pValue);
					if (value < this.rsMini)
						value = this.rsMini;
					if (value > this.rsMaxi)
						value = this.rsMaxi;
					if (value != Math.round(this.rsValue))
					{
						this.rsValue = value;
						this.roc.rcChanged = true;
						this.computeNewDisplay();
					}
				}
				else
				{
					if (pValue < this.rsMini)
						pValue = this.rsMini;
					if (pValue > this.rsMaxi)
						pValue = this.rsMaxi;
					if (pValue != this.rsValue)
					{
						this.rsValue = pValue;
						this.roc.rcChanged = true;
						this.computeNewDisplay();
					}
				}
			},

			cpt_Add: function (pValue)
			{
				this.cpt_ToFloat(pValue);
				this.cpt_Change(this.rsValue + pValue);
			},

			cpt_Sub: function (pValue)
			{
				this.cpt_ToFloat(pValue);
				this.cpt_Change(this.rsValue - pValue);
			},

			cpt_SetMin: function (value)
			{
				this.rsMini = value;
				this.cpt_Change(this.rsValue);
			},

			cpt_SetMax: function (value)
			{
				this.rsMaxi = value;
				this.cpt_Change(this.rsValue);
			},

			cpt_SetColor1: function (rgb)
			{
				this.rsColor1 = rgb;
				this.computeNewDisplay();
			},

			cpt_SetColor2: function (rgb)
			{
				this.rsColor2 = rgb;
				this.computeNewDisplay();
			},

			cpt_GetValue: function ()
			{
				return this.rsValue;
			},

			cpt_GetMin: function ()
			{
				return this.rsMini;
			},

			cpt_GetMax: function ()
			{
				return this.rsMaxi;
			},

			cpt_GetColor1: function ()
			{
				return this.rsColor1;
			},

			cpt_GetColor2: function ()
			{
				return this.rsColor2;
			},

			addOwnerDrawSprite: function (xx, yy, layer, quickDisplay, shown, index)
			{
				if (this.hoCommon.ocCounters == null)
					return;
				if (this.bAddedToPlane == true)
					return;

				this.bAddedToPlane = true;
				this.bQuickDisplay = quickDisplay;
				this.bShown = shown;

				this.pLayer = this.hoAdRunHeader.rhFrame.layers[layer];
				if (this.bQuickDisplay)
					this.plane = this.pLayer.planeQuickDisplay;
				else
					this.plane = this.pLayer.planeSprites;

				if (index < 0)
					this.plane.addChild(this);
				else
					this.plane.addChildIndex(this, index);

				if (this.type != 5)
					this.computeNewDisplay();
			},

			delSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return -1;
				if (this.bAddedToPlane == false)
					return -1;

				this.bAddedToPlane = false;
				var index = this.plane.getChildIndex(this);
				this.plane.removeChild(this);
				return index;
			},

			getChildIndex: function ()
			{
				if (this.bAddedToPlane)
				{
					return this.plane.getChildIndex(this);
				}
				return -1;
			},

			getChildMaxIndex: function ()
			{
				if (this.bAddedToPlane)
					return this.plane.getNumChildren();
				return -1;
			},

			setChildIndex: function (index)
			{
				if (this.bAddedToPlane)
					this.plane.setChildIndex(this, index);
			},

			showSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return;

				if (this.bShown == false)
				{
					this.bShown = true;
					this.computeNewDisplay();
				}
			},

			hideSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return;

				if (this.bShown == true)
				{
					this.bShown = false;
				}
			},

			callComputeNewDisplay: function ()
			{
				if (!this.computed)
					this.computeNewDisplay();
			},

			computeNewDisplay: function ()
			{
				var image;
				var s;
				var nbl;

				var adCta = this.hoCommon.ocCounters;
				switch (this.type)
				{
					case 4:
						if (this.rsMaxi <= this.rsMini)
							this.rsOldFrame = 0;
						else
							this.rsOldFrame = Math.floor(((this.rsValue - this.rsMini) * adCta.nFrames) / (this.rsMaxi - this.rsMini));
						this.rsOldFrame = Math.min(this.rsOldFrame, adCta.nFrames - 1);
						image = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(adCta.frames[Math.max(this.rsOldFrame, 0)]);
						this.hoImgWidth = image.width;
						this.hoImgHeight = image.height;
						this.hoImgXSpot = image.xSpot;
						this.hoImgYSpot = image.ySpot;
						break;
					case 2:
					case 3:
						nbl = this.rsBoxCx;
						if (adCta.odDisplayType == CDefCounters.CTA_VBAR)
							nbl = this.rsBoxCy;
						if (this.rsMaxi <= this.rsMini)
							this.rsOldFrame = 0;
						else
							this.rsOldFrame = (((this.rsValue - this.rsMini) * nbl) / (this.rsMaxi - this.rsMini));
						if (adCta.odDisplayType == CDefCounters.CTA_HBAR)
						{
							this.hoImgYSpot = 0;
							this.hoImgHeight = this.rsBoxCy;
							this.hoImgWidth = this.rsOldFrame;
							if ((adCta.odDisplayFlags & CDefCounters.BARFLAG_INVERSE) != 0)
								this.hoImgXSpot = this.rsOldFrame - this.rsBoxCx;
							else
								this.hoImgXSpot = 0;
						}
						else
						{
							this.hoImgXSpot = 0;
							this.hoImgWidth = this.rsBoxCx;
							this.hoImgHeight = this.rsOldFrame;
							if ((adCta.odDisplayFlags & CDefCounters.BARFLAG_INVERSE) != 0)
								this.hoImgYSpot = this.rsOldFrame - this.rsBoxCy;
							else
								this.hoImgYSpot = 0;
						}
						break;
					case 1:
						if (this.bFloat == false)
							s = CServices.intToString(this.rsValue, this.displayFlags);
						else
							s = CServices.doubleToString(this.rsValue, this.displayFlags);
						var i;
						var c;
						var img;
						var ifo;
						var dx = 0, dy = 0;

						for (i = s.length - 1; i >= 0; i--)
						{
							c = s.charCodeAt(i);
							img = 0;
							if (c == 45)
								img = adCta.frames[10];
							else if (c == 46)
								img = adCta.frames[12];
							else if (c == 43)
								img = adCta.frames[11];
							else if (c == 101 || c == 69)
								img = adCta.frames[13];
							else if (c >= 48 && c <= 57)
								img = adCta.frames[c - 48];
							if (img >= 0)
							{
								ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(img);
								if (ifo != null)
								{
									dx += ifo.width;
									dy = Math.max(dy, ifo.height);
								}
								else
								{
									toto = 2;
								}
							}
						}
						this.hoImgXSpot = dx;
						this.hoImgYSpot = dy;
						this.hoImgWidth = dx;
						this.hoImgHeight = dy;
						break;
					case 5:
						if (this.bFloat == false)
							s = CServices.intToString(this.rsValue, this.displayFlags);
						else
							s = CServices.doubleToString(this.rsValue, this.displayFlags);
						var w;
						if (this.textSurface != null)
							w = this.textSurface.measureText(s, this.font);
						else
						{
							var ts = new CTextSurface(this.hoAdRunHeader.rhApp, 16, 16);
							w = ts.measureText(s, this.font);
						}
						this.hoImgXSpot = w;
						this.hoImgYSpot = this.rsBoxCy / 2 + this.fontHeight / 2;
						this.hoImgWidth = w;
						this.hoImgHeight = this.fontHeight;
						if (this.textSurface == null)
							this.textSurface = new CTextSurface(this.hoAdRunHeader.rhApp, this.hoImgWidth, this.hoImgHeight);
						else
						{
							if (this.hoImgWidth > this.textSurface.width || this.hoImgHeight > this.textSurface.height)
								this.textSurface.resize(this.hoImgWidth, this.hoImgHeight);
						}
						var rect = new CRect(0, 0, 1000, 1000);
						this.textSurface.setText(s, CServices.DT_LEFT | CServices.DT_TOP, rect, this.font, this.rsColor1);
						break;
				}
				this.computed = true;
			},

			draw:            function (context, xx, yy)
			{
				if (!this.bShown || !this.computed) return;


				var image;
				var color1, color2;
				var s;

				var adCta = this.hoCommon.ocCounters;
				var x = xx + this.hoX - this.hoImgXSpot - this.hoAdRunHeader.rhWindowX + this.pLayer.x;
				var y = yy + this.hoY - this.hoImgYSpot - this.hoAdRunHeader.rhWindowY + this.pLayer.y;
				var cx = this.hoImgWidth;
				var cy = this.hoImgHeight;
				switch (this.type)
				{
					case 4:
						image = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(adCta.frames[Math.max(this.rsOldFrame, 0)]);
						context.renderImage(image, x + image.xSpot, y + image.ySpot, 0, 1.0, 1.0, this.ros.rsEffect, this.ros.rsEffectParam);
						break;
					case 2:
					case 3:
						var color1 = this.rsColor1;
						var color2 = this.rsColor2;
						switch (adCta.ocFillType)
						{
							case 1:
								context.renderSolidColor(x, y, cx, cy, color1, this.ros.rsEffect, this.ros.rsEffectParam);
								break;
							case 2:
								if ((adCta.odDisplayFlags & CDefCounters.BARFLAG_INVERSE) != 0)
								{
									dl = color1;
									color1 = color2;
									color2 = dl;
								}
								var bVertical = adCta.ocGradientFlags != 0;
								context.renderGradient(x, y, cx, cy, color1, color2, bVertical, this.ros.rsEffect, this.ros.rsEffectParam);
								break;
						}
						break;
					case 1:
						if (this.bFloat == false)
							s = CServices.intToString(this.rsValue, this.displayFlags);
						else
							s = CServices.doubleToString(this.rsValue, this.displayFlags);
						var i, img, ifo;
						for (i = 0; i < s.length; i++)
						{
							var c = s.charCodeAt(i);
							img = 0;
							if (c == 45)
								img = adCta.frames[10];
							else if (c == 46 || c == 44)
								img = adCta.frames[12];
							else if (c == 43)
								img = adCta.frames[11];
							else if (c == 69 || c == 101)
								img = adCta.frames[13];
							else if (c >= 48 && c <= 57)
								img = adCta.frames[c - 48];
							ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(img);
							if (ifo != null)
							{
								context.renderImage(ifo, x + ifo.xSpot, y + ifo.ySpot, 0, 1.0, 1.0, this.ros.rsEffect, this.ros.rsEffectParam);
								x += ifo.width;
							}
						}
						break;
					case 5:
						this.textSurface.draw(context, x, y, this.ros.rsEffect, this.ros.rsEffectParam);
						break;
				}
			},
			setTransparency: function (t)
			{
				this.ros.rsEffect = CRSpr.BOP_BLEND;
				this.ros.rsEffectParam = t;
			}
		});

	// CScore object
	// ------------------------------------------------------------
	function CScore()
	{
		this.rsPlayer = 0;
		this.rsValue = 0;
		this.rsBoxCx = 0;
		this.rsBoxCy = 0;
		this.rsFont = 0;
		this.rsColor1 = 0;
		this.type = 0;
		this.bShown = true;
		this.nLayer = 0;
		this.nIndex = 0;
		this.plane = null;
		this.displayFlags = 0;
		this.pLayer = null;
		this.bAddedToFrame = false;
		this.fontHeight = 0;
		this.alpha = 1.0;
		this.composite = "source-over";
		this.computed = false;
	}

	CScore.prototype = CServices.extend(new CObject(),
		{
			init: function (ocPtr, cob)
			{
				this.rsFont = -1;
				this.rsColor1 = 0;
				this.hoImgWidth = this.hoImgHeight = 1;

				var adCta = this.hoCommon.ocCounters;
				this.hoImgWidth = this.rsBoxCx = adCta.odCx;
				this.hoImgHeight = this.rsBoxCy = adCta.odCy;
				this.type = adCta.odDisplayType;
				this.rsColor1 = adCta.ocColor1;
				this.rsPlayer = adCta.odPlayer;
				this.rsValue = this.hoAdRunHeader.rhApp.getScores()[this.rsPlayer - 1];
				this.displayFlags = adCta.odDisplayFlags;

				if (this.type == 5)
				{
					var nFont = this.rsFont;
					if (nFont == -1)
						nFont = adCta.odFont;
					this.font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(nFont);
					this.fontHeight = this.font.getHeight();
				}
			},

			kill: function ()
			{
			},

			handle: function ()
			{
				var value = this.hoAdRunHeader.rhApp.getScores()[this.rsPlayer - 1];
				if (value != this.rsValue)
				{
					this.rsValue = value;
					this.computeNewDisplay();
				}
				this.ros.handle();
				if (this.roc.rcChanged)
				{
					this.roc.rcChanged = false;
				}
			},

			getFont: function ()
			{
				var adCta = this.hoCommon.ocCounters;
				if (adCta.odDisplayType == 5)
				{
					var nFont = this.rsFont;
					if (nFont == -1)
						nFont = adCta.odFont;
					return this.hoAdRunHeader.rhApp.fontBank.getFontInfoFromHandle(nFont);
				}
				return null;
			},

			setFont: function (font, size)
			{
				if (type == 5)
				{
					this.rsFont = hoAdRunHeader.rhApp.fontBank.addFont(font);
					var font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(this.rsFont);
					this.fontHeight = font.getHeight();
					if (size != null)
					{
						this.hoImgWidth = this.rsBoxCx = size.right - size.left;
						this.hoImgHeight = this.rsBoxCy = size.bottom - size.top;
					}
					this.computeNewDisplay();
				}
			},

			getFontColor: function ()
			{
				return this.rsColor1;
			},

			setFontColor: function (rgb)
			{
				this.rsColor1 = rgb;
				this.computeNewDisplay();
			},

			addOwnerDrawSprite: function (xx, yy, layer, quickDisplay, shown, index)
			{
				if (this.hoCommon.ocCounters == null)
					return;
				if (this.bAddedToPlane == true)
					return;

				this.bAddedToPlane = true;
				this.bShown = shown;

				this.pLayer = this.hoAdRunHeader.rhFrame.layers[layer];
				if (quickDisplay)
					this.plane = this.pLayer.planeQuickDisplay;
				else
					this.plane = this.pLayer.planeSprites;

				if (index < 0)
					this.plane.addChild(this);
				else
					this.plane.addChildIndex(this, index);

				if (this.type != 5)
					this.computeNewDisplay();
			},

			delSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return -1;
				if (this.bAddedToPlane == false)
					return -1;

				this.bAddedToPlane = false;
				var index = this.plane.getChildIndex(this);
				this.plane.removeChild(this);
				return index;
			},

			getChildIndex: function ()
			{
				if (this.bAddedToPlane)
				{
					return this.plane.getChildIndex(this);
				}
				return -1;
			},

			getChildMaxIndex: function ()
			{
				if (this.bAddedToPlane)
					return this.plane.getNumChildren();
				return -1;
			},

			setChildIndex: function (index)
			{
				if (this.bAddedToPlane)
					this.plane.setChildIndex(this, index);
			},

			showSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return;

				if (this.bShown == false)
				{
					this.bShown = true;
					this.computeNewDisplay();
				}
			},

			hideSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return;

				if (this.bShown == true)
				{
					this.bShown = false;
				}
			},

			setValue: function (value)
			{
				if (value != this.rsValue)
				{
					this.rsValue = value;
					this.computeNewDisplay();
				}
			},

			callComputeNewDisplay: function ()
			{
				if (!this.computed)
					this.computeNewDisplay();
			},

			computeNewDisplay: function ()
			{
				this.computed = true;
				this.hoImgWidth = this.hoImgHeight = 1;
				if (this.hoCommon.ocCounters == null)
					return;
				var adCta = this.hoCommon.ocCounters;

				var img;
				var s = CServices.intToString(this.rsValue, this.displayFlags);
				switch (adCta.odDisplayType)
				{
					case 1:
						var i;
						var c;
						var img;
						var ifo;
						var dx = 0, dy = 0;

						for (i = s.length - 1; i >= 0; i--)
						{
							c = s.charCodeAt(i);
							img = 0;
							if (c == 45)
								img = adCta.frames[10];
							else if (c == 46)
								img = adCta.frames[12];
							else if (c == 43)
								img = adCta.frames[11];
							else if (c == 101 || c == 69)
								img = adCta.frames[13];
							else if (c >= 48 && c <= 57)
								img = adCta.frames[c - 48];
							if (img >= 0)
							{
								ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(img);
								dx += ifo.width;
								dy = Math.max(dy, ifo.height);
							}
						}
						this.hoImgXSpot = dx;
						this.hoImgYSpot = dy;
						this.hoImgWidth = dx;
						this.hoImgHeight = dy;
						break;

					case 5:
						var w;
						if (this.textSurface != null)
							w = this.textSurface.measureText(s, this.font);
						else
						{
							var ts = new CTextSurface(this.hoAdRunHeader.rhApp, 8, 8);
							w = ts.measureText(s, this.font);
						}
						this.hoImgXSpot = w;
						this.hoImgYSpot = this.rsBoxCy / 2 + this.fontHeight / 2;
						this.hoImgWidth = w;
						this.hoImgHeight = this.fontHeight;
						if (this.textSurface == null)
							this.textSurface = new CTextSurface(this.hoAdRunHeader.rhApp, this.hoImgWidth, this.hoImgHeight);
						else
						{
							if (this.hoImgWidth > this.textSurface.width || this.hoImgHeight > this.textSurface.height)
								this.textSurface.resize(this.hoImgWidth, this.hoImgHeight);
						}
						var rect = new CRect(0, 0, 1000, 1000);
						this.textSurface.setText(s, CServices.DT_LEFT | CServices.DT_TOP, rect, this.font, this.rsColor1);
						break;
				}
			},

			draw:            function (context, xx, yy)
			{
				if (!this.bShown || !this.computed) return;

				this.globalAlpha = this.alpha;
				this.globalCompositeOperation = this.composite;

				var image;
				var color1, color2;
				var s;

				var adCta = this.hoCommon.ocCounters;
				var x = xx + this.hoX - this.hoImgXSpot - this.hoAdRunHeader.rhWindowX + this.pLayer.x;
				var y = yy + this.hoY - this.hoImgYSpot - this.hoAdRunHeader.rhWindowY + this.pLayer.y;
				s = CServices.intToString(this.rsValue, this.displayFlags);
				switch (this.type)
				{
					case 1:
						var i, img, ifo;
						for (i = 0; i < s.length; i++)
						{
							var c = s.charCodeAt(i);
							img = 0;
							if (c == 45)
								img = adCta.frames[10];
							else if (c == 46 || c == 44)
								img = adCta.frames[12];
							else if (c == 43)
								img = adCta.frames[11];
							else if (c == 69 || c == 101)
								img = adCta.frames[13];
							else if (c >= 48 && c <= 57)
								img = adCta.frames[c - 48];
							ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(img);
							context.renderImage(ifo, x + ifo.xSpot, y + ifo.ySpot, 0, 1.0, 1.0, this.ros.rsEffect, this.ros.rsEffectParam);
							x += ifo.width;
						}
						break;
					case 5:
						this.textSurface.draw(context, x, y, this.ros.rsEffect, this.ros.rsEffectParam);
						break;
				}
			},
			setTransparency: function (t)
			{
				this.ros.rsEffect = CRSpr.BOP_BLEND;
				this.ros.rsEffectParam = t;
			}
		});

	// CLives object
	// ------------------------------------------------------------
	function CLives()
	{
		this.rsPlayer = 0;
		this.rsValue = 0;
		this.rsBoxCx = 0;
		this.rsBoxCy = 0;
		this.rsFont = 0;
		this.rsColor1 = 0;
		this.type = 0;
		this.bShown = true;
		this.nLayer = 0;
		this.nIndex = 0;
		this.plane = null;
		this.displayFlags = 0;
		this.pLayer = null;
		this.bAddedToFrame = false;
		this.fontHeight = 0;
		this.alpha = 1.0;
		this.composite = "source-over";
		this.computed = false;
	}

	CLives.prototype = CServices.extend(new CObject(),
		{
			init: function (ocPtr, cob)
			{
				this.rsFont = -1;
				this.rsColor1 = 0;
				this.hoImgWidth = this.hoImgHeight = 1;

				var adCta = this.hoCommon.ocCounters;
				this.hoImgWidth = this.rsBoxCx = adCta.odCx;
				this.hoImgHeight = this.rsBoxCy = adCta.odCy;
				this.type = adCta.odDisplayType;
				this.rsColor1 = adCta.ocColor1;
				this.rsPlayer = adCta.odPlayer;
				this.rsValue = this.hoAdRunHeader.rhApp.getLives()[this.rsPlayer - 1];
				this.displayFlags = adCta.odDisplayFlags;

				if (this.type == 5)
				{
					var nFont = this.rsFont;
					if (nFont == -1)
						nFont = adCta.odFont;
					this.font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(nFont);
					this.fontHeight = this.font.getHeight();
				}
			},

			kill: function ()
			{
			},

			handle: function ()
			{
				var value = this.hoAdRunHeader.rhApp.getLives()[this.rsPlayer - 1];
				if (value != this.rsValue)
				{
					this.rsValue = value;
					this.computeNewDisplay();
				}
				this.ros.handle();
				if (this.roc.rcChanged)
				{
					this.roc.rcChanged = false;
				}
			},

			getFont: function ()
			{
				var adCta = this.hoCommon.ocCounters;
				if (adCta.odDisplayType == 5)
				{
					var nFont = this.rsFont;
					if (nFont == -1)
						nFont = adCta.odFont;
					return this.hoAdRunHeader.rhApp.fontBank.getFontInfoFromHandle(nFont);
				}
				return null;
			},

			setFont: function (font, size)
			{
				if (type == 5)
				{
					this.rsFont = hoAdRunHeader.rhApp.fontBank.addFont(font);
					var font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(this.rsFont);
					this.fontHeight = font.getHeight();
					if (size != null)
					{
						this.hoImgWidth = this.rsBoxCx = size.right - size.left;
						this.hoImgHeight = this.rsBoxCy = size.bottom - size.top;
					}
					this.computeNewDisplay();
				}
			},

			getFontColor: function ()
			{
				return this.rsColor1;
			},

			setFontColor: function (rgb)
			{
				this.rsColor1 = rgb;
				this.computeNewDisplay();
			},

			addOwnerDrawSprite: function (xx, yy, layer, quickDisplay, shown, index)
			{
				if (this.hoCommon.ocCounters == null)
					return;
				if (this.bAddedToPlane == true)
					return;

				this.bAddedToPlane = true;
				this.bShown = shown;

				this.pLayer = this.hoAdRunHeader.rhFrame.layers[layer];
				if (quickDisplay)
					this.plane = this.pLayer.planeQuickDisplay;
				else
					this.plane = this.pLayer.planeSprites;

				if (index < 0)
					this.plane.addChild(this);
				else
					this.plane.addChildIndex(this, index);

				if (this.type != 5)
					this.computeNewDisplay();
			},

			delSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return -1;
				if (this.bAddedToPlane == false)
					return -1;

				this.bAddedToPlane = false;
				var index = this.plane.getChildIndex(this);
				this.plane.removeChild(this);
				return index;
			},

			getChildIndex: function ()
			{
				if (this.bAddedToPlane)
				{
					return this.plane.getChildIndex(this);
				}
				return -1;
			},

			getChildMaxIndex: function ()
			{
				if (this.bAddedToPlane)
					return this.plane.getNumChildren();
				return -1;
			},

			setChildIndex: function (index)
			{
				if (this.bAddedToPlane)
					this.plane.setChildIndex(this, index);
			},

			showSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return;

				if (this.bShown == false)
				{
					this.bShown = true;
					this.computeNewDisplay();
				}
			},

			hideSprite: function ()
			{
				if (this.hoCommon.ocCounters == null)
					return;

				if (this.bShown == true)
				{
					this.bShown = false;
				}
			},

			setValue: function (value)
			{
				if (value != this.rsValue)
				{
					this.rsValue = value;
					this.computeNewDisplay();
				}
			},

			callComputeNewDisplay: function ()
			{
				if (!this.computed)
					this.computeNewDisplay();
			},

			computeNewDisplay: function ()
			{
				this.computed = true;
				this.hoImgWidth = this.hoImgHeight = 1;
				if (this.hoCommon.ocCounters == null)
					return;
				var adCta = this.hoCommon.ocCounters;

				switch (adCta.odDisplayType)
				{
					case 4:
						if (this.rsValue != 0)
						{
							ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(adCta.frames[0]);
							var lg = this.rsValue * ifo.width;
							if (lg <= this.rsBoxCx)
							{
								this.hoImgWidth = lg;
								this.hoImgHeight = ifo.height;
							}
							else
							{
								this.hoImgWidth = this.rsBoxCx;
								this.hoImgHeight = ((this.rsBoxCx / ifo.width) + this.rsValue - 1) * ifo.height;
							}
							break;
						}
						this.hoImgWidth = this.hoImgHeight = 1;
						break;
					case 1:
						var i;
						var c;
						var img;
						var ifo;
						var dx = 0, dy = 0;
						var s = CServices.intToString(this.rsValue, this.displayFlags);
						for (i = s.length - 1; i >= 0; i--)
						{
							c = s.charCodeAt(i);
							img = 0;
							if (c == 45)
								img = adCta.frames[10];
							else if (c == 46)
								img = adCta.frames[12];
							else if (c == 43)
								img = adCta.frames[11];
							else if (c == 101 || c == 69)
								img = adCta.frames[13];
							else if (c >= 48 && c <= 57)
								img = adCta.frames[c - 48];
							if (img >= 0)
							{
								ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(img);
								dx += ifo.width;
								dy = Math.max(dy, ifo.height);
							}
						}
						this.hoImgXSpot = dx;
						this.hoImgYSpot = dy;
						this.hoImgWidth = dx;
						this.hoImgHeight = dy;
						break;

					case 5:
						var s = CServices.intToString(this.rsValue, this.displayFlags);
						var w;
						if (this.textSurface != null)
							w = this.textSurface.measureText(s, this.font);
						else
						{
							var ts = new CTextSurface(this.hoAdRunHeader.rhApp, 8, 8);
							w = ts.measureText(s, this.font);
						}
						this.hoImgXSpot = w;
						this.hoImgYSpot = this.rsBoxCy / 2 + this.fontHeight / 2;
						this.hoImgWidth = w;
						this.hoImgHeight = this.fontHeight;
						if (this.textSurface == null)
							this.textSurface = new CTextSurface(this.hoAdRunHeader.rhApp, this.hoImgWidth, this.hoImgHeight);
						else
						{
							if (this.hoImgWidth > this.textSurface.width || this.hoImgHeight > this.textSurface.height)
								this.textSurface.resize(this.hoImgWidth, this.hoImgHeight);
						}
						var rect = new CRect(0, 0, 1000, 1000);
						this.textSurface.setText(s, CServices.DT_LEFT | CServices.DT_TOP, rect, this.font, this.rsColor1);
						break;
				}
			},

			draw:            function (context, xx, yy)
			{
				if (!this.bShown || !this.computed) return;

				this.globalAlpha = this.alpha;
				this.globalCompositeOperation = this.composite;

				var image;
				var color1, color2;
				var s;

				var adCta = this.hoCommon.ocCounters;
				var x = xx + this.hoX - this.hoImgXSpot - this.hoAdRunHeader.rhWindowX + this.pLayer.x;
				var y = yy + this.hoY - this.hoImgYSpot - this.hoAdRunHeader.rhWindowY + this.pLayer.y;
				switch (this.type)
				{
					case 1:
						var i, img, ifo;
						s = CServices.intToString(this.rsValue, this.displayFlags);
						for (i = 0; i < s.length; i++)
						{
							var c = s.charCodeAt(i);
							img = 0;
							if (c == 45)
								img = adCta.frames[10];
							else if (c == 46 || c == 44)
								img = adCta.frames[12];
							else if (c == 43)
								img = adCta.frames[11];
							else if (c == 69 || c == 101)
								img = adCta.frames[13];
							else if (c >= 48 && c <= 57)
								img = adCta.frames[c - 48];
							ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(img);
							context.renderImage(ifo, x + ifo.xSpot, y + ifo.ySpot, 0, 1.0, 1.0, this.ros.rsEffect, this.ros.rsEffectParam);
							x += ifo.width;
						}
						break;
					case 4:
						if (this.rsValue != 0)
						{
							var x2 = x + this.hoImgWidth;
							var y2 = y + this.hoImgHeight;
							var x1 = x;
							var y1 = y;
							var vInt = this.rsValue;
							var ifo = this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(adCta.frames[0]);
							for (y = y1; y < y2 && vInt > 0; y += ifo.height)
							{
								for (x = x1; x < x2 && vInt > 0; x += ifo.width, vInt -= 1)
								{
									context.renderImage(ifo, x + ifo.xSpot, y + ifo.ySpot, 0, 1.0, 1.0, this.ros.rsEffect, this.ros.rsEffectParam);
								}
							}
						}
						break;
					case 5:
						this.textSurface.draw(context, x, y, this.ros.rsEffect, this.ros.rsEffectParam);
						break;
				}
			},
			setTransparency: function (t)
			{
				this.ros.rsEffect = CRSpr.BOP_BLEND;
				this.ros.rsEffectParam = t;
			}
		});

	// CText object
	// ------------------------------------------------------------
	function CText()
	{
		this.rsTextBuffer = null;
		this.currentText = null;
		this.rsMaxi = 0;
		this.rsMini = 0;
		this.rsFont = 0;
		this.rsTextColor = 0;
		this.nLayer = 0;
		this.font = null;
		this.bShown = true;
		this.flags = 0;
		this.rsHidden = 0;
		this.pLayer = null;
		this.plane = null;
		this.bAddedToPlane = false;
		this.rect = new CRect();
		this.deltaY = 0;
		this.rsBoxCx = 0;
		this.rsBoxCy = 0;
		this.textSurface = null;
		this.computed = false;
	}

	CText.prototype = CServices.extend(new CObject(),
		{
			init: function (ocPtr, cob)
			{
				var txt = ocPtr.ocObject;
				this.hoImgWidth = txt.otCx;
				this.hoImgHeight = txt.otCy;
				this.rsBoxCx = txt.otCx;
				this.rsBoxCy = txt.otCy;

				this.rsMaxi = txt.otNumberOfText;
				this.rsTextColor = 0;
				if (txt.otTexts.length > 0)
					this.rsTextColor = txt.otTexts[0].tsColor;

				this.rsTextBuffer = null;
				this.rsFont = -1;
				this.rsMini = 0;
				this.bShown = true;
				this.rsHidden = cob.cobFlags;
				if ((cob.cobFlags & CRun.COF_FIRSTTEXT) != 0)
				{
					if (txt.otTexts.length > 0)
					{
						this.rsTextBuffer = txt.otTexts[0].tsText;
					}
				}
				var nFont = this.rsFont;
				if (nFont == -1)
				{
					if (txt.otTexts.length > 0)
						nFont = txt.otTexts[0].tsFont;
				}
				this.font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(nFont);
				this.textSurface = new CTextSurface(this.hoAdRunHeader.rhApp, this.hoImgWidth, this.hoImgHeight);
			},

			kill: function ()
			{
			},

			handle: function ()
			{
				this.ros.handle();
				if (this.roc.rcChanged)
				{
					this.roc.rcChanged = false;
				}
			},

			getFont: function ()
			{
				var nFont = this.rsFont;
				if (nFont == -1)
				{
					var txt = this.hoCommon.ocObject;
					nFont = txt.otTexts[0].tsFont;
				}
				return this.hoAdRunHeader.rhApp.fontBank.getFontInfoFromHandle(nFont);
			},

			setFont: function (f, size)
			{
				this.rsFont = this.hoAdRunHeader.rhApp.fontBank.addFont(f);
				this.font = this.hoAdRunHeader.rhApp.fontBank.getFontFromHandle(this.rsFont);
				if (size != null)
				{
					this.hoImgWidth = size.right - size.left;
					this.hoImgHeight = size.bottom - size.top;
					this.textSurface.resize(this.hoImgWidth, this.hoImgHeight);
				}
				this.roc.rcChanged = true;
				this.computeNewDisplay();
			},

			getFontColor: function ()
			{
				return this.rsTextColor;
			},

			setFontColor: function (rgb)
			{
				this.rsTextColor = rgb;
				this.computeNewDisplay();
			},

			addOwnerDrawSprite: function (xx, yy, layer, quickDisplay, shown, index)
			{
				if (this.bAddedToPlane == true)
					return;

				this.bAddedToPlane = true;
				this.bShown = shown;

				this.pLayer = this.hoAdRunHeader.rhFrame.layers[layer];
				if (quickDisplay)
					this.plane = this.pLayer.planeQuickDisplay;
				else
					this.plane = this.pLayer.planeSprites;

				if (index < 0)
					this.plane.addChild(this);
				else
					this.plane.addChildIndex(this, index);
			},

			delSprite: function ()
			{
				if (this.bAddedToPlane == false)
					return -1;

				this.bAddedToPlane = false;
				var index = this.plane.getChildIndex(this);
				this.plane.removeChild(this);
				return index;
			},

			getChildIndex: function ()
			{
				if (this.bAddedToPlane)
				{
					return this.plane.getChildIndex(this);
				}
				return -1;
			},

			getChildMaxIndex: function ()
			{
				if (this.bAddedToPlane)
					return this.plane.getNumChildren();
				return -1;
			},

			setChildIndex: function (index)
			{
				if (this.bAddedToPlane)
					this.plane.setChildIndex(this, index);
			},

			showSprite: function ()
			{
				if (this.bShown == false)
				{
					this.bShown = true;
				}
			},

			hideSprite: function ()
			{
				if (this.bShown == true)
				{
					this.bShown = false;
				}
			},

			txtChange: function (num)
			{
				if (num < -1)
					num = -1;
				if (num >= this.rsMaxi)
					num = this.rsMaxi - 1;
				if (num == this.rsMini)
					return false;

				this.rsMini = num;

				if (num >= 0)
				{
					var txt = this.hoCommon.ocObject;
					this.txtSetString(txt.otTexts[this.rsMini].tsText);
				}
				this.computeNewDisplay();

				if ((this.ros.rsFlags & CRSpr.RSFLAG_HIDDEN) != 0)
					return false;

				return true;
			},

			txtSetString: function (s)
			{
				this.rsTextBuffer = s;
				this.computeNewDisplay();
			},

			callComputeNewDisplay: function ()
			{
				if (!this.computed)
					this.computeNewDisplay();
			},

			computeNewDisplay: function ()
			{
				this.computed = true;

				var txt = this.hoCommon.ocObject;
				var flags = txt.otTexts[0].tsFlags;

				this.hoImgXSpot = 0;
				this.hoImgYSpot = 0;
				this.rect.left = 0;
				this.rect.top = 0;
				this.rect.right = this.hoImgWidth;
				this.rect.bottom = this.hoImgHeight;

				var s;
				if (this.rsMini >= 0)
					s = txt.otTexts[this.rsMini].tsText;
				else
				{
					s = this.rsTextBuffer;
					if (s == null)
						s = "";
				}

				var dtflags = (flags & (CServices.DT_LEFT | CServices.DT_CENTER | CServices.DT_RIGHT |
					CServices.DT_TOP | CServices.DT_BOTTOM | CServices.DT_VCENTER |
					CServices.DT_SINGLELINE));
				var ht = this.textSurface.setText(s, dtflags, this.rect, this.font, this.rsTextColor);
				if ((dtflags & (CServices.DT_BOTTOM | CServices.DT_VCENTER)) == 0)
				    this.hoImgHeight = ht;
			},
			setTransparency:   function (t)
			{
				this.ros.rsEffect = CRSpr.BOP_BLEND;
				this.ros.rsEffectParam = t;
			},
			draw:              function (context, xx, yy)
			{
				if (!this.bShown || !this.computed) return;
				var x = xx + this.hoX - this.hoAdRunHeader.rhWindowX + this.pLayer.x;
				var y = yy + this.hoY - this.hoAdRunHeader.rhWindowY + this.pLayer.y;
				this.textSurface.draw(context, x, y, this.ros.rsEffect, this.ros.rsEffectParam);
			}
		});

	// CQuestion object
	// -------------------------------------------------------------
	function CQuestion()
	{
		this.rsBoxCx = 0;
		this.rsBoxCy = 0;
		this.rcA = null;
		this.currentDown = 0;
		this.xMouse = 0;
		this.yMouse = 0;
		this.textSurfaces = new Array();
	}
	CQuestion.prototype = CServices.extend(new CObject(),
		{
			init: function (ocPtr, cob)
			{
			},

			kill: function ()
			{
			},

			handle:         function ()
			{
				this.hoAdRunHeader.pause();
				this.hoAdRunHeader.questionObjectOn = this;
				var layer = this.hoAdRunHeader.rhFrame.layers[this.hoAdRunHeader.rhFrame.nLayers - 1];
				layer.planeSprites.addChild(this);
				this.computeTexts();
			},
			destroyObject:  function ()
			{
				var layer = this.hoAdRunHeader.rhFrame.layers[this.hoAdRunHeader.rhFrame.nLayers - 1];
				layer.planeSprites.removeChild(this);
			},
			handleQuestion: function ()
			{
				var current;
				var xMouse = this.hoAdRunHeader.rhApp.mouseX - this.hoAdRunHeader.rhApp.xOffset;
				var yMouse = this.hoAdRunHeader.rhApp.mouseY - this.hoAdRunHeader.rhApp.yOffset;

				if (this.currentDown == 0)
				{
					if (this.hoAdRunHeader.rhApp.keyBuffer[CRunApp.VK_LBUTTON])
					{
						current = this.getQuestion(xMouse, yMouse);
						if (current != 0)
						{
							this.currentDown = current;
						}
					}
				}
				else
				{
					if (!this.hoAdRunHeader.rhApp.keyBuffer[CRunApp.VK_LBUTTON])
					{
						if (this.getQuestion(xMouse, yMouse) == this.currentDown)
						{
							this.hoAdRunHeader.rhEvtProg.rhCurParam0 = this.currentDown;
							this.hoAdRunHeader.rhEvtProg.handle_Event(this, (((-80 - 3) << 16) | 4));

							var defTexts = this.hoCommon.ocObject;
							var ptts = defTexts.otTexts[this.currentDown];
							var bCorrect = (ptts.tsFlags & CDefText.TSF_CORRECT) != 0;
							if (bCorrect)
							{
								this.hoAdRunHeader.rhEvtProg.handle_Event(this, (((-80 - 1) << 16) | 4));
							}
							else
							{
								this.hoAdRunHeader.rhEvtProg.handle_Event(this, (((-80 - 2) << 16) | 4));
							}
							this.destroyObject();
							this.hoAdRunHeader.questionObjectOn = null;
							this.hoAdRunHeader.resume();
							this.hoAdRunHeader.f_KillObject(this.hoNumber, true);
							return;
						}
						this.currentDown = 0;
					}
				}
			},

			getQuestion: function (xMouse, yMouse)
			{
				var i;
				if (this.rcA != null)
				{
					for (i = 1; i < this.rcA.length; i++)
					{
						if (xMouse >= this.rcA[i].left && xMouse < this.rcA[i].right)
						{
							if (yMouse > this.rcA[i].top && yMouse < this.rcA[i].bottom)
							{
								return i;
							}
						}
					}
				}
				return 0;
			},

			border3D: function (context, rc, state)
			{
				var color1, color2;

				if (state)
				{
					color1 = 0x808080;
					color2 = 0xFFFFFF;
				}
				else
				{
					color2 = 0x808080;
					color1 = 0xFFFFFF;
				}

				context.renderRect(rc.left, rc.top, rc.right - rc.left,
					rc.bottom - rc.top, 0x000000, 1);

				var pt = new Array(3);
				var n;
				for (n = 0; n < 3; n++)
				{
					pt[n] = new CPoint();
				}
				pt[0].x = rc.right - 1;
				if (state == false)
					pt[0].x -= 1;
				pt[0].y = rc.top + 1;
				pt[1].y = rc.top + 1;
				pt[1].x = rc.left + 1;
				pt[2].x = rc.left + 1;
				pt[2].y = rc.bottom;
				if (state == false)
					pt[2].y -= 1;
				context.renderLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y, color1, 1);
				context.renderLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y, color1, 1);

				if (state == false)
					pt[0].x -= 1;
				pt[0].y += 1;
				pt[1].x += 1;
				pt[1].y += 1;
				pt[2].x += 1;
				if (state == false)
					pt[2].y -= 1;
				context.renderLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y, color1, 1);
				context.renderLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y, color1, 1);

				if (state == false)
				{
					pt[0].x += 2;
					pt[1].x = rc.right - 1;
					pt[1].y = rc.bottom - 1;
					pt[2].y = rc.bottom - 1;
					pt[2].x -= 1;
					context.renderLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y, color2, 1);
					context.renderLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y, color2, 1);

					pt[0].x -= 1;
					pt[0].y += 1;
					pt[1].x -= 1;
					pt[1].y -= 1;
					pt[2].x += 1;
					pt[2].y -= 1;
					context.renderLine(pt[0].x, pt[0].y, pt[1].x, pt[1].y, color2, 1);
					context.renderLine(pt[1].x, pt[1].y, pt[2].x, pt[2].y, color2, 1);
				}
			},

			redraw_Answer: function (context, number, state)
			{
				var rc = new CRect();

				rc.copyRect(this.rcA[number]);
				this.border3D(context, this.rcA[number], state);
				rc.left += 2;
				rc.top += 2;
				rc.right -= 4;
				rc.bottom -= 4;
				if (state)
				{
					rc.left += 2;
					rc.top += 2;
				}
				this.textSurfaces[number].draw(context,
					(rc.left + rc.right) / 2 - this.textSurfaces[number].width / 2,
					(rc.top + rc.bottom) / 2 - this.textSurfaces[number].height / 2,
					0, 0);
			},

			computeTexts: function ()
			{
				this.measureTextSurface = new CTextSurface(this.hoAdRunHeader.rhApp, 8, 8);

				var defTexts = this.hoCommon.ocObject;
				var prh = this.hoAdRunHeader;

				var ptta = defTexts.otTexts[1];
				var colorA = ptta.tsColor;
				var flgRelief = (ptta.tsFlags & CDefText.TSF_RELIEF) != 0;
				var fontAnswers = prh.rhApp.fontBank.getFontFromHandle(ptta.tsFont);
				this.xa_margin = Math.floor((this.measureTextSurface.measureText("X", fontAnswers) * 3) / 2);
				this.hta = 4;
				this.lgBox = 64;
				var i, tm;
				for (i = 1; i < defTexts.otTexts.length; i++)
				{
					ptta = defTexts.otTexts[i];
					if (ptta.tsText.length > 0)
					{
						tm = this.measureTextSurface.measureText(ptta.tsText, fontAnswers);
						this.lgBox = Math.max(this.lgBox, tm + this.xa_margin * 2 + 4);
						this.hta = Math.max(this.hta, Math.floor((fontAnswers.getHeight() * 3) / 2));
					}
				}
				this.hte = Math.max(Math.floor(this.hta / 4), 2);
				this.lgBox += this.xa_margin * 2 + 4;
				var rc = new CRect();
				for (i = 1; i < defTexts.otTexts.length; i++)
				{
					ptta = defTexts.otTexts[i];
					this.textSurfaces[i] = new CTextSurface(prh.rhApp, this.lgBox, this.hta);
					rc.right = this.lgBox;
					rc.bottom = this.hta;
					this.textSurfaces[i].manualDrawText(ptta.tsText, CServices.DT_CENTER | CServices.DT_VCENTER, rc, colorA, fontAnswers, flgRelief ? 1 : 0, 0xFFFFFF);
				}

				var ptts = defTexts.otTexts[0];
				flgRelief = (ptts.tsFlags & CDefText.TSF_RELIEF) != 0;
				var fontQuestion = prh.rhApp.fontBank.getFontFromHandle(ptts.tsFont);
				var xq_margin = Math.floor((this.measureTextSurface.measureText("X", fontQuestion) * 3) / 2);
				tm = this.measureTextSurface.measureText(ptts.tsText, fontQuestion);
				this.htq = Math.floor(fontQuestion.getHeight() * 3 / 2);
				this.lgBox = Math.max(this.lgBox, tm + xq_margin * 2 + 4);
				if (this.lgBox > prh.rhApp.gaCxWin)
					this.lgBox = prh.rhApp.gaCxWin;
				else if (this.lgBox > prh.rhFrame.leWidth)
					this.lgBox = prh.rhFrame.leWidth;
				rc.right = this.lgBox;
				rc.bottom = this.htq;
				this.textSurfaces[0] = new CTextSurface(prh.rhApp, this.lgBox, this.htq);
				this.textSurfaces[0].manualDrawText(ptts.tsText, CServices.DT_CENTER | CServices.DT_VCENTER,
					rc, colorA, fontQuestion, flgRelief ? 1 : 0, 0xFFFFFF);
			},
			draw:         function (context, xDraw, yDraw)
			{
				var defTexts = this.hoCommon.ocObject;
				var prh = this.hoAdRunHeader;
				var x = this.hoX - prh.rhWindowX;
				var y = this.hoY - prh.rhWindowY;

				var rcQ = new CRect();
				rcQ.left = x;
				rcQ.top = y;
				var boxCx = this.lgBox;
				var boxCy = this.htq + 1 + (this.hta + this.hte) * (defTexts.otTexts.length - 1) + this.hte + 4;
				rcQ.right = x + boxCx;
				rcQ.bottom = y + boxCy;

				context.renderSolidColor(rcQ.left, rcQ.top, rcQ.right - rcQ.left, rcQ.bottom - rcQ.top, 0xC0C0C0, 0, 0);
				this.border3D(context, rcQ, false);

				rcQ.left += 2;
				rcQ.top += 2;
				rcQ.right -= 2;
				rcQ.bottom = rcQ.top + this.htq;
				this.textSurfaces[0].draw(context,
					(rcQ.left + rcQ.right) / 2 - this.textSurfaces[0].width / 2,
					(rcQ.top + rcQ.bottom) / 2 - this.textSurfaces[0].height / 2,
					0, 0);
				rcQ.top = rcQ.bottom;
				context.renderLine(rcQ.left, rcQ.top, rcQ.right, rcQ.bottom, 0x808080, 1, 0, 0);
				rcQ.top += 1;
				rcQ.bottom += 1;
				context.renderLine(rcQ.left, rcQ.top, rcQ.right, rcQ.bottom, 0xFFFFFF, 1, 0, 0);

				if (this.rcA == null)
				{
					this.rcA = Array(defTexts.otTexts.length);
					for (i = 1; i < defTexts.otTexts.length; i++)
					{
						this.rcA[i] = new CRect();
						this.rcA[i].left = x + 2 + this.xa_margin;
						this.rcA[i].right = x + this.lgBox - 2 - this.xa_margin;
						this.rcA[i].top = y + 2 + this.htq + 1 + this.hte + (this.hta + this.hte) * (i - 1);
						this.rcA[i].bottom = this.rcA[i].top + this.hta;
					}
				}
				for (i = 1; i < defTexts.otTexts.length; i++)
				{
					var bFlag = (this.currentDown == i);
					this.redraw_Answer(context, i, bFlag);
				}
			}
		});

	// CExtension object
	// -------------------------------------------------------------
	function CExtension(type, rhPtr)
	{
		this.ext = rhPtr.rhApp.extLoader.loadRunObject(type);
		this.noHandle = false;
		this.privateData = 0;
		this.objectCount = 0;
		this.objectNumber = 0;
		this.bAddedToPlane = false;
		this.bShown = true;
		this.nLayer = 0;
		this.pLayer = null;
		this.plane = null;
	}
	CExtension.prototype = CServices.extend(new CObject(),
		{
			init: function (ocPtr, cob)
			{
				this.ext.init(this);

				var file = this.hoAdRunHeader.rhApp.file.createFromFile(ocPtr.ocExtension);
				this.privateData = ocPtr.ocPrivate;
				this.ext.createRunObject(file, cob, ocPtr.ocVersion);
			},

			addSprite: function (xx, yy, image, layer, bShown)
			{
				this.nLayer = layer;
				this.pLayer = this.hoAdRunHeader.rhFrame.layers[layer];
				this.bShown = bShown;
				if (this.bAddedToPlane == true)
					return;
				this.bAddedToPlane = true;
				this.plane = this.pLayer.planeSprites;
				this.plane.addChild(this);
			},

			addOwnerDrawSprite: function (xx, yy, layer, bQuickDisplay, bShown)
			{
				this.nLayer = layer;
				this.pLayer = this.hoAdRunHeader.rhFrame.layers[layer];
				this.bShown = bShown;

				if (this.bAddedToPlane == true)
					return;
				this.bAddedToPlane = true;

				if (bQuickDisplay)
					this.plane = this.pLayer.planeQuickDisplay;
				else
					this.plane = this.pLayer.planeSprites;

				this.plane.addChild(this);
			},

			delSprite: function ()
			{
			    //return this.plane.removeChild(this);

				if (this.bAddedToPlane == false)
				    return -1;
				this.bAddedToPlane = false;
				var index = this.plane.getChildIndex(this);
				this.plane.removeChild(this);
				return index;
			},

			handle: function ()
			{
				if ((this.hoOEFlags & 0x0200) != 0)
					this.ros.handle();
				else if ((this.hoOEFlags & 0x0030) == 0x0010 || (this.hoOEFlags & 0x0030) == 0x0030)
					this.rom.move();
				else if ((this.hoOEFlags & 0x0030) == 0x0020)
					this.roa.animate();

				var ret = 0;
				if (this.noHandle == false)
					ret = this.ext.handleRunObject();

				if ((ret & CRunExtension.REFLAG_ONESHOT) != 0)
					this.noHandle = true;
				if (this.roc != null)
				{
					if (this.roc.rcChanged)
					{
						ret |= CRunExtension.REFLAG_DISPLAY;
						this.roc.rcChanged = false;
					}
				}
			},

			autoResize: function ()
			{
				this.ext.autoResize();
			},
			createFont: function ()
			{
				this.ext.createFont();
			},
			draw:       function (context, xDraw, yDraw)
			{
				if (this.bShown)
				{
					this.ext.displayRunObject(context, xDraw, yDraw);
				}
			},

			kill: function (bFast)
			{
				this.ext.destroyRunObject(bFast);
			},

			getCollisionMask: function (flags)
			{
				return this.ext.getRunObjectCollisionMask(flags);
			},

			condition: function (num, cnd)
			{
				return this.ext.condition(num, cnd);
			},

			action: function (num, act)
			{
				this.ext.action(num, act);
			},

			expression: function (num)
			{
				return this.ext.expression(num);
			},

			setTransparency: function (t)
			{
				this.ros.rsEffect = CRSpr.BOP_BLEND;
				this.ros.rsEffectParam = t;
			},

			setFocus: function (bFlag)
			{
				this.ext.setFocus(bFlag);
			},

			showSprite: function ()
			{
				this.bShown = true;
			},

			hideSprite: function ()
			{
				this.bShown = false;
			},

			//setChildIndex: function (index)
			//{
			//	this.ext.setChildIndex(index);
			//},

			getChildIndex: function ()
			{
				return this.plane.getChildIndex(this);
			},

			getChildMaxIndex: function ()
			{
				return this.plane.children.length;
			},

			setChildIndex: function (index)
			{
				if (index >= this.plane.children.length)
					index = this.plane.children.length;
				if (index < 0)
					index = 0;
				this.plane.setChildIndex(this, index);
			},

			pauseRunObject: function ()
			{
				this.ext.pauseRunObject();
			},

			continueRunObject: function ()
			{
				this.ext.continueRunObject();
			},

			forcePosition: function ()
			{
				this.ext.forcePosition();
			},

			loadImageList: function (list)
			{
				this.hoAdRunHeader.rhApp.imageBank.loadImageList(list);
			},

			getImage: function (handle)
			{
				return this.hoAdRunHeader.rhApp.imageBank.getImageFromHandle(handle);
			},

			getApplication: function ()
			{
				return this.hoAdRunHeader.rhApp;
			},

			getX: function ()
			{
				return this.hoX;
			},

			getY: function ()
			{
				return this.hoY;
			},

			getWidth: function ()
			{
				return this.hoImgWidth;
			},

			getHeight: function ()
			{
				return this.hoImgHeight;
			},

			setX: function (x)
			{
				if (this.rom != null)
				{
					this.rom.rmMovement.setXPosition(x);
				}
				else
				{
					this.hoX = x;
					if (this.roc != null)
					{
						this.roc.rcChanged = true;
						this.roc.rcCheckCollides = true;
					}
				}
			},

			setY: function (y)
			{
				if (this.rom != null)
				{
					this.rom.rmMovement.setYPosition(y);
				}
				else
				{
					this.hoY = y;
					if (this.roc != null)
					{
						this.roc.rcChanged = true;
						this.roc.rcCheckCollides = true;
					}
				}
			},

			setWidth: function (width)
			{
				this.hoImgWidth = width;
			},

			setHeight: function (height)
			{
				this.hoImgHeight = height;
			},
			setSize:   function (width, height)
			{
				this.hoImgWidth = width;
				this.hoImgHeight = height;
			},
			reHandle:  function ()
			{
				this.noHandle = false;
			},

			generateEvent: function (code, param)
			{
				if (this.hoAdRunHeader.rh2PauseCompteur == 0)
				{
					var p0 = this.hoAdRunHeader.rhEvtProg.rhCurParam0;
					this.hoAdRunHeader.rhEvtProg.rhCurParam0 = param;

					code = (-(code + CEventProgram.EVENTS_EXTBASE + 1) << 16);
					code |= (this.hoType & 0xFFFF);
					this.hoAdRunHeader.rhEvtProg.handle_Event(this, code);

					this.hoAdRunHeader.rhEvtProg.rhCurParam0 = p0;
				}
			},

			pushEvent: function (code, param)
			{
				if (this.hoAdRunHeader.rh2PauseCompteur == 0)
				{
					code = (-(code + CEventProgram.EVENTS_EXTBASE + 1) << 16);
					code |= (this.hoType & 0xFFFF);
					this.hoAdRunHeader.rhEvtProg.push_Event(1, code, param, this, this.hoOi);
				}
			},

			pause: function ()
			{
				this.hoAdRunHeader.pause();
			},

			resume: function ()
			{
				this.hoAdRunHeader.resume();
			},

			redraw: function ()
			{
			},

			destroy: function ()
			{
				this.hoAdRunHeader.destroy_Add(this.hoNumber);
			},

			setPosition: function (x, y)
			{
				if (this.rom != null)
				{
					this.rom.rmMovement.setXPosition(x);
					this.rom.rmMovement.setYPosition(y);
				}
				else
				{
					this.hoX = x;
					this.hoY = y;
					if (this.roc != null)
					{
						this.roc.rcChanged = true;
						this.roc.rcCheckCollides = true;
					}
				}
			},

			getExtUserData: function ()
			{
				return this.privateData;
			},

			setExtUserData: function (data)
			{
				this.privateData = data;
			},

			addBackdrop: function (img, x, y, typeObst, nLayer)
			{
				this.hoAdRunHeader.addBackdrop(img, x, y, nLayer, typeObst, true);
			},

			getEventCount: function ()
			{
				return this.hoAdRunHeader.rh4EventCount;
			},

			getExpParam: function ()
			{
				this.hoAdRunHeader.rh4CurToken++;
				return this.hoAdRunHeader.getExpression();
			},

			getEventParam: function ()
			{
				return this.hoAdRunHeader.rhEvtProg.rhCurParam0;
			},

			callMovement: function (hoPtr, action, param)
			{
				if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_MOVEMENTS) != 0)
				{
					if (hoPtr.roc.rcMovementType == CMoveDef.MVTYPE_EXT)
					{
						var mvPtr = hoPtr.rom.rmMovement;
						return mvPtr.callMovement(action, param);
					}
				}
				return 0;
			},

			getFirstObject: function ()
			{
				this.objectCount = 0;
				this.objectNumber = 0;
				return this.getNextObject();
			},

			getNextObject: function ()
			{
				if (this.objectNumber < this.hoAdRunHeader.rhNObjects)
				{
					while (this.hoAdRunHeader.rhObjectList[this.objectCount] == null)
						this.objectCount++;
					var hoPtr = this.hoAdRunHeader.rhObjectList[this.objectCount];
					this.objectNumber++;
					this.objectCount++;
					return hoPtr;
				}
				return null;
			},

			getObjectFromFixed: function (fixed)
			{
				var count = 0;
				var number;
				for (number = 0; number < this.hoAdRunHeader.rhNObjects; number++)
				{
					while (this.hoAdRunHeader.rhObjectList[count] == null)
						count++;
					var hoPtr = this.hoAdRunHeader.rhObjectList[count];
					count++;
					var id = (hoPtr.hoCreationId << 16) | (hoPtr.hoNumber & 0xFFFF);
					if (id == fixed)
						return hoPtr;
				}
				return null;
			},

			findFirstObject:function(name)
			{
				return this.hoAdRunHeader.findFirstObject(name);
			},

			findNextObject:function(object)
			{
				return this.hoAdRunHeader.findNextObject(object);
			},

			openHFile: function (path)
			{
				return hoAdRunHeader.rhApp.openHFile(path);
			},

			closeHFile: function (path)
			{
				hoAdRunHeader.rhApp.closeHFile(path);
			}
		});
	// CParam object
	// ------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	CParam.PARAM_EXPRESSIONNUM = 22;
	CParam.create = function (app)
	{
		var debut = app.file.getFilePointer();

		var param = null;
		var size = app.file.readAShort();
		var c = app.file.readAShort();

		switch (c)
		{
			case 1:
				param = new PARAM_OBJECT(app);
				break;
			case 2:
				param = new PARAM_TIME(app);
				break;
			case 3:
				param = new PARAM_SHORT(app);
				break;
			case 4:
				param = new PARAM_SHORT(app);
				break;
			case 5:
				param = new PARAM_INT(app);
				break;
			case 6:
				param = new PARAM_SAMPLE(app);
				break;
			case 9:
				param = new PARAM_CREATE(app);
				break;
			case 10:
				param = new PARAM_SHORT(app);
				break;
			case 11:
				param = new PARAM_SHORT(app);
				break;
			case 12:
				param = new PARAM_SHORT(app);
				break;
			case 13:
				param = new PARAM_EVERY(app);
				break;
			case 14:
				param = new PARAM_KEY(app);
				break;
			case 15:
				param = new PARAM_EXPRESSION(app);
				break;
			case 16:
				param = new PARAM_POSITION(app);
				break;
			case 17:
				param = new PARAM_SHORT(app);
				break;
			case 18:
				param = new PARAM_SHOOT(app);
				break;
			case 19:
				param = new PARAM_ZONE(app);
				break;
			case 21:
				param = new PARAM_CREATE(app);
				break;
			case 22:
				param = new PARAM_EXPRESSION(app);
				break;
			case 23:
				param = new PARAM_EXPRESSION(app);
				break;
			case 24:
				param = new PARAM_COLOUR(app);
				break;
			case 25:
				param = new PARAM_INT(app);
				break;
			case 26:
				param = new PARAM_SHORT(app);
				break;
			case 27:
				param = new PARAM_EXPRESSION(app);
				break;
			case 28:
				param = new PARAM_EXPRESSION(app);
				break;
			case 29:
				param = new PARAM_INT(app);
				break;
			case 31:
				param = new PARAM_SHORT(app);
				break;
			case 32:
				param = new PARAM_SHORT(app);
				break;
			case 34:
				param = new PARAM_INT(app);
				break;
			case 35:
				param = new PARAM_SAMPLE(app);
				break;
			case 36:
				param = new PARAM_SAMPLE(app);
				break;
			case 37:
				param = new PARAM_SHORT(app);
				break;
			case 38:
				param = new PARAM_GROUP(app);
				break;
			case 39:
				param = new PARAM_GROUPOINTER(app);
				break;
			case 40:
				param = new PARAM_STRING(app);
				break;
			case 41:
				param = new PARAM_STRING(app);
				break;
			case 42:
				param = new PARAM_CMPTIME(app);
				break;
			case 43:
				param = new PARAM_SHORT(app);
				break;
			case 44:
				param = new PARAM_KEY(app);
				break;
			case 45:
				param = new PARAM_EXPRESSION(app);
				break;
			case 46:
				param = new PARAM_EXPRESSION(app);
				break;
			case 47:
				param = new PARAM_2SHORTS(app);
				break;
			case 48:
				param = new PARAM_INT(app);
				break;
			case 49:
				param = new PARAM_SHORT(app);
				break;
			case 50:
				param = new PARAM_SHORT(app);
				break;
			case 51:
				param = new PARAM_2SHORTS(app);
				break;
			case 52:
				param = new PARAM_EXPRESSION(app);
				break;
			case 53:
				param = new PARAM_EXPRESSION(app);
				break;
			case 54:
				param = new PARAM_EXPRESSION(app);
				break;
			case 55:
				param = new PARAM_EXTENSION(app);
				break;
			case 56:
				param = new PARAM_INT(app);
				break;
			case 57:
				param = new PARAM_SHORT(app);
				break;
			case 58:
				param = new PARAM_SHORT(app);
				break;
			case 59:
				param = new PARAM_EXPRESSION(app);
				break;
			case 60:
				param = new PARAM_SHORT(app);
				break;
			case 61:
				param = new PARAM_SHORT(app);
				break;
			case 62:
				param = new PARAM_EXPRESSION(app);
				break;
			case 63:
				param = new PARAM_STRING(app);
				break;
			case 64:
				param = new PARAM_STRING(app);
				break;
		    case 67:
		        param = new PARAM_SHORT(app);
		        break;
		}
		param.code = c;
		app.file.seek(debut + size);
		return param;
	}
	function CParam()
	{
	}

	// CPositionInfo object
	// ------------------------------------------------------------------------
	function CPositionInfo()
	{
		this.x = 0;
		this.y = 0;
		this.dir = 0;
		this.layer = 0;
		this.bRepeat = false;
	}
	// Parameter objects
	// ------------------------------------------------------------------------
	function PARAM_2SHORTS(app)
	{
		this.value1 = app.file.readAShort();
		this.value2 = app.file.readAShort();
	}
	function PARAM_CMPTIME(app)
	{
		this.timer = app.file.readAInt();
		this.loops = app.file.readAInt();
		this.comparaison = app.file.readAShort();
	}
	function PARAM_COLOUR(app)
	{
		this.color = app.file.readAColor();
	}
	function PARAM_EVERY(app)
	{
		this.delay = app.file.readAInt();
		this.compteur = app.file.readAInt();
	}
	function PARAM_EXPRESSION(app)
	{
		this.comparaison = app.file.readAShort();

		var debut = app.file.getFilePointer();
		var count = 0;
		var size;
		var code;
		while (true)
		{
			count++;
			code = app.file.readAInt();
			if (code == 0)
				break;
			size = app.file.readAShort();
			if (size > 6)
				app.file.skipBytes(size - 6);
		}

		app.file.seek(debut);
		this.tokens = new Array(count);
		var n;
		for (n = 0; n < count; n++)
			this.tokens[n] = CExp.create(app.file);
	}
	function PARAM_EXTENSION(app)
	{
		var size = app.file.readAShort();
		app.file.skipBytes(4);
		this.data = 0;
		if (size > 6)
		{
			this.data = app.file.getFilePointer();
			app.file.skipBytes(size - 6);
		}
	}
	PARAM_GROUP.GRPFLAGS_INACTIVE = 0x0001;
	PARAM_GROUP.GRPFLAGS_CLOSED = 0x0002;
	PARAM_GROUP.GRPFLAGS_PARENTINACTIVE = 0x0004;
	PARAM_GROUP.GRPFLAGS_GROUPINACTIVE = 0x0008;
	PARAM_GROUP.GRPFLAGS_GLOBAL = 0x0010;
	function PARAM_GROUP(app)
	{
		this.grpFlags = app.file.readAShort();
		this.grpId = app.file.readAShort();
	}
	function PARAM_GROUPOINTER(app)
	{
		app.file.skipBytes(4);
		this.pointer = 0;
		this.id = app.file.readAShort();
	}
	function PARAM_INT(app)
	{
		this.value = app.file.readAInt();
		this.value2 = 0;
	}
	function PARAM_KEY(app)
	{
		this.key = app.file.readAShort();
	}
	function PARAM_OBJECT(app)
	{
		this.oiList = app.file.readShort();
		this.oi = app.file.readShort();
		this.type = app.file.readShort();
	}
	CPosition.CPF_DIRECTION = 0x0001;
	CPosition.CPF_ACTION = 0x0002;
	CPosition.CPF_INITIALDIR = 0x0004;
	CPosition.CPF_DEFAULTDIR = 0x0008;
	function CPosition()
	{
	}
	CPosition.prototype =
	{
		read_Position: function (rhPtr, getDir, pInfo)
		{
			pInfo.layer = -1;

			if (this.posOINUMParent == -1)
			{
				if (getDir != 0)
				{
					pInfo.dir = -1;
					if ((this.posFlags & CPosition.CPF_DEFAULTDIR) == 0)
					{
						pInfo.dir = rhPtr.get_Direction(this.posDir);
					}
				}
				pInfo.x = this.posX;
				pInfo.y = this.posY;
				var nLayer = this.posLayer;
				if (nLayer > rhPtr.rhFrame.nLayers - 1)
					nLayer = rhPtr.rhFrame.nLayers - 1;
				pInfo.layer = nLayer;
				pInfo.bRepeat = false;
			}
			else
			{
				rhPtr.rhEvtProg.rh2EnablePick = false;
				var pHo;
				pHo = rhPtr.rhEvtProg.get_CurrentObjects(this.posOiList);
				pInfo.bRepeat = rhPtr.rhEvtProg.repeatFlag;
				if (pHo == null)
					return false;
				pInfo.x = pHo.hoX;
				pInfo.y = pHo.hoY;
				pInfo.layer = pHo.hoLayer;

				if ((this.posFlags & CPosition.CPF_ACTION) != 0)
				{
					if ((pHo.hoOEFlags & CObjectCommon.OEFLAG_ANIMATIONS) != 0)
					{
						if (pHo.roc.rcImage >= 0)
						{
							var ifo;
							var angle = pHo.roc.rcAngle;
							var pMBase = rhPtr.GetMBase(pHo);
							if (pMBase != null)
								angle = pMBase.getAngle();
							ifo = rhPtr.rhApp.imageBank.getImageInfoEx(pHo.roc.rcImage, angle, pHo.roc.rcScaleX, pHo.roc.rcScaleY);
							pInfo.x += ifo.xAP - ifo.xSpot;
							pInfo.y += ifo.yAP - ifo.ySpot;
						}
					}
				}

				if ((this.posFlags & CPosition.CPF_DIRECTION) != 0)
				{
					var dir = this.posAngle + pHo.hoAdRunHeader.getDir(pHo) & 0x1F;
					var px = CMove.getDeltaX(this.posSlope, dir);
					var py = CMove.getDeltaY(this.posSlope, dir);
					pInfo.x += px;
					pInfo.y += py;
				}
				else
				{
					pInfo.x += this.posX;
					pInfo.y += this.posY;
				}

				if ((getDir & 0x01) != 0)
				{
					if ((this.posFlags & CPosition.CPF_DEFAULTDIR) != 0)
						pInfo.dir = -1;
					else if ((this.posFlags & CPosition.CPF_INITIALDIR) != 0)
						pInfo.dir = pHo.hoAdRunHeader.getDir(pHo);
					else
						pInfo.dir = rhPtr.get_Direction(this.posDir);
				}
			}

			if ((getDir & 0x02) != 0)
			{
				if (pInfo.x < rhPtr.rh3XMinimumKill || pInfo.x > rhPtr.rh3XMaximumKill)
					return false;
				if (pInfo.y < rhPtr.rh3YMinimumKill || pInfo.y > rhPtr.rh3YMaximumKill)
					return false;
			}
			return true;
		}
	}
	function PARAM_POSITION(app)
	{
		this.posOINUMParent = app.file.readShort();
		this.posFlags = app.file.readShort();
		this.posX = app.file.readShort();
		this.posY = app.file.readShort();
		this.posSlope = app.file.readShort();
		this.posAngle = app.file.readShort();
		this.posDir = app.file.readAInt();
		this.posTypeParent = app.file.readShort();
		this.posOiList = app.file.readShort();
		this.posLayer = app.file.readShort();
	}
	PARAM_POSITION.prototype = CServices.extend(new CPosition(),
		{
		});
	function PARAM_CREATE(app)
	{
		this.posOINUMParent = app.file.readShort();
		this.posFlags = app.file.readShort();
		this.posX = app.file.readShort();
		this.posY = app.file.readShort();
		this.posSlope = app.file.readShort();
		this.posAngle = app.file.readShort();
		this.posDir = app.file.readAInt();
		this.posTypeParent = app.file.readShort();
		this.posOiList = app.file.readShort();
		this.posLayer = app.file.readShort();
		this.cdpHFII = app.file.readAShort();
		this.cdpOi = app.file.readAShort();
	}
	PARAM_CREATE.prototype = CServices.extend(new CPosition(),
		{
		});
	function PARAM_SHOOT(app)
	{
		this.posOINUMParent = app.file.readShort();
		this.posFlags = app.file.readShort();
		this.posX = app.file.readShort();
		this.posY = app.file.readShort();
		this.posSlope = app.file.readShort();
		this.posAngle = app.file.readShort();
		this.posDir = app.file.readAInt();
		this.posTypeParent = app.file.readShort();
		this.posOiList = app.file.readShort();
		this.posLayer = app.file.readShort();
		this.cdpHFII = app.file.readShort();
		this.cdpOi = app.file.readShort();
		app.file.skipBytes(4);		//cdpFree
		this.shtSpeed = app.file.readAShort();
	}
	PARAM_SHOOT.prototype = CServices.extend(new CPosition(),
		{
		});

	function PARAM_SAMPLE(app)
	{
		this.sndHandle = app.file.readAShort();
		this.sndFlags = app.file.readAShort();
	}
	function PARAM_SHORT(app)
	{
		this.value = app.file.readAShort();
	}
	function PARAM_STRING(app)
	{
		this.string = app.file.readAString();
	}
	function PARAM_TIME(app)
	{
		this.timer = app.file.readAInt();
		this.loops = app.file.readAInt();
	}
	function PARAM_ZONE(app)
	{
		this.x1 = app.file.readShort();
		this.y1 = app.file.readShort();
		this.x2 = app.file.readShort();
		this.y2 = app.file.readShort();
	}
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	function Renderer()
	{
		this.clips = [];
	};

	Renderer.prototype =
	{
		renderSolidColor: function (x, y, w, h, color, inkEffect, inkEffectParam)
		{
		},

		renderSolidColorEllipse: function (x, y, w, h, color, inkEffect, inkEffectParam)
		{
		},

		renderGradient: function (x, y, w, h, color1, color2, vertical, inkEffect, inkEffectParam)
		{
		},

		renderGradientEllipse: function (x, y, w, h, color1, color2, vertical, inkEffect, inkEffectParam)
		{
		},

		renderImage: function (image, x, y, angle, scaleX, scaleY, inkEffect, inkEffectParam)
		{
		},

		renderSimpleImage: function (image, x, y, w, h, inkEffect, inkEffectParam)
		{
		},

		renderPattern: function (image, x, y, w, h, inkEffect, inkEffectParam)
		{
		},

		renderPatternEllipse: function (image, x, y, w, h, inkEffect, inkEffectParam)
		{
		},

		renderLine: function (xA, yA, xB, yB, color, thickness, inkEffect, inkEffectParam)
		{
		},

		renderRect: function (x, y, w, h, color, thickness, inkEffect, inkEffectParam)
		{
		},

		renderEllipse: function (x, y, w, h, color, inkEffect, inkEffectParam)
		{
		},

		pushClip: function (x, y, w, h)
		{
			var curClip = this.clips[this.clips.length - 1];

			if (curClip)
			{
				if (x < curClip.x)
					x = curClip.x;

				if (y < curClip.y)
					y = curClip.y;

				if ((x + w) > (curClip.x + curClip.w))
					w = (curClip.x + curClip.w) - x;

				if ((y + h) > (curClip.y + curClip.h))
					h = (curClip.y + curClip.h) - y;
			}

			var clip = { x: x, y: y, w: w, h: h };

			this.clips.push(clip);

			return clip;
		},

		popClip: function ()
		{
			this.clips.pop();
		}
	};

	/* Renderer implementation using 2D canvas context
	 */
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */
	function StandardRenderer(element)
	{
	    this.xScale = 1.0;
	    this.yScale = 1.0;
	    this.oldEffect = -1;
		this.smoothing = false;
		this.oldSmoothing = false;
		this.dxw = 0.0;               // sub-pixel margin size for destination rectangle
		this.dyw = 0.0;               // sub-pixel margin size for destination rectangle

		if (!(this._context = element.getContext('2d')))
			throw new Error("Failed to init standard renderer");
	};

	StandardRenderer.prototype = CServices.extend(new Renderer(),
		{
			resetEffect: function (smooth)
			{
				this.smoothing = smooth;
				this.oldSmoothing = smooth;
				this._context["imageSmoothingEnabled"] = smooth;
				this._context["webkitImageSmoothingEnabled"] = smooth;
				this._context["mozImageSmoothingEnabled"] = smooth;
				this._context["msImageSmoothingEnabled"] = smooth;

				this.oldEffect = -1;
				this.setInkEffect(0, 0);
			},

			setScale: function (sx, sy)
			{
				this._context.scale(sx, sy);

			    // Adjust subpixel correction according to scale, to avoid seams between backdrop objects
	            // todo: should it depend on the browser?
				this.xScale = sx;
				this.yScale = sy;
				this.dxw = 0.0;             // no sub-pixel correction if no scaling
				this.dyw = 0.0;

				if (this.xScale > 1.0)
				    this.dxw = 1.0;         // 1 pixel correction if zoom > 1.0
			    else if (this.xScale > 0.0 && this.xScale < 1.0)
			        this.dxw = 1.0 / this.xScale;   // 1/scale pixel correction if zoom < 1.0
				if (this.yScale > 1.0)
				    this.dyw = 1.0;
				if (this.yScale > 0.0 && this.yScale < 1.0)
				    this.dyw = 1.0 / this.yScale;
			},

			clearBackground: function (x, y, w, h)
			{
				var context = this._context;
				context.clearRect(x, y, w, h);
			},

			renderSolidColor: function (x, y, w, h, color, inkEffect, inkEffectParam)
			{
				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				context.fillStyle = CServices.getColorString(color);
				context.fillRect(x, y, w, h);
			},

			renderSolidColorEllipse: function (x, y, w, h, color, inkEffect, inkEffectParam)
			{
				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				context.fillStyle = CServices.getColorString(color);

				CServices.createEllipse(context, x, y, w, h);
				context.fill();
			},

			renderGradient: function (x, y, w, h, color1, color2, vertical, inkEffect, inkEffectParam)
			{
				if (color1 == color2)
					return this.renderSolidColor(x, y, w, h, color1, inkEffect, inkEffectParam);

				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				this.configureGradient(x, y, w, h, vertical, color1, color2);

				context.fillRect(x, y, w, h);
			},

			renderGradientEllipse: function (x, y, w, h, color1, color2, vertical, inkEffect, inkEffectParam)
			{
				if (color1 == color2)
					return this.renderSolidColorEllipse(x, y, w, h, color1, inkEffect, inkEffectParam);

				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				this.configureGradient(x, y, w, h, vertical, color1, color2);

				CServices.createEllipse(context, x, y, w, h);
				this._context.fill();
			},

			renderImage: function (image, x, y, angle, scaleX, scaleY, inkEffect, inkEffectParam)
			{
				//        if(! (image instanceof CImage))
				//            throw new Error("renderImage: bad image type: " + (typeof image));
				var context = this._context;
				var xi = x - image.xSpot;
				var yi = y - image.ySpot;
				//        if (xi+image.width<0 || xi>context.width || yi+image.height<0 || yi>context.height)
				//        	return;

				this.setInkEffect(inkEffect, inkEffectParam);

				if (angle == 0 && scaleX == 1 && scaleY == 1)
				{
					if (image.mosaic == 0)
					{
						if (image.img != null)
						{
						    context.drawImage(image.img, xi, yi);
	                    }
					}
					else
					{
					    context.drawImage(image.app.imageBank.mosaics[image.mosaic],
							image.mosaicX, image.mosaicY,
							image.width, image.height,
	                        xi, yi,
							image.width, image.height);
	                }
				}
				else
				{
					context.save();

					context.translate(x, y);

					if (angle != 0)
						context.rotate(-angle * 0.0174532925);

					context.scale(Math.max(0.001, scaleX), Math.max(0.001, scaleY));
					context.translate(-image.xSpot, -image.ySpot);

					if (image.mosaic == 0)
					{
					    if (image.img != null && image.width != 0 && image.height != 0)
						{
							context.drawImage(image.img, 0, 0, image.width, image.height,
								0, 0, image.width, image.height);
						}
					}
					else
					{
						context.drawImage(image.app.imageBank.mosaics[image.mosaic],
							image.mosaicX, image.mosaicY,
							image.width, image.height, 0, 0,
							image.width, image.height);
					}

					context.restore();
				}
			},

		    // This function is used by backdrop objects only, to avoid seams between objects
	        // Limited to backdrop objects as it can affect rendering of small objects
			renderImageWithSubPixelCorrection: function (image, x, y, angle, scaleX, scaleY, inkEffect, inkEffectParam) {
			    //        if(! (image instanceof CImage))
			    //            throw new Error("renderImage: bad image type: " + (typeof image));
			    var context = this._context;
			    var xi = x - image.xSpot;
			    var yi = y - image.ySpot;
			    //        if (xi+image.width<0 || xi>context.width || yi+image.height<0 || yi>context.height)
			    //        	return;

			    this.setInkEffect(inkEffect, inkEffectParam);

			    if (angle == 0 && scaleX == 1 && scaleY == 1)
			    {
			        if (image.mosaic == 0)
			        {
			            if (image.img != null)
			            {
			                context.drawImage(image.img,
	                            0, 0,
	                            image.width, image.height,
	                            xi, yi,
	                            image.width + this.dxw, image.height + this.dyw);
			            }
			        }
			        else
			        {
			            context.drawImage(image.app.imageBank.mosaics[image.mosaic],
							image.mosaicX, image.mosaicY,
							image.width, image.height,
	                        xi, yi,
							image.width + this.dxw, image.height + this.dyw);
			        }
			    }
			    else
			    {
			        context.save();

			        context.translate(x, y);

			        if (angle != 0)
			            context.rotate(-angle * 0.0174532925);

			        context.scale(Math.max(0.001, scaleX), Math.max(0.001, scaleY));
			        context.translate(-image.xSpot, -image.ySpot);

			        if (image.mosaic == 0)
			        {
			            if (image.img != null)
			            {
			                context.drawImage(image.img, 0, 0, image.width, image.height,
								0, 0, image.width, image.height);
			            }
			        }
			        else
			        {
			            context.drawImage(image.app.imageBank.mosaics[image.mosaic],
							image.mosaicX, image.mosaicY,
							image.width, image.height, 0, 0,
							image.width, image.height);
			        }

			        context.restore();
			    }
			},

			renderSimpleImage: function (image, x, y, width, height, inkEffect, inkEffectParam)
			{
				this.setInkEffect(inkEffect, inkEffectParam);
				this._context.drawImage(image, x, y, width, height);

			    // Not sure if we should add sub-pixel margin to this routine as it's not used by backdrops
	            // Do it later if necessary only
				//this._context.drawImage(image, x, y, width + this.dxw, height + this.dyw);
			},

			renderPattern: function (image, x, y, w, h, inkEffect, inkEffectParam)
			{
				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				context.save();
				context.beginPath();
				context.moveTo(x, y);
				context.lineTo(x + w, y);
				context.lineTo(x + w, y + h);
				context.lineTo(x, y + h);
				context.lineTo(x, y);
				context.clip();

				var iSx = image.width;
				var iSy = image.height;
				var widthX = Math.floor(w / iSx) + 1;
				var heightY = Math.floor(h / iSy) + 1;
				var nX, nY;
				for (nX = 0; nX < widthX; nX++)
				{
					for (nY = 0; nY < heightY; nY++)
					{
						if (image.mosaic == 0)
						{
							if (image.img != null)
							{
	//							context.drawImage(image.img, x + nX * iSx, y + nY * iSy);

							    context.drawImage(image.img,
	                                0, 0,
	                                image.width, image.height,
	                                x + nX * iSx, y + nY * iSy,
	                                image.width + this.dxw, image.height + this.dyw);
							}
						}
						else
						{
						    context.drawImage(image.app.imageBank.mosaics[image.mosaic],
								image.mosaicX, image.mosaicY,
								image.width, image.height,
	                            x + nX * iSx, y + nY * iSy,
								image.width + this.dxw, image.height + this.dyw);
	                    }
					}
				}
				context.restore();
			},

			renderPatternEllipse: function (image, x, y, w, h, inkEffect, inkEffectParam)
			{
				if (!(image instanceof CImage))
					throw new Error("renderPatternEllipse: bad image type: " + (typeof image));

				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				if (image.mosaic == 0)
				{
					if (image.img != null)
					{
						context.fillStyle = context.createPattern(image.img, 'repeat');
					}
				}
				else
				{
					if (!image.pattern)
					{
						image.pattern = document.createElement("canvas");
						image.pattern.width = image.width;
						image.pattern.height = image.height;
						var context = image.pattern.getContext("2d");
						context.drawImage(image.app.imageBank.mosaics[image.mosaic],
							image.mosaicX, image.mosaicY,
							image.width, image.height, 0, 0,
							image.width, image.height);
					}
					context.fillStyle = context.createPattern(image.pattern, 'repeat');
				}
				CServices.createEllipse(context, x, y, w, h);
				this._context.fill();
			},

			renderLine: function (xA, yA, xB, yB, color, thickness, inkEffect, inkEffectParam)
			{
				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				context.strokeStyle = CServices.getColorString(color);
				context.lineCap = 'round';
				context.lineWidth = thickness;

				context.beginPath();
				context.moveTo(xA, yA);
				context.lineTo(xB, yB);
				context.closePath();

				context.stroke();
			},

			renderRect: function (x, y, w, h, color, thickness, inkEffect, inkEffectParam)
			{
				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);

				context.strokeStyle = CServices.getColorString(color);
				context.lineWidth = thickness;
				context.strokeRect(x, y, w, h);
			},

			renderEllipse: function (x, y, w, h, thickness, color, inkEffect, inkEffectParam)
			{
				var context = this._context;

				this.setInkEffect(inkEffect, inkEffectParam);
				context.lineWidth = thickness;
				context.strokeStyle = CServices.getColorString(color);

				CServices.createEllipse(context, x, y, w, h);
				this._context.stroke();
			},

			clip: function (x, y, w, h)
			{
				var context = this._context;
				context.save();
				context.beginPath();
				context.rect(x, y, w, h);
				context.clip();
			},

			unClip: function ()
			{
				this._context.restore();
			},

			pushClip: function ()
			{
				var context = this._context;

				var clip = Renderer.prototype.pushClip.apply(this, arguments);

				context.beginPath();
				context.rect(clip.x, clip.y, clip.w, clip.h);
				context.clip();
			},

			popClip: function ()
			{
				var context = this._context;

				Renderer.prototype.popClip.apply(this, arguments);

				if (this.clips.length > 0)
				{
					var clip = this.clips[this.clips.length - 1];

					context.beginPath();
					context.rect(clip.x, clip.y, clip.w, clip.h);
					context.clip();
				}
				else
				{
					context.resetClip();
				}
			},

			setInkEffect: function (effect, effectParam)
			{
				var context = this._context;
				if (typeof effect == 'undefined')
				{
					context.globalAlpha = 1.0;
					context.composite = 'source-over';
					return;
				}

				if (effect == this.oldEffect && effectParam == this.oldEffectParam)
					return;
				this.oldEffect = effect;
				this.oldEffectParam = effectParam;


				var effectMasked = effect & CRSpr.BOP_MASK;
				var smoothing = ((effect & CRSpr.BOP_SMOOTHING) != 0) | this.smoothing;
				if (smoothing != this.oldSmoothing)
				{
					this.oldSmoothing = smoothing;
					context["imageSmoothingEnabled"] = smoothing;
					context["webkitImageSmoothingEnabled"] = smoothing;
					context["mozImageSmoothingEnabled"] = smoothing;
					context["msImageSmoothingEnabled"] = smoothing;
	            }

				if ((effect & CRSpr.BOP_RGBAFILTER) != 0)
					context.globalAlpha = (((effectParam >>> 24) & 0xFF) / 255.0);
				else if (effectMasked == CRSpr.BOP_BLEND)
					context.globalAlpha = ((128 - effectParam) / 128.0);
				else
					context.globalAlpha = 1.0;

				switch (effectMasked)
				{
					case CRSpr.BOP_ADD:
						context.composite = "lighter";
						break;
					case CRSpr.BOP_XOR:
						context.composite = "xor";
						break;
					default:
						context.composite = "source-over";
						break;
				}
			},

			configureGradient: function (x, y, w, h, vertical, color1, color2)
			{
				var gradient = vertical ?
					this._context.createLinearGradient(x, y, x, y + h)
					: this._context.createLinearGradient(x, y, x + w, y);

				gradient.addColorStop(0, CServices.getColorString(color1));
				gradient.addColorStop(1, CServices.getColorString(color2));

				this._context.fillStyle = gradient;
			}
		});




	// CTRANSITIONDATA : données transitions
	//----------------------------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 *
	 * Permission is hereby granted to any person obtaining a legal copy
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for
	 * debugging, optimizing, or customizing applications created with
	 * Clickteam Multimedia Fusion 2.
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	CTransitionData.TRFLAG_COLOR = 0x0001;
	function CTransitionData()
	{
		this.dllName = "";
		this.transID = 0;
		this.transDuration = 0;
		this.transFlags = 0;
		this.transColor = 0;
		this.dataOffset = 0;
	}
	CTransitionData.prototype =
	{
		load: function (file)
		{
			var debut = file.getFilePointer();

			file.skipBytes(4);
			this.transID = file.readAInt();
			this.transDuration = file.readAInt();
			this.transFlags = file.readAInt();
			this.transColor = file.readAColor();

			var nameOffset = file.readAInt();
			var paramOffset = file.readAInt();
			file.seek(debut + nameOffset);
			this.dllName = file.readAString();
			this.dllName = this.dllName.substr(0, this.dllName.indexOf('.'));
			this.dataOffset = (debut + paramOffset);
		}
	}

	// CTRANSITIONS : interface avec la dll
	//----------------------------------------------------------------------------------
	function CTransition()
	{
	}
	CTransition.prototype =
	{
		getTrans: function (data)
		{
			return null;
		}
	}

	// CTRANS : interface avec un effet de transition
	//----------------------------------------------------------------------------------
	CTrans.LEFT_RIGHT = 0;
	CTrans.RIGHT_LEFT = 1;
	CTrans.TOP_BOTTOM = 2;
	CTrans.BOTTOM_TOP = 3;
	CTrans.CENTER_LEFTRIGHT = 0;
	CTrans.LEFTRIGHT_CENTER = 1;
	CTrans.CENTER_TOPBOTTOM = 2;
	CTrans.TOPBOTTOM_CENTER = 3;
	CTrans.TOP_LEFT = 0;
	CTrans.TOP_RIGHT = 1;
	CTrans.BOTTOM_LEFT = 2;
	CTrans.BOTTOM_RIGHT = 3;
	CTrans.CENTER = 4;
	CTrans.DIR_HORZ = 0;
	CTrans.DIR_VERT = 1;
	CTrans.TRFLAG_FADEIN = 0x0001;
	CTrans.TRFLAG_FADEOUT = 0x0002;
	function CTrans()
	{
		this.m_initTime = 0;
		this.m_currentTime = 0;
		this.m_endTime = 0;
		this.m_duration = 0;
		this.m_overflow = false;
		this.m_running = false;
		this.m_starting = false;
		this.source1 = null;
		this.source2 = null;
		this.dest = null;
		this.destContext = null;
	}
	CTrans.prototype =
	{
		start: function (data, display, debut, fin)
		{
			this.dest = display;
			this.destContext = this.dest.getContext("2d");
			this.source1 = debut;
			this.source2 = fin;

			var date = new Date();
			this.m_initTime = date.getTime();
			this.m_duration = data.transDuration;
			if (this.m_duration == 0)
				this.m_duration = 1;
			this.m_currentTime = this.m_initTime;
			this.m_endTime = this.m_initTime + this.m_duration;
			this.m_running = true;
			this.m_starting = true;
		},

		finish: function ()
		{
		},

		isCompleted: function ()
		{
			if (this.m_running)
			{
				var date = new Date();
				if (date.getTime() >= this.m_endTime)
					return true;
				return (date.getTime() >= this.m_endTime);
			}
			return true;
		},

		getDeltaTime: function ()
		{
			var date = new Date();
			this.m_currentTime = date.getTime();
			if (this.m_currentTime > this.m_endTime)
				this.m_currentTime = this.m_endTime;
			return (this.m_currentTime - this.m_initTime);
		},

		getTimePos: function ()
		{
			return this.m_currentTime - this.m_initTime;
		},

		setTimePos: function (msTimePos)
		{
			this.m_initTime = (this.m_currentTime - this.msTimePos);
			this.m_endTime = this.m_initTime + this.m_duration;
		},

		blit: function (source, xDest, yDest, xSrce, ySrce, width, height)
		{
			if (this.m_objectFadeOut)
				this.destContext.globalCompositeOperation = "source-atop";
			if (arguments.length == 1)
				this.destContext.drawImage(source, 0, 0);
			else if (width > 0 && height > 0)
				this.destContext.drawImage(source, xSrce, ySrce, width, height, xDest, yDest, width, height);
		},

		stretch: function (source, xDest, yDest, wDest, hDest, xSrce, ySrce, wSrce, hSrce)
		{
			if (this.m_objectFadeOut)
				this.destContext.globalCompositeOperation = "source-atop";
			if (wDest > 0 && hDest > 0 && wSrce > 0 && hSrce > 0)
				this.destContext.drawImage(source, xSrce, ySrce, wSrce, hSrce, xDest, yDest, wDest, hDest);
		},

		stepDraw: function (flag)
		{
		},

		end: function ()
		{
		},

		init: function (data, file, display, source, dest)
		{
		}

	}

	// CTRANSITIONMANAGER
	//----------------------------------------------------------------------------------
	function CTransitionManager(a)
	{
		this.app = a;
	}
	CTransitionManager.prototype =
	{
		startObjectFade:  function (hoPtr, bFadeOut)
		{
			var pData = hoPtr.hoCommon.ocFadeIn;
			if (bFadeOut)
			{
				pData = hoPtr.hoCommon.ocFadeOut;
			}
			var img = null;
			var context;
			if ((hoPtr.hoOEFlags & CObjectCommon.OEFLAG_ANIMATIONS) != 0)
			{
				var image = this.app.imageBank.getImageFromHandle(hoPtr.roc.rcImage);
				img = document.createElement("canvas");
				img.width = image.width;
				img.height = image.height;
				var context = img.getContext("2d");
				if (image.mosaic == 0)
					context.drawImage(image.img, 0, 0);
				else
				{
					context.drawImage(this.app.imageBank.mosaics[image.mosaic],
						image.mosaicX, image.mosaicY,
						image.width, image.height, 0, 0,
						image.width, image.height);
				}
			}
			else if (hoPtr.hoType >= 32)
			{
				img = document.createElement("canvas");
				img.width = hoPtr.hoImgWidth;
				img.height = hoPtr.hoImgHeight;
				var renderer = new StandardRendered(img);
				if (!hoPtr.getSurface(renderer))
					img = null;
			}
			if (img == null)
			{
				return null;
			}

			var width = img.width;
			var height = img.height;

			// L'image de fond
			var display = document.createElement("canvas");
			display.width = width;
			display.height = height;

			// Les images de debut et de fin
			var surface1 = document.createElement("canvas");
			surface1.width = width;
			surface1.height = height;
			var surface2 = document.createElement("canvas");
			surface2.width = width;
			surface2.height = height;
			var context;
			if (bFadeOut)
			{
				// Source = image
				context = surface1.getContext("2d");
				context.drawImage(img, 0, 0);
				context = display.getContext("2d");
				context.drawImage(img, 0, 0);
				if ((pData.transFlags & CTransitionData.TRFLAG_COLOR) != 0)
				{
					this.copyColorMask(surface2, img, pData.transColor);
				}
			}
			// Fade in
			else
			{
				// Destination = image
				context = surface2.getContext("2d");
				context.drawImage(img, 0, 0);
				if ((pData.transFlags & CTransitionData.TRFLAG_COLOR) != 0)
				{
					this.copyColorMask(surface1, img, pData.transColor);
				}
			}

			// Charge la transition
			var pTrans = this.createTransition(pData, display, surface1, surface2);
			if (pTrans != null)
			{
				var trFlags = 0;
				if ((hoPtr.hoFlags & CObject.HOF_FADEOUT) != 0)
				{
					pTrans.m_objectFadeOut = true;
					trFlags |= CTrans.TRFLAG_FADEOUT;
				}
				else
				{
					pTrans.m_objectFadeOut = false;
					trFlags |= CTrans.TRFLAG_FADEIN;
				}
				hoPtr.transitionImage = display;
				pTrans.stepDraw(trFlags);
			}
			return pTrans;
		},
		copyColorMask:    function (dest, source, couleur)
		{
			var context = dest.getContext("2d");
			context.drawImage(source, 0, 0);
			var width = source.width;
			var height = source.height;
			var pixels = context.getImageData(0, 0, width, height);
			var x, y, alpha;
			var color = couleur & 0x00FFFFFF;
			var r = (couleur & 0x00FF0000) >> 16;
			var g = (couleur & 0x0000FF00) >> 8;
			var b = couleur & 0x000000FF;
			for (y = 0; y < height; y++)
			{
				for (x = 0; x < width; x++)
				{
					if (pixels.data[(y * width + x) * 4 + 3] != 0)
					{
						pixels.data[(y * width + x) * 4] = r;
						pixels.data[(y * width + x) * 4 + 1] = g;
						pixels.data[(y * width + x) * 4 + 2] = b;
					}
				}
			}
			context.putImageData(pixels, 0, 0);
		},
		createTransition: function (pData, display, surfaceStart, surfaceEnd)
		{
			var dllName = pData.dllName;

			var dll = null;

			// STARTCUT
			if (dllName.toLowerCase() == "cctrans")
				dll = new CTransitionCCTrans();
			// ENDCUT

			if (dll != null)
			{
				var trans = dll.getTrans(pData);
				this.app.file.seek(pData.dataOffset);
				trans.m_objectFadeOut = false;
				trans.init(pData, this.app.file, display, surfaceStart, surfaceEnd);
				return trans;
			}
			return null;
		}
	}

	// CTransitioncctrans : point d'entree des transitions standard
	//----------------------------------------------------------------------------------
	/* Copyright (c) 1996-2012 Clickteam
	 *
	 * This source code is part of the HTML5 exporter for Clickteam Multimedia Fusion 2.
	 * 
	 * Permission is hereby granted to any person obtaining a legal copy 
	 * of Clickteam Multimedia Fusion 2 to use or modify this source code for 
	 * debugging, optimizing, or customizing applications created with 
	 * Clickteam Multimedia Fusion 2. 
	 * Any other use of this source code is prohibited.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
	 * IN THE SOFTWARE.
	 */

	CTransitionCCTrans.identifiers =
		[
			"BAND",
			"SE00",
			"SE10",
			"SE12",
			"DOOR",
			"SE03",
			"MOSA",
			"SE05",
			"SE06",
			"SCRL",
			"SE01",
			"SE07",
			"SE09",
			"SE13",
			"SE08",
			"SE02",
			"ZIGZ",
			"SE04",
			"ZOOM",
			"SE11",
			"FADE"
		];
	function CTransitionCCTrans()
	{
	}
	CTransitionCCTrans.prototype = CServices.extend(new CTransition(),
		{
			getTrans: function (data)
			{
				// Extrait l'identifier
				var id = data.transID;
				var idChars = "";
				idChars += String.fromCharCode(id & 0xFF);
				id >>= 8;
				idChars += String.fromCharCode(id & 0xFF);
				id >>= 8;
				idChars += String.fromCharCode(id & 0xFF);
				id >>= 8;
				idChars += String.fromCharCode(id & 0xFF);

				// Recherche dans la liste
				var n;
				for (n = 0; n < CTransitionCCTrans.identifiers.length; n++)
				{
					if (idChars == CTransitionCCTrans.identifiers[n])
					{
						break;
					}
				}

				// Cree la transition
				var trans = null;
				switch (n)
				{
					case 0:
						trans = new CTransBand();
						break;
					case 1:
						trans = new CTransAdvancedScrolling();
						break;
					case 2:
						trans = new CTransBack();
						break;
					case 3:
						trans = new CTransCell();
						break;
					case 4:
						trans = new CTransDoor();
						break;
					case 5:
						trans = new CTransLine();
						break;
					case 6:
						trans = new CTransMosaic();
						break;
					case 7:
						trans = new CTransOpen();
						break;
					case 8:
						trans = new CTransPush();
						break;
					case 9:
						trans = new CTransScroll();
						break;
					case 10:
						trans = new CTransSquare();
						break;
					case 11:
						trans = new CTransStretch();
						break;
					case 12:
						trans = new CTransStretch2();
						break;
					case 13:
						trans = new CTransTrame();
						break;
					case 14:
						trans = new CTransTurn();
						break;
					case 15:
						trans = new CTransTurn2();
						break;
					case 16:
						trans = new CTransZigZag();
						break;
					case 17:
						trans = new CTransZigZag2();
						break;
					case 18:
						trans = new CTransZoom();
						break;
					case 19:
						trans = new CTransZoom2();
						break;
					case 20:
						trans = new CTransFade();
						break;
				}
				return trans;
			}
		});

	// CTransAdvancedScrolling
	//----------------------------------------------------------------------------------
	function CTransAdvancedScrolling()
	{
		this.dwStyle = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
		this.m_style = 0;
	}
	CTransAdvancedScrolling.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;

					if (this.dwStyle != 8)
						this.m_style = this.dwStyle;
					else
						this.m_style = Math.floor(Math.random() * 8);
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);													// completed
				}
				else
				{
					var w, h;

					switch (this.m_style)
					{
						case 0:
							// Scrolling (To right, to left and to down)
							/////////////////////////////////////////////

							w = this.m_source2Width / 3 * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.blit(this.source2, 0, 0, this.m_source2Width / 3 - w, 0, w, h);					// Left Side
							this.blit(this.source2, this.m_source2Width - w, 0, 2 * this.m_source2Width / 3, 0, w, h);	// Right Side

							w = this.m_source2Width / 3;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.blit(this.source2, w, 0, w, this.m_source2Height - h, w, h);					// Top side
							break;
						case 1:
							// Scrolling (To right, to left and to up)
							/////////////////////////////////////////////

							w = this.m_source2Width / 3 * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.blit(this.source2, 0, 0, this.m_source2Width / 3 - w, 0, w, h);					// Left Side
							this.blit(this.source2, this.m_source2Width - w, 0, 2 * this.m_source2Width / 3, 0, w, h);	// Right Side

							w = this.m_source2Width / 3;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.blit(this.source2, w, this.m_source2Height - h, w, 0, w, h);					// Bottom side
							break;
						case 2:
							// To right, to left and to up
							////////////////////////////////

							w = this.m_source2Width / 3 * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.blit(this.source2, 0, 0, this.m_source2Width / 3 - w, 0, w, h);					// Left Side
							this.blit(this.source2, this.m_source2Width - w, 0, 2 * this.m_source2Width / 3, 0, w, h);	// Right Side

							w = this.m_source2Width / 3;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.blit(this.source2, w, 0, w, 0, w, h);									// Top side
							break;
						case 3:
							// To right, to left and to down
							/////////////////////////////////

							w = this.m_source2Width / 3 * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.blit(this.source2, 0, 0, this.m_source2Width / 3 - w, 0, w, h);					// Left Side
							this.blit(this.source2, this.m_source2Width - w, 0, 2 * this.m_source2Width / 3, 0, w, h);	// Right Side

							w = this.m_source2Width / 3;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.blit(this.source2, w, this.m_source2Height - h, w, this.m_source2Height - h, w, h);	// Bottom side
							break;
						case 4:
							// To right, to left, to down and to up
							////////////////////////////////////////

							w = this.m_source2Width / 3 * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.blit(this.source2, 0, 0, this.m_source2Width / 3 - w, 0, w, h);					// Left Side
							this.blit(this.source2, this.m_source2Width - w, 0, 2 * this.m_source2Width / 3, 0, w, h);	// Right Side

							w = this.m_source2Width / 3;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.blit(this.source2, w, 0, w, this.m_source2Height / 2 - h, w, h);					// Top side
							this.blit(this.source2, w, this.m_source2Height - h, w, this.m_source2Height / 2, w, h);	// Bottom side
							break;
						case 5:
							// To right, to left, to down and to up
							////////////////////////////////////////

							w = this.m_source2Width / 3 * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.blit(this.source2, 0, 0, this.m_source2Width / 3 - w, 0, w, h);					// Left Side
							this.blit(this.source2, this.m_source2Width - w, 0, 2 * this.m_source2Width / 3, 0, w, h);	// Right Side

							w = this.m_source2Width / 3;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.blit(this.source2, w, 0, w, 0, w, h);									// Top side
							this.blit(this.source2, w, this.m_source2Height - h, w, this.m_source2Height - h, w, h);	// Bottom side
							break;
						case 6:
							// Scrolling (3 bands)
							///////////////////////

							w = this.m_source2Width / 3;
							h = this.m_source2Height * elapsedTime / this.m_duration;

							this.blit(this.source2, 0, this.m_source2Height - h, 0, 0, w, h);					// Band 1
							this.blit(this.source2, w, 0, w, this.m_source2Height - h, w, h);					// Band 2
							this.blit(this.source2, w * 2, this.m_source2Height - h, w * 2, 0, w, h);				// Band 3
							break;
						case 7:
							// Scrolling (7 bands)
							///////////////////////

							w = this.m_source2Width / 7;
							h = this.m_source2Height * elapsedTime / this.m_duration;

							this.blit(this.source2, 0, this.m_source2Height - h, 0, 0, w, h);					// Band 1
							this.blit(this.source2, w, 0, w, this.m_source2Height - h, w, h);					// Band 2
							this.blit(this.source2, w * 2, this.m_source2Height - h, w * 2, 0, w, h);				// Band 3
							this.blit(this.source2, w * 3, 0, w * 3, this.m_source2Height - h, w, h);				// Band 4
							this.blit(this.source2, w * 4, this.m_source2Height - h, w * 4, 0, w, h);				// Band 5
							this.blit(this.source2, w * 5, 0, w * 5, this.m_source2Height - h, w, h);				// Band 6
							this.blit(this.source2, w * 6, this.m_source2Height - h, w * 6, 0, w * 2, h);				// Band 7
							break;
						default:
							this.blit(this.source2);
							break;
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransBack()
	{
		this.dwStyle = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
	}
	CTransBack.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);												// completed
				}
				else
				{
					var w, h;
					this.blit(this.source2);

					switch (this.dwStyle)
					{
						// OPEN
						case 0:
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							w = this.m_source2Width / 2 - w;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 - h;
							this.stretch(this.source1, 0, 0, w, h, 0, 0, this.m_source2Width / 2, this.m_source2Height / 2);

							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 - h;
							this.stretch(this.source1, this.m_source2Width / 2 + w, 0, this.m_source2Width / 2 - w, h, this.m_source2Width / 2, 0, this.m_source2Width / 2, this.m_source2Height / 2);

							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							w = this.m_source2Width / 2 - w;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.stretch(this.source1, 0, this.m_source2Height / 2 + h, w, this.m_source2Height / 2 - h, 0, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);

							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.stretch(this.source1, this.m_source2Width / 2 + w, this.m_source2Height / 2 + h, this.m_source2Width / 2 - w, this.m_source2Height / 2 - h, this.m_source2Width / 2, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);
							break;
						// SLIDE
						case 1:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							w = this.m_source2Width - w;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							h = this.m_source2Height - h;
							this.blit(this.source1, 0, 0, this.m_source2Width - w, this.m_source2Height - h, w, h);
							break;
						// SLIDE
						case 2:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							h = this.m_source2Height - h;
							this.blit(this.source1, w, 0, 0, this.m_source2Height - h, this.m_source2Width - w, h);
							break;
						// SLIDE
						case 3:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							w = this.m_source2Width - w;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.blit(this.source1, 0, h, this.m_source2Width - w, 0, w, this.m_source2Height - h);
							break;
						// SLIDE
						case 4:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.blit(this.source1, w, h, 0, 0, this.m_source2Width - w, this.m_source2Height - h);
							break;
						// OPEN (SCROLLING)
						case 5:
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							w = this.m_source2Width / 2 - w;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 - h;
							this.blit(this.source1, w - this.m_source2Width / 2, h - this.m_source2Height / 2, 0, 0, this.m_source2Width / 2, this.m_source2Height / 2);

							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 - h;
							this.blit(this.source1, this.m_source2Width / 2 + w, h - this.m_source2Height / 2, this.m_source2Width / 2, 0, this.m_source2Width / 2, this.m_source2Height / 2);

							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							w = this.m_source2Width / 2 - w;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.blit(this.source1, w - this.m_source2Width / 2, this.m_source2Height / 2 + h, 0, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);

							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.blit(this.source1, this.m_source2Width / 2 + w, this.m_source2Height / 2 + h, this.m_source2Width / 2, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);
							break;
						// SLIDE
						case 6:
							w = this.m_source2Width;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 - h;
							this.blit(this.source1, 0, h - this.m_source2Height / 2, 0, 0, this.m_source2Width, this.m_source2Height / 2);
							this.blit(this.source1, 0, this.m_source2Height - h, 0, this.m_source2Height / 2, this.m_source2Width, this.m_source2Height / 2);
							break;
						// SLIDE
						case 7:
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							w = this.m_source2Width / 2 - w;
							h = this.m_source2Height;
							this.blit(this.source1, w - this.m_source2Width / 2, 0, 0, 0, this.m_source2Width / 2, this.m_source2Height);
							this.blit(this.source1, this.m_source2Width - w, 0, this.m_source2Width / 2, 0, this.m_source2Width / 2, this.m_source2Height);
							break;
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});

	function CTransBand()
	{
		this.bpNbBands = 0;
		this.bpDirection = 0;
		this.m_wbande = 0;
		this.m_rw = 0;
		this.m_prc = null;
	}
	CTransBand.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.bpNbBands = file.readAShort();
				this.bpDirection = file.readAShort();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				var sw = this.source1.width;
				var sh = this.source1.height;
				var n;

				// 1st time? create surface
				if (this.m_starting)
				{
					// Security...
					if (this.bpNbBands == 0)
						this.bpNbBands = 1;

					switch (this.bpDirection)
					{
						case CTrans.LEFT_RIGHT:
						case CTrans.RIGHT_LEFT:
							this.m_wbande = (sw + this.bpNbBands - 1) / this.bpNbBands;
							if (this.m_wbande == 0)
							{
								this.m_wbande = 1;
								this.bpNbBands = sw;
							}
							break;
						default:
							this.m_wbande = (sh + this.bpNbBands - 1) / this.bpNbBands;
							if (this.m_wbande == 0)
							{
								this.m_wbande = 1;
								this.bpNbBands = sh;
							}
							break;
					}
					this.m_rw = 0;
					this.m_starting = false;
				}

				// Attention, passer la transparence en parametre...
				if (this.bpNbBands <= 0 || this.m_wbande <= 0 || this.m_duration == 0)
					this.blit(this.source2);	// termine
				else
				{
					var rw = this.m_wbande * this.getDeltaTime() / this.m_duration;
					if (rw > this.m_rw)
					{
						var x = 0, y = 0, w = 0, h = 0;
						for (n = 0; n < this.bpNbBands; n++)
						{
							switch (this.bpDirection)
							{
								case CTrans.LEFT_RIGHT:
									x = this.m_rw + n * this.m_wbande;
									y = 0;
									w = rw - this.m_rw;
									h = sh;
									break;
								case CTrans.RIGHT_LEFT:
									x = sw - (this.m_rw + n * this.m_wbande) - (rw - this.m_rw);
									y = 0;
									w = rw - this.m_rw;
									h = sh;
									break;
								case CTrans.TOP_BOTTOM:
									x = 0;
									y = this.m_rw + n * this.m_wbande;
									w = sw;
									h = rw - this.m_rw;
									break;
								case CTrans.BOTTOM_TOP:
									x = 0;
									y = sh - (this.m_rw + n * this.m_wbande) - (rw - this.m_rw);
									w = sw;
									h = rw - this.m_rw;
									break;
							}
							this.blit(this.source2, x, y, x, y, w, h);
						}
					}
					this.m_rw = rw;
				}
				return this.m_prc;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransCell()
	{
		this.dwPos = 0;
		this.dwPos2 = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
	}
	CTransCell.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwPos = file.readAInt();
				this.dwPos2 = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);					// completed
				}
				else
				{
					var x, y, w, h, i, j, w2, h2;
					var width, height;

					width = this.m_source2Width / this.dwPos;
					height = this.m_source2Height / this.dwPos2;
					w = this.m_source2Width / this.dwPos;
					h = this.m_source2Height / this.dwPos2;

					for (i = 0; i < this.dwPos; i++)
					{
						for (j = 0; j < this.dwPos2; j++)
						{
							x = ( i * width );
							y = ( j * height );

							w2 = w * elapsedTime / this.m_duration;
							h2 = h * elapsedTime / this.m_duration;
							this.stretch(this.source2, x + (w - w2) / 2, y + (h - h2) / 2, w2, h2, x + (w - w2) / 2, y + (h - h2) / 2, w2, h2);
						}
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});

	function CTransDoor()
	{
		this.m_direction = 0;
		this.m_wbande = 0;
		this.m_rw = 0;
	}
	CTransDoor.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.m_direction = file.readAShort();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time? create surface
				if (this.m_starting)
				{
					switch (this.m_direction)
					{
						case CTrans.CENTER_LEFTRIGHT:
						case CTrans.LEFTRIGHT_CENTER:
							this.m_wbande = this.source1.width / 2;
							break;
						default:
							this.m_wbande = this.source1.height / 2;
							break;
					}
					this.m_rw = 0;
					this.m_starting = false;
				}

				// Attention, passer la transparence en parametre...
				if (this.m_wbande == 0)
					this.blit(this.source2);	// termine
				else
				{
					var x = 0, y = 0, w = 0, h = 0;
					var rw = this.m_wbande * this.getDeltaTime() / this.m_duration;
					if (rw > this.m_rw)
					{
						// 1st band
						switch (this.m_direction)
						{
							case CTrans.CENTER_LEFTRIGHT:
								x = this.source1.width / 2 - rw;
								y = 0;
								w = rw - this.m_rw;
								h = this.source2.height;
								break;
							case CTrans.LEFTRIGHT_CENTER:
								x = this.m_rw;
								y = 0;
								w = rw - this.m_rw;
								h = this.source2.height;
								break;
							case CTrans.CENTER_TOPBOTTOM:
								x = 0;
								y = this.source1.height / 2 - rw;
								w = this.source2.width;
								h = rw - this.m_rw;
								break;
							case CTrans.TOPBOTTOM_CENTER:
								x = 0;
								y = this.m_rw;
								w = this.source2.width;
								h = rw - this.m_rw;
								break;
						}
						this.blit(this.source2, x, y, x, y, w, h);

						// 2nd band
						switch (this.m_direction)
						{
							case CTrans.CENTER_LEFTRIGHT:
								x = this.source1.width / 2 + this.m_rw;
								break;
							case CTrans.LEFTRIGHT_CENTER:
								x = this.source1.width - rw;
								break;
							case CTrans.CENTER_TOPBOTTOM:
								y = this.source1.height / 2 + this.m_rw;
								break;
							case CTrans.TOPBOTTOM_CENTER:
								y = this.source1.height - rw;
								break;
						}
						this.blit(this.source2, x, y, x, y, w, h);
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransFade()
	{
	}
	CTransFade.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time? create surface
				if (this.m_starting)
				{
					this.m_starting = false;
				}

				var fadeCoef;

				// Fade in
				if ((flag & CTrans.TRFLAG_FADEIN) != 0)
				{
					this.destContext.globalAlpha = 1.0;
					this.blit(this.source1);
					fadeCoef = this.getDeltaTime() / this.m_duration;
					this.destContext.globalAlpha = fadeCoef;
					this.blit(this.source2);
				}
				// Fade out
				else
				{
					this.destContext.globalAlpha = 1.0;
					this.blit(this.source1);
					fadeCoef = this.getDeltaTime() / this.m_duration;
					this.destContext.globalAlpha = fadeCoef;
					this.blit(this.source2);
				}
				return null;
			},
			end:      function ()
			{
				this.destContext.globalAlpha = 1.0;
				this.finish();
			}
		});


	function CTransLine()
	{
		this.dwPos = 0;
		this.dwStyle = 0;
		this.dwScrolling = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
	}
	CTransLine.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwPos = file.readAInt();
				this.dwStyle = file.readAInt();
				this.dwScrolling = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);      // completed
				}
				else
				{
					var x, y, w, h;
					var i = 0;		// Loop
					var j = 0;		// Loop
					var linesize = 0;

					// Horizontal
					if (this.dwStyle == 0)
					{
						linesize = this.m_source2Height / this.dwPos;
						for (i = 0; i < this.dwPos; i++)
						{
							if (j == 0)
							{
								x = 0;
								y = (i * linesize);
								w = this.m_source2Width * elapsedTime / this.m_duration;

								// Last
								if (i == this.dwPos - 1)
									h = this.m_source2Height;
								else
									h = (linesize + 1.0);

								// Without scrolling or with scrolling
								if (this.dwScrolling == 0)
									this.blit(this.source2, x, y, x, y, w, h);
								else
									this.blit(this.source2, x, y, this.m_source2Width - w, y, w, h);

								j = 1;
							}
							else
							{
								y = (i * linesize);//h;
								w = this.m_source2Width * elapsedTime / this.m_duration;
								x = this.m_source2Width - w;

								// Last
								if (i == this.dwPos - 1)
									h = this.m_source2Height;
								else
									h = (linesize + 1.0);

								// Without scrolling or with scrolling
								if (this.dwScrolling == 0)
									this.blit(this.source2, x, y, x, y, w, h);
								else
									this.blit(this.source2, x, y, 0, y, w, h);

								j = 0;
							}
						}
					}
					// Vertical
					else
					{
						linesize = this.m_source2Width / this.dwPos;
						for (i = 0; i < this.dwPos; i++)
						{
							if (j == 0)
							{
								x = (i * linesize);
								y = 0;
								h = this.m_source2Height * elapsedTime / this.m_duration;

								// Last
								if (i == this.dwPos - 1)
									w = this.m_source2Width;
								else
									w = (linesize + 1);

								// Without scrolling or with scrolling
								if (this.dwScrolling == 0)
									this.blit(this.source2, x, y, x, y, w, h);
								else
									this.blit(this.source2, x, y, x, this.m_source2Height - h, w, h);

								j = 1;
							}
							else
							{
								x = (i * linesize);
								h = this.m_source2Height * elapsedTime / this.m_duration;
								y = this.m_source2Height - h;

								// Last
								if (i == this.dwPos - 1)
									w = this.m_source2Width;
								else
									w = (linesize + 1);

								// Without scrolling or with scrolling
								if (this.dwScrolling == 0)
									this.blit(this.source2, x, y, x, y, w, h);
								else
									this.blit(this.source2, x, y, x, 0, w, h);
								j = 0;
							}
						}
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransMosaic()
	{
		// Parameters
		this.m_spotPercent;

		// Runtime
		this.m_spotSize = 0;
		this.m_nbBlockPerLine = 0;
		this.m_nbBlockPerCol = 0;
		this.m_nbBlocks = 0;
		this.m_lastNbBlocks = 0;
		this.m_bitbuf = null;
	}
	CTransMosaic.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.m_spotPercent = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time? create surface
				if (this.m_starting)
				{
					var sw = this.source1.width;
					var sh = this.source1.height;

					// Spot size: voir si ca rend bien
					this.m_spotSize = Math.floor(((sw * this.m_spotPercent / 100) + (sh * this.m_spotPercent / 100)) / 2);
					if (this.m_spotSize == 0)
						this.m_spotSize = 1;

					// Calcul buffer bits
					var bufSize;
					this.m_nbBlockPerLine = ((sw + this.m_spotSize - 1) / this.m_spotSize);
					this.m_nbBlockPerCol = ((sh + this.m_spotSize - 1) / this.m_spotSize);
					this.m_nbBlocks = this.m_nbBlockPerLine * this.m_nbBlockPerCol;
					bufSize = Math.floor((this.m_nbBlocks + 7) / 8 + 2);	// 2 = security
					this.m_lastNbBlocks = 0;
					this.m_bitbuf = new Array(bufSize);
					var n;
					for (n = 0; n < bufSize; n++)
						this.m_bitbuf[n] = 0;
					this.m_starting = false;
				}

				if (this.m_bitbuf == null || this.m_nbBlockPerLine < 2 || this.m_nbBlockPerCol < 2 || this.m_duration == 0)
					this.blit(this.source2);	// termine
				else
				{
					var NB_TRIES = 1;
					var i;
					var l, xb = 0, yb = 0;
					var nbBlocks = Math.floor(this.m_nbBlocks * this.getDeltaTime() / this.m_duration);
					var nbCurrentBlocks = nbBlocks - this.m_lastNbBlocks;
					if (nbCurrentBlocks != 0)
					{
						this.m_lastNbBlocks = nbBlocks;
						for (l = 0; l < nbCurrentBlocks; l++)
						{
							// Get random block coordinates
							for (i = 0; i < NB_TRIES; i++)
							{
								xb = Math.floor(this.m_nbBlockPerLine * Math.random());
								yb = Math.floor(this.m_nbBlockPerCol * Math.random());

								var nb, off;
								var mask;

								nb = yb * this.m_nbBlockPerLine + xb;
								off = Math.floor(nb / 8);
								mask = (1 << (nb & 7));
								if ((this.m_bitbuf[off] & mask) == 0)
								{
									this.m_bitbuf[off] |= mask;
									break;
								}

								var pBuf = off;
								var nbb = (this.m_nbBlocks + 7) / 8;
								var b;
								var r = false;
								for (b = off; b < nbb; b++, pBuf++)
								{
									if (this.m_bitbuf[pBuf] != -1)
									{
										yb = Math.floor((b * 8) / this.m_nbBlockPerLine);
										xb = Math.floor((b * 8) % this.m_nbBlockPerLine);
										for (mask = 1; mask != 0; mask <<= 1)
										{
											if ((this.m_bitbuf[pBuf] & mask) == 0)
											{
												this.m_bitbuf[pBuf] |= mask;
												r = true;
												break;
											}
											if (++xb >= this.m_nbBlockPerLine)
											{
												xb = 0;
												if (++yb >= this.m_nbBlockPerCol)
													break;
											}
										}
										if (r)
											break;
									}
								}
								if (r)
									break;

								pBuf = 0;
								for (b = 0; b < off; b++, pBuf++)
								{
									if (this.m_bitbuf[pBuf] != 255)
									{
										yb = Math.floor((b * 8) / m_nbBlockPerLine);
										xb = Math.floor((b * 8) % m_nbBlockPerLine);
										for (mask = 1; mask != 0; mask <<= 1)
										{
											if ((this.m_bitbuf[pBuf] & mask) == 0)
											{
												this.m_bitbuf[pBuf] |= mask;
												r = true;
												break;
											}
											if (++xb >= this.m_nbBlockPerLine)
											{
												xb = 0;
												if (++yb >= this.m_nbBlockPerCol)
													break;
											}
										}
										if (r)
											break;
									}
									if (r)
										break;

									r = false;
								}
							}
							if (i < NB_TRIES)
							{
								this.blit(this.source2, Math.floor(xb * this.m_spotSize), Math.floor(yb * this.m_spotSize), Math.floor(xb * this.m_spotSize), Math.floor(yb * this.m_spotSize), this.m_spotSize, this.m_spotSize);
							}
						}
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransOpen()
	{
		this.dwStyle = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
	}
	CTransOpen.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
				}

				var elapsedTime = this.getDeltaTime();

				var pourcentage = elapsedTime / this.m_duration;

				if (pourcentage > 1.0)
				{
					this.blit(this.source2);					// completed
				}
				else
				{
					var x, y, w, h;
					if (pourcentage < 0.25)
					{
						w = this.m_source2Width * 2 * elapsedTime / this.m_duration;
						w *= 2;
						h = this.m_source2Height / 7;
						x = this.m_source2Width / 2 - w / 2;
						y = this.m_source2Height / 2 - h / 2;
						this.blit(this.source2, x, y, x, y, w, h);

						w = this.m_source2Width / 7;
						h = this.m_source2Height * 2 * elapsedTime / this.m_duration;
						h *= 2;
						x = this.m_source2Width / 2 - w / 2;
						y = this.m_source2Height / 2 - h / 2;
						this.blit(this.source2, x, y, x, y, w, h);
					}
					else
					{
						x = this.m_source2Width / 2;
						w = this.m_source2Width * elapsedTime / this.m_duration - x;
						h = this.m_source2Height / 2;
						y = 0;
						this.blit(this.source2, x, y, x, y, w, h);

						y = this.m_source2Height / 2;
						h = this.m_source2Height * elapsedTime / this.m_duration - y;
						w = this.m_source2Width / 2;
						x = w;
						this.blit(this.source2, x, y, x, y, w, h);

						w = this.m_source2Width * elapsedTime / this.m_duration - this.m_source2Width / 2;
						x = this.m_source2Width / 2 - w;
						h = this.m_source2Height / 2;
						y = h;
						this.blit(this.source2, x, y, x, y, w, h);

						h = this.m_source2Height * elapsedTime / this.m_duration - this.m_source2Height / 2;
						y = this.m_source2Height / 2 - h;
						w = this.m_source2Width / 2;
						x = 0;
						this.blit(this.source2, x, y, x, y, w, h);
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransPush()
	{
		this.dwStyle = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
		this.m_refresh = 0;
	}
	CTransPush.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
					this.m_refresh = false;
				}

				var elapsedTime = this.getDeltaTime();

				var pourcentage = elapsedTime / this.m_duration;
				if (pourcentage > 1.0)
				{
					this.blit(this.source2);
				}
				else
				{
					var x, y, w, h;

					// First Scrolling
					if (pourcentage <= 0.5)
					{
						switch (this.dwStyle)
						{
							case 0:
								w = this.m_source2Width * elapsedTime / this.m_duration * 2;
								h = this.m_source2Height / 2;
								x = this.m_source2Width - w;
								y = this.m_source2Height / 2;
								this.blit(this.source2, 0, 0, x, y, w, h);
								break;
							case 1:
								w = this.m_source2Width * elapsedTime / this.m_duration * 2;
								h = this.m_source2Height / 2;
								x = this.m_source2Width - w;
								y = this.m_source2Height / 2;
								this.blit(this.source2, x, 0, 0, y, w, h);
								break;
							case 2:
								w = this.m_source2Width * elapsedTime / this.m_duration * 2;
								h = this.m_source2Height / 2;
								x = this.m_source2Width - w;
								y = this.m_source2Height / 2;
								this.blit(this.source2, 0, y, x, 0, w, h);
								break;
							case 3:
								w = this.m_source2Width * elapsedTime / this.m_duration * 2;
								h = this.m_source2Height / 2;
								x = this.m_source2Width - w;
								y = this.m_source2Height / 2;
								this.blit(this.source2, x, y, 0, 0, w, h);
								break;
						}
					}

					// Second Scrolling
					if (pourcentage > 0.5)
					{
						if (this.m_refresh == false)
						{
							if (this.dwStyle <= 1)
								this.blit(this.source2, 0, 0, 0, this.m_source2Height / 2, this.m_source2Width, this.m_source2Height / 2);
							else
								this.blit(this.source2, 0, this.m_source2Height / 2, 0, 0, this.m_source2Width, this.m_source2Height / 2);
							this.m_refresh = true;
						}

						pourcentage = elapsedTime - this.m_duration / 2.0;
						pourcentage /= this.m_duration / 2.0;
						pourcentage *= 1000;
						h = this.m_source2Height / 2 * pourcentage / 1000; // Math.floor()?

						switch (this.dwStyle)
						{
							case 0:
							case 1:
								this.stretch(this.source2, 0, h, this.m_source2Width, this.m_source2Height / 2, 0, this.m_source2Height / 2, this.m_source2Width, this.m_source2Height / 2);
								this.stretch(this.source2, 0, 0, this.m_source2Width, h, 0, this.m_source2Height / 2 - h, this.m_source2Width, h);
								break;
							case 2:
							case 3:
								this.stretch(this.source2, 0, this.m_source2Height / 2 - h, this.m_source2Width, this.m_source2Height / 2, 0, 0, this.m_source2Width, this.m_source2Height / 2);
								this.stretch(this.source2, 0, this.m_source2Height - h, this.m_source2Width, h, 0, this.m_source2Height / 2, this.m_source2Width, h);
								break;
						}
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransScroll()
	{
		this.m_direction;
		this.m_wbande;
		this.m_rw;
	}
	CTransScroll.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.m_direction = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				var sw = this.source1.width;
				var sh = this.source1.height;

				// 1st time? create surface
				if (this.m_starting)
				{
					switch (this.m_direction)
					{
						case CTrans.LEFT_RIGHT:
						case CTrans.RIGHT_LEFT:
							this.m_wbande = sw;
							break;
						default:
							this.m_wbande = sh;
							break;
					}
					this.m_rw = 0;
					this.m_starting = false;
				}

				if (this.m_duration == 0)
					this.blit(this.source2);  // termine
				else
				{
					var rw = this.m_wbande * this.getDeltaTime() / this.m_duration;
					if (rw > this.m_rw)
					{
						var x = 0, y = 0;

						switch (this.m_direction)
						{
							case CTrans.LEFT_RIGHT:
								x = rw - sw;
								y = 0;
								break;
							case CTrans.RIGHT_LEFT:
								x = sw - rw;
								y = 0;
								break;
							case CTrans.TOP_BOTTOM:
								x = 0;
								y = rw - sh;
								break;
							case CTrans.BOTTOM_TOP:
								x = 0;
								y = sh - rw;
								break;
						}
						this.blit(this.source2, x, y, 0, 0, sw, sh);
						this.m_rw = rw;
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransSquare()
	{
		this.dwStyle = 0;
		this.dwPos = 0;
		this.dwStretch = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
	}
	CTransSquare.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.dwPos = file.readAInt();
				this.dwStretch = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
				}

				var elapsedTime = this.getDeltaTime();

				if (elapsedTime / this.m_duration > 1.0)
				{
					this.blit(this.source2);													// completed
				}
				else
				{
					var x, y, w, h;
					var width, height;

					// Inside Square
					/////////////////

					width = this.m_source2Width * this.dwPos / 100;
					height = this.m_source2Height * this.dwPos / 100;

					w = width * elapsedTime / this.m_duration;
					h = height * elapsedTime / this.m_duration;
					x = this.m_source2Width / 2 - w / 2;
					y = this.m_source2Height / 2 - h / 2;

					// No Stretch
					if (this.dwStretch == 0)
						this.blit(this.source2, x, y, x, y, w, h);
					else
						this.stretch(this.source2, x, y, w, h, this.m_source2Width / 2 - width / 2, this.m_source2Height / 2 - height / 2, width, height);

					// Outside Square
					//////////////////

					var pos = 100 - this.dwPos;
					width = this.m_source2Width * pos / 100;
					height = this.m_source2Height * pos / 100;

					w = width / 2 * elapsedTime / this.m_duration;
					h = height / 2 * elapsedTime / this.m_duration;
					this.blit(this.source2, 0, 0, 0, 0, this.m_source2Width, h);									// Up To Down
					this.blit(this.source2, 0, 0, 0, 0, w, this.m_source2Height);									// Left to Right
					this.blit(this.source2, 0, this.m_source2Height - h, 0, this.m_source2Height - h, this.m_source2Width, h);	// Down To Up
					this.blit(this.source2, this.m_source2Width - w, 0, this.m_source2Width - w, 0, w, this.m_source2Height);	// Right To Left
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransStretch()
	{
		this.dwStyle = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
	}
	CTransStretch.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);					// completed
				}
				else
				{
					var w, h;

					switch (this.dwStyle)
					{
						// Top Left
						case 0:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.stretch(this.source2, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
						// Top Right
						case 1:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.stretch(this.source2, this.m_source2Width - w, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
						// Bottom Left
						case 2:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.stretch(this.source2, 0, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
						// Bottom Right
						case 3:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.stretch(this.source2, this.m_source2Width - w, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
						// 4 corners
						case 4:
							// Top Left
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							if (h < 5)
								h = 5;
							this.stretch(this.source2, 0, 0, w, h, 0, 0, this.source1.width / 2, this.source1.height / 2);
							// Top Right
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							if (h < 5)
								h = 5;
							this.stretch(this.source2, this.m_source2Width - w, 0, w, h, this.m_source2Width / 2, 0, this.m_source2Width / 2, this.m_source2Height / 2);
							// Bottom Left
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.stretch(this.source2, 0, this.m_source2Height - h, w, h, 0, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);
							// Bottom Right
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.stretch(this.source2, this.m_source2Width - w, this.m_source2Height - h, w, h, this.m_source2Width / 2, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);
							break;
						// Center
						case 5:
							// Top Left
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							if (h < 5)
								h = 5;
							this.stretch(this.source2, this.m_source2Width / 2 - w, this.m_source2Height / 2 - h, w, h, 0, 0, this.source1.width / 2, this.source1.height / 2);
							// Top Right
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							if (h < 5)
								h = 5;
							this.stretch(this.source2, this.m_source2Width / 2, this.m_source2Height / 2 - h, w, h, this.m_source2Width / 2, 0, this.m_source2Width / 2, this.m_source2Height / 2);
							// Bottom Left
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.stretch(this.source2, this.m_source2Width / 2 - w, this.m_source2Height / 2, w, h, 0, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);
							// Bottom Right
							w = this.m_source2Width / 2 * elapsedTime / this.m_duration;
							h = this.m_source2Height / 2 * elapsedTime / this.m_duration;
							this.stretch(this.source2, this.m_source2Width / 2, this.m_source2Height / 2, w, h, this.m_source2Width / 2, this.m_source2Height / 2, this.m_source2Width / 2, this.m_source2Height / 2);
							break;
						// Top Middle
						case 6:
							w = this.m_source2Width;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.stretch(this.source2, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
						// Middle Left
						case 7:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.stretch(this.source2, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
						// Middle Right
						case 8:
							w = this.m_source2Width * elapsedTime / this.m_duration;
							h = this.m_source2Height;
							this.stretch(this.source2, this.m_source2Width - w, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
						// Bottom Middle
						case 9:
							w = this.m_source2Width;
							h = this.m_source2Height * elapsedTime / this.m_duration;
							this.stretch(this.source2, 0, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							break;
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransStretch2()
	{
		this.dwStyle = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
		this.m_phase = 0;
	}
	CTransStretch2.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
					this.m_phase = 0;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);					// completed
				}
				else
				{
					var w, h;

					switch (this.dwStyle)
					{
						// Top Left
						case 0:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;

								this.stretch(this.source1, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								this.stretch(this.source2, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Top Middle
						case 1:
							if (this.m_phase == 0)
							{
								w = this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;

								this.stretch(this.source1, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								this.stretch(this.source2, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Top Right
						case 2:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;

								this.stretch(this.source1, this.m_source2Width - w, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								this.stretch(this.source2, this.m_source2Width - w, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Middle Left
						case 3:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = this.m_source2Height;

								this.stretch(this.source1, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = this.m_source2Height;
								this.stretch(this.source2, 0, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Center H
						case 4:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = this.m_source2Height;

								this.stretch(this.source1, this.m_source2Width / 2 - w / 2, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = this.m_source2Height;
								this.stretch(this.source2, this.m_source2Width / 2 - w / 2, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Center V
						case 5:
							if (this.m_phase == 0)
							{
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;
								w = this.m_source2Width;

								this.stretch(this.source1, 0, this.m_source2Height / 2 - h / 2, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								w = this.m_source2Width;
								this.stretch(this.source2, 0, this.m_source2Height / 2 - h / 2, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Center H+V
						case 6:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;

								this.stretch(this.source1, this.m_source2Width / 2 - w / 2, this.m_source2Height / 2 - h / 2, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								this.stretch(this.source2, this.m_source2Width / 2 - w / 2, this.m_source2Height / 2 - h / 2, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Middle Right
						case 7:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = this.m_source2Height;

								this.stretch(this.source1, this.m_source2Width - w, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = this.m_source2Height;
								this.stretch(this.source2, this.m_source2Height - w, 0, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Bottom Left
						case 8:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;

								this.stretch(this.source1, 0, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								this.stretch(this.source2, 0, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Bottom Middle
						case 9:
							if (this.m_phase == 0)
							{
								w = this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;

								this.stretch(this.source1, 0, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								this.stretch(this.source2, 0, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
						// Bottom Right
						case 10:
							if (this.m_phase == 0)
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w = this.m_source2Width - w;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h = this.m_source2Height - h;

								this.stretch(this.source1, this.m_source2Width - w, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);

								if (elapsedTime >= this.m_duration / 2)
									this.m_phase = 1;
							}
							else
							{
								w = 2 * this.m_source2Width * elapsedTime / this.m_duration;
								w -= this.m_source2Width;
								h = 2 * this.m_source2Height * elapsedTime / this.m_duration;
								h -= this.m_source2Height;
								this.stretch(this.source2, this.m_source2Width - w, this.m_source2Height - h, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
							}
							break;
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransTrame()
	{
		this.dwStyle = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
		this.m_index = 0;
		this.m_index2 = 0;
	}
	CTransTrame.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
					this.m_index = 0;
					this.m_index2 = 0;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);					// completed
				}
				else
				{
					var w, h, i, j, k;

					h = this.m_source2Height * elapsedTime / this.m_duration;
					w = this.m_source2Width * elapsedTime / this.m_duration;

					if (this.dwStyle == 0)
					{
						k = h % 2;
						for (i = 0; i < this.m_source2Width; i += 2)
						{
							for (j = this.m_index; j < h; j++)
							{
								this.blit(this.source2, i, j, i, j, 1, 1);
							}
							for (j = this.m_source2Height - h - k; j < this.m_source2Height - this.m_index; j++)
							{
								this.blit(this.source2, i + 1, j + 1, i + 1, j + 1, 1, 1);
							}
						}
						if (h % 2 == 0)
							this.m_index = h;
						else
							this.m_index = h - 1;
					}

					if (this.dwStyle == 1)
					{
						k = w % 2;
						for (j = 0; j < this.m_source2Height; j++)
						{
							for (i = this.m_index2; i < w; i += 2)
							{
								this.blit(this.source2, i + 1, j, i + 1, j, 1, 1);
							}
							for (i = this.m_source2Width - w - k; i < this.m_source2Width - this.m_index2; i += 2)
							{
								this.blit(this.source2, i, j + 1, i, j + 1, 1, 1);
							}
						}
						if (w % 2 == 0)
							this.m_index2 = w;
						else
							this.m_index2 = w - 1;
					}

					if (this.dwStyle == 2)
					{
						k = h % 2;
						for (i = 0; i < this.m_source2Width; i += 2)
						{
							for (j = this.m_index; j < h; j += 2)
							{
								this.blit(this.source2, i, j, i, j, 1, 1);
							}
							for (j = this.m_source2Height - h - k; j < this.m_source2Height - this.m_index; j += 2)
							{
								this.blit(this.source2, i + 1, j + 1, i + 1, j + 1, 1, 1);
							}
						}

						k = w % 2;
						for (j = 0; j < this.m_source2Height; j += 2)
						{
							for (i = this.m_index2; i < w; i += 2)
							{
								this.blit(this.source2, i + 1, j, i + 1, j, 1, 1);
							}
							for (i = this.m_source2Width - w - k; i < this.m_source2Width - this.m_index2; i += 2)
							{
								this.blit(this.source2, i, j + 1, i, j + 1, 1, 1);
							}
						}
						if (h % 2 == 0)
							this.m_index = h;
						else
							this.m_index = h - 1;
						if (w % 2 == 0)
							this.m_index2 = w;
						else
							this.m_index2 = w - 1;
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransTurn()
	{
		this.dwPos = 0;
		this.dwCheck1 = 0;
		this.dwCheck2 = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
		this.m_angle = 0;
	}
	CTransTurn.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwPos = file.readAInt();
				this.dwCheck1 = file.readAInt();
				this.dwCheck2 = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
					this.m_angle = 0.0;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);			// completed
				}
				else
				{
					var x, y, w, h;
					var dist, xcenter, ycenter;

					xcenter = this.m_source2Width / 2;
					ycenter = this.m_source2Height / 2;

					this.m_angle = this.dwPos * 6.28318 * elapsedTime / this.m_duration;

					// Inverse ?
					if (this.dwCheck2 == 1)
					{
						this.m_angle = 6.28318 - this.m_angle;
					}

					dist = this.m_source2Width / 2 - this.m_source2Width / 2 * elapsedTime / this.m_duration;
					x = Math.floor(xcenter + Math.cos(this.m_angle) * dist);
					y = Math.floor(ycenter + Math.sin(this.m_angle) * dist);

					w = this.m_source2Width * elapsedTime / this.m_duration;
					h = this.m_source2Height * elapsedTime / this.m_duration;

					this.stretch(this.source1, 0, 0, this.m_source2Width, this.m_source2Height, 0, 0, this.source1.width, this.source1.height);

					// Full Image ?
					if (this.wCheck1 == 1)
						this.stretch(this.source2, x - w / 2, y - h / 2, w, h, 0, 0, this.m_source2Width, this.m_source2Height);
					else
						this.stretch(this.source2, x - w / 2, y - h / 2, w, h, this.m_source2Width - w, this.m_source2Height - h, w, h);
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransTurn2()
	{
		this.dwPos = 0;
		this.dwCheck1 = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
		this.m_curcircle = 0;
	}
	CTransTurn2.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwPos = file.readAInt();
				this.dwCheck1 = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
					this.m_curcircle = 0;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);				// completed
				}
				else
				{
					var x, y, xcenter, ycenter, dist;
					var angle = 0.0;

					xcenter = this.m_source2Width / 2;
					ycenter = this.m_source2Height / 2;

					angle = this.dwPos * 6.28318 * elapsedTime / this.m_duration;
					angle -= this.m_curcircle * 6.28318;
					if (this.dwCheck1 == 1)
						angle = 6.28318 - angle;

					dist = this.m_source2Width * elapsedTime / this.m_duration;
					x = Math.floor(xcenter + Math.cos(angle) * dist);
					y = Math.floor(ycenter + Math.sin(angle) * dist);

					this.blit(this.source2);
					this.blit(this.source1, x - this.m_source2Width / 2, y - this.m_source2Height / 2, 0, 0, this.m_source2Width, this.m_source2Height);

					if (this.dwCheck1 == 0)
					{
						if (angle >= 6.28318)
							this.m_curcircle++;
					}
					else
					{
						if (angle <= 0)
							this.m_curcircle++;
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransZigZag()
	{
		this.zpSpotPercent = 0;
		this.zpStartPoint = 0;
		this.zpDirection = 0;
		this.m_spotSize = 0;
		this.m_nbBlockPerLine = 0;
		this.m_nbBlockPerCol = 0;
		this.m_nbBlocks = 0;
		this.m_lastNbBlocks = 0;
		this.m_curx = 0;
		this.m_cury = 0;
		this.m_currentDirection = 0;
		this.m_currentStartPoint = 0;
		this.m_left = 0;
		this.m_top = 0;
		this.m_right = 0;
		this.m_bottom = 0;
	}
	CTransZigZag.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.zpSpotPercent = file.readAInt();
				this.zpStartPoint = file.readAShort();
				this.zpDirection = file.readAShort();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				var sw = this.source1.width;
				var sh = this.source1.height;

				// 1st time? create surface
				if (this.m_starting)
				{
					// Spot size: voir si ca rend bien
					this.m_spotSize = Math.floor(((sw * this.zpSpotPercent / 100) + (sh * this.zpSpotPercent / 100)) / 2);
					if (this.m_spotSize == 0)
						this.m_spotSize = 1;

					this.m_nbBlockPerLine = ((sw + this.m_spotSize - 1) / this.m_spotSize);
					this.m_nbBlockPerCol = ((sh + this.m_spotSize - 1) / this.m_spotSize);

					// Start point
					this.m_currentDirection = this.zpDirection;
					this.m_currentStartPoint = this.zpStartPoint;

					switch (this.zpStartPoint)
					{
						case CTrans.TOP_LEFT:
							this.m_curx = this.m_cury = 0;
							break;
						case CTrans.TOP_RIGHT:
							this.m_curx = sw - this.m_spotSize;
							this.m_cury = 0;
							break;
						case CTrans.BOTTOM_LEFT:
							this.m_curx = 0;
							this.m_cury = sh - this.m_spotSize;
							break;
						case CTrans.BOTTOM_RIGHT:
							this.m_curx = sw - this.m_spotSize;
							this.m_cury = sh - this.m_spotSize;
							break;
						case CTrans.CENTER:
							this.m_curx = sw / 2 - this.m_spotSize;
							this.m_cury = sh / 2 - this.m_spotSize;
							if (this.m_currentDirection == CTrans.DIR_HORZ)
								this.m_currentStartPoint = CTrans.TOP_LEFT;
							else
								this.m_currentStartPoint = CTrans.TOP_RIGHT;
							this.m_left = this.m_curx - this.m_spotSize;
							this.m_top = this.m_cury - this.m_spotSize;
							this.m_bottom = this.m_cury + this.m_spotSize * 2;
							this.m_right = this.m_curx + this.m_spotSize * 2;

							this.m_nbBlockPerLine = 2 + 2 * (this.m_curx + this.m_spotSize - 1) / this.m_spotSize;
							this.m_nbBlockPerCol = 2 + 2 * (this.m_cury + this.m_spotSize - 1) / this.m_spotSize;
							break;
					}
					this.m_nbBlocks = Math.floor(this.m_nbBlockPerLine * this.m_nbBlockPerCol);
					this.m_lastNbBlocks = 0;
					this.m_starting = false;
				}

				if (this.m_spotSize >= sw || this.m_spotSize >= sh)
					this.blit(this.source2);	// termine
				else
				{
					// Compute number of spots to display in 1 step
					var l;
					var nbBlocks = Math.floor(this.m_nbBlocks * this.getDeltaTime() / this.m_duration);
					var nbCurrentBlocks = nbBlocks - this.m_lastNbBlocks;
					if (nbCurrentBlocks != 0)
					{
						this.m_lastNbBlocks = nbBlocks;
						for (l = 0; l < nbCurrentBlocks; l++)
						{
							// Blit current spot
							this.blit(this.source2, this.m_curx, this.m_cury, this.m_curx, this.m_cury, this.m_spotSize, this.m_spotSize);

							// Increment spot coordinates
							if (this.zpStartPoint == CTrans.CENTER)
							{
								switch (this.m_currentStartPoint)
								{
									case CTrans.TOP_LEFT:
										this.m_curx += this.m_spotSize;
										if (this.m_curx >= this.m_right)
										{
											this.m_curx -= this.m_spotSize;
											this.m_cury += this.m_spotSize;
											this.m_currentStartPoint = CTrans.TOP_RIGHT;
											this.m_right += this.m_spotSize;
										}
										break;
									case CTrans.TOP_RIGHT:
										this.m_cury += this.m_spotSize;
										if (this.m_cury >= this.m_bottom)
										{
											this.m_cury -= this.m_spotSize;
											this.m_curx -= this.m_spotSize;
											this.m_currentStartPoint = CTrans.BOTTOM_RIGHT;
											this.m_bottom += this.m_spotSize;
										}
										break;
									case CTrans.BOTTOM_RIGHT:
										this.m_curx -= this.m_spotSize;
										if ((this.m_curx + this.m_spotSize) <= this.m_left)
										{
											this.m_curx += this.m_spotSize;
											this.m_cury -= this.m_spotSize;
											this.m_currentStartPoint = CTrans.BOTTOM_LEFT;
											this.m_left -= this.m_spotSize;
										}
										break;
									case CTrans.BOTTOM_LEFT:
										this.m_cury -= this.m_spotSize;
										if ((this.m_cury + this.m_spotSize) <= this.m_top)
										{
											this.m_cury += this.m_spotSize;
											this.m_curx += this.m_spotSize;
											this.m_currentStartPoint = CTrans.TOP_LEFT;
											this.m_top -= this.m_spotSize;
										}
										break;
								}
							}
							else
							{
								switch (this.m_currentDirection)
								{
									// Horizontal
									case CTrans.DIR_HORZ:
										switch (this.m_currentStartPoint)
										{
											case CTrans.TOP_LEFT:
												this.m_curx += this.m_spotSize;
												if (this.m_curx >= sw)
												{
													this.m_curx -= this.m_spotSize;
													this.m_cury += this.m_spotSize;
													this.m_currentStartPoint = CTrans.TOP_RIGHT;
												}
												break;
											case CTrans.TOP_RIGHT:
												this.m_curx -= this.m_spotSize;
												if ((this.m_curx + this.m_spotSize) <= 0)
												{
													this.m_curx += this.m_spotSize;
													this.m_cury += this.m_spotSize;
													this.m_currentStartPoint = CTrans.TOP_LEFT;
												}
												break;
											case CTrans.BOTTOM_LEFT:
												this.m_curx += this.m_spotSize;
												if (this.m_curx >= sw)
												{
													this.m_curx -= this.m_spotSize;
													this.m_cury -= this.m_spotSize;
													this.m_currentStartPoint = CTrans.BOTTOM_RIGHT;
												}
												break;
											case CTrans.BOTTOM_RIGHT:
												this.m_curx -= this.m_spotSize;
												if ((this.m_curx + this.m_spotSize) <= 0)
												{
													this.m_curx += this.m_spotSize;
													this.m_cury -= this.m_spotSize;
													this.m_currentStartPoint = CTrans.BOTTOM_LEFT;
												}
												break;
										}
										break;

									// Vertical
									case CTrans.DIR_VERT:
										switch (this.m_currentStartPoint)
										{
											case CTrans.TOP_LEFT:
												this.m_cury += this.m_spotSize;
												if (this.m_cury >= sh)
												{
													this.m_cury -= this.m_spotSize;
													this.m_curx += this.m_spotSize;
													this.m_currentStartPoint = CTrans.BOTTOM_LEFT;
												}
												break;
											case CTrans.TOP_RIGHT:
												this.m_cury += this.m_spotSize;
												if (this.m_cury >= sh)
												{
													this.m_cury -= this.m_spotSize;
													this.m_curx -= this.m_spotSize;
													this.m_currentStartPoint = CTrans.BOTTOM_RIGHT;
												}
												break;
											case CTrans.BOTTOM_LEFT:
												this.m_cury -= this.m_spotSize;
												if ((this.m_cury + this.m_spotSize) <= 0)
												{
													this.m_cury += this.m_spotSize;
													this.m_curx += this.m_spotSize;
													this.m_currentStartPoint = CTrans.TOP_LEFT;
												}
												break;
											case CTrans.BOTTOM_RIGHT:
												this.m_cury -= this.m_spotSize;
												if ((this.m_cury + this.m_spotSize) <= 0)
												{
													this.m_cury += this.m_spotSize;
													this.m_curx -= this.m_spotSize;
													this.m_currentStartPoint = CTrans.TOP_RIGHT;
												}
												break;
										}
										break;
								}
							}
						}
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransZigZag2()
	{
		this.dwStyle = 0;
		this.dwPos = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
		this.m_linepos = 0;
		this.m_dir = 0;
	}
	CTransZigZag2.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwStyle = file.readAInt();
				this.dwPos = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
					this.m_linepos = 0;
					this.m_dir = 0;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);					// completed
				}
				else
				{
					var x, y, w, h;
					var nb = 0.0;

					if (this.dwStyle == 0)
					{
						nb = this.m_source2Height / this.dwPos;

						// TOP
						h = Math.floor(this.m_linepos * nb) + Math.floor(nb);
						y = 0;
						w = this.m_source2Width * elapsedTime / this.m_duration;
						w = w * this.dwPos / 2;
						w -= this.m_source2Width * this.m_linepos;
						if (this.m_dir == 0)
							x = 0;
						else
							x = this.m_source2Width - w;
						this.blit(this.source2, x, y, x, y, w, h);

						// BOTTOM
						y = this.m_source2Height - h;
						if (this.m_dir == 1)
							x = 0;
						else
							x = this.m_source2Width - w;
						this.blit(this.source2, x, y, x, y, w, h);

						// End of line
						if (w >= this.m_source2Width)
						{
							this.m_linepos++;
							this.m_dir++;
							if (this.m_dir == 2)
								this.m_dir = 0;
						}
					}
					else
					{
						nb = this.m_source2Width / this.dwPos;

						// LEFT
						w = Math.floor(this.m_linepos * nb) + Math.floor(nb);
						x = 0;
						h = this.m_source2Height * elapsedTime / this.m_duration;
						h = h * this.dwPos / 2;
						h -= this.m_source2Height * this.m_linepos;
						if (this.m_dir == 0)
							y = 0;
						else
							y = this.m_source2Height - h;
						this.blit(this.source2, x, y, x, y, w, h);

						// RIGHT
						x = this.m_source2Width - w;
						if (this.m_dir == 1)
							y = 0;
						else
							y = this.m_source2Height - h;
						this.blit(this.source2, x, y, x, y, w, h);

						// End of line
						if (h >= this.m_source2Height)
						{
							this.m_linepos++;
							this.m_dir++;
							if (this.m_dir == 2)
								this.m_dir = 0;
						}
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransZoom()
	{
	}
	CTransZoom.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{

				var sw = this.source1.width;
				var sh = this.source1.height;

				// 1st time? 
				if (this.m_starting)
				{
					// Reset m_starting
					this.m_starting = false;
				}

				// Securites
				if (this.m_duration == 0)	// || etc... )
					this.blit(this.source2);
				else
				{
					var nw, nh;
					var deltaTime = this.getDeltaTime();

					// Fade out
					if ((flag & CTrans.TRFLAG_FADEOUT) != 0)
					{
						nw = Math.floor(sw - sw * deltaTime / this.m_duration);
						nh = Math.floor(sh - sh * deltaTime / this.m_duration);

						// Fill background
						this.blit(this.source2);

						// Stretch new image
						this.stretch(this.source1, (sw - nw) / 2, (sh - nh) / 2, nw, nh, 0, 0, sw, sh);
					}

					// Fade in
					else
					{
						nw = Math.floor(sw * deltaTime / this.m_duration);
						nh = Math.floor(sh * deltaTime / this.m_duration);

						// Fill background
						this.blit(this.source1);

						// Stretch new image
						this.stretch(this.source2, (sw - nw) / 2, (sh - nh) / 2, nw, nh, 0, 0, sw, sh);
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});


	function CTransZoom2()
	{
		this.dwPos = 0;
		this.m_source2Width = 0;
		this.m_source2Height = 0;
	}
	CTransZoom2.prototype = CServices.extend(new CTrans(),
		{
			init:     function (data, file, display, source, dest)
			{
				this.dwPos = file.readAInt();
				this.start(data, display, source, dest);
			},
			stepDraw: function (flag)
			{
				// 1st time?
				if (this.m_starting)
				{
					this.m_starting = false;
					this.m_source2Width = this.source2.width;
					this.m_source2Height = this.source2.height;
				}

				var elapsedTime = this.getDeltaTime();

				if ((elapsedTime / this.m_duration) > 1.0)
				{
					this.blit(this.source2);		// completed
				}
				else
				{
					var x, y, w, h;

					if (this.dwPos == 0)
					{
						w = this.m_source2Width * elapsedTime / this.m_duration;
						h = this.m_source2Height * elapsedTime / this.m_duration;
						x = this.m_source2Width / 2 - w / 2;
						y = this.m_source2Height / 2 - h / 2;

						this.stretch(this.source2, 0, 0, this.m_source2Width, this.m_source2Height, x, y, w, h);
					}
					else
					{
						w = this.m_source2Width * elapsedTime / this.m_duration;
						w = this.m_source2Width - w;
						h = this.m_source2Height * elapsedTime / this.m_duration;
						h = this.m_source2Height - h;
						x = this.m_source2Width / 2 - w / 2;
						y = this.m_source2Height / 2 - h / 2;

						this.stretch(this.source1, 0, 0, this.m_source2Width, this.m_source2Height, x, y, w, h);
					}
				}
				return null;
			},
			end:      function ()
			{
				this.finish();
			}
		});
	/**

	 JSZip - A Javascript class for generating and reading zip files
	 <http://stuartk.com/jszip>

	 (c) 2009-2012 Stuart Knightley <stuart [at] stuartk.com>
	 Dual licenced under the MIT license or GPLv3. See LICENSE.markdown.

	 Usage:
	 zip = new JSZip();
	 zip.file("hello.txt", "Hello, World!").file("tempfile", "nothing");
	 zip.folder("images").file("smile.gif", base64Data, {base64: true});
	 zip.file("Xmas.txt", "Ho ho ho !", {date : new Date("December 25, 2007 00:00:01")});
	 zip.remove("tempfile");

	 base64zip = zip.generate();

	 **/

	/**
	 * Representation a of zip file in js
	 * @constructor
	 * @param {String=|ArrayBuffer=|Uint8Array=} data the data to load, if any (optional).
	 * @param {Object=} options the options for creating this objects (optional).
	 */
	var JSZip = function (data, options)
	{
		// object containing the files :
		// {
		//   "folder/" : {...},
		//   "folder/data.txt" : {...}
		// }
		this.files = {};

		// Where we are in the hierarchy
		this.root = "";

		if (data)
		{
			this.load(data, options);
		}
	};

	JSZip.signature = {
		LOCAL_FILE_HEADER:               "\x50\x4b\x03\x04",
		CENTRAL_FILE_HEADER:             "\x50\x4b\x01\x02",
		CENTRAL_DIRECTORY_END:           "\x50\x4b\x05\x06",
		ZIP64_CENTRAL_DIRECTORY_LOCATOR: "\x50\x4b\x06\x07",
		ZIP64_CENTRAL_DIRECTORY_END:     "\x50\x4b\x06\x06",
		DATA_DESCRIPTOR:                 "\x50\x4b\x07\x08"
	};

	// Default properties for a new file
	JSZip.defaults = {
		base64:      false,
		binary:      false,
		dir:         false,
		date:        null,
		compression: null
	};


	JSZip.prototype = (function ()
	{
		/**
		 * A simple object representing a file in the zip file.
		 * @constructor
		 * @param {string} name the name of the file
		 * @param {string} data the data
		 * @param {Object} options the options of the file
		 */
		var ZipObject = function (name, data, options)
		{
			this.name = name;
			this.data = data;
			this.options = options;
		};

		ZipObject.prototype = {
			/**
			 * Return the content as UTF8 string.
			 * @return {string} the UTF8 string.
			 */
			asText:        function ()
			{
				var result = this.data;
				if (result === null || typeof result === "undefined")
				{
					return "";
				}
				if (this.options.base64)
				{
					result = JSZipBase64.decode(result);
				}
				if (this.options.binary)
				{
					result = JSZip.prototype.utf8decode(result);
				}
				return result;
			},
			/**
			 * Returns the binary content.
			 * @return {string} the content as binary.
			 */
			asBinary:      function ()
			{
				var result = this.data;
				if (result === null || typeof result === "undefined")
				{
					return "";
				}
				if (this.options.base64)
				{
					result = JSZipBase64.decode(result);
				}
				if (!this.options.binary)
				{
					result = JSZip.prototype.utf8encode(result);
				}
				return result;
			},
			/**
			 * Returns the content as an Uint8Array.
			 * @return {Uint8Array} the content as an Uint8Array.
			 */
			asUint8Array:  function ()
			{
				return JSZip.utils.string2Uint8Array(this.asBinary());
			},
			/**
			 * Returns the content as an ArrayBuffer.
			 * @return {ArrayBuffer} the content as an ArrayBufer.
			 */
			asArrayBuffer: function ()
			{
				return JSZip.utils.string2Uint8Array(this.asBinary()).buffer;
			}
		};

		/**
		 * Transform an integer into a string in hexadecimal.
		 * @private
		 * @param {number} dec the number to convert.
		 * @param {number} bytes the number of bytes to generate.
		 * @returns {string} the result.
		 */
		var decToHex = function (dec, bytes)
		{
			var hex = "", i;
			for (i = 0; i < bytes; i++)
			{
				hex += String.fromCharCode(dec & 0xff);
				dec = dec >>> 8;
			}
			return hex;
		};

		/**
		 * Merge the objects passed as parameters into a new one.
		 * @private
		 * @param {...Object} var_args All objects to merge.
		 * @return {Object} a new object with the data of the others.
		 */
		var extend = function ()
		{
			var result = {}, i, attr;
			for (i = 0; i < arguments.length; i++)
			{ // arguments is not enumerable in some browsers
				for (attr in arguments[i])
				{
					if (arguments[i].hasOwnProperty(attr) && typeof result[attr] === "undefined")
					{
						result[attr] = arguments[i][attr];
					}
				}
			}
			return result;
		};

		/**
		 * Transforms the (incomplete) options from the user into the complete
		 * set of options to create a file.
		 * @private
		 * @param {Object} o the options from the user.
		 * @return {Object} the complete set of options.
		 */
		var prepareFileAttrs = function (o)
		{
			o = o || {};
			if (o.base64 === true && o.binary == null)
			{
				o.binary = true;
			}
			o = extend(o, JSZip.defaults);
			o.date = o.date || new Date();
			if (o.compression !== null) o.compression = o.compression.toUpperCase();

			return o;
		};

		/**
		 * Add a file in the current folder.
		 * @private
		 * @param {string} name the name of the file
		 * @param {String|ArrayBuffer|Uint8Array} data the data of the file
		 * @param {Object} o the options of the file
		 * @return {Object} the new file.
		 */
		var fileAdd = function (name, data, o)
		{
			// be sure sub folders exist
			var parent = parentFolder(name);
			if (parent)
			{
				folderAdd.call(this, parent);
			}

			o = prepareFileAttrs(o);

			if (o.dir || data === null || typeof data === "undefined")
			{
				o.base64 = false;
				o.binary = false;
				data = null;
			}
			else if (JSZip.support.uint8array && data instanceof Uint8Array)
			{
				o.base64 = false;
				o.binary = true;
				data = JSZip.utils.uint8Array2String(data);
			}
			else if (JSZip.support.arraybuffer && data instanceof ArrayBuffer)
			{
				o.base64 = false;
				o.binary = true;
				var bufferView = new Uint8Array(data);
				data = JSZip.utils.uint8Array2String(bufferView);
			}
			else if (o.binary && !o.base64)
			{
				// optimizedBinaryString == true means that the file has already been filtered with a 0xFF mask
				if (o.optimizedBinaryString !== true)
				{
					// this is a string, not in a base64 format.
					// Be sure that this is a correct "binary string"
					data = JSZip.utils.string2binary(data);
				}
				// we remove this option since it's only relevant here
				delete o.optimizedBinaryString;
			}

			return this.files[name] = new ZipObject(name, data, o);
		};


		/**
		 * Find the parent folder of the path.
		 * @private
		 * @param {string} path the path to use
		 * @return {string} the parent folder, or ""
		 */
		var parentFolder = function (path)
		{
			if (path.slice(-1) == '/')
			{
				path = path.substring(0, path.length - 1);
			}
			var lastSlash = path.lastIndexOf('/');
			return (lastSlash > 0) ? path.substring(0, lastSlash) : "";
		};

		/**
		 * Add a (sub) folder in the current folder.
		 * @private
		 * @param {string} name the folder's name
		 * @return {Object} the new folder.
		 */
		var folderAdd = function (name)
		{
			// Check the name ends with a /
			if (name.slice(-1) != "/")
			{
				name += "/"; // IE doesn't like substr(-1)
			}

			// Does this folder already exist?
			if (!this.files[name])
			{
				// be sure sub folders exist
				var parent = parentFolder(name);
				if (parent)
				{
					folderAdd.call(this, parent);
				}

				fileAdd.call(this, name, null, {dir: true});
			}
			return this.files[name];
		};

		/**
		 * Generate the data found in the local header of a zip file.
		 * Do not create it now, as some parts are re-used later.
		 * @private
		 * @param {Object} file the file to use.
		 * @param {string} utfEncodedFileName the file name, utf8 encoded.
		 * @param {string} compressionType the compression to use.
		 * @return {Object} an object containing header and compressedData.
		 */
		var prepareLocalHeaderData = function (file, utfEncodedFileName, compressionType)
		{
			var useUTF8 = utfEncodedFileName !== file.name,
				data = file.asBinary(),
				o = file.options,
				dosTime,
				dosDate;

			// date
			// @see http://www.delorie.com/djgpp/doc/rbinter/it/52/13.html
			// @see http://www.delorie.com/djgpp/doc/rbinter/it/65/16.html
			// @see http://www.delorie.com/djgpp/doc/rbinter/it/66/16.html

			dosTime = o.date.getHours();
			dosTime = dosTime << 6;
			dosTime = dosTime | o.date.getMinutes();
			dosTime = dosTime << 5;
			dosTime = dosTime | o.date.getSeconds() / 2;

			dosDate = o.date.getFullYear() - 1980;
			dosDate = dosDate << 4;
			dosDate = dosDate | (o.date.getMonth() + 1);
			dosDate = dosDate << 5;
			dosDate = dosDate | o.date.getDate();

			var hasData = data !== null && data.length !== 0;

			compressionType = o.compression || compressionType;
			if (!JSZip.compressions[compressionType])
			{
				throw compressionType + " is not a valid compression method !";
			}

			var compression = JSZip.compressions[compressionType];
			var compressedData = hasData ? compression.compress(data) : '';

			var header = "";

			// version needed to extract
			header += "\x0A\x00";
			// general purpose bit flag
			// set bit 11 if utf8
			header += useUTF8 ? "\x00\x08" : "\x00\x00";
			// compression method
			header += hasData ? compression.magic : JSZip.compressions['STORE'].magic;
			// last mod file time
			header += decToHex(dosTime, 2);
			// last mod file date
			header += decToHex(dosDate, 2);
			// crc-32
			header += hasData ? decToHex(this.crc32(data), 4) : '\x00\x00\x00\x00';
			// compressed size
			header += hasData ? decToHex(compressedData.length, 4) : '\x00\x00\x00\x00';
			// uncompressed size
			header += hasData ? decToHex(data.length, 4) : '\x00\x00\x00\x00';
			// file name length
			header += decToHex(utfEncodedFileName.length, 2);
			// extra field length
			header += "\x00\x00";

			return {
				header:         header,
				compressedData: compressedData
			};
		};


		// return the actual prototype of JSZip
		return {
			/**
			 * Read an existing zip and merge the data in the current JSZip object.
			 * The implementation is in jszip-load.js, don't forget to include it.
			 * @param {String|ArrayBuffer|Uint8Array} stream  The stream to load
			 * @param {Object} options Options for loading the stream.
			 *  options.base64 : is the stream in base64 ? default : false
			 * @return {JSZip} the current JSZip object
			 */
			load: function (stream, options)
			{
				throw new Error("Load method is not defined. Is the file jszip-load.js included ?");
			},

			/**
			 * Filter nested files/folders with the specified function.
			 * @param {Function} search the predicate to use :
			 * function (relativePath, file) {...}
			 * It takes 2 arguments : the relative path and the file.
			 * @return {Array} An array of matching elements.
			 */
			filter: function (search)
			{
				var result = [], filename, relativePath, file, fileClone;
				for (filename in this.files)
				{
					if (!this.files.hasOwnProperty(filename))
					{
						continue;
					}
					file = this.files[filename];
					// return a new object, don't let the user mess with our internal objects :)
					fileClone = new ZipObject(file.name, file.data, extend(file.options));
					relativePath = filename.slice(this.root.length, filename.length);
					if (filename.slice(0, this.root.length) === this.root && // the file is in the current root
						search(relativePath, fileClone))
					{ // and the file matches the function
						result.push(fileClone);
					}
				}
				return result;
			},

			/**
			 * Add a file to the zip file, or search a file.
			 * @param   {string|RegExp} name The name of the file to add (if data is defined),
			 * the name of the file to find (if no data) or a regex to match files.
			 * @param   {String|ArrayBuffer|Uint8Array} data  The file data, either raw or base64 encoded
			 * @param   {Object} o     File options
			 * @return  {JSZip|Object|Array} this JSZip object (when adding a file),
			 * a file (when searching by string) or an array of files (when searching by regex).
			 */
			file: function (name, data, o)
			{
				if (arguments.length === 1)
				{
					if (name instanceof RegExp)
					{
						var regexp = name;
						return this.filter(function (relativePath, file)
						{
							return !file.options.dir && regexp.test(relativePath);
						});
					}
					else
					{ // text
						return this.filter(function (relativePath, file)
						{
							return !file.options.dir && relativePath === name;
						})[0] || null;
					}
				}
				else
				{ // more than one argument : we have data !
					name = this.root + name;
					fileAdd.call(this, name, data, o);
				}
				return this;
			},

			/**
			 * Add a directory to the zip file, or search.
			 * @param   {String|RegExp} arg The name of the directory to add, or a regex to search folders.
			 * @return  {JSZip} an object with the new directory as the root, or an array containing matching folders.
			 */
			folder: function (arg)
			{
				if (!arg)
				{
					return this;
				}

				if (arg instanceof RegExp)
				{
					return this.filter(function (relativePath, file)
					{
						return file.options.dir && arg.test(relativePath);
					});
				}

				// else, name is a new folder
				var name = this.root + arg;
				var newFolder = folderAdd.call(this, name);

				// Allow chaining by returning a new object with this folder as the root
				var ret = this.clone();
				ret.root = newFolder.name;
				return ret;
			},

			/**
			 * Delete a file, or a directory and all sub-files, from the zip
			 * @param {string} name the name of the file to delete
			 * @return {JSZip} this JSZip object
			 */
			remove: function (name)
			{
				name = this.root + name;
				var file = this.files[name];
				if (!file)
				{
					// Look for any folders
					if (name.slice(-1) != "/")
					{
						name += "/";
					}
					file = this.files[name];
				}

				if (file)
				{
					if (!file.options.dir)
					{
						// file
						delete this.files[name];
					}
					else
					{
						// folder
						var kids = this.filter(function (relativePath, file)
						{
							return file.name.slice(0, name.length) === name;
						});
						for (var i = 0; i < kids.length; i++)
						{
							delete this.files[kids[i].name];
						}
					}
				}

				return this;
			},

			/**
			 * Generate the complete zip file
			 * @param {Object} options the options to generate the zip file :
			 * - base64, (deprecated, use type instead) true to generate base64.
			 * - compression, "STORE" by default.
			 * - type, "base64" by default. Values are : string, base64, uint8array, arraybuffer, blob.
			 * @return {String|Uint8Array|ArrayBuffer|Blob} the zip file
			 */
			generate: function (options)
			{
				options = extend(options || {}, {
					base64:      true,
					compression: "STORE",
					type:        "base64"
				});
				var compression = options.compression.toUpperCase();

				if (!JSZip.compressions[compression])
				{
					throw compression + " is not a valid compression method !";
				}

				// The central directory, and files data
				var directory = [], files = [], fileOffset = 0;

				for (var name in this.files)
				{
					if (!this.files.hasOwnProperty(name))
					{
						continue;
					}

					var file = this.files[name];

					var utfEncodedFileName = this.utf8encode(file.name);

					var fileRecord = "",
						dirRecord = "",
						data = prepareLocalHeaderData.call(this, file, utfEncodedFileName, compression);
					fileRecord = JSZip.signature.LOCAL_FILE_HEADER + data.header + utfEncodedFileName + data.compressedData;

					dirRecord = JSZip.signature.CENTRAL_FILE_HEADER +
						// version made by (00: DOS)
						"\x14\x00" +
						// file header (common to file and central directory)
						data.header +
						// file comment length
						"\x00\x00" +
						// disk number start
						"\x00\x00" +
						// internal file attributes TODO
						"\x00\x00" +
						// external file attributes
						(this.files[name].options.dir === true ? "\x10\x00\x00\x00" : "\x00\x00\x00\x00") +
						// relative offset of local header
						decToHex(fileOffset, 4) +
						// file name
						utfEncodedFileName;

					fileOffset += fileRecord.length;

					files.push(fileRecord);
					directory.push(dirRecord);
				}

				var fileData = files.join("");
				var dirData = directory.join("");

				var dirEnd = "";

				// end of central dir signature
				dirEnd = JSZip.signature.CENTRAL_DIRECTORY_END +
					// number of this disk
					"\x00\x00" +
					// number of the disk with the start of the central directory
					"\x00\x00" +
					// total number of entries in the central directory on this disk
					decToHex(files.length, 2) +
					// total number of entries in the central directory
					decToHex(files.length, 2) +
					// size of the central directory   4 bytes
					decToHex(dirData.length, 4) +
					// offset of start of central directory with respect to the starting disk number
					decToHex(fileData.length, 4) +
					// .ZIP file comment length
					"\x00\x00";

				var zip = fileData + dirData + dirEnd;


				switch (options.type.toLowerCase())
				{
					case "uint8array" :
						return JSZip.utils.string2Uint8Array(zip);
					case "arraybuffer" :
						return JSZip.utils.string2Uint8Array(zip).buffer;
					case "blob" :
						return JSZip.utils.string2Blob(zip);
					case "base64" :
						return (options.base64) ? JSZipBase64.encode(zip) : zip;
					default : // case "string" :
						return zip;
				}
			},

			/**
			 *
			 *  Javascript crc32
			 *  http://www.webtoolkit.info/
			 *
			 */
			crc32: function (str, crc)
			{

				if (str === "" || typeof str === "undefined")
				{
					return 0;
				}

				var table = [
					0x00000000, 0x77073096, 0xEE0E612C, 0x990951BA,
					0x076DC419, 0x706AF48F, 0xE963A535, 0x9E6495A3,
					0x0EDB8832, 0x79DCB8A4, 0xE0D5E91E, 0x97D2D988,
					0x09B64C2B, 0x7EB17CBD, 0xE7B82D07, 0x90BF1D91,
					0x1DB71064, 0x6AB020F2, 0xF3B97148, 0x84BE41DE,
					0x1ADAD47D, 0x6DDDE4EB, 0xF4D4B551, 0x83D385C7,
					0x136C9856, 0x646BA8C0, 0xFD62F97A, 0x8A65C9EC,
					0x14015C4F, 0x63066CD9, 0xFA0F3D63, 0x8D080DF5,
					0x3B6E20C8, 0x4C69105E, 0xD56041E4, 0xA2677172,
					0x3C03E4D1, 0x4B04D447, 0xD20D85FD, 0xA50AB56B,
					0x35B5A8FA, 0x42B2986C, 0xDBBBC9D6, 0xACBCF940,
					0x32D86CE3, 0x45DF5C75, 0xDCD60DCF, 0xABD13D59,
					0x26D930AC, 0x51DE003A, 0xC8D75180, 0xBFD06116,
					0x21B4F4B5, 0x56B3C423, 0xCFBA9599, 0xB8BDA50F,
					0x2802B89E, 0x5F058808, 0xC60CD9B2, 0xB10BE924,
					0x2F6F7C87, 0x58684C11, 0xC1611DAB, 0xB6662D3D,
					0x76DC4190, 0x01DB7106, 0x98D220BC, 0xEFD5102A,
					0x71B18589, 0x06B6B51F, 0x9FBFE4A5, 0xE8B8D433,
					0x7807C9A2, 0x0F00F934, 0x9609A88E, 0xE10E9818,
					0x7F6A0DBB, 0x086D3D2D, 0x91646C97, 0xE6635C01,
					0x6B6B51F4, 0x1C6C6162, 0x856530D8, 0xF262004E,
					0x6C0695ED, 0x1B01A57B, 0x8208F4C1, 0xF50FC457,
					0x65B0D9C6, 0x12B7E950, 0x8BBEB8EA, 0xFCB9887C,
					0x62DD1DDF, 0x15DA2D49, 0x8CD37CF3, 0xFBD44C65,
					0x4DB26158, 0x3AB551CE, 0xA3BC0074, 0xD4BB30E2,
					0x4ADFA541, 0x3DD895D7, 0xA4D1C46D, 0xD3D6F4FB,
					0x4369E96A, 0x346ED9FC, 0xAD678846, 0xDA60B8D0,
					0x44042D73, 0x33031DE5, 0xAA0A4C5F, 0xDD0D7CC9,
					0x5005713C, 0x270241AA, 0xBE0B1010, 0xC90C2086,
					0x5768B525, 0x206F85B3, 0xB966D409, 0xCE61E49F,
					0x5EDEF90E, 0x29D9C998, 0xB0D09822, 0xC7D7A8B4,
					0x59B33D17, 0x2EB40D81, 0xB7BD5C3B, 0xC0BA6CAD,
					0xEDB88320, 0x9ABFB3B6, 0x03B6E20C, 0x74B1D29A,
					0xEAD54739, 0x9DD277AF, 0x04DB2615, 0x73DC1683,
					0xE3630B12, 0x94643B84, 0x0D6D6A3E, 0x7A6A5AA8,
					0xE40ECF0B, 0x9309FF9D, 0x0A00AE27, 0x7D079EB1,
					0xF00F9344, 0x8708A3D2, 0x1E01F268, 0x6906C2FE,
					0xF762575D, 0x806567CB, 0x196C3671, 0x6E6B06E7,
					0xFED41B76, 0x89D32BE0, 0x10DA7A5A, 0x67DD4ACC,
					0xF9B9DF6F, 0x8EBEEFF9, 0x17B7BE43, 0x60B08ED5,
					0xD6D6A3E8, 0xA1D1937E, 0x38D8C2C4, 0x4FDFF252,
					0xD1BB67F1, 0xA6BC5767, 0x3FB506DD, 0x48B2364B,
					0xD80D2BDA, 0xAF0A1B4C, 0x36034AF6, 0x41047A60,
					0xDF60EFC3, 0xA867DF55, 0x316E8EEF, 0x4669BE79,
					0xCB61B38C, 0xBC66831A, 0x256FD2A0, 0x5268E236,
					0xCC0C7795, 0xBB0B4703, 0x220216B9, 0x5505262F,
					0xC5BA3BBE, 0xB2BD0B28, 0x2BB45A92, 0x5CB36A04,
					0xC2D7FFA7, 0xB5D0CF31, 0x2CD99E8B, 0x5BDEAE1D,
					0x9B64C2B0, 0xEC63F226, 0x756AA39C, 0x026D930A,
					0x9C0906A9, 0xEB0E363F, 0x72076785, 0x05005713,
					0x95BF4A82, 0xE2B87A14, 0x7BB12BAE, 0x0CB61B38,
					0x92D28E9B, 0xE5D5BE0D, 0x7CDCEFB7, 0x0BDBDF21,
					0x86D3D2D4, 0xF1D4E242, 0x68DDB3F8, 0x1FDA836E,
					0x81BE16CD, 0xF6B9265B, 0x6FB077E1, 0x18B74777,
					0x88085AE6, 0xFF0F6A70, 0x66063BCA, 0x11010B5C,
					0x8F659EFF, 0xF862AE69, 0x616BFFD3, 0x166CCF45,
					0xA00AE278, 0xD70DD2EE, 0x4E048354, 0x3903B3C2,
					0xA7672661, 0xD06016F7, 0x4969474D, 0x3E6E77DB,
					0xAED16A4A, 0xD9D65ADC, 0x40DF0B66, 0x37D83BF0,
					0xA9BCAE53, 0xDEBB9EC5, 0x47B2CF7F, 0x30B5FFE9,
					0xBDBDF21C, 0xCABAC28A, 0x53B39330, 0x24B4A3A6,
					0xBAD03605, 0xCDD70693, 0x54DE5729, 0x23D967BF,
					0xB3667A2E, 0xC4614AB8, 0x5D681B02, 0x2A6F2B94,
					0xB40BBE37, 0xC30C8EA1, 0x5A05DF1B, 0x2D02EF8D
				];

				if (typeof(crc) == "undefined")
				{
					crc = 0;
				}
				var x = 0;
				var y = 0;

				crc = crc ^ (-1);
				for (var i = 0, iTop = str.length; i < iTop; i++)
				{
					y = ( crc ^ str.charCodeAt(i) ) & 0xFF;
					x = table[y];
					crc = ( crc >>> 8 ) ^ x;
				}

				return crc ^ (-1);
			},

			// Inspired by http://my.opera.com/GreyWyvern/blog/show.dml/1725165
			clone: function ()
			{
				var newObj = new JSZip();
				for (var i in this)
				{
					if (typeof this[i] !== "function")
					{
						newObj[i] = this[i];
					}
				}
				return newObj;
			},


			/**
			 * http://www.webtoolkit.info/javascript-utf8.html
			 */
			utf8encode: function (string)
			{
				var utftext = "";

				for (var n = 0; n < string.length; n++)
				{

					var c = string.charCodeAt(n);

					if (c < 128)
					{
						utftext += String.fromCharCode(c);
					}
					else if ((c > 127) && (c < 2048))
					{
						utftext += String.fromCharCode((c >> 6) | 192);
						utftext += String.fromCharCode((c & 63) | 128);
					}
					else
					{
						utftext += String.fromCharCode((c >> 12) | 224);
						utftext += String.fromCharCode(((c >> 6) & 63) | 128);
						utftext += String.fromCharCode((c & 63) | 128);
					}

				}

				return utftext;
			},

			/**
			 * http://www.webtoolkit.info/javascript-utf8.html
			 */
			utf8decode: function (utftext)
			{
				var string = "";
				var i = 0;
				var c = 0, c1 = 0, c2 = 0, c3 = 0;

				while (i < utftext.length)
				{

					c = utftext.charCodeAt(i);

					if (c < 128)
					{
						string += String.fromCharCode(c);
						i++;
					}
					else if ((c > 191) && (c < 224))
					{
						c2 = utftext.charCodeAt(i + 1);
						string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
						i += 2;
					}
					else
					{
						c2 = utftext.charCodeAt(i + 1);
						c3 = utftext.charCodeAt(i + 2);
						string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
						i += 3;
					}

				}

				return string;
			}
		};
	}());

	/*
	 * Compression methods
	 * This object is filled in as follow :
	 * name : {
	 *    magic // the 2 bytes indentifying the compression method
	 *    compress // function, take the uncompressed content and return it compressed.
	 *    uncompress // function, take the compressed content and return it uncompressed.
	 * }
	 *
	 * STORE is the default compression method, so it's included in this file.
	 * Other methods should go to separated files : the user wants modularity.
	 */
	JSZip.compressions = {
		"STORE": {
			magic:      "\x00\x00",
			compress:   function (content)
			{
				return content; // no compression
			},
			uncompress: function (content)
			{
				return content; // no compression
			}
		}
	};

	/*
	 * List features that require a modern browser, and if the current browser support them.
	 */
	JSZip.support = {
		// contains true if JSZip can read/generate ArrayBuffer, false otherwise.
		arraybuffer: (function ()
		{
			return typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined";
		})(),
		// contains true if JSZip can read/generate Uint8Array, false otherwise.
		uint8array:  (function ()
		{
			return typeof Uint8Array !== "undefined";
		})(),
		// contains true if JSZip can read/generate Blob, false otherwise.
		blob:        (function ()
		{
			// the spec started with BlobBuilder then replaced it with a construtor for Blob.
			// Result : we have browsers that :
			// * know the BlobBuilder (but with prefix)
			// * know the Blob constructor
			// * know about Blob but not about how to build them
			// About the "=== 0" test : if given the wrong type, it may be converted to a string.
			// Instead of an empty content, we will get "[object Uint8Array]" for example.
			if (typeof ArrayBuffer === "undefined")
			{
				return false;
			}
			var buffer = new ArrayBuffer(0);
			try
			{
				return new Blob([buffer], { type: "application/zip" }).size === 0;
			}
			catch (e)
			{
			}

			try
			{
				var builder = new (window.BlobBuilder || window.WebKitBlobBuilder ||
					window.MozBlobBuilder || window.MSBlobBuilder)();
				builder.append(buffer);
				return builder.getBlob('application/zip').size === 0;
			}
			catch (e)
			{
			}

			return false;
		})()
	};

	JSZip.utils = {
		/**
		 * Convert a string to a "binary string" : a string containing only char codes between 0 and 255.
		 * @param {string} str the string to transform.
		 * @return {String} the binary string.
		 */
		string2binary:     function (str)
		{
			var result = "";
			for (var i = 0; i < str.length; i++)
			{
				result += String.fromCharCode(str.charCodeAt(i) & 0xff);
			}
			return result;
		},
		/**
		 * Create a Uint8Array from the string.
		 * @param {string} str the string to transform.
		 * @return {Uint8Array} the typed array.
		 * @throws {Error} an Error if the browser doesn't support the requested feature.
		 */
		string2Uint8Array: function (str)
		{
			if (!JSZip.support.uint8array)
			{
				throw new Error("Uint8Array is not supported by this browser");
			}
			var buffer = new ArrayBuffer(str.length);
			var bufferView = new Uint8Array(buffer);
			for (var i = 0; i < str.length; i++)
			{
				bufferView[i] = str.charCodeAt(i);
			}

			return bufferView;
		},

		/**
		 * Create a string from the Uint8Array.
		 * @param {Uint8Array} array the array to transform.
		 * @return {string} the string.
		 * @throws {Error} an Error if the browser doesn't support the requested feature.
		 */
		uint8Array2String: function (array)
		{
			if (!JSZip.support.uint8array)
			{
				throw new Error("Uint8Array is not supported by this browser");
			}
			var result = "";
			for (var i = 0; i < array.length; i++)
			{
				result += String.fromCharCode(array[i]);
			}

			return result;
		},
		/**
		 * Create a blob from the given string.
		 * @param {string} str the string to transform.
		 * @return {Blob} the string.
		 * @throws {Error} an Error if the browser doesn't support the requested feature.
		 */
		string2Blob:       function (str)
		{
			if (!JSZip.support.blob)
			{
				throw new Error("Blob is not supported by this browser");
			}

			var buffer = JSZip.utils.string2Uint8Array(str).buffer;
			try
			{
				// Blob constructor
				return new Blob([buffer], { type: "application/zip" });
			}
			catch (e)
			{
			}

			try
			{
				// deprecated, browser only, old way
				var builder = new (window.BlobBuilder || window.WebKitBlobBuilder ||
					window.MozBlobBuilder || window.MSBlobBuilder)();
				builder.append(buffer);
				return builder.getBlob('application/zip');
			}
			catch (e)
			{
			}

			// well, fuck ?!
			throw new Error("Bug : can't construct the Blob.");
		}
	};

	/**
	 *
	 *  Base64 encode / decode
	 *  http://www.webtoolkit.info/
	 *
	 *  Hacked so that it doesn't utf8 en/decode everything
	 **/
	var JSZipBase64 = (function ()
	{
		// private property
		var _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

		return {
			// public method for encoding
			encode: function (input, utf8)
			{
				var output = "";
				var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
				var i = 0;

				while (i < input.length)
				{

					chr1 = input.charCodeAt(i++);
					chr2 = input.charCodeAt(i++);
					chr3 = input.charCodeAt(i++);

					enc1 = chr1 >> 2;
					enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
					enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
					enc4 = chr3 & 63;

					if (isNaN(chr2))
					{
						enc3 = enc4 = 64;
					}
					else if (isNaN(chr3))
					{
						enc4 = 64;
					}

					output = output +
						_keyStr.charAt(enc1) + _keyStr.charAt(enc2) +
						_keyStr.charAt(enc3) + _keyStr.charAt(enc4);

				}

				return output;
			},

			// public method for decoding
			decode: function (input, utf8)
			{
				var output = "";
				var chr1, chr2, chr3;
				var enc1, enc2, enc3, enc4;
				var i = 0;

				input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

				while (i < input.length)
				{

					enc1 = _keyStr.indexOf(input.charAt(i++));
					enc2 = _keyStr.indexOf(input.charAt(i++));
					enc3 = _keyStr.indexOf(input.charAt(i++));
					enc4 = _keyStr.indexOf(input.charAt(i++));

					chr1 = (enc1 << 2) | (enc2 >> 4);
					chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
					chr3 = ((enc3 & 3) << 6) | enc4;

					output = output + String.fromCharCode(chr1);

					if (enc3 != 64)
					{
						output = output + String.fromCharCode(chr2);
					}
					if (enc4 != 64)
					{
						output = output + String.fromCharCode(chr3);
					}

				}

				return output;

			}
		};
	}());

	// enforcing Stuk's coding style
	// vim: set shiftwidth=3 softtabstop=3:
	/*
	 * Port of a script by Masanao Izumo.
	 *
	 * Only changes : wrap all the variables in a function and add the 
	 * main function to JSZip (DEFLATE compression method).
	 * Everything else was written by M. Izumo.
	 *
	 * Original code can be found here: http://www.onicos.com/staff/iz/amuse/javascript/expert/inflate.txt
	 */

	if (!JSZip)
	{
		throw "JSZip not defined";
	}

	/*
	 * Original:
	 *   http://www.onicos.com/staff/iz/amuse/javascript/expert/inflate.txt
	 */

	(function ()
	{
		// the original implementation leaks a global variable.
		// Defining the variable here doesn't break anything.
		var zip_fixed_bd;

		/* Copyright (C) 1999 Masanao Izumo <iz@onicos.co.jp>
		 * Version: 1.0.0.1
		 * LastModified: Dec 25 1999
		 */

		/* Interface:
		 * data = zip_inflate(src);
		 */

		/* constant parameters */
		var zip_WSIZE = 32768;		// Sliding Window size
		var zip_STORED_BLOCK = 0;
		var zip_STATIC_TREES = 1;
		var zip_DYN_TREES = 2;

		/* for inflate */
		var zip_lbits = 9; 		// bits in base literal/length lookup table
		var zip_dbits = 6; 		// bits in base distance lookup table
		var zip_INBUFSIZ = 32768;	// Input buffer size
		var zip_INBUF_EXTRA = 64;	// Extra buffer

		/* variables (inflate) */
		var zip_slide;
		var zip_wp;			// current position in slide
		var zip_fixed_tl = null;	// inflate static
		var zip_fixed_td;		// inflate static
		var zip_fixed_bl, fixed_bd;	// inflate static
		var zip_bit_buf;		// bit buffer
		var zip_bit_len;		// bits in bit buffer
		var zip_method;
		var zip_eof;
		var zip_copy_leng;
		var zip_copy_dist;
		var zip_tl, zip_td;	// literal/length and distance decoder tables
		var zip_bl, zip_bd;	// number of bits decoded by tl and td

		var zip_inflate_data;
		var zip_inflate_pos;


		/* constant tables (inflate) */
		var zip_MASK_BITS = new Array(
			0x0000,
			0x0001, 0x0003, 0x0007, 0x000f, 0x001f, 0x003f, 0x007f, 0x00ff,
			0x01ff, 0x03ff, 0x07ff, 0x0fff, 0x1fff, 0x3fff, 0x7fff, 0xffff);
		// Tables for deflate from PKZIP's appnote.txt.
		var zip_cplens = new Array( // Copy lengths for literal codes 257..285
			3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
			35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0);
		/* note: see note #13 above about the 258 in this list. */
		var zip_cplext = new Array( // Extra bits for literal codes 257..285
			0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2,
			3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99); // 99==invalid
		var zip_cpdist = new Array( // Copy offsets for distance codes 0..29
			1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
			257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
			8193, 12289, 16385, 24577);
		var zip_cpdext = new Array( // Extra bits for distance codes
			0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6,
			7, 7, 8, 8, 9, 9, 10, 10, 11, 11,
			12, 12, 13, 13);
		var zip_border = new Array(  // Order of the bit length code lengths
			16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15);
		/* objects (inflate) */

		function zip_HuftList()
		{
			this.next = null;
			this.list = null;
		}

		function zip_HuftNode()
		{
			this.e = 0; // number of extra bits or operation
			this.b = 0; // number of bits in this code or subcode

			// union
			this.n = 0; // literal, length base, or distance base
			this.t = null; // (zip_HuftNode) pointer to next level of table
		}

		function zip_HuftBuild(b,	// code lengths in bits (all assumed <= BMAX)
			n,	// number of codes (assumed <= N_MAX)
			s,	// number of simple-valued codes (0..s-1)
			d,	// list of base values for non-simple codes
			e,	// list of extra bits for non-simple codes
			mm	// maximum lookup bits
			)
		{
			this.BMAX = 16;   // maximum bit length of any code
			this.N_MAX = 288; // maximum number of codes in any set
			this.status = 0;	// 0: success, 1: incomplete table, 2: bad input
			this.root = null;	// (zip_HuftList) starting table
			this.m = 0;		// maximum lookup bits, returns actual

			/* Given a list of code lengths and a maximum table size, make a set of
			 tables to decode that set of codes.	Return zero on success, one if
			 the given code set is incomplete (the tables are still built in this
			 case), two if the input is invalid (all zero length codes or an
			 oversubscribed set of lengths), and three if not enough memory.
			 The code with value 256 is special, and the tables are constructed
			 so that no bits beyond that code are fetched when that code is
			 decoded. */
			{
				var a;			// counter for codes of length k
				var c = new Array(this.BMAX + 1);	// bit length count table
				var el;			// length of EOB code (value 256)
				var f;			// i repeats in table every f entries
				var g;			// maximum code length
				var h;			// table level
				var i;			// counter, current code
				var j;			// counter
				var k;			// number of bits in current code
				var lx = new Array(this.BMAX + 1);	// stack of bits per table
				var p;			// pointer into c[], b[], or v[]
				var pidx;		// index of p
				var q;			// (zip_HuftNode) points to current table
				var r = new zip_HuftNode(); // table entry for structure assignment
				var u = new Array(this.BMAX); // zip_HuftNode[BMAX][]  table stack
				var v = new Array(this.N_MAX); // values in order of bit length
				var w;
				var x = new Array(this.BMAX + 1);// bit offsets, then code stack
				var xp;			// pointer into x or c
				var y;			// number of dummy codes added
				var z;			// number of entries in current table
				var o;
				var tail;		// (zip_HuftList)

				tail = this.root = null;
				for (i = 0; i < c.length; i++)
					c[i] = 0;
				for (i = 0; i < lx.length; i++)
					lx[i] = 0;
				for (i = 0; i < u.length; i++)
					u[i] = null;
				for (i = 0; i < v.length; i++)
					v[i] = 0;
				for (i = 0; i < x.length; i++)
					x[i] = 0;

				// Generate counts for each bit length
				el = n > 256 ? b[256] : this.BMAX; // set length of EOB code, if any
				p = b;
				pidx = 0;
				i = n;
				do {
					c[p[pidx]]++;	// assume all entries <= BMAX
					pidx++;
				} while (--i > 0);
				if (c[0] == n)
				{	// null input--all zero length codes
					this.root = null;
					this.m = 0;
					this.status = 0;
					return;
				}

				// Find minimum and maximum length, bound *m by those
				for (j = 1; j <= this.BMAX; j++)
					if (c[j] != 0)
						break;
				k = j;			// minimum code length
				if (mm < j)
					mm = j;
				for (i = this.BMAX; i != 0; i--)
					if (c[i] != 0)
						break;
				g = i;			// maximum code length
				if (mm > i)
					mm = i;

				// Adjust last length count to fill out codes, if needed
				for (y = 1 << j; j < i; j++, y <<= 1)
					if ((y -= c[j]) < 0)
					{
						this.status = 2;	// bad input: more codes than bits
						this.m = mm;
						return;
					}
				if ((y -= c[i]) < 0)
				{
					this.status = 2;
					this.m = mm;
					return;
				}
				c[i] += y;

				// Generate starting offsets into the value table for each length
				x[1] = j = 0;
				p = c;
				pidx = 1;
				xp = 2;
				while (--i > 0)		// note that i == g from above
					x[xp++] = (j += p[pidx++]);

				// Make a table of values in order of bit lengths
				p = b;
				pidx = 0;
				i = 0;
				do {
					if ((j = p[pidx++]) != 0)
						v[x[j]++] = i;
				} while (++i < n);
				n = x[g];			// set n to length of v

				// Generate the Huffman codes and for each, make the table entries
				x[0] = i = 0;		// first Huffman code is zero
				p = v;
				pidx = 0;		// grab values in bit order
				h = -1;			// no tables yet--level -1
				w = lx[0] = 0;		// no bits decoded yet
				q = null;			// ditto
				z = 0;			// ditto

				// go through the bit lengths (k already is bits in shortest code)
				for (; k <= g; k++)
				{
					a = c[k];
					while (a-- > 0)
					{
						// here i is the Huffman code of length k bits for value p[pidx]
						// make tables up to required level
						while (k > w + lx[1 + h])
						{
							w += lx[1 + h]; // add bits already decoded
							h++;

							// compute minimum size table less than or equal to *m bits
							z = (z = g - w) > mm ? mm : z; // upper limit
							if ((f = 1 << (j = k - w)) > a + 1)
							{ // try a k-w bit table
								// too few codes for k-w bit table
								f -= a + 1;	// deduct codes from patterns left
								xp = k;
								while (++j < z)
								{ // try smaller tables up to z bits
									if ((f <<= 1) <= c[++xp])
										break;	// enough codes to use up j bits
									f -= c[xp];	// else deduct codes from patterns
								}
							}
							if (w + j > el && w < el)
								j = el - w;	// make EOB code end at table
							z = 1 << j;	// table entries for j-bit table
							lx[1 + h] = j; // set table size in stack

							// allocate and link in new table
							q = new Array(z);
							for (o = 0; o < z; o++)
							{
								q[o] = new zip_HuftNode();
							}

							if (tail == null)
								tail = this.root = new zip_HuftList();
							else
								tail = tail.next = new zip_HuftList();
							tail.next = null;
							tail.list = q;
							u[h] = q;	// table starts after link

							/* connect to last table, if there is one */
							if (h > 0)
							{
								x[h] = i;		// save pattern for backing up
								r.b = lx[h];	// bits to dump before this table
								r.e = 16 + j;	// bits in this table
								r.t = q;		// pointer to this table
								j = (i & ((1 << w) - 1)) >> (w - lx[h]);
								u[h - 1][j].e = r.e;
								u[h - 1][j].b = r.b;
								u[h - 1][j].n = r.n;
								u[h - 1][j].t = r.t;
							}
						}

						// set up table entry in r
						r.b = k - w;
						if (pidx >= n)
							r.e = 99;		// out of values--invalid code
						else if (p[pidx] < s)
						{
							r.e = (p[pidx] < 256 ? 16 : 15); // 256 is end-of-block code
							r.n = p[pidx++];	// simple code is just the value
						}
						else
						{
							r.e = e[p[pidx] - s];	// non-simple--look up in lists
							r.n = d[p[pidx++] - s];
						}

						// fill code-like entries with r //
						f = 1 << (k - w);
						for (j = i >> w; j < z; j += f)
						{
							q[j].e = r.e;
							q[j].b = r.b;
							q[j].n = r.n;
							q[j].t = r.t;
						}

						// backwards increment the k-bit code i
						for (j = 1 << (k - 1); (i & j) != 0; j >>= 1)
							i ^= j;
						i ^= j;

						// backup over finished tables
						while ((i & ((1 << w) - 1)) != x[h])
						{
							w -= lx[h];		// don't need to update q
							h--;
						}
					}
				}

				/* return actual size of base table */
				this.m = lx[1];

				/* Return true (1) if we were given an incomplete table */
				this.status = ((y != 0 && g != 1) ? 1 : 0);
			}
			/* end of constructor */
		}


		/* routines (inflate) */

		function zip_GET_BYTE()
		{
			if (zip_inflate_data.length == zip_inflate_pos)
				return -1;
			return zip_inflate_data.charCodeAt(zip_inflate_pos++) & 0xff;
		}

		function zip_NEEDBITS(n)
		{
			while (zip_bit_len < n)
			{
				zip_bit_buf |= zip_GET_BYTE() << zip_bit_len;
				zip_bit_len += 8;
			}
		}

		function zip_GETBITS(n)
		{
			return zip_bit_buf & zip_MASK_BITS[n];
		}

		function zip_DUMPBITS(n)
		{
			zip_bit_buf >>= n;
			zip_bit_len -= n;
		}

		function zip_inflate_codes(buff, off, size)
		{
			/* inflate (decompress) the codes in a deflated (compressed) block.
			 Return an error code or zero if it all goes ok. */
			var e;		// table entry flag/number of extra bits
			var t;		// (zip_HuftNode) pointer to table entry
			var n;

			if (size == 0)
				return 0;

			// inflate the coded data
			n = 0;
			for (; ;)
			{			// do until end of block
				zip_NEEDBITS(zip_bl);
				t = zip_tl.list[zip_GETBITS(zip_bl)];
				e = t.e;
				while (e > 16)
				{
					if (e == 99)
						return -1;
					zip_DUMPBITS(t.b);
					e -= 16;
					zip_NEEDBITS(e);
					t = t.t[zip_GETBITS(e)];
					e = t.e;
				}
				zip_DUMPBITS(t.b);

				if (e == 16)
				{		// then it's a literal
					zip_wp &= zip_WSIZE - 1;
					buff[off + n++] = zip_slide[zip_wp++] = t.n;
					if (n == size)
						return size;
					continue;
				}

				// exit if end of block
				if (e == 15)
					break;

				// it's an EOB or a length

				// get length of block to copy
				zip_NEEDBITS(e);
				zip_copy_leng = t.n + zip_GETBITS(e);
				zip_DUMPBITS(e);

				// decode distance of block to copy
				zip_NEEDBITS(zip_bd);
				t = zip_td.list[zip_GETBITS(zip_bd)];
				e = t.e;

				while (e > 16)
				{
					if (e == 99)
						return -1;
					zip_DUMPBITS(t.b);
					e -= 16;
					zip_NEEDBITS(e);
					t = t.t[zip_GETBITS(e)];
					e = t.e;
				}
				zip_DUMPBITS(t.b);
				zip_NEEDBITS(e);
				zip_copy_dist = zip_wp - t.n - zip_GETBITS(e);
				zip_DUMPBITS(e);

				// do the copy
				while (zip_copy_leng > 0 && n < size)
				{
					zip_copy_leng--;
					zip_copy_dist &= zip_WSIZE - 1;
					zip_wp &= zip_WSIZE - 1;
					buff[off + n++] = zip_slide[zip_wp++]
						= zip_slide[zip_copy_dist++];
				}

				if (n == size)
					return size;
			}

			zip_method = -1; // done
			return n;
		}

		function zip_inflate_stored(buff, off, size)
		{
			/* "decompress" an inflated type 0 (stored) block. */
			var n;

			// go to byte boundary
			n = zip_bit_len & 7;
			zip_DUMPBITS(n);

			// get the length and its complement
			zip_NEEDBITS(16);
			n = zip_GETBITS(16);
			zip_DUMPBITS(16);
			zip_NEEDBITS(16);
			if (n != ((~zip_bit_buf) & 0xffff))
				return -1;			// error in compressed data
			zip_DUMPBITS(16);

			// read and output the compressed data
			zip_copy_leng = n;

			n = 0;
			while (zip_copy_leng > 0 && n < size)
			{
				zip_copy_leng--;
				zip_wp &= zip_WSIZE - 1;
				zip_NEEDBITS(8);
				buff[off + n++] = zip_slide[zip_wp++] =
					zip_GETBITS(8);
				zip_DUMPBITS(8);
			}

			if (zip_copy_leng == 0)
				zip_method = -1; // done
			return n;
		}

		function zip_inflate_fixed(buff, off, size)
		{
			/* decompress an inflated type 1 (fixed Huffman codes) block.  We should
			 either replace this with a custom decoder, or at least precompute the
			 Huffman tables. */

			// if first time, set up tables for fixed blocks
			if (zip_fixed_tl == null)
			{
				var i;			// temporary variable
				var l = new Array(288);	// length list for huft_build
				var h;	// zip_HuftBuild

				// literal table
				for (i = 0; i < 144; i++)
					l[i] = 8;
				for (; i < 256; i++)
					l[i] = 9;
				for (; i < 280; i++)
					l[i] = 7;
				for (; i < 288; i++)	// make a complete, but wrong code set
					l[i] = 8;
				zip_fixed_bl = 7;

				h = new zip_HuftBuild(l, 288, 257, zip_cplens, zip_cplext,
					zip_fixed_bl);
				if (h.status != 0)
				{
					alert("HufBuild error: " + h.status);
					return -1;
				}
				zip_fixed_tl = h.root;
				zip_fixed_bl = h.m;

				// distance table
				for (i = 0; i < 30; i++)	// make an incomplete code set
					l[i] = 5;
				zip_fixed_bd = 5;

				h = new zip_HuftBuild(l, 30, 0, zip_cpdist, zip_cpdext, zip_fixed_bd);
				if (h.status > 1)
				{
					zip_fixed_tl = null;
					alert("HufBuild error: " + h.status);
					return -1;
				}
				zip_fixed_td = h.root;
				zip_fixed_bd = h.m;
			}

			zip_tl = zip_fixed_tl;
			zip_td = zip_fixed_td;
			zip_bl = zip_fixed_bl;
			zip_bd = zip_fixed_bd;
			return zip_inflate_codes(buff, off, size);
		}

		function zip_inflate_dynamic(buff, off, size)
		{
			// decompress an inflated type 2 (dynamic Huffman codes) block.
			var i;		// temporary variables
			var j;
			var l;		// last length
			var n;		// number of lengths to get
			var t;		// (zip_HuftNode) literal/length code table
			var nb;		// number of bit length codes
			var nl;		// number of literal/length codes
			var nd;		// number of distance codes
			var ll = new Array(286 + 30); // literal/length and distance code lengths
			var h;		// (zip_HuftBuild)

			for (i = 0; i < ll.length; i++)
				ll[i] = 0;

			// read in table lengths
			zip_NEEDBITS(5);
			nl = 257 + zip_GETBITS(5);	// number of literal/length codes
			zip_DUMPBITS(5);
			zip_NEEDBITS(5);
			nd = 1 + zip_GETBITS(5);	// number of distance codes
			zip_DUMPBITS(5);
			zip_NEEDBITS(4);
			nb = 4 + zip_GETBITS(4);	// number of bit length codes
			zip_DUMPBITS(4);
			if (nl > 286 || nd > 30)
				return -1;		// bad lengths

			// read in bit-length-code lengths
			for (j = 0; j < nb; j++)
			{
				zip_NEEDBITS(3);
				ll[zip_border[j]] = zip_GETBITS(3);
				zip_DUMPBITS(3);
			}
			for (; j < 19; j++)
				ll[zip_border[j]] = 0;

			// build decoding table for trees--single level, 7 bit lookup
			zip_bl = 7;
			h = new zip_HuftBuild(ll, 19, 19, null, null, zip_bl);
			if (h.status != 0)
				return -1;	// incomplete code set

			zip_tl = h.root;
			zip_bl = h.m;

			// read in literal and distance code lengths
			n = nl + nd;
			i = l = 0;
			while (i < n)
			{
				zip_NEEDBITS(zip_bl);
				t = zip_tl.list[zip_GETBITS(zip_bl)];
				j = t.b;
				zip_DUMPBITS(j);
				j = t.n;
				if (j < 16)		// length of code in bits (0..15)
					ll[i++] = l = j;	// save last length in l
				else if (j == 16)
				{	// repeat last length 3 to 6 times
					zip_NEEDBITS(2);
					j = 3 + zip_GETBITS(2);
					zip_DUMPBITS(2);
					if (i + j > n)
						return -1;
					while (j-- > 0)
						ll[i++] = l;
				}
				else if (j == 17)
				{	// 3 to 10 zero length codes
					zip_NEEDBITS(3);
					j = 3 + zip_GETBITS(3);
					zip_DUMPBITS(3);
					if (i + j > n)
						return -1;
					while (j-- > 0)
						ll[i++] = 0;
					l = 0;
				}
				else
				{		// j == 18: 11 to 138 zero length codes
					zip_NEEDBITS(7);
					j = 11 + zip_GETBITS(7);
					zip_DUMPBITS(7);
					if (i + j > n)
						return -1;
					while (j-- > 0)
						ll[i++] = 0;
					l = 0;
				}
			}

			// build the decoding tables for literal/length and distance codes
			zip_bl = zip_lbits;
			h = new zip_HuftBuild(ll, nl, 257, zip_cplens, zip_cplext, zip_bl);
			if (zip_bl == 0)	// no literals or lengths
				h.status = 1;
			if (h.status != 0)
			{
				if (h.status == 1)
					;// **incomplete literal tree**
				return -1;		// incomplete code set
			}
			zip_tl = h.root;
			zip_bl = h.m;

			for (i = 0; i < nd; i++)
				ll[i] = ll[i + nl];
			zip_bd = zip_dbits;
			h = new zip_HuftBuild(ll, nd, 0, zip_cpdist, zip_cpdext, zip_bd);
			zip_td = h.root;
			zip_bd = h.m;

			if (zip_bd == 0 && nl > 257)
			{   // lengths but no distances
				// **incomplete distance tree**
				return -1;
			}

			if (h.status == 1)
			{
				;// **incomplete distance tree**
			}
			if (h.status != 0)
				return -1;

			// decompress until an end-of-block code
			return zip_inflate_codes(buff, off, size);
		}

		function zip_inflate_start()
		{
			var i;

			if (zip_slide == null)
				zip_slide = new Array(2 * zip_WSIZE);
			zip_wp = 0;
			zip_bit_buf = 0;
			zip_bit_len = 0;
			zip_method = -1;
			zip_eof = false;
			zip_copy_leng = zip_copy_dist = 0;
			zip_tl = null;
		}

		function zip_inflate_internal(buff, off, size)
		{
			// decompress an inflated entry
			var n, i;

			n = 0;
			while (n < size)
			{
				if (zip_eof && zip_method == -1)
					return n;

				if (zip_copy_leng > 0)
				{
					if (zip_method != zip_STORED_BLOCK)
					{
						// STATIC_TREES or DYN_TREES
						while (zip_copy_leng > 0 && n < size)
						{
							zip_copy_leng--;
							zip_copy_dist &= zip_WSIZE - 1;
							zip_wp &= zip_WSIZE - 1;
							buff[off + n++] = zip_slide[zip_wp++] =
								zip_slide[zip_copy_dist++];
						}
					}
					else
					{
						while (zip_copy_leng > 0 && n < size)
						{
							zip_copy_leng--;
							zip_wp &= zip_WSIZE - 1;
							zip_NEEDBITS(8);
							buff[off + n++] = zip_slide[zip_wp++] = zip_GETBITS(8);
							zip_DUMPBITS(8);
						}
						if (zip_copy_leng == 0)
							zip_method = -1; // done
					}
					if (n == size)
						return n;
				}

				if (zip_method == -1)
				{
					if (zip_eof)
						break;

					// read in last block bit
					zip_NEEDBITS(1);
					if (zip_GETBITS(1) != 0)
						zip_eof = true;
					zip_DUMPBITS(1);

					// read in block type
					zip_NEEDBITS(2);
					zip_method = zip_GETBITS(2);
					zip_DUMPBITS(2);
					zip_tl = null;
					zip_copy_leng = 0;
				}

				switch (zip_method)
				{
					case 0: // zip_STORED_BLOCK
						i = zip_inflate_stored(buff, off + n, size - n);
						break;

					case 1: // zip_STATIC_TREES
						if (zip_tl != null)
							i = zip_inflate_codes(buff, off + n, size - n);
						else
							i = zip_inflate_fixed(buff, off + n, size - n);
						break;

					case 2: // zip_DYN_TREES
						if (zip_tl != null)
							i = zip_inflate_codes(buff, off + n, size - n);
						else
							i = zip_inflate_dynamic(buff, off + n, size - n);
						break;

					default: // error
						i = -1;
						break;
				}

				if (i == -1)
				{
					if (zip_eof)
						return 0;
					return -1;
				}
				n += i;
			}
			return n;
		}

		function zip_inflate(str)
		{
			var out, buff;
			var i, j;

			zip_inflate_start();
			zip_inflate_data = str;
			zip_inflate_pos = 0;

			buff = new Array(1024);
			out = "";
			while ((i = zip_inflate_internal(buff, 0, buff.length)) > 0)
			{
				for (j = 0; j < i; j++)
					out += String.fromCharCode(buff[j]);
			}
			zip_inflate_data = null; // G.C.
			return out;
		}

		//
		// end of the script of Masanao Izumo.
		//

		// we add the compression method for JSZip
		if (!JSZip.compressions["DEFLATE"])
		{
			JSZip.compressions["DEFLATE"] = {
				magic:      "\x08\x00",
				uncompress: zip_inflate
			}
		}
		else
		{
			JSZip.compressions["DEFLATE"].uncompress = zip_inflate;
		}

	})();

	// enforcing Stuk's coding style
	// vim: set shiftwidth=3 softtabstop=3:
	/**

	 JSZip - A Javascript class for generating and reading zip files
	 <http://stuartk.com/jszip>

	 (c) 2011 David Duponchel <d.duponchel@gmail.com>
	 Dual licenced under the MIT license or GPLv3. See LICENSE.markdown.

	 **/
	/*global JSZip,JSZipBase64 */
	(function ()
	{

		var MAX_VALUE_16BITS = 65535;
		var MAX_VALUE_32BITS = -1; // well, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" is parsed as -1

		/**
		 * Prettify a string read as binary.
		 * @param {string} str the string to prettify.
		 * @return {string} a pretty string.
		 */
		var pretty = function (str)
		{
			var res = '', code, i;
			for (i = 0; i < (str || "").length; i++)
			{
				code = str.charCodeAt(i);
				res += '\\x' + (code < 16 ? "0" : "") + code.toString(16).toUpperCase();
			}
			return res;
		};

		/**
		 * Find a compression registered in JSZip.
		 * @param {string} compressionMethod the method magic to find.
		 * @return {Object|null} the JSZip compression object, null if none found.
		 */
		var findCompression = function (compressionMethod)
		{
			for (var method in JSZip.compressions)
			{
				if (!JSZip.compressions.hasOwnProperty(method))
				{
					continue;
				}
				if (JSZip.compressions[method].magic === compressionMethod)
				{
					return JSZip.compressions[method];
				}
			}
			return null;
		};

		// class StreamReader {{{
		/**
		 * Read bytes from a stream.
		 * Developer tip : when debugging, a watch on pretty(this.reader.stream.slice(this.reader.index))
		 * is very useful :)
		 * @constructor
		 * @param {String|ArrayBuffer|Uint8Array} stream the stream to read.
		 */
		function StreamReader(stream)
		{
			this.stream = "";
			if (JSZip.support.uint8array && stream instanceof Uint8Array)
			{
				this.stream = JSZip.utils.uint8Array2String(stream);
			}
			else if (JSZip.support.arraybuffer && stream instanceof ArrayBuffer)
			{
				var bufferView = new Uint8Array(stream);
				this.stream = JSZip.utils.uint8Array2String(bufferView);
			}
			else
			{
				this.stream = JSZip.utils.string2binary(stream);
			}
			this.index = 0;
		}

		StreamReader.prototype = {
			/**
			 * Check that the offset will not go too far.
			 * @param {string} offset the additional offset to check.
			 * @throws {Error} an Error if the offset is out of bounds.
			 */
			checkOffset: function (offset)
			{
				this.checkIndex(this.index + offset);
			},
			/**
			 * Check that the specifed index will not be too far.
			 * @param {string} newIndex the index to check.
			 * @throws {Error} an Error if the index is out of bounds.
			 */
			checkIndex:  function (newIndex)
			{
				if (this.stream.length < newIndex || newIndex < 0)
				{
					throw new Error("End of stream reached (stream length = " +
						this.stream.length + ", asked index = " +
						(newIndex) + "). Corrupted zip ?");
				}
			},
			/**
			 * Change the index.
			 * @param {number} newIndex The new index.
			 * @throws {Error} if the new index is out of the stream.
			 */
			setIndex:    function (newIndex)
			{
				this.checkIndex(newIndex);
				this.index = newIndex;
			},
			/**
			 * Skip the next n bytes.
			 * @param {number} n the number of bytes to skip.
			 * @throws {Error} if the new index is out of the stream.
			 */
			skip:        function (n)
			{
				this.setIndex(this.index + n);
			},
			/**
			 * Get the byte at the specified index.
			 * @param {number} i the index to use.
			 * @return {number} a byte.
			 */
			byteAt:      function (i)
			{
				return this.stream.charCodeAt(i);
			},
			/**
			 * Get the next number with a given byte size.
			 * @param {number} size the number of bytes to read.
			 * @return {number} the corresponding number.
			 */
			readInt:     function (size)
			{
				var result = 0, i;
				this.checkOffset(size);
				for (i = this.index + size - 1; i >= this.index; i--)
				{
					result = (result << 8) + this.byteAt(i);
				}
				this.index += size;
				return result;
			},
			/**
			 * Get the next string with a given byte size.
			 * @param {number} size the number of bytes to read.
			 * @return {string} the corresponding string.
			 */
			readString:  function (size)
			{
				this.checkOffset(size);
				// this will work because the constructor applied the "& 0xff" mask.
				var result = this.stream.slice(this.index, this.index + size);
				this.index += size;
				return result;
			},
			/**
			 * Get the next date.
			 * @return {Date} the date.
			 */
			readDate:    function ()
			{
				var dostime = this.readInt(4);
				return new Date(
					((dostime >> 25) & 0x7f) + 1980, // year
					((dostime >> 21) & 0x0f) - 1, // month
					(dostime >> 16) & 0x1f, // day
					(dostime >> 11) & 0x1f, // hour
					(dostime >> 5) & 0x3f, // minute
					(dostime & 0x1f) << 1); // second
			}
		};
		// }}} end of StreamReader

		// class ZipEntry {{{
		/**
		 * An entry in the zip file.
		 * @constructor
		 * @param {Object} options Options of the current file.
		 * @param {Object} loadOptions Options for loading the stream.
		 */
		function ZipEntry(options, loadOptions)
		{
			this.options = options;
			this.loadOptions = loadOptions;
		}

		ZipEntry.prototype = {
			/**
			 * say if the file is encrypted.
			 * @return {boolean} true if the file is encrypted, false otherwise.
			 */
			isEncrypted:   function ()
			{
				// bit 1 is set
				return (this.bitFlag & 0x0001) === 0x0001;
			},
			/**
			 * say if the file has utf-8 filename/comment.
			 * @return {boolean} true if the filename/comment is in utf-8, false otherwise.
			 */
			useUTF8:       function ()
			{
				// bit 11 is set
				return (this.bitFlag & 0x0800) === 0x0800;
			},
			/**
			 * Read the local part of a zip file and add the info in this object.
			 * @param {StreamReader} reader the reader to use.
			 */
			readLocalPart: function (reader)
			{
				var compression, localExtraFieldsLength;

				// we already know everything from the central dir !
				// If the central dir data are false, we are doomed.
				// On the bright side, the local part is scary  : zip64, data descriptors, both, etc.
				// The less data we get here, the more reliable this should be.
				// Let's skip the whole header and dash to the data !
				reader.skip(22);
				// in some zip created on windows, the filename stored in the central dir contains \ instead of /.
				// Strangely, the filename here is OK.
				// I would love to treat these zip files as corrupted (see http://www.info-zip.org/FAQ.html#backslashes
				// or APPNOTE#4.4.17.1, "All slashes MUST be forward slashes '/'") but there are a lot of bad zip generators...
				// Search "unzip mismatching "local" filename continuing with "central" filename version" on
				// the internet.
				//
				// I think I see the logic here : the central directory is used to display
				// content and the local directory is used to extract the files. Mixing / and \
				// may be used to display \ to windows users and use / when extracting the files.
				// Unfortunately, this lead also to some issues : http://seclists.org/fulldisclosure/2009/Sep/394
				this.fileNameLength = reader.readInt(2);
				localExtraFieldsLength = reader.readInt(2); // can't be sure this will be the same as the central dir
				this.fileName = reader.readString(this.fileNameLength);
				reader.skip(localExtraFieldsLength);

				if (this.compressedSize == -1 || this.uncompressedSize == -1)
				{
					throw new Error("Bug or corrupted zip : didn't get enough informations from the central directory " +
						"(compressedSize == -1 || uncompressedSize == -1)");
				}
				this.compressedFileData = reader.readString(this.compressedSize);

				compression = findCompression(this.compressionMethod);
				if (compression === null)
				{ // no compression found
					throw new Error("Corrupted zip : compression " + pretty(this.compressionMethod) +
						" unknown (inner file : " + this.fileName + ")");
				}
				this.uncompressedFileData = compression.uncompress(this.compressedFileData);

				if (this.uncompressedFileData.length !== this.uncompressedSize)
				{
					throw new Error("Bug : uncompressed data size mismatch");
				}

				if (this.loadOptions.checkCRC32 && JSZip.prototype.crc32(this.uncompressedFileData) !== this.crc32)
				{
					throw new Error("Corrupted zip : CRC32 mismatch");
				}
			},

			/**
			 * Read the central part of a zip file and add the info in this object.
			 * @param {StreamReader} reader the reader to use.
			 */
			readCentralPart:      function (reader)
			{
				this.versionMadeBy = reader.readString(2);
				this.versionNeeded = reader.readInt(2);
				this.bitFlag = reader.readInt(2);
				this.compressionMethod = reader.readString(2);
				this.date = reader.readDate();
				this.crc32 = reader.readInt(4);
				this.compressedSize = reader.readInt(4);
				this.uncompressedSize = reader.readInt(4);
				this.fileNameLength = reader.readInt(2);
				this.extraFieldsLength = reader.readInt(2);
				this.fileCommentLength = reader.readInt(2);
				this.diskNumberStart = reader.readInt(2);
				this.internalFileAttributes = reader.readInt(2);
				this.externalFileAttributes = reader.readInt(4);
				this.localHeaderOffset = reader.readInt(4);

				if (this.isEncrypted())
				{
					throw new Error("Encrypted zip are not supported");
				}

				this.fileName = reader.readString(this.fileNameLength);
				this.readExtraFields(reader);
				this.parseZIP64ExtraField(reader);
				this.fileComment = reader.readString(this.fileCommentLength);

				// warning, this is true only for zip with madeBy == DOS (plateform dependent feature)
				this.dir = this.externalFileAttributes & 0x00000010 ? true : false;
			},
			/**
			 * Parse the ZIP64 extra field and merge the info in the current ZipEntry.
			 * @param {StreamReader} reader the reader to use.
			 */
			parseZIP64ExtraField: function (reader)
			{

				if (!this.extraFields[0x0001])
				{
					return;
				}

				// should be something, preparing the extra reader
				var extraReader = new StreamReader(this.extraFields[0x0001].value);

				// I really hope that these 64bits integer can fit in 32 bits integer, because js
				// won't let us have more.
				if (this.uncompressedSize === MAX_VALUE_32BITS)
				{
					this.uncompressedSize = extraReader.readInt(8);
				}
				if (this.compressedSize === MAX_VALUE_32BITS)
				{
					this.compressedSize = extraReader.readInt(8);
				}
				if (this.localHeaderOffset === MAX_VALUE_32BITS)
				{
					this.localHeaderOffset = extraReader.readInt(8);
				}
				if (this.diskNumberStart === MAX_VALUE_32BITS)
				{
					this.diskNumberStart = extraReader.readInt(4);
				}
			},
			/**
			 * Read the central part of a zip file and add the info in this object.
			 * @param {StreamReader} reader the reader to use.
			 */
			readExtraFields:      function (reader)
			{
				var start = reader.index,
					extraFieldId,
					extraFieldLength,
					extraFieldValue;

				this.extraFields = this.extraFields || {};

				while (reader.index < start + this.extraFieldsLength)
				{
					extraFieldId = reader.readInt(2);
					extraFieldLength = reader.readInt(2);
					extraFieldValue = reader.readString(extraFieldLength);

					this.extraFields[extraFieldId] = {
						id:     extraFieldId,
						length: extraFieldLength,
						value:  extraFieldValue
					};
				}
			},
			/**
			 * Apply an UTF8 transformation if needed.
			 */
			handleUTF8:           function ()
			{
				if (this.useUTF8())
				{
					this.fileName = JSZip.prototype.utf8decode(this.fileName);
					this.fileComment = JSZip.prototype.utf8decode(this.fileComment);
				}
			}
		};
		// }}} end of ZipEntry

		//  class ZipEntries {{{
		/**
		 * All the entries in the zip file.
		 * @constructor
		 * @param {String|ArrayBuffer|Uint8Array} data the binary stream to load.
		 * @param {Object} loadOptions Options for loading the stream.
		 */
		function ZipEntries(data, loadOptions)
		{
			this.files = [];
			this.loadOptions = loadOptions;
			if (data)
			{
				this.load(data);
			}
		}

		ZipEntries.prototype = {
			/**
			 * Check that the reader is on the speficied signature.
			 * @param {string} expectedSignature the expected signature.
			 * @throws {Error} if it is an other signature.
			 */
			checkSignature:                    function (expectedSignature)
			{
				var signature = this.reader.readString(4);
				if (signature !== expectedSignature)
				{
					throw new Error("Corrupted zip or bug : unexpected signature " +
						"(" + pretty(signature) + ", expected " + pretty(expectedSignature) + ")");
				}
			},
			/**
			 * Read the end of the central directory.
			 */
			readBlockEndOfCentral:             function ()
			{
				this.diskNumber = this.reader.readInt(2);
				this.diskWithCentralDirStart = this.reader.readInt(2);
				this.centralDirRecordsOnThisDisk = this.reader.readInt(2);
				this.centralDirRecords = this.reader.readInt(2);
				this.centralDirSize = this.reader.readInt(4);
				this.centralDirOffset = this.reader.readInt(4);

				this.zipCommentLength = this.reader.readInt(2);
				this.zipComment = this.reader.readString(this.zipCommentLength);
			},
			/**
			 * Read the end of the Zip 64 central directory.
			 * Not merged with the method readEndOfCentral :
			 * The end of central can coexist with its Zip64 brother,
			 * I don't want to read the wrong number of bytes !
			 */
			readBlockZip64EndOfCentral:        function ()
			{
				this.zip64EndOfCentralSize = this.reader.readInt(8);
				this.versionMadeBy = this.reader.readString(2);
				this.versionNeeded = this.reader.readInt(2);
				this.diskNumber = this.reader.readInt(4);
				this.diskWithCentralDirStart = this.reader.readInt(4);
				this.centralDirRecordsOnThisDisk = this.reader.readInt(8);
				this.centralDirRecords = this.reader.readInt(8);
				this.centralDirSize = this.reader.readInt(8);
				this.centralDirOffset = this.reader.readInt(8);

				this.zip64ExtensibleData = {};
				var extraDataSize = this.zip64EndOfCentralSize - 44,
					index = 0,
					extraFieldId,
					extraFieldLength,
					extraFieldValue;
				while (index < extraDataSize)
				{
					extraFieldId = this.reader.readInt(2);
					extraFieldLength = this.reader.readInt(4);
					extraFieldValue = this.reader.readString(extraFieldLength);
					this.zip64ExtensibleData[extraFieldId] = {
						id:     extraFieldId,
						length: extraFieldLength,
						value:  extraFieldValue
					};
				}
			},
			/**
			 * Read the end of the Zip 64 central directory locator.
			 */
			readBlockZip64EndOfCentralLocator: function ()
			{
				this.diskWithZip64CentralDirStart = this.reader.readInt(4);
				this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8);
				this.disksCount = this.reader.readInt(4);
				if (this.disksCount > 1)
				{
					throw new Error("Multi-volumes zip are not supported");
				}
			},
			/**
			 * Read the local files, based on the offset read in the central part.
			 */
			readLocalFiles:                    function ()
			{
				var i, file;
				for (i = 0; i < this.files.length; i++)
				{
					file = this.files[i];
					this.reader.setIndex(file.localHeaderOffset);
					this.checkSignature(JSZip.signature.LOCAL_FILE_HEADER);
					file.readLocalPart(this.reader);
					file.handleUTF8();
				}
			},
			/**
			 * Read the central directory.
			 */
			readCentralDir:                    function ()
			{
				va