const gamepad = new Gamepad();


var btnState_ButtonLeft = false;
var btnState_ButtonRight = false;
var btnState_ButtonUp = false;
var btnState_ButtonDown = false;



//button_1 - A (XBOX) / X (PS3/PS4) DOWN
gamepad.on('press', 'button_1', e => {	
	if(e.player == 0)
	{
		simulateKeyPress("keypress", 75);
		btnState_ButtonDown = true;
	}
});
gamepad.on('hold', 'button_1', e => {
	if(e.player == 0)
	{
		simulateKeyPress("keydown", 75);
		simulateKeyPress("keydown", 90);
	}
	
});
gamepad.on('release', 'button_1', e => {
	if(e.player == 0)
	{
		btnState_ButtonDown = false;
		simulateKeyPress("keyup", 75);
		
		if(!btnState_ButtonLeft && !btnState_ButtonRight && !btnState_ButtonUp && !btnState_ButtonDown)
			simulateKeyPress("keyup", 90);
	}
});


// JUMP BUTTONS

gamepad.on('press', 'shoulder_top_left ', e => {	
	if(e.player == 0)
		simulateKeyPress("keypress", 32);
});
gamepad.on('hold', 'shoulder_top_left ', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 32);
});
gamepad.on('release', 'shoulder_top_left ', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 32);
});

gamepad.on('press', 'shoulder_top_right', e => {	
	if(e.player == 0)
		simulateKeyPress("keypress", 88);
});
gamepad.on('hold', 'shoulder_top_right', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 88);
});
gamepad.on('release', 'shoulder_top_right', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 88);
});

gamepad.on('press', 'shoulder_bottom_left ', e => {	
	if(e.player == 0)
		simulateKeyPress("keypress", 32);
});
gamepad.on('hold', 'shoulder_bottom_left ', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 32);
});
gamepad.on('release', 'shoulder_bottom_left ', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 32);
});

gamepad.on('press', 'shoulder_bottom_right', e => {	
	if(e.player == 0)
		simulateKeyPress("keypress", 88);
});
gamepad.on('hold', 'shoulder_bottom_right', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 88);
});
gamepad.on('release', 'shoulder_bottom_right', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 88);
});
//---------------------------------------------


//73); //I -> UP
//74); //J -> LEFT
//75); //K -> DOWN
//76); //L -> RIGHT


//button_2 - B (XBOX) / Circle (PS3/PS4) RIGHT
gamepad.on('press', 'button_2', e => {
	if(e.player == 0)
	{
		btnState_ButtonRight = true;
		simulateKeyPress("keypress", 76);
	}
});
gamepad.on('hold', 'button_2', e => {
	if(e.player == 0)
	{
		simulateKeyPress("keydown", 76);
		simulateKeyPress("keydown", 90);
	}
});
gamepad.on('release', 'button_2', e => {
	if(e.player == 0)
	{
		btnState_ButtonRight = false;
		simulateKeyPress("keyup", 76);
		
		if(!btnState_ButtonLeft && !btnState_ButtonRight && !btnState_ButtonUp && !btnState_ButtonDown)
			simulateKeyPress("keyup", 90);
	}
});


//button_3 - X (XBOX) / Square (PS3/PS4) LEFT
gamepad.on('press', 'button_3', e => {
	if(e.player == 0)
	{
		btnState_ButtonLeft = true;
		simulateKeyPress("keypress", 74);
	}
});
gamepad.on('hold', 'button_3', e => {
	if(e.player == 0)
	{
		simulateKeyPress("keydown", 74);
		simulateKeyPress("keydown", 90);
	}
});
gamepad.on('release', 'button_3', e => {
	if(e.player == 0)
	{
		btnState_ButtonLeft = false;
		simulateKeyPress("keyup", 74);
		
		if(!btnState_ButtonLeft && !btnState_ButtonRight && !btnState_ButtonUp && !btnState_ButtonDown)
			simulateKeyPress("keyup", 90);
	}
});	

//button_4 - Y (XBOX) / Triangle (PS3/PS4) UP
gamepad.on('press', 'button_4', e => {
	if(e.player == 0)
	{
		btnState_ButtonUp = true;
		simulateKeyPress("keypress", 73);
	}
});
gamepad.on('hold', 'button_4', e => {
	if(e.player == 0)
	{
		simulateKeyPress("keydown", 90);
		simulateKeyPress("keydown", 73);
	}
});
gamepad.on('release', 'button_4', e => {
	if(e.player == 0)
	{
		btnState_ButtonUp = false;
		simulateKeyPress("keyup", 73);
		
		if(!btnState_ButtonLeft && !btnState_ButtonRight && !btnState_ButtonUp && !btnState_ButtonDown)
			simulateKeyPress("keyup", 90);
	}
});

//start - Start (XBOX/PS3/PS4)
gamepad.on('press', 'start', e => {
    simulateKeyPress("keypress", 13);
});
gamepad.on('hold', 'start', e => {
    simulateKeyPress("keydown", 13);
});
gamepad.on('release', 'start', e => {
   simulateKeyPress("keyup", 13);
});


//select - Select (XBOX/PS3/PS4)
gamepad.on('press', 'select', e => {
    simulateKeyPress("keypress", 32);
});
gamepad.on('hold', 'select', e => {
    simulateKeyPress("keydown", 32);
});
gamepad.on('release', 'select', e => {
   simulateKeyPress("keyup", 32);
});



//d_pad_up - Up on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_up', e => {
    simulateKeyPress("keypress", 38);
});
gamepad.on('hold', 'd_pad_up', e => {
    simulateKeyPress("keydown", 38);
});
gamepad.on('release', 'd_pad_up', e => {
   simulateKeyPress("keyup", 38);
});


//d_pad_down - Down on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_down', e => {
    simulateKeyPress("keypress", 40);
});
gamepad.on('hold', 'd_pad_down', e => {
    simulateKeyPress("keydown", 40);
});
gamepad.on('release', 'd_pad_down', e => {
   simulateKeyPress("keyup", 40);
});



//d_pad_left - Left on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_left', e => {
    simulateKeyPress("keypress", 37);
});
gamepad.on('hold', 'd_pad_left', e => {
    simulateKeyPress("keydown", 37);
});
gamepad.on('release', 'd_pad_left', e => {
   simulateKeyPress("keyup", 37);
});


//d_pad_right - Right on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_right', e => {
    simulateKeyPress("keypress", 39);
});
gamepad.on('hold', 'd_pad_right', e => {
    simulateKeyPress("keydown", 39);
});
gamepad.on('release', 'd_pad_right', e => {
   simulateKeyPress("keyup", 39);
});

var btnState_AnalogLeft = false;
var btnState_AnalogRight = false;
var btnState_AnalogUp = false;
var btnState_AnalogDown = false;


gamepad.on('release', 'stick_axis_left', e => {
	simulateKeyPress("keyup", 37); //LEFT
	simulateKeyPress("keyup", 38); //UP
	simulateKeyPress("keyup", 39); //RIGHT
	simulateKeyPress("keyup", 40); //DOWN
	
	btnState_AnalogLeft = false;
	btnState_AnalogRight = false;
	btnState_AnalogUp = false;
	btnState_AnalogDown = false;
});

gamepad.on('hold', 'stick_axis_left', e => {
	
	if(e.value[0] < -0.25) //LEFT
		simulateKeyPress("keydown", 37);
	else
		simulateKeyPress("keyup", 37);
		
	if(e.value[0] > 0.25) //RIGHT
		simulateKeyPress("keydown", 39);
	else
		simulateKeyPress("keyup", 39);
		
	if(e.value[1] < -0.25) //UP
		simulateKeyPress("keydown", 38);
	else
		simulateKeyPress("keyup", 38);
		
	if(e.value[1] > 0.25) //DOWN
		simulateKeyPress("keydown", 40);
	else
		simulateKeyPress("keyup", 40);
	
	/*
	if(e.value[0] < -0.25) //LEFT
	{
		if(!btnState_AnalogLeft)
		{
			simulateKeyPress("keypress", 37);
			btnState_AnalogLeft = true;
		}
		else
		{
			simulateKeyPress("keydown", 37);
			btnState_AnalogLeft = true;
		}
	}
	else
	{
		if(btnState_AnalogLeft)
		{
			simulateKeyPress("keyup", 37);
		}
		btnState_AnalogLeft = false;
	}
	
	if(e.value[0] > 0.25) //RIGHT
	{
		if(!btnState_AnalogRight)
		{
			simulateKeyPress("keypress", 39);
			btnState_AnalogRight = true;
		}
		else
		{
			simulateKeyPress("keydown", 39);
		}
	}
	else
	{
		if(btnState_AnalogRight)
		{
			simulateKeyPress("keyup", 39);
		}
		btnState_AnalogRight = false;
	}
	
	if(e.value[1] < -0.25) //UP
	{
		if(!btnState_AnalogUp)
		{
			simulateKeyPress("keypress", 38);
			btnState_AnalogUp = true;
		}
		else
		{
			simulateKeyPress("keydown", 38);
		}
	}
	else
	{
		if(btnState_AnalogUp)
		{
			simulateKeyPress("keyup", 38);
		}
		btnState_AnalogUp = false;
	}
	
	if(e.value[1] > 0.25) //DOWN
	{
		if(!btnState_AnalogDown)
		{
			simulateKeyPress("keypress", 40);
			btnState_AnalogDown = true;
		}
		else
		{
			simulateKeyPress("keydown", 40);
		}
	}
	else
	{
		if(btnState_AnalogDown)
		{
			simulateKeyPress("keyup", 40);
		}
		btnState_AnalogDown = false;
	}
	*/
	
    //console.log(`stick_axis_left has a value of ${e.value}!`);
	
	
});





gamepad.on('release', 'stick_axis_right', e => {
	simulateKeyPress("keyup", 73); //I -> UP
	simulateKeyPress("keyup", 74); //J -> LEFT
	simulateKeyPress("keyup", 75); //K -> DOWN
	simulateKeyPress("keyup", 76); //L -> RIGHT
	
	simulateKeyPress("keyup", 90);// Z or Square
	
	btnState_AnalogLeft = false;
	btnState_AnalogRight = false;
	btnState_AnalogUp = false;
	btnState_AnalogDown = false;
});

gamepad.on('hold', 'stick_axis_right', e => {
	
	if(e.value[0] < -0.25) //LEFT
	{
		simulateKeyPress("keydown", 74);
		simulateKeyPress("keydown", 90);
	}
	else
	{
		simulateKeyPress("keyup", 74);
	}
		
	if(e.value[0] > 0.25) //RIGHT
	{
		simulateKeyPress("keydown", 76);
		simulateKeyPress("keydown", 90);
	}
	else
	{
		simulateKeyPress("keyup", 76);
	}
		
	if(e.value[1] < -0.25) //UP
	{
		simulateKeyPress("keydown", 73);
		simulateKeyPress("keydown", 90);
	}
	else
	{
		simulateKeyPress("keyup", 73);
	}
		
	if(e.value[1] > 0.25) //DOWN
	{
		simulateKeyPress("keydown", 75);
		simulateKeyPress("keydown", 90);
	}
	else
	{
		simulateKeyPress("keyup", 75);
	}
	
	
	/*
	if(e.value[0] < -0.25) //LEFT
	{
		if(!btnState_AnalogLeft)
		{
			simulateKeyPress("keypress", 37);
			btnState_AnalogLeft = true;
		}
		else
		{
			simulateKeyPress("keydown", 37);
			btnState_AnalogLeft = true;
		}
	}
	else
	{
		if(btnState_AnalogLeft)
		{
			simulateKeyPress("keyup", 37);
		}
		btnState_AnalogLeft = false;
	}
	
	if(e.value[0] > 0.25) //RIGHT
	{
		if(!btnState_AnalogRight)
		{
			simulateKeyPress("keypress", 39);
			btnState_AnalogRight = true;
		}
		else
		{
			simulateKeyPress("keydown", 39);
		}
	}
	else
	{
		if(btnState_AnalogRight)
		{
			simulateKeyPress("keyup", 39);
		}
		btnState_AnalogRight = false;
	}
	
	if(e.value[1] < -0.25) //UP
	{
		if(!btnState_AnalogUp)
		{
			simulateKeyPress("keypress", 38);
			btnState_AnalogUp = true;
		}
		else
		{
			simulateKeyPress("keydown", 38);
		}
	}
	else
	{
		if(btnState_AnalogUp)
		{
			simulateKeyPress("keyup", 38);
		}
		btnState_AnalogUp = false;
	}
	
	if(e.value[1] > 0.25) //DOWN
	{
		if(!btnState_AnalogDown)
		{
			simulateKeyPress("keypress", 40);
			btnState_AnalogDown = true;
		}
		else
		{
			simulateKeyPress("keydown", 40);
		}
	}
	else
	{
		if(btnState_AnalogDown)
		{
			simulateKeyPress("keyup", 40);
		}
		btnState_AnalogDown = false;
	}
	*/
	
    //console.log(`stick_axis_left has a value of ${e.value}!`);
	
	
});



function simulateKeyPress(eventtype, keycode) {
/*
var e = new KeyboardEvent(eventtype,
	{
		
	'altKey':false,
	'ctrlKey':true,
	'shiftKey':false,
	'metaKey':false,
	'bubbles':true,
	
	'composed':true,
	'isTrusted':true,
		
	'key':"x",
	'keyCode':120,
	'charCode':120,
	'which':120,
	
	'srcElement':document.body,
	'target':document.body,
	
	'type':eventtype
	});
*/
var e = document.createEvent('Event');
e.initEvent(eventtype, true, true);
e.keyCode = keycode;

document.dispatchEvent(e);

}

