const gamepad = new Gamepad();

//button_1 - A (XBOX) / X (PS3/PS4)
gamepad.on('press', 'button_1', e => {	
	if(e.player == 0)
		simulateKeyPress("keypress", 88);
});
gamepad.on('hold', 'button_1', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 88);
});
gamepad.on('release', 'button_1', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 88);
});


//button_2 - B (XBOX) / Circle (PS3/PS4)
gamepad.on('press', 'button_2', e => {
	if(e.player == 0)
		simulateKeyPress("keypress", 32);
});
gamepad.on('hold', 'button_2', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 32);
});
gamepad.on('release', 'button_2', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 32);
});


//button_3 - X (XBOX) / Square (PS3/PS4)
gamepad.on('press', 'button_3', e => {
	if(e.player == 0)
		simulateKeyPress("keypress", 90);
});
gamepad.on('hold', 'button_3', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 90);
});
gamepad.on('release', 'button_3', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 90);
});	

//button_4 - Y (XBOX) / Triangle (PS3/PS4)
gamepad.on('press', 'button_4', e => {
	if(e.player == 0)
		simulateKeyPress("keypress", 90);
});
gamepad.on('hold', 'button_4', e => {
	if(e.player == 0)
		simulateKeyPress("keydown", 90);
});
gamepad.on('release', 'button_4', e => {
	if(e.player == 0)
		simulateKeyPress("keyup", 90);
});

//start - Start (XBOX/PS3/PS4)
gamepad.on('press', 'start', e => {
    simulateKeyPress("keypress", 13);
});
gamepad.on('hold', 'start', e => {
    simulateKeyPress("keydown", 13);
});
gamepad.on('release', 'start', e => {
   simulateKeyPress("keyup", 13);
});

//select - Select (XBOX/PS3/PS4)
gamepad.on('press', 'select', e => {
    simulateKeyPress("keypress", 32);
});
gamepad.on('hold', 'select', e => {
    simulateKeyPress("keydown", 32);
});
gamepad.on('release', 'select', e => {
   simulateKeyPress("keyup", 32);
});


//d_pad_up - Up on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_up', e => {
    simulateKeyPress("keypress", 38);
});
gamepad.on('hold', 'd_pad_up', e => {
    simulateKeyPress("keydown", 38);
});
gamepad.on('release', 'd_pad_up', e => {
   simulateKeyPress("keyup", 38);
});


//d_pad_down - Down on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_down', e => {
    simulateKeyPress("keypress", 40);
});
gamepad.on('hold', 'd_pad_down', e => {
    simulateKeyPress("keydown", 40);
});
gamepad.on('release', 'd_pad_down', e => {
   simulateKeyPress("keyup", 40);
});



//d_pad_left - Left on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_left', e => {
    simulateKeyPress("keypress", 37);
});
gamepad.on('hold', 'd_pad_left', e => {
    simulateKeyPress("keydown", 37);
});
gamepad.on('release', 'd_pad_left', e => {
   simulateKeyPress("keyup", 37);
});


//d_pad_right - Right on the D-Pad (XBOX/PS3/PS4)
gamepad.on('press', 'd_pad_right', e => {
    simulateKeyPress("keypress", 39);
});
gamepad.on('hold', 'd_pad_right', e => {
    simulateKeyPress("keydown", 39);
});
gamepad.on('release', 'd_pad_right', e => {
   simulateKeyPress("keyup", 39);
});

	
//console.log(`stick_axis_left has a value of ${e.value}!`);



function simulateKeyPress(eventtype, keycode) {
/*
var e = new KeyboardEvent(eventtype,
	{
		
	'altKey':false,
	'ctrlKey':true,
	'shiftKey':false,
	'metaKey':false,
	'bubbles':true,
	
	'composed':true,
	'isTrusted':true,
		
	'key':"x",
	'keyCode':120,
	'charCode':120,
	'which':120,
	
	'srcElement':document.body,
	'target':document.body,
	
	'type':eventtype
	});
*/
var e = document.createEvent('Event');
e.initEvent(eventtype, true, true);
e.keyCode = keycode;

document.dispatchEvent(e);

}

