<!DOCTYPE html>

<html lang="en">

<head>
<meta http-equiv="Content-Type" name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">

<link rel="icon" type="image/png" href="vrun.png" />
<style type="text/css">
* {
    padding: 0;
    margin: 0;
  }
  
html, body {
  <?php if (isset($_GET['fullscreen'])) { echo "overflow: hidden;";}?>
}
  
body{
	background-color:black;
	background-image: url("back.png");
    background-repeat: repeat;
	margin: 0;
	padding: 0;
}
.MMFDiv{
	overflow: hidden; 
	position: relative; 
	transform: translateZ(0px); 
	box-sizing: 
	content-box; 
	display:inline-block;
	<?php if (!isset($_GET['fullscreen'])) { echo "margin-top:20px;";}?>
	
}
.MMFCanvas {
    display: block;
	//width:1024px;
	margin: 0;
	padding: 0;
	image-rendering: pixelated;
}

video {
  object-fit: fill;
}
</style>

  <title>VRUN</title>

  	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js"></script>
	<script src="howler/howler.min.js"></script>
	<script src="mespeak.js"></script>
	<script src="gamepad.js"></script>
	<script src="keyboard.js"></script>
	<script src="gamepadcode<?php 
	if (isset($_GET['joystick'])) {
        echo $_GET['joystick'];
	}
	else
	{
		echo "Mixed";
	}
	?>.js"></script>
	<script src="speakcode.js"></script>
	<script src="musiccode.js"></script>
	<script src="videocode.js"></script>
	<script src="nervecode.js"></script>
	<script src="vruncode.js"></script>
	
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-58027378-2', 'auto');
  ga('send', 'pageview');

</script>
  
<?php
echo "<script>";

$dir = 'maps';
			
$files = glob($dir . '/*.*');
$file = array_rand($files);

echo "gameValues[\"Map\"] = '" . $files[$file] . "';";

    if (isset($_GET['power'])) {
        echo "gameValues[\"Intensity\"] = " . $_GET['power'] . ";";
        echo "gameValues[\"Range\"] = " . $_GET['power'] . ";";
        echo "gameValues[\"Burst\"] = " . $_GET['power'] . ";";
        echo "gameValues[\"Speed\"] = " . $_GET['power'] . ";";
		echo "gameValues[\"Trail\"] = " . $_GET['power'] . ";";
		echo "gameValues[\"Field\"] = " . $_GET['power'] . ";";
		echo "gameValues[\"Life\"] = " . $_GET['power'] . ";";
    }
	
	 if (isset($_GET['nomusic'])) {
		 echo "gameValues[\"NoMusic\"] = true;";
	 }
	 
	 if (isset($_GET['debug'])) {
		 echo "gameValues[\"Debug\"] = 666;";
	 }
	 
	 if (isset($_GET['soundtrack'])) {
		 $ost = $_GET['soundtrack'];
		 
		if($ost == "-1")
		{
			echo "gameValues[\"NoMusic\"] = true;";
		}
		else
		{
			echo "setSoundtrack(" . $ost . ");";
		}
	 }
	 
	 $canvasBack = '';
	 
	 if (isset($_GET['backVid'])) {
		 echo "gameValues[\"backVid\"] = " . $_GET['backVid'] . ";";
		 
		 if($_GET['backVid'] == 0)
			 $canvasBack = "background-color:black;background-size: 100%;";
	 }
echo "</script>";
?>
  
  
  	<!-- EXTRASOURCES -->
	<!-- Loads the Javascript code...-->
  	<script src="src/Runtime.js"></script>

</head>


<body onload="LoadMap('text')" onresize="resize()" onzoom="resize()">

		<!-- This is where we create the Canvas element that will contain the application...-->
		<div style="display:block; width:100%; height: 100%" align="center">
			<div class="MMFDiv">
				<video id="backgroundVideo" width="398" height="224" autoplay loop="loop" class="MMFCanvas" style="position:absolute;<?php echo $canvasBack ?>">
					
				</video>
				<canvas class="MMFCanvas" id="MMFCanvas" width="398" height="224">
					<p>Your browser does not support HTML5</p>
				</canvas>   
			</div>
		</div>
    <script>
        window.rs = "src/Runtime.js";
        window.fs = "617109";
    </script>
    <script>
	    // RUNTIMESTART
	    // This is where the HTML5 runtime is actually started
	    window.addEventListener("load", windowLoaded, false);
	    function windowLoaded()
	    {
		    // Calls the runtime
		    // First parameter : name of the canvas element
		    // Second parameter : path to the cch file. Images and sounds must lay beside this file
		    new Runtime("MMFCanvas", "resources/vrun.cch");
			resize();
	    }
	    // RUNTIMESTARTEND
		
		function resize()
		{

			
			var canvas = document.getElementById("MMFCanvas");
			var videobg = document.getElementById("backgroundVideo");
			
			var width = $(window).width();
			var height = $(window).height();
			
			
			if(<?php if (isset($_GET['fullscreen'])) { echo "true";} else {echo "false";} ?>) //if fullscreen
				{
					canvas.style.width = width+"px";
					canvas.style.height = height+"px";
					
					videobg.width = parseInt($('canvas').css('width'), 10);
					videobg.height = parseInt($('canvas').css('height'), 10);
					
					return;
				}
			
			var zoom = Math.floor((height-20)/224);
			
			if (zoom<1)
				zoom = 1;
			
			var suggestedWidth = (zoom*398);
			
			if(suggestedWidth<width)
			{
				canvas.style.width = suggestedWidth+"px";
				videobg.width = parseInt($('canvas').css('width'), 10);
				videobg.height = parseInt($('canvas').css('height'), 10);
			}
			else
			{
				var vertZoom = Math.floor((width)/398);
				
				if(vertZoom<1)
					vertZoom = 1;
				
				var vertSuggestedWidth = (vertZoom*398);
				canvas.style.width = vertSuggestedWidth+"px";
				videobg.width = parseInt($('canvas').css('width'), 10);
				videobg.height = parseInt($('canvas').css('height'), 10);
			}
		}
		
		$( document ).ready(function() {
			$(window).resize(function() {
				//resize just happened, pixels changed
				resize();
			});
			resize();
		});
		
    </script>
	<center>
	<input type="text" id="restorecode" name="restorecode" style="display:none; background-color:black; border: solid 2px #666666;
    height: 22px; width:398px; font-size:12px; color:green;font-family: Consolas, monaco, monospace; vertical-align:9px; <?php if (!isset($_GET['showdebug'])) { echo "display:none;";}?>"/>
	<div id="debugpanel">
		<div id="debugnotes" style="background-color:black; border: solid 2px #666666;
		height: 224px; width:398px; font-size:12px; color:green;font-family: Consolas, monaco, monospace; vertical-align:9px; <?php if (!isset($_GET['showdebug'])) { echo "display:none;";}?>">
Debug Notes</div>
		<div id="debugload" style="display:none;">
			<textarea id="LoadMapTextArea" style="background-color:black; border: solid 2px #666666;
			height: 48px; width:398px; font-size:12px; color:green;font-family: Consolas, monaco, monospace; vertical-align:9px; display:none;">
			<?php 
		
				
			if (!isset($_GET['debug'])) {
				
				include $files[$file];
			}
			else{	
				if(file_exists('testlevel.txt'))
					include 'testlevel.txt'; 
			}
				
				
			?>
			</textarea><br/>

			<button id="LoadMapButton" style="background-color:black; border: solid 2px #666666;
			height: 22px; width:398px; font-size:12px; color:green;font-family: Consolas, monaco, monospace; vertical-align:9px" onclick="LoadMap('text')">Load test map from server</button><br/><br/>
			
			<div style="background-color:black; border: solid 2px #666666;
			height:50px;  width:398px; font-size:12px; color:green;font-family: Consolas, monaco, monospace; vertical-align:9px">
			<span style="background-color:black; height: 22px; width:256px; font-size:12px; color:green;font-family: Consolas, monaco, monospace; vertical-align:9px">Load test map from file</span> <br/>
			<input type="file" id="txtfiletoread" />
			</div>
			
		</div>
	</div>
	</center>
</body>
</html>
